#!/bin/csh
#PBS -j oe
#PBS -r n
#PBS -q romo
#PBS -W group_list=romo
#PBS -W umask=022
#PBS -A plateval

# This script assumes that the meteorology files are preprocessed and named with
# the following convention:
#
#     METCOMBO_<YYYYDDD>
#     METCOMBO_<YYYYDDD>
# (C. Allen: I don't see why we need METCOMBOs if the vars we need are already in the 2D file.)
#
# Script created by B.H. Baek, CEMPD (4/20/2010)
#
#*****************************************************************************

# Script settings
setenv PROMPTFLAG N                # Y prompts for input
setenv GRID   12US2
setenv IOAPI_GRIDNAME_1   12US2

set wdir = /garnet/home/cvy/scripts/gentpro

# Profile Methods: MET, AGNH3, RWC
setenv PROFILE_METHOD RWC

# Averaging Method
# RWC : Only works for DAILY averaging method
# AGNH3 : Only works for HOURLY averaging method
# MET : Work for all averaging methods (ALL,MONTHLY,DAILY,HOURLY)
#setenv TPRO_OUTPUT  ALL
setenv TPRO_OUTPUT  DAILY

# Determine a list of surrogates for county averaging
#setenv SRG_LIST  "311, 340"          # list of surrogates to retrieve a list of counties
setenv SRG_LIST  "340"          # list of surrogates to retrieve a list of counties
# (C. Allen: there is no surrogate 311. Don't know what that's about. 340 is what we want right?)

# List a list of SCC users would like to process 
# (C. Allen: this is a list of RWC SCCs from the existing TREF. 2104008*)
#setenv SCC_LIST  "2104008000,2104008001,2104008002,2104008003,2104008004,2104008010,2104008030,2104008050,2104008051,2104008052,2104008053,2104008060,2104008070"
setenv SCC_LIST  "2104008100,2104008200,2104008210,2104008220,2104008230,2104008300,2104008310,2104008320,2104008330,2104008400,2104008510,2104009000"
#setenv SCC_LIST  "2801700001,2805001100,2805030000,2805045000" # for ag?

setenv RWC_COUNTY_TEMP_YN Y
#setenv RWC_COUNTY_TEMP_YN N
setenv RWC_COUNTY_TEMP $wdir/RWC_county_threshold.csv
#setenv DEFAULT_TEMP_RWC 53.3
#setenv CONSTANT 47.4
setenv RWC_AZ_EQ_YN Y # use alternate RWC profile formula

# Determine a list of met variables for your profiiles
# AGNH3 profile method requires both ambient temperature and speed variable (ex: WSP10D)
# RWC profile method requires ambient temperature
# MET profile method : User can pick any single met variable for MET profiles
#setenv MET_VARS   "TEMP2,WSPD10"      # (ag) 
#setenv MET_VARS   "TEMP2"      # (RWC) 

# needed for SMOKE 3.0 but not 2.7, apparently
setenv TEMP_VAR   "TEMP2"      # (RWC) 

# Base dir
setenv BASEDIR $wdir

# executable dir
setenv SMK_BIN /garnet/oaqps/smoke/smoke3.6/Linux2_x86_64ifort

# Input files
setenv GE_DAT /garnet/oaqps/em_v6/ge_dat
if ($GRID == 36US1) then
  setenv SRGPRO_PATH /garnet/oaqps/em_v5/platform_setup/surrogates/CONUS36_2010_v4_20140404
  setenv SRGDESC $GE_DAT/srgdesc_CONUS36_2010_v4_20140404_04apr2014_v1.txt
else
  setenv SRGPRO_PATH /garnet/oaqps/em_v5/platform_setup/surrogates/CONUS12_2010_v4_20140310
  setenv SRGDESC $GE_DAT/srgdesc_CONUS12_2010_v4_20140211_11feb2014_v0.txt
endif

setenv COSTCY   $GE_DAT/costcy_for_2007platform_10may2013_v8.txt
setenv GRIDDESC $GE_DAT/griddesc_lambertonly_30apr2013_v54.txt

setenv METLIST  $BASEDIR/metlist_2011g_12US2.txt
#setenv TREF_IN  $GE_DAT/Gentpro_TREF_HOURLY_BASH_NH3_agNH3_bash_2011ea_11f_newgent_emf_txt_06sep2013_nf_v4_tref_13aug2014_v0
#setenv TREF_IN /garnet/home/cvy/scripts/gentpro/tref_rwc_in_newformat_test.txt
#setenv TREF_IN $GE_DAT/work/Gentpro_TREF_agNH3_RWC_2007ed.txt
setenv TREF_IN Gentpro_TREF_DAILY_RWC.RWC_2011vf_11f.txt

# Define the modeling period
setenv STDATE 2011001               # Starting date in Julian
setenv ENDATE 2011365               # Ending date in Julian 

##############################################################################
# Define output file name
set SENS = RWC_2011eh_11g_12US2_smk36
setenv TREF_OUT  $BASEDIR/Gentpro_TREF_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.txt
setenv TPRO_MON  $BASEDIR/Gentpro_TPRO_MON_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.txt
setenv TPRO_DAY  $BASEDIR/Gentpro_TPRO_DAY_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.txt
setenv TPRO_HOUR $BASEDIR/Gentpro_TPRO_HOUR_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.ncf
setenv LOGFILE   $BASEDIR/logs/Gentpro_TREF_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.log
mkdir -p $BASEDIR/logs

##############################################################################

rm -f $LOGFILE

$SMK_BIN/gentpro

