#!/bin/csh
#SBATCH --export=NONE
# Memory requirements: RPV needs 20 GB, RPD needs 64 GB (> 70 GB for full NATA)
#
# This script runs the Movesmrg report post-processor, which takes the daily onroad reports
# output by Movesmrg and creates a series of monthly and annual reports by state, county,
# state/SCC, and county/SCC.

# Root directory where you unzipped all .zips
setenv INSTALL_DIR "/work/EMIS/em_v7.2/for_MJOs_14_15_16"

setenv BASE_YEAR 2016
setenv GRID 12US1
setenv SECTOR onroad
setenv EMF_SPC cmaq_cb6
setenv CASE 2016fd_cb6_16j
setenv PROJECT_ROOT $INSTALL_DIR/$CASE
setenv DAYS_PER_RUN 1 # How many days were in each Movesmrg instance? If running individual days, set to 1

# Molecular weight file for converting moles to mass
setenv MW $INSTALL_DIR/smoke4.5/scripts/annual_report/parameter_file_${EMF_SPC}.txt

mkdir -p $PROJECT_ROOT/reports/annual_report

./smoke_moves2014_reports_smk40_12apr2016.py -d $DAYS_PER_RUN -r RPH -l -w $MW
./smoke_moves2014_reports_smk40_12apr2016.py -d $DAYS_PER_RUN -r RPP -l -w $MW
./smoke_moves2014_reports_smk40_12apr2016.py -d $DAYS_PER_RUN -r RPV -l -w $MW
./smoke_moves2014_reports_smk40_12apr2016.py -d $DAYS_PER_RUN -r RPD -l -w $MW

