/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.cem.correct;

import edu.unc.cem.correct.CemEvaluator;
import edu.unc.cem.util.CemEvent;
import edu.unc.cem.util.Constants;
import edu.unc.cem.util.Tokenizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Calculator {
    private int[] numDaysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int INX_HI = 0;
    private int INX_SO2 = 1;
    private int INX_NOX = 2;
    private double[] thresholds = new double[]{0.2, 0.2, 0.2};
    private Tokenizer tokenizer;
    private ConcurrentHashMap<String, String> heatInputs;
    private List<ConcurrentHashMap<String, String>> lstHeatInputMonthly;
    private ConcurrentHashMap<String, String>[] heatInputsMonthly;
    private List<ConcurrentHashMap<String, Float>> lstHiPercntMonthly;
    private ConcurrentHashMap<String, Float>[] hiPercntMonthly;
    private List<ConcurrentHashMap<String, Float>> lstNoxPercntMonthly;
    private ConcurrentHashMap<String, Float>[] noxPercntMonthly;
    private List<ConcurrentHashMap<String, Float>> lstSo2PercntMonthly;
    private ConcurrentHashMap<String, Float>[] so2PercntMonthly;
    private ConcurrentHashMap<String, Float> preSubNoxMTotal;
    private ConcurrentHashMap<String, Float> postSubNoxMTotal;
    private ConcurrentHashMap<String, Float> preSubSO2MTotal;
    private ConcurrentHashMap<String, Float> postSubSO2MTotal;
    private ConcurrentHashMap<String, Float> preSubHeatInputTotal;
    private ConcurrentHashMap<String, Float> postSubHeatInputTotal;
    private ConcurrentHashMap<String, Integer> numOfHoursSO2;
    private ConcurrentHashMap<String, Integer> numOfHoursNOX;
    private ConcurrentHashMap<String, Integer> numOfHoursHI;
    private List<String> allSrcs;
    private StringBuilder warnings = new StringBuilder();
    private int currentMonth = -1;
    private CemEvaluator eval;
    public static String NaN = "-9";
    public static String MOD_FLAG = "5";
    private Map<String, CemEvent> eventMap;
    private int numPeriodsSO2 = 1;
    private int numPeriodsNOx = 2;
    private List<ConcurrentHashMap<String, String>> periodSO2TotalEmission;
    private List<ConcurrentHashMap<String, String>> periodNOXTotalEmission;
    private List<HashMap<String, String>> periodBadHI4NOX;
    private List<HashMap<String, String>> periodBadHI4SO2;
    private List<ConcurrentHashMap<String, String>> lstSO2Monthly;
    private ConcurrentHashMap<String, String>[] SO2Monthly;
    private float[] SO2Percnt = new float[12];
    private List<ConcurrentHashMap<String, String>> lstNOXMonthly;
    private ConcurrentHashMap<String, String>[] NOXMonthly;
    private float[] NOXPercnt = new float[12];

    public Calculator(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.eval = new CemEvaluator();
        this.heatInputs = new ConcurrentHashMap();
        this.lstSO2Monthly = new ArrayList<ConcurrentHashMap<String, String>>();
        int i = 0;
        while (i < 12) {
            this.lstSO2Monthly.add(new ConcurrentHashMap());
            ++i;
        }
        this.SO2Monthly = this.lstSO2Monthly.toArray(new ConcurrentHashMap[0]);
        this.lstNOXMonthly = new ArrayList<ConcurrentHashMap<String, String>>();
        i = 0;
        while (i < 12) {
            this.lstNOXMonthly.add(new ConcurrentHashMap());
            ++i;
        }
        this.NOXMonthly = this.lstNOXMonthly.toArray(new ConcurrentHashMap[0]);
        this.lstHeatInputMonthly = new ArrayList<ConcurrentHashMap<String, String>>();
        i = 0;
        while (i < 12) {
            this.lstHeatInputMonthly.add(new ConcurrentHashMap());
            ++i;
        }
        this.heatInputsMonthly = this.lstHeatInputMonthly.toArray(new ConcurrentHashMap[0]);
        this.lstHiPercntMonthly = new ArrayList<ConcurrentHashMap<String, Float>>();
        i = 0;
        while (i < 12) {
            this.lstHiPercntMonthly.add(new ConcurrentHashMap());
            ++i;
        }
        this.hiPercntMonthly = this.lstHiPercntMonthly.toArray(new ConcurrentHashMap[0]);
        this.lstNoxPercntMonthly = new ArrayList<ConcurrentHashMap<String, Float>>();
        i = 0;
        while (i < 12) {
            this.lstNoxPercntMonthly.add(new ConcurrentHashMap());
            ++i;
        }
        this.noxPercntMonthly = this.lstNoxPercntMonthly.toArray(new ConcurrentHashMap[0]);
        this.lstSo2PercntMonthly = new ArrayList<ConcurrentHashMap<String, Float>>();
        i = 0;
        while (i < 12) {
            this.lstSo2PercntMonthly.add(new ConcurrentHashMap());
            ++i;
        }
        this.so2PercntMonthly = this.lstSo2PercntMonthly.toArray(new ConcurrentHashMap[0]);
        this.preSubNoxMTotal = new ConcurrentHashMap();
        this.postSubNoxMTotal = new ConcurrentHashMap();
        this.preSubSO2MTotal = new ConcurrentHashMap();
        this.postSubSO2MTotal = new ConcurrentHashMap();
        this.preSubHeatInputTotal = new ConcurrentHashMap();
        this.postSubHeatInputTotal = new ConcurrentHashMap();
        this.numOfHoursSO2 = new ConcurrentHashMap();
        this.numOfHoursNOX = new ConcurrentHashMap();
        this.numOfHoursHI = new ConcurrentHashMap();
        this.allSrcs = new ArrayList<String>();
        this.getThresholds();
    }

    private void getThresholds() {
        String thresholdStr = System.getenv("THRESHOLDHI");
        this.thresholds[0] = Double.parseDouble(thresholdStr);
        thresholdStr = System.getenv("THRESHOLDSO2");
        this.thresholds[1] = Double.parseDouble(thresholdStr);
        thresholdStr = System.getenv("THRESHOLDNOX");
        this.thresholds[2] = Double.parseDouble(thresholdStr);
    }

    public void addRecords(List<String> records, File file) {
        int count = 1;
        for (String record : records) {
            try {
                String[] t = this.tokenizer.tokens(record);
                if (!(!Constants.DEBUG || t[0].equals("3948") && t[1].equals("1"))) {
                    ++count;
                    continue;
                }
                String badId = String.valueOf(t[0]) + t[1] + "%%CEM_COMMA%%" + t[2] + "%%CEM_COMMA%%" + t[3];
                String srcHrId = String.valueOf(t[0]) + t[1] + t[3];
                String srcId = String.valueOf(t[0]) + t[1];
                int month = 0;
                int day = 1;
                try {
                    month = Integer.parseInt(t[2].substring(2, 4)) - 1;
                    day = Integer.parseInt(t[2].substring(4));
                }
                catch (Exception e) {
                    System.out.println("Bad date in file " + file.getName() + ": " + record);
                    System.exit(1);
                }
                if (Constants.DEBUG && month == 3 && (day == 27 || day == 28) && (t[3].equals("22") || t[3].equals("23"))) {
                    System.out.println("April " + day);
                }
                if (month == 1 && day == 29) {
                    this.numDaysInMonth[1] = 29;
                }
                CemEvent event = null;
                if (this.eventMap != null) {
                    event = this.eventMap.get(srcId);
                }
                ConcurrentHashMap<String, String> periodNOXTotalEmission = this.getPeriodNOXTotalEmission(event, month, day);
                ConcurrentHashMap<String, String> periodSO2TotalEmission = this.getPeriodSO2TotalEmission(event, month, day);
                HashMap<String, String> periodBadHINox = this.getPeriodBadHI4NOX(event, month, day);
                HashMap<String, String> periodBadHISo2 = this.getPeriodBadHI4SO2(event, month, day);
                if (periodNOXTotalEmission == null || periodSO2TotalEmission == null || periodBadHINox == null || periodBadHISo2 == null) {
                    System.out.println("Calculator was not initialized correctly - some hash maps are null!");
                    System.exit(1);
                }
                String exist = null;
                float goodHI = 0.0f;
                if (this.isGoodFloatValue(t[10]) && !this.isFlagged4Mean(t[11])) {
                    goodHI = Float.parseFloat(t[10]);
                    exist = this.heatInputs.get(srcHrId);
                    if (exist == null || exist.isEmpty()) {
                        this.heatInputs.put(srcHrId, String.valueOf(t[10]) + ",1");
                    } else {
                        this.updateValue(goodHI, srcHrId, exist, this.heatInputs);
                    }
                    exist = this.heatInputsMonthly[month].get(srcHrId);
                    if (exist == null || exist.isEmpty()) {
                        this.heatInputsMonthly[month].put(srcHrId, String.valueOf(t[10]) + ",1");
                    } else {
                        this.updateValue(goodHI, srcHrId, exist, this.heatInputsMonthly[month]);
                    }
                }
                if (this.isGoodFloatValue(t[4]) && !this.isFlagged4Mean(t[13])) {
                    exist = periodNOXTotalEmission.get(srcHrId);
                    if (goodHI == 0.0f) {
                        periodBadHINox.put(badId, String.valueOf(t[4]) + "," + t[10]);
                    } else if (exist == null || exist.isEmpty()) {
                        periodNOXTotalEmission.put(srcHrId, String.valueOf(Float.parseFloat(t[4]) / goodHI) + ",1");
                    } else {
                        this.updateValue(Float.parseFloat(t[4]) / goodHI, srcHrId, exist, periodNOXTotalEmission);
                    }
                    exist = this.NOXMonthly[month].get(srcHrId);
                    if (goodHI != 0.0f) {
                        if (exist == null || exist.isEmpty()) {
                            this.NOXMonthly[month].put(srcHrId, String.valueOf(Float.parseFloat(t[4]) / goodHI) + ",1");
                        } else {
                            this.updateValue(Float.parseFloat(t[4]) / goodHI, srcHrId, exist, this.NOXMonthly[month]);
                        }
                    }
                }
                if (this.isGoodFloatValue(t[5]) && !this.isFlagged4Mean(t[12])) {
                    exist = periodSO2TotalEmission.get(srcHrId);
                    if (goodHI == 0.0f) {
                        periodBadHISo2.put(badId, String.valueOf(t[5]) + "," + t[10]);
                    } else if (exist == null || exist.isEmpty()) {
                        periodSO2TotalEmission.put(srcHrId, String.valueOf(Float.parseFloat(t[5]) / goodHI) + ",1");
                    } else {
                        this.updateValue(Float.parseFloat(t[5]) / goodHI, srcHrId, exist, periodSO2TotalEmission);
                    }
                    exist = this.SO2Monthly[month].get(srcHrId);
                    if (goodHI != 0.0f) {
                        if (exist == null || exist.isEmpty()) {
                            this.SO2Monthly[month].put(srcHrId, String.valueOf(Float.parseFloat(t[5]) / goodHI) + ",1");
                        } else {
                            this.updateValue(Float.parseFloat(t[5]) / goodHI, srcHrId, exist, this.SO2Monthly[month]);
                        }
                    }
                }
                ++count;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Bad line in file " + file.getName() + " (" + count + "): " + record);
                System.exit(1);
            }
        }
    }

    private void updateValue(float t, String srcHrId, String exist, ConcurrentHashMap<String, String> map) {
        String[] temp = exist.split(",");
        try {
            float total = Float.parseFloat(temp[0]) + t;
            int inc = Integer.parseInt(temp[1]) + 1;
            map.replace(srcHrId, String.valueOf(total) + "," + inc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isGoodFloatValue(String t) {
        boolean good = t != null && !t.isEmpty() && !t.equals(NaN);
        try {
            Float.parseFloat(t);
        }
        catch (Exception e) {
            good = false;
        }
        return good;
    }

    private boolean isFlagged4Mean(String t) {
        if (t == null || t.isEmpty()) {
            return true;
        }
        int flag = 3;
        try {
            flag = Integer.parseInt(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag > 2;
    }

    private boolean isFlagged4Anomalous(String t) {
        if (t == null || t.isEmpty()) {
            return false;
        }
        int flag = 3;
        try {
            flag = Integer.parseInt(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag > 2;
    }

    public void calculateDayPercnt() {
        int i = 0;
        while (i < 12) {
            float numDays;
            String[] values;
            String temp;
            int j = i + 1;
            ConcurrentHashMap<String, String> map = this.heatInputsMonthly[i];
            Set keys = map.keySet();
            int nKeys = keys.size();
            for (String key : keys) {
                temp = map.get(key);
                values = temp.split(",");
                numDays = Float.parseFloat(values[1]);
                this.hiPercntMonthly[i].put(key, Float.valueOf(numDays / (float)this.numDaysInMonth[i]));
            }
            map = this.SO2Monthly[i];
            keys = map.keySet();
            nKeys = keys.size();
            for (String key : keys) {
                temp = map.get(key);
                values = temp.split(",");
                numDays = Float.parseFloat(values[1]);
                this.SO2Percnt[i] = numDays / (float)this.numDaysInMonth[i];
                this.so2PercntMonthly[i].put(key, Float.valueOf(numDays / (float)this.numDaysInMonth[i]));
            }
            map = this.NOXMonthly[i];
            keys = map.keySet();
            nKeys = keys.size();
            for (String key : keys) {
                temp = map.get(key);
                values = temp.split(",");
                numDays = Float.parseFloat(values[1]);
                this.noxPercntMonthly[i].put(key, Float.valueOf(numDays / (float)this.numDaysInMonth[i]));
            }
            if (Constants.DEBUG) {
                System.out.println("Month " + j + " NOX percent: " + this.NOXPercnt[i]);
            }
            ++i;
        }
    }

    public void calculateMeans() {
        HashMap<String, String> badMap;
        ConcurrentHashMap<String, String> map;
        this.calculateDayPercnt();
        this.calculateHeatInputMean(this.heatInputs);
        int i = 0;
        while (i < 12) {
            this.calculateHeatInputMean(this.heatInputsMonthly[i]);
            this.calculateHeatInputMean(this.SO2Monthly[i]);
            this.calculateHeatInputMean(this.NOXMonthly[i]);
            ++i;
        }
        i = 0;
        while (i < this.numPeriodsNOx) {
            map = this.periodNOXTotalEmission.get(i);
            badMap = this.periodBadHI4NOX.get(i);
            if (Constants.DEBUG) {
                System.out.println("===NOx period " + i);
                System.out.println("Map size: " + map.size());
            }
            this.calculateEmissionRate(map, this.heatInputs, badMap);
            if (Constants.DEBUG) {
                System.out.println("Map size: " + map.size());
                System.out.println("***");
            }
            ++i;
        }
        i = 0;
        while (i < this.numPeriodsSO2) {
            map = this.periodSO2TotalEmission.get(i);
            badMap = this.periodBadHI4SO2.get(i);
            if (Constants.DEBUG) {
                System.out.println("===SO2 period " + i);
            }
            this.calculateEmissionRate(map, this.heatInputs, badMap);
            ++i;
        }
        this.periodBadHI4NOX = null;
        this.periodBadHI4SO2 = null;
    }

    private void calculateHeatInputMean(ConcurrentHashMap<String, String> map) {
        Set keys = map.keySet();
        for (String key : keys) {
            String temp = map.get(key);
            String[] values = temp.split(",");
            float mean = Float.parseFloat(values[0]) / Float.parseFloat(values[1]);
            map.replace(key, String.valueOf(mean));
            if (!Constants.DEBUG) continue;
            System.out.println(String.valueOf(key) + " mean: " + mean);
        }
    }

    private void calculateEmissionRate(ConcurrentHashMap<String, String> map, ConcurrentHashMap<String, String> hi, HashMap<String, String> toBeAdded) {
        Set<String> badKeys = toBeAdded.keySet();
        for (String badkey : badKeys) {
            String exist;
            String[] subkeys = badkey.split("%%CEM_COMMA%%");
            String srcHrKey = String.valueOf(subkeys[0]) + subkeys[2];
            String[] stored = toBeAdded.get(badkey).split(",");
            String meanHI = hi.get(srcHrKey);
            float meanHIf = 0.0f;
            if (meanHI == null) {
                String msg = "Warning: average heat input cannot be calculated for source (id=" + subkeys[0] + "(ORISID+BLRID)) for hour " + subkeys[2];
                int index = Integer.parseInt(subkeys[2]);
                int prev = 0;
                int nxt = 0;
                if (index == 0) {
                    prev = 23;
                    nxt = 1;
                } else if (index == 23) {
                    prev = 22;
                    nxt = 0;
                } else {
                    prev = index - 1;
                    nxt = index + 1;
                }
                String pMeanHI = hi.get(String.valueOf(subkeys[0]) + prev);
                String nMeanHI = hi.get(String.valueOf(subkeys[0]) + nxt);
                if (pMeanHI == null && nMeanHI == null) {
                    meanHIf = Float.NaN;
                } else if (pMeanHI == null) {
                    meanHIf = Float.parseFloat(nMeanHI);
                } else if (nMeanHI == null) {
                    meanHIf = Float.parseFloat(pMeanHI);
                } else if (pMeanHI != null && nMeanHI != null) {
                    meanHIf = (Float.parseFloat(pMeanHI) + Float.parseFloat(pMeanHI)) / 2.0f;
                }
            } else {
                meanHIf = Float.parseFloat(meanHI);
            }
            float rate = 0.0f;
            float massEmis = Float.parseFloat(stored[0]);
            float badHI = Float.parseFloat(stored[1]);
            if (meanHIf != Float.NaN) {
                rate = (double)badHI > (double)meanHIf * 2.0 || stored[1].equals(NaN) || stored[1].equals("0") || stored[1].isEmpty() ? massEmis / meanHIf : massEmis / badHI;
            }
            if ((exist = map.get(srcHrKey)) == null && rate != 0.0f) {
                map.put(srcHrKey, String.valueOf(rate) + ",1");
            }
            if (exist != null && rate != 0.0f) {
                this.updateValue(rate, srcHrKey, exist, map);
            }
            if (badHI != 0.0f || !(massEmis > 0.0f)) continue;
            this.warnings.append("WARNING: CANNOT HAVE MASS EMISSION VALUES WHILE HEAT INPUT VALUE IS 0!!! Source: " + srcHrKey + "\n");
        }
        Set keys = map.keySet();
        for (String key : keys) {
            String temp = map.get(key);
            String[] values = temp.split(",");
            float mean = Float.parseFloat(values[0]) / Float.parseFloat(values[1]);
            map.replace(key, String.valueOf(mean));
            if (!Constants.DEBUG) continue;
            System.out.println(String.valueOf(key) + ": num " + values[1] + ", mean: " + mean);
        }
    }

    private void printMap(Map<String, String> map) {
        for (String key : map.keySet()) {
            System.out.println("\"" + key + "\": " + map.get(key));
        }
    }

    public List<String> processLine(String line, File infile) throws Exception {
        String so2Rate;
        String noxRate;
        ArrayList<String> toReturn = new ArrayList<String>();
        StringBuilder log = new StringBuilder();
        String[] t = this.tokenizer.tokens(line);
        boolean hiflag = this.isFlagged4Anomalous(t[11]);
        boolean so2flag = this.isFlagged4Anomalous(t[12]);
        boolean noxmassflag = this.isFlagged4Anomalous(t[13]);
        boolean noxrateflag = this.isFlagged4Anomalous(t[14]);
        if (Constants.DEBUG) {
            System.out.println(line);
        }
        String srcHrId = String.valueOf(t[0]) + t[1] + t[3];
        String srcHrInfo = String.valueOf(t[0]) + "_" + t[1] + "_" + t[3];
        String srcId = String.valueOf(t[0]) + "_" + t[1];
        String srcIdForPeriod = String.valueOf(t[0]) + t[1];
        int month = -1;
        int day = -1;
        try {
            if (this.currentMonth == -1) {
                this.currentMonth = Integer.parseInt(t[2].substring(2, 4));
            }
            day = Integer.parseInt(t[2].substring(4));
        }
        catch (Exception e) {
            throw new Exception("Bad date: " + t[2] + "in file " + infile.getName() + " : " + line);
        }
        month = this.currentMonth - 1;
        if (!this.allSrcs.contains(srcId)) {
            this.allSrcs.add(srcId);
        }
        this.addToTotals(t[4], srcId, this.preSubNoxMTotal);
        this.addToTotals(t[5], srcId, this.preSubSO2MTotal);
        this.addToTotals(t[10], srcId, this.preSubHeatInputTotal);
        String hiMean = "";
        Float exist = null;
        exist = this.hiPercntMonthly[month].get(srcHrId);
        hiMean = exist != null && (double)exist.floatValue() >= this.thresholds[this.INX_HI] ? this.heatInputsMonthly[month].get(srcHrId) : this.heatInputs.get(srcHrId);
        String repModHead = String.valueOf(srcId) + "," + t[2] + "," + t[3] + ",";
        String templog = "";
        if (Constants.DEBUG) {
            System.out.println("hiLocal: " + t[10] + " " + hiMean + "\n");
        }
        CemEvent event = null;
        if (this.eventMap != null) {
            event = this.eventMap.get(srcIdForPeriod);
        }
        if (this.periodNOXTotalEmission == null || this.periodSO2TotalEmission == null) {
            System.out.println("Calculator was not initialized correctly - some hash maps are null!");
            System.exit(1);
        }
        ConcurrentHashMap<String, String> NOXEmission = this.NOXMonthly[month];
        exist = this.noxPercntMonthly[month].get(srcHrId);
        if (exist != null && (double)exist.floatValue() < this.thresholds[this.INX_NOX]) {
            int periodNOx = CemEvent.getPeriodIndexNOx(event, month, day);
            ConcurrentHashMap<String, String> periodNOXTotalEmission = this.periodNOXTotalEmission.get(periodNOx);
            NOXEmission = periodNOXTotalEmission;
        }
        if (((noxRate = NOXEmission.get(srcHrId)) == null || Float.isInfinite(Float.parseFloat(noxRate))) && Constants.DEBUG && noxRate == null) {
            System.out.println("SrcHrId = \"" + srcHrId + "\"\nMap size: " + NOXEmission.size());
            this.printMap(NOXEmission);
        }
        ConcurrentHashMap<String, String> SO2Emission = this.SO2Monthly[month];
        exist = this.so2PercntMonthly[month].get(srcHrId);
        if (exist != null && (double)exist.floatValue() < this.thresholds[this.INX_SO2]) {
            int periodSO2 = CemEvent.getPeriodIndexSO2(event, month, day);
            ConcurrentHashMap<String, String> periodSO2TotalEmission = this.periodSO2TotalEmission.get(periodSO2);
            SO2Emission = periodSO2TotalEmission;
        }
        if (((so2Rate = SO2Emission.get(srcHrId)) == null || Float.isInfinite(Float.parseFloat(so2Rate))) && Constants.DEBUG && line.startsWith("3948,\"1\",\"070427\",21")) {
            System.out.println(line);
        }
        boolean allAnomalous = false;
        boolean hiAnomalous = false;
        boolean so2Anomalous = false;
        boolean noxAnomalous = false;
        if (this.isAnomalous(t[10], hiMean)) {
            hiAnomalous = true;
        }
        if (this.isAnomalous(t[5], so2Rate, hiMean)) {
            so2Anomalous = true;
        }
        if (this.isAnomalous(t[4], noxRate, hiMean)) {
            noxAnomalous = true;
        }
        boolean bl = allAnomalous = hiAnomalous || so2Anomalous || noxAnomalous;
        if (!(hiflag || so2flag || noxmassflag || noxrateflag)) {
            toReturn.add(String.valueOf(line) + "\n");
            if (allAnomalous) {
                String cvalue;
                if (hiAnomalous) {
                    templog = String.valueOf(templog) + repModHead + "HTINPUT,Keep," + t[11] + "," + t[10] + "," + t[10] + "," + hiMean + "\n";
                }
                if (so2Anomalous) {
                    cvalue = this.typicalValue(so2Rate, hiMean).toString();
                    templog = String.valueOf(templog) + repModHead + "SO2MASS,Keep," + t[12] + "," + t[5] + "," + t[5] + "," + cvalue + "\n";
                }
                if (noxAnomalous) {
                    cvalue = this.typicalValue(noxRate, hiMean).toString();
                    templog = String.valueOf(templog) + repModHead + "NOXMASS,Keep," + t[13] + "," + t[4] + "," + t[4] + "," + cvalue + "\n";
                }
                toReturn.add(templog);
            } else {
                toReturn.add(null);
            }
            this.addToTotals(t[10], srcId, this.postSubHeatInputTotal);
            this.addToTotals(t[5], srcId, this.postSubSO2MTotal);
            this.addToTotals(t[4], srcId, this.postSubNoxMTotal);
            return toReturn;
        }
        String t10orig = t[10];
        if (allAnomalous && t[10] != null && this.isAnomalous(t[10], hiMean)) {
            t[10] = hiMean;
            templog = String.valueOf(repModHead) + "HTINPUT,Corrected," + t[11] + "," + t10orig + "," + t[10] + "," + hiMean + "\n";
            t[11] = MOD_FLAG;
            this.incrementCount(srcId, this.numOfHoursHI);
        }
        this.addToTotals(t[10], srcId, this.postSubHeatInputTotal);
        String t5orig = t[5];
        if (allAnomalous && t[5] != null && this.typicalValue(so2Rate, hiMean) != null && this.isAnomalous(t[5], so2Rate, hiMean)) {
            t[5] = this.typicalValue(so2Rate, hiMean).toString();
            templog = String.valueOf(templog) + repModHead + "SO2MASS,Corrected," + t[12] + "," + t5orig + "," + t[5] + "," + t[5] + "\n";
            t[12] = MOD_FLAG;
            this.incrementCount(srcId, this.numOfHoursSO2);
        }
        this.addToTotals(t[5], srcId, this.postSubSO2MTotal);
        String t4orig = t[4];
        if (allAnomalous && t[4] != null && this.typicalValue(noxRate, hiMean) != null && this.isAnomalous(t[4], noxRate, hiMean)) {
            t[4] = this.typicalValue(noxRate, hiMean).toString();
            templog = String.valueOf(templog) + repModHead + "NOXMASS,Corrected," + t[13] + "," + t4orig + "," + t[4] + "," + t[4] + "\n";
            t[13] = MOD_FLAG;
            this.incrementCount(srcId, this.numOfHoursNOX);
        }
        this.addToTotals(t[4], srcId, this.postSubNoxMTotal);
        String t6orig = t[6];
        if (templog.length() > repModHead.length()) {
            log.append(templog);
        }
        toReturn.add(String.valueOf(t[0]) + ",\"" + t[1] + "\",\"" + t[2] + "\"," + t[3] + "," + t[4] + "," + t[5] + "," + t[6] + "," + t[7] + "," + t[8] + "," + t[9] + "," + t[10] + "," + t[11] + "," + t[12] + "," + t[13] + "," + t[14] + "," + t[15] + "\n");
        toReturn.add(log.toString());
        return toReturn;
    }

    private void addToTotals(String t, String srcId, ConcurrentHashMap<String, Float> totals) {
        if (t == null || t.isEmpty()) {
            return;
        }
        Float value = totals.get(srcId);
        if (value == null && !t.equals(NaN)) {
            totals.put(srcId, Float.valueOf(t));
        } else if (value != null && !t.equals(NaN)) {
            totals.replace(srcId, Float.valueOf(Float.parseFloat(t) + value.floatValue()));
        }
    }

    private void incrementCount(String srcId, ConcurrentHashMap<String, Integer> totals) {
        Integer value = totals.get(srcId);
        if (value == null) {
            totals.put(srcId, new Integer(1));
        } else if (value != null) {
            totals.replace(srcId, value + 1);
        }
    }

    private boolean isAnomalous(String field, String normal) {
        Float value = null;
        try {
            value = Float.valueOf(field);
        }
        catch (Exception e) {
            return false;
        }
        if (field.equals(NaN) || value.floatValue() < 0.0f) {
            return false;
        }
        if (normal == null || normal.trim().isEmpty()) {
            return false;
        }
        Float normVal = Float.valueOf(normal);
        return this.eval.compare(value, normVal) > 0;
    }

    private boolean isAnomalous(String field, String rate, String hi) {
        Float value = null;
        try {
            value = Float.valueOf(field);
        }
        catch (Exception e) {
            return false;
        }
        if (field.equals(NaN) || value.floatValue() < 0.0f) {
            return false;
        }
        Float normVal = this.typicalValue(rate, hi);
        if (normVal == null) {
            return false;
        }
        return this.eval.compare(value, normVal) > 0;
    }

    private Float typicalValue(String rate, String hi) {
        if (rate == null || rate.isEmpty() || hi == null || hi.isEmpty()) {
            return null;
        }
        try {
            float frate = Float.parseFloat(rate);
            float fhi = Float.parseFloat(hi);
            return new Float(frate * fhi);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void clearTotals() {
        this.preSubNoxMTotal.clear();
        this.postSubNoxMTotal.clear();
        this.preSubSO2MTotal.clear();
        this.postSubSO2MTotal.clear();
        this.preSubHeatInputTotal.clear();
        this.postSubHeatInputTotal.clear();
        this.currentMonth = -1;
        this.numOfHoursSO2.clear();
        this.numOfHoursNOX.clear();
        this.numOfHoursHI.clear();
    }

    public List<String> getTotals() {
        ArrayList<String> totals = new ArrayList<String>();
        for (String id : this.allSrcs) {
            Float preSubNoxTotal = this.preSubNoxMTotal.get(id);
            Float postSubNoxTotal = this.postSubNoxMTotal.get(id);
            Float preSubSO2Total = this.preSubSO2MTotal.get(id);
            Float postSubSO2Total = this.postSubSO2MTotal.get(id);
            Float preSubHITotal = this.preSubHeatInputTotal.get(id);
            Float postSubHITotal = this.postSubHeatInputTotal.get(id);
            Integer totalNOXHours = this.numOfHoursNOX.get(id);
            Integer totalSO2Hours = this.numOfHoursSO2.get(id);
            Integer totalHIHours = this.numOfHoursHI.get(id);
            totals.add(String.valueOf(id) + "," + this.currentMonth + "," + this.convert2String(preSubNoxTotal) + "," + this.convert2String(postSubNoxTotal) + "," + this.convertDiff2String(preSubNoxTotal, postSubNoxTotal) + "," + this.convert2String(totalNOXHours) + "," + this.convert2String(preSubSO2Total) + "," + this.convert2String(postSubSO2Total) + "," + this.convertDiff2String(preSubSO2Total, postSubSO2Total) + "," + this.convert2String(totalSO2Hours) + "," + this.convert2String(preSubHITotal) + "," + this.convert2String(postSubHITotal) + "," + this.convertDiff2String(preSubHITotal, postSubHITotal) + "," + this.convert2String(totalHIHours) + "\n");
        }
        return totals;
    }

    private String convert2String(Object num) {
        if (num == null) {
            return "0";
        }
        return num.toString();
    }

    private String convertDiff2String(Float num1, Float num2) {
        if (num1 == null && num2 == null) {
            return "0.0";
        }
        if (num1 == null && num2 != null) {
            return String.valueOf(-num2.floatValue());
        }
        if (num1 != null && num2 == null) {
            return num1.toString();
        }
        return String.valueOf(num1.floatValue() - num2.floatValue());
    }

    public String getWarnings() {
        return this.warnings.toString();
    }

    public void clearMemory() {
        this.tokenizer = null;
        this.periodNOXTotalEmission = null;
        this.periodSO2TotalEmission = null;
        this.heatInputs = null;
        this.periodBadHI4NOX = null;
        this.periodBadHI4SO2 = null;
        this.eval = null;
        this.preSubNoxMTotal = null;
        this.postSubNoxMTotal = null;
        this.preSubSO2MTotal = null;
        this.postSubSO2MTotal = null;
        this.preSubHeatInputTotal = null;
        this.postSubHeatInputTotal = null;
    }

    public void setEventMap(Map<String, CemEvent> eventMap) throws Exception {
        this.eventMap = eventMap;
        this.calculatePeriods();
        this.init();
    }

    public Map<String, CemEvent> getEventMap() {
        return this.eventMap;
    }

    private void calculatePeriods() throws Exception {
        if (this.eventMap == null) {
            return;
        }
        Collection<CemEvent> eventSet = this.eventMap.values();
        int numSO2 = 1;
        int numNOx = 2;
        for (CemEvent event : eventSet) {
            numSO2 = CemEvent.getNumPeriodsSO2(event);
            numNOx = CemEvent.getNumPeriodsNOx(event);
            if (numSO2 > this.numPeriodsSO2) {
                this.numPeriodsSO2 = numSO2;
            }
            if (numNOx <= this.numPeriodsNOx) continue;
            this.numPeriodsNOx = numNOx;
        }
    }

    private void init() {
        this.periodNOXTotalEmission = new ArrayList<ConcurrentHashMap<String, String>>();
        this.periodSO2TotalEmission = new ArrayList<ConcurrentHashMap<String, String>>();
        this.periodBadHI4NOX = new ArrayList<HashMap<String, String>>();
        this.periodBadHI4SO2 = new ArrayList<HashMap<String, String>>();
        int i = 0;
        while (i < this.numPeriodsNOx) {
            this.periodNOXTotalEmission.add(new ConcurrentHashMap());
            this.periodBadHI4NOX.add(new HashMap());
            ++i;
        }
        i = 0;
        while (i < this.numPeriodsSO2) {
            this.periodSO2TotalEmission.add(new ConcurrentHashMap());
            this.periodBadHI4SO2.add(new HashMap());
            ++i;
        }
    }

    private ConcurrentHashMap<String, String> getPeriodNOXTotalEmission(CemEvent event, int month, int day) throws Exception {
        if (this.periodNOXTotalEmission == null) {
            throw new Exception("Please initialize the Calculator first!");
        }
        int index = CemEvent.getPeriodIndexNOx(event, month, day);
        return this.periodNOXTotalEmission.get(index);
    }

    private ConcurrentHashMap<String, String> getPeriodSO2TotalEmission(CemEvent event, int month, int day) throws Exception {
        if (this.periodSO2TotalEmission == null) {
            throw new Exception("Please initialize the Calculator first!");
        }
        int index = CemEvent.getPeriodIndexSO2(event, month, day);
        return this.periodSO2TotalEmission.get(index);
    }

    private HashMap<String, String> getPeriodBadHI4NOX(CemEvent event, int month, int day) throws Exception {
        if (this.periodBadHI4NOX == null) {
            throw new Exception("Please initialize the Calculator first!");
        }
        int index = CemEvent.getPeriodIndexNOx(event, month, day);
        return this.periodBadHI4NOX.get(index);
    }

    private HashMap<String, String> getPeriodBadHI4SO2(CemEvent event, int month, int day) throws Exception {
        if (this.periodBadHI4SO2 == null) {
            throw new Exception("Please initialize the Calculator first!");
        }
        int index = CemEvent.getPeriodIndexSO2(event, month, day);
        return this.periodBadHI4SO2.get(index);
    }

    public static void main(String[] args) {
    }
}

