/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.cem.correct;

import edu.unc.cem.correct.Calculator;
import edu.unc.cem.util.Constants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class CemWriter {
    private File input;
    private File output;
    private File summary;
    private File log;
    private File modRep;
    private BufferedWriter writer;
    private BufferedWriter reporter;
    private BufferedWriter logger;
    private BufferedWriter modReporter;

    public CemWriter(File input, File output, File log, File sum, File modRep) {
        this.input = input;
        this.output = output;
        this.summary = sum;
        this.log = log;
        this.modRep = modRep;
    }

    public void write(Calculator calc) throws IOException {
        File logdir;
        File outdir = this.output.getParentFile();
        if (!outdir.exists()) {
            outdir.mkdirs();
        }
        if (!(logdir = this.log.getParentFile()).exists()) {
            logdir.mkdir();
        }
        boolean reportExists = this.summary.exists();
        boolean repModExists = this.modRep.exists();
        BufferedReader reader = new BufferedReader(new FileReader(this.input));
        this.writer = new BufferedWriter(new FileWriter(this.output));
        this.reporter = new BufferedWriter(new FileWriter(this.summary, true));
        this.logger = new BufferedWriter(new FileWriter(this.log, true));
        this.modReporter = new BufferedWriter(new FileWriter(this.modRep, true));
        List<String> processed = null;
        String line = null;
        long count = 1L;
        try {
            calc.clearTotals();
            String wrn = calc.getWarnings();
            if (wrn != null && !wrn.isEmpty()) {
                this.logger.append(wrn);
            }
            if (!repModExists) {
                this.modReporter.write("# Type: 1. Measured, 2. calculated, 3. substituted, 4. measured/sub\n");
                this.modReporter.write("Source,YYMMDD,Hour,Pollutant,Action,Type,Original(lb/hr mmBtu),Corrected,Mean\n");
            }
            while ((line = reader.readLine()) != null) {
                if (Constants.DEBUG && !line.startsWith("3948,\"1\",")) continue;
                processed = calc.processLine(line, this.input);
                String toOut = processed.get(0);
                String toLog = processed.get(1);
                this.writer.write(toOut);
                if (toLog != null && !toLog.isEmpty()) {
                    this.modReporter.append(toLog);
                }
                ++count;
            }
            List<String> totals = calc.getTotals();
            if (!reportExists) {
                this.reporter.write("Source,Month,NOX Mass Total (pre-substitution) (lb/hr),NOX Mass Total (post-substitution) (lb/hr),NOX Mass Total Difference (lb/hr),Number of Hours Substituted,SO2 Mass Total (pre-substitution) (lb/hr),SO2 Mass Total (post-substitution) (lb/hr),SO2 Mass Total Difference (lb/hr),Number of Hours Substituted,Heat Input Total (pre-substitution) (mmBtu),Heat Input Total (post-substitution) (mmBtu),Heat Input Total Difference (mmBtu),Number of Hours Substituted\n");
            }
            for (String total : totals) {
                this.reporter.append(total);
            }
        }
        catch (Exception e) {
            System.out.println("Error reading line " + count + "(" + this.input.getName() + "): " + line);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void close() throws IOException {
        this.writer.close();
        this.reporter.close();
        this.logger.close();
        this.modReporter.close();
    }

    public void finalize() {
        this.writer = null;
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

