/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.cem.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DelimitedTokenizer {
    private Pattern p;

    public DelimitedTokenizer(String pattern) {
        this.p = Pattern.compile(pattern);
    }

    public String[] doTokenize(String input) {
        Matcher m = this.p.matcher(input);
        ArrayList<String> tokens = new ArrayList<String>();
        while (m.find()) {
            String token = input.substring(m.start(), m.end()).trim();
            if (token.length() == input.trim().length()) {
                return new String[]{token};
            }
            if (token.startsWith("\"")) {
                tokens.add(this.startWithDoubleQuote(input, m, token));
                continue;
            }
            if (token.startsWith("'")) {
                tokens.add(this.startWithSingleQuote(input, m, token));
                continue;
            }
            tokens.add(token);
        }
        return tokens.toArray(new String[0]);
    }

    private String startWithDoubleQuote(String input, Matcher m, String token) {
        return this.startWithQuote("\"", input, m, token);
    }

    private String startWithSingleQuote(String input, Matcher m, String token) {
        return this.startWithQuote("'", input, m, token);
    }

    private String startWithQuote(String quote, String input, Matcher m, String token) {
        int start = m.start();
        while (!token.endsWith(quote) && m.find()) {
            token = input.substring(m.start(), m.end()).trim();
        }
        token = input.substring(start, m.end()).trim();
        return token.substring(1, token.length() - 1);
    }
}

