/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.cem.util;

import edu.unc.cem.correct.Calculator;
import edu.unc.cem.util.CemEvent;
import edu.unc.cem.util.CommaDelimitedTokenizer;
import edu.unc.cem.util.DateUtil;
import edu.unc.cem.util.SemicolonDelimitedTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PropertiesManager {
    private String configFile;
    private boolean loaded = false;

    public PropertiesManager(String file) {
        this.configFile = file;
    }

    private void loadProperties() {
        if (this.loaded) {
            return;
        }
        try {
            File file;
            if (this.configFile == null || this.configFile.trim().isEmpty()) {
                System.out.println("Configuration file is not specified.");
            }
            if ((file = new File(this.configFile)).exists()) {
                System.getProperties().load(new FileInputStream(file));
            } else {
                System.out.println("Configuration file \"" + this.configFile + "\" doesn't exist!");
            }
            this.loaded = true;
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getLocalizedMessage());
        }
    }

    public String getProperty(String key) {
        if (!this.loaded) {
            this.loadProperties();
        }
        return System.getProperty(key);
    }

    public Map<String, CemEvent> parseEvent(String events) throws Exception {
        HashMap<String, CemEvent> eventMap = null;
        if (events != null && events.trim().length() != 0) {
            SemicolonDelimitedTokenizer tokenizer = new SemicolonDelimitedTokenizer();
            CommaDelimitedTokenizer tokenizer2 = new CommaDelimitedTokenizer();
            try {
                String[] ts;
                String[] stringArray = ts = tokenizer.tokens(events);
                int n = ts.length;
                int n2 = 0;
                while (n2 < n) {
                    int day;
                    int month;
                    int year;
                    String t = stringArray[n2];
                    String[] ts2 = tokenizer2.tokens(t);
                    String key = String.valueOf(ts2[0].trim()) + ts2[1].trim();
                    if (ts2[2] == null) {
                        throw new Exception("Invalid start date in event: " + t);
                    }
                    String startDate = ts2[2].trim();
                    if (startDate == null || startDate.length() != 6) {
                        throw new Exception("Invalid start date in event: " + t);
                    }
                    try {
                        year = Integer.parseInt(startDate.substring(0, 2));
                    }
                    catch (Exception e) {
                        throw new Exception("Invalid start year in event: " + t);
                    }
                    if (!DateUtil.checkYear(year)) {
                        throw new Exception("Invalid start year in event: " + t);
                    }
                    year = year < 30 ? (year += 100) : (year += 0);
                    try {
                        month = Integer.parseInt(startDate.substring(2, 4));
                    }
                    catch (Exception e) {
                        throw new Exception("Invalid start month in event: " + t);
                    }
                    if (!DateUtil.checkMonth(month)) {
                        throw new Exception("Invalid start month in event: " + t);
                    }
                    try {
                        day = Integer.parseInt(startDate.substring(4));
                    }
                    catch (Exception e) {
                        throw new Exception("Invalid start day in event: " + t);
                    }
                    if (!DateUtil.checkDay(month, day)) {
                        throw new Exception("Invalid start day in event: " + t);
                    }
                    Date start = new Date(year, month - 1, day);
                    Date end = null;
                    if (ts2[3] != null && !ts2[3].trim().equals("")) {
                        String endDate = ts2[3].trim();
                        if (endDate.length() != 6) {
                            throw new Exception("Invalid end date in event: " + t);
                        }
                        try {
                            year = Integer.parseInt(endDate.substring(0, 2));
                        }
                        catch (Exception e) {
                            throw new Exception("Invalid end year in event: " + t);
                        }
                        if (!DateUtil.checkYear(year)) {
                            throw new Exception("Invalid end year in event: " + t);
                        }
                        year = year < 30 ? (year += 100) : (year += 0);
                        try {
                            month = Integer.parseInt(endDate.substring(2, 4));
                        }
                        catch (Exception e) {
                            throw new Exception("Invalid end month in event: " + t);
                        }
                        if (!DateUtil.checkMonth(month)) {
                            throw new Exception("Invalid end month in event: " + t);
                        }
                        try {
                            day = Integer.parseInt(endDate.substring(4));
                        }
                        catch (Exception e) {
                            throw new Exception("Invalid end day in event: " + t);
                        }
                        if (!DateUtil.checkDay(month, day)) {
                            throw new Exception("Invalid end day in event: " + t);
                        }
                        end = new Date(year, month - 1, day);
                    }
                    if (eventMap == null) {
                        eventMap = new HashMap<String, CemEvent>();
                    }
                    eventMap.put(key, new CemEvent(start, end));
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return eventMap;
    }

    public void printEventMap(Map<String, CemEvent> eventMap) {
        if (eventMap == null) {
            return;
        }
        Set<Map.Entry<String, CemEvent>> eventSet = eventMap.entrySet();
        for (Map.Entry<String, CemEvent> en : eventSet) {
            System.out.println(String.valueOf(en.getKey()) + ": " + en.getValue().getStart().toLocaleString() + " " + (en.getValue().getEnd() == null ? "" : en.getValue().getEnd().toLocaleString()));
        }
    }

    public static void main(String[] args) {
        PropertiesManager pMan = new PropertiesManager("/Users/jizhen/Documents/workspace/cem_tools/cem_tools/config/config.test");
        String events = pMan.getProperty("events");
        Map<String, CemEvent> eventMap = null;
        try {
            eventMap = pMan.parseEvent(events);
            pMan.printEventMap(eventMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Calculator cal = new Calculator(null);
        try {
            cal.setEventMap(eventMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

