#!/bin/csh
#SBATCH export=NONE

# Define the modeling period. STDATE should be the last day of the previous year,
# and ENDATE should be the last day of the base year.
setenv STDATE 2017365               # Starting date in Julian
setenv ENDATE 2018365               # Ending date in Julian 

setenv PROMPTFLAG N                # Y prompts for input
setenv GRID   12US1 # grid name for filename labeling
setenv IOAPI_GRIDNAME_1   12US1_459X299 # grid name as listed in GRIDDESC

# Label for output filenames
set SENS = agNH3_bash_2018_${GRID}

# Profile Methods: MET, AGNH3, RWC. For ag, leave these alone.
setenv PROFILE_METHOD BASH_NH3
setenv TPRO_OUTPUT  HOURLY

# Determine a list of surrogates for county averaging. Generally should be left alone unless you want to use a different surrogate for averaging cells to counties.
setenv SRG_LIST  "340"          

# List a list of SCC users would like to process 
# This affects the temporal xref output by Gentpro. Unless you want to change the SCCs that receive temperature-based temporal profiles
# in the ag sector, we recommend you ignore the temporal xref that is output by SMOKE and instead use the ag temporal xref that is provided in whichever 
# modeling platform you are using. Note that this SCC_LIST does not include all ag SCCs which receive Gentpro profiles. When running Gentpro, unless
# we need to create a new ATREF, we run Gentpro with an abbreviated SCC_LIST to help Gentpro run faster.
setenv SCC_LIST "2805002000,2805003100,2805007100,2805007300" # for ag, testing only

# leave these variables alone for ag
setenv TEMP_VAR   "TEMPG"
setenv AERO_RESISTANCE_VAR "RADYNI"

setenv BASEDIR $cwd

setenv SMK_BIN $cwd

setenv GE_DAT $cwd/ge_dat

# This package contains the land area surrogate (340) for the 12km CONUS domain from the 2017 emissions modeling platform.
# Your domain does not have to match the surrogate domain exactly, as long as your resolution and map projection are the same. 
# Surrogates for other domains and resolutions can also be used, but EPA standard practice is to run Gentpro with 12km resolution data.
# EPA standard practice is also to use 12km-based temporal profiles for finer resolution domains, although Gentpro can also be run
# for finer resolutions.
# If you are using a 2014 or 2016 case, since the FIPS codes have changed over time,
# use the land area surrogate and COSTCY from that platform instead of the ones from 2017 platform.
setenv SRGPRO_PATH $GE_DAT # Location of spatial surrogate (just need the single surrogate listed in SRG_LIST)
setenv SRGDESC $GE_DAT/srgdesc_CONUS12_2017NEI_17dec2019_29apr2020_v1.txt # Surrogate descriptions file which lists the filename for the spatial surrogates

setenv COSTCY   $GE_DAT/costcy_for_2017platform_20aug2020_v1.txt # State and county names and FIPS codes, included in this package
setenv GRIDDESC $GE_DAT/griddesc_lambertonly_29may2019_nf_v9.txt # grid description file, included in this package

# This package contains a sample METLIST file. Edit this file to point to your daily METCRO2D (MCIP) files.
# You should also include the last day of the previous year, and the first two days of the next year, in this file.
# If METCRO2D files are not available for those dates, create them by running m3tshift (I/O API utility, a.k.a. m3tools)
# on the first or last day of met data that you do have.
setenv METLIST  metlist_2018j_12US1.txt

# Temporal xref for input to Gentpro. In general you should not need to change this.
setenv TREF_IN $GE_DAT/amptref_general_2011platform_tref_6nov2014_14may2015_v6


##############################################################################
# Define output file name
setenv TREF_OUT  $BASEDIR/Gentpro_TREF_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.txt
setenv TPRO_MON  $BASEDIR/Gentpro_TPRO_MON_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.txt
setenv TPRO_DAY  $BASEDIR/Gentpro_TPRO_DAY_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.txt
setenv TPRO_HOUR $BASEDIR/Gentpro_TPRO_HOUR_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.ncf
setenv LOGFILE   $BASEDIR/logs/Gentpro_TREF_${TPRO_OUTPUT}_${PROFILE_METHOD}.${SENS}.log
mkdir -p $BASEDIR/logs

##############################################################################

rm -f $LOGFILE

# The "gentpro_v37" executable included in this package is from SMOKE v3.7.
# As of 11/24/21, the Gentpro executable from SMOKE v4.X does not work for ag due to the 
# formatting of FIPS codes. This is a known bug and will be fixed in the future.
$SMK_BIN/gentpro_v37

