#!/bin/csh -f
#SBATCH --export=NONE

limit stacksize unlimited

setenv SECTOR "mrggrid"

if ($?SLURM_SUBMIT_DIR) then
  cd $SLURM_SUBMIT_DIR
endif

## Definitions for case name, directory structures, etc, that are used
#  by every sector in the case
#  Anything defined in directory_definitions can be overridden here 
#  if desired
source ../directory_definitions.csh

setenv PYTHONPATH /work/EMIS/users/bte/local/lib/python3.6/site-packages

## Months for emissions processing, and spinup duration
#  In the EPA emissions modeling platforms, the only sectors that use
#    SPINUP_DURATION are biogenics and the final sector merge (Mrggrid).
#  Elsewhere, SPINUP_DURATION = 0, and when Mrggrid runs for spinup days,
#    base year emissions are used for the spinup year for all sectors except
#    biogenics.
#  Effective Jan 2019, SPINUP_DURATION now should work for all months.
#  SPINUP_MONTH_END (new for Jan 2019) specifies whether the last $SPINUP_DURATION 
#    days of quarter 2/3/4 should be run at the end of a quarter (Y), or at the start 
#    of the next quarter (N). For example, if runningwith SPINUP_DURATION = 10:
#    When N (old behavior), Q1 will include 10 day spinup and end on 3/21; Q2 will
#    cover 3/22 through 6/20. When Y, Q1 will include 10 day spinup and end on 3/31
#    (including all of March), remaining quarters will function as if spinup = 0.
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"
setenv SPINUP_MONTH_END "Y"

## Emissions modeling year
#  (i.e. meteorological year, not necessarily the inventory year"
setenv BASE_YEAR "2018"
setenv EPI_STDATE_TIME "${BASE_YEAR}-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "${BASE_YEAR}-12-31 23:59:00.0"

## Inventory case name, if inventories are coming from a different case (they usually aren't)
#  CASEINPUTS is defined in directory_definitions and optionally overridden here
#setenv INVENTORY_CASE "2011ek_cb6v2_v6_11g"
#setenv CASEINPUTS "$INSTALL_DIR/$INVENTORY_CASE/inputs"

## Inputs for all sectors
setenv SECTORLIST "$CASESCRIPTS/sectorlist_2032gg"
setenv MRGDATE_FILES "$INSTALL_DIR/smoke4.8.1/scripts/smk_dates/2018/smk_merge_dates_201801.txt"

# Inputs specific to this sector

# Parameters for all sectors
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv PLATFORM "v8.1"
setenv SPC "$EMF_SPC"

# Sector-specific parameters
setenv OCL2ROOT "$INSTALL_DIR/ocean_cl2/cl2_"
setenv EXT ".ncf"
setenv GZIP_OUTPUTS "N"

$RUNSCRIPTS/emf/smk_sectormerge_emf.csh $REGION_ABBREV -m "$RUN_MONTHS" $SPINUP_DURATION all
