#!/bin/csh -f
#SBATCH --export=NONE

limit stacksize unlimited

setenv SECTOR "ptegu_winter"

if ($?SLURM_SUBMIT_DIR) then
  cd $SLURM_SUBMIT_DIR
endif

## Definitions for case name, directory structures, etc, that are used
#  by every sector in the case
#  Anything defined in directory_definitions can be overridden here
#  if desired
source ../directory_definitions.csh

## Months for emissions processing, and spinup duration
#  In the EPA emissions modeling platforms, the only sectors that use
#    SPINUP_DURATION are biogenics and the final sector merge (Mrggrid).
#  Elsewhere, SPINUP_DURATION = 0, and when Mrggrid runs for spinup days,
#    base year emissions are used for the spinup year for all sectors except
#    biogenics.
#  Effective Jan 2019, SPINUP_DURATION now should work for all months.
#  SPINUP_MONTH_END (new for Jan 2019) specifies whether the last $SPINUP_DURATION
#    days of quarter 2/3/4 should be run at the end of a quarter (Y), or at the start
#    of the next quarter (N). For example, if runningwith SPINUP_DURATION = 10:
#    When N (old behavior), Q1 will include 10 day spinup and end on 3/21; Q2 will
#    cover 3/22 through 6/20. When Y, Q1 will include 10 day spinup and end on 3/31
#    (including all of March), remaining quarters will function as if spinup = 0.
setenv RUN_MONTHS "1 2 12"
setenv SPINUP_DURATION "0"
setenv SPINUP_MONTH_END "Y"

## Emissions modeling year
#  (i.e. meteorological year, not necessarily the inventory year"
setenv BASE_YEAR "2018"
setenv EPI_STDATE_TIME "${BASE_YEAR}-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "${BASE_YEAR}-12-31 23:59:00.0"

## Inventory case name, if inventories are coming from a different case (they usually aren't)
#  CASEINPUTS is defined in directory_definitions and optionally overridden here
#setenv INVENTORY_CASE "2011ek_cb6v2_v6_11g"
#setenv CASEINPUTS "$INSTALL_DIR/$INVENTORY_CASE/inputs"


## Inputs for all sectors
setenv GRIDDESC "${GE_DAT}/gridding/griddesc_lambertonly_18jan2019_v7.txt"
setenv COSTCY "${GE_DAT}/costcy_for_2017platform_20aug2020_v1.txt"
#setenv INVTABLE "${GE_DAT}/invtable_2014platform_integrate_21dec2018_v3.txt"
setenv SCCDESC "${GE_DAT}/smkreport/sccdesc_2014platform_13dec2019_v3.txt"
setenv ATREF "${GE_DAT}/temporal/amptref_general_2017platform_18apr2022_v7"
setenv SRGDESC "${GE_DAT}/gridding/srgdesc_CONUS12_2017NEI_17dec2019_13may2021_v3.txt"
setenv ARTOPNT "${GE_DAT}/artopnt_2002detroit_20aug2019_v2.txt"
setenv HOLIDAYS "${GE_DAT}/temporal/holidays_01feb2021_v3.txt"
setenv GSCNV "${GE_DAT}/speciation/gscnv_Create_CB6R3AE7_Spec_5_2_full_26oct2022_v2.txt"
setenv PELVCONFIG "${GE_DAT}/point/pelvconfig_elevate_everything_17apr2020_v0.txt"
setenv ORISDESC "${GE_DAT}/smkreport/orisdesc_04dec2006_v0.txt"
setenv PSTK "${GE_DAT}/point/pstk_13nov2018_v1.txt"
setenv AGREF "${GE_DAT}/gridding/agref_us_2017platform_25oct2022_v14.txt"
#setenv PTREF "${GE_DAT}/temporal/amptref_general_2017platform_20oct2022_v10"
setenv MTREF "${GE_DAT}/temporal/mtref_onroad_MOVES3_2017NEI_08nov2021_v2"
setenv NAICSDESC "${GE_DAT}/smkreport/naicsdesc_02jan2008_v0.txt"
setenv MRGDATE_FILES "${INSTALL_DIR}/smoke4.8.1/scripts/smk_dates/2018/smk_merge_dates_201712.txt"
setenv SRGPRO "${GE_DAT}/gridding/surrogates/CONUS12_2017NEI_04mar2021/USA_100_NOFILL.txt"
setenv EFTABLES "${CASEINPUTS}/onroad/eftables/rateperdistance_smoke_aq_cb6_saprc_20210217_2016v3-2032-20220901_27035_1.csv"
setenv MTPRO_MONTHLY "${GE_DAT}/temporal/mtpro_monthly_MOVES_03aug2016_v1"
setenv ATPRO_MONTHLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_12oct2021_v9"
setenv ATPRO_WEEKLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
setenv ATPRO_HOURLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_18apr2022_v11"
#setenv PTPRO_WEEKLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
#setenv PTPRO_MONTHLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_12oct2021_v9"
#setenv PTPRO_HOURLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_18apr2022_v11"
setenv MTPRO_WEEKLY "${GE_DAT}/temporal/mtpro_weekly_MOVES_2014v2_25feb2021_nf_v3"
setenv MTPRO_HOURLY "${GE_DAT}/temporal/mtpro_hourly_MOVES_2014v2_25feb2021_nf_v3"
setenv ATPRO_HOURLY_NCF "${GE_DAT}/temporal/Gentpro_TPRO_HOUR_HOURLY_BASH_NH3.agNH3_bash_2018gc_18j_12US1_smk37_newFIPS.ncf"
setenv PTPRO_DAILY "${GE_DAT}/temporal/noncem_2032_2018_winter_tpro_daily_csv_14sep2022_v0"


## Inputs specific to this sector and/or job
#setenv REPCONFIG_INV "${GE_DAT}/smkreport/repconfig/repconfig_area_inv_2016beta_07feb2019_v0.txt"
#setenv REPCONFIG_GRID "${GE_DAT}/smkreport/repconfig/repconfig_area_inv_grid_2016beta_07feb2019_v0.txt"
setenv INVTABLE "${GE_DAT}/invtable_2014platform_nointegrate_07dec2018_v1.txt"
setenv REPCONFIG_INV "${GE_DAT}/smkreport/repconfig/repconfig_point_inv_2016beta_07feb2019_v0.txt"
setenv REPCONFIG_TEMP "${GE_DAT}/smkreport/repconfig/repconfig_point_temporal_2016beta_07feb2019_v0.txt"
setenv PTREF "${GE_DAT}/temporal/noncem_2032gg2_2018_winter_tref_winter_csv_17apr2023_v0"
setenv EMISINV_A "${CASEINPUTS}/ptegu_winter/egucems_epa621_2032_20230327_winter_17apr2023_v0.csv"
setenv EMISHOUR_MULTI_A "${CASEINPUTS}/cem/HOUR_UNIT_2017_12_31dec_2032_adj_final.txt"
setenv REPCONFIG_GRID "${GE_DAT}/smkreport/repconfig/repconfig_point_invgrid_2011platform_11aug2014_v0.txt"
setenv CEMSUM "${CASEINPUTS}/cem/cemsum_2032_3_14_2018_final_v3_winter.txt"
setenv PTPRO_WEEKLY "${GE_DAT}/temporal/noncem_2032_2018_winter_tpro_weekly_csv_14sep2022_v0"
setenv PTPRO_MONTHLY "${GE_DAT}/temporal/noncem_2032_2018_winter_tpro_monthly_csv_14sep2022_v0"
setenv PTPRO_HOURLY "${GE_DAT}/temporal/noncem_2032_2018_winter_tpro_hourly_winter_csv_14sep2022_v0"
setenv REPCONFIG_INV3 "${GE_DAT}/smkreport/repconfig/repconfig_point_inv_vocprof_2016beta_07feb2019_v0.txt"
setenv EMISINV_B "${CASEINPUTS}/ptegu_winter/egunoncems_epa621_2032_20230327_winter_17apr2023_v0.csv"
setenv GSREFTMP_A "${GE_DAT}/speciation/gsref_ptegu_winter_cmaq_cb6ae7_2032gg2_18j_11oct2022.txt"
setenv GSPROTMP_A "${GE_DAT}/speciation/gspro_ptegu_winter_cmaq_cb6ae7_2032gg2_18j_01may2019.txt"


## Parameters for all sectors
setenv PLATFORM "v8.1" ## Platform name
setenv SPC "$EMF_SPC" ## Speciation type name
setenv FILL_ANNUAL "N" ## Fill annual values
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5" ## Formula for Smkinven
setenv SMK_DEFAULT_SRGID "100" ## Default surrogate code
setenv REPORT_DEFAULTS "Y" ## Report default profiles used
setenv SMK_AVEDAY_YN "N" ## Use average day emissions
setenv SMK_MAXWARNING "10" ## Maximum warnings printed
setenv SMK_MAXERROR "10000" ## Maximum errors printed
#setenv FULLSCC_ONLY "Y" ## Match full SCCs
setenv RUN_HOLIDAYS "Y" ## Run holidays
#setenv L_TYPE "mwdss" ## Temporal type
#setenv M_TYPE "mwdss" ## Merge type
setenv RAW_DUP_CHECK "N" ## Check for duplicate sources
setenv SMK_SPECELEV_YN "Y" ## Laypoint uses Elevpoint to set sources for plume rise calc
setenv SMK_PING_METHOD "0" ## Plume-in-grid method
#setenv INLINE_MODE "only" ## Run in "inline" mode
setenv RUN_PYTHON_ANNUAL "Y" ## Run script for Smkmerge annual totals
setenv NO_SPC_ZERO_EMIS "Y" ## Don't speciate zero emission SCCs
setenv MTMP_OUTPUT_YN "N" ## Generate MTMP_INV files
setenv DEFAULT_CONV_FAC_ERROR "Y" ## Error if profile missing from GSCNV
setenv OUTPUT_FORMAT "$EMF_AQM" ## Model output format
setenv SMKMERGE_CUSTOM_OUTPUT "Y" ## Custom merge output
setenv MRG_REPSTA_YN "N" ## Output state totals
setenv IOAPI_ISPH "20" ## I/O API Sphere type
setenv POLLUTANT_CONVERSION "Y" ## Use pollutant conversion
setenv RENORM_TPROF "Y" ## Renormalize temporal profiles
setenv OUTZONE "0" ## Output time zone
setenv MRG_REPCNY_YN "Y" ## Output county totals
setenv WEST_HSPHERE "Y" ## Western hemisphere?
setenv MRG_MARKETPEN_YN "N" ## Include market penetration
setenv WRITE_ANN_ZERO "Y" ## Write zero emissions
setenv DAY_SPECIFIC_YN "N" ## Use day-specific emission
setenv HOUR_SPECIFIC_YN "Y" ## Use hour-specific emission
setenv NAMEBREAK_HOURLY "4" ## Count of underscores for Hourly data prefix
setenv ZIPOUT "Y" ## Zip POUT and INLN output files
setenv SORT_LIST_EVS "Y" ## Sort inventory EVs by letter
setenv USE_FF10_DAILY_POINT "N" ## Using FF10 Daily Point inventory?


## Parameters specific to this sector and/or job
setenv FULLSCC_ONLY "N" ## Match full SCCs
setenv L_TYPE "all" ## Temporal type
setenv M_TYPE "all" ## Merge type
setenv INLINE_MODE "only" ## Run in "inline" mode (elevate everything)

$RUNSCRIPTS/emf/smk_pt_annual_onetime_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME onetime
