#!/bin/csh -f
#SBATCH --export=NONE

limit stacksize unlimited

setenv SECTOR "canada_og2D"

if ($?SLURM_SUBMIT_DIR) then
  cd $SLURM_SUBMIT_DIR
endif

## Definitions for case name, directory structures, etc, that are used
#  by every sector in the case
#  Anything defined in directory_definitions can be overridden here
#  if desired
source ../directory_definitions.csh

## Months for emissions processing, and spinup duration
#  In the EPA emissions modeling platforms, the only sectors that use
#    SPINUP_DURATION are biogenics and the final sector merge (Mrggrid).
#  Elsewhere, SPINUP_DURATION = 0, and when Mrggrid runs for spinup days,
#    base year emissions are used for the spinup year for all sectors except
#    biogenics.
#  Effective Jan 2019, SPINUP_DURATION now should work for all months.
#  SPINUP_MONTH_END (new for Jan 2019) specifies whether the last $SPINUP_DURATION
#    days of quarter 2/3/4 should be run at the end of a quarter (Y), or at the start
#    of the next quarter (N). For example, if runningwith SPINUP_DURATION = 10:
#    When N (old behavior), Q1 will include 10 day spinup and end on 3/21; Q2 will
#    cover 3/22 through 6/20. When Y, Q1 will include 10 day spinup and end on 3/31
#    (including all of March), remaining quarters will function as if spinup = 0.
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"
setenv SPINUP_MONTH_END "Y"

## Emissions modeling year
#  (i.e. meteorological year, not necessarily the inventory year"
setenv BASE_YEAR "2019"
setenv EPI_STDATE_TIME "${BASE_YEAR}-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "${BASE_YEAR}-12-31 23:59:00.0"

## Inventory case name, if inventories are coming from a different case (they usually aren't)
#  CASEINPUTS is defined in directory_definitions and optionally overridden here
#setenv INVENTORY_CASE "2011ek_cb6v2_v6_11g"
#setenv CASEINPUTS "$INSTALL_DIR/$INVENTORY_CASE/inputs"


## Inputs for all sectors
setenv SECTORLIST "${CASESCRIPTS}/sectorlist_2019ge"
setenv COSTCY "${GE_DAT}/costcy_for_2017platform_07dec2021_nf_v5.txt"
setenv PTREF "${GE_DAT}/temporal/amptref_general_2017platform_21feb2022_nf_v7"
setenv GSCNV "${GE_DAT}/speciation/gscnv_Create_CB6R3AE7_Spec_5_2_full_06dec2021_nf_v1.txt"
setenv MRGDATE_FILES "${INSTALL_DIR}/smoke4.8.1/scripts/smk_dates/2019/smk_merge_dates_201812.txt"
setenv ATPRO_HOURLY_NCF "${GE_DAT}/temporal/Gentpro_TPRO_HOUR_HOURLY_BASH_NH3.agNH3_bash_19k_12US1_smk37_2017FIPS.ncf"
setenv MTPRO_HOURLY "${GE_DAT}/temporal/mtpro_hourly_MOVES_2014v2_25feb2021_nf_v3"
setenv MTPRO_WEEKLY "${GE_DAT}/temporal/mtpro_weekly_MOVES_2014v2_25feb2021_nf_v3"
setenv PTPRO_HOURLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_13dec2021_nf_v11"
setenv PTPRO_MONTHLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_12oct2021_v9"
setenv PTPRO_WEEKLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
setenv ATPRO_HOURLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_13dec2021_nf_v11"
setenv ATPRO_WEEKLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
setenv ATPRO_MONTHLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_12oct2021_v9"
setenv MTPRO_MONTHLY "${GE_DAT}/temporal/mtpro_monthly_MOVES_03aug2016_v1"
setenv EFTABLES "${CASEINPUTS}/onroad/eftables/rateperdistance_smoke_nata_20210219_2019-20211020_10003_1.csv"
setenv SRGPRO "${GE_DAT}/gridding/surrogates/CONUS12_2017NEI_04mar2021/USA_100_NOFILL.txt"
setenv NAICSDESC "${GE_DAT}/smkreport/naicsdesc_20220222_22feb2022_v0.txt"
setenv MTREF "${GE_DAT}/temporal/mtref_onroad_MOVES3_2017NEI_08nov2021_v2"
setenv AGREF "${GE_DAT}/gridding/agref_us_2017platform_13jan2022_nf_v12.txt"
setenv PSTK "${GE_DAT}/point/pstk_13nov2018_v1.txt"
setenv ORISDESC "${GE_DAT}/smkreport/orisdesc_04dec2006_v0.txt"
setenv PELVCONFIG "${GE_DAT}/point/pelvconfig_elevate_everything_17apr2020_v0.txt"
setenv HOLIDAYS "${GE_DAT}/temporal/holidays_01feb2021_v3.txt"
setenv ARTOPNT "${GE_DAT}/artopnt_2002detroit_20aug2019_v2.txt"
setenv SRGDESC "${GE_DAT}/gridding/srgdesc_CONUS12_2017NEI_17dec2019_13may2021_v3.txt"
setenv ATREF "${GE_DAT}/temporal/amptref_general_2017platform_21feb2022_nf_v7"
setenv SCCDESC "${GE_DAT}/smkreport/sccdesc_2014platform_13jan2022_nf_v6.txt"
setenv GRIDDESC "${GE_DAT}/gridding/griddesc_lambertonly_18jan2019_v7.txt"


## Inputs specific to this sector and/or job
setenv REPCONFIG_GRID "${GE_DAT}/smkreport/repconfig/repconfig_area_inv_grid_2016beta_15nov2021_nf_v2.txt"
setenv REPCONFIG_INV "${GE_DAT}/smkreport/repconfig/repconfig_area_inv_2016beta_15nov2021_nf_v3.txt"
setenv REPCONFIG_INV2 "${GE_DAT}/smkreport/repconfig/repconfig_point_inv_vocprof_2016beta_15nov2021_nf_v1.txt"
setenv REPCONFIG_INV "${GE_DAT}/smkreport/repconfig/repconfig_point_inv_2016beta_15nov2021_nf_v2.txt"
setenv REPCONFIG_GRID "${GE_DAT}/smkreport/repconfig/repconfig_point_invgrid_2011platform_11aug2014_v0.txt"
setenv PTREF "${GE_DAT}/temporal/amptref_Canada_2015_27oct2020_nf_v5"
setenv PTPRO_WEEKLY "${GE_DAT}/temporal/amptpro_Canada_2010_tpro_weekly_05jan2015_v1"
setenv PTPRO_MONTHLY "${GE_DAT}/temporal/amptpro_Canada_2010_tpro_monthly_28nov2018_nf_v2"
setenv PTPRO_HOURLY "${GE_DAT}/temporal/amptpro_Canada_2010_tpro_hourly_05jan2015_v1"
setenv INVTABLE "${GE_DAT}/invtable_2014platform_nointegrate_07dec2018_v1.txt"
setenv EMISINV_O "${CASEINPUTS}/canada_og2D/canada_MYR_2016_point_UOG_15jun2021_nf_v1.csv"
setenv GSREFTMP_A "${GE_DAT}/speciation/gsref_canada_og2D_cmaq_cb6ae7_2016fj_16j_nf.txt"
setenv GSPROTMP_A "${GE_DAT}/speciation/gspro_canada_og2D_cmaq_cb6ae7_2016fj_16j_01may2019.txt"


## Parameters for all sectors
setenv SPC "$EMF_SPC"
setenv PLATFORM "v8.1"
setenv WRF_VERSION "4"
setenv NO_SPC_ZERO_EMIS "Y"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "only"
setenv SMK_PING_METHOD "0"
setenv SMK_SPECELEV_YN "Y"
setenv RAW_DUP_CHECK "N"
setenv M_TYPE "mwdss"
setenv L_TYPE "mwdss"
setenv RUN_HOLIDAYS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_MAXERROR "10000"
setenv SMK_MAXWARNING "10"
setenv SMK_AVEDAY_YN "N"
setenv REPORT_DEFAULTS "Y"
setenv SMK_DEFAULT_SRGID "100"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv FILL_ANNUAL "N"
setenv MRG_MARKETPEN_YN "N"
setenv WEST_HSPHERE "Y"
setenv MRG_REPCNY_YN "Y"
setenv OUTZONE "0"
setenv RENORM_TPROF "Y"
setenv POLLUTANT_CONVERSION "Y"
setenv IOAPI_ISPH "20"
setenv MRG_REPSTA_YN "N"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv SORT_LIST_EVS "Y"
setenv SMK_ELEV_METHOD "0"
setenv MRG_BYDAY "P"
setenv MRG_LAYERS_YN "N"


## Parameters specific to this sector and/or job
setenv SMK_SPECELEV_YN "N"
setenv RUN_HOLIDAYS "N"
setenv M_TYPE "mwdss"
setenv INLINE_MODE "off"
setenv FILL_ANNUAL "Y"

$RUNSCRIPTS/emf/smk_pt_monthly_onetime_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -m "$RUN_MONTHS" $SPINUP_DURATION onetime
