#!/bin/tcsh
#SBATCH --export=NONE

limit stacksize unlimited

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
source /work/romo/share/EMFClient/EmfCmdClientEnv.atmos.csh
setenv EMF_JAVACMDLINE "$JAVA_EXE -DUSER_PREFERENCES=$PREF_FILE -DEMF_HOME=$EMF_HOME -classpath $CLASSPATH gov.epa.emissions.framework.client.EMFCmdClient $TOMCAT_SERVER/emf/services  -r 3"
setenv EMF_CLIENT /work/romo/share/EMFClient/EMFCmdClient.py

## Job run file for job: Othptdust_adjustment

## EMF specific variables
setenv EMF_JOBID "153174"
setenv EMF_JOBNAME "Othptdust_adjustment"
setenv EMF_USER "callen05"
setenv EMF_SCRIPTDIR "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/scripts"
setenv EMF_SCRIPTNAME "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/scripts/Othptdust_adjustment_canada_ptdust_12US1_2021hb_cb6_21k_20240104152636.csh"
setenv EMF_LOGNAME "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/scripts/logs/Othptdust_adjustment_canada_ptdust_12US1_2021hb_cb6_21k_20240104152636.log"
setenv EMF_JOBKEY "153174_1704399996719"

## Inputs -- for all regions, all sectors and all jobs
setenv GRIDDESC "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/gridding/griddesc_lambertonly_18jan2019_v7.txt" ## Grid Description List
setenv COSTCY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/costcy_for_2017platform_20dec2023_v8.txt" ## Country, State, County Information
setenv INVTABLE "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/invtable_2017_NATA_CMAQ_26apr2023_v7.txt" ## Inventory Table - NBAFM integration
setenv SCCDESC "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/smkreport/sccdesc_2021platform_04jan2024_nf_v1.txt" ## SCC descriptions
setenv ATREF "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptref_general_2017platform_01aug2023_nf_v14" ## Temporal xref, all nonpoint and nonroad
setenv SRGDESC "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/gridding/srgdesc_CONUS12_2020NEI_03mar2023_27mar2023_nf_v1.txt" ## surrogate descriptions (works for all grids)
setenv ARTOPNT "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/artopnt_2002detroit_20aug2019_v2.txt" ## Area-to-point data
setenv HOLIDAYS "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/holidays_19dec2023_v5.txt" ## Holidays table
setenv PELVCONFIG "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/point/pelvconfig_elevate_everything_17apr2020_v0.txt" ## Elevation Configuration File for Point Sources
setenv ORISDESC "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/smkreport/orisdesc_04dec2006_v0.txt" ## ORIS Description
setenv PSTK "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/point/pstk_13nov2018_v1.txt" ## Stack replacement
setenv AGREF "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/gridding/agref_us_2020platform_06nov2023_nf_v5.txt" ## nonpoint & nonroad surrogate xref
setenv REPCONFIG_INV "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/smkreport/repconfig/repconfig_area_inv_2016beta_15nov2021_nf_v3.txt" ## Report configuration, nonpoint default inventory
setenv PTREF "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptref_general_2017platform_01aug2023_nf_v14" ## Temporal xref, point default. 
setenv MTREF "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2017NEI_03sep2020_v1" ## Temporal xref, onroad mobile default
setenv NAICSDESC "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/smkreport/naicsdesc_20220222_22feb2022_v0.txt" ## NAICS descriptions
setenv REPCONFIG_GRID "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/smkreport/repconfig/repconfig_area_inv_grid_2016beta_15nov2021_nf_v2.txt" ## Report configuration, nonpoint default gridded
setenv GSPROTMP_A  "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_static_cmaq_21feb2012_v13.txt" ## Speciation profiles static
setenv GSPROTMP_C  "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_PM2_5_AE6_Spec_5_2_S2S_20221213_15dec2022_v0.txt" ## Speciation profiles for PM2.5
setenv GSPROTMP_B  "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_sulf_29jun2007_v1.txt" ## Speciation profiles for SO2-SULF
setenv GSPROTMP_D  "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_CB6R3_AE7_nointegrate_Spec_5_3_S2S_20230911_01nov2023_nf_v1.txt" ## Speciation profiles for TOG
setenv GSREFTMP_A "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_static_cap_pf4_2014v1_platform_23jan2017_v0.txt" ## Speciation xref  CAP  static  
setenv GSREFTMP_C "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_static_nox_hono_pf4_2014v1_platform_10nov2023_nf_v4.txt" ## Speciation xref static NOX --  HONO for mobile sources
setenv GSREFTMP_B "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_sulf__2014v1_platform_23jan2017_v0.txt" ## Speciation xref for SO2-SULF
setenv GSREFTMP_E "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_pm25_2018_2021_platforms_10nov2023_nf_v11.txt" ## Speciation xref for PM2.5
setenv GSPROTMP_E "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_CB6R3_AE7_integrate_Spec_5_3_S2S_20230911_01nov2023_v1.txt" ## Speciation profiles for NONHAPTOG
setenv SECTORLIST "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/mrggrid/sectorlist_2020ha2_30may2023_v0" ## List of sectors for mrggrid
setenv GSPROTMP_I "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_speciated_voc_cb6cmaq_21jul2017_v1.txt" ## Speciation profiles speciated VOC
setenv GSPROTMP_G "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_nox_hono_pf4_06aug2008_v0.txt" ## Speciation profiles for NOX
setenv GSPROTMP_F "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_haps_2014v1_cb6cmaq_11oct2016_v0.txt" ## Speciation profiles for HAPS except metals, PAHs
setenv GSREFTMP_F "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_voc_2018_2021_platforms_10nov2023_nf_v11.txt" ## Speciation xref for VOC
setenv GSREFTMP_K "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_alaska_onroad_26sep2017_nf_v2.txt" ## Speciation xref for Alaska onroad
setenv GSPROTMP_M "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_NMOG_HAPs_only_22dec2022_v1.txt" ## Speciation profiles for NMOG
setenv SRGPRO "/work/EMIS/em_v9/ge_dat/gridding/surrogates/CONUS12_2020NEI_25may2023/USA_100_NOFILL.txt" ## Gridding surrogates USA 12km
setenv EFTABLES "/work/EMIS/em_v9/MOVES_EF/rates-2021-20231108-post/output/hapcap/rateperdistance_smoke_nata_20220825_rates-2021-20231108_10003_1.csv" ## MOVES Emission Factor Tables
setenv GSPROTMP_E1 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_CB6R3_AE7_integrate_tracer_Spec_5_3_S2S_20230911_01nov2023_v0.txt" ## Speciation profiles for NONHAPTOG - SOAALK tracer
setenv GSPROTMP_X1 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_hapmetals_05dec2017_nf_v2.txt" ## Speciation profiles Metals (other than Chromium)
setenv GSPROTMP_X2 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_chromium_05dec2017_nf_v2.txt" ## Speciation profiles CHROMIUM
setenv GSREFTMP_X1 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_metals_chromium_stationary_2014v1_platform_17jan2017_v0.txt" ## Speciation xref for Metals, including Chromium
setenv GSPROTMP_X3 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_hg_2017platform_16apr2020_nf_v1.txt" ## Speciation profiles Mercury
setenv GSPROTMP_X4 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_pahs_2014v1_nata_02apr2020_nf_v1.txt" ## Speciation profiles PAHs
setenv GSREFTMP_X4 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_dieselpm_2014v1_platform_15apr2020_nf_v2.txt" ## Speciation xref for Diesel PM
setenv GSPROTMP_X5 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_diesel_pm_2014v1_nata_21oct2016_nf_v1.txt" ## Speciation profiles DIESEL PM
setenv GSREFTMP_X5 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_hg_2017platform_10mar2023_nf_v4.txt" ## Speciation xref for Mercury
setenv MTPRO_MONTHLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_28nov2018_v8" ## Monthly Temporal profiles, all mobile
setenv ATPRO_MONTHLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_25may2023_nf_v12" ## Temporal profiles monthly nonpoint
setenv ATPRO_WEEKLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2" ## Temporal profiles weekly nonpoint
setenv ATPRO_HOURLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_18apr2022_v11" ## Temporal profiles diurnal nonpoint
setenv PTPRO_WEEKLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2" ## Temporal profiles weekly point
setenv PTPRO_MONTHLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_25may2023_nf_v12" ## Temporal profiles monthly point
setenv PTPRO_HOURLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_18apr2022_v11" ## Temporal profiles diurnal point
setenv ATPRO_HOURLY_NCF "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/work/livestock/Gentpro_TPRO_HOUR_HOURLY_BASH_NH3.agNH3_bash_2021hb_12US1.ncf" ## Hour specific ag temporal profile
setenv GSPROTMP_D1 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gspro_CB6R3_AE7_criteria_tracer_Spec_5_3_S2S_20230911_01nov2023_v1.txt" ## Speciation profiles for TOG - SOAALK tracer (no PRIMARYs from TOG)
setenv GSREFTMP_H1 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_nonhapvoc_2021hb_oilgas_basin_specific_ramboll_10nov2023_v0.txt" ## Speciation xref for NONHAPVOC - basin-specific oil/gas
setenv GSREFTMP_F1 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_voc_2021hb_oilgas_basin_specific_ramboll_10nov2023_v0.txt" ## Speciation xref for VOC - basin-specific oil/gas
setenv GSREFTMP_H2 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_nonhapvoc_2021hb_oilgas_combo_ERG_10nov2023_v0.txt" ## Speciation xref for NONHAPVOC - oil/gas COMBO
setenv GSREFTMP_F2 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_voc_2021hb_oilgas_combo_ERG_10nov2023_v0.txt" ## Speciation xref for VOC - oil/gas COMBO
setenv GSREFTMP_X1A "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_minnesota_metals_05dec2017_v0.txt" ## Speciation xref for Metals, including Chromium - Minnesota special
setenv GSREFTMP_X5B "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_hg_2017platform_geothermal_06apr2020_v0.txt" ## Speciation xref for Mercury - geothermal
setenv GSREF_SUMMER "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_nostarts_summer_16nov2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - summer
setenv GSREF_WINTER "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_nostarts_winter_16nov2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - winter
setenv GSREF_STARTS_1 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m1_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 1
setenv GSREF_STARTS_2 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m2_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 2
setenv GSREF_STARTS_4 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m4_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 4
setenv GSREF_STARTS_3 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m3_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 3
setenv GSREF_STARTS_5 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m5_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 5
setenv GSREF_STARTS_6 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m6_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 6
setenv GSREF_STARTS_7 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m7_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 7
setenv GSREF_STARTS_8 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m8_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 8
setenv GSREF_STARTS_9 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m9_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 9
setenv GSREF_STARTS_10 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m10_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 10
setenv GSREF_STARTS_12 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m12_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 12
setenv MRGDATE_FILES "/work/EMIS/em_v6.3/ge_dat/smk_dates/2021/smk_merge_dates_202012.txt" ## Smkmerge representative dates files
setenv GSREF_STARTS_11 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/gsref_MOVES4_custom_speciation_2021hb_all_starts_m11_31oct2023_v0.txt" ## GSREF for custom SMOKE-MOVES speciation - starts 11
setenv GSCNV "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gscnv_SPECIATE_5_3_fromS2S_20230911_01nov2023_v0.txt" ## GSCNV - pollutant to pollutant conversions
setenv GSREFTMP_H "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/speciation/spec_parts/gsref_nonhapvoc_2018_2021_platforms_10nov2023_nf_v9.txt" ## Speciation xref for NONHAPVOC

## Inputs -- region (Continental US 12km (12US1)) and all sectors and all jobs
setenv MTPRO_WEEKLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtpro_weekly_onroad_MOVES_2021hb_06nov2023_nf_v1" ## Weekly Temporal profiles, all mobile
setenv MTPRO_HOURLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtpro_hourly_onroad_MOVES_2021hb_06nov2023_v0" ## Hourly Temporal profiles, all mobile
setenv MTREF_1 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month1_16nov2023_nf_v1" ## Temporal xref, onroad mobile January
setenv MTREF_12 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month12_16nov2023_nf_v1" ## Temporal xref, onroad mobile Dec
setenv MTREF_5 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month5_16nov2023_nf_v1" ## Temporal xref, onroad mobile May
setenv MTREF_9 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month9_16nov2023_nf_v1" ## Temporal xref, onroad mobile Sep
setenv MTREF_2 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month2_16nov2023_nf_v1" ## Temporal xref, onroad mobile Feb
setenv MTREF_3 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month3_16nov2023_nf_v1" ## Temporal xref, onroad mobile Mar
setenv MTREF_4 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month4_16nov2023_nf_v1" ## Temporal xref, onroad mobile Apr
setenv MTREF_6 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month6_16nov2023_nf_v1" ## Temporal xref, onroad mobile Jun
setenv MTREF_10 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month10_16nov2023_nf_v1" ## Temporal xref, onroad mobile Oct
setenv MTREF_11 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month11_16nov2023_nf_v1" ## Temporal xref, onroad mobile Nov
setenv MTREF_8 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month8_16nov2023_nf_v1" ## Temporal xref, onroad mobile Aug
setenv MTREF_7 "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/mtref_onroad_MOVES_2021hb_month7_16nov2023_nf_v1" ## Temporal xref, onroad mobile Jul

## Inputs -- all regions and  sector (canada_ptdust) and all jobs
setenv REPCONFIG_INV "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/smkreport/repconfig/repconfig_point_inv_2016beta_13nov2023_v2.txt" ## Report configuration, othpt inventory
setenv PTREF "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptref_Canada_2015_31mar2023_nf_v6" ## Temporal xref, othpt
setenv EMISINV_E "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/canada_ptdust/canada_BAU19_2021interp_I041_point_dust_monthly_02jan2024_v0.csv" ## Point Inventory - Canada Point road dust
setenv REPCONFIG_GRID "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/smkreport/repconfig/repconfig_point_invgrid_2011platform_11aug2014_v0.txt" ## Report configuration, othpt gridded
setenv PTPRO_WEEKLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptpro_Canada_2010_tpro_weekly_05jan2015_v1" ## Temporal weekly profiles, Can/Mex
setenv PTPRO_MONTHLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptpro_Canada_2010_tpro_monthly_28nov2018_nf_v2" ## Temporal monthly profiles, Can/Mex
setenv PTPRO_HOURLY "/work/EMIS/em_v9/hapcap/2021hb_cb6_21k/inputs/../../../ge_dat/temporal/amptpro_Canada_2010_tpro_hourly_05jan2015_v1" ## Temporal diurnal profiles, Can/Mex

## Inputs -- region (Continental US 12km (12US1)) and  sector (canada_ptdust) and all jobs
setenv XPORTFRAC "/work/EMIS/users/cvy/scripts/afdust_xportfrac/gridcro2d/xportfrac.12US1.GRIDCRO2D.ncf" ## Afdust xportfrac

## Inputs -- all regions and  all sector and job (Othptdust adjustment (canada_ptdust, 12US1))

## Inputs -- region (Continental US 12km (12US1)) and  all sectors and job (Othptdust adjustment (canada_ptdust, 12US1))

## Inputs -- all regions and  sector (canada_ptdust) and job (Othptdust adjustment)

## Inputs -- region (Continental US 12km (12US1)) and  sector (canada_ptdust) and job (Othptdust adjustment)

## Parameters -- from Case summary 
setenv CASE "2021hb_cb6_21k"
setenv MODEL_LABEL "SMOKE5.0"
setenv EMF_AQM "CMAQ v5.2"
setenv EMF_SPC "cmaq_cb6ae7"
setenv BASE_YEAR "2021"
setenv FUTURE_YEAR "2021"
setenv EPI_STDATE_TIME "2021-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2021-12-31 23:59:00.0"
setenv PARENT_CASE "2020ha2_cb6_20k"

## Parameters -- from job tab
setenv SECTOR "canada_ptdust"
setenv REGION "Continental US 12km"
setenv REGION_ABBREV "12US1"
setenv REGION_IOAPI_GRIDNAME "12US1_459X299"

## Parameters -- all regions, all sectors, all jobs 
setenv SPINUP_DURATION "10" ## Spinup Duration
setenv PROJECT "hapcap" ## Project short name
setenv PROJECT_ROOT "/work/EMIS/em_v9/hapcap" ## Project root directory
setenv EMF_QUEUE_OPTIONS_S16 "--mem-per-cpu=16g -n 1 -p singlepe -A emis -t 24:00:00" ## EMF queue options - spe 16gb
setenv EMF_QUEUE_OPTIONS_S8 "--mem-per-cpu=8g -n 1 -p singlepe -A emis -t 72:00:00" ## EMF queue options - spe 8gb
setenv EMF_QUEUE_OPTIONS_C "--mem-per-cpu=20g -n 1 -p compute -A emis -t 168:00:00" ## EMF queue options - emis
setenv EMF_QUEUE_OPTIONS "--mem-per-cpu=16g -n 1 -p singlepe -A emis -t 72:00:00" ## EMF queue options - spe 16gb def
setenv PLATFORM "v9" ## Platform name
setenv SPC "$EMF_SPC" ## Speciation type name
setenv SMK_HOME "/work/EMIS/smoke" ## Path, SMOKE home
setenv DAT_ROOT "/work/EMIS/em_$PLATFORM" ## Path, data root
setenv IMD_ROOT "$PROJECT_ROOT/$CASE/intermed" ## Path, intermediate root
setenv OUT_ROOT "/work/ROMO" ## Path, Output data root
setenv ASSIGNS_FILE "$SMK_HOME/smoke5.0/assigns/ASSIGNS.emf" ## Assigns File
setenv RUNSET "$EMF_SCRIPTDIR/run_settings.txt" ## Run settings file
setenv FILL_ANNUAL "N" ## Fill annual values
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5" ## Formula for Smkinven
setenv SMK_DEFAULT_SRGID "100" ## Default surrogate code
setenv REPORT_DEFAULTS "Y" ## Report default profiles used
setenv SMK_AVEDAY_YN "N" ## Use average day emissions
setenv SMK_MAXWARNING "10" ## Maximum warnings printed
setenv SMK_MAXERROR "10000" ## Maximum errors printed
setenv FULLSCC_ONLY "Y" ## Match full SCCs
setenv RUN_HOLIDAYS "Y" ## Run holidays
setenv L_TYPE "mwdss" ## Temporal type
setenv M_TYPE "mwdss" ## Merge type
setenv RAW_DUP_CHECK "N" ## Check for duplicate sources
setenv SMK_SPECELEV_YN "Y" ## Laypoint uses Elevpoint to set sources for plume rise calc
setenv SMK_PING_METHOD "0" ## Plume-in-grid method
setenv INLINE_MODE "only" ## Run in "inline" mode
setenv RUN_PYTHON_ANNUAL "Y" ## Run script for Smkmerge annual totals
setenv NO_SPC_ZERO_EMIS "Y" ## Don't speciate zero emission SCCs
setenv SPINUP_MONTH_END "Y" ## Run all of last month when running spinup
setenv WRF_VERSION "4" ## WRF version (affects afdust adjustments)
setenv DEFAULT_CONV_FAC_ERROR "Y" ## Error if profile missing from GSCNV
setenv OUTPUT_FORMAT "$EMF_AQM" ## Model output format
setenv SMKMERGE_CUSTOM_OUTPUT "Y" ## Custom merge output
setenv MRG_REPSTA_YN "N" ## Output state totals
setenv IOAPI_ISPH "20" ## I/O API Sphere type
setenv POLLUTANT_CONVERSION "Y" ## Use pollutant conversion
setenv RENORM_TPROF "Y" ## Renormalize temporal profiles
setenv OUTZONE "0" ## Output time zone
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python" ## EMF log directory
setenv MRG_REPCNY_YN "Y" ## Output county totals
setenv WEST_HSPHERE "Y" ## Western hemisphere?
setenv MRG_MARKETPEN_YN "N" ## Include market penetration

## Parameters -- region (Continental US 12km (12US1)), all sectors, all jobs 
setenv MET_ROOT "/work/EMIS/met/MCIP_v5.3.3/WRFv4.1.1_12US1_2021_35aL" ## Path, Met data root

## Parameters -- all regions, sector (canada_ptdust), all jobs 
setenv FILL_ANNUAL "Y" ## Fill annual values
setenv RUN_HOLIDAYS "N" ## Run holidays
setenv L_TYPE "week" ## Temporal type
setenv M_TYPE "week" ## Merge type
setenv MRG_BYDAY "P" ## Merge by day
setenv SMK_SPECELEV_YN "N" ## Laypoint uses Elevpoint to set sources for plume rise calc
setenv SMK_ELEV_METHOD "0" ## SMOKE elevated method
setenv INLINE_MODE "off" ## Run in "inline" mode othpt (elevate everything)
setenv MRG_LAYERS_YN "N" ## Run laypoint

## Parameters -- region (Continental US 12km (12US1)), sector (canada_ptdust), all jobs 

## Parameters -- all regions, all sectors, job (Othptdust adjustment)

## Parameters -- region (Continental US 12km (12US1)), all sectors, job (Othptdust adjustment)

## Parameters -- all regions, sector (canada_ptdust), all job (Othptdust adjustment)

## Parameters -- region (Continental US 12km (12US1)), sector (canada_ptdust), job (Othptdust adjustment)

## job executable
$EMF_CLIENT -k $EMF_JOBKEY -x $SMK_HOME/smoke4.6/scripts/emf/afdust_adj_emf.csh -m "Running top level script for job: Othptdust_adjustment"
$SMK_HOME/smoke4.6/scripts/emf/afdust_adj_emf.csh $REGION_ABBREV -q "1 2 3 4" 0
if ( $status != 0 ) then
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e' 
	 exit(1)
else
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

