
      PROGRAM MAIN

!C**********************************************************************
!C
!C  program to generate a table comparing AIRS and modeled ozone values
!C
!C**********************************************************************
      USE M3UTILIO
      USE LTNG_DEFN 

      IMPLICIT NONE 

!C..INCLUDES:  
!      INCLUDE SUBST_IOPARMS     ! IOAPI parameters
!      INCLUDE SUBST_IOFDESC     ! IOAPI file description
!      INCLUDE SUBST_IODECL      ! IOAPI declarations
      
!C..ARGUMENTS:

!C..PARAMETERS: None

!C..EXTERNAL FUNCTIONS: None
 
!C..SAVED LOCAL VARIABLES: None 

!C..SCRATCH LOCAL VARIABLES:
      CHARACTER*16    PNAME        ! Program Name
      CHARACTER*80    MSG          ! Error message
      CHARACTER*80    XMSG          ! Error message

      INTEGER :: SDATE     ! scenario start date
      INTEGER :: STIME     ! scenario start time
      INTEGER :: NSTEPS    ! run duration
      INTEGER :: STATUS    ! 

      INTEGER   N, i, j, k                 ! Loop index
      INTEGER :: JDATE, JTIME, TSTEP
      INTEGER     ::    yyyy, mm, dd


!C**********************************************************************
      DATA  PNAME       / 'LTNG_COLUMN_NO'  /

!cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c  Get the one time files and data type filled   
!c  variables
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
       SDATE = ENVINT( 'CTM_STDATE', 'Scenario Start (YYYYJJJ)', 0, STATUS )
       STIME = ENVINT( 'CTM_STTIME', 'Scenario Start (HHMMSS)', 0, STATUS )
       TSTEP = ENVINT( 'TSTEP', 'Scenario Start (HHMMSS)', 0, STATUS )
       NSTEPS = ENVINT( 'CTM_RUNLEN', 'Scenario Duration (HHMMSS)', 24, STATUS )
       NSTEPS = NSTEPS / TSTEP           ! initscen guarantees divisibility

        JDATE = SDATE
        JTIME = STIME
         print*,  " NSTEPS = ", NSTEPS
       IF ( .NOT. LTNG_INIT( JDATE, JTIME, TSTEP, NSTEPS) ) THEN
            XMSG = 'Failure initializing lightning emissions module'
            CALL M3EXIT ( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
       END IF
        JDATE = SDATE
        JTIME = STIME
       DO i = 1, NSTEPS
         CALL GET_LTNG ( JDATE, JTIME, TSTEP )
         CALL NEXTIME ( JDATE, JTIME, TSTEP )
       ENDDO

      WRITE( *, 92020 )                                  &
         '>>---->  Program ' // PNAME // ' completed successfully  <----<<'


      CALL EXIT( 0 )

!C******************  FORMAT  STATEMENTS   ******************************

2000   FORMAT(A9, 2(1x, F8.3), 1x, I1, 1x, I8, 1x, I7, 1x, I2, 2(1x, F8.2))
92020  FORMAT( //5X, A, // )

       END
       
       
