#!/bin/csh -f

##SBATCH -J LTNG_EMIS 
##SBATCH -p singlepe
##SBATCH -t 24:00:00

#
# 72 hours should be enough to run 23 days
#


set echo
set CASE = WWLLNs # NLDN # PARMs3x3fmx #lnr   #x7Month
set dmres = 4km 
# ##### begin user define area #####
set yyyy = 2022
set start_year     = $yyyy
set end_year       = $yyyy
set met_year       = 22 # now defined / hardcoded below depending on ${year}
set start_month    = 7

set end_month      = 7  #2 
set start_day      = 1 
set end_day        = 31
set cycle          = 000000
set firstday       = ${start_year}0701

set Mnames = ("Jan" "Feb" "Mar" "Apr" "May" "Jun" "Jul" "Aug" "Sep" "Oct" "Nov" "Dec")

setenv PROMPTFLAG           F  # turn off I/O-API PROMPT*FILE interactive mode

setenv CTM_LTNG_NO          Y  # turn on lightning NOx [N]
setenv USE_NLDN          Y  # turn on lightning NOx [N]
setenv LTNGDIAG             Y  # diagnostic file [N]
setenv DIAG3D                Y
setenv LINEAR         N 
# ----- CMAQ -----

 set EXEC     =  LTNG_Emis_Diag
# set CASE     = 12US1
 setenv EXECUTION_ID $EXEC    #> define the model execution id

 set year      = $start_year
 @ pre_year    = $year - 1
 @ cur_year    = $year
 @ yr          = $year
 @ start_hour  = $cycle / 10000
 @ end_hour    = ($start_hour + 23) % 24

# loop through simulation period
@ cur_year = $cur_year - 1
while ($cur_year < $end_year)

  @ cur_year++

  if (($cur_year % 4) != 0) then
     set leap_year_cur_year = 0
  else if (($cur_year % 400) == 0) then
     set leap_year_cur_year = 1     # leap year, nday = 29
  else if (($cur_year % 100) == 0) then
     set leap_year_cur_year = 0
  else
     set leap_year_cur_year = 1     # leap year, nday = 29
  endif

  if ($leap_year_cur_year) then
     set numday_cur_year = ( 31 29 31 30 31 30 31 31 30 31 30 31 )
     set leap_year_pre_year = 0
  else
     set numday_cur_year = ( 31 28 31 30 31 30 31 31 30 31 30 31 )
     if (($pre_year % 4) != 0) then
        set leap_year_pre_year = 0
     else if (($pre_year % 400) == 0) then
        set leap_year_pre_year = 1
     else if (($pre_year % 100) == 0) then
        set leap_year_pre_year = 0
     else
        set leap_year_pre_year = 1
     endif
  endif

# setup the current and previous day in julian format
  if ($cur_year == $start_year) then
     @ cur_day_j = 0
     @ temp_month = 1
     while ($temp_month < $start_month)
       @ cur_day_j = $cur_day_j + $numday_cur_year[$temp_month]
       @ temp_month++
     end
     @ cur_day_j = $cur_day_j + $start_day
     @ pre_day_j = $cur_day_j - 1
  else
     @ cur_day_j = 1
  endif

  if ($cur_day_j == 1) then
     if ($leap_year_pre_year) then
        set pre_day_j = 366
     else
        set pre_day_j = 365
     endif
  endif

  if ($cur_year == $start_year) then
     @ cur_month = $start_month
  else
     @ cur_month = 1
  endif

  if ($cur_year == $end_year) then
     @ cur_end_month = $end_month
  else
     @ cur_end_month = 12
  endif

  @ cur_month = $cur_month - 1
  while ($cur_month < $cur_end_month)
    @ cur_month++

    @ cur_day = 0
    @ cur_month_end_day = $numday_cur_year[$cur_month]
    if (($cur_year == $start_year) && ($cur_month == $start_month)) then
       @ cur_day = $start_day - 1
    endif

    if (($cur_year == $end_year) && ($cur_month == $cur_end_month)) then
       @ cur_month_end_day = $end_day
    endif

    while ($cur_day < $cur_month_end_day)

      @ cur_day++
      set loc_pre_year = $cur_year

      if ($cur_day == 1) then
         @ pre_month = $cur_month - 1
         if ($pre_month == 0) then
            set pre_month = 12
            @ loc_pre_year = $cur_year - 1
         endif
         set yest = $numday_cur_year[$pre_month]
         set yesterday = `printf "%d%2.2d%2.2d\n" $loc_pre_year $pre_month $yest`
      else
         @ yest = $cur_day - 1
         set yesterday = `printf "%d%2.2d%2.2d\n" $loc_pre_year $cur_month $yest`
      endif

      set today       = `printf "%d%2.2d%2.2d\n" $cur_year $cur_month $cur_day` # beginning date, yyyymmdd
      set today_j     = `printf "%d%3.3d\n" $cur_year $cur_day_j`               # beginning Julian date, yyyyxxx
      set yesterday_j = `printf "%d%3.3d\n" $loc_pre_year $pre_day_j`
      set MONTH       = `printf "%2.2d\n" $cur_month` # mm
      set DAY         = `printf "%2.2d\n" $cur_day` # dd
      set OUTDIR = /work/MOD3EVAL/dkj/LTNG/LTemis/${CASE}_$dmres/DenverSIP/emis22
      if ($today == $firstday) then
         if ( ! -d $OUTDIR ) then
            mkdir -p $OUTDIR
         endif
      endif

      set STDATE   = $today_j      # beginning date in julian format
      set STTIME   = $cycle        # beginning GMT time (HHMMSS)
      set NSTEPS   = 240000        # time duration (HHMMSS) for this run
      setenv TSTEP     010000        # output time step interval (HHMMSS)

#      set APPL     = $today

      setenv CTM_APPL ${today} 
      set    METpath     = /work/MOD3EVAL/dkj/LTNG/WWLLNs_4km/DenverSIP/mcip

# this is for inline biogenic emissions *.q
      set YEAR = $year
      set MONTH = `printf "%2.2d\n" $cur_month`
      set day = $cur_day
   
##> lightning NOx
      if ( $?CTM_LTNG_NO ) then   # $CTM_LTNG_NO is defined
         if ( $CTM_LTNG_NO == 'Y' || $CTM_LTNG_NO == 'T' ) then
            set ltngon = 1
         else
            set ltngon = 0
         endif
      else   # $CTM_LTNG_NO is not defined => $CTM_LTNG_NO == 'N
         set ltngon = 0
      endif

      if ( $ltngon ) then
        setenv LTNGNO "InLine" 
        setenv LTNGPARAM Y #> use lightning parameter file? [ Y|T ]
        set IN_LTpath = /work/MOD3EVAL/dkj/LTNG/WWLLNs_4km/DenverSIP/2022 # /work/MOD3EVAL/dkj/LTNG/OAQPS/${CASE}_$dmres2/$YEAR
        set MM = `date -ud "${today}" +%m`
        set Mon = $Mnames[$MM]
        setenv FLASH_FILE $IN_LTpath/WWLLNs_4km_DenverSIP_60min_${today}.nc
        setenv PARAMETER_FILE /work/MOD3EVAL/dkj/LTNG/WWLLNs_4km/DenverSIP/2022/LTNG_AllParms_DenverSIP_4km.ncf
        setenv LTNGOUT $OUTDIR/CCTM_LTNGCOL2D_${CASE}_${today}.nc
        setenv LTNGOUT3D $OUTDIR/CCTM_LTNGEMIS3D_${CASE}_${today}.nc
        if( -e $LTNGOUT) rm $LTNGOUT
        if( -e $LTNGOUT3D) rm $LTNGOUT3D

      endif

      set EXTN = ${met_year}${MONTH}${DAY}
      setenv MET_CRO_3D $METpath/METCRO3D.12US1.35L.$EXTN
      setenv MET_CRO_2D $METpath/METCRO2D.12US1.35L.$EXTN

#> for the run control ...

      setenv CTM_STDATE      $STDATE
      setenv CTM_STTIME      $STTIME
      setenv CTM_RUNLEN      $NSTEPS
      setenv CTM_TSTEP       $TSTEP
      setenv CTM_PROGNAME    $EXEC

# ----- END CMAQ -----

     ./$EXEC
                                                
      date '+Completed cctm at %m/%d/%y %H:%M:%S%n'

      @ cur_day_j++
      @ pre_day_j++
      if ($pre_day_j > $cur_day_j) then
         @ pre_day_j = $cur_day_j - 1
      endif
    end
  end
  @ pre_year++
end

endif 
