#!/bin/csh -fx
#  Scripts runs beld4_water_fix which is meant to correct the lack of water in CONUS and
#  Canada seen in BELDv4.1.  Fully updating BELDv4.1 to correct this water issue seems
#  unlikely instead it will likely be updated in future BELD versions.
#
#  INPUTS:
#  BELD4 gridded landuse file
#  GRID_CRO2D landuse file (any day shoudld work)
#
#  OUTPUT:
#  New BELD4 gridded landuse file with water corrected (water = GRIDCRO2D water LU
#
#  Program written by Jeff Vukovich Sept 2018
#
setenv BDIR  /work/EMIS/users/cvy/scripts/land_use/b41_feb2017/output/12US2
setenv BELD4  $BDIR/beld41_feb2017_12US2_windowed_from_12US1.ncf
setenv GRIDCRO2D /work/EMIS/users/jvukovic/work/afdust/GRIDCRO2D.12US2.35L.160715

setenv OUTFILE beld41_sep2018_12US.waterfixed.ncf 

/home/jvukovic/apps/smoke_v45/subsys/smoke/Linux2_x86_64ifort/beld4_water_fix

exit
