
      PROGRAM BELD4_WATER_FIX

C***********************************************************************
C
C  DESCRIPTION: Takes gridded SMOKE emissions file and applies
C
C  PRECONDITIONS REQUIRED:
C
C  SUBROUTINES AND FUNCTIONS CALLED:
C
C  REVISION  HISTORY:
C
C***********************************************************************
C
C Project Title: Sparse Matrix Operator Kernel Emissions (SMOKE) Modeling
C                System
C File: @(#)$Id: geofac.f,v 1.10 2007/07/11 19:18:32 bbaek Exp $
C
C COPYRIGHT (C) 2004, Environmental Modeling for Policy Development
C All Rights Reserved
C 
C Carolina Environmental Program
C University of North Carolina at Chapel Hill
C 137 E. Franklin St., CB# 6116
C Chapel Hill, NC 27599-6116
C 
C smoke@unc.edu
C
C Pathname: $Source: /nas01/depts/ie/cempd/apps/SMOKE_archive/smoke_archive/smoke/smoke/src/emutil/geofac.f,v $
C Last updated: $Date: 2007/07/11 19:18:32 $ 
C
C*************************************************************************

      USE MODFILESET

      IMPLICIT NONE

C...........   INCLUDES:

        INCLUDE 'IODECL3.EXT'     ! I/O API function declarations
        INCLUDE 'EMCNST3.EXT'     ! Emissions constants
        INCLUDE 'SETDECL.EXT'   !  FileSetAPI function declarations

C...........   EXTERNAL FUNCTIONS and their descriptions:

        INTEGER         GETFLINE
        INTEGER         PROMPTFFILE
        CHARACTER(16)   PROMPTMFILE
        INTEGER         TRIMLEN

        EXTERNAL  GETFLINE, PROMPTFFILE, PROMPTMFILE,
     &            TRIMLEN
           
C...........   PARAMETERS and their descriptions:

        CHARACTER(50), PARAMETER :: 
     &  CVSW = '$Name: SMOKEv36_13Nov2014 $' ! CVS release tag

C...........  LOCAL VARIABLES

        REAL  BFAC,GFAC                        ! temporary value for emissions
        REAL, ALLOCATABLE :: BLU( :, : )        ! emissions 
        REAL, ALLOCATABLE :: GLU( :, : )         ! species factors
        REAL, ALLOCATABLE :: GBRATIO( :, : )         ! species factors
        REAL, ALLOCATABLE :: BFIX( :, : )        ! emissions

        INTEGER  TSTEP                           ! time step
        INTEGER  I, J, K , L, M, N                  ! counters
        INTEGER  LDEV                            ! log file unit number
        INTEGER  RDEV                            ! species factors unit number
        INTEGER  NSPECS                          ! number of species
        INTEGER  HR                              ! hour loop counter
        INTEGER  NLINES                          ! number of species factors 
        INTEGER  NSTEPS                          ! number of time steps
        INTEGER  IOS                             ! iostat
        INTEGER  SDATE                           ! start date
        INTEGER  STIME                           ! start time

        CHARACTER(16), ALLOCATABLE :: SPCNAM ( : ) ! species names with facs
        CHARACTER(16)  ENAME, GNAME        ! logical name for gridded emis input file
        CHARACTER(16)  ONAME                       ! logical name for output file
        CHARACTER(300) MESG                        ! message buffer for M3EXIT()

        CHARACTER(16) :: PROGNAME = 'BELD4_WATER_FIX'   !  program name

C***********************************************************************
C   begin body of program

        LDEV = INIT3()

C.........  Write out copyright, version, web address, header info, and prompt
C           to continue running the program.

        CALL INITEM( LDEV, CVSW, PROGNAME )

C.........  Prompt for name of NetCDF input file

        GNAME = PROMPTSET(
     &       'Enter logical name for GRIDCRO2D file',
     &        FSREAD3, 'GRIDCRO2D', PROGNAME )

        IF ( .NOT. DESC3( GNAME ) ) THEN

            MESG = 'Could not get description of file "' //
     &             TRIM( GNAME ) // '"'
            CALL M3EXIT( PROGNAME , 0, 0, MESG, 2 )

        END IF


C.........  Prompt for name of NetCDF input file

        ENAME = PROMPTSET(
     &       'Enter logical name for BELD4 landuse file',
     &        FSREAD3, 'BELD4', PROGNAME )

        IF ( .NOT. DESC3( ENAME ) ) THEN

            MESG = 'Could not get description of file "' //
     &             TRIM( ENAME ) // '"'
            CALL M3EXIT( PROGNAME , 0, 0, MESG, 2 )

        END IF

C.........  Assign local variables

        TSTEP  = TSTEP3D
        SDATE  = SDATE3D
        STIME  = STIME3D
        NSPECS = NVARS3D
        NSTEPS = MXREC3D

C.........  Allocate memory for emissions

        ALLOCATE( BLU( NCOLS3D, NROWS3D ), STAT=IOS )
        CALL CHECKMEM( IOS, 'BLU', PROGNAME )

        ALLOCATE( BFIX( NCOLS3D, NROWS3D ), STAT=IOS )
        CALL CHECKMEM( IOS, 'BFIX', PROGNAME )

        ALLOCATE( GLU( NCOLS3D, NROWS3D ), STAT=IOS )
        CALL CHECKMEM( IOS, 'GLU', PROGNAME )

        ALLOCATE( GBRATIO( NCOLS3D, NROWS3D ), STAT=IOS )
        CALL CHECKMEM( IOS, 'GBRATIO', PROGNAME )

        GBRATIO = 0.0000 ! array

        IF( .NOT. READ3( ENAME, 'MODIS_0', 1,
     &                           SDATE, STIME, BLU ) ) THEN
                    MESG = 'Could not read variable MODIS_0' //
     &                     ' from file ' //
     &                     TRIM( ENAME )
                    CALL M3EXIT( PROGNAME, SDATE, STIME, MESG, 2 )
        END IF

        IF( .NOT. READ3( GNAME, 'LUFRAC_17', 1,
     &                           SDATE, STIME, GLU ) ) THEN
                    MESG = 'Could not read variable LUFRAC_17' //
     &                     ' from file ' //
     &                     TRIM( GNAME )
                    CALL M3EXIT( PROGNAME, SDATE, STIME, MESG, 2 )
        END IF
        N = 0 
        DO I = 1, NCOLS3D
         DO J = 1, NROWS3D
           GFAC = 100.000 - ( 100.000 * GLU( I,J ) ) 
           BFAC = 100.000 - BLU( I, J ) 
           IF ( BLU( I, J ) .EQ. 100.000 ) THEN
            GBRATIO( I, J ) = 1.000
           ELSE
            GBRATIO( I, J ) = GFAC/BFAC 
           ENDIF
           IF ( GBRATIO( I, J ) .GT. 1.25 ) THEN
             N = N + 1
             WRITE( 6, * ) I,J,GBRATIO(I,J),BFAC, GFAC,  N
           ENDIF 
           if ( i .eq. 370 .and. j .eq. 14 ) then
            write( 6, * ) 'bingo'
            write( 6, * )  I,J,GBRATIO(I,J),BFAC, GFAC
            write( 6, * )  BLU(I,J), GLU(I,J)
           endif 
         ENDDO
        ENDDO

C.........  Open output file

C        NVARS3D = 1
C        VNAME3D( 1 ) = "WATER_FAC"

        ONAME = 'OUTFILE'
        MESG = 'Output file name:'
        ONAME = PROMPTMFILE( MESG, FSUNKN3, ONAME, PROGNAME )

C        IF( .NOT. WRITE3( ONAME, VNAME3D( 1 ),
C     &                            SDATE, STIME, GBRATIO ) ) THEN
C                    MESG = 'Could not write variable ' //
C     &                     TRIM( VNAME3D( 1 ) ) // ' to file ' //
C     &                     TRIM( ONAME )
C                    CALL M3EXIT( PROGNAME, SDATE, STIME, MESG, 2 )
C        END IF

C.............  Write to screen because WRITE3 only writes to LDEV

        DO  L = 1, NSPECS

          BLU = 0.0   !  array

C.....................  Read input file for time and species of interest
          WRITE( 6, * ) 'Reading var = ', VNAME3D( L ) 

          IF( .NOT. READ3( ENAME, VNAME3D( L ), 1,
     &                           SDATE, STIME, BLU ) ) THEN
                    MESG = 'Could not read variable ' //
     &                     TRIM( VNAME3D( L ) ) // ' from file ' //
     &                     TRIM( ENAME )
                    CALL M3EXIT( PROGNAME, SDATE, STIME, MESG, 2 )
          END IF
          IF ( VNAME3D( L ) .NE. 'MODIS_0' ) THEN
           DO I = 1, NCOLS3D
            DO J = 1, NROWS3D
             BFIX( I, J ) = BLU( I, J ) * GBRATIO( I, J ) 
            ENDDO 
           ENDDO
          ELSE
           WRITE( 6, * ) 'SKIPPING WATER TYPE'
           DO I = 1, NCOLS3D
            DO J = 1, NROWS3D
             BFIX( I, J ) = GLU( I, J ) * 100.0000
             IF ( BLU ( I, J ) .EQ. 100.000 ) THEN
               BFIX( I, J ) = BLU( I, J ) 
             ENDIF
            ENDDO
           ENDDO

          ENDIF
          IF( .NOT. WRITE3( ONAME, VNAME3D( L ),
     &                            SDATE, STIME, BFIX ) ) THEN
                    MESG = 'Could not write variable ' //
     &                     TRIM( VNAME3D( L ) ) // ' to file ' //
     &                     TRIM( ONAME )
                    CALL M3EXIT( PROGNAME, SDATE, STIME, MESG, 2 )
          END IF
         
        ENDDO

C.........   End of program:

        CALL M3EXIT( PROGNAME, 0, 0, ' ', 0 )

C******************  FORMAT  STATEMENTS   ******************************

C...........   Error and warning message formats..... 91xxx

C...........   Informational (LOG) message formats... 92xxx

C...........   Formatted file I/O formats............ 93xxx

93000   FORMAT( A, F10.5 ) 

C...........   Internal buffering formats............ 94xxx

        END PROGRAM  BELD4_WATER_FIX
