options(scipen=999)
library(plyr)

for(country in c("BH","CB","CI","CT","DR","HT","JA")){

dat <- read.csv(sprintf("ptday_finn_%s_finn_2009_ff10_forMYR_20200505_csv_29may2020_v0", country), comment.char="#", stringsAsFactors=F)
dat.agg <- ddply(dat, c("poll","monthnum"), numcolwise(sum, na.rm=T))
write.csv(dat.agg, sprintf("ptday_finn_%s_finn_2009_ff10_forMYR_20200505_csv_29may2020_v0_sum.csv", country), row.names=F, quote=F)

}
