﻿# Begin queries to re-calculate hotelling based on new Long-Haul VMT developed under CRC A-88.

create table if not exists hotelling_vmt (region_cd char(5), scc bigint, vmt_original double, vmt_crc double, primary key(region_cd, scc))engine=myisam;
truncate hotelling_vmt;
insert into hotelling_vmt
  select o.region_cd, o.scc, o.ann_value, c.ann_value
  from ff10vmt o
  inner join ff10vmt_crc c
  where mid(o.scc,5,4) in (6202,6204) and o.region_cd=c.region_cd and o.scc=c.scc;

create table if not exists hotelling_scalars (region_cd char(5), vmt_original double, vmt_crc double, ratio double, primary key(region_cd))engine=myisam;
truncate hotelling_scalars;
truncate hotelling_scalars;
insert into hotelling_scalars (region_cd, vmt_original, vmt_crc)
  select region_cd, sum(vmt_original), sum(vmt_crc)
  from hotelling_vmt
  group by region_cd;

update hotelling_scalars set ratio=vmt_crc/vmt_original;

create table if not exists ff10hot_crc like ff10hot;
truncate ff10hot_crc;
insert into ff10hot_crc select * from ff10hot;
update ff10hot_crc c, hotelling_scalars s set c.ann_value=c.ann_value*s.ratio where c.region_cd=s.region_cd;

#Update `comment` field
update ff10hot_crc set `comment`='Default annual extended idle hours. Updated activity for consistency with source type 62 VMT from CRC-A88.' where right(scc,2)=53;
update ff10hot_crc set `comment`='Default annual auxiliary power unit hours. Updated activity for consistency with source type 62 VMT from CRC-A88.' where right(scc,2)=91;