-- **************************************************  ACTIVITY  *****************************************************
-- *******************************************************************************************************************
-- load the raw activity file.  entered here are the variables hoursusePerYear and loadFactor.  These are called
--		activity and LF in the raw data table.
-- due to the poor table design of MOVES2014a nonroad, this table must be blended properly with the Population data contained 
--		in the same table "nrsourceusetype".
-- *******************************************************************************************************************
drop table if exists ActFile;
create table ActFile
select 
	scc,
	description,
	region,
	minhp,
	maxhp,
	LF as loadfactor,
	units,
	activity,
	ageAdj
from S55000.activity a
order by scc, minhp, maxhp;


-- *******************************************************************************************************************
-- join the nrhprange bin table and get all combinations for each data entry in the table.
-- *******************************************************************************************************************
drop table if exists temp1;
create table temp1
select 
	scc,
	minHP,
	maxHP,
	n.nrhprangebinid,
	n.hpmin,
	n.hpmax,
	loadFactor,
	activity
from ActFile join movesdb20151109.nrhprangebin n
group by scc, minhp, maxhp, nrhprangebinid;

alter table temp1	add
(	inBin			varchar(1));

-- filter out impossible combinations
update temp1	set	inBin = "y";

update temp1	set inBin = "n"		where maxHp < minHP;
update temp1	set inBin = "n"		where minHP > hpmax;
update temp1	set inBin = "n"		where maxHP <= hpmin;

delete from temp1	where inBin = "n";

create index index1 on temp1 (scc, nrhprangebinid);




-- *******************************************************************************************************************
-- insert the new data into the official table structure.  these are only the new records.
-- this insert installs the new hoursusedperyear and loadfactor data.
-- *******************************************************************************************************************
drop table if exists temp2;
create table temp2 
select 
	sourceTypeID,
	t1.scc,
	t1.NRHPRangeBinID,
	medianLifeFullLoad,
	t1.activity as hoursUsedPerYear,
	t1.loadFactor,
	hpAvg,
	isPumpFilled,
	tankUnits,
	tankSize,
	tankFillFrac,
	tankMetalFrac,
	hoseLength,
	hoseDiameter,
	hoseMetalFrac,
	marineFillNeckHoseLength,
	marineFillNeckHoseDiameter,
	marineSupplyHoseLength,
	marineSupplyHoseDiameter,
	marineVentHoseLength,
	marineVentHoseDiameter,
	hotSoaksPerSHO,
	nonInstMarineTankFrac,
	marineInstPlasticTankTrailFrac,
	marineInstPlasticTankWaterFrac,
	marineInstMetalTankTrailerFrac,
	marineInstMetalTankWaterFrac,
	e10TankPermeationAdjFac,
	e10HosePermeationAdjFac,
	e10MarineFillNeckPermAdjFac,
	e10MarineSupplyHosePermAdjFac,
	e10MarineVentHosePermAdjFac
from   movesdb20151109.nrsourceusetype n inner join temp1 t1 
using (scc,nrhprangebinid) 
group by t1.scc, t1.nrhprangebinid
order by t1.scc, t1.nrhprangebinid;



-- *******************************************************************************************************************
-- create the final table from the activity data
-- *******************************************************************************************************************
drop table if exists nrsourceusetype_ACT;
create table nrsourceusetype_ACT like movesdb20151109.nrsourceusetype;
insert into nrsourceusetype_ACT select * from movesdb20151109.nrsourceusetype;
replace into nrsourceusetype_ACT select * from temp2;





-- *******************************************************************************************************************
-- create the final nrsourceusetype table based on the insertion of data from both the activity and populatin tables.
-- *******************************************************************************************************************
drop table if exists nrsourceusetype;
create table nrsourceusetype like movesdb20151109.nrsourceusetype;
insert into nrsourceusetype 
(	sourceTypeID,
	scc,
	NRHPRangeBinID,
	medianLifeFullLoad,
	hoursUsedPerYear,
	loadFactor,
	hpAvg,
	isPumpFilled,
	tankUnits,
	tankSize,
	tankFillFrac,
	tankMetalFrac,
	hoseLength,
	hoseDiameter,
	hoseMetalFrac,
	marineFillNeckHoseLength,
	marineFillNeckHoseDiameter,
	marineSupplyHoseLength,
	marineSupplyHoseDiameter,
	marineVentHoseLength,
	marineVentHoseDiameter,
	hotSoaksPerSHO,
	nonInstMarineTankFrac,
	marineInstPlasticTankTrailFrac,
	marineInstPlasticTankWaterFrac,
	marineInstMetalTankTrailerFrac,
	marineInstMetalTankWaterFrac,
	e10TankPermeationAdjFac,
	e10HosePermeationAdjFac,
	e10MarineFillNeckPermAdjFac,
	e10MarineSupplyHosePermAdjFac,
	e10MarineVentHosePermAdjFac 
)
select 
	a.sourceTypeID,
	a.scc,
	a.NRHPRangeBinID,
	p.medianLifeFullLoad,
	a.hoursUsedPerYear,
	a.loadFactor,
	p.hpAvg,
	a.isPumpFilled,
	a.tankUnits,
	a.tankSize,
	a.tankFillFrac,
	a.tankMetalFrac,
	a.hoseLength,
	a.hoseDiameter,
	a.hoseMetalFrac,
	a.marineFillNeckHoseLength,
	a.marineFillNeckHoseDiameter,
	a.marineSupplyHoseLength,
	a.marineSupplyHoseDiameter,
	a.marineVentHoseLength,
	a.marineVentHoseDiameter,
	a.hotSoaksPerSHO,
	a.nonInstMarineTankFrac,
	a.marineInstPlasticTankTrailFrac,
	a.marineInstPlasticTankWaterFrac,
	a.marineInstMetalTankTrailerFrac,
	a.marineInstMetalTankWaterFrac,
	a.e10TankPermeationAdjFac,
	a.e10HosePermeationAdjFac,
	a.e10MarineFillNeckPermAdjFac,
	a.e10MarineSupplyHosePermAdjFac,
	a.e10MarineVentHosePermAdjFac 
from  nrsourceusetype_act a inner join nrsourceusetype_population p
using (sourcetypeid)
group by a.sourcetypeid
order by a.sourcetypeid;


update S55000_2014.nrsourceusetype, movesdb20151109.nrsourceusetype set S55000_2014.nrsourceusetype.medianLifeFullLoad = movesdb20151109.nrsourceusetype.medianLifeFullLoad 
	where S55000_2014.nrsourceusetype.medianLifeFullLoad is null and 
		S55000_2014.nrsourceusetype.sourcetypeid = movesdb20151109.nrsourceusetype.sourcetypeid;

update S55000_2014.nrsourceusetype, movesdb20151109.nrsourceusetype set S55000_2014.nrsourceusetype.hpavg = movesdb20151109.nrsourceusetype.hpavg 
	where S55000_2014.nrsourceusetype.hpavg is null and 
		S55000_2014.nrsourceusetype.sourcetypeid = movesdb20151109.nrsourceusetype.sourcetypeid;

		
		
		

-- *******************************************************************************************
-- check the new user supplied data against the MOVES default data.  This is the final check
-- *******************************************************************************************
drop table if exists check2;
create table check2 
select 
	d.sourcetypeid,
	d.medianLifeFullLoad as medianlifefullload_default,
		n.medianLifeFullLoad,
	d.hoursUsedPerYear as hoursUsedPerYear_default,
		n.hoursUsedPerYear,
	d.hpavg as hpavg_default,
		n.hpavg,
	d.loadfactor as loadfactor_default,
		n.loadfactor,
	(d.medianLifeFullLoad - n.medianLifeFullLoad) as medianLifeFullLoad_diff,
	(d.hoursUsedPerYear - n.hoursUsedPerYear) as hoursUsedPerYear_diff,
	(d.hpavg - n.hpavg) as hpavg_diff,
	(d.loadfactor - n.loadfactor) as loadfactor_diff
from movesdb20151109.nrsourceusetype d left join nrsourceusetype n
using (sourcetypeid)
group by sourcetypeid
order by sourcetypeid;



drop table if exists actfile;
drop table if exists nrsourceusetype_act;
drop table if exists nrsourceusetype_population;
drop table if exists population;
drop table if exists temp1;
drop table if exists temp2;
drop table if exists check1;
drop table if exists check2;
drop table if exists check6;

