-- *******************************************************************************************************************
-- ************************************************** ALLOCATION *****************************************************
-- *******************************************************************************************************************
-- *******************************************************************************************************************
-- load the data from the raw allocation table.
-- *******************************************************************************************************************
drop table if exists AllocFile;
create table AllocFile
select 
	indicator,
	fips,
	subregion,
	year,
	allocation,
	description
from S55000.allocation a
order by indicator, fips, year;

alter table allocfile add
(	surrogateID			int,
	stateID				int,
	countyID			int,
	surrogatequant		double,
	surrogateyearID		int
);

update allocfile	set			surrogateID = 1		where indicator = "AIR";
update allocfile	set			surrogateID = 2		where indicator = "RVP";
update allocfile	set			surrogateID = 3		where indicator = "POP";
update allocfile	set			surrogateID = 4		where indicator = "OIL";
update allocfile	set			surrogateID = 5		where indicator = "MFG";
update allocfile	set			surrogateID = 6		where indicator = "MIN";
update allocfile	set			surrogateID = 7		where indicator = "LSC";
update allocfile	set			surrogateID = 8		where indicator = "LOG";
update allocfile	set			surrogateID = 9		where indicator = "HOU";
update allocfile	set			surrogateID = 10	where indicator = "COM";
update allocfile	set			surrogateID = 11	where indicator = "FRM";
update allocfile	set			surrogateID = 12	where indicator = "CON";
update allocfile	set			surrogateID = 13	where indicator = "GC";
update allocfile	set			surrogateID = 14	where indicator = "SNM";
update allocfile	set			surrogateID = 15	where indicator = "SBR";
update allocfile	set			surrogateID = 16	where indicator = "SBC";
update allocfile	set			surrogateID = 17	where indicator = "WIB";
update allocfile	set			surrogateID = 18	where indicator = "WOB";
update allocfile	set			surrogateID = 19	where indicator = "RR";

update allocfile	set			stateid = fips/1000;
update allocfile	set			countyid = fips/1;
update allocfile	set			surrogatequant = allocation;
update allocfile	set			surrogateyearid  = year;



-- *******************************************************************************************************************
-- load the final table.  only the records which are actually imported are loaded.
--		the other defaults are not loaded into the user supplied database.
-- *******************************************************************************************************************
drop table if exists nrstatesurrogate;
create table nrstatesurrogate like movesdb20151109.nrstatesurrogate;
insert into nrstatesurrogate 
(	surrogateID,
	stateID,
	countyID,
	surrogatequant,
	surrogateyearid
)
select 
	surrogateID,
	stateID,
	countyID,
	surrogatequant,
	surrogateyearid
from allocfile
group by stateid, countyid, surrogateID
order by stateid, countyid, surrogateID;

drop table if exists allocfile;

