-- *******************************************************************************************************************
-- ******************************************** MonthAdjustmentFactors ***********************************************
-- *******************************************************************************************************************
-- *******************************************************************************************************************
-- *******************************************************************************************************************
-- read in the regionID decoder.  this is the one provided by Dan's program and provided by the state.  should be the 
--		as the official one.
-- the raw state input files may have the subregion column filled.  this decoder is the official 
--		one used for NONROAD. the state may just specify there state abbr.  this code will have to be modified
--		to read a state name or state abbreviation.
-- *******************************************************************************************************************
drop table if exists temp1;
create table temp1 
select 
	subregion,
	scc,
	description,
	month as monthid,
	adjFactor
from S55000.monthlyadjfactors;

create index index1 on temp1(subregion);


-- *******************************************************************************************************************
-- read the data from Dan's Region table to decode the regions.
-- *******************************************************************************************************************
drop table if exists regionDecoderUser;
create table regionDecoderUser 
select 
	region as subregion,
	description,
	fips/1000 as stateID,
	name
from S55000.region;

create index index1 on regionDecoderUser(subregion);


drop table if exists temp2;
create table temp2 
select 
	t.subregion,
	d.stateid,
	t.scc,
	t.description,
	t.monthid,
	t.adjFactor
from temp1 t left join regionDecoderUser d
using (subregion)
group by d.stateid, t.scc, t.monthid
order by d.stateid, t.scc, t.monthid;



drop table if exists temp3;
create table temp3 like movesdb20151109.nrmonthallocation;
insert into temp3 select * from movesdb20151109.nrmonthallocation;


replace into temp3 
(	scc,
	stateID,
	monthID,
	monthFraction
)
select 
	scc,
	stateid,
	monthid,
	adjfactor as monthFraction 
from temp2
where stateid <> 0
group by scc, stateid, monthid
order by scc, stateid, monthid;

create index index1 on temp3(scc, stateid);

drop table if exists temp3sum;
create table  temp3sum
select 
	scc,
	stateID,
	sum(monthFraction) as monthFractionSum
from temp3
group by scc, stateid;

create index index1 on temp3sum(scc, stateid);


drop table if exists temp4;
create table temp4 
select 
	t.scc,
	t.stateid,
	t.monthid,
	t.monthfraction / s.monthfractionSum as monthFraction
from temp3 t left join temp3sum s
using (scc, stateid)
group by t.scc, t.stateid, t.monthid
order by t.scc, t.stateid, t.monthid; 



drop table if exists nrmonthallocation;
create table nrmonthallocation like movesdb20151109.nrmonthallocation;
insert into nrmonthallocation select * from temp4;

delete from nrmonthallocation where stateid <> 55;



drop table if exists regiondecoderuser;
drop table if exists temp1;
drop table if exists temp2;
drop table if exists temp3;
drop table if exists temp3sum;
drop table if exists temp4;

