-- ************************************************  POPULATION  *****************************************************
-- *******************************************************************************************************************
-- load the raw POPFile data.  It contains more than just population data.
-- it also contains medianLifeFullLoad - called expectedusefullife in the primary database.
-- it also contains avgHP value.
-- 		both the population and activity TOUCH the nrSourceUseType table and must be processed together.
-- *******************************************************************************************************************
drop table if exists Population;
create table Population
select 
	fips,
	subregion,
	year,
	scc,
	description,
	minhp,
	maxhp,
	avghp,
	expectedusefullife,
	scrappagedistributionequipment,
	population
from S55000.population
order by fips, year, scc, minhp, maxhp;


-- *******************************************************************************************************************
-- combine the raw population table data with the MOVES2014a table nrhprangebin table.
--		create a hpbin for every combination.  delete the ones that do not exist.
-- *******************************************************************************************************************
drop table if exists temp1;
create table temp1
select 
	fips,
	subregion,
	year,
	scc,
	description,
	minhp,
	maxhp,
	avghp,
	n.nrhprangebinid,
	n.hpmin,
	n.hpmax,
	expectedusefullife,
	scrappagedistributionequipment,
	population
from population join movesdb20151109.nrhprangebin n
order by fips, year, scc, minhp, maxhp, n.nrhprangebinid;

alter table temp1	add
(	inBin			varchar(1),
	newHPRangeID	smallint(6)
);

-- filter out impossible combinations
update temp1	set	inBin = "n";
update temp1	set newHPRangeID = maxhp;
update temp1	set inBin = "y"		where newHPRangeID = nrhprangebinid;
delete from temp1	where inBin = "n";
create index index1 on temp1 (scc, nrhprangebinid);



-- ***********************************************************************************************************************
-- join the data table with the moves2014a nrsourceusetype table to bring the primary key (sourcetypeid) into the dataset.
-- ***********************************************************************************************************************
drop table if exists temp2;
create table temp2 
select 
	n.sourcetypeid,
	t.fips/1000 as stateID,
	t.year as nrbaseyearid,
	t.scc,
	t.avghp as hpAvg,
	t.nrhprangebinid,
	t.hpmin,
	t.hpmax,
	t.expectedusefullife as medianLifeFullLoad,
	t.scrappagedistributionequipment,
	t.population
from temp1 t join movesdb20151109.nrsourceusetype n 
using (scc, nrhprangebinid)
group by n.sourcetypeid, stateid, nrbaseyearid, t.scc, t.nrhprangebinid
order by n.sourcetypeid, stateid, nrbaseyearid, t.scc, t.nrhprangebinid;

create index index1 on temp2(stateid);
create index index2 on temp2(sourcetypeid, stateid);

-- *******************************************************************************************************************
-- populate the final base year population table.
-- this routine needs to check to see if the user is entering an old base year population and growth factors or 
--		or if the user is entering the actual population in the evaluation year.  If the latter is the case, then the growth rates
--		must be zeroed out.  If the former is true the default MOVES2014a growth rates can be used or the user can enter their
--		own growth rates.
-- *******************************************************************************************************************
drop table if exists nrbaseyearequippopulation;
create table nrbaseyearequippopulation like movesdb20151109.nrbaseyearequippopulation;
insert into nrbaseyearequippopulation 
(	sourcetypeid,
	stateid,
	population,
	nrbaseyearid
)
select
	d.sourcetypeid,
	d.stateid,
	d.population,
	d.nrbaseyearid 
from movesdb20151109.nrbaseyearequippopulation d inner join temp2  t
using (stateid)
group by d.sourcetypeid, d.stateid
order by d.sourcetypeid, d.stateid;

-- make all of the default values zero population and then cover up the zeros with the actual user supplied data.
update nrbaseyearequippopulation set population = 0.0; 

# Later base years overwrite earlier base years.  All possible nrbaseyearids must be present.
# This procedure assures that the latest base year populations are used.
replace into nrbaseyearequippopulation 
(	sourcetypeid,
	stateid,
	population,
	nrbaseyearid
)
select 
	sourcetypeid,
	stateid,
	population,
	nrbaseyearid
from temp2
where nrbaseyearid = 1996
group by sourcetypeid, stateid
order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 1997 group by sourcetypeid, stateid order by sourcetypeid, stateid;
	
replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 1998 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 1999 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2000 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2001 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2002 group by sourcetypeid, stateid order by sourcetypeid, stateid;
	
replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2003 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2004 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2005 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2006 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2007 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2008 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2009 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2010 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2011 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2012 group by sourcetypeid, stateid order by sourcetypeid, stateid;
	
replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2013 group by sourcetypeid, stateid order by sourcetypeid, stateid;

replace into nrbaseyearequippopulation (sourcetypeid,stateid,population,nrbaseyearid) select sourcetypeid,stateid,population, nrbaseyearid
	from temp2 where nrbaseyearid = 2014 group by sourcetypeid, stateid order by sourcetypeid, stateid;




	
drop table if exists check6;
create table check6 
select 
	d.sourcetypeid,
	d.stateid,
	u.population as population_user,
	d.population as population_default,
	u.nrbaseyearid as nrbaseyearid_user,
	d.nrbaseyearid as nrbaseyearid_default,
	u.population - d.population as pop_diff
from movesdb20151109.nrbaseyearequippopulation d left join nrbaseyearequippopulation u
using (sourcetypeid, stateid)
where d.stateid = 55
group by d.stateid, d.sourcetypeid
order by abs(pop_diff) desc;
	




-- *******************************************************************************************************************
-- this query creates a table for future processing with the activity data since they share the 
--		the nrsourceusetype table.  It has a complete set of keys based on the default table in MOVES2014a.
-- a error check is to check for null values inthe medianLifeFullLoad and hpAvg.  These would indicated less than a 
--		complete match.
-- *******************************************************************************************************************
drop table if exists nrsourceusetype_population;
create table nrsourceusetype_population 
select 
	n.sourceTypeID,
	n.scc,
	n.NRHPRangeBinID,
	t2.medianLifeFullLoad,
	hoursUsedPerYear,
	loadFactor,
	t2.hpAvg,
	isPumpFilled,
	tankUnits,
	tankSize,
	tankFillFrac,
	tankMetalFrac,
	hoseLength,
	hoseDiameter,
	hoseMetalFrac,
	marineFillNeckHoseLength,
	marineFillNeckHoseDiameter,
	marineSupplyHoseLength,
	marineSupplyHoseDiameter,
	marineVentHoseLength,
	marineVentHoseDiameter,
	hotSoaksPerSHO,
	nonInstMarineTankFrac,
	marineInstPlasticTankTrailFrac,
	marineInstPlasticTankWaterFrac,
	marineInstMetalTankTrailerFrac,
	marineInstMetalTankWaterFrac,
	e10TankPermeationAdjFac,
	e10HosePermeationAdjFac,
	e10MarineFillNeckPermAdjFac,
	e10MarineSupplyHosePermAdjFac,
	e10MarineVentHosePermAdjFac
from   movesdb20151109.nrsourceusetype n left join temp2 t2 
using (sourcetypeid) 
group by n.sourcetypeid
order by n.sourcetypeid;

drop table if exists temp1;
drop table if exists temp2;



-- *************************************************************************
-- check the new user supplied data against the MOVES default data.
-- *************************************************************************
drop table if exists check1;
create table check1 
select 
	d.sourcetypeid,
	d.medianLifeFullLoad as medianlifefullload_default,
		n.medianLifeFullLoad,
	d.hpavg as hpavg_default,
		n.hpavg,
	(d.hpavg - n.hpavg) as hpavg_diff,
	(d.medianLifeFullLoad - n.medianLifeFullLoad) as medianLifeFullLoad_diff
from movesdb20151109.nrsourceusetype d left join nrsourceusetype_population n
using (sourcetypeid)
group by sourcetypeid
order by sourcetypeid;

