import configparser

import sqlalchemy

class ConnectToMySQL(object):
    '''
    Use this class to create a sqlalchemy engine using a standardized config file
    '''

    @classmethod
    def create_engine(cls, config_path=None, username=None, password=None,
                      host=None, port=None, db=None):
        '''
        Returns a sqlalchemy engine using the connection information contained in
        a configuration file, which should contain a 'mysql' section that defines
        the MySQL username, password, host, and port.
        '''
                
        config = configparser.ConfigParser()
        config.read(config_path)
        username = username or config.get(section='mysql', option='username', fallback='moves')
        password = password if password is not None else config.get(section='mysql', option='password', fallback='moves')
        host = host if host is not None else config.get(section='mysql', option='host', fallback='')
        port = port if port is not None else config.get(section='mysql', option='port', fallback='')
        db = db if db is not None else config.get(section='mysql', option='database', fallback='')
        
        if port != '':
            port = ':' + port
        
        s = 'mysql+pymysql://{u}:{p}@{host}{port}/{db}'.format(u=username, p=password, host=host, port=port, db=db)

        try:
            engine = sqlalchemy.create_engine(s)
            engine.connect().close() # test the connection!
        except Exception as e:
            raise MySQLConnectionError(str(e))
        
        return engine

class MySQLConnectionError(Exception):
    pass
