import os
from NR08a.NR08aData import NR08aData

class DataFile(object):
    '''
    DataFile represents a raw NR data file. It can read individual sections,
    depending on which data type is requested.
    '''

    def __init__(self, path):
        self.path = path
        
    def read(self, data_type):       
        data = []
        with open(self.path, 'r') as f:
            in_section = False
            for line in f:
                if not in_section:
                    if line.startswith('/{}/'.format(data_type.section)): 
                        in_section = True
                    continue
                if line.startswith('/END/'): break
                line = line.rstrip(os.linesep)
                if len(line) == 0: continue
                data.append([line[col.range_start-1:col.range_end].strip() for col in data_type.columns])
        return NR08aData(data, data_type)
