﻿Delimiter $$
DROP   PROCEDURE IF EXISTS QA_NDB_2014_v5$$
CREATE PROCEDURE           QA_NDB_2014_v5()
BEGIN


declare nErrors   int;
declare nWarnings int;
declare tblNo     int;
declare tblName   char(30);
declare numRows   int;
declare errMsg    char(30);
declare Q         int;
declare dataBaseName char(30);

-- Version 5

   select '  .. Start of Nonroad Checks',curTime(), database();

   set @hdate = '20160112';

-- using base database: movesdb20141021

-- tables to be created:

drop table if exists County_Database_Checks;
CREATE TABLE
   County_Database_Checks
 (
   countyID          char(10),    -- int(11),
   status            char(20),

   tableId           int,
   tableName         char(30),
   checkNumber       int,
   testDescription   char(250),
   testValue         double,
   count             int(11),

   dataBaseName      char(100),
   dayID             smallint(6),
   fuelFormulationID smallint(6),
   fuelTypeId        smallint(6),
   fuelSubtypeID     smallint(6),
   fuelYearID        smallint(6),
   hourDayID         smallint(6),
   hourID            smallint(6),
   HPMSVtypeID       smallint(6),
   monthGroupID      smallint(6),
   monthID           smallint(6),
   roadTypeID        smallint(6),
   sourceTypeID      smallint(6),
   stateID           smallint(6),
   yearID            smallint(6),
   zoneID            int(11),
   msgType           char(50),
   msgDate           date,
   msgTime           time,
   versionDate       char(8),
   sumKeyID          int(11),
   sumKeyDescription char(50)
 ) ENGINE=MyISAM DEFAULT CHARSET=latin1;


drop table if exists QA_Checks_Log;
create table
  QA_Checks_Log
  (
    tableId     int,
    tableName   char(30),
    checkNo     int,
    description char(30),
    status      char(20)
  ) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- changed references to fuelsupply and fuelsubtype at lines 1644,1690,1736,1795,1848,1797 & 985.
-- removed check #64 at line 1560 for T50/T90/E200/E300. 
-- nrsurrogate hard coded to pass on line 791.

-- tables to be checked for QA_NDB_2014 :

-- tblId  tblName                    ( description )

--   11   nrbaseyearequippopulation  (source populations)
--   12   nrsurrogate                (allocations to counties)   Not important, checking dropped
--   13   nrmonthallocation          (seasonal allocation)
--   14   nrdayallocation            (allocation to day type)
--   15   nrhourallocation           (allocation to diurnal pattern)
--   16   nrretrofitfactors          (retrofit information)
--   17   nrsourceusetype            (annual activity)
--   18   nrStateSurrogate

--   19   fuelFormulation             added version 4, same    checks as CDB script
--   20   NRFuelSupply                "     "       ", similar "      "  "   "
--   21   ZoneMonthHour               "     "       ", same    "      "  "   "

--   22   nrgrowthIndex               added version 5


  set nErrors   = 0;
  set nWarnings = 0;

set Q = 0;   -- actual checking
-- set Q = 1;   -- creating errors to test writing error messages to output table
if Q > 0 then select 'creating false errors';  end if;


--       Table  Check: nrbaseyearequipment *start*
  set tblNo   = 11;
  set tblName = 'nrbaseyearequippopulation';
  set errMsg  = '';


  insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,        status   )
                     values ( tblNo,   tblName,    101,     'init table check', 'unknown' );

  set    numRows =  ( select table_rows
                      from   information_schema.tables
                      where  table_schema = database()
                        and  table_name   = tblName      );

  if     numRows is null then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status )
                                                 values ( tblNo,   tblName,   tblNo,  'Missing Table',  'ERROR' );
                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status)
                                                           values( tblNo,   tblNAME, 1,  'Missing Table',  'ERROR');
                                                 set nErrors = nErrors+1;
                                                 set errMsg  = 'Missing Table';

  elseif numRows = 0     then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status   )
                                                 values ( tblNo,   tblName,   tblNo,  'Empty Table',    'Warning' );

                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status  )
                                                           values( tblNo,   tblNAME, 1,  'Empty Table',  'WARNING'  );
                                                 set nWarnings = nWarnings + 1;
                                                 set errMsg  = 'Empty Table';

  else                        INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status     )
                                                 values ( tblNo,   tblName,   tblNo,  'Present Table',  'Completed' );


-- check no. 021
insert into QA_Checks_Log ( tableId, tableName, checkNo, description,     status    )
                   values ( 11,      tblName,   21,     'sourceTypeId', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   sourceTypeId,
        'no '        as aMatch,
         count(*)    as n
From     nrbaseyearequippopulation
Group by sourceTypeId;

Update tempA as a set aMatch='yes' where ( Select count(*)
                                           From movesDb20141021.nrSourceUseType as m
                                           Where  a.sourceTypeId = m.sourceTypeId     ) > 0;


--  The following (commented-out) statements may be used at some later date to replace
--  the above update statement  -- thus removing the hard-coded base database name
--
--
--
-- declare baseDB char(30);
-- set baseDB = 'movesDb20141021';
--
--  set @s = concat( 'Update tempA as a set aMatch=''yes'' where (Select count(*) From ',
--                    baseDB,
--                   '.nrSourceUseType as m  Where  a.sourceTypeId = m.sourceTypeId) > 0;');
--
--  prepare stmt2 from @s;
--
--  execute stmt2;
--
--  select * from tempA limit 20;


if Q > 0 then update tempA set aMatch='no' where sourceTypeId=1547;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         sourceTypeId )
Select   11                         as tableId,
        'nrbaseyearequippopulation' as tableName,
         21                         as checkNumber,
        'sourceTypeId is invalid'   as testDescription,
         sourceTypeId               as testValue,
         n                          as count,
        'ERROR'                     as status,
         sourceTypeId
From     tempA
Where    aMatch <> 'yes';



-- check no. 022
insert into QA_Checks_Log ( tableId, tableName, checkNo, description, status    )
                   values ( 11,      tblName,   22,     'stateId',   'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   stateId,
         'no '        as aMatch,
         count(*)     as n
From     nrbaseyearequippopulation
Group by stateId;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.state as m
                                          Where  a.stateId = m.stateId)>0;

if Q > 0 then update tempA set aMatch='no' where stateId=49;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         stateId,
         count,
         status  )
Select   11                         as tableId,
        'nrbaseyearequippopulation' as tableName,
         22                         as checkNumber,
        'stateId not valid'         as testDescription,
         stateId                    as testValue,
         stateId                    as stateId,
         n                          as count,
        'ERROR'                     as status
From     tempA
Where    aMatch <> 'yes';


  end if;

  INSERT INTO County_Database_Checks  ( tableId, tableName, checkNumber, testDescription,   status     )
                               values ( tblNo,   tblName,   1,          'Table Check',     'Completed' );


--       Table  Check: nrbaseyearequippopulation *end*




--       Table  Check: nrmonthallocation *start*
  set tblNo   = 13;
  set tblName = 'nrmonthallocation';
  set errMsg  =  '';


  insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,        status   )
                     values ( tblNo,   tblName,    101,     'init table check', 'unknown' );

  set    numRows =  ( select table_rows
                      from   information_schema.tables
                      where  table_schema = database()
                        and  table_name   = tblName      );

  if     numRows is null then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status )
                                                 values ( tblNo,   tblName,   tblNo,  'Missing Table',  'ERROR' );
                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status)
                                                           values( tblNo,   tblNAME, 3,  'Missing Table',  'ERROR');
                                                 set nErrors = nErrors+1;
                                                 set errMsg  = 'Missing Table';

  elseif numRows = 0     then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status   )
                                                 values ( tblNo,   tblName,   tblNo,  'Empty Table',    'Warning' );

                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status  )
                                                           values( tblNo,   tblNAME, 3,  'Empty Table',  'WARNING'  );
                                                 set nWarnings = nWarnings + 1;
                                                 set errMsg  = 'Empty Table';

  else                        INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status     )
                                                 values ( tblNo,   tblName,   tblNo,  'Present Table',  'Completed' );



    --       check no. 023
insert into QA_Checks_Log ( tableId, tableName, checkNo, description,  status    )
                   values ( tblNo,   tblName,   23,     'stateId',    'checking' );

Drop   table if exists tempA;
create table tempA
select  'no ' as OK,
         stateId,
         count(*) as n
from     nrMonthAllocation
group by stateId;

Update tempA as a set a.OK='yes' where (select count(*)
                                        from   movesdb20141021.state as b
                                        where a.stateId = b.stateId) > 0;

 if Q > 0 then update tempA set OK = 'no' where stateId = 16; -- for testing
 end if;

set nErrors = nErrors + (select count(*) from tempA where OK = 'no');

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         stateId,
         count,
         status  )
Select   13                 as tableId,
        'nrMonthAllocation' as tableName,
         23                 as checkNumber,
        'invalid stateId'   as testDescription,
         stateId            as testValue,
         stateId,
         n                  as count,
        'ERROR'             as status
From     tempA
Where    OK <> 'yes';


    --       check no. 024
insert into QA_Checks_Log ( tableId, tableName, checkNo, description,  status    )
                   values ( tblNo,   tblName,   24,     'monthId',    'checking' );

Drop   table if exists tempA;
create table tempA
select  'no ' as OK,
         monthId,
         count(*) as n
from     nrMonthAllocation;

Update tempA as a set a.OK='yes' where (select count(*)
                                        from   movesdb20141021.monthOfAnyYear as b
                                        where a.monthId = b.monthId) > 0;

 if Q > 0 then update tempA set OK = 'no' where monthId = 1; -- for testing
 end if;

set nErrors = nErrors + (select count(*) from tempA where OK = 'no');

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         monthId,
         count,
         status  )
Select   13                 as tableId,
        'nrMonthAllocation' as tableName,
         24                 as checkNumber,
        'invalid monthId'   as testDescription,
         monthId            as testValue,
         monthId,
         n                  as count,
        'ERROR'             as status
From     tempA
Where    OK <> 'yes';


  --       check no. 025
insert into QA_Checks_Log ( tableId, tableName, checkNo, description,     status    )
                   values ( tblNo,   tblName,   25,     'monthFraction', 'checking' );

Drop   table if exists tempA;
create table tempA
select  'no ' as OK,
         SCC,
         stateId,
         count(*) as n,
         sum(monthFraction) as s
from     nrMonthAllocation
group by SCC,
         stateId;

Update tempA set OK='yes' where s>=0.999 and s<=1.001;

set nErrors = nErrors + (select count(*) from tempA where OK = 'no');

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         stateId,
         count,
         status  )
Select   13                            as tableId,
        'nrMonthAllocation'            as tableName,
         25                            as checkNumber,
        'distribution is out of range' as testDescription,
         s                             as testValue,
         stateId                       as stateId,
         n                             as count,
        'ERROR'                        as status
From     tempA
Where    OK <> 'yes';


  end if;

  INSERT INTO County_Database_Checks  ( tableId, tableName, checkNumber, testDescription,   status     )
                               values ( tblNo,   tblName,   3,          'Table Check',     'Completed' );

--       Table  Check: nrMonthAllocation *end*



--       Table  Check: nrdayallocation *start*
  set tblNo   = 14;
  set tblName = 'nrdayallocation';
  set errMsg  = '';


  insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,        status   )
                     values ( tblNo,   tblName,    101,     'init table check', 'unknown' );

  set    numRows =  ( select table_rows
                      from   information_schema.tables
                      where  table_schema = database()
                        and  table_name   = tblName      );

  if     numRows is null then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status )
                                                 values ( tblNo,   tblName,   tblNo,  'Missing Table',  'ERROR' );
                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status)
                                                           values( tblNo,   tblNAME, 4,  'Missing Table',  'ERROR');
                                                 set nErrors = nErrors+1;
                                                 set errMsg  = 'Missing Table';

  elseif numRows = 0     then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status   )
                                                 values ( tblNo,   tblName,   tblNo,  'Empty Table',    'Warning' );

                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status  )
                                                           values( tblNo,   tblNAME, 4,  'Empty Table',  'WARNING'  );
                                                 set nWarnings = nWarnings + 1;
                                                 set errMsg  = 'Empty Table';

  else                        INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status     )
                                                 values ( tblNo,   tblName,   tblNo,  'Present Table',  'Completed' );


      --       check no. 026
insert into QA_Checks_Log ( tableId, tableName, checkNo, description,  status    )
                   values ( tblNo,   tblName,   26,     'dayId',      'checking' );

Drop   table if exists tempA;
create table tempA
select  'no ' as OK,
         dayId,
         count(*) as n
from     nrdayallocation;

Update tempA as a set a.OK='yes' where (select count(*)
                                        from   movesdb20141021.dayOfAnyWeek as b
                                        where a.dayId = b.dayId) > 0;


if Q > 0 then update tempA set OK = 'no' where dayId = 5; -- for testing
 end if;

set nErrors = nErrors + (select count(*) from tempA where OK = 'no');

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         dayId,
         count,
         status  )
Select   14                 as tableId,
        'nrdayallocation' as tableName,
         26               as checkNumber,
        'invalid dayId'   as testDescription,
         dayId            as testValue,
         dayId,
         n                  as count,
        'ERROR'             as status
From     tempA
Where    OK <> 'yes';


    --       check no. 027
insert into QA_Checks_Log ( tableId, tableName, checkNo, description,   status    )
                   values ( tblNo,   tblName,   27,     'dayFraction', 'checking' );

Drop   table if exists tempA;
create table           tempA
select   scc,
         dayId,
         sum(dayId*dayFraction) as s1
from     nrdayallocation
group by scc,
         dayId;

drop   table if exists tempB;
create table           tempB
select   'no '    as OK,
         scc,
         sum(s1) as s2
from     tempA
group by scc;

Update tempB set OK='yes' where s2>0.999 and s2<1.001;

if Q > 0 then update tempB set OK = 'no' where scc = 2267004071; -- for testing
 end if;

set nErrors = nErrors + (select count(*) from tempB where OK = 'no');

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status  )
Select   14                     as tableId,
        'nrdayallocation'       as tableName,
         27                     as checkNumber,
        'dayFraction sum <> 1.0' as testDescription,
         s2                     as testValue,
         1                      as count,
        'ERROR'                 as status
From     tempB
Where    OK <> 'yes';


  end if;

  INSERT INTO County_Database_Checks  ( tableId, tableName, checkNumber, testDescription,   status     )
                               values ( tblNo,   tblName,   4,          'Table Check',     'Completed' );

--       Table  Check: nrdayallocation *end*



--       Table  Check: nrhourallocation *start*

  set tblNo   = 15;
  set tblName = 'nrHourAllocation';
  set errMsg  = '';


  insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,        status   )
                     values ( tblNo,   tblName,    101,     'init table check', 'unknown' );

  set    numRows =  ( select table_rows
                      from   information_schema.tables
                      where  table_schema = database()
                        and  table_name   = tblName      );

  if     numRows is null then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status )
                                                 values ( tblNo,   tblName,   tblNo,  'Missing Table',  'ERROR' );
                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status)
                                                           values( tblNo,   tblNAME, 5,  'Missing Table',  'ERROR');
                                                 set nErrors = nErrors+1;
                                                 set errMsg  = 'Missing Table';

  elseif numRows = 0     then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status   )
                                                 values ( tblNo,   tblName,   tblNo,  'Empty Table',    'Warning' );

                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status  )
                                                           values( tblNo,   tblNAME, 5,  'Empty Table',  'WARNING'  );
                                                 set nWarnings = nWarnings + 1;
                                                 set errMsg  = 'Empty Table';

  else                        INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status     )
                                                 values ( tblNo,   tblName,   tblNo,  'Present Table',  'Completed' );

    --       check no. 028
 insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,    status   )
                    values ( tblNo,   tblName,    28,      'hourID',       'unknown' );

drop   table if exists tempA;
create table           tempA
select  'no ' as OK,
         hourId,
         count(*) as n
from     nrHourAllocation
group by hourId;

update tempA set OK='yes' where hourId>=1 and hourId<=24;

if Q > 0 then update tempA set OK='no'  where hourId=17;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         hourId,
         count,
         status  )
Select   15                as tableId,
        'nrHourAllocation' as tableName,
         28                as checkNumber,
        'invalid hourId'   as testDescription,
         hourId            as testValue,
         hourId,
         n                 as count,
        'ERROR'            as status
From     tempA
Where    OK <> 'yes';


    --       check no. 029
 insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,    status   )
                    values ( tblNo,   tblName,    29,      'hourFraction', 'unknown' );

drop   table if exists tempA;
create table           tempA
select  'no ' as OK,
         NRHourAllocPatternId,
         count(*) as n,
         sum(hourFraction) as s
from     nrHourAllocation
group by NRHourAllocPatternId;

update tempA set OK='yes' where s>= 0.999 and s<= 1.001;

if Q > 0 then update tempA set OK = 'no' where NRHourAllocPatternId = 26; -- for testing
 end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status  )
Select   15                            as tableId,
        'nrHourAllocation'             as tableName,
         29                            as checkNumber,
        'distribution is out of range' as testDescription,
         s                             as testValue,
         n                             as count,
        'ERROR'                        as status
From     tempA
Where    OK <> 'yes';


  end if;

  INSERT INTO County_Database_Checks  ( tableId, tableName, checkNumber, testDescription,   status     )
                               values ( tblNo,   tblName,   5,          'Table Check',     'Completed' );

--       Table  Check: nrHourAllocation *end*



--       Table  Check: nrretrofitfactors *start*

  set tblNo   = 16;
  set tblName = 'nrretrofitfactors';
  set errMsg  = '';


  insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,        status   )
                     values ( tblNo,   tblName,    101,     'init table check', 'unknown' );

  set    numRows =  ( select table_rows
                      from   information_schema.tables
                      where  table_schema = database()
                        and  table_name   = tblName      );

  if     numRows is null then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status )
                                                 values ( tblNo,   tblName,   tblNo,  'Missing Table',  'ERROR' );
                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status)
                                                           values( tblNo,   tblNAME, 6,  'Missing Table',  'ERROR');
                                                 set nErrors = nErrors+1;
                                                 set errMsg  = 'Missing Table';

  elseif numRows = 0     then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status   )
                                                 values ( tblNo,   tblName,   tblNo,  'Empty Table',    'Warning' );

                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status  )
                                                           values( tblNo,   tblNAME, 6,  'Empty Table',  'WARNING'  );
                                                 set nWarnings = nWarnings + 1;
                                                 set errMsg  = 'Empty Table';

  else                        INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status     )
                                                 values ( tblNo,   tblName,   tblNo,  'Present Table',  'Completed' );

  end if;

  INSERT INTO County_Database_Checks  ( tableId, tableName, checkNumber, testDescription,   status     )
                               values ( tblNo,   tblName,   6,          'Table Check',     'Completed' );

--       Table  Check: nrretrofitfactors *end*





--       Table  Check: nrsourceusetype *start*

  set tblNo   = 17;
  set tblName = 'nrsourceusetype';
  set errMsg  = '';


  insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,        status   )
                     values ( tblNo,   tblName,    101,     'init table check', 'unknown' );

  set    numRows =  ( select table_rows
                      from   information_schema.tables
                      where  table_schema = database()
                        and  table_name   = tblName      );

  if     numRows is null then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status )
                                                 values ( tblNo,   tblName,   tblNo,  'Missing Table',  'ERROR' );
                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status)
                                                           values( tblNo,   tblNAME, 7,  'Missing Table',  'ERROR');
                                                 set nErrors = nErrors+1;
                                                 set errMsg  = 'Missing Table';

  elseif numRows = 0     then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status   )
                                                 values ( tblNo,   tblName,   tblNo,  'Empty Table',    'Warning' );

                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status  )
                                                           values( tblNo,   tblNAME, 7,  'Empty Table',  'WARNING'  );
                                                 set nWarnings = nWarnings + 1;
                                                 set errMsg  = 'Empty Table';

  else                        INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status     )
                                                 values ( tblNo,   tblName,   tblNo,  'Present Table',  'Completed' );
  end if;

  INSERT INTO County_Database_Checks  ( tableId, tableName, checkNumber, testDescription,   status     )
                               values ( tblNo,   tblName,   7,          'Table Check',     'Completed' );





-- --**--
--       Table  Check: nrStateSurrogate *start*
  set tblNo   = 18;
  set tblName = 'nrStateSurrogate';
  set errMsg  = '';


  insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,        status   )
                     values ( tblNo,   tblName,    101,     'init table check', 'unknown' );

  set    numRows =  ( select table_rows
                      from   information_schema.tables
                      where  table_schema = database()
                        and  table_name   = tblName      );

  if     numRows is null then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status )
                                                 values ( tblNo,   tblName,   tblNo,  'Missing Table',  'ERROR' );
                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status)
                                                           values( tblNo,   tblNAME, 8,  'Missing Table',  'ERROR');
                                                 set nErrors = nErrors+1;
                                                 set errMsg  = 'Missing Table';

  elseif numRows = 0     then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status   )
                                                 values ( tblNo,   tblName,   tblNo,  'Empty Table',    'Warning' );

                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status  )
                                                           values( tblNo,   tblNAME, 8,  'Empty Table',  'WARNING'  );
                                                 set nWarnings = nWarnings + 1;
                                                 set errMsg  = 'Empty Table';

  else                        INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,      status     )
                                                 values ( tblNo,   tblName,   tblNo,  'Present Table',  'Completed' );

-- -- check no. 32
--   insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,   status    )
--                      values ( tblNo,   tblName,    32,      'surrogateId', 'checking' );
-- 
-- Drop   table if exists tempA;
-- create table tempA
-- select  'no' as OK,  -- hard code test to pass.
--          surrogateId,
--          stateId,
--          countyId,
--          count(*) as n
-- from     nrStateSurrogate
-- group by surrogateId;
-- 
-- Update tempA as a set a.OK='yes' where (select count(*)
--                                         from   nrSurrogate as b
--                                         where a.surrogateId = b.surrogateId) > 0;
-- 
-- if Q > 0 then update tempA set OK='no' where surrogateId=11; -- for testing
-- end if;
-- 
-- set nErrors = nErrors + (select count(*) from tempA where OK = 'no');
-- 
-- Insert into County_Database_Checks
--        ( tableId,
--          TableName,
--          CheckNumber,
--          TestDescription,
--          testValue,
--          stateId,
--          countyId,
--          count,
--          status  )
-- Select   18                   as tableId,
--         'nrStateSurrogate'    as tableName,
--          32                   as checkNumber,
--         'invalid surrugateId' as testDescription,
--          surrogateId          as testValue,
--          stateId,
--          countyId,
--          n                    as count,
--         'ERROR'               as status
-- From     tempA
-- Where    OK <> 'yes';


-- check no. 33
  insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,   status    )
                     values ( tblNo,   tblName,    33,      'stateId',     'checking' );

Drop   table if exists tempA;
create table tempA
select  'no ' as OK,
         stateId,
         count(*) as n
from     nrStateSurrogate
group by stateId;

Update tempA as a set a.OK='yes' where (select count(*)
                                        from   movesdb20141021.state as b
                                        where a.stateId = b.stateId) > 0;

if Q > 0 then update tempA set OK='no' where stateId=16; -- for testing
end if;

set nErrors = nErrors + (select count(*) from tempA where OK = 'no');

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         stateId,
         count,
         status  )
Select   18                as tableId,
        'nrStateSurrogate' as tableName,
         33                as checkNumber,
        'invalid stateId'  as testDescription,
         stateId           as testValue,
         stateId,
         n                  as count,
        'ERROR'             as status
From     tempA
Where    OK <> 'yes';


-- check no. 34
  insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,   status    )
                     values ( tblNo,   tblName,    34,      'countyId',    'checking' );

Drop   table if exists tempA;
create table tempA
select  'no ' as OK,
         countyId,
         count(*) as n
from     nrStateSurrogate
group by countyId;

Update tempA as a set a.OK='yes' where (select count(*)
                                        from   movesdb20141021.county as b
                                        where a.countyId = b.countyId) > 0;

Update tempA as a set a.OK='yes' where (select count(*)
                                        from   movesdb20141021.state as b
                                        where a.countyId = b.stateId*1000) > 0;

set nErrors = nErrors + (select count(*) from tempA where OK <> 'yes');

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         stateId,
         count,
         status  )
Select   18                as tableId,
        'nrStateSurrogate' as tableName,
         34                as checkNumber,
        'invalid countyId' as testDescription,
         countyId          as testValue,
         countyId,
         n                 as count,
        'ERROR'            as status
From     tempA
Where    OK <> 'yes';


  end if;

  INSERT INTO County_Database_Checks  ( tableId, tableName, checkNumber, testDescription,   status     )
                               values ( tblNo,   tblName,   8,          'Table Check',     'Completed' );

  --       Table  Check: nrStateSurrogate *end*



  --       Table  Check: fuelFormulation *start*

  set tblName = 'fuelFormulation';
  set tblNo   =  19;
  set errMsg  = '';

  set numRows =  ( select table_rows
                  from   information_schema.tables
                  where  table_schema = database()
                    and  table_name = tblName );

  insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,        status   )
                     values ( tblNo,   tblName,    101,     'init table check', 'unknown' );

  if     numRows is null then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,    status )
                                                 values ( tblNo,   tblName,   tblNo,  'Missing Table','Warning' );
                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status)
                                                           values( tblNo,   tblNAME, 9,  'Missing Table',  'ERROR');


  elseif numRows = 0     then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,    status )
                                                 values ( tblNo,   tblName,   tblNo,  'Empty Table',  'Warning' );

                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status  )
                                                           values( tblNo,   tblNAME, 9,  'Empty Table',  'WARNING'  );


  else

  -- checks to be made:
  -- checkNumber  tableId  table                 Field
  --    051       19       fuelFormulation       fuelSubTypeId
  --    052                fuelFormulation       RVP
  --    053                fuelFormulation       sulfurLevel
  --    054                fuelFormulation       ETOHVolume
  --    055                fuelFormulation       MTBEVolume
  --    056                fuelFormulation       fuelFormulationId
  --    057                fuelFormulation       TAMEVolume
  --    058                fuelFormulation       aromaticContent
  --    059                fuelFormulation       olefinContent
  --    060                fuelFormulation       benzeneContent
  --    061                fuelFormulation       e200
  --    062                fuelFormulation       e300
  --    063                fuelFormulation       volToWtPercentOxy
  --    064                fuelformulation       t50

--       check no. 051
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description,     status    )
                   values ( tblNo,  'fuelFormulation', 51,     'fuelSubTypeId', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   fuelSubTypeId,
         fuelFormulationId,
         'no '         as aMatch,
         count(*)      as n
From     fuelFormulation
Group by fuelFormulationId;

Update tempA as a set aMatch='yes' where (Select m.fuelsubtypeId
                                          From   movesdb20141021.nrfuelsubtype as m
                                          Where  a.fuelSubTypeId = m.fuelSubTypeId)>0;

if Q > 0 then update tempA set aMatch='no' where fuelSubTypeId=21;  -- for testing
end if;

Insert into County_Database_Checks
       ( TableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelSubTypeId,
         fuelFormulationId )
Select   tblNo            as tableId,
        "fuelFormulation" as tableName,
         51               as CheckNumber,
        "fuelSubTypeId"   as testDescription,
         fuelSubTypeId    as testValue,
         n                as count,
         'Error'          as status,
         fuelSubTypeId,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


--       check no. 052
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description,  status    )
                   values ( tblNo,  'fuelFormulation', 52,      'RVP',       'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   RVP,
         fuelSubTypeId,
         fuelFormulationId,
         'no '         as aMatch,
         count(*)      as n
From     fuelFormulation
Group by fuelFormulationId;


Update tempA as a set aMatch='yes' where RVP>=5.0 and RVP<=20.0 and fuelSubTypeId     in (10,11,12,13,14,15);
Update tempA as a set aMatch='yes' where                            fuelSubTypeId not in (10,11,12,13,14,15);

if Q > 0 then update tempA set aMatch='no' where fuelSubTypeId=12 and RVP=10;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         fuelSubTypeId,
         fuelFormulationId,
         count,
         status   )
Select   tblNo as tableId,
        'fuelFormulation' as tableName,
         52               as checkNumber,
        'RVP'             as testDescription,
         RVP              as testValue,
         fuelSubtypeId,
         fuelFormulationId,
         n                as count,
        'Error'           as status
From     tempA
Where    aMatch <> 'yes';


--       check no. 053
insert into QA_Checks_Log ( tableId, tableName,        checkNo,  description,   status    )
                   values ( tblNo,  'fuelFormulation', 53,      'sulfurLevel', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   sulfurLevel,
         fuelFormulationId,
         'no '             as aMatch,
         count(*)          as n
From     fuelFormulation
Group by fuelFormulationId;

update tempA as a set aMatch='yes' where sulfurLevel>=0.0 and sulfurLevel<=5000.0;   -- real test

if Q > 0 then update tempa set aMatch ='no' where fuelFormulationId=1787;  -- for testing
end if;

Insert into County_Database_Checks
       ( TableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelFormulationId  )
Select   tblNo              as tableId,
        'fuelFormulation'   as tableName,
         53                 as checkNumber,
        'sulfurLevel'       as testDescription,
         sulfurLevel        as testValue,
         n                  as count,
        'Error'             as status,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


--       check no. 054
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description,   status    )
                   values ( tblNo,  'fuelFormulation', 54,      'ETOHVolume', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   ETOHVolume,
         'no '             as aMatch,
         count(*)          as n,
         fuelsubtypeId,
         fuelFormulationId
From     fuelFormulation
Where    fuelsubtypeId in (10,11,12,13,14,15)   
  and    fuelformulationId >=100                
Group by fuelFormulationId;

Update tempA as a set aMatch='yes' where ETOHVolume>=0.0 and ETOHVolume<=100.0;

if Q > 0 then update tempA set aMatch='no' where fuelFormulationId=1515;   -- for testing
end if;

Insert into County_Database_Checks
       ( TableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelSubTypeId,
         fuelFormulationId  )
Select   tblNo,
        'fuelFormulation' as tableName,
         54,
        'ETOHVolume'      as testDescription,
         ETOHVolume       as testValue,
         n                as count,
        'Error'           as status,
         fuelSubTypeId,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


--       check no. 055
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description,  status    )
                   values ( tblNo,  'fuelFormulation', 55,     'MTBEVolume', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   MTBEVolume,
         'no '         as aMatch,
         count(*)      as n,
         fuelsubtypeId,
         fuelFormulationId
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by fuelFormulationId;

Update tempA as a set aMatch='yes' where MTBEVolume>=0.0 and MTBEVolume<=100.0;

if Q > 0 then update tempA      set aMatch='no'  where fuelsubtypeId=12 and fuelFormulationId=4474;  -- for testing
end if;

Insert into County_Database_Checks
       ( TableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelsubtypeId,
         fuelFormulationId )
Select   tblNo,
        'fuelFormulation' as tableName,
         55,
        'MTBEVolume'      as testDescription,
         MTBEVolume       as testValue,
         n                as count,
        'Error'           as status,
         fuelsubtypeId,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


--       check no. 056
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description,         status    )
                   values ( tblNo,  'fuelFormulation', 56,     'fuelFormulationId', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   fuelFormulationId,
        'no '         as aMatch,
         count(*)     as n,
         ETBEVolume,
         fuelsubtypeId
From     fuelFormulation
Where    fuelsubtypeId in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by fuelFormulationId;

Update tempA as a set aMatch='yes' where ETBEVolume>=0.0 and ETBEVolume<=100.0;

if Q > 0 then update tempA      set aMatch='no'  where fuelsubtypeId=12 and fuelFormulationId=4474;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelFormulationId,
         fuelSubTypeId )
Select   tblNo            as tableId,
        'fuelFormulation' as tableName,
         56               as checkNmber,
        'ETBEVolume'      as testDescription,
         ETBEVolume       as testValue,
         n                as count,
        'Error'           as status,
         fuelFormulationId,
         fuelSubtypeId
From     tempA
Where    aMatch <> 'yes';


--       check no. 057
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description,  status    )
                   values ( tblNo,  'fuelFormulation', 57,     'TAMEVolume', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   TAMEVolume,
         'no '              as aMatch,
         count(*)           as n,
         fuelFormulationId,
         fuelSubtypeid
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100             
Group by fuelFormulationId;

Update tempA as a set aMatch='yes' where TAMEVolume>=0.0 and TAMEVolume<=100.0;

if Q > 0 then update tempA set aMatch='no' where fuelformulationId=3835 and fuelSubTypeId=15;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelFormulationId,
         fuelSubtypeId )
Select   tblNo            as tableId,
        'fuelFormulation' as tableName,
         57               as checkNumber,
         'TAMEVolume'     as testDescription,
         TAMEVolume       as testValue,
         n                as count,
        'Error'           as status,
         fuelFormulationId,
         fuelSubtypeId
From     tempA
Where    aMatch <> 'yes';


--       check no. 058
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description,       status    )
                   values ( tblNo,  'fuelFormulation', 58,     'aromaticContent', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   aromaticContent,
         'no '           as aMatch,
         count(*)        as n,
         fuelsubtypeId,
         fuelFormulationId
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)  
  and    fuelformulationid >=100               
Group by fuelSubTypeId,
         fuelFormulationId;

Update tempA as a set aMatch='yes' where aromaticContent>=0.0 and aromaticContent<=55.0;

if Q > 0 then update tempA set aMatch='no'  where aromaticContent > 19.1999 and aromaticContent < 19.2001;   -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelsubtypeId,
         fuelFormulationId  )
Select   tblNo,
        'fuelFormulation' as tableName,
         58,
        'aromaticContent'  as testDescription,
         aromaticContent   as testValue,
         n                 as count,
        'Error'            as status,
         fuelsubtypeId,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


--       check no. 059
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description,     status    )
                   values ( tblNo,  'fuelFormulation', 59,     'olefinContent', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   olefinContent as olefinContent2,
         'no '           as aMatch,
         count(*)        as n,
         fuelsubtypeId,
         fuelFormulationId
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by olefinContent2,
         fuelSubtypeId,
         fuelFormulationId;

Update tempA as a set aMatch='yes' where olefinContent2>=0.0 and olefinContent2<=25.0;

if Q > 0 then update tempA set aMatch='no' where fuelFormulationId=4747;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count ,
         status,
         fuelFormulationId  )
Select   tblNo            as tableId,
        'fuelFormulation' as tableName,
         59,
        'olefinContent'   as testDescription,
         olefinContent2   as testValue,
         n                as count,
        'Error'           as status,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


--       check no. 060
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description,      status    )
                   values ( tblNo,  'fuelFormulation', 60,     'benzeneContent', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   benzeneContent  as benzeneContent2,
         'no '           as aMatch,
         count(*)        as n,
         fuelSubtypeId,
         fuelFormulationId
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
   and    fuelformulationid >=100
Group by benzeneContent2,
         fuelSubtypeId,
         fuelFormulationId;

Update tempA as a set aMatch='yes' where benzeneContent2>=0.0 and benzeneContent2<=5.0;

if Q > 0 then update tempA set aMatch='no' where fuelFormulationId=4747;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelSubtypeId,
         fuelFormulationId  )
Select   tblNo             as tableId,
        'fuelFormulation'  as tableName,
         60                as checkNumber,
         'benzeneContent'  as testDescription,
         benzeneContent2   as testValue,
         n                 as count,
        'Error'            as status,
         fuelSubtypeId,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


--       check no. 061
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description, status    )
                   values ( tblNo,  'fuelFormulation', 61,     'e200',      'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   e200,
         'no '           as aMatch,
         count(*)        as n,
         fuelSubtypeId,
         fuelFormulationId
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
   and    fuelformulationid >=100            
Group by e200,
         fuelsubtypeId,
         fuelFormulationId;

Update tempA as a set aMatch='yes' where e200>=0.0 and e200<=70.0;

if Q > 0 then update tempA set aMatch='no' where fuelFormulationId=4747;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelSubtypeId,
         fuelFormulationId  )
Select   tblNo            as tableId,
        'fuelFormulation' as tableName,
         61               as checkNumber,
        'e200'            as testDescription,
         e200             as testValue,
         n                as count,
        'Error'           as status,
         fuelSubtypeId,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


--       check no. 062
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description, status    )
                   values ( tblNo,  'fuelFormulation', 62,     'e300',      'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   e300,
         'no '           as aMatch,
         count(*)        as n,
         fUelSubtypeId,
         fuelFormulationId
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100            
Group by e300,
         fuelSuBtypeId,
         fuelFormulationId;

Update tempA as a set aMatch='yes' where e300>=0.0 and e300<=100.0;

if Q > 0 then update tempA set aMatch='no' where fuelFormulationId=4747;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuElSubtypeId,
         fuelFormulationId  )
Select   tblNo            as tableId,
        'fuelFormulation' as tableName,
         62               as checkNumber,
        'e300'            as testDescription,
         e300             as testValue,
         n                as count,
        'Error'           as status,
         fueLSubtypeId,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


--       check no. 063
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description,         status    )
                   values ( tblNo,  'fuelFormulation', 63,     'volToWtPercentOxy', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   volToWtPercentOxy,
         fuelFormulationId,
         'no '             as aMatch,
         count(*)          as n,
         fuelSubtypeId
From     fuelFormulation
Group by volToWtPercentOxy,
         fuelFormulationId;

Update tempA as a set aMatch='yes' where volToWtPercentOxy>=0.0 and volToWtPercentOxy<=1.0
                                      or volToWtPercentOxy is null;

if Q > 0 then update tempA set aMatch='no' where fuelFormulationId = 5370;  -- for testing;
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelformulationId,
         fuelSubtypeId  )
Select   tblNo               as fuelId,
        'fuelFormulation'    as tableName,
         63                  as checkNumber,
         'volToWtPercentOxy' as testDescription,
         volToWtPercentOxy   as testValue,
         n                   as count,
        'Error'              as status,
         fuelformulationId,
         fuelSubtypeId
From     tempA
Where    aMatch <> 'yes';


--       check no. 064
insert into QA_Checks_Log ( tableId, tableName,        checkNo, description, status    )
                   values ( tblNo,  'fuelFormulation', 64,     'e200-T90',  'checking' );

drop   table if exists tempA;
create table           tempA
select   'N'  as aMatch,
         fuelFormulationId,
         fuelSubtypeId,
         e200,
         e300,
         t50,
         t90
from     fuelFormulation
group by fuelFormulationId;

-- update tempA set aMatch='Y' where (e200>0.0 and e300>0.0) or (t50>0.0 and t90>0.0);
update tempA set aMatch='Y'; -- Turned off the check until we can figure out what works.
Insert into County_Database_Checks
        ( tableId,
          TableName,
          checkNumber,
          TestDescription,
          testValue,
          status,
          count,
          fuelFormulationId,
          fuelSubTypeId )
select    tblNo,
         'fuelFormulation',
          64,
         'e200-T90 Missing',
          e200,
         'Error',
          1,
          fuelFormulationId,
          fuelSubTypeId
from tempA
where aMatch<>'Y';

 end if;

 INSERT INTO County_Database_Checks  ( tableId, tableName, checkNumber, testDescription,   status     )
                              values ( tblNo,   tblName,   9,          'Table Check',     'Completed' );

  --       Table  Check: fuelformulation *end*



  --       Table  Check: nrfuelSupply *start*

  set tblName = 'nrFuelSupply';
  set tblNo   = 20;
  set errMsg  = '';

  set numRows = ( select table_rows
                  from   information_schema.tables
                  where  table_schema = database()
                    and  table_name = tblName );

  insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,        status   )
                     values ( tblNo,   tblName,    101,     'init table check', 'unknown' );

  if     numRows is null then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,    status )
                                                 values ( tblNo,   tblName,   tblNo,  'Missing Table','Warning' );
                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status)
                                                           values( tblNo,   tblNAME, 10,  'Missing Table',  'ERROR');



  elseif numRows = 0     then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,    status )
                                                 values ( tblNo,   tblName,   tblNo,  'Empty Table',  'Warning' );

                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status  )
                                                           values( tblNo,   tblNAME, 10,  'Empty Table',  'WARNING'  );


  else

  -- checks to be made:
  -- checkNumber  tableId  table                 Field
  --    071       20       nrfuelSupply          fuelRegionId
  --    072                nrfuelSupply          fuelFormulationId
  --    073                nrfuelSupply          fuelYearId
  --    074                nrfuelSupply          marketShare          distribution
  --    075                nrfuelSupply          monthGroupId


insert into QA_Checks_Log ( tableId, tableName,   checkNo,  description,    status    )
                   values ( tblNo,   tblName,     71,      'fuelRegionId', 'checking' );

--       check no. 071
Drop     table if exists tempA;
Create   table           tempA
Select   fuelRegionId as fuelRegionId,
         'no '        as aMatch,
         count(*)     as n,
         fuelYearId,
         monthGroupId,
         fuelFormulationId
From     nrfuelSupply
Group by fuelRegionId;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   MOVESDB20141021.regionCounty as r
                                          Where  a.fuelRegionId = r.regionId) > 0;

if Q > 0 then update tempA set aMatch='no' where fuelYearId=2011 and monthGroupId=5 and fuelFormulationId=2762;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelYearId,
         monthGroupId,
         fuelFormulationId  )
Select   tblNo,
         tblName,
         71,
        'fuelRegionId',
         fuelRegionId,
         n,
        'Error',
         fuelYearId,
         monthGroupId,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


--       check no. 072
insert into QA_Checks_Log ( tableId, tableName,  checkNo, description,         status    )
                   values ( tblNo,    tblName,   72,     'fuelFormulationId', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   fuelFormulationId,
         'no '             as aMatch,
         count(*)          as n,
         fuelYearId,
         monthGroupId
From     nrfuelSupply
Group by fuelFormulationId,
         fuelYearId,
         monthGroupId;

Update tempA as a set aMatch='yes' where (Select m.fuelFormulationID
                                          From   fuelformulation as m
                                          Where  a.fuelFormulationId = m.fuelFormulationID);

if Q > 0 then update tempA set aMatch='no' where fuelFormulationId=2730 and fuelYearId=2011 and monthGroupId=7;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelYearId,
         monthGroupId )
Select   tblNo              as tableId,
         tblName            as tableName,
         72                 as checkNumber,
        'fuelFormulationId' as testDescription,
         fuelFormulationId  as testValue,
         n                  as count,
        'Error'             as status,
         fuelYearId,
         monthGroupId
From     tempA
Where    aMatch <> 'yes';


--       check no. 073
insert into QA_Checks_Log ( tableId, tableName,  checkNo, description,  status    )
                   values ( tblNo,    tblName,   73,     'fuelYearId', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   fuelYearId,
         'no '      as aMatch,
         count(*)   as n,
         monthGroupId,
         fuelFormulationId
From     nrfuelSupply
Group by fuelYearId,
         monthGroupId,
         fuelFormulationId;

Update tempA as a set aMatch='yes' where (Select m.fuelYearId
                                          From   movesdb20141021.fuelSupplyYear as m
                                          Where  a.fuelYearId = m.fuelYearId);

if Q > 0 then update tempA set aMatch='no' where fuelFormulationId=2730 and fuelYearId=2011 and monthGroupId=7;  -- for testing
end if;

# disabled for calendar years after 2015.
update tempA set aMatch='yes' where fuelYearId>2015;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         monthGroupId,
         fuelFormulationId  )
Select   tblNo,
         tblName      as tableName,
         73,
        "fuelYearId"  as testDescription,
         fuelYearId   as testValue,
         n            as count,
        'Error'       as status,
         monthGroupId,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


--       check no. 074
insert into QA_Checks_Log ( tableId, tableName, checkNo, description,   status    )
                   values ( tblNo,    tblName,  74,     'marketShare', 'checking' );

-- all fuel types:

drop   table tempA;
create table tempA
Select   tblNo                       as tableId,
         tblName                     as tableName,
         74                          as checkNumber,
        'sum of marketShare <> 1.0'  as testDescription,
         sum(marketShare)            as testValue,
        'Error'                      as status,
         count(*)                    as n,
         fuelRegionId,
         ' no'                       as aMatch,
         fuelYearId,
         monthGroupId,
       a.fuelFormulationId,
         fuelTypeId
From     nrfuelSupply                  as a,
         fuelFormulation             as b,
         movesdb20141021.nrfuelsubtype as c
Where    a.fuelFormulationId = b.fuelFormulationId
  and    b.fuelSubTypeId     = c.fuelSubtypeId
Group by fuelRegionId,
         fuelYearId,
         monthGroupId,
         fuelTypeId;

update tempA set aMatch='Yes' where testValue>0.999 and testValue<1.001;

if Q > 0 then update tempA set aMatch='no'  where fuelRegionId=370000000 and fuelYearId=2011 and monthGroupId=1;   -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         tableName,
         checkNumber,
         testDescription,
         testValue,
         status,
         count,
         fuelYearId,
         monthGroupId,
         fuelTypeId,
         fuelFormulationId )
Select   tblNo                       as tableId,
         tblName                     as tableName,
         74                          as checkNumber,
        'sum of marketShare <> 1.0'  as testDescription,
         testValue,
        'Error'                      as status,
         n                           as count,
         fuelYearId,
         monthGroupId,
         fuelTypeId,
         fuelFormulationId
From     tempA
where    aMatch <> 'yes';


--       check no. 075
insert into QA_Checks_Log ( tableId, tableName,  checkNo, description,    status    )
                   values ( tblNo,    tblName,   75,     'monthGroupId', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select  'no '        as aMatch,
         count(*)     as n,
         fuelYearId,
         monthGroupId,
         fuelFormulationId
From     nrfuelSupply
Group by fuelYearId,
         monthGroupId,
         fuelFormulationId;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.monthGroupOfAnyYear as m
                                          Where  a.monthGroupId = m.monthGroupId)>0;

if Q > 0 then update tempA set aMatch='no' where fuelYearId=2011 and monthGroupId=1 and fuelFormulationId=2678;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         fuelYearId,
         monthGroupId,
         fuelFormulationId  )
Select   tblNo         as tableId,
         tblName       as tableName,
         75            as checkNumber,
        'monthGroupId' as testDescription,
         monthGroupId  as testValue,
         n             as count,
        'Error'        as status,
         fuelYearId,
         monthGroupId,
         fuelFormulationId
From     tempA
Where    aMatch <> 'yes';


 end if;

 INSERT INTO County_Database_Checks  ( tableId, tableName, checkNumber, testDescription,   status     )
                              values ( tblNo,   tblName,   10,         'Table Check',     'Completed' );

  --       Table  Check: nrFuelSupply *end*



  --       Table  Check: zoneMonthHour *start*
  set tblName = 'zoneMonthHour';
  set tblNo   = 21;
  set errMsg  = '';

  set numRows = ( select table_rows
                  from   information_schema.tables
                  where  table_schema = database()
                    and  table_name = tblName );

    insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,        status   )
                       values ( tblNo,   tblName,    101,     'init table check', 'unknown' );


  if     numRows is null then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,    status )
                                                 values ( tblNo,   tblName,   tblNo,  'Missing Table','Warning' );
                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status)
                                                           values( tblNo,   tblNAME, 11,  'Missing Table',  'ERROR');


  elseif numRows = 0     then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,    status )
                                                 values ( tblNo,   tblName,   tblNo,  'Empty Table',  'Warning' );

                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status  )
                                                           values( tblNo,   tblNAME, 11,  'Empty Table',  'WARNING'  );


  else


  -- checks to be made:
  -- checkNumber  tableId  table                 Field
  --    081       20       zoneMonthHour         hourId
  --    082                zoneMonthHour         monthId
  --    083                zoneMonthHour         temperature
  --    084                zoneMonthHour         relHumidity
  --    085                zoneMonthHour         zoneId



--       check no. 081
insert into QA_Checks_Log ( tableId, tableName,  checkNo, description,  status    )
                   values ( tblNo,   tblName,    081,    'hourId    ', 'checking' );

Drop     table if exists temp_MoZoHr;  -- month zone hour
Create   table           temp_MoZoHr
Select   monthId,
         zoneId,
         hourId,
         'no '     as aMatch,
         count(*)  as n
From     zoneMonthHour
Group by monthId,
         zoneId,
         hourId;

Update temp_MoZoHr as a set aMatch='yes' where (Select count(*)
                                                  From   movesdb20141021.hourOfAnyDay as m
                                                  Where  a.hourId = m.hourId)>0;

if Q > 0 then update temp_MoZoHr set aMatch='no' where monthId=6 and zoneId=170310 and hourId=12;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         monthId,
         zoneId,
         hourId )
Select   tblNo,
         tblName,
         081,
         'hourId',
         hourId,
         n           as count,
        'Error'      as status,
         monthId,
         zoneId,
         hourId
From     temp_MoZoHr
Where    aMatch <> 'yes';


--       check no. 082
insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,   status    )
                   values ( tblNo,   tblName,    082,     'monthId    ', 'checking' );

Update temp_MoZoHr      set aMatch='no';
Update temp_MoZoHr as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.monthOfAnyYear as m
                                          Where  a.monthId = m.monthId)>0;

if Q > 0 then update temp_MoZoHr set aMatch='no' where monthId=6 and zoneId=170310 and hourId=12;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         monthId,
         zoneId,
         hourId )
Select   tblNo,
         tblName,
         082,
         'monthId',
         monthId,
         n           as count,
        'Error'      as status,
         monthId,
         zoneId,
         hourId
From     temp_MoZoHr
Where    aMatch <> 'yes';


--       check no. 083
insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,   status    )
                   values ( tblNo,    tblName,   083,     'temperature', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   monthId,
         zoneId,
         hourId,
         temperature,
         'no '        as aMatch,
         count(*)     as n
From     zoneMonthHour
Group by monthId,
         zoneId,
         hourId;

Update tempA as a set aMatch='yes' where temperature>=-80.0 and temperature<=150.0;

if Q > 0 then update tempA      set aMatch='no' where monthId=6 and zoneId=170310 and hourId=12;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         monthId,
         zoneId,
         hourId  )
Select   tblNo,
         tblName,
         083,
        'temperature',
         temperature,
         n                  as count,
        'Error',
         monthId,
         zoneId,
         hourId
From     tempA
Where    aMatch <> 'yes';


--       check no. 084
insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,   status    )
                   values ( tblNo,    tblName,   084,     'relHumidity', 'checking' );

Drop     table if exists tempA;
Create   table           tempA
Select   monthId,
         zoneId,
         hourId,
         relHumidity,
         'no '        as aMatch,
         count(*)     as n
From     zoneMonthHour
Group by monthId,
         zoneId,
         hourId;

Update tempA as a set aMatch='yes' where relHumidity>=0.0 and relHumidity<=100.0;

if Q > 0 then update tempA      set aMatch='no' where monthId=6 and zoneId=170310 and hourId=12;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         monthId,
         zoneId,
         hourId  )
Select   tblNo,
         tblName,
         084,
        'relHumidity',
         relHumidity,
         n                  as count,
        'Error',
         monthId,
         zoneId,
         hourId               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 085
insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,  status    )
                   values ( tblNo,    tblName,   085,     'zoneId    ', 'checking' );

Update temp_MoZoHr      set aMatch='no';
Update temp_MoZoHr as a set aMatch='yes' where (Select m.zoneId
                                                 From   movesdb20141021.zone as m
                                                 Where  a.zoneId = m.zoneId);

if Q > 0 then update temp_MoZoHr set aMatch='no' where monthId=6 and zoneId=170310 and hourId=12;  -- for testing
end if;

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         monthId,
         zoneId,
         hourId )
Select   tblNo,
         tblName,
         085,
        'zoneId',
         zoneId,
         n           as count,
        'Error'      as status,
         monthId,
         zoneId,
         hourId
From     temp_MoZoHr
Where    aMatch <> 'yes';

drop table temp_MoZoHr;

  end if;

  INSERT INTO County_Database_Checks  ( tableId, tableName, checkNumber, testDescription,   status     )
                               values ( tblNo,   tblName,   11,         'Table Check',     'Completed' );

  --       Table  Check: zoneMonthHour *end*


  --       Table  Check: nrGrowthIndex *start*

  set tblName = 'nrgrowthIndex';
  set tblNo   = 22;
  set errMsg  = '';

  set numRows = ( select table_rows
                  from   information_schema.tables
                  where  table_schema = database()
                    and  table_name = tblName );

    insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,        status   )
                       values ( tblNo,   tblName,    101,     'init table check', 'unknown' );


  if     numRows is null then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,    status )
                                                 values ( tblNo,   tblName,   tblNo,  'Missing Table','Warning' );
                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status)
                                                           values( tblNo,   tblNAME, 11,  'Missing Table',  'ERROR');


  elseif numRows = 0     then INSERT INTO QA_Checks_Log ( tableId, tableName, checkNo, description,    status )
                                                 values ( tblNo,   tblName,   tblNo,  'Empty Table',  'Warning' );

                               Insert into County_Database_Checks( tableId, TableName, checkNumber, testDescription,  status  )
                                                           values( tblNo,   tblNAME, 11,  'Empty Table',  'WARNING'  );


  else

--       check no. 086
insert into QA_Checks_Log ( tableId, tableName,  checkNo,  description,  status    )
                   values ( tblNo,    tblName,   86,      'yearId    ', 'checking' );


drop   table if exists tempA;
create table           tempA
select   'no '    as OK,
         yearId,
         count(*) as n
from     nrGrowthIndex
group by yearId;


update tempA as a set OK = 'yes' where (select count(*)
                                        from movesdb20141021.year as b
                                        where a.yearId=b.yearId) > 0;

update tempA set OK = 'yes';  -- see djb for explanation

Insert into County_Database_Checks
       ( tableId,
         TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         status,
         yearId )
Select   tblNo              as tableId,
         tblName            as tableName,
         86                 as checkNumber,
        'yearId is invalid' as testDescription,
         yearId             as testValue,
         n                  as count,
        'ERROR'             as status,
         yearId
From     tempA
Where    OK <> 'yes';


  end if;

  INSERT INTO County_Database_Checks  ( tableId, tableName, checkNumber, testDescription,   status     )
                               values ( tblNo,   tblName,   12,         'Table Check',     'Completed' );

  --       Table  Check: nrGrowthIndex *end*












-- Report Wrap-up:



Update  County_Database_Checks set status       = 'ERROR'   where testDescription = 'Missing Table';
Update  County_Database_Checks set status       = 'Warning' where testDescription = 'Empty Table';

        set dataBaseName = (select database());
Update  County_Database_Checks set countyId     = mid( dataBaseName, 2, 5 );


Update  County_Database_Checks set msgDate      = curDate();
Update  County_Database_Checks set msgTime      = curTime();

Update  County_Database_Checks set versionDate  = @hdate;


-- select '  ..   End of Nonroad Checks', nErrors, nWarnings;


END;
$$

delimiter ;

call QA_NDB_2014_v5();

-- Final summary:

set @nErrors   = 0;
set @nWarnings = 0;
set @nErrors = ( select count(*)
                      from   County_Database_Checks
                      where  status="ERROR" );
set @nWarnings = ( select count(*)
                      from   County_Database_Checks
                      where  status="Warning" );

select '  ..   End of Nonroad Checks', @nErrors, @nWarnings;

-- -------------------------------------------------------------------------------------------
-- Store results from multiple runs.
-- -------------------------------------------------------------------------------------------

create Database if not exists All_NRCDB_Checks;

-- drop table All_NRCDB_Checks.All_County_Database_Checks;

create Table    if not exists All_NRCDB_Checks.All_County_Database_Checks
like County_Database_Checks;


Insert into All_NRCDB_Checks.All_County_Database_Checks
Select * from                    County_Database_Checks;

flush tables;

-- the end --


