# CreateAndPopulateamazonDirStructureSmokeMovesNei2014_20160630.plx


# PROJECT
$project='nei2014';
$zmhproj='nei2014';
$amazondir='C:\\epa\\moves\\amazon20130603';
$year=2014;
$vers=20160719;
$repcdblist="296RepCos2014_20160630.txt";
#$scen='ctl';
# CASE
#$case="$project$year$scen";  # for when the case includes a scen & year
$case="$project";  # for when the case does not include a scen & year
$casevers="${case}_$vers";
$casepath="P:\\EPA_MOVES_4-04\\$project\\AmazonStructure\\$casevers";
$casedbs="$casepath\\databases_$casevers";
$dbdir="P:\\EPA_MOVES_4-04\\$project\\InputDatabases";
$runspecgenyear=2014;  # This can be different from $year
$fuelsdb='M2014a_fuelsupply';
#$vmtpopagedb='nationaldefaultvmtpop_20120410';
$cdbdir="P:\\EPA_MOVES_4-04\\$project\\InputDatabases\\2014NEIv1_296repCDBs_06302016";
# MOVES driver output
# The runspecs have same names as the base year+significant editing below.
# Zonemonthhour is the same as base year.
$zmhoutput="P:\\EPA_MOVES_4-04\\nei2014\\SmokeMovesRunSpecGenerator_nei2014\\nei2014_zmh";
$rdrunspectemplate='samplerunspecs\\RDCB05CB6NEI_2014.mrs';
$rprunspectemplate='samplerunspecs\\RPCB05CB6NEI_2014.mrs';
$rvrunspectemplate='samplerunspecs\\RVCB05CB6NEI_2014.mrs';
#$ppblock="CB05";
#$fuelvehblock="DiesGasE85CNG_Veh.txt";
#$outputemissionsbreakdownselectionblock="outputemissionsbreakdownselection.txt";
print "project = $project\n";
print "amazondir = $amazondir\n";
print "dbdir = $dbdir\n";
#print "scen = $scen\n";
print "year = $year\n";
print "runspecgenyear = $runspecgenyear\n";
print "vers = $vers\n";
print "fuelsdb = $fuelsdb\n";
print "repcdblist = $repcdblist\n";
print "cdbdir = $cdbdir\n";
print "case = $case\n";
print "casevers = $casevers\n";
print "casepath = $casepath\n";
print "casedbs = $casedbs\n";
print "zmhoutput = $zmhoutput\n";
print "rdrunspectemplate = $rdrunspectemplate\n";
print "rprunspectemplate = $rprunspectemplate\n";
print "rvrunspectemplate = $rvrunspectemplate\n";
#print "ppblock = $ppblock\n";
#print "fuelvehblock = $fuelvehblock\n";
#print "outputemissionsbreakdownselection = $outputemissionsbreakdownselectionblock\n";

`mkdir $casepath`;
`mkdir $casedbs"`;

# COPY CASE-LEVEL DATABASES
foreach $xxx(
"$dbdir $fuelsdb",
"$dbdir regioncountytrnoda_20151203",
"$dbdir\\LEV lev_06_20140903",
"$dbdir\\LEV lev_09_20140903",
"$dbdir\\LEV lev_10_20140903",
"$dbdir\\LEV lev_11_20140903",
"$dbdir\\LEV lev_23_20140903",
"$dbdir\\LEV lev_24_20140903",
"$dbdir\\LEV lev_25_20140903",
"$dbdir\\LEV lev_33_20140903",
"$dbdir\\LEV lev_34_20140903",
"$dbdir\\LEV lev_36_20140903",
"$dbdir\\LEV lev_41_20140903",
"$dbdir\\LEV lev_42_20140903",
"$dbdir\\LEV lev_44_20140903",
"$dbdir\\LEV lev_50_20140903",
"$dbdir\\LEV lev_51_20140903",
"$dbdir\\LEV lev_53_20140903",
#"$dbdir\\VMT_VPOP c01000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c04000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c05000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c06000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c08000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c12000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c18000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c19000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c20000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c21000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c22000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c28000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c30000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c31000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c32000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c35000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c36000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c38000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c39000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c40000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c41000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c46000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c47000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c48000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c54000y2011_M14_20140728",
#"$dbdir\\VMT_VPOP c56000y2011_M14_20140728",
){
($dbpath,$db)=split(/ /,$xxx);
print "dbpath = $dbpath\n";
print "db = $db\n";
print "Case-level DB = $db\n";
	if (-d "$casedbs\\$db") {
		print 'Line '.__LINE__.". DB $db already exists; not copied.\n";
	} else {
	# Include only mysql tables by specifying the extensions
	`xcopy $dbpath\\$db\\*.frm $casedbs\\$db /I/S/Y/D/Q`;
	`xcopy $dbpath\\$db\\*.MYD $casedbs\\$db /I/S/Y/D/Q`;
	`xcopy $dbpath\\$db\\*.MYI $casedbs\\$db /I/S/Y/D/Q`;
	}
}

# COUNTY
$cntycount=0;
open(cdb1,"$repcdblist");
foreach $xxx(<cdb1>)
{
if(substr($xxx,0,1) eq '#'){next;}
$cntycount=$cntycount+1;
print "cntycount = $cntycount\n";
#if($cntycount>1){last;}  # Limit to one county for diagnostics
if(substr($xxx,0,1) eq '#'){next;}
#($cnty,$cdbvers,$janrvpbin,$julrvpbin)=split(/ /,$xxx);
($cnty,$cdbvers)=split(/ /,$xxx);
chomp($cnty);
chomp($cdbvers);
# COUNTY DATABASE:
$cdb="c${cnty}y${year}_$cdbvers";		
$state=substr($cnty,0,2);
print "cnty = $cnty\n";
print "cdbvers = $cdbvers\n";
print "cdb = $cdb\n";
print "state = $state\n";
$monthcount=0;
foreach $month(
	'1',
	'7',
){
$monthcount=$monthcount+1;
#if($monthcount>1){last;}  # Diagnostic limit to one month
print "month = $month\n";
#if($month==1){$rvpbin=$janrvpbin}
#elsif($month==7){$rvpbin=$julrvpbin}
$batchzmh="${case}_${cnty}_$month";  # Normally OK
#$batchzmh="nei2011v2_${cnty}_$month";  
#$batchzmh="2007pfbase2007_${cnty}_$month";  # Needed for 2007PF

$batch="${casevers}_${cnty}_$month";
$batchpath="$casepath\\$batch";
$batchdbs="$batchpath\\databases";
print "month = $month\n";
#print "rvpbin = $rvpbin\n";
print "batchzmh = $batchzmh\n";
print "batch = $batch\n";
print "batchpath = $batchpath\n";
print "batchdbs = $batchdbs\n";
# Create folder batchpath and transfer batch-specific databases.  
# Create folder batchdatabases and transfer batch-specific databases.  
#   Commented out if already done.
`md $batchpath`;
`md $batchdbs`;
	# LEV
	$lev=0;
	foreach $st(
		'06','09','10','11','23','24','25','33','34','36','41','42','44','50','51','53',
		){
		if($state eq $st){$lev=1;}
	}
	# STATE-WIDE VMT AND POP
	$stvmtpop=0;
	foreach $st('01','04','05','06','08','12','18','19','20','21','22','28','30','31',
		'32','35','36','38','39','40','41','46','47','48','54','56',
		){
		if($state eq $st){$stvmtpop=1;}
	}
	
# COPY BATCH COUNTY-LEVEL DATABASES
if (-d "$batchdbs\\$cdb") {
	print 'Line '.__LINE__.". DB $cdb already exists; not copied.\n";
} else {
	`xcopy $cdbdir\\$cdb $batchdbs\\$cdb /I/S/Y/D/Q`;
}

# JOB
$jobcount=0;
$zmhpath="$zmhoutput\\${zmhproj}_${cnty}_${month}";
print "zmhpath = $zmhpath\n";
foreach $zmhdb (`dir /b $zmhpath`)
{
	print "zmhdb = $zmhdb\n";
	$jobcount=$jobcount+1;
	#if($jobcount>1){last;}  # Limit to one job for diagnostics
	chomp($zmhdb);
	$zmhdb=lc($zmhdb);  # Convert to lower case
	$ratetype=substr($zmhdb,0,2);
	print "ratetype = $ratetype\n";
	# DETERMINE THE NUMBER OF HOURS NEEDED IN RD RUNSPECS
	#  The reason for this is to not repeat temperatures unnecessarily.
	if($ratetype eq 'rd'){
		($a1,$a2,$a3,$a4,$tlow,$thigh,$a7)=split(/_/,$zmhdb);	
		# Eliminate initial t or tn
		if(substr($tlow,0,2) eq 'tn'){
			$tlow=substr($tlow,2,10); # Eliminate inital tn
			$tlow=-1.*$tlow; # Re-establish sign
		} else {$tlow=substr($tlow,1,10);}  # Eliminate initial t
		$rdendhour=($thigh-$tlow)/5+1;
		print "thigh, tlow, rdendhour = $thigh, $tlow, $rdendhour\n";
		$runspectemplate=$rdrunspectemplate;
	} elsif($ratetype eq 'rv') {$runspectemplate=$rvrunspectemplate;}
	elsif($ratetype eq 'rp') {$runspectemplate=$rprunspectemplate;}
	else {die "Unknown ratetype $ratetype\n";}
	# Peel off the trailing _zmh:
	# Make job lower case and substitute tn for t-
	$job05=substr($zmhdb,0,-4);
	$job05=lc($job05);
	$_=$job05;
	s/t-/tn/;
	$job05=$_;
	s/_${runspecgenyear}_/_${year}_/;
	$job=$_;
	$jobpath="$batchpath\\$job";
	print "zmhdb = $zmhdb\n";
	print "job05 = $job05\n";
	print "jobpath = $jobpath\n";
	`md $jobpath`;
	# Create jobdatabases folder and copy jobdatabases
	`md $jobpath\\databases`;
	`xcopy $zmhoutput\\$batchzmh\\$zmhdb $jobpath\\databases\\$zmhdb /I/S/Y/D/Q`;
# EDIT RUNSPECS INTO APPROPRIATE DIRECTORY
# Input database name has been commented out for increased flexibility.
#  It is blank in the moves driver script output, and 
#  we could change the database without having to re-jar the job.
	if (-f "$jobpath\\$job.mrs") {
		print "runspec $jobpath\\$job.mrs already exists.\n";
	} else {
	open (in1,"$runspectemplate");
	open (out1,">$jobpath\\$job.mrs");
	$inpp=0; # inside pollutantprocessassociations block
	$inveh=0; # inside onroadvehicleselections block
	while (<in1>) {
		# ADD <models> UNTIL UNC CHANGES RUNSPEC_GENERATOR
#		if (m/<\/description>/){
#			print out1;
#			print out1 "	<models>\n";
#			print out1 "		<model value=\"ONROAD\"/>\n";
#			print out1 "	</models>\n";
#		}
		# REPLACE POLLUTANTPROCESSASSOCIATIONS BLOCK -- now in runspectemplate
#		if (m/<pollutantprocessassociations>/){
#			print out1;
#			$inpp=1;
#			open(rt1,"samplerunspecs/${ratetype}_${ppblock}_PP.txt");
#			while(<rt1>){print out1}; 
#			close(rt1);
#			next;
#		}
#		if (m/<\/pollutantprocessassociations>/){
#			$inpp=0;
#			print out1;
#			next;
#		}
#		if ($inpp) {next;}
		# REPLACE ONROADVEHICLSELECTIONS BLOCK -- now in runspectemplate
#		if (m/<onroadvehicleselections>/){
#			print out1;
#			$inveh=1;
#			open(rt1,"samplerunspecs/$fuelvehblock");
#			while(<rt1>){print out1}; 
#			close(rt1);
#			next;
#		}
#		if (m/<\/onroadvehicleselections>/){
#			$inveh=0;
#			print out1;
#			next;
#		}
#		if ($inveh) {next;}
		# REPLACE outputemissionsbreakdownselection BLOCK -- now in runspectemplate
#		if (m/<outputemissionsbreakdownselection>/){
#			print out1;
#			$inoebs=1;
#			open(rt1,"samplerunspecs/$outputemissionsbreakdownselectionblock");
#			while(<rt1>){print out1}; 
#			close(rt1);
#			next;
#		}
#		if (m/<\/outputemissionsbreakdownselection>/){
#			$inoebs=0;
#			print out1;
#			next;
#		}
#		if ($inoebs) {next;}
		# SET COUNTY
		if (m/geographicselection type="COUNTY"/){
			s/<geographicselection type.*$/<geographicselection type="COUNTY" key="$cnty" description=""\/>/;
		}
		# SET MONTH
		 	if (m/month id="1"/){
			s/1/$month/;
		}
		# SET CDB
		if (m/scaleinputdatabase/){
			s/databasename=".*description/databasename="$cdb" description/;
		}
#		s/year key="${runspecgenyear}"/year key="$year"/;
#		s/for MOVES2010/v0.31_29Mar12/;
		if($ratetype eq 'rd'){
			s/endhour id="24"/endhour id="$rdendhour"/;
		}
		if (m/outputdatabase/){
			s/databasename=".*description/databasename="standardoutput" description/;
		}
		if (m/scenarioid/){
			s/scenarioid=".*"/scenarioid="$job"/;
		}
		# Replace databaseselections block
		if (m/<databaseselections>/){
			print out1; 
			$indbs=1;
			# zonemonthhour
			print out1 "		<databaseselection servername=\"\" databasename=\"$zmhdb\" description=\"\"/>\n";
			# fuelsdb
			if ($fuelsdb ne ''){
				print out1 "		<databaseselection servername=\"\" databasename=\"$fuelsdb\" description=\"\"/>\n";
			}
			# LEV
			if ($lev==1){
				print out1 "		<databaseselection servername=\"\" databasename=\"lev_${state}_20140903\" description=\"\"/>\n";
			}
			# GFRE Table
			print out1 "		<databaseselection servername=\"\" databasename=\"regioncountytrnoda_20151203\" description=\"\"/>\n";
			# State vmt and pop tables
			# RESTORE 3 LINES BELOW TO ACTIVE STVMTPOP DBs
			#if ($stvmtpop==1){
			#	print out1 "		<databaseselection servername=\"\" databasename=\"c${state}000y${year}_M14_20140728\" description=\"\"/>\n";
			#}
			next; # Go to next line without printing if still in databaseselections
		}
		if (m/<\/databaseselections>/){
			$indbs=0;
			print out1;
			next;
		}
		if ($indbs) {next;} # Go to next line without printing if still in databaseselections
		print out1;
	}
	close(in1);
	close(out1);
	} # ELSE
} # JOB
# JARJOBS FOR EACH BATCH
open(out2,">jarjobs.bat");
print out2 "call pushd $amazondir\n";
print out2 "call setenv\n";
print out2 "call ant -Dcmd=\"jarjobs batchdir $batchpath\" job\n";
print out2 "call popd\n";
close(out2);
`call jarjobs.bat`;
} # COUNTY
} # MONTH
close(cdb1);

