# ------------------------------------------------------------------------------
# -------- Populate CDB Script -------------------------------------------------
# ------------------------------------------------------------------------------
# ------------------------------------------------------------------------------
# -------- This script uses the information in the VMT, VPOP and HOT FF10 files
# -------- and copies it into the appropriate tables of the associated CDBs.
# ------------------------------------------------------------------------------
# djb June 17, 2016
use CDBPLACEHOLDER;

-- Create VMT tables, if needed
create table if not exists HPMSVTypeYear like movesdb20151028.HPMSVTypeYear;
create table if not exists HPMSVTypeDay like movesdb20151028.HPMSVTypeDay;
create table if not exists sourceTypeYearVMT like movesdb20151028.sourceTypeYearVMT;
create table if not exists sourceTypeDayVMT like movesdb20151028.sourceTypeDayVMT;

-- eliminate existing VMT data.
truncate hpmsvtypeyear;
truncate hpmsvtypeday;
truncate sourcetypeyearvmt;
truncate sourcetypedayvmt;

-- populate the sourcetypeyearvmt table with FF10 data.
insert into sourcetypeyearvmt (yearid,sourcetypeid,vmt)
select calc_year as yearid,  
	   mid(scc,5,2) as sourcetypeid,
       sum(ann_value) as vmt
from ff10data.vmtff10 as a,
     county as b
where a.region_cd=b.countyid
group by mid(scc,5,2);

-- eliminate existing population data.
truncate sourcetypeyear;

-- populate the sourcetypeyear table with FF10 data.
insert into sourcetypeyear (yearid,sourcetypeid,sourcetypepopulation)
select calc_year as yearid,
       mid(scc,5,2) as sourcetypeid,
       sum(ann_value) as sourcetypepopulation
from ff10data.popff10 as a,
     county as b
where a.region_cd=b.countyid
group by mid(scc,5,2);
