﻿
-- known as QA_Checks_2014_v7.sql
-- based on QA_Checks_v11.sql
--   for:  MOVES2014 based CDBs
-- using:  movesdb20141021 default database

set @hVersion = '20151217';

select '  .. QA_Checks_2014_v7.sql',curTime(), database();


-- version 2 has the new check, check no 470, checking the table imCoverage,
-- comparing the counts of fuelTypeIds 1 and 5
-- if their counts are different a warning is issued.
-- version 3 limits check 405 to only roadtypeid in (1,2,3,4,5).
-- version 4 allows a range of values for the sum of the fuelengfraction sum (Check #9)
-- and allows Check #428 fuelusagefraction for E85 to work properly.
-- version 5 updates check no 470 so that it does not generate in appropriate warnings.
-- version 5 eliminates the spurious warnings for the day and hour vmt tables.
-- version 7 eliminates the checks on calendar years and model years in the onroadretrofit table.


drop table if exists County_Database_Checks;
CREATE TABLE
   County_Database_Checks
 (
   countyID          int(11),
   status            char(20),
   tableName         char(100),
   checkNumber       smallint(6),
   testDescription   char(250),
   testValue         double,
   count             int(11),
   dataBaseName      char(100),
   dayID             smallint(6),
   fuelFormulationID smallint(6),
   fuelTypeId        smallint(6),
   fuelSubtypeID     smallint(6),
   fuelYearID        smallint(6),
   hourDayID         smallint(6),
   hourID            smallint(6),
   HPMSVtypeID       smallint(6),
   monthGroupID      smallint(6),
   monthID           smallint(6),
   roadTypeID        smallint(6),
   sourceTypeID      smallint(6),
   stateID           smallint(6),
   yearID            smallint(6),
   zoneID            int(11),
   msgType           char(50),
   msgDate           date,
   msgTime           time,
   version           char(8),
   sumKeyID          int(11),
   sumKeyDescription char(50)
 ) ENGINE=MyISAM DEFAULT CHARSET=latin1;


drop table if exists QA_Checks_Log;
create table
  QA_Checks_Log
  (
    checkNo    int(11),
    status     char(20),
    version    char(8),
    msgDate    date,
    msgTime    time
  ) ENGINE=MyISAM DEFAULT CHARSET=latin1;



Insert into County_Database_Checks set tableName = 'auditLog';
Insert into County_Database_Checks set tableName = 'avft';
Insert into County_Database_Checks set tableName = 'avgSpeedDistribution';
Insert into County_Database_Checks set tableName = 'county';
Insert into County_Database_Checks set tableName = 'countyYear';

Insert into County_Database_Checks set tableName = 'dayVmtFraction';
Insert into County_Database_Checks set tableName = 'EmissionRateByAge';
Insert into County_Database_Checks set tableName = 'fuelFormulation';
Insert into County_Database_Checks set tableName = 'fuelSupply';
Insert into County_Database_Checks set tableName = 'fuelSupplyYear';

Insert into County_Database_Checks set tableName = 'hourVmtFraction';
Insert into County_Database_Checks set tableName = 'hpmsVTypeYear';
Insert into County_Database_Checks set tableName = 'imCoverage';
Insert into County_Database_Checks set tableName = 'monthVmtFraction';
Insert into County_Database_Checks set tableName = 'roadType';

Insert into County_Database_Checks set tableName = 'roadTypeDistribution';
Insert into County_Database_Checks set tableName = 'sourceTypeAgeDistribution';
Insert into County_Database_Checks set tableName = 'sourceTypeYear';
Insert into County_Database_Checks set tableName = 'state';

Insert into County_Database_Checks set tableName = 'year';
Insert into County_Database_Checks set tableName = 'zoneMonthHour';
Insert into County_Database_Checks set tableName = 'zone';
Insert into County_Database_Checks set tableName = 'zoneRoadType';    -- fixed, exactly 24 rows


Insert into County_Database_Checks set tableName = 'fuelUsageFraction';
Insert into County_Database_Checks set tableName = 'hotellingActivityDistribution';
Insert into County_Database_Checks set tableName = 'hotellingHours';
Insert into County_Database_Checks set tableName = 'importStartsOpModeDistribution';
Insert into County_Database_Checks set tableName = 'onRoadRetroFit';
Insert into County_Database_Checks set tableName = 'starts';
Insert into County_Database_Checks set tableName = 'startsHourFraction';
Insert into County_Database_Checks set tableName = 'startsMonthAdjust';
Insert into County_Database_Checks set tableName = 'startsPerDay';
Insert into County_Database_Checks set tableName = 'StartsSourceTypeFraction';


Update      County_Database_Checks set msgType   = 'Table Check';
Update      County_Database_Checks set msgDate   = curDate();
Update      County_Database_Checks set msgTime   = curTime();


Drop   table if exists tempB;
Create table           tempB
select distinct
       table_Name as TableName,
       table_rows
from   information_schema.TABLES
where  TABLE_SCHEMA = (select database())
  and  TABLE_ROWS >= 0
  and  Table_Name in ( 'auditlog',
                       'avft',
                       'avgSpeedDistribution',
                       'county',
                       'countyYear',

                       'dayVmtFraction',
                       'EmissionRateByAge',
                       'fuelFormulation',
                       'fuelSupply',
                       'fuelSupplyYear',

                       'hourVmtFraction',
                       'hpmsVTypeYear',
                       'imCoverage',
                       'monthVmtFraction',
                       'roadType',

                       'roadTypeDistribution',
                       'sourceTypeAgeDistribution',
                       'sourceTypeYear',
                       'state',

                       'year',
                       'zone',
                       'zoneMonthHour',
                       'zoneRoadType',    -- 24 -- not fixed, up to 24 table names

                       'fuelUsageFraction',
                       'hotellingActivityDistribution',
                       'hotellingHours',
                       'importStartsOpModeDistribution',
                       'onRoadRetroFit',
                       'starts',
                       'startsHourFraction',
                       'startsMonthAdjust',
                       'startsPerDay',
                       'StartsSourceTypeFraction'
                     );



Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'auditLog'
                                                                            and  b.TableName = 'auditLog';               -- update  0

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'avft'
                                                                            and  b.TableName = 'avft';                   -- update  1

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'avgSpeedDistribution'
                                                                            and  b.TableName = 'avgSpeedDistribution';   -- update  2

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'county'
                                                                            and  b.TableName = 'county';                 -- update  3

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'countyYear'
                                                                            and  b.TableName = 'countyYear';             -- update  4

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'dayVmtFraction'
                                                                            and  b.TableName = 'dayVmtFraction';         -- update  5


Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'emissionRateByAge'
                                                                            and  b.TableName = 'emissionRateByAge';      -- update  6

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'fuelFormulation'
                                                                            and  b.TableName = 'fuelFormulation';        -- update  7

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'fuelSupply'
                                                                            and  b.TableName = 'fuelSupply';             -- update  8

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'fuelSupplyYear'
                                                                            and  b.TableName = 'fuelSupplyYear';         -- update  9

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'hourVmtFraction'
                                                                            and  b.TableName = 'hourVmtFraction';        -- update  10


Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'hpmsVTypeYear'
                                                                            and  b.TableName = 'hpmsVTypeYear';          -- update  11

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'imCoverage'
                                                                            and  b.TableName = 'imCoverage';             -- update  12

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'monthVmtFraction'
                                                                            and  b.TableName = 'monthVmtFraction';       -- update  13

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'roadType'
                                                                            and  b.TableName = 'roadType';               -- update  14

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'roadTypeDistribution'
                                                                            and  b.TableName = 'roadTypeDistribution';   -- update  15

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'sourceTypeAgeDistribution'
                                                                            and  b.TableName = 'sourceTypeAgeDistribution'; -- update  17

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'sourceTypeYear'
                                                                            and  b.TableName = 'sourceTypeYear';            -- update  18

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'state'
                                                                            and  b.TableName = 'state';                     -- update  19

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'year'
                                                                            and  b.TableName = 'year';                      -- update  20

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'zone'
                                                                            and  b.TableName = 'zone';                      -- update  21

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'zoneMonthHour'
                                                                            and  b.TableName = 'zoneMonthHour';             -- update  22

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'zoneRoadType'
                                                                            and  b.TableName = 'zoneRoadType';              -- update  23


Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'fuelUsageFraction'
                                                                            and  b.TableName = 'fuelUsageFraction';              -- 24

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'hotellingActivityDistribution'
                                                                            and  b.TableName = 'hotellingActivityDistribution';  -- 25

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'hotellingHours'
                                                                            and  b.TableName = 'hotellingHours';                 -- 26

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'importStartsOpModeDistribution'
                                                                            and  b.TableName = 'importStartsOpModeDistribution'; -- 27

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'onRoadRetroFit'
                                                                            and  b.TableName = 'onRoadRetroFit';                 -- 28

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'starts'
                                                                            and  b.TableName = 'starts';                         -- 29

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'startsHourFraction'
                                                                            and  b.TableName = 'startsHourFraction';              -- 30

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'startsMonthAdjust'
                                                                            and  b.TableName = 'startsMonthAdjust';              -- 31

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'startsPerDay'
                                                                            and  b.TableName = 'startsPerDay';                   -- 32

Update County_Database_Checks as a, tempb as b set a.count = b.table_rows Where  a.tableName = 'StartsSourceTypeFraction'
                                                                            and  b.TableName = 'StartsSourceTypeFraction';        -- 33


Update County_Database_Checks set testDescription = 'Present'       where count is not null;
Update County_Database_Checks set testDescription = 'Table Missing' where count is     null;

Update County_Database_Checks set status          = 'ERROR'         where count is     null;


Delete from County_Database_Checks where count is not null;


-- ----------------------------------------------------------------------------------------
-- Create missing tables to keep error-checking code from crashing-------------------------
-- ----------------------------------------------------------------------------------------


-- auditlog
CREATE TABLE IF NOT EXISTS `auditlog` (
  `whenHappened`     datetime          NOT NULL,
  `importerName`     varchar(100)      NOT NULL,
  `briefDescription` varchar(100)  DEFAULT NULL,
  `fullDescription`  varchar(4096) DEFAULT NULL,
  KEY `logByDate`     (`whenHappened`),
  KEY `logByImporter` (`importerName`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- avft
CREATE TABLE IF NOT EXISTS `avft` (
  `sourceTypeID` smallint(6) NOT NULL,
  `modelYearID` smallint(6) NOT NULL,
  `fuelTypeID` smallint(6) NOT NULL,
  `engTechID` smallint(6) NOT NULL,
  `fuelEngFraction` double NOT NULL,
  PRIMARY KEY (`sourceTypeID`,`modelYearID`,`fuelTypeID`,`engTechID`),
  KEY `sourceTypeID` (`sourceTypeID`),
  KEY `modelYearID` (`modelYearID`),
  KEY `fuelTypeID` (`fuelTypeID`),
  KEY `engTechID` (`engTechID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- avgspeeddistribution
CREATE TABLE IF NOT EXISTS `avgspeeddistribution` (
  `sourceTypeID` smallint(6) NOT NULL DEFAULT '0',
  `roadTypeID` smallint(6) NOT NULL DEFAULT '0',
  `hourDayID` smallint(6) NOT NULL DEFAULT '0',
  `avgSpeedBinID` smallint(6) NOT NULL DEFAULT '0',
  `avgSpeedFraction` float DEFAULT NULL,
  PRIMARY KEY (`avgSpeedBinID`,`hourDayID`,`roadTypeID`,`sourceTypeID`),
  KEY `sourceTypeID` (`sourceTypeID`),
  KEY `roadTypeID` (`roadTypeID`),
  KEY `hourDayID` (`hourDayID`),
  KEY `avgSpeedBinID` (`avgSpeedBinID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- county
CREATE TABLE IF NOT EXISTS `county` (
  `countyID` int(11) NOT NULL DEFAULT '0',
  `stateID` smallint(6) NOT NULL DEFAULT '0',
  `countyName` char(50) DEFAULT NULL,
  `altitude` char(1) DEFAULT NULL,
  `GPAFract` float DEFAULT NULL,
  `barometricPressure` float DEFAULT NULL,
  `barometricPressureCV` float DEFAULT NULL,
  PRIMARY KEY (`countyID`),
  KEY `countyID` (`countyID`,`stateID`),
  KEY `stateID` (`stateID`,`countyID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- countyyear
CREATE TABLE IF NOT EXISTS `countyyear` (
  `countyID` int(11) NOT NULL DEFAULT '0',
  `yearID` smallint(6) NOT NULL DEFAULT '0',
  `refuelingVaporProgramAdjust` float NOT NULL DEFAULT '0',
  `refuelingSpillProgramAdjust` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`countyID`,`yearID`),
  KEY `countyID` (`countyID`),
  KEY `yearID` (`yearID`),
  KEY `yearID_2` (`yearID`,`countyID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- dayvmtfraction
CREATE TABLE IF NOT EXISTS `dayvmtfraction` (
  `sourceTypeID` smallint(6) NOT NULL DEFAULT '0',
  `monthID` smallint(6) NOT NULL DEFAULT '0',
  `roadTypeID` smallint(6) NOT NULL DEFAULT '0',
  `dayID` smallint(6) NOT NULL DEFAULT '0',
  `dayVMTFraction` float DEFAULT NULL,
  PRIMARY KEY (`dayID`,`monthID`,`roadTypeID`,`sourceTypeID`),
  KEY `sourceTypeID` (`sourceTypeID`),
  KEY `monthID` (`monthID`),
  KEY `roadTypeID` (`roadTypeID`),
  KEY `dayID` (`dayID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- emissionratebyage
CREATE TABLE IF NOT EXISTS `emissionratebyage` (
  `sourceBinID`      bigint(20) NOT NULL DEFAULT '0',
  `polProcessID`     smallint(6) NOT NULL DEFAULT '0',
  `opModeID`         smallint(6) NOT NULL DEFAULT '0',
  `ageGroupID`       smallint(6) NOT NULL DEFAULT '0',
  `meanBaseRate`     float DEFAULT NULL,
  `meanBaseRateCV`   float DEFAULT NULL,
  `meanBaseRateIM`   float DEFAULT NULL,
  `meanBaseRateIMCV` float DEFAULT NULL,
  `dataSourceId`     smallint(6) DEFAULT NULL,
  PRIMARY KEY (`ageGroupID`,`opModeID`,`polProcessID`,`sourceBinID`),
  UNIQUE KEY `XPKEmissionRateByAge` (`sourceBinID`,`polProcessID`,`opModeID`,`ageGroupID`),
  KEY `polProcessID` (`polProcessID`),
  KEY `sourceBinID` (`sourceBinID`),
  KEY `opModeID` (`opModeID`),
  KEY `ageGroupID` (`ageGroupID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- fuelformulation
CREATE TABLE IF NOT EXISTS `fuelformulation` (
  `fuelFormulationID` smallint(6) NOT NULL DEFAULT '0',
  `fuelSubtypeID` smallint(6) NOT NULL DEFAULT '0',
  `RVP` float DEFAULT NULL,
  `sulfurLevel` float NOT NULL DEFAULT '30',
  `ETOHVolume` float DEFAULT NULL,
  `MTBEVolume` float DEFAULT NULL,
  `ETBEVolume` float DEFAULT NULL,
  `TAMEVolume` float DEFAULT NULL,
  `aromaticContent` float DEFAULT NULL,
  `olefinContent` float DEFAULT NULL,
  `benzeneContent` float DEFAULT NULL,
  `e200` float DEFAULT NULL,
  `e300` float DEFAULT NULL,
  `volToWtPercentOxy` float DEFAULT NULL,
  `BioDieselEsterVolume` float DEFAULT NULL,
  `CetaneIndex` float DEFAULT NULL,
  `PAHContent` float DEFAULT NULL,
  `T50` float DEFAULT NULL,
  `T90` float DEFAULT NULL,
  PRIMARY KEY (`fuelFormulationID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- fuelsupply
CREATE TABLE IF NOT EXISTS `fuelsupply` (
  `countyID` int(11) NOT NULL DEFAULT '0',
  `fuelYearID` smallint(6) NOT NULL DEFAULT '0',
  `monthGroupID` smallint(6) NOT NULL DEFAULT '0',
  `fuelFormulationID` smallint(6) NOT NULL DEFAULT '0',
  `marketShare` float DEFAULT NULL,
  `marketShareCV` float DEFAULT NULL,
  PRIMARY KEY (`countyID`,`fuelFormulationID`,`monthGroupID`,`fuelYearID`),
  KEY `countyID` (`countyID`),
  KEY `yearID` (`fuelYearID`),
  KEY `monthGroupID` (`monthGroupID`),
  KEY `fuelSubtypeID` (`fuelFormulationID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- fuelsupplyyear
CREATE TABLE IF NOT EXISTS `fuelsupplyyear` (
  `fuelYearID` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fuelYearID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- hourvmtfraction
CREATE TABLE IF NOT EXISTS `hourvmtfraction` (
  `sourceTypeID` smallint(6) NOT NULL DEFAULT '0',
  `roadTypeID` smallint(6) NOT NULL DEFAULT '0',
  `dayID` smallint(6) NOT NULL DEFAULT '0',
  `hourID` smallint(6) NOT NULL DEFAULT '0',
  `hourVMTFraction` float DEFAULT NULL,
  PRIMARY KEY (`dayID`,`hourID`,`roadTypeID`,`sourceTypeID`),
  KEY `sourceTypeID` (`sourceTypeID`),
  KEY `roadTypeID` (`roadTypeID`),
  KEY `dayID` (`dayID`),
  KEY `hourID` (`hourID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- hpmsVTypeYear
CREATE TABLE IF NOT EXISTS `hpmsVTypeYear` (
  `HPMSVtypeID` smallint(6) NOT NULL DEFAULT '0',
  `yearID` smallint(6) NOT NULL DEFAULT '0',
  `VMTGrowthFactor` float DEFAULT NULL,
  `HPMSBaseYearVMT` float DEFAULT NULL,
  `baseYearOffNetVMT` float DEFAULT NULL,
  PRIMARY KEY (`HPMSVtypeID`,`yearID`),
  KEY `HPMSVtypeID` (`HPMSVtypeID`),
  KEY `yearID` (`yearID`),
  KEY `yearID_2` (`yearID`,`HPMSVtypeID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- imcoverage
CREATE TABLE IF NOT EXISTS `imcoverage` (
  `polProcessID`     smallint(6)     NOT NULL DEFAULT '0',
  `stateID`          smallint(6)     NOT NULL DEFAULT '0',
  `countyID`         int(11)         NOT NULL DEFAULT '0',
  `yearID`           smallint(6)     NOT NULL DEFAULT '0',
  `sourceTypeID`     smallint(6)     NOT NULL DEFAULT '0',
  `fuelTypeID`       smallint(6)     NOT NULL DEFAULT '0',
  `IMProgramID`      smallint(6)     NOT NULL DEFAULT '0',
  `begModelYearID`   smallint(6)     NOT NULL DEFAULT '0',
  `endModelYearID`   smallint(6)     NOT NULL DEFAULT '0',
  `inspectFreq`      smallint(6) DEFAULT NULL,
  `testStandardsID`  smallint(6)     NOT NULL DEFAULT '0',
  `useIMyn`          char(1)         NOT NULL DEFAULT 'Y',
  `complianceFactor` float       DEFAULT NULL,
  PRIMARY KEY (`polProcessID`,`stateID`,`countyID`,`yearID`,`sourceTypeID`,`fuelTypeID`,`IMProgramID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- monthvmtfraction
CREATE TABLE IF NOT EXISTS `monthvmtfraction` (
  `sourceTypeID` smallint(6) NOT NULL DEFAULT '0',
  `isLeapYear` char(1) NOT NULL DEFAULT '',
  `monthID` smallint(6) NOT NULL DEFAULT '0',
  `monthVMTFraction` float DEFAULT NULL,
  PRIMARY KEY (`isLeapYear`,`monthID`,`sourceTypeID`),
  KEY `sourceTypeID` (`sourceTypeID`),
  KEY `isLeapYear` (`isLeapYear`),
  KEY `monthID` (`monthID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- roadtype
CREATE TABLE IF NOT EXISTS `roadtype` (
  `roadTypeID` smallint(6) NOT NULL DEFAULT '0',
  `roadDesc` char(50) DEFAULT NULL,
  `rampFraction` float DEFAULT NULL,
  PRIMARY KEY (`roadTypeID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- roadtypedistribution
CREATE TABLE IF NOT EXISTS `roadtypedistribution` (
  `sourceTypeID` smallint(6) NOT NULL DEFAULT '0',
  `roadTypeID` smallint(6) NOT NULL DEFAULT '0',
  `roadTypeVMTFraction` float DEFAULT NULL,
  PRIMARY KEY (`roadTypeID`,`sourceTypeID`),
  KEY `sourceTypeID` (`sourceTypeID`),
  KEY `roadTypeID` (`roadTypeID`),
  KEY `roadTypeID_2` (`roadTypeID`,`sourceTypeID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- sourcetypeagedistribution
CREATE TABLE IF NOT EXISTS `sourcetypeagedistribution` (
   `sourceTypeID` smallint(6) NOT NULL DEFAULT '0',
   `yearID` smallint(6) NOT NULL DEFAULT '0',
   `ageID` smallint(6) NOT NULL DEFAULT '0',
   `ageFraction` float DEFAULT NULL,
   PRIMARY KEY (`ageID`,`sourceTypeID`,`yearID`),
   KEY `sourceTypeID` (`sourceTypeID`),
   KEY `yearID` (`yearID`),
   KEY `ageID` (`ageID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- sourcetypeyear
CREATE TABLE IF NOT EXISTS `sourcetypeyear` (
  `yearID` smallint(6) NOT NULL DEFAULT '0',
  `sourceTypeID` smallint(6) NOT NULL DEFAULT '0',
  `salesGrowthFactor` float DEFAULT NULL,
  `sourceTypePopulation` float DEFAULT NULL,
  `migrationrate` float DEFAULT NULL,
  PRIMARY KEY (`sourceTypeID`,`yearID`),
  KEY `yearID` (`yearID`),
  KEY `sourceTypeID` (`sourceTypeID`),
  KEY `sourceTypeID_2` (`sourceTypeID`,`yearID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- state
CREATE TABLE IF NOT EXISTS `state` (
  `stateID` smallint(6) NOT NULL DEFAULT '0',
  `stateName` char(25) DEFAULT NULL,
  `stateAbbr` char(2) DEFAULT NULL,
  PRIMARY KEY (`stateID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- year
CREATE TABLE IF NOT EXISTS `year` (
  `yearID` smallint(6) NOT NULL DEFAULT '0',
  `isBaseYear` char(1) DEFAULT NULL,
  `fuelYearID` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`yearID`),
  KEY `isBaseYear` (`isBaseYear`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- zone
CREATE TABLE IF NOT EXISTS `zone` (
  `zoneID` int(11) NOT NULL DEFAULT '0',
  `countyID` int(11) NOT NULL DEFAULT '0',
  `startAllocFactor` float DEFAULT NULL,
  `idleAllocFactor` float DEFAULT NULL,
  `SHPAllocFactor` float DEFAULT NULL,
  PRIMARY KEY (`zoneID`),
  KEY `countyID` (`countyID`),
  KEY `zoneID` (`zoneID`,`countyID`),
  KEY `countyID_2` (`countyID`,`zoneID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- zonemonthhour
CREATE TABLE IF NOT EXISTS `zonemonthhour` (
  `monthID` smallint(6) NOT NULL DEFAULT '0',
  `zoneID` int(11) NOT NULL DEFAULT '0',
  `hourID` smallint(6) NOT NULL DEFAULT '0',
  `temperature` float DEFAULT NULL,
  `temperatureCV` float DEFAULT NULL,
  `relHumidity` float DEFAULT NULL,
  `heatIndex` float DEFAULT NULL,
  `specificHumidity` float DEFAULT NULL,
  `relativeHumidityCV` float DEFAULT NULL,
  PRIMARY KEY (`hourID`,`monthID`,`zoneID`),
  KEY `monthID` (`monthID`),
  KEY `zoneID` (`zoneID`),
  KEY `hourID` (`hourID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- zoneroadtype
CREATE TABLE IF NOT EXISTS `zoneroadtype` (
  `zoneID` int(11) NOT NULL DEFAULT '0',
  `roadTypeID` smallint(6) NOT NULL DEFAULT '0',
  `SHOAllocFactor` float DEFAULT NULL,
  PRIMARY KEY (`roadTypeID`,`zoneID`),
  KEY `roadTypeID` (`roadTypeID`,`zoneID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 DELAY_KEY_WRITE=1;

-- -------------------------------------------------------------
-- The following ten tables are to be tested for errors.
-- If any such table does not exist, the following tests
-- will create errors.
-- Hence, create these tables if they do not exist.

CREATE TABLE IF NOT EXISTS `fuelusagefraction` (
  `countyID` int(11) NOT NULL,
  `fuelYearID` int(11) NOT NULL,
  `modelYearGroupID` int(11) NOT NULL,
  `sourceBinFuelTypeID` smallint(6) NOT NULL,
  `fuelSupplyFuelTypeID` smallint(6) NOT NULL,
  `usageFraction` double DEFAULT NULL,
  PRIMARY KEY (`countyID`,`fuelYearID`,`modelYearGroupID`,`sourceBinFuelTypeID`,`fuelSupplyFuelTypeID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `hotellingactivitydistribution` (
  `beginModelYearID` smallint(6) NOT NULL,
  `endModelYearID` smallint(6) NOT NULL,
  `opModeID` smallint(6) NOT NULL,
  `opModeFraction` float NOT NULL,
  PRIMARY KEY (`beginModelYearID`,`endModelYearID`,`opModeID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `hotellinghours` (
  `sourceTypeID` smallint(6) NOT NULL,
  `hourDayID` smallint(6) NOT NULL,
  `monthID` smallint(6) NOT NULL,
  `yearID` smallint(6) NOT NULL,
  `ageID` smallint(6) NOT NULL,
  `zoneID` int(11) NOT NULL,
  `hotellingHours` double DEFAULT NULL,
  `isUserInput` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`sourceTypeID`,`hourDayID`,`monthID`,`yearID`,`ageID`,`zoneID`),
  KEY `sourceTypeID` (`sourceTypeID`),
  KEY `hourDayID` (`hourDayID`),
  KEY `monthID` (`monthID`),
  KEY `yearID` (`yearID`),
  KEY `ageID` (`ageID`),
  KEY `zoneID` (`zoneID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `importstartsopmodedistribution` (
  `sourceTypeID` smallint(6) NOT NULL,
  `hourDayID` smallint(6) NOT NULL,
  `linkID` int(11) NOT NULL,
  `polProcessID` int(11) NOT NULL,
  `opModeID` smallint(6) NOT NULL,
  `opModeFraction` float DEFAULT NULL,
  `opModeFractionCV` float DEFAULT NULL,
  `isUserInput` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`sourceTypeID`,`hourDayID`,`linkID`,`polProcessID`,`opModeID`),
  KEY `sourceTypeID` (`sourceTypeID`),
  KEY `hourDayID` (`hourDayID`),
  KEY `linkID` (`linkID`),
  KEY `polProcessID` (`polProcessID`),
  KEY `opModeID` (`opModeID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `onroadretrofit` (
  `pollutantID` smallint(6) NOT NULL,
  `processID` smallint(6) NOT NULL,
  `fuelTypeID` smallint(6) NOT NULL,
  `sourceTypeID` smallint(6) NOT NULL,
  `retrofitYearID` smallint(6) NOT NULL,
  `beginModelYearID` smallint(6) NOT NULL,
  `endModelYearID` smallint(6) NOT NULL,
  `cumFractionRetrofit` double NOT NULL DEFAULT '0',
  `retrofitEffectiveFraction` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`pollutantID`,`processID`,`fuelTypeID`,`sourceTypeID`,
               `retrofitYearID`,`beginModelYearID`,`endModelYearID`),
  KEY `retrofitYearID` (`retrofitYearID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `starts` (
  `hourDayID` smallint(6) NOT NULL DEFAULT '0',
  `monthID` smallint(6) NOT NULL DEFAULT '0',
  `yearID` smallint(6) NOT NULL DEFAULT '0',
  `ageID` smallint(6) NOT NULL DEFAULT '0',
  `zoneID` int(11) NOT NULL DEFAULT '0',
  `sourceTypeID` smallint(6) NOT NULL DEFAULT '0',
  `starts` float DEFAULT NULL,
  `StartsCV` float DEFAULT NULL,
  `isUserInput` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`ageID`,`hourDayID`,`monthID`,`sourceTypeID`,`yearID`,`zoneID`),
  KEY `hourDayID` (`hourDayID`),
  KEY `monthID` (`monthID`),
  KEY `yearID` (`yearID`),
  KEY `ageID` (`ageID`),
  KEY `zoneID` (`zoneID`),
  KEY `sourceTypeID` (`sourceTypeID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `startshourfraction` (
  `zoneID` int(11) NOT NULL,
  `dayID` smallint(6) NOT NULL,
  `hourID` smallint(6) NOT NULL,
  `allocationFraction` double NOT NULL,
  PRIMARY KEY (`zoneID`,`dayID`,`hourID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `startsmonthadjust` (
  `monthID` smallint(6) NOT NULL,
  `monthAdjustment` double NOT NULL,
  PRIMARY KEY (`monthID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `startsperday` (
  `zoneID` int(11) NOT NULL,
  `dayID` smallint(6) NOT NULL,
  `yearID` smallint(6) NOT NULL,
  `startsPerDay` double NOT NULL,
  PRIMARY KEY (`zoneID`,`dayID`,`yearID`),
  KEY `yearID` (`yearID`,`zoneID`,`dayID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `startssourcetypefraction` (
  `sourceTypeID` smallint(6) NOT NULL,
  `allocationFraction` double NOT NULL,
  PRIMARY KEY (`sourceTypeID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




-- ----------------------------------------------------------------------------------------
-- Data Checking: ------------------------------------------------------------------------
-- ----------------------------------------------------------------------------------------

DROP PROCEDURE IF EXISTS checkImCoverage;


Insert into   County_Database_Checks ( TableName,  TestDescription )
       values
                                     ("auditlog", "Table Check:");

--       check no. 001  -- no check
--       check no. 002  -- no check
--       check no. 003  -- no check
--       check no. 004  -- no check


--       Table  Check: avft
Insert into   County_Database_Checks ( TableName, TestDescription )
       values
                           ("avft",     "Table Check:");

--       check no. 005
INSERT INTO QA_Checks_Log values ( 5, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   sourceTypeId as sourceTypeId2,
         'no '        as aMatch,
         count(*)     as n
From     avft
Group by sourceTypeId2;


Update tempA as a set aMatch='yes' where (Select m.sourceTypeId
                                          From   movesdb20141021.sourceUseType as m
                                          Where  a.sourceTypeId2 = m.sourceTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "avft"        as tableName,
         5,
        "sourceTypeId" as testDescription,
         sourceTypeId2 as testValue,
         n             as count               --
From     tempA
Where    aMatch <> 'yes';

--       check no. 006
INSERT INTO QA_Checks_Log values ( 6, 'OK', @hversion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   modelYearId  as modelYearId2,
         'no '        as aMatch,
         count(*)     as n
From     avft
Group by modelYearId2;

Update tempA as a set aMatch='yes' where (Select m.modelYearId
                                          From   movesdb20141021.modelYear as m
                                          Where  a.modelYearId2 = m.modelYearId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "avft"       as tableName,
         6,
        "modelYearId" as testDescription,
         modelYearId2 as testValue,
         n            as count               --
From     tempA
Where    aMatch <> 'yes';

--       check no. 007
INSERT INTO QA_Checks_Log values ( 7, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   fuelTypeId  as fuelTypeId2,
         'no '       as aMatch,
         count(*)    as n
From     avft
Group by fuelTypeId2;

Update tempA as a set aMatch='yes' where (Select min(m.fuelTypeId)
                                          From   movesdb20141021.fuelSubType as m
                                          Where  a.fuelTypeId2 = m.fuelTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "avft"      as tableName,
         7,
        "fuelTypeId" as testDescription,
         fuelTypeId2 as testValue,
         n           as count               --
From     tempA
Where    aMatch <> 'yes';

--       check no. 008
INSERT INTO QA_Checks_Log values ( 8, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   engTechId  as engTechId2,
         'no '      as aMatch,
         count(*)   as n
From     avft
Group by engTechId2;


Update tempA as a set aMatch='yes' where (Select engTechId
                                          From   movesdb20141021.engineTech as m
                                          Where  a.engTechId2 = m.engTechId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "avft"     as tableName,
         8,
        "engTechId" as testDescription,
         engTechId2 as testValue,
         n          as count
From     tempA
Where    aMatch <> 'yes';

--       check no. 009
INSERT INTO QA_Checks_Log values ( 9, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   fuelEngFraction as fuelEngFraction2,
         'no '           as aMatch,
         count(*)        as n
From     avft
Group by fuelEngFraction2;


Update tempA as a set aMatch='yes' where fuelEngFraction2 >= 0.0 and fuelEngFraction2 <= 1.0001;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "avft"           as tableName,
         9,
        "fuelEngFraction" as testDescription,
         fuelEngFraction2 as testValue,
         n                as count
From     tempA
Where    aMatch <> 'yes';


--       Table  Check: avgspeeddistribution
Insert into   County_Database_Checks ( TableName,              TestDescription )
       values
                           ("avgspeeddistribution", "Table Check:");

--       check no. 010
INSERT INTO QA_Checks_Log values ( 10, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   avgSpeedBinId   as avgSpeedBinId2,   -- '+1' for testing
         'no '           as aMatch,
         count(*)        as n
From     avgSpeedDistribution
Group by avgSpeedBinId2;

Update   tempA as a set aMatch='yes' where (Select m.avgSpeedBinId
                                            From   movesdb20141021.avgSpeedBin as m
                                            Where  a.avgSpeedBinId2 = m.avgSpeedBinId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "avgSpeedDistribution"    as tableName,
         10,
         "avgSpeedBinId Not Valid" as testDescription,
         avgSpeedBinId2            as testValue,
         n                         as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 011
INSERT INTO QA_Checks_Log values ( 11, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue,
           sourceTypeId,
           roadTypeId,
           hourDayId )

Select  "avgspeeddistribution"           as tableName,
         11                              as checkNumber,
        "sum of avgSpeedFraction <> 1.0" as testDescription,
         sum(avgSpeedFraction)           as testValue,
           sourceTypeId,
           roadTypeId,
           hourDayId

From     avgspeeddistribution
Group by sourceTypeId,
         roadTypeId,
         hourDayId
Having   testValue <0.999 or testValue >1.001;


--       check no. 012
INSERT INTO QA_Checks_Log values ( 12, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   hourDayId       as hourDayId2,
         'no '           as aMatch,
         count(*)        as n
From     avgSpeedDistribution
Group by hourDayId2;

Update tempA as a set aMatch='yes' where (Select m.hourDayId
                                          From   movesdb20141021.hourDay as m
                                          Where  a.hourDayId2 = m.hourDayId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "avgSpeedDistribution" as tableName,
         12,
         "hourDayId"            as testDescription,
         hourDayId2             as testValue,
         n                      as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 013
INSERT INTO QA_Checks_Log values ( 13, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   roadTypeId      as roadTypeId2,
         'no '           as aMatch,
         count(*)        as n
From     avgSpeedDistribution
Group by roadTypeId2;

Update tempA as a set aMatch='yes' where (Select m.roadTypeId
                                          From   movesdb20141021.roadType as m
                                          Where  a.roadTypeId2 = m.roadTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "avgSpeedDistribution" as tableName,
         13,
         "roadTypeId"           as testDescription,
         roadTypeId2            as testValue,
         n                      as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 014
INSERT INTO QA_Checks_Log values ( 14, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   sourceTypeId    as sourceTypeId2,
         'no '           as aMatch,
         count(*)        as n
From     avgSpeedDistribution
Group by sourceTypeId2;

Update tempA as a set aMatch='yes' where (Select m.sourceTypeId
                                          From   movesdb20141021.sourceUseType as m
                                          Where  a.sourceTypeId2 = m.sourceTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "avgSpeedDistribution" as tableName,
         14,
         "sourceTypeTypeId"     as testDescription,
         sourceTypeId2          as testValue,
         n                      as count
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,  TestDescription )
       values
                           ("county",   "Table Check:");

--       check no. 015
INSERT INTO QA_Checks_Log values ( 15, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   countyId    as countyId2,
         'no '       as aMatch,
         count(*)    as n
From     county
Group by countyId2;

Update tempA as a set aMatch='yes' where (Select m.countyId
                                          From   movesdb20141021.county as m
                                          Where  a.countyId2 = m.countyId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "county"   as tableName,
         15,
         "countyId" as testDescription,
         countyId2  as testValue,
         n          as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 016  -- no check


--       check no. 017
INSERT INTO QA_Checks_Log values ( 17, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   altitude     as altitude2,
         'no '        as aMatch,
         count(*)     as n
From     county
Group by altitude2;

Update tempA as a set aMatch='yes' where altitude2 in ('L','H');

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         -- testValue,
         count  )
Select   "county"              as tableName,
         17,
         "altitude not L or H" as testDescription,
         -- altitude2          as testValue,
         n                     as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 018
INSERT INTO QA_Checks_Log values ( 18, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   GPAFract     as GPAFract2,
         'no '        as aMatch,
         count(*)     as n
From     county
Group by GPAFract2;

Update tempA set aMatch='yes' where GPAFract2>=0.0 and GPAFract2<=1.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "county"       as tableName,
         18,
         "GPACFract"    as testDescription,
         GPAFract2      as testValue,
         n              as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 019
INSERT INTO QA_Checks_Log values ( 19, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   barometricPressure as barPre,
         'no '              as aMatch,
         count(*)           as n
From     county
Group by barPre;


Update tempA as a set aMatch='yes' where BarPre>=20.0 and BarPre<=33.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "county"             as tableName,
         19,
         "barometricPressure" as testDescription,
         BarPre               as testValue,
         n                    as count
From     tempA
Where    aMatch <> 'yes';

--       check no. 020  No test

--       check no. 021
INSERT INTO QA_Checks_Log values ( 21, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   stateId      as stateId2,
         'no '        as aMatch,
         count(*)     as n
From     county
Group by stateId2;

Update tempA as a set aMatch='yes' where (Select m.stateId
                                          From   movesdb20141021.state as m
                                          Where  a.stateId2 = m.stateId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "county"            as tableName,
         21,
         "stateId not valid" as testDescription,
         stateId2            as testValue,
         n                   as count
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,        TestDescription )
       values
                           ("dayVmtFraction", "Table Check:");


--       check no. 022
INSERT INTO QA_Checks_Log values ( 22, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   dayId        as dayId2,
         'no '        as aMatch,
         count(*)     as n
From     dayVmtFraction
Group by dayId2;


Update tempA as a set aMatch='yes' where (Select m.dayId
                                          From   movesdb20141021.dayOfAnyWeek as m
                                          Where  a.dayId2 = m.dayId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "dayVmtFraction" as tableName,
         22,
         "dayId"          as testDescription,
         dayId2           as testValue,
         n                as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 023
INSERT INTO QA_Checks_Log values ( 23, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue,
           sourceTypeId,
           monthId,
           roadTypeId )

Select  "dayVmtFraction"               as tableName,
         23                            as checkNumber,
        "sum of dayVMTFraction <> 1.0" as testDescription,
         sum(dayVMTFraction)           as testValue,
           sourceTypeId,
           monthId,
           roadTypeId

From     dayVmtFraction
Where    roadTypeId in (2,3,4,5)
Group by sourceTypeId,
         monthId,
         roadTypeId
Having   testValue <0.999 or testValue >1.001;


--       check no. 024
INSERT INTO QA_Checks_Log values ( 24, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   monthId      as monthId2,
         'no '        as aMatch,
         count(*)     as n
From     dayVmtFraction
Group by monthId2;


Update tempA as a set aMatch='yes' where (Select m.monthId
                                          From   movesdb20141021.monthOfAnyYear as m
                                          Where  a.monthId2 = m.monthId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "dayVmtFraction" as tableName,
         24,
         "monthId"        as testDescription,
         monthId2         as testValue,
         n                as count
From     tempA
Where    aMatch <> 'yes';

--       check no. 025
INSERT INTO QA_Checks_Log values ( 25, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   roadTypeId   as roadTypeId2,
         'no '        as aMatch,
         count(*)     as n
From     movesdb20141021.dayVmtFraction
Group by roadTypeId2;


Update tempA as a set aMatch='yes' where (Select m.roadTypeId
                                          From   movesdb20141021.roadType as m
                                          Where  a.roadTypeId2 = m.roadTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "dayVmtFraction" as tableName,
         25,
         "roadTypeId"     as testDescription,
         roadTypeId2      as testValue,
         n                as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 026
INSERT INTO QA_Checks_Log values ( 26, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   sourceTypeId as sourceTypeId2,
         'no '        as aMatch,
         count(*)     as n
From     dayVmtFraction
Group by sourceTypeId2;


Update tempA as a set aMatch='yes' where (Select m.sourceTypeId
                                          From   movesdb20141021.sourceUseType as m
                                          Where  a.sourceTypeId2 = m.sourceTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "dayVmtFraction" as tableName,
         26,
         "sourceTypeId"   as testDescription,
         sourceTypeId2    as testValue,
         n                as count
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,         TestDescription )
       values
                           ("fuelFormulation", "Table Check:");

--       check no. 027  no check

--       check no. 028
INSERT INTO QA_Checks_Log values ( 28, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   fuelSubTypeId as fuelSubTypeId2,
         'no '         as aMatch,
         count(*)      as n
From     fuelFormulation
Group by fuelSubTypeId2;


Update tempA as a set aMatch='yes' where (Select m.fuelSubTypeId
                                          From   movesdb20141021.fuelSubType as m
                                          Where  a.fuelSubTypeId2 = m.fuelSubTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         28,
         "fuelSubTypeId"   as testDescription,
         fuelSubTypeId2    as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 029
INSERT INTO QA_Checks_Log values ( 29, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   RVP           as RVP2,
         fuelSubTypeId as fuelSubType2,
         'no '         as aMatch,
         count(*)      as n
From     fuelFormulation
Group by RVP2;

Update tempA as a set aMatch='yes' where RVP2>=5.0 and RVP2<=20.0 and fuelSubType2     in (10,11,12,13,14,15);
Update tempA as a set aMatch='yes' where                              fuelSubType2 not in (10,11,12,13,14,15);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         29,
         "RVP"             as testDescription,
         RVP2              as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 030
INSERT INTO QA_Checks_Log values ( 30, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   sulfurLevel   as sulfurLevel2,
         'no '         as aMatch,
         count(*)      as n
From     fuelFormulation
Group by sulfurLevel2;

Update tempA as a set aMatch='yes' where sulfurLevel2>=0.0 and sulfurLevel2<=5000.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         30,
         "sulfurLevel"     as testDescription,
         sulfurLevel2      as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 031
INSERT INTO QA_Checks_Log values ( 31, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   ETOHVolume    as ETOHVolume2,
         'no '         as aMatch,
         count(*)      as n,
         fuelsubtypeid as fuelsubtype2
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by ETOHVolume2;

Update tempA as a set aMatch='yes' where ETOHVolume2>=0.0 and ETOHVolume2<=100.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         31,
         "ETOHVolume"      as testDescription,
         ETOHVolume2       as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 032
INSERT INTO QA_Checks_Log values ( 32, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   MTBEVolume    as MTBEVolume2,
         'no '         as aMatch,
         count(*)      as n,
         fuelsubtypeid as fuelsubtype2
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by MTBEVolume2;


Update tempA as a set aMatch='yes' where MTBEVolume2>=0.0 and MTBEVolume2<=100.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         32,
         "MTBEVolume"      as testDescription,
         MTBEVolume2       as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 033
INSERT INTO QA_Checks_Log values ( 33, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   fuelFormulationID,
         ETBEVolume    as ETBEVolume2,
         'no '         as aMatch,
         count(*)      as n,
         fuelsubtypeid as fuelsubtype2
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by ETBEVolume2;


Update tempA as a set aMatch='yes' where ETBEVolume2>=0.0 and ETBEVolume2<=100.0;

Insert into County_Database_Checks
       ( TableName,
         fuelFormulationID,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         fuelFormulationID,
         33,
         "ETBEVolume"      as testDescription,
         ETBEVolume2       as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 034
INSERT INTO QA_Checks_Log values ( 34, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   TAMEVolume    as TAMEVolume2,
         'no '         as aMatch,
         count(*)      as n,
         fuelsubtypeid as fuelsubtype2
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by TAMEVolume2;

Update tempA as a set aMatch='yes' where TAMEVolume2>=0.0 and TAMEVolume2<=100.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         34,
         "TAMEVolume"      as testDescription,
         TAMEVolume2       as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';

--       check no. 035
INSERT INTO QA_Checks_Log values ( 35, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   aromaticContent as aromaticContent2,
         'no '           as aMatch,
         count(*)        as n,
         fuelsubtypeid   as fuelsubtype2
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by aromaticContent2;

Update tempA as a set aMatch='yes' where aromaticContent2>=0.0 and aromaticContent2<=55.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         35,
         "aromaticContent" as testDescription,
         aromaticContent2  as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 036
INSERT INTO QA_Checks_Log values ( 36, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   olefinContent as olefinContent2,
         'no '           as aMatch,
         count(*)        as n,
         fuelsubtypeid   as fuelsubtype2
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by olefinContent2;

Update tempA as a set aMatch='yes' where olefinContent2>=0.0 and olefinContent2<=25.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         36,
         "olefinContent"   as testDescription,
         olefinContent2    as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 037
INSERT INTO QA_Checks_Log values ( 37, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   benzeneContent  as benzeneContent2,
         'no '           as aMatch,
         count(*)        as n,
         fuelsubtypeid   as fuelsubtype2
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by benzeneContent2;

Update tempA as a set aMatch='yes' where benzeneContent2>=0.0 and benzeneContent2<=5.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         37,
         "benzeneContent"  as testDescription,
         benzeneContent2   as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 038
INSERT INTO QA_Checks_Log values ( 38, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   e200  as e2002,
         'no '           as aMatch,
         count(*)        as n,
         fuelsubtypeid   as fuelsubtype2
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by e2002;


Update tempA as a set aMatch='yes' where e2002>=0.0 and e2002<=70.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         38,
         "e200"            as testDescription,
         e2002             as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 039
INSERT INTO QA_Checks_Log values ( 39, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   e300            as e3002,
         'no '           as aMatch,
         count(*)        as n,
         fuelsubtypeid   as fuelsubtype2
From     fuelFormulation
Where    fuelsubtypeid in (10,11,12,13,14,15)
  and    fuelformulationid >=100
Group by e3002;


Update tempA as a set aMatch='yes' where e3002>=0.0 and e3002<=100.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         39,
         "e300"            as testDescription,
         e3002             as testValue,
         n                 as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 040
INSERT INTO QA_Checks_Log values ( 40, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   volToWtPercentOxy as volToWtPercentOxy2,
         'no '             as aMatch,
         count(*)          as n
From     fuelFormulation
Group by volToWtPercentOxy2;


Update tempA as a set aMatch='yes' where volToWtPercentOxy2>=0.0 and volToWtPercentOxy2<=1.0
                                      or volToWtPercentOxy2 is null;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelFormulation" as tableName,
         40,
         "volToWtPercentOxy" as testDescription,
         volToWtPercentOxy2  as testValue,
         n                   as count
From     tempA
Where    aMatch <> 'yes';

--       check no. 041  -- no check
--       check no. 042  -- no check
--       check no. 043  -- no check
--       check no. 044  -- no check
--       check no. 045  -- no check

Insert into   County_Database_Checks ( TableName,    TestDescription )
       values
                           ("fuelSupply", "Table Check:");


--       check no. 046 (fuelRegionId does not exist in older CDBs)
INSERT INTO QA_Checks_Log values (-46, 'OK', @hVersion, curDate(), curTime() );
-- Drop     table if exists tempA;
-- Create   table           tempA
-- Select   fuelRegionId as fuelRegionId2,
--          'no '        as aMatch,
--          count(*)     as n
-- From     fuelSupply
-- Group by fuelRegionId;
--
--
-- Update tempA as a set aMatch='yes' where (Select count(*)
--                                           From   MOVESDB20140731.regionCounty as r
--                                           Where  a.fuelRegionId2 = r.regionId) > 0;
--
-- Insert into County_Database_Checks
--        ( TableName,
--          CheckNumber,
--          TestDescription,
--          testValue,
--          count  )
-- Select   "fuelSupply"  as tableName,
--          46,
--         "fuelRegionId" as testDescription,
--          fuelRegionId2 as testValue,
--          n             as count
-- From     tempA
-- Where    aMatch <> 'yes';


--       check no. 047
INSERT INTO QA_Checks_Log values ( 47, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   fuelFormulationID as fuelFormulationID2,
         'no '             as aMatch,
         count(*)          as n
From     fuelSupply
Group by fuelFormulationID2;


Update tempA as a set aMatch='yes' where (Select m.fuelFormulationID
                                          From   fuelformulation as m
                                          Where  a.fuelFormulationID2 = m.fuelFormulationID);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelSupply" as tableName,
         47,
        "fuelFormulationID" as testDescription,
         fuelFormulationID2  as testValue,
         n                   as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 048
INSERT INTO QA_Checks_Log values ( 48, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   fuelYearId as fuelYearId2,
         'no '      as aMatch,
         count(*)   as n
From     fuelSupply
Group by fuelYearId2;


Update tempA as a set aMatch='yes' where (Select m.fuelYearId
                                          From   movesdb20141021.fuelSupplyYear as m
                                          Where  a.fuelYearId2 = m.fuelYearId);

# disabled for calendar years after 2015.
update tempA set aMatch='yes' where fuelYearId2>2015;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelSupply" as tableName,
         48,
        "fuelYearId"  as testDescription,
         fuelYearId2  as testValue,
         n            as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 049  (fuelRegionId does not exist in older CDBs)
INSERT INTO QA_Checks_Log values ( -49, 'OK', @hVersion, curDate(), curTime() );
-- Drop     table if exists tempA;
--
-- -- gasoline fuel types:
-- Insert into County_Database_Checks
--        ( tableName,
--          checkNumber,
--          testDescription,
--          testValue,
--            fuelYearId,
--            monthGroupId,
--            fuelTypeId )
-- Select  "fuelSupply"                  as tableName,
--          49                           as checkNumber,
--         "sum of marketShare <> 1.0"   as testDescription,
--          sum(marketShare)             as testValue,
--            fuelYearId,
--            monthGroupId,
--            fuelTypeId
-- From     fuelSupply                  as a,
--          fuelFormulation             as b,
--          movesdb20141021.fuelSubtype as c
--
-- Where    a.fuelFormulationId = b.fuelFormulationId
--   and    b.fuelSubTypeId     = c.fuelSubtypeId
--   and    c.fuelTypeId in (1,5)
--
-- Group by fuelYearId,
--          monthGroupId,
--          fuelRegionId,
--          fuelTypeId
-- Having   testValue <0.999 or testValue >1.001;
--
-- -- Non-gasoline fuel types:
-- Insert into County_Database_Checks
--        ( tableName,
--          checkNumber,
--          testDescription,
--          testValue,
--            fuelYearId,
--            monthGroupId,
--            fuelTypeId )
-- Select  "fuelSupply"                  as tableName,
--          49                           as checkNumber,
--         "sum of marketShare <> 1.0"   as testDescription,
--          sum(marketShare)             as testValue,
--            fuelYearId,
--            monthGroupId,
--            fuelTypeId
-- From     fuelSupply                  as a,
--          fuelFormulation             as b,
--          movesdb20141021.fuelSubtype as c
--
-- Where    a.fuelFormulationId = b.fuelFormulationId
--   and    b.fuelSubTypeId     = c.fuelSubtypeId
--   and    c.fuelTypeId not in (1,5)
--
-- Group by fuelYearId,
--          monthGroupId,
--          fuelRegionId,
--          fuelTypeId
-- Having   testValue <0.999 or testValue >1.001;



--       check no. 050  -- no check

--       check no. 051
INSERT INTO QA_Checks_Log values ( 51, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   monthGroupId as monthGroupId2,
         'no '        as aMatch,
         count(*)     as n
From     fuelSupply
Group by monthGroupId2;


Update tempA as a set aMatch='yes' where (Select m.monthGroupId
                                          From   movesdb20141021.monthGroupOfAnyYear as m
                                          Where  a.monthGroupId2 = m.monthGroupId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelSupply"   as tableName,
         51,
        "monthGroupId"  as testDescription,
         monthGroupId2  as testValue,
         n              as count
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,        TestDescription )
       values
                           ("fuelSupplyYear", "Table Check:");


--       check no. 052
INSERT INTO QA_Checks_Log values ( 52, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   fuelYearId   as fuelYearId2,
         'no '        as aMatch,
         count(*)     as n
From     fuelSupplyYear
Group by fuelYearId2;

Update tempA as a set aMatch='yes' where (Select m.fuelYearId
                                          From   movesdb20141021.fuelSupplyYear as m
                                          Where  a.fuelYearId2 = m.fuelYearId);

# disabled for calendar years after 2015.
update tempA set aMatch='yes' where fuelYearId2>2015;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select  "fuelSupplyYear" as tableName,
         52,
        "fuelYearId"     as testDescription,
         fuelYearId2     as testValue,
         n               as count               --
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,         TestDescription )
       values
                           ("hourVmtFraction", "Table Check:");


--       check no. 053
INSERT INTO QA_Checks_Log values ( 53, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;

Insert into County_Database_Checks
       (  tableName,
          checkNumber,
          testDescription,
          testValue,
            sourceTypeId,
            roadTypeId,
            dayId  )

Select   "hourVmtFraction"               as tableName,
          53                             as checkNumber,
         "sum of hourVmtFraction <> 1.0" as tesDescription,
          sum(hourVmtFraction)           as testValue,
            sourceTypeId,
            roadTypeId,
            dayId

From      hourVmtFraction
Where     roadTypeId in (2,3,4,5)
Group by  sourceTypeId,
          roadTypeId,
          dayId
Having    testValue <0.999 or testValue >1.001;


--       check no. 054
INSERT INTO QA_Checks_Log values ( 54, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   dayId    as dayId2,
         'no '    as aMatch,
         count(*) as n
From     hourVmtFraction
Group by dayId2;


Update tempA as a set aMatch='yes' where (Select m.dayId
                                          From   movesdb20141021.dayOfAnyWeek as m
                                          Where  a.dayId2 = m.dayId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "hourVmtFraction" as tableName,
         54,
         "dayId"           as testDescription,
         dayId2            as testValue,
         n                 as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 055
INSERT INTO QA_Checks_Log values ( 55, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   hourId    as hourId2,
         'no '     as aMatch,
         count(*)  as n
From     hourVmtFraction
Group by hourId2;


Update tempA as a set aMatch='yes' where (Select m.hourId
                                          From   movesdb20141021.hourOfAnyDay as m
                                          Where  a.hourId2 = m.hourId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select  "hourVmtFraction" as tableName,
         55,
        "hourId"          as testDescription,
         hourId2          as testValue,
         n                as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 056
INSERT INTO QA_Checks_Log values ( 56, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   roadTypeId as roadTypeId2,
         'no '      as aMatch,
         count(*)   as n
From     hourVmtFraction
Group by roadTypeId2;


Update tempA as a set aMatch='yes' where (Select m.roadTypeId
                                          From   movesdb20141021.roadType as m
                                          Where  a.roadTypeId2 = m.roadTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select  "hourVmtFraction" as tableName,
         56,
        "roadTypeId"      as testDescription,
         roadTypeId2      as testValue,
         n                as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 057
INSERT INTO QA_Checks_Log values ( 57, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   sourceTypeId as sourceTypeId2,
         'no '        as aMatch,
         count(*)     as n
From     hourVmtFraction
Group by sourceTypeId2;


Update tempA as a set aMatch='yes' where (Select m.sourceTypeId
                                          From   movesdb20141021.sourceUseType as m
                                          Where  a.sourceTypeId2 = m.sourceTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select  "hourVmtFraction" as tableName,
         57,
        "sourceTypeId"    as testDescription,
         sourceTypeId2    as testValue,
         n                as count               --
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,       TestDescription )
       values
                           ("hpmsVTypeYear", "Table Check:");

--       check no. 058
INSERT INTO QA_Checks_Log values ( 48, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   HPMSVtypeID  as HPMSVtypeID2,
         'no '        as aMatch,
         count(*)     as n
From     hpmsVTypeYear
Group by HPMSVtypeID2;


Update tempA as a set aMatch='yes' where (Select m.HPMSVtypeID
                                          From   movesdb20141021.hpmsvType as m
                                          Where  a.HPMSVtypeID2 = m.HPMSVtypeID);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select  "hpmsVTypeYear"   as tableName,
         58,
        "hpmSvTypeId"      as testDescription,
         HPMSVtypeId2      as testValue,
         n                 as count               --
From     tempA
Where    aMatch <> 'yes';

--       check no. 059  -- no check

--       check no. 060  -- no check

--       check no. 061  -- no check

--       check no. 062
INSERT INTO QA_Checks_Log values ( 62, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   yearId          as yearId2,
         'no '           as aMatch,
         count(*)        as n
From     hpmsVTypeYear
Group by yearId2;

Update tempA as a set aMatch='yes' where (Select m.yearId
                                          From   movesdb20141021.year as m
                                          Where  a.yearId2 = m.yearId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select  "hpmsVTypeYear"   as tableName,
         62,
        "yearId"      as testDescription,
         yearId2      as testValue,
         n            as count               --
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,    TestDescription )
       values
                           ("imCoverage", "Table Check:");

--       check no. 063
INSERT INTO QA_Checks_Log values ( 63, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   countyId        as countyId2,
         'no '           as aMatch,
         count(*)        as n
From     imCoverage
Group by countyId2;


Update tempA as a set aMatch='yes' where (Select m.countyId
                                          From   movesdb20141021.county as m
                                          Where  a.countyId2 = m.countyId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select  "imCoverage" as tableName,
         63,
        "countyId"      as testDescription,
         countyId2      as testValue,
         n              as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 064
INSERT INTO QA_Checks_Log values ( 64, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   fuelTypeId      as fuelTypeId2,
         'no '           as aMatch,
         count(*)        as n
From     imCoverage
Group by fuelTypeId2;


Update tempA as a set aMatch='yes' where (Select fuelTypeId
                                          From   movesdb20141021.fuelType as m
                                          Where  a.fuelTypeId2 = m.fuelTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select  "imCoverage" as tableName,
         64,
        "fuelTypeId" as testDescription,
         fuelTypeId2 as testValue,
         n           as count
From     tempA
Where    aMatch <> 'yes';

--       check no. 065  -- no check

--       check no. 066
INSERT INTO QA_Checks_Log values ( 66, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   polProcessId    as polProcessId2,
         'no '           as aMatch,
         count(*)        as n
From     imCoverage
Group by polProcessId2;


Update tempA as a set aMatch='yes' where (Select polProcessId
                                          From   movesdb20141021.pollutantProcessAssoc as m
                                          Where  a.polProcessId2 = m.polProcessId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select  "imCoverage" as tableName,
         66,
        "polProcessId"      as testDescription,
         polProcessId2      as testValue,
         n                  as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 069
INSERT INTO QA_Checks_Log values ( 69, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   inspectFreq     as inspectFreq2,
         'no '           as aMatch,
         count(*)        as n
From     imCoverage
Group by inspectFreq2;


Update tempA as a set aMatch='yes' where inspectFreq2 in (1,2);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select  "imCoverage"  as tableName,
         69,
        "inspectFreq" as testDescription,
         inspectFreq2 as testValue,
         n            as count               --
From     tempA
Where    aMatch <> 'yes';

--       check no. 070  -- no check

--       check no. 071
INSERT INTO QA_Checks_Log values ( 71, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   useIMyn         as useIMyn2,
         'no '           as aMatch,
         count(*)        as n
From     imCoverage
Group by useIMyn2;


Update tempA as a set aMatch='yes' where useIMyn2 in ('y', 'n');

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
    --   testValue,
         count  )
Select   "imCoverage" as tableName,
         71,
        "useIMyn not Y or N" as testDescription,
    --   useIMyn2      as testValue,
         n         as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 072
INSERT INTO QA_Checks_Log values ( 72, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   complianceFactor as complianceFactor2,
         'no '            as aMatch,
         count(*)         as n
From     imCoverage
Group by complianceFactor;


Update tempA as a set aMatch='yes' where complianceFactor2>=0.0 and complianceFactor2<=100.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "imCoverage" as tableName,
         72,
        "complianceFactor range" as testDescription,
         complianceFactor2       as testValue,
         n                       as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 073
INSERT INTO QA_Checks_Log values ( 73, 'OK', @hVersion, curDate(), curTime() );
Drop     table tempA;
Create   table           tempA
Select   sourceTypeId as sourceTypeId2,
         'no '        as aMatch,
         count(*)     as n
From     imCoverage
Group by sourceTypeId2;



Update tempA as a set aMatch='yes' where (Select m.sourceTypeId
                                          From   movesdb20141021.sourceUseType as m
                                          Where  a.sourceTypeId2 = m.sourceTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "imCoverage"  as tableName,
         73,
        "sourceTypeId" as testDescription,
         sourceTypeId2 as testValue,
         n             as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 074
INSERT INTO QA_Checks_Log values ( 74, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   stateId      as stateId2,
         'no '        as aMatch,
         count(*)     as n
From     imcoverage
Group by stateId2;

Update tempA as a set aMatch='yes' where (Select m.stateId
                                          From   movesdb20141021.state as m
                                          Where  a.stateId2 = m.stateId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "imCoverage"       as tableName,
         74,
         "statId not valid" as testDescription,
         stateId2           as testValue,
         n                  as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 075
INSERT INTO QA_Checks_Log values ( 75, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   yearId          as yearId2,
         'no '           as aMatch,
         count(*)        as n
From     imcoverage
Group by yearId2;


Update tempA as a set aMatch='yes' where (Select m.yearId
                                          From   movesdb20141021.year as m
                                          Where  a.yearId2 = m.yearId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "imCoverage" as tableName,
         75,
        "yearId"      as testDescription,
         yearId2      as testValue,
         n            as count               --
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,          TestDescription )
       values
                           ("monthVmtFraction", "Table Check:");

--       check no. 076
-- INSERT INTO QA_Checks_Log values ( 76, 'OK', '20141104', curDate(), curTime() );
-- Drop     table if exists tempA;
-- Create   table           tempA
-- Select   isLeapYear      as isLeapYear2,
--          'no '           as aMatch,
--          count(*)        as n
-- From     monthvmtfraction
-- Group by isLeapYear2;
--
--
-- Update tempA as a set aMatch='yes' where isLeapYear2 in ('y', 'n');
--
-- Insert into County_Database_Checks
--        ( TableName,
--          CheckNumber,
--          TestDescription,
--          testValue,
--          count  )
-- Select   "monthvmtfraction"     as tableName,
--           76,
--         "isLeapYear not Y or N" as testDescription,
--         useIMyn2               as testValue,
--          n                      as count
-- From     tempA
-- Where    aMatch <> 'yes';
--
-- Select * from County_Database_Checks;
--

--       check no. 077
INSERT INTO QA_Checks_Log values ( 77, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   monthId      as monthId2,
         'no '        as aMatch,
         count(*)     as n
From     monthVmtFraction
Group by monthId2;


Update tempA as a set aMatch='yes' where (Select m.monthId
                                          From   movesdb20141021.monthOfAnyYear as m
                                          Where  a.monthId2 = m.monthId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "monthVmtFraction" as tableName,
         77,
        "monthId"           as testDescription,
         monthId2           as testValue,
         n                  as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 078
-- INSERT INTO QA_Checks_Log values ( 78, 'OK', '20141104', curDate(), curTime() );
-- Insert into County_Database_Checks
--        ( tableName,
--          checkNumber,
--          testDescription,
--          testValue,
--            sourceTypeId  )
--
-- Select  "monthVmtFraction"               as tableName,
--          78                              as checkNumber,
--         "sum of monthVmtFraction <> 1.0" as testDescription,
--          sum(monthVmtFraction)           as testValue,
--            sourceTypeId
--
-- From     monthVmtFraction
-- Group by sourceTypeId,
--          isLeapYear
-- Having   testValue <0.999 or testValue >1.001;


--       check no. 079
INSERT INTO QA_Checks_Log values ( 79, 'OK', @hVersion, curDate(), curTime() );
Drop     table tempA;
Create   table           tempA
Select   sourceTypeId as sourceTypeId2,
         'no '        as aMatch,
         count(*)     as n
From     monthVmtFraction
Group by sourceTypeId2;


Update tempA as a set aMatch='yes' where (Select m.sourceTypeId
                                          From   movesdb20141021.sourceUseType as m
                                          Where  a.sourceTypeId2 = m.sourceTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "monthVmtFraction" as tableName,
         79,
         "sourceTypeId"     as testDescription,
         sourceTypeId2      as testValue,
         n                  as count
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,  TestDescription )
       values
                           ("roadType", "Table Check:");


--       check no. 080
INSERT INTO QA_Checks_Log values ( 80, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   roadTypeId as roadTypeId2,
         'no '      as aMatch,
         count(*)   as n
From     roadType
Group by roadTypeId2;


Update tempA as a set aMatch='yes' where (Select m.roadTypeId
                                          From   movesdb20141021.roadType as m
                                          Where  a.roadTypeId2 = m.roadTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "roadType"   as tableName,
         80,
         "roadTypeId" as testDescription,
         roadTypeId2  as testValue,
         n            as count               --
From     tempA
Where    aMatch <> 'yes';

--       check no. 081  -- no check

--       check no. 082
INSERT INTO QA_Checks_Log values ( 82, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   rampFraction as rampFraction2,
         'no '        as aMatch,
         count(*)     as n
From     roadType
Group by rampFraction2;


Update tempA as a set aMatch='yes' where rampFraction2>=0.0 and rampFraction2<=1.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "roadType"     as tableName,
         82,
        "rampFraction"  as testDescription,
         rampFraction2  as testValue,
         n              as count               --
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,               TestDescription )
       values
                           ("roadTypeDistribution",  "Table Check:");


--       check no. 083
INSERT INTO QA_Checks_Log values ( 83, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   roadTypeId as roadTypeId2,
         'no '      as aMatch,
         count(*)   as n
From     roadTypeDistribution
Group by roadTypeId2;

Update tempA as a set aMatch='yes' where (Select m.roadTypeId
                                          From   movesdb20141021.roadType as m
                                          Where  a.roadTypeId2 = m.roadTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "roadTypeDistribution" as tableName,
         83,
        "roadTypeId"            as testDescription,
         roadTypeId2            as testValue,
         n                      as count
From     tempA
Where    aMatch <> 'yes';

--       check no. 084
INSERT INTO QA_Checks_Log values ( 84, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue,
           sourceTypeId  )

Select  "roadTypeDistribution"              as tableName,
         84                                 as checkNumber,
        "sum of roadTypeVmtFraction <> 1.0" as testDescription,
         sum(roadTypeVmtFraction)           as testValue,
           sourceTypeId

From     roadTypeDistribution
Group by sourceTypeId
Having   testValue <0.999 or testValue >1.001;


--       check no. 085
INSERT INTO QA_Checks_Log values ( 85, 'OK', @hVersion, curDate(), curTime() );
Drop     table tempA;
Create   table tempA
Select   sourceTypeId as sourceTypeId2,
         'no '        as aMatch,
         count(*)     as n
From     roadTypeDistribution
Group by sourceTypeId2;

Update tempA as a set aMatch='yes' where (Select m.sourceTypeId
                                          From   movesdb20141021.sourceUseType as m
                                          Where  a.sourceTypeId2 = m.sourceTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "roadTypeDistribution" as tableName,
         85,
        "sourceTypeId"          as testDescription,
         sourceTypeId2          as testValue,
         n                      as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 090  -- no check

Insert into   County_Database_Checks ( TableName,                   TestDescription )
       values
                                     ("sourcetypeagedistribution", "Table Check:");


--       check no. 091  
INSERT INTO QA_Checks_Log values ( 91, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   ageId         as ageId2,
         'no '         as aMatch,
         count(*)      as n
From     sourceTypeAgeDistribution
Group by ageId2;

update tempa                       as a,        -- djb's
       movesdb20141021.ageCategory as m         -- code
   set aMatch='yes'  where a.ageId2 = m.ageId;  --

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "sourceTypeAgeDistribution" as tableName,
         91,
        "ageId"                      as testDescription,
         ageId2                      as testValue,
         n                           as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 092
INSERT INTO QA_Checks_Log values ( 92, 'OK', @hVersion, curDate(), curTime() );
Drop     table tempA;
Create   table           tempA
Select   sourceTypeId as sourceTypeId2,
         'no '        as aMatch,
         count(*)     as n
From     sourceTypeAgeDistribution
Group by sourceTypeId2;


Update tempA as a set aMatch='yes' where (Select m.sourceTypeId
                                          From   movesdb20141021.sourceUseType as m
                                          Where  a.sourceTypeId2 = m.sourceTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "sourceTypeAgeDistribution" as tableName,
         92,
        "sourceTypeId"               as testDescription,
         sourceTypeId2               as testValue,
         n                           as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 093
INSERT INTO QA_Checks_Log values ( 93, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue,
           sourceTypeId,
           yearId       )

Select  "sourceTypeAgeDistribution"   as tableName,
         93                           as checkNumber,
        "sum of AgeFraction <> 1.0"   as testDescription,
         sum(ageFraction)             as testValue,
           sourceTypeId,
           yearId

From     sourceTypeAgeDistribution
Group by sourceTypeId,
         yearId
Having   testValue <0.999 or testValue >1.001;


--       check no. 094
INSERT INTO QA_Checks_Log values ( 94, 'OK', @hVersion, curDate(), curTime() );
Drop     table tempA;
Create   table           tempA
Select   yearId       as yearId2,
         'no '        as aMatch,
         count(*)     as n
From     sourceTypeAgeDistribution
Group by yearId2;


Update tempA as a set aMatch='yes' where (Select m.yearId
                                          From   movesdb20141021.year as m
                                          Where  a.yearId2 = m.yearId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "sourceTypeAgeDistribution" as tableName,
         94,
        "yearId"                     as testDescription,
         yearId2                     as testValue,
         n                           as count
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,        TestDescription )
       values
                           ("sourceTypeYear", "Table Check:");


--       check no. 095
INSERT INTO QA_Checks_Log values ( 95, 'OK', @hVersion, curDate(), curTime() );
Drop     table tempA;
Create   table           tempA
Select   sourceTypeId   as sourceTypeId2,
         'no '          as aMatch,
         count(*)       as n
From     sourceTypeYear
Group by sourceTypeId2;


Update tempA as a set aMatch='yes' where (Select min(m.yearId)
                                          From   movesdb20141021.sourceTypeYear as m
                                          Where  a.sourceTypeId2 = m.sourceTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "sourceTypeYear" as tableName,
         95,
        "sourceTypeId"    as testDescription,
         sourceTypeId2    as testValue,
         n                as count
From     tempA
Where    aMatch <> 'yes';

--       check no. 096  -- no check

--       check no. 097
INSERT INTO QA_Checks_Log values ( 97, 'OK', @hVersion, curDate(), curTime() );
Drop     table tempA;
Create   table           tempA
Select   sum(sourceTypePopulation) as sourceTypePopulation2,
         a.yearId,
         b.HPMSVtypeId,
         b.HPMSBaseYearVMT,
      -- HPMSVmt              as HPMSVmt,
         'no '                as aMatch,
         count(*)             as n

From                     sourceTypeYear as a
Join     movesdb20141021.sourceUseType  as c on c.sourceTypeId = a.sourceTypeId
Join                     hpmsVTypeYear  as b on b.HPMSVtypeId  = c.HPMSVtypeId

where    a.yearId = b.yearId
Group by a.yearId,
         b.HPMSVtypeId;

Update tempA as a set aMatch='yes' where a.HPMSBaseYearVMT >0 and sourceTypePopulation2<>0;
Update tempA as a set aMatch='yes' where a.HPMSBaseYearVMT= 0 and sourceTypePopulation2= 0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         HPMSVtypeId,
         yearId
 )
Select   "sourceTypeYear or hpmsVTypeYear"                as tableName,
         97,
        "sourceTypePopulation or HPMSBaseYearVMT is zero" as testDescription,
         HPMSBaseYearVMT                                  as testValue,
         n                                                as count,
         HPMSVTypeId,
         yearId

From     tempA
Where    aMatch <> 'yes';

--       check no. 098  -- no check

--       check no. 099
INSERT INTO QA_Checks_Log values ( 99, 'OK', @hVersion, curDate(), curTime() );
Drop     table tempA;
Create   table           tempA
Select   yearId       as yearId2,
         'no '        as aMatch,
         count(*)     as n
From     sourceTypeYear
Group by yearId2;


Update tempA as a set aMatch='yes' where (Select m.yearId
                                          From   movesdb20141021.year as m
                                          Where  a.yearId2 = m.yearId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "sourceTypeYear" as tableName,
         99,
        "yearId"          as testDescription,
         yearId2          as testValue,
         n                as count
From     tempA
Where    aMatch <> 'yes';

--       check no. 100  -- no check

--       check no. 101  -- no check

Insert into   County_Database_Checks ( TableName,  TestDescription )
       values
                           ("state",    "Table Check:");

--       check no. 102
INSERT INTO QA_Checks_Log values ( 102, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   stateId      as stateId2,
         'no '        as aMatch,
         count(*)     as n
From     state
Group by stateId2;

Update tempA as a set aMatch='yes' where (Select m.stateId
                                          From   movesdb20141021.state as m
                                          Where  a.stateId2 = m.stateId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "state"            as tableName,
         102,
         "statId not valid" as testDescription,
         stateId2           as testValue,
         n                  as count
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,  TestDescription )
       values
                           ("year",     "Table Check:");


--       check no. 103
INSERT INTO QA_Checks_Log values ( 103, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   isBaseYear   as isBaseYear2,
         'no '        as aMatch,
         count(*)     as n
From     year
Group by isBaseYear2;


Update tempA as a set aMatch='yes' where isBaseYear2 in ('Y', 'N');

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "year"                  as tableName,
         103,
         "isBaseYear not Y or N" as testDescription,
         null                    as testValue,
         n                       as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 104
INSERT INTO QA_Checks_Log values ( 104, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   fuelYearId   as fuelYearId2,
         yearId       as yearId2,
         'no '        as aMatch,
         count(*)     as n
From     year
Group by fuelYearId2,
         yearId2;


Update tempA set aMatch='yes' where fuelYearId2=yearId2;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count     )
Select   "year"                          as tableName,
         104                             as checkNumber,
        "fuelYearId not equal to yearId" as testDescription,
         fuelYearId2                     as testValue,
         n                               as count

From     tempA
Where    aMatch <> 'yes';


--       check no. 105
INSERT INTO QA_Checks_Log values ( 105, 'OK', @hVersion, curDate(), curTime() );
Drop     table tempA;
Create   table           tempA
Select   yearId       as yearId2,
         'no '        as aMatch,
         count(*)     as n
From     year
Group by yearId2;


Update tempA as a set aMatch='yes' where (Select m.yearId
                                          From   movesdb20141021.year as m
                                          Where  a.yearId2 = m.yearId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "year"   as tableName,
         105,
        "yearId"  as testDescription,
         yearId2  as testValue,
         n        as count
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,  TestDescription )
       values
                           ("zone",     "Table Check:");

--       check no. 106
INSERT INTO QA_Checks_Log values ( 106, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   countyId        as countyId2,
         'no '           as aMatch,
         count(*)        as n
From     zone
Group by countyId2;

Update tempA as a set aMatch='yes' where (Select m.countyId
                                          From   movesdb20141021.county as m
                                          Where  a.countyId2 = m.countyId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "zone"     as tableName,
         106,
        "countyId"  as testDescription,
         countyId2  as testValue,
         n          as count               --
From     tempA
Where    aMatch <> 'yes';

--       check no. 107
INSERT INTO QA_Checks_Log values ( 107, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue    )
Select  "zone"                           as tableName,
         107                             as checkNumber,
        "sum of startAllocFactor <> 1.0" as testDescription,
         sum(startAllocFactor)           as testValue
From     zone
-- Group by zoneId
Having   testValue <0.999 or testValue >1.001;

--       check no. 108
INSERT INTO QA_Checks_Log values ( 108, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue    )

Select  "zone"                          as tableName,
         108                            as checkNumber,
        "sum of idleAllocFactor <> 1.0" as testDescription,
         sum(idleAllocFactor)           as testValue
From     zone
-- Group by zoneId
Having   testValue <0.999 or testValue >1.001;

--       check no. 109
INSERT INTO QA_Checks_Log values ( 109, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue    )

Select  "zone"                         as tableName,
         109                           as checkNumber,
        "sum of SHPAllocFactor <> 1.0" as testDescription,
         sum(SHPAllocFactor)           as testValue
From     zone
-- Group by zoneId
Having   testValue <0.999 or testValue >1.001;


--       check no. 110
INSERT INTO QA_Checks_Log values ( 110, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   zoneId          as zoneId2,
         'no '           as aMatch,
         count(*)        as n
From     zone
Group by zoneId2;


Update tempA as a set aMatch='yes' where (Select m.zoneId
                                          From   movesdb20141021.zone as m
                                          Where  a.zoneId2 = m.zoneId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "zone"   as tableName,
         110,
        "zoneId"  as testDescription,
         zoneId2  as testValue,
         n        as count
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,       TestDescription )
       values
                           ("zoneMonthHour", "Table Check:");

--       check no. 111
INSERT INTO QA_Checks_Log values ( 111, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   hourId    as hourId2,
         'no '     as aMatch,
         count(*)  as n
From     zoneMonthHour
Group by hourId2;

Update tempA as a set aMatch='yes' where (Select m.hourId
                                          From   movesdb20141021.hourOfAnyDay as m
                                          Where  a.hourId2 = m.hourId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "zoneMonthHour" as tableName,
         111,
         "hourId"        as testDescription,
         hourId2         as testValue,
         n               as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 112
INSERT INTO QA_Checks_Log values ( 112, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   monthId      as monthId2,
         'no '        as aMatch,
         count(*)     as n
From     zoneMonthHour
Group by monthId2;


Update tempA as a set aMatch='yes' where (Select m.monthId
                                          From   movesdb20141021.monthOfAnyYear as m
                                          Where  a.monthId2 = m.monthId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "zoneMonthHour"    as tableName,
         112,
        "monthId"           as testDescription,
         monthId2           as testValue,
         n                  as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 113
INSERT INTO QA_Checks_Log values ( 113, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   temperature  as temperature2,
         'no '        as aMatch,
         count(*)     as n
From     zoneMonthHour
Group by temperature2;


Update tempA as a set aMatch='yes' where temperature2>=-80.0 and temperature2<=150.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "zoneMonthHour"    as tableName,
         113,
        "temperature"       as testDescription,
         temperature2       as testValue,
         n                  as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 114  -- no check

--       check no. 115
INSERT INTO QA_Checks_Log values ( 115, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   relHumidity  as relHumidity2,
         'no '        as aMatch,
         count(*)     as n
From     zoneMonthHour
Group by relHumidity2;


Update tempA as a set aMatch='yes' where relHumidity2>=0.0 and relHumidity2<=100.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "zoneMonthHour"    as tableName,
         115,
        "relHumidity"       as testDescription,
         relHumidity2       as testValue,
         n                  as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 116  -- no check
--       check no. 117  -- no check
--       check no. 118  -- no check

--       check no. 119
INSERT INTO QA_Checks_Log values ( 119, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   zoneId          as zoneId2,
         'no '           as aMatch,
         count(*)        as n
From     zonemonthhour
Group by zoneId2;


Update tempA as a set aMatch='yes' where (Select m.zoneId
                                          From   movesdb20141021.zone as m
                                          Where  a.zoneId2 = m.zoneId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "zoneMonthHour" as tableName,
         119,
        "zoneId"         as testDescription,
         zoneId2         as testValue,
         n               as count               --
From     tempA
Where    aMatch <> 'yes';


Insert into   County_Database_Checks ( TableName,      TestDescription )
       values
                           ("zoneRoadType", "Table Check:");

--       check no. 120
INSERT INTO QA_Checks_Log values ( 120, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   roadTypeId as roadTypeId2,
         'no '      as aMatch,
         count(*)   as n
From     zoneRoadtype
Group by roadTypeId2;


Update tempA as a set aMatch='yes' where (Select m.roadTypeId
                                          From   movesdb20141021.roadType as m
                                          Where  a.roadTypeId2 = m.roadTypeId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "zoneRoadType" as tableName,
         120,
        "roadTypeId"            as testDescription,
         roadTypeId2            as testValue,
         n                      as count
From     tempA
Where    aMatch <> 'yes';


--       check no. 121
INSERT INTO QA_Checks_Log values ( 121, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   zoneId          as zoneId2,
         'no '           as aMatch,
         count(*)        as n
From     zoneroadtype
Group by zoneId2;


Update tempA as a set aMatch='yes' where (Select m.zoneId
                                          From   movesdb20141021.zone as m
                                          Where  a.zoneId2 = m.zoneId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "zoneRoadType" as tableName,
         121,
        "zoneId"        as testDescription,
         zoneId2        as testValue,
         n              as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 122
INSERT INTO QA_Checks_Log values ( 122, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )

Select  "zoneRoadType"       as tableName,
         122,
        "roadTypeId"         as testDescription,
         sum(SHOAllocFactor) as SHOAllocFactor2,
         count(*)
From     zoneroadtype
Group by roadTypeId
Having   SHOAllocFactor2 <0.999 or SHOAllocFactor2 >1.000000001;


Insert into   County_Database_Checks ( TableName,           TestDescription )
       values
                           ("emissionRateByAge", "Table Check:");


--       check no. 123  no check

--       check no. 124
INSERT INTO QA_Checks_Log values ( 124, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   polProcessId    as polProcessId2,
         'no '           as aMatch,
         count(*)        as n
From     emissionRateByAge
Group by polProcessId2;


Update tempA as a set aMatch='yes' where (Select min(m.polProcessId)
                                          From   movesdb20141021.emissionRateByAge as m
                                          Where  a.polProcessId2 = m.polProcessId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "emissionRateByAge" as tableName,
         124,
        "polProcessId"       as testDescription,
         polProcessId2       as testValue,
         n                   as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 125
INSERT INTO QA_Checks_Log values ( 125, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   opModeId        as opModeId2,
         'no '           as aMatch,
         count(*)        as n
From     emissionRateByAge
Group by opModeId2;

Update tempA as a, movesdb20141021.operatingmode as m
  set aMatch='yes' 
  where a.opModeId2 = m.opModeId;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "emissionRateByAge" as tableName,
         125,
        "opModeId"       as testDescription,
         opModeId2       as testValue,
         n               as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 126
INSERT INTO QA_Checks_Log values ( 126, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   ageGroupId      as ageGroupId2,
         'no '           as aMatch,
         count(*)        as n
From     emissionRateByAge
Group by ageGroupId2;


Update tempA as a set aMatch='yes' where (Select min(m.ageGroupId)
                                          From   movesdb20141021.ageGroup as m
                                          Where  a.ageGroupId2 = m.ageGroupId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "emissionRateByAge" as tableName,
         126,
        "ageGroupId"         as testDescription,
         ageGroupId2         as testValue,
         n                   as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 127  -- no check
--       check no. 128  -- no check
--       check no. 129  -- no check
--       check no. 130  -- no check
--       check no. 131  -- no check


Insert into   County_Database_Checks ( TableName,    TestDescription )
       values
                           ("countyYear", "Table Check:");

--       check no. 132
INSERT INTO QA_Checks_Log values ( 132, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   countyId        as countyId2,
         'no '           as aMatch,
         count(*)        as n
From     countyYear
Group by countyId2;

Update tempA as a set aMatch='yes' where (Select m.countyId
                                          From   movesdb20141021.county as m
                                          Where  a.countyId2 = m.countyId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "countyYear" as tableName,
         132,
        "countyId" as testDescription,
         countyId2 as testValue,
         n         as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 133
INSERT INTO QA_Checks_Log values ( 133, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   yearId          as yearId2,
         'no '           as aMatch,
         count(*)        as n
From     countyYear
Group by yearId2;


Update tempA as a set aMatch='yes' where (Select min(m.yearId)
                                          From   movesdb20141021.year as m
                                          Where  a.yearId2 = m.yearId);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "countyYear" as tableName,
         133,
        "yearId" as testDescription,
         yearId2 as testValue,
         n       as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 134
INSERT INTO QA_Checks_Log values ( 134, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   refuelingVaporProgramAdjust as refuelingVaporProgramAdjust2,
         'no '                       as aMatch,
         count(*)                    as n
From     countyYear
Group by refuelingVaporProgramAdjust2;


Update tempA as a set aMatch='yes' where refuelingVaporProgramAdjust2 >= 0.0
                                     and refuelingVaporProgramAdjust2 <= 1.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "countyYear"                 as tableName,
         134,
        "refuelingVaporProgramAdjust" as testDescription,
         refuelingVaporProgramAdjust2 as testValue,
         n       as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 135
INSERT INTO QA_Checks_Log values ( 135, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   refuelingSpillProgramAdjust as refuelingSpillProgramAdjust2,
         'no '                       as aMatch,
         count(*)                    as n
From     countyYear
Group by refuelingSpillProgramAdjust2;


Update tempA as a set aMatch='yes' where refuelingSpillProgramAdjust2 >= 0.0
                                     and refuelingSpillProgramAdjust2 <= 1.0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "countyYear"                 as tableName,
         135,
        "refuelingSpillProgramAdjust" as testDescription,
         refuelingSpillProgramAdjust2 as testValue,
         n       as count               --
From     tempA
Where    aMatch <> 'yes';


--       check no. 136
INSERT INTO QA_Checks_Log values ( 136, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   roadTypeId                  as roadType2,
         SHOAllocFactor              as SHOAllocFactor2,
         'no '                       as aMatch,
         count(*)                    as n
From     zoneRoadType
Group by roadType2;

-- Select * from tempA;

Update tempA as a set a.aMatch='yes' where a.SHOAllocFactor2 = 1.0
                                       and a.roadType2 in (2,3,4,5);

-- individual road type SHOAlloctFactor error
Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count,
         roadTypeId  )
Select   "zoneRoadType"               as tableName,
         136                          as checkNumber,
        "SHOAllocFactor <> 1.0"       as testDescription,
         SHOAllocFactor2              as testValue,
         n                            as count,
         roadType2                    as roadTypeId
From     tempA
Where    aMatch <> 'yes' and roadType2 in (2,3,4,5);




-- -- START March 2013 Checks------------------------------------------------

--       check no. 200
INSERT INTO QA_Checks_Log values ( 200, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
 ( TableName,
   checkNumber,
   TestDescription,
   testValue )
 values
 ("roadType",
   200,
  "Number of Rows",
  (Select count(*) from roadType) );
Delete from County_Database_Checks where checkNumber=200 and testValue>0;

--       check no. 201
INSERT INTO QA_Checks_Log values ( 201, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue)
Select   "roadType"                         as tableName,
         201,
        "restricted rampFraction not > 0.0" as testDescription,
         rampFraction                       as testValue
From     roadType
Where    roadTypeId in (2,4)
  and    rampFraction < .0001;

--       check no. 202
INSERT INTO QA_Checks_Log values ( 202, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue)
Select   "roadType"                         as tableName,
         202,
        "restricted rampFraction not < 0.0" as testDescription,
         rampFraction                       as testValue
From     roadType
Where    roadTypeId not in (2,4)
  and    rampFraction > 0.0;


--       check no. 203
INSERT INTO QA_Checks_Log values ( 203, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
 ( TableName,
   checkNumber,
   TestDescription,
   testValue )
 values
 ("hpmsVTypeYear",
   203,
  "Number of Rows",
  (Select count(*) from hpmsVTypeYear) );
Delete from County_Database_Checks where checkNumber=203 and testValue>0;

--       check no. 204
INSERT INTO QA_Checks_Log values ( 204, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
 ( TableName,
   checkNumber,
   TestDescription,
   testValue )
 values
 ("sourceTypeYear",
   204,
  "Number of Rows",
  (Select count(*) from sourceTypeYear) );
Delete from County_Database_Checks where checkNumber=204 and testValue>0;

--       check no. 206
INSERT INTO QA_Checks_Log values ( 206, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
 ( TableName,
   checkNumber,
   TestDescription,
   testValue )
 values
 ("county",
   206,
  "Number of Rows",
  (Select count(*) from county) );
Delete from County_Database_Checks where checkNumber=206 and testValue>0;

--       check no. 207
INSERT INTO QA_Checks_Log values ( 207, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
 ( TableName,
   checkNumber,
   TestDescription,
   testValue )
 values
 ("state",
   207,
  "Number of Rows",
  (Select count(*) from state) );
Delete from County_Database_Checks where checkNumber=207 and testValue>0;

--       check no. 208
INSERT INTO QA_Checks_Log values ( 208, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
 ( TableName,
   checkNumber,
   TestDescription,
   testValue )
 values
 ("zone",
   208,
  "Number of Rows",
  (Select count(*) from zone) );
Delete from County_Database_Checks where checkNumber=208 and testValue>0;

--       check no. 209
INSERT INTO QA_Checks_Log values ( 209, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
 ( TableName,
   checkNumber,
   TestDescription,
   testValue )
 values
 ("zoneRoadType",
   209,
  "Number of Rows",
  (Select count(*) from zoneRoadType) );
Delete from County_Database_Checks where checkNumber=209 and testValue>0;


--       check no. 301   11/13
INSERT INTO QA_Checks_Log values ( 301, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
 ( TableName,
   checkNumber,
   TestDescription,
   testValue )
 values
 ("fuelFormulation",
   301,
  "T50 Missing",
  (Select count(*)
   from   information_schema.columns
   where  table_name   = 'fuelformulation'
     and  column_name  = 't50'
     and  table_schema = database()) );
Delete from County_Database_Checks where checkNumber=301 and testValue>0;

-- -------------------------------------------------------------------------------

INSERT INTO QA_Checks_Log values ( 401, 'OK', @hVersion, curDate(), curTime() );
drop   table if exists mini;
create table mini
Select   sourceTypeId,
         'roadTypeDistribution'   as tableName,
         sum(roadTypeVMTfraction) as distribution
from     roadTypeDistribution
group by sourceTypeId;

Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue,
         sourceTypeId )
Select  'roadTypeDistribution'    as tableName,
         401                      as checkNumber,
         'incorrect distribution' as testDescription,
         distribution             as testValue,
         sourceTypeId             as sourceTypeId
From     mini
Where    distribution < 0.0
   or    distribution > 0.0 and distribution < 0.999
   or    distribution > 1.001
   or    distribution is null;

INSERT INTO QA_Checks_Log values ( 402, 'OK', @hVersion, curDate(), curTime() );

alter table mini add column population float;
update      mini as m set   population = (select sum(sourceTypePopulation)
                                          from   sourceTypeYear as s
                                          where m.sourceTypeId = s.sourceTypeId);

alter table mini add column descp char(50);

update      mini set distribution = 1.0 where distribution > 0.999
                                          and distribution < 1.001;


update      mini set descp = 'Distribution = 0 and population > 0'
                                        where distribution =  0.0
                                          and population   >  0.0;

Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue,
         sourceTypeId
       )
Select   'sourceTypeYear' as tableName,
         402              as checkNumber,
         descp            as testDescription,
         distribution     as testValue,
         sourceTypeId     as sourceType
From     mini
Where    descp is not null;

drop table mini;

INSERT INTO QA_Checks_Log values ( 403, 'OK', @hVersion, curDate(), curTime() );

drop table if exists tempA;
create   table tempA
select   sourceTypeId,
         sum(monthVmtfraction) as s,
         'n' as Ok
from     monthVMTfraction
group by sourceTypeId;

update tempA set Ok = 'y' where s > 0.999 and s < 1.001 and s is not null;

Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue,
         sourceTypeId
       )
Select  'monthVmtFraction'    as tableName,
         403                  as checkNumber,
         'distribution error' as testDescription,
         s                    as testValue,
         sourceTypeId         as sourceType
From     tempA
Where    Ok = 'n';


INSERT INTO QA_Checks_Log values ( 404, 'OK', @hVersion, curDate(), curTime() );

drop   table if exists tempA;  -- hourVmtFraction;        SEE check no. 53
create table tempA
select   a.sourceTypeId,
         a.roadTypeId,
         a.dayId,
         e.monthId,

         sum(a.hourVMTFraction)               as hourVMT,

        (select sum(b.sourceTypePopulation)
         from sourceTypeYear as b
         where a.sourceTypeId=b.sourceTypeId) as sourcePop,

        (select sum(c.dayVmtFraction)
         from dayVmtFraction as c
         where a.sourceTypeId=c.sourceTypeId
           and a.roadTypeId  =c.roadTypeId
           and e.monthId     =c.monthId )     as dayVMT,

        (select sum(d.roadTypeVmtFraction)
         from roadTypeDistribution as d
         where a.sourceTypeId=d.sourceTypeId) as roadVMT

from     hourVmtFraction as a
join     dayVmtFraction  as e on a.sourceTypeId = e.sourceTypeId
                             and a.roadTypeId   = e.roadTypeId
                             and a.dayId        = e.dayId

group by a.sourceTypeId,
         a.roadTypeId,
         a.dayId,
         e.monthId;

update tempA set hourVMT=1.0 where hourVMT > 0.999 and hourVMT < 1.001;
update tempA set  dayVMT=1.0 where  dayVMT > 0.999 and  dayVMT < 1.001;
update tempA set roadVMT=1.0 where roadVMT > 0.999 and roadVMT < 1.001;

-- select 13*5*2*12;      -- 1560,   sourceTypes * roadTypes * dayIds * months;

-- select * from tempA;   -- 1560 rows

alter table tempA add column Error char(2);

update tempA set Error='OK' where hourVMT=1;
update tempA set Error=NULL where hourVMT<=0.999 or hourVMT>=1.001;
update tempA set Error='OK' where hourVMT=0 and sourcePop = 0;
update tempA set Error='OK' where hourVMT=0 and dayVMT    = 0;
update tempA set Error='OK' where hourVMT=0 and roadVMT   = 0;

-- Select * from tempA;


Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue,
         sourceTypeId
       )
Select  'hourVmtFraction'     as tableName,
         404                  as checkNumber,
         'distribution error' as testDescription,
         hourVMT              as testValue,
         sourceTypeId         as sourceType
From     tempA
Where    ERROR is NULL;


drop   table if exists tempA;  -- dayVmtFraction;       SEE check no. 23
create table tempA
select   a.sourceTypeId,
         a.monthId,
         a.roadTypeId,
         a.dayId,

        (select sum(b.dayVmtFraction)
         from dayVmtFraction as b
         where a.sourceTypeId=b.sourceTypeId
           and a.roadTypeId  =b.roadTypeId
           and a.monthId     =b.monthId )     as dayVMT,

        (select sum(c.sourceTypePopulation)
         from sourceTypeYear as c
         where a.sourceTypeId=c.sourceTypeId) as sourcePop,

        (select sum(d.roadTypeVmtFraction)
         from roadTypeDistribution as d
         where a.sourceTypeId=d.sourceTypeId) as roadVMT,

        (select sum(e.monthVmtFraction)
         from monthVmtFraction as e
         where a.sourceTypeId=e.sourceTypeId) as monthVMT

from     dayVmtFraction as a

where    roadtypeid in (1,2,3,4,5)

group by a.sourceTypeId,
         a.monthId,
         a.roadTypeId,
         a.dayId;


update tempA set  dayVMT = 1.0 where  dayVMT > 0.999 and  dayVMT < 1.001;
update tempA set roadVMT = 1.0 where roadVMT > 0.999 and roadVMT < 1.001;

alter table tempA add column Error char(2);
update tempA set Error='OK' where dayVMT=1;
update tempA set Error=NULL where dayVMT<=0.999 or dayVMT>=1.001;
update tempA set Error='OK' where dayVMT=0 and sourcePop = 0;
update tempA set Error='OK' where dayVMT=0 and roadVMT   = 0;
update tempA set Error='OK' where dayVMT=0 and monthVMT  = 0;

-- select * from tempA;


INSERT INTO QA_Checks_Log values ( 405, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue,
         sourceTypeId
       )
Select  'dayVmtFraction'      as tableName,
         405                  as checkNumber,
         'distribution error' as testDescription,
         dayVMT               as testValue,
         sourceTypeId         as sourceType
From     tempA
Where    ERROR is NULL;

drop   table if exists tempA;  -- avgSpeedDistribution;      SEE check no. 11
create table tempA
select   a.sourceTypeId,
         a.roadTypeId,
         a.hourDayId,

         sum(a.avgSpeedFraction)              as avgSpeed,

        (select sum(b.sourceTypePopulation)
         from sourceTypeYear as b
         where a.sourceTypeId=b.sourceTypeId) as sourcePop,

        (select sum(c.roadTypeVmtFraction)
         from roadTypeDistribution as c
         where a.sourceTypeId=c.sourceTypeId) as roadVMT,

        (select sum(d.hourVMTFraction)
         from hourVmtFraction as d
         where a.sourceTypeId=d.sourceTypeId
           and a.roadTypeId  =d.roadTypeId)   as dayVMT

from     avgSpeedDistribution as a

group by a.sourceTypeId,
         a.roadTypeId,
         a.hourDayId;

-- select * from tempA;

update tempA set avgSpeed=1.0 where avgSpeed>0.999 and avgSpeed<1.001;
update tempA set roadVMT =1.0 where roadVMT >0.999 and roadVMT <1.001;
update tempA set dayVMT  = round(dayVMT,3);

alter table tempA add column Error char(2);
update tempA set Error='OK' where avgSpeed=1;

update tempA set Error=NULL where avgSpeed<=0.999 or avgSpeed>=1.001;
update tempA set Error='OK' where avgSpeed=0 and sourcePop = 0;
update tempA set Error='OK' where avgSpeed=0 and roadVMT   = 0;
update tempA set Error='OK' where avgSpeed=0 and dayVMT    = 0;


INSERT INTO QA_Checks_Log values ( 406, 'OK', @hVersion, curDate(), curTime() );
Insert into County_Database_Checks
       ( tableName,
         checkNumber,
         testDescription,
         testValue,
         sourceTypeId,
         roadTypeId,
         hourDayId
       )
Select  'avgSpeedDistribution' as tableName,
         406                   as checkNumber,
         'distribution error'  as testDescription,
         avgSpeed              as testValue,
         sourceTypeId,
         roadTypeId,
         hourDayId
From     tempA
Where    ERROR is NULL;

drop table if exists tempA;
-- End   Feb 14, 2014 ----------------------------------------------------------------------

-- start Sept 23 2014:
-- check the fuelEngFracion distributions of AVFT table

drop     table if exists tempA;
create   table           tempA
select   sourceTypeId,
         modelYearId,
         sum(fuelEngFraction) as distribution
from     avft
group by sourceTypeId,
         modelYearId;

update tempA set distribution = 1.0 where distribution > 0.999 and distribution < 1.001;


INSERT INTO QA_Checks_Log values ( 407, 'OK', @hVersion, curDate(), curTime() );
  Insert into County_Database_Checks
       ( tableName,

         checkNumber,
         testDescription,
         testValue
       )
  Select 'avft'                         as tableName,
         407                            as checkNumber,
         'Sum <> 1.0 Errors:'           as testDescription,
         ( select count(*)
           from   tempA
           where  distribution <> 1.0 ) as testValue;

delete from County_Database_Checks where checkNumber = 407 and testValue = 0;

drop     table if exists tempA;

-- -------------------------------------------------------------------------------
-- --------- Add ten table checks  -- from 9/25/2014 email, errors 421 - 464 -----
-- --------- Start                                                          ------
-- -------------------------------------------------------------------------------



Insert into   County_Database_Checks ( TableName,           TestDescription )
       values                        ("fuelUsageFraction", "Table Check:");


-- check fuelYear:

-- select 'check 421';
INSERT INTO QA_Checks_Log values ( 421, 'OK', @hVersion, curDate(), curTime() );
drop   table if exists tempA ;
create table tempA
select  fuelYearId,
       'no '    as aMatch,
       count(*) as n
from   fuelUsageFraction
group by fuelYearId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   year as y
                                          Where  a.fuelYearId = y.yearId) > 0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "fuelUsageFraction" as tableName,
         421                 as checkNumber,
        "fuelYearId"         as testDescription,
         fuelYearId          as testValue,
         count(*)            as cou
from     tempA
where    aMatch <> 'yes '; -- and fuelYearId not in (1947, 2014);

Delete from County_Database_Checks where checkNumber=421 and count=0;


-- check countyId

-- select 'check 422';
INSERT INTO QA_Checks_Log values ( 422, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   countyId,
         'no '           as aMatch,
         count(*)        as n
From     fuelUsageFraction
group by countyId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   county as c
                                          Where  a.countyId = c.CountyId
                                     --     and  a.countyId<>37085    -- creates error
                                                                  ) > 0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count )
Select   "fuelUsageFraction"  as tableName,
         422                  as checkNumber,
        'countyId'            as testDescription,
         countyId             as testValue,
         count(*)             as count
from     tempA
where    aMatch <> 'yes';  -- and countyId not in (37085, 54321);

Delete from County_Database_Checks where checkNumber=422 and count=0;


-- check modelYearGroupId

-- select 'check 423';
INSERT INTO QA_Checks_Log values ( 423, 'OK', @hVersion, curDate(), curTime() );
Drop     table if exists tempA;
Create   table           tempA
Select   modelYearGroupId,
         'no '           as aMatch,
         count(*)        as n
From     fuelUsageFraction
group by modelYearGroupId;

-- select * from tempA;

-- select * from modelYearGroup;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.modelYearGroup as m
                                          Where  a.modelYearGroupId = m.modelYearGroupId
                                 --         and  a.modelYearGroupId<>1975  -- creates error
                                                                  ) > 0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count )
Select   "fuelUsageFraction"  as tableName,
         423                  as checkNumber,
        'modelYearGroupId'    as testDescription,
         modelYearGroupId     as testValue,
         count(*)             as count
from     tempA
where    aMatch <> 'yes';

Delete from County_Database_Checks where checkNumber=423 and count=0;



-- select 'check 424';
INSERT INTO QA_Checks_Log values ( 424, 'OK', @hVersion, curDate(), curTime() );
-- check sourceBinFuelTypeId

Drop     table if exists tempA;
Create   table           tempA
Select   sourceBinFuelTypeId,
         'no '           as aMatch,
         count(*)        as n
From     fuelUsageFraction
group by sourceBinFuelTypeId;

-- select * from tempA;
-- select * from fuelType;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.fuelType as f
                                          Where  a.sourceBinFuelTypeId = f.fuelTypeId
                              --            and  a.sourceBinFuelTypeId<>4  -- creates error
                                                                  ) > 0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count )
Select   "fuelUsageFraction"  as tableName,
         424                  as checkNumber,
        'sourceBinFuelTypeId' as testDescription,
         sourceBinFuelTypeId  as testValue,
         count(*)             as count
from     tempA
where    aMatch <> 'yes';

Delete from County_Database_Checks where checkNumber=424 and count=0;



-- select 'check 425';
INSERT INTO QA_Checks_Log values ( 425, 'OK', @hVersion, curDate(), curTime() );
-- check fuelSupplyFuelTypeId

Drop     table if exists tempA;
Create   table           tempA
Select   fuelSupplyFuelTypeId,
         'no '           as aMatch,
         count(*)        as n
From     fuelUsageFraction
group by fuelSupplyFuelTypeId;

-- select * from tempA;
-- select * from fuelType;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.fuelType as f
                                          Where  a.fuelSupplyFuelTypeId = f.fuelTypeId
                              --            and  a.fuelSupplyFuelTypeId<>4  -- creates error
                                                                  ) > 0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count )
Select   "fuelUsageFraction"   as tableName,
         425                   as checkNumber,
        'fuelSupplyFuelTypeId' as testDescription,
         fuelSupplyFuelTypeId  as testValue,
         count(*)              as count
from     tempA
where    aMatch <> 'yes';

Delete from County_Database_Checks where checkNumber=425 and count=0;


-- select 'check 426';
INSERT INTO QA_Checks_Log values ( 426, 'OK', @hVersion, curDate(), curTime() );
-- when fuelSupplyFuelTypeId<>5 then it must match sourceBinfuelTypeId
drop     table tempA;
create   table tempA
select   countyId,
         fuelYearId,
         sourceBinFuelTypeId,
         fuelSupplyFuelTypeId,
         count(*) as cou
From     fuelUsageFraction
where    sourceBinFuelTypeId<>5
  and    sourceBinFuelTypeId<>fuelSupplyFuelTypeId
group by countyId,
         fuelYearId,
         sourceBinFuelTypeId;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         countyId,
         TestDescription,
         testValue,
         fuelYearId,
         count  )
Select  'fuelUsageFraction'  as tableName,
         426                 as checkNumber,
         countyId            as countyId,
        'fuelTypes Mismatch' as testDescription,
         sourceBinFuelTypeId as testValue,
         fuelYearId          as fuelYearId,
         cou                 as count
from     tempA;

Delete from County_Database_Checks where checkNumber=426 and count=0;


-- select 'check 427';
INSERT INTO QA_Checks_Log values ( 427, 'OK', @hVersion, curDate(), curTime() );
-- when fuelSupplyFuelTypeId =5 then sourceBinFuelTypeId must = 1 or 5
drop     table tempA;
create   table tempA
select *,
       count(*) as cou
from (select countyId,
             fuelYearId,
             sourceBinFuelTypeId,
             fuelSupplyFuelTypeId
      from   fuelUsageFraction
      where  sourceBinFuelTypeId=5
        and  fuelSupplyFuelTypeId<>1) as a
where        a.fuelSupplyFuelTypeId<>5
group by     countyId,
             fuelYearId,
             fuelSupplyFuelTypeId;

Insert into County_Database_Checks
           ( TableName,
             CheckNumber,
             countyId,
             fuelYearId,
             TestDescription,
             testValue,
             count  )
Select      'fuelUsageFraction'               as tableName,
             427                              as checkNumber,
             countyId                         as countyId,
             fuelYearId                       as fuelYearId,
            ' incorrrect sourceBinFuelTypeId' as testDescription,
             sourceBinFuelTypeId              as testValue,
             cou                              as count
from         tempA;

Delete from County_Database_Checks where checkNumber=427 and count=0;


-- select 'check 428';
INSERT INTO QA_Checks_Log values ( 428, 'OK', @hVersion, curDate(), curTime() );
-- when fuelSupplyFuelTypeId =5 then sum(usageFraction) must = 1.0
drop     table tempA;
create   table tempA
select *,
       count(*) as cou
from (select   countyId,
               fuelYearId,
               sum(usageFraction) as s
      from     fuelUsageFraction
      where    sourceBinFuelTypeId=5
      group by countyId,
               fuelYearId) as a;

Insert into County_Database_Checks
           ( TableName,
             CheckNumber,
             TestDescription,
             testValue,
             countyId,
             fuelYearId,
             count  )
Select      'fuelUsageFraction'   as tableName,
             428                  as checkNumber,
            'distribution <> 1.0' as testDescription,
             s,
             countyId             as countyId,
             fuelYearId           as fuelYearId,
             cou                  as count
from         tempA
where    s < 0.999
   or    s > 1.001;

Delete from County_Database_Checks where checkNumber=428 and count=0;


Insert into   County_Database_Checks ( TableName,                      TestDescription )
       values                        ("hotellingActivityDistribution", "Table Check:");


-- select 'check 429';
INSERT INTO QA_Checks_Log values ( 429, 'OK', @hVersion, curDate(), curTime() );
-- check opModeId of hotellingActivityDistribution

Drop     table if exists tempA;
Create   table           tempA
Select   opModeId,
         'no '           as aMatch,
         count(*)        as n
From     hotellingActivityDistribution
group by opModeId;

-- select * from tempA;
-- select * from operatingMode order by opModeId;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.operatingMode as o
                                          Where  a.opModeId = o.opModeId ) > 0;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count )
Select   "hotellingActivityDistribution" as tableName,
         429                             as checkNumber,
        'opModeId'                       as testDescription,
         opModeId                        as testValue,
         count(*)                        as count
from     tempA
where    aMatch <> 'yes';

Delete from County_Database_Checks where checkNumber=429 and count=0;



-- select 'check 430';
INSERT INTO QA_Checks_Log values ( 430, 'OK', @hVersion, curDate(), curTime() );
-- check distribution by opModeId
Drop     table if exists tempA;
Create   table           tempA
select   opModeId,
         sum(opModeFraction) as s,
         count(*)            as cou
From     hotellingActivityDistribution
group by beginmodelyearId,endmodelyearid;

-- select * from tempA;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count    )
Select   "hotellingActivityDistribution" as tableName,
         430                             as checkNumber,
        'distribution<>1.0'              as testDescription,
         s                               as testValue,
         cou                             as count
from     tempA
where    s<0.999
   or    s>1.001;

Delete from County_Database_Checks where checkNumber=430 and count=0;


Insert into   County_Database_Checks ( TableName,        TestDescription )
       values                        ("hotellingHours", "Table Check:");

-- select 'check 431';
INSERT INTO QA_Checks_Log values ( 431, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  sourceTypeId,
       'no '    as aMatch,
       count(*) as n
from   hotellingHours
group by sourceTypeId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.sourceUseType as s
                                          Where  s.sourceTypeId = a.sourceTypeId > 0);
                             --              and  s.sourceTypeId <> 52);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "hotellingHours" as tableName,
         431              as checkNumber,
        "sourceTypeId"    as testDescription,
         sourceTypeId     as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=431 and count=0;



-- check hourDayId of hotellingHours:

-- select 'check 432';
INSERT INTO QA_Checks_Log values ( 432, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  hourDayId,
       'no '    as aMatch,
       count(*) as n
from   hotellingHours
group by hourDayId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.hourDay as h
                                          Where  h.hourDayId = a.hourDayId > 0);
                                    --      and  h.hourDayId <> 22);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "hotellingHours" as tableName,
         432              as checkNumber,
        "hourDayId"       as testDescription,
         hourDayId        as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=432 and count=0;



-- check monthId of hotellingHours:

-- select 'check 433';
INSERT INTO QA_Checks_Log values ( 433, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  monthId,
       'no '    as aMatch,
       count(*) as n
from   hotellingHours
group by monthId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.monthOfAnyYear as m
                                          Where  m.monthId = a.monthId > 0);
                                       --   and  m.monthId <> 5);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "hotellingHours" as tableName,
         433              as checkNumber,
        "monthId"         as testDescription,
         monthId          as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=433 and count=0;



-- check yearId of hotellingHours:

-- select 'check 434';
INSERT INTO QA_Checks_Log values ( 434, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  yearId,
       'no '    as aMatch,
       count(*) as n
from   hotellingHours
group by yearId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   year as y
                                          Where  y.yearId = a.yearId > 0);
                            --              and  a.yearId <> 2003);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "hotellingHours" as tableName,
         434              as checkNumber,
        "yearId"          as testDescription,
         yearId           as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=434 and count=0;



-- check ageId of hotellingHours:

-- select 'check 435';
INSERT INTO QA_Checks_Log values ( 435, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  ageId,
       'no '    as aMatch,
       count(*) as n
from   hotellingHours
group by ageId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.ageCategory as c
                                          Where  c.ageId = a.ageId > 0);
                            --              and  a.yearId <> 2003);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "hotellingHours" as tableName,
         435              as checkNumber,
        "ageId"           as testDescription,
         ageId            as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=435 and count=0;



-- check zoneId of hotellingHours:

-- select 'check 436';
INSERT INTO QA_Checks_Log values ( 436, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  zoneId,
       'no '    as aMatch,
       count(*) as n
from   hotellingHours
group by zoneId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   zone as z
                                          Where  z.zoneId = a.zoneId > 0);
                              --            and  a.zoneId <> 10090);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "hotellingHours" as tableName,
         436              as checkNumber,
        "zoneId"          as testDescription,
         zoneId           as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=436 and count=0;



Insert into   County_Database_Checks ( TableName,                        TestDescription )
       values                        ("importStartsOpmoDedistribution", "Table Check:");

-- select 'check 437';
INSERT INTO QA_Checks_Log values ( 437, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  sourceTypeId,
       'no '    as aMatch,
       count(*) as n
from   importStartsOpmoDedistribution
group by sourceTypeId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.sourceUseType as s
                                          Where  s.sourceTypeId = a.sourceTypeId > 0);
                                  --        and  a.sourceTypeId <> 32);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "importStartsOpmoDedistribution" as tableName,
         437                              as checkNumber,
        "sourceTypeId"                    as testDescription,
         sourceTypeId                     as testValue,
         count(*)                         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=437 and count=0;



-- check hourDayId of importStartsOpmoDedistribution:

-- select 'check 438';
INSERT INTO QA_Checks_Log values ( 438, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  hourDayId,
       'no '    as aMatch,
       count(*) as n
from   importStartsOpmoDedistribution
group by hourDayId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.hourDay as h
                                          Where  h.hourDayId = a.hourDayId > 0);
                                --          and  a.hourDayId <> 32);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "importStartsOpmoDedistribution" as tableName,
         438                              as checkNumber,
        "hourDayId"                       as testDescription,
         hourDayId                        as testValue,
         count(*)                         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=438 and count=0;



-- check linkId of importStartsOpmoDedistribution:

-- select 'check 439';
INSERT INTO QA_Checks_Log values ( 439, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  linkId,
       'no '    as aMatch,
       count(*) as n
from   importStartsOpmoDedistribution
group by linkId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   roadType as r
                                          Where  r.roadTypeId = a.linkId > 0);
                               --           and  a.linkId <> 3);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "importStartsOpmoDedistribution" as tableName,
         439                              as checkNumber,
        "linkId"                          as testDescription,
         linkId                           as testValue,
         count(*)                         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=439 and count=0;



-- check polProcessId of importStartsOpmoDedistribution:

-- select 'check 440';
INSERT INTO QA_Checks_Log values ( 440, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  polProcessId,
       'no '    as aMatch,
       count(*) as n
from   importStartsOpmoDedistribution
group by polProcessId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.pollutantProcessModelYear as p
                                          Where  p.polProcessId = a.polProcessId > 0);
                                  --        and  a.polProcessId <>390);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "importStartsOpmoDedistribution" as tableName,
         440                              as checkNumber,
        "polProcessId"                    as testDescription,
         polProcessId                     as testValue,
         count(*)                         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=440 and count=0;



-- check opModeId of importStartsOpmoDedistribution:

-- select 'check 441';
INSERT INTO QA_Checks_Log values ( 441, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  opModeId,
       'no '    as aMatch,
       count(*) as n
from   importStartsOpmoDedistribution
group by opModeId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.operatingMode as o
                                          Where  o.opModeId = a.opModeId > 0);
                                 --         and  a.opModeId <> 305);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "importStartsOpmoDedistribution" as tableName,
         441                              as checkNumber,
        "opModeId"                        as testDescription,
         opModeId                         as testValue,
         count(*)                         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=441 and count=0;



Insert into   County_Database_Checks ( TableName,        TestDescription )
       values                        ("onRoadRetroFit", "Table Check:");


-- select 'check 442';
INSERT INTO QA_Checks_Log values ( 442, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  pollutantId,
       'no '    as aMatch,
       count(*) as n
from   onRoadRetroFit
group by pollutantId;

-- select * from tempA

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.pollutant as p
                                          Where  p.pollutantId = a.pollutantId > 0);
                                 --         and  a.opModeId <> 20);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "onRoadRetroFit" as tableName,
         442              as checkNumber,
        "pollutantId"     as testDescription,
         pollutantId      as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=442 and count=0;



-- check processId of onRoadRetroFit:

-- select 'check 443';
INSERT INTO QA_Checks_Log values ( 443, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  processId,
       'no '    as aMatch,
       count(*) as n
from   onRoadRetroFit
group by processId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.pollutantProcessAssoc as p
                                          Where  p.processId = a.processId > 0);
                                 --         and  a.opModeId <> 9);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "onRoadRetroFit" as tableName,
         443              as checkNumber,
        "processId"       as testDescription,
         processId        as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=443 and count=0;



-- check fuelTypeId of onRoadRetroFit:

-- select 'check 444';
INSERT INTO QA_Checks_Log values ( 444, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  fuelTypeId ,
       'no '    as aMatch,
       count(*) as n
from   onRoadRetroFit
group by fuelTypeId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.fuelType as f
                                          Where  f.fuelTypeId  = a.fuelTypeId  > 0);
                                 --         and  a.opModeId <> 9);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "onRoadRetroFit" as tableName,
         444              as checkNumber,
        "fuelTypeId "     as testDescription,
         fuelTypeId       as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=444 and count=0;



-- check sourceTypeId of onRoadRetroFit:

-- select 'check 445';
INSERT INTO QA_Checks_Log values ( 445, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  sourceTypeId,
       'no '    as aMatch,
       count(*) as n
from   onRoadRetroFit
group by sourceTypeId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.sourceUseType as s
                                          Where  s.sourceTypeId = a.sourceTypeId > 0);
                                 --         and  a.opModeId <> 31);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "onRoadRetroFit" as tableName,
         445              as checkNumber,
        "sourceTypeId"    as testDescription,
         sourceTypeId     as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=445 and count=0;



-- check retrofitYearId of onRoadRetroFit:

-- select 'check 446';
INSERT INTO QA_Checks_Log values ( 446, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  retrofitYearId,
       'no '    as aMatch,
       count(*) as n
from   onRoadRetroFit
group by retrofitYearId;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.year as m
                                          Where  a.retrofitYearId = m.yearId) > 0;
Update tempA as a set aMatch='yes';								 
								 
								 

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "onRoadRetroFit" as tableName,
         446              as checkNumber,
        "retrofitYearId"  as testDescription,
         retrofitYearId   as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=446 and count=0;



-- check beginModelYearId of onRoadRetroFit:

-- select 'check 447';
INSERT INTO QA_Checks_Log values ( 447, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  beginModelYearId,
       'no '    as aMatch,
       count(*) as n
from   onRoadRetroFit
group by beginModelYearId;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.year as m
                                          Where  a.beginModelYearId = m.yearId) > 0;
Update tempA as a set aMatch='yes';

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "onRoadRetroFit"  as tableName,
         447               as checkNumber,
        "beginModelYearId" as testDescription,
         beginModelYearId  as testValue,
         count(*)          as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=447 and count=0;



-- check endModelYearId of onRoadRetroFit:

-- select 'check 448';
INSERT INTO QA_Checks_Log values ( 448, 'OK', @hVersion, curDate(), curTime() );
drop   table tempA;
create table tempA
select  endModelYearId,
       'no '    as aMatch,
       count(*) as n
from   onRoadRetroFit
group by endModelYearId;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.year as m
                                          Where  a.endModelYearId = m.yearId) > 0;
Update tempA as a set aMatch='yes';

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "onRoadRetroFit" as tableName,
         448              as checkNumber,
        "endModelYearId"  as testDescription,
         endModelYearId   as testValue,
         count(*)         as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=448 and count=0;



Insert into   County_Database_Checks ( TableName,  TestDescription )
       values                        ("starts",   "Table Check:");

-- select 'check 449';
INSERT INTO QA_Checks_Log values ( 449, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   hourDayId,
        'no '    as aMatch,
         count(*) as n
from     starts
group by hourDayId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.hourDay as h
                                          Where  h.hourDayId = a.hourDayId > 0);
                                 --         and  a.hourDayId <> 12);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "starts"    as tableName,
         449         as checkNumber,
        "hourDayId"  as testDescription,
         hourDayId   as testValue,
         count(*)    as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=449 and count=0;


-- check monthId of starts table:

-- select 'check 450';
INSERT INTO QA_Checks_Log values ( 450, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   monthId,
        'no '    as aMatch,
         count(*) as n
from     starts
group by monthId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.monthOfAnyYear as m
                                          Where  m.monthId = a.monthId > 0);
                                 --         and  a.monthId <> 2006);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "starts"       as tableName,
         450            as checkNumber,
        "monthId"       as testDescription,
         monthId        as testValue,
         count(*)       as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=450 and count=0;



-- check yearId of starts table:

-- select 'check 451';
INSERT INTO QA_Checks_Log values ( 451, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   yearId,
        'no '     as aMatch,
         count(*) as n
from     starts
group by yearId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   year as y
                                          Where  y.yearId = a.yearId > 0);
                                 --         and  a.yearId <> 2006);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "starts" as tableName,
         451      as checkNumber,
        "yearId"  as testDescription,
         yearId   as testValue,
         count(*) as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=451 and count=0;



-- check ageId of starts table:

-- select 'check 452';
INSERT INTO QA_Checks_Log values ( 452, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   ageId,
        'no '    as aMatch,
         count(*) as n
from     starts
group by ageId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.ageCategory as c
                                          Where  c.ageId = a.ageId > 0);
                                 --         and  a.ageId <> 13);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "starts"       as tableName,
         452            as checkNumber,
        "ageId"         as testDescription,
         ageId          as testValue,
         count(*)       as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=452 and count=0;



-- check zoneId of starts table:

-- select 'check 453';
INSERT INTO QA_Checks_Log values ( 453, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   zoneId,
        'no '    as aMatch,
         count(*) as n
from     starts
group by zoneId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   zone as z
                                          Where  z.zoneId = a.zoneId > 0);
                                 --         and  a.zoneId <> 311750);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "starts" as tableName,
         453      as checkNumber,
        "zoneId"  as testDescription,
         zoneId   as testValue,
         count(*) as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=453 and count=0;



-- check sourceTypeId of starts table:

-- select 'check 454';
INSERT INTO QA_Checks_Log values ( 454, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   sourceTypeId,
        'no '    as aMatch,
         count(*) as n
from     starts
group by sourceTypeId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.sourceUseType as s
                                          Where  s.sourceTypeId = a.sourceTypeId > 0);
                                 --         and  a.sourceTypeId <> 2006);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "starts"       as tableName,
         454            as checkNumber,
        "sourceTypeId"  as testDescription,
         sourceTypeId   as testValue,
         count(*)       as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=454 and count=0;


Insert into   County_Database_Checks ( TableName,           TestDescription )
       values                        ("startsHourFraction","Table Check:");


-- select 'check 455';
INSERT INTO QA_Checks_Log values ( 455, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   zoneId,
        'no '     as aMatch,
         count(*) as n
from     startsHourFraction
group by zoneId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   zone as z
                                          Where  z.zoneId = a.zoneId > 0);
                              --            and  a.zoneId <> 311750);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "startsHourFraction" as tableName,
         455                  as checkNumber,
        "zoneId"              as testDescription,
         zoneId               as testValue,
         count(*)             as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=455 and count=0;



-- select 'check 456';
INSERT INTO QA_Checks_Log values ( 456, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   dayId,
        'no '     as aMatch,
         count(*) as n
from     startsHourFraction
group by dayId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.dayOfAnyWeek as d
                                          Where  d.dayId = a.dayId > 0);
                              --            and  a.zoneId <> 311750);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "startsHourFraction" as tableName,
         456                  as checkNumber,
        "dayId"               as testDescription,
         dayId                as testValue,
         count(*)             as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=456 and count=0;



-- select 'check 457';
INSERT INTO QA_Checks_Log values ( 457, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   hourId,
        'no '     as aMatch,
         count(*) as n
from     startsHourFraction
group by hourId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.hourDay as h
                                          Where  h.hourId = a.hourId > 0);
                              --            and  a.zoneId <> 25);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "startsHourFraction" as tableName,
         457                  as checkNumber,
        "hourId"              as testDescription,
         hourId               as testValue,
         count(*)             as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=457 and count=0;



-- select 'check 458';
INSERT INTO QA_Checks_Log values ( 458, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   zoneId,
         dayId,
        'no '     as aMatch,
         count(*) as n,
         sum(allocationFraction) as s
from     startsHourFraction
group by zoneId,
         dayId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.dayOfAnyWeek as d
                                          Where  d.dayId = a.dayId > 0)
                                     and
                                         (Select count(*)
                                          From   zone as z
                                          Where  z.zoneId = a.zoneId > 0)

                                     and  s > 0.999
                                     and  s < 1.001;

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         dayId,
         zoneId,
         count  )
Select   "startsHourFraction" as tableName,
         458                  as checkNumber,
        "day, zone or dist?"  as testDescription,
         s                    as testValue,
         dayId,
         zoneId,
         count(*)             as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=458 and count=0;


Insert into   County_Database_Checks ( TableName,          TestDescription )
       values                        ("startsMonthAdjust","Table Check:");


-- select 'check 459';
INSERT INTO QA_Checks_Log values ( 459, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   monthId,
        'no '     as aMatch,
         count(*) as n
from     startsMonthAdjust
group by monthId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.monthOfAnyYear as m
                                          Where  m.monthId = a.monthId > 0);
                                 --         and  a.monthId <> 7);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "startsMonthAdjust" as tableName,
         459                 as checkNumber,
        "monthId"            as testDescription,
         monthId             as testValue,
         count(*)            as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=459 and count=0;



Insert into   County_Database_Checks ( TableName,      TestDescription )
       values                        ("startsPerDay", "Table Check:");

-- select 'check 460';
INSERT INTO QA_Checks_Log values ( 460, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   zoneId,
        'no '     as aMatch,
         count(*) as n
from     startsPerDay
group by zoneId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   zone as z
                                          Where  z.zoneId = a.zoneId > 0);
                           --               and  a.zoneId <> 10990);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "startsPerDay" as tableName,
         460            as checkNumber,
        "zoneId"        as testDescription,
         zoneId         as testValue,
         count(*)       as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=460 and count=0;



-- select 'check 461';
INSERT INTO QA_Checks_Log values ( 461, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   dayId,
        'no '     as aMatch,
         count(*) as n
from     startsPerDay
group by dayId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.dayOfAnyWeek as d
                                          Where  d.dayId = a.dayId > 0);
                            --              and  a.dayId <> 2);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "startsPerDay" as tableName,
         461            as checkNumber,
        "dayId"         as testDescription,
         dayId          as testValue,
         count(*)       as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=461 and count=0;



-- select 'check 462';
INSERT INTO QA_Checks_Log values ( 462, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   yearId,
        'no '     as aMatch,
         count(*) as n
from     startsPerDay
group by yearId;

-- select * from tempA;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   year as y
                                          Where  y.yearId = a.yearId > 0);
                                 --         and  a.yearId <> 2033);  -- create error for testing

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "startsPerDay" as tableName,
         462            as checkNumber,
        "yearId"        as testDescription,
         yearId         as testValue,
         count(*)       as cou
from     tempA
where    aMatch <> 'yes ';

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=462 and count=0;



-- select 'check 463';
INSERT INTO QA_Checks_Log values ( 463, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   sourceTypeId,
         'no'                    as aMatch,
         sum(allocationFraction) as s,
         count(*) as n
from     startsSourceTypeFraction
group by sourceTypeId;

Update tempA as a set aMatch='yes' where (Select count(*)
                                          From   movesdb20141021.sourceUseType as s
                                          Where  s.sourceTypeId = a.sourceTypeId > 0);
                          --                and  a.sourceTypeId <> 32);  -- create error for testing
Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "startsSourceTypeFraction" as tableName,
         463                        as checkNumber,
        "sourceTypeId"              as testDescription,
         sourceTypeId               as testValue,
         count(*)                   as cou
from     tempA
where    s > 0.999
  and    s < 1.001;

Delete from County_Database_Checks where checkNumber=463 and count=0;


-- select 'check 464';
INSERT INTO QA_Checks_Log values ( 464, 'OK', @hVersion, curDate(), curTime() );
drop     table tempA;
create   table tempA
select   sum(allocationFraction) as s
from     startsSourceTypeFraction;

-- select * from tempA;


Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
         testValue,
         count  )
Select   "startsSourceTypeFraction" as tableName,
         464                        as checkNumber,
        "distribution <> 1.0"       as testDescription,
         s                          as testValue,
         count(*)                   as cou
from     tempA
where    s < 0.999
   or    s > 1.001;

-- select * from County_Database_Checks;

Delete from County_Database_Checks where checkNumber=464 and count=0;

-- -------------------------------------------------------------------------------
-- --------- Add ten table checks  -- from 9/25/2014 email, errors 421 - 464 -----
-- --------- End                                                            ------
-- -------------------------------------------------------------------------------

-- --------------------------------------------------------------------
-- check 470
-- for table imCoverage count of fuelTypesIds 1 & 5 must be equal

INSERT INTO QA_Checks_Log values ( 470, 'OK', @hVersion, curDate(), curTime() );

drop   table if exists tempA;
create table           tempA
select stateId,
       countyId,
       yearId,
       sourceTypeId,
       fuelTypeId
from   imCoverage;

alter table tempA add numFtype1 int default 0;
alter table tempA add numFtype5 int default 0;

drop   table if exists tempB;
create table           tempB
select * from tempA;

create INDEX idxA on tempA (stateId, countyId, yearId, sourceTypeId);
create INDEX idxB on tempB (stateId, countyId, yearId, sourceTypeId);

update tempA as a set a.numFtype1 = (select count(*)
                                     from tempB as b
                                     where b.fuelTypeId=1
                                       and a.stateId      = b.stateId
                                       and a.countyId     = b.countyId
                                       and a.yearId       = b.yearId
                                       and a.sourceTypeId = b.sourceTypeId
                                     group by               b.stateId,
                                                            b.countyId,
                                                            b.yearId,
                                                            b.sourceTypeId);

update tempA as a set a.numFtype5 = (select count(*)
                                     from tempB as b
                                     where b.fuelTypeId=5
                                       and a.stateId      = b.stateId
                                       and a.countyId     = b.countyId
                                       and a.yearId       = b.yearId
                                       and a.sourceTypeId = b.sourceTypeId
                                     group by               b.stateId,
                                                            b.countyId,
                                                            b.yearId,
                                                            b.sourceTypeId);

update tempa set numFtype1=0 where isnull(numFtype1);
update tempa set numFtype5=0 where isnull(numFtype5);

Insert into County_Database_Checks
       ( TableName,
         CheckNumber,
         TestDescription,
   --    testValue,
         count,
         stateId,
         countyId,
         yearId,
         sourceTypeId )
Select  'imCoverage'               as tableName,
         470                       as checkNumber,
        'counts fuelTypesIds 1<>5' as testDescription,
         count(*)                  as count,
         stateId,
         countyId,
         yearId,
         sourceTypeId
from     tempA
where numFtype1<>numFtype5
group by stateId,
         countyId,
         yearId,
         sourceTypeId;


-- --------------------------------------------------------------------

--
--       Final Message:
--
Delete from   County_Database_Checks where TableName = "ALL";

Insert into   County_Database_Checks ( TableName, TestDescription )
       values                        ("ALL",     "Tables Checked.");


Update        County_Database_Checks set msgType = 'Progress'   where testDescription = 'Table Check:';

Update        County_Database_Checks set msgType = 'Data Problem' where checkNumber is not null
                                                                  and msgType     is     null;

Update        County_Database_Checks set msgType = 'DB Checked' where tableName = 'ALL';
Update        County_Database_Checks set msgDate = curDate();
Update        County_Database_Checks set msgTime = curTime();

Update        County_Database_Checks set dataBaseName = (select database())
                                   where dataBaseName is null;

Update        County_Database_Checks set countyId = (select min(countyId)
                                                     from county);

Update        County_Database_Checks set status = 'Completed';
Update        County_Database_Checks set status = 'Error'   where checkNumber is not null;
Update        County_Database_Checks set status = 'Warning' where checkNumber in (84, 93, 78, 53, 23, 11, 470, 200);

Update        County_Database_checks set status  = 'Comment' where checkNumber = 302 and testValue=0;
Update        County_Database_checks set msgType = 'Comment' where checkNumber = 302 and testValue=0;



Drop     table if exists tempA;
Drop     table if exists tempB;


-- Version:
-- See version date at beginning of Script.
Update        County_Database_Checks set version = @hVersion;


-- Select * from County_Database_Checks;

-- -------------------------------------------------------------------------------------------
-- -------------------------------------------------------------------------------------------

create Database if not exists All_CDB_Checks;

-- drop table All_CDB_Checks.All_County_Database_Checks;

create Table    if not exists All_CDB_Checks.All_County_Database_Checks
like County_Database_Checks;


Insert into All_CDB_Checks.All_County_Database_Checks
Select * from                  County_Database_Checks;

flush tables;

DROP   PROCEDURE IF EXISTS checkImCoverage;

select '  .. QA_Checks_2014_v7.sql Done',curTime(),database();