#!/bin/bash
# MOVES_JOBID
# MOVES_CODEBUCKET
# MOVES_CODENAME
# MOVES_JOBBUCKET
# MOVES_JOBNAME
# MOVES_STATUSQUEUE
# hmm. 9/4/14. Modifying to use moves2smkEF_v1.4.plx
cd /home/moves/amazon
umask 000
export ANT_HOME=/home/moves/amazon/ant
export JAVA_HOME=/usr/java/jdk1.6.0_23
export PATH=/opt/ActivePerl-5.12/site/bin:/opt/ActivePerl-5.12/bin:/usr/java/jdk1.6.0_23/bin:/usr/local/bin:/bin:/usr/bin:/opt/aws/bin:/home/ec2-user/bin

# put databases away into MySQL
mysql --user=ec2-user -e "flush tables;"

for file in /home/moves/jobs/postprocess_${MOVES_CODENAME}/databases/*
do
	if [ -d $file ]
	then
#		sudo mv -uf $file /var/lib/mysql/
		mv -uf $file /var/lib/mysql/
	fi
done

# setup permissions on all MySQL data files
#sudo chmod -R a+rwx /var/lib/mysql/
chmod -R a+rwx /var/lib/mysql/

# Consolidate job output databases
cd /home/moves/jobs/postprocess_${MOVES_CODENAME}
mkdir output

cd /home/moves/jobs
rm db_results_*.jar
cd /home/moves/jobs/postprocess_${MOVES_CODENAME}
perl -v

perl -w /home/moves/jobs/postprocess_${MOVES_CODENAME}/ConsolidateJobs.plx

perl -w /home/moves/jobs/postprocess_${MOVES_CODENAME}/AdjEFs.plx

# Convert the MOVES output in the speciate_working database to SMOKE format ratios in /home/moves/jobs/postprocess_${MOVES_CODENAME}/*.csv (or *.CSV)
cd /home/moves/jobs/postprocess_${MOVES_CODENAME}
echo "127.0.0.1" > /home/moves/jobs/postprocess_${MOVES_CODENAME}/postprocesslist.txt
echo "/home/moves/jobs/postprocess_${MOVES_CODENAME}/output/" >> /home/moves/jobs/postprocess_${MOVES_CODENAME}/postprocesslist.txt
echo "speciate_working" >> /home/moves/jobs/postprocess_${MOVES_CODENAME}/postprocesslist.txt

mysql --user=ec2-user < "/home/moves/jobs/postprocess_${MOVES_CODENAME}/profileWeights_onroad_roc_rev.sql"

# Export tables to CSV

mysql --user=ec2-user --execute="(SELECT 'monthID','SMOKE_SCC','togSpeciationProfileID','pollutantID','pollutantName','SMOKE_mode','countyID','profileContribution','weightedGROCNMOGRatio')
                                 UNION
                                 SELECT * FROM speciation_outside_moves_collected.epm_groc 
				 INTO OUTFILE '/home/moves/jobs/postprocess_${MOVES_CODENAME}/output/${MOVES_CODENAME}_epm_groc_${MOVES_JOBNAME}.csv' 
				 FIELDS TERMINATED BY ','  ESCAPED BY '' LINES TERMINATED BY '\n';"

mysql --user=ec2-user --execute="(SELECT 'monthID','SMOKE_SCC','togSpeciationProfileID','pollutantID','pollutantName','SMOKE_mode','countyID','profileContribution','weightedGROCNMOGRatio')
                                 UNION
                                 SELECT * FROM speciation_outside_moves_collected.exh_groc 
				 INTO OUTFILE '/home/moves/jobs/postprocess_${MOVES_CODENAME}/output/${MOVES_CODENAME}_exh_groc_${MOVES_JOBNAME}.csv' 
				 FIELDS TERMINATED BY ','  ESCAPED BY '' LINES TERMINATED BY '\n';"

mysql --user=ec2-user --execute="(SELECT 'monthID','SMOKE_SCC','togSpeciationProfileID','pollutantID','pollutantName','SMOKE_mode','countyID','profileContribution','weightedGROCNMOGRatio')
                                 UNION
                                 SELECT * FROM speciation_outside_moves_collected.evp_groc 
				 INTO OUTFILE '/home/moves/jobs/postprocess_${MOVES_CODENAME}/output/${MOVES_CODENAME}_evp_groc_${MOVES_JOBNAME}.csv' 
				 FIELDS TERMINATED BY ','  ESCAPED BY '' LINES TERMINATED BY '\n';"

mysql --user=ec2-user --execute="(SELECT 'monthID','SMOKE_SCC','togSpeciationProfileID','pollutantID','pollutantName','SMOKE_mode','countyID','profileContribution','weightedGROCNMOGRatio')
                                 UNION
                                 SELECT * FROM speciation_outside_moves_collected.rfl_groc 
				 INTO OUTFILE '/home/moves/jobs/postprocess_${MOVES_CODENAME}/output/${MOVES_CODENAME}_rfl_groc_${MOVES_JOBNAME}.csv' 
				 FIELDS TERMINATED BY ','  ESCAPED BY '' LINES TERMINATED BY '\n';"

mysql --user=ec2-user --execute="(SELECT 'monthID','SMOKE_SCC','pmSpeciationProfileID','pollutantID','pollutantName','SMOKE_mode','countyID','profileContribution','weightedCROCOMRatio')
                                 UNION
                                 SELECT * FROM speciation_outside_moves_collected.exh_croc 
				 INTO OUTFILE '/home/moves/jobs/postprocess_${MOVES_CODENAME}/output/${MOVES_CODENAME}_exh_croc_${MOVES_JOBNAME}.csv' 
				 FIELDS TERMINATED BY ','  ESCAPED BY '' LINES TERMINATED BY '\n';"

mysql --user=ec2-user --execute="(SELECT 'monthID','SMOKE_SCC','pmSpeciationProfileID','pollutantID','pollutantName','SMOKE_mode','countyID','profileContribution')
                                 UNION
                                 SELECT * FROM speciation_outside_moves_collected.exh_residpm 
				 INTO OUTFILE '/home/moves/jobs/postprocess_${MOVES_CODENAME}/output/${MOVES_CODENAME}_exh_residpm_${MOVES_JOBNAME}.csv' 
				 FIELDS TERMINATED BY ','  ESCAPED BY '' LINES TERMINATED BY '\n';"

cd /home/moves/jobs/postprocess_${MOVES_CODENAME}/output
rm *After*Adjustment*csv
cd /home/moves/jobs/postprocess_${MOVES_CODENAME}
