C***********************************************************************STR00100
C                                                                       STR00200
C                           STAR (DATED 97086)                          XXX00300
C                                                                       STR00400
C              *** SEE STAR MODEL CHANGE BULLETIN MCB#3 ***             STR00500
C                                                                       STR00600
C     ON THE SUPPORT CENTER FOR REGULATORY AIR MODELS BULLETIN BOARD    STR00700
C                                                                       STR00800
C                              919-541-5742                             STR00900
C                                                                       STR01000
C***********************************************************************STR01100
C     STABILITY ARRAY PROGRAM   STAR                                    STR01200
C  DIMENSIONS AND FORMATS                                               STR01300
      DIMENSION IMO(12),MONTH(12),MP(12),MPR(12)                        STR01400
      DIMENSION WRQ(6,16,6),LOCA(20)                                    STR01500
      DIMENSION IWRS(6),WR(6),WRS(6),IWR(6,17,6),WRJ(17)                STR01600
      DIMENSION STI(6)                                                  STR01700
      DIMENSION D(12,31),E(12,31),NC(11)                                STR01800
      DIMENSION R(155),B(155),C(62),F(155),G(155),S(62)                 STR01900
      INTEGER*4 ISTA                                                    STR02000
      INTEGER*4 NSTA                                                    STR02100
      INTEGER*4 NDATE                                                   STR02200
      INTEGER*4 MDATE                                                   STR02300
      CHARACTER*1 CH(4), CM(11), BLK, WSCHK(4), TC                      STR02400
      CHARACTER*4 STAB(6,2),DRCTN(17),MONTH,MP,MPR                      STR02500
      DATA BLK/' '/                                                     STR02600
      DATA MONTH/' JAN',' FEB',' MAR',' APR',' MAY',' JUN',' JUL',      STR02700
     1' AUG',' SEP',' OCT',' NOV',' DEC'/                               STR02800
      DATA CM/'1','2','3','4','5','6','7','8','9','0','-'/              STR02900
      DATA NC/1,2,3,4,5,6,7,8,9,0,10/                                   STR03000
      DATA STAB/' A  ',' B  ',' C  ',' D  ',' E  ',' F  ',              STR03100
     1' A  ',' B  ',' C  ','D(D)','D(N)','E+F '/                        STR03200
      DATA DRCTN/'N   ','NNE ','NE  ','ENE ','E   ','ESE ','SE  ','SSE 'STR03300
     1,'S   ','SSW ','SW  ','WSW ','W   ','WNW ','NW  ','NNW ','CALM'/  STR03400
      DATA R/-23.078,-22.998,-22.912,-22.812,-22.715,-22.605,-22.488,   STR03500
     1-22.363,-22.232,-22.092,-21.947,-21.792,-21.632,-21.465,-21.290,  STR03600
     1-21.108,-20.920,-20.725,-20.525,-20.317,-20.103,-19.882,-19.655,  STR03700
     1-19.423,-19.185,-18.940,-18.690,-18.435,-18.173,-17.907,-17.635,  STR03800
     1-17.357,-17.075,-16.787,-16.495,-16.198,-15.895,-15.588,-15.278,  STR03900
     1-14.963,-14.643,-14.320,-13.993,-13.662,-13.327,-12.987,-12.645,  STR04000
     1-12.300,-11.950,-11.598,-11.243,-10.887,-10.525,-10.162,-9.797,   STR04100
     1-9.428,-9.057,-8.683,-8.308,-8.120,0.000,0.000,-7.932,            STR04200
     1-7.553,-7.172,-6.788,-6.405,-6.018,-5.632,-5.243,-4.853,          STR04300
     1-4.463,-4.070,-3.678,-3.285,-2.892,-2.497,-2.102,-1.707,          STR04400
     1-1.312,-0.917,-0.520,-0.125,0.270,0.665,1.058,1.453,              STR04500
     11.845,2.238,2.630,3.020,3.400,3.800,4.187,4.573,                  STR04600
     14.958,5.342,5.725,6.105,6.483,6.860,7.235,7.608,                  STR04700
     17.978,8.348,8.713,9.078,9.438,9.797,10.153,10.507,                STR04800
     110.857,11.203,11.548,11.888,12.227,12.560,12.890,13.218,          STR04900
     113.542,13.862,14.178,14.490,0.000,14.798,15.103,15.403,           STR05000
     115.698,15.990,16.278,16.560,16.838,17.112,17.380,17.645,          STR05100
     117.903,18.158,18.407,18.650,18.888,19.122,19.350,19.572,          STR05200
     119.788,19.998,20.203,20.403,20.597,20.785,20.967,21.143,          STR05300
     121.312,21.477,21.633,21.785/                                      STR05400
      DATA B/21.930,22.068,22.200,22.327,                               STR05500
     122.445,22.558,22.665,22.763,22.857,22.943,23.023,23.095,          STR05600
     123.162,23.220,23.272,23.318,23.357,23.388,23.413,23.430,          STR05700
     123.442,23.445,23.443,23.433,23.417,23.393,23.363,23.325,          STR05800
     123.282,23.232,0.000,23.173,23.110,23.038,22.960,22.877,           STR05900
     122.785,22.688,22.583,22.473,22.355,22.232,22.102,21.965,          STR06000
     121.823,21.673,21.518,21.358,21.190,21.017,20.838,20.653,          STR06100
     120.463,20.267,20.065,19.857,19.643,19.425,19.202,18.970,          STR06200
     118.738,18.498,18.253,18.003,17.750,17.490,17.227,16.957,          STR06300
     116.683,16.407,16.123,15.837,15.547,15.252,14.952,14.650,          STR06400
     114.342,14.032,13.718,13.400,13.078,12.753,12.425,12.093,          STR06500
     111.760,11.422,11.080,10.737,10.390,10.042,9.688,9.335,            STR06600
     18.977,8.618,8.255,7.892,7.525,7.157,6.787,6.415,                  STR06700
     16.040,5.665,5.288,4.910,4.530,4.148,3.767,3.383,                  STR06800
     12.992,2.613,2.227,1.840,1.452,1.063,0.675,0.287,                  STR06900
     1-0.103,-0.493,-0.882,-1.272,-1.662,-2.052,-2.440,0.000,           STR07000
     1-2.830,-3.218,-3.607,-3.993,-4.380,-4.765,-5.152,-5.533,          STR07100
     1-5.915,-6.297,-6.677,-7.055,-7.430,-7.805,-8.178,-8.548,          STR07200
     1-8.918,-9.285,-9.648,-10.012,-10.372,-10.728,-11.083,             STR07300
     1-11.435,-11.783,-12.130,-12.473,-12.813,-13.150,-13.483,-13.812/  STR07400
      DATA C/-14.138,-14.460,-14.778,-15.093,-15.403,-15.701,-16.012,   STR07500
     1-16.308,-16.602,-16.888,-17.172,-17.450,-17.723,-17.990,-18.253,  STR07600
     1-18.512,-18.763,-19.010,-19.250,-19.485,-19.715,-19.938,-20.155,  STR07700
     1-20.367,-20.570,-20.770,-20.962,-21.147,-21.327,-21.498,0.000,    STR07800
     1-21.663,-21.822,-21.973,-22.118,-22.255,-22.385,-22.508,-22.623,  STR07900
     1-22.732,-22.833,-22.925,-23.012,-23.090,-23.160,-23.222,-23.277,  STR08000
     1-23.325,-23.365,-23.397,-23.420,-23.437,-23.445,-23.445,-23.437,  STR08100
     1-23.422,-23.398,-23.368,-23.330,-23.283,-23.228,-23.167/          STR08200
      DATA F/-0.052,-0.060,-0.068,-0.075,-0.083,-0.091,-0.098,          STR08300
     1-0.105,-0.112,-0.119,-0.126,-0.133,-0.139,-0.146,-0.152,          STR08400
     1-0.158,-0.164,-0.169,-0.175,-0.180,-0.185,-0.190,-0.194,          STR08500
     1-0.198,-0.202,-0.206,-0.210,-0.213,-0.217,-0.220,-0.222,          STR08600
     1-0.225,-0.227,-0.229,-0.231,-0.233,-0.234,-0.236,-0.237,          STR08700
     1-0.237,-0.238,-0.238,-0.238,-0.238,-0.238,-0.237,-0.237,          STR08800
     1-0.236,-0.235,-0.233,-0.232,-0.230,-0.228,-0.226,-0.224,          STR08900
     1-0.221,-0.219,-0.216,-0.213,0.000,0.000,0.000,-0.210,             STR09000
     1-0.207,-0.204,-0.200,-0.196,-0.193,-0.189,-0.185,-0.181,          STR09100
     1-0.177,-0.173,-0.168,-0.164,-0.159,-0.155,-0.150,-0.145,          STR09200
     1-0.141,-0.136,-0.131,-0.126,-0.121,-0.116,-0.111,-0.106,          STR09300
     1-0.101,-0.096,-0.090,-0.085,-0.080,-0.075,-0.070,-0.065,          STR09400
     1-0.060,-0.055,-0.050,-0.046,-0.041,-0.036,-0.031,-0.027,          STR09500
     1-0.022,-0.018,-0.014,-0.009,-0.005,-0.001,0.003,0.007,            STR09600
     10.011,0.015,0.018,0.022,0.025,0.028,0.031,0.034,0.037,0.040,0.042,STR09700
     10.045,0.000,0.047,0.049,0.051,0.053,0.055,0.056,0.057,0.059,0.060,STR09800
     10.060,0.061,0.062,0.062,0.062,0.062,0.062,0.062,0.062,0.061,0.060,STR09900
     10.060,0.059,0.057,0.056,0.055,0.053,0.051,0.050,0.048,0.046,0.043/STR10000
      DATA G/0.041,0.038,0.036,0.033,0.030,0.027,0.024,0.021,0.018,     STR10100
     10.015,0.012,0.008,0.005,0.001,-0.002,-0.006,-0.009,-0.013,-0.016, STR10200
     1-0.020,-0.024,-0.027,-0.031,-0.034,-0.038,-0.041,-0.045,-0.048,   STR10300
     1-0.052,-0.055,0.000,-0.059,-0.062,-0.065,-0.068,-0.071,           STR10400
     1-0.074,-0.078,-0.080,-0.083,-0.085,-0.088,-0.090,-0.092,          STR10500
     1-0.094,-0.096,-0.098,-0.099,-0.101,-0.102,-0.103,-0.104,          STR10600
     1-0.105,-0.106,-0.106,-0.107,-0.107,-0.107,-0.107,-0.107,          STR10700
     1-0.106,-0.106,-0.105,-0.104,-0.103,-0.102,-0.100,-0.099,          STR10800
     1-0.097,-0.095,-0.093,-0.091,-0.089,-0.086,-0.083,-0.080,          STR10900
     1-0.077,-0.074,-0.071,-0.067,-0.064,-0.060,-0.056,-0.052,          STR11000
     1-0.048,-0.043,-0.039,-0.034,-0.030,-0.025,-0.020,-0.015,          STR11100
     1-0.010,-0.005,0.000,0.005,0.011,0.016,0.022,0.027,                STR11200
     10.033,0.038,0.044,0.050,0.056,0.062,0.068,0.074,                  STR11300
     10.079,0.085,0.091,0.097,0.103,0.109,0.115,0.121,                  STR11400
     10.127,0.133,0.138,0.144,0.150,0.155,0.161,0.000,                  STR11500
     10.166,0.172,0.177,0.185,0.187,0.192,0.197,0.202,                  STR11600
     10.207,0.211,0.216,0.220,0.224,0.229,0.232,0.236,                  STR11700
     10.240,0.243,0.247,0.250,0.253,0.256,0.258,                        STR11800
     10.261,0.263,0.265,0.267,0.268,0.270,0.271,0.272/                  STR11900
      DATA S/0.272,0.273,0.273,0.273,0.273,0.273,0.272,0.271,0.270,     STR12000
     10.269,0.267,0.266,0.264,0.261,0.259,0.256,0.253,                  STR12100
     10.250,0.247,0.243,0.239,0.235,0.231,0.226,0.222,                  STR12200
     10.217,0.212,0.206,0.201,0.195,0.000,0.189,0.183,                  STR12300
     10.176,0.170,0.163,0.156,0.149,0.142,0.135,0.127,                  STR12400
     10.120,0.112,0.105,0.097,0.089,0.081,0.073,0.065,                  STR12500
     10.057,0.048,0.040,0.032,0.024,0.015,0.007,-0.001,                 STR12600
     1-0.010,-0.018,-0.026,-0.034,-0.042/                               STR12700
  208 FORMAT(I5,3I2,I2,3A1,22X,2I2,13X,A1,23X,T39,4A1)                  STR12800
  212 FORMAT('1')                                                       STR12900
  213 FORMAT(//47X,'FREQUENCY DISTRIBUTION')                            STR13000
  214 FORMAT(////52X,11H SPEED(MPH))                                    STR13100
  215 FORMAT(1H1,3X,'STATION: ',I5,5X,'YEAR: ',I2,5X,'RUN ID: ',20A1)   STR13200
  216 FORMAT(//3X,9HDIRECTION,7X,6H 1 - 3,8X,6H 4 - 7,7X,7H 8 - 12,6X,  STR13300
     18H 13 - 18,6X,8H 19 - 24,2X,16H GREATER THAN 24,10X,6H TOTAL)     STR13400
  397 FORMAT(I5,I2,I1,20A1,2F8.3,F3.0,2I1,12I1)                         STR13500
  221 FORMAT(1H0,7X,A3,6(7X,I7),13X,I7)                                 STR13600
  222 FORMAT(//2X,9H TOTAL   ,6(7X,I7))                                 STR13700
  223 FORMAT(1H0,7X,A3,6(6X,F8.6),12X,F8.6)                             STR13800
  224 FORMAT(//2X,9H TOTAL   ,6(6X,F8.6))                               STR13900
  231 FORMAT(//2X,'NUMBER OF OCCURENCES OF  ',A4,1X,'STABILITY  = ',I7) STR14000
  232 FORMAT(//2X,'NUMBER OF CALMS WITH  ',A4,1X,'STABILITY  =  ',I7)   STR14100
  233 FORMAT(//2X,'FREQUENCY OF OCCURENCE OF  ',A4,1X,'STABILITY  =  ', STR14200
     1F8.6)                                                             STR14300
  234 FORMAT(//2X,'FREQUENCY OF CALMS DISTRIBUTED ABOVE WITH ',A4,1X,   STR14400
     1'STABILITY = ',F8.6)                                              STR14500
  841 FORMAT(7X,6F7.6)                                                  STR14600
  241 FORMAT(1X,6F10.6)                                                 STR14700
  242 FORMAT(6F10.6)                                                    STR14800
C     INITIALIZING ARRAY AND READING REFERENCE DATA                     STR14900
      T=0.0                                                             STR15000
      I=1                                                               STR15100
      DO 14 IM=1,5                                                      STR15200
      DO 14 ID=1,31                                                     STR15300
      D(IM,ID)=R(I)                                                     STR15400
      I=I+1                                                             STR15500
   14 CONTINUE                                                          STR15600
      I=1                                                               STR15700
      DO 15 IM=6,10                                                     STR15800
      DO 15 ID=1,31                                                     STR15900
      D(IM,ID)=B(I)                                                     STR16000
      I=I+1                                                             STR16100
   15 CONTINUE                                                          STR16200
      I=1                                                               STR16300
      DO 16 IM=11,12                                                    STR16400
      DO 16 ID=1,31                                                     STR16500
      D(IM,ID)=C(I)                                                     STR16600
      I=I+1                                                             STR16700
   16 CONTINUE                                                          STR16800
      I=1                                                               STR16900
      DO 13 IM=1,5                                                      STR17000
      DO 13 ID=1,31                                                     STR17100
      E(IM,ID)=F(I)                                                     STR17200
      I=I+1                                                             STR17300
   13 CONTINUE                                                          STR17400
      I=1                                                               STR17500
      DO 18 IM=6,10                                                     STR17600
      DO 18 ID=1,31                                                     STR17700
      E(IM,ID)=G(I)                                                     STR17800
      I=I+1                                                             STR17900
   18 CONTINUE                                                          STR18000
      I=1                                                               STR18100
      DO 20 IM=11,12                                                    STR18200
      DO 20 ID=1,31                                                     STR18300
      E(IM,ID)=S(I)                                                     STR18400
      I=I+1                                                             STR18500
   20 CONTINUE                                                          STR18600
      DO 9 IWD=1,17                                                     STR18700
    9 WRJ(IWD)=0.0                                                      STR18800
      DO 11 ISC=1,6                                                     STR18900
      DO 11 IWD=1,17                                                    STR19000
      DO 11 IWSC=1,6                                                    STR19100
   11 IWR(ISC,IWD,IWSC)=0                                               STR19200
      KK=1                                                              STR19300
C********INPUT CONTROL PARAMETER LAYOUT****1 RECORD*********************STR19400
C                                                                       STR19500
C         PARAMETER      DESCRIPTION             FORMAT     CC          STR19600
C         *********      ***********             ******     **          STR19700
C                                                                       STR19800
C              NSTA:  NCDC STATION NUMBER         I5         1          STR19900
C             IYEAR:  YEAR OF RECORD              I2         6          STR20000
C              IOPT:  STAR OUTPUT FILE OPTION     I1         8          STR20100
C                        IOPT = 1    YES                                STR20200
C                        IOPT = 0    NO                                 STR20300
C              LOCA:  RUN DESCRIPTION             20A1      19          STR20400
C              ALAT:  STA LATITUDE   XX.XX DEG    F8.3      29          STR20500
C              ALON:  STA LONGITUDE XXX.XX DEG    F8.3      37          STR20600
C               ZON:  STATION ZONE                F3.0      45          STR20700
C                        ETZ = 075                                      STR20800
C                        CTZ = 090                                      STR20900
C                        MTZ = 105                                      STR21000
C                        PTZ = 120                                      STR21100
C              IMOD:  MODEL SELECTION             I1        48          STR21200
C                        CDM-2   = 1                                    STR21300
C                        ISCLT   = 2                                    STR21400
C                        LONGZ   = 2                                    STR21500
C                        VALLEY  = 2                                    STR21600
C              ITST:  MONTHLY SELECTION           I1        49          STR21700
C                        YES  =  1                                      STR21800
C                         NO  =  0                                      STR21900
C               IMO:  MONTHS SELECTED             12I1      50          STR22000
C                        YES  =  1                                      STR22100
C                         NO  =  0                                      STR22200
C                      ONE FIELD TO BE USED FOR EACH MONTH              STR22300
C                 NOTE: THIS ARRAY IS ONLY USED WHEN THE ABOVE          STR22400
C                       PARAMETER ITST = 1                              STR22500
C                                                                       STR22600
C                                                                       STR22700
C***********************************************************************STR22800
      READ(5,397)NSTA,IYEAR,IOPT,LOCA,ALAT,ALON,ZON,IMOD,ITST,IMO       STR22900
      IUR=6                                                             STR23000
      IF(IMOD.LT.3.AND.IMOD.GT.0)GO TO 17                               STR23100
      WRITE(6,19)                                                       STR23200
   19 FORMAT(1H1,10X,'INCORRECT MODEL CHOICE')                          STR23300
      GO TO 4001                                                        STR23400
   17 IF(IMOD.EQ.2)GOTO21                                               STR23500
      IMOD=2                                                            STR23600
      GOTO25                                                            STR23700
   21 IMOD=1                                                            STR23800
   25 DIFL1=(ZON-ALON)*0.066667                                         STR23900
      STH=SIN(ALAT/57.29578)                                            STR24000
      CTH=COS(ALAT/57.29578)                                            STR24100
      READ(9,208,END=400)ISTA,IY,IM,ID,IH,(CH(N),N=1,3),KWD,IWS,CH(4)   STR24200
     *,(WSCHK(NN),NN=1,4)                                               STR24300
      IF(NSTA.NE.ISTA.OR.IYEAR.NE.IY)GOTO888                            STR24400
      GOTO95                                                            STR24500
  888 WRITE(6,219)                                                      STR24600
  219 FORMAT(3X,'STATION OR YEAR DOES NOT MATCH - TERMINATE RUN')       STR24700
      GOTO4001                                                          STR24800
  450 READ(9,208,END=400)ISTA,IY,IM,ID,IH,(CH(N),N=1,3),KWD,IWS,CH(4)   STR24900
     *,(WSCHK(NN),NN=1,4)                                               STR25000
   95 IF(WSCHK(1).EQ.BLK.OR.WSCHK(2).EQ.BLK.OR.WSCHK(3).EQ.BLK.         STR25100
     *OR.WSCHK(4).EQ.BLK)GO TO 450                                      STR25200
C                                                                       STR25300
C   DETERMINES CLOUD HEIGHT IF ANY,AND DETERMINES CLOUD AMOUNT          STR25400
C                                                                       STR25500
 1303 IF(ITST)1304,2305,1304                                            STR25600
 1304 IF(IMO(IM))2305,450,2305                                          STR25700
 2305 IF(CH(1).EQ.CM(11))GOTO 304                                       STR25800
      GOTO 306                                                          STR25900
  304 IF(CH(2).EQ.CM(11))GOTO 305                                       STR26000
      GOTO 450                                                          STR26100
  305 IF(CH(3).EQ.CM(11))GOTO 315                                       STR26200
      GOTO 450                                                          STR26300
  306 DO 314 N=1,4                                                      STR26400
      L=1                                                               STR26500
  307 IF(CH(N).EQ.CM(L))GOTO 309                                        STR26600
      GOTO 308                                                          STR26700
  308 L=L+1                                                             STR26800
      IF ((L .EQ. 11) .AND. (N .NE. 4)) GO TO 450                       XXX26900
      IF (L .EQ. 11) GO TO 309                                          XXX26930
      GO TO 307                                                         XXX26970
  309 GO TO(310,311,312,313),N                                          STR27100
  310 N1=L                                                              STR27200
      GO TO 314                                                         STR27300
  311 N2=L                                                              STR27400
      GO TO 314                                                         STR27500
  312 N3=L                                                              STR27600
      GO TO 314                                                         STR27700
  313 N4=L                                                              STR27800
  314 CONTINUE                                                          STR27900
      ICH=NC(N1)*100+NC(N2)*10+NC(N3)                                   STR28000
      GO TO 319                                                         STR28100
  315 ICH=999                                                           STR28200
      L=1                                                               STR28300
  316 IF(CH(4).EQ.CM(L))GOTO 318                                        STR28400
      GOTO 317                                                          STR28500
  317 L=L+1                                                             STR28600
      IF(L-11)316,316,450                                               STR28700
  318 N4=L                                                              STR28800
  319 ICA=NC(N4)                                                        STR28900
C                                                                       STR29000
C   COMPUTES SUNRISE AND SUNSET                                         STR29100
C                                                                       STR29200
      H=FLOAT(IH)                                                       STR29300
      M=1                                                               STR29400
   30 CSH=-(STH*SIN(D(IM,ID)/57.29578))/(CTH*COS(D(IM,ID)/57.29578))    STR29500
      IF(IMOD.EQ.1)GOTO 36                                              STR29600
      IF(CSH-1.0)32,31,31                                               STR29700
   36 IF(CSH-0.99999)32,32,31                                           STR29800
   31 TNH=90.0                                                          STR29900
      GO TO 34                                                          STR30000
   32 TNH=(ATAN(((1.0-CSH*CSH)**0.5)/CSH))*57.29578                     STR30100
      IF(TNH-0.0)33,34,34                                               STR30200
   33 TNH=180.0+TNH                                                     STR30300
   34 SR=11.917-DIFL1-E(IM,ID)-TNH/15.0                                 STR30400
      SS=12.083-DIFL1-E(IM,ID)+TNH/15.0                                 STR30500
C                                                                       STR30600
C   COMPUTES ANGLE OF ELEVATION OF THE SUN                              STR30700
C                                                                       STR30800
      DIFL2=12.0-DIFL1-E(IM,ID)                                         STR30900
   40 IF((H-SR)-1.0)83,81,81                                            STR31000
   81 IF((SS-H)-1.0)83,82,82                                            STR31100
   82 HAS=(ABS(DIFL2-H))*15.0                                           STR31200
      SNA=STH*SIN(D(IM,ID)/57.29578)+CTH*COS(D(IM,ID)/57.29578)*        STR31300
     1COS(HAS/57.29578)                                                 STR31400
      IF(IMOD.EQ.1)GOTO50                                               STR31500
      IF(SNA-0.000009)83,83,180                                         STR31600
   50 IF(SNA-0.0)83,83,180                                              STR31700
   83 A=9999.0000                                                       STR31800
      M=2                                                               STR31900
      GO TO 72                                                          STR32000
  180 IF(IMOD.EQ.1)GO TO 84                                             STR32100
      IF(SNA-1.0)71,71,70                                               STR32200
   84 IF(SNA-0.99999)71,71,70                                           STR32300
   70 A=90.0                                                            STR32400
      GO TO 72                                                          STR32500
   71 A=(ATAN(SNA/((1.0-SNA*SNA)**0.5)))*57.29578                       STR32600
   72 IF(ICA-10)86,85,85                                                STR32700
   85 IF(ICH-70)134,86,86                                               STR32800
   86 IF(M-1)87,87,122                                                  STR32900
   87 IF(60.0-A)91,88,88                                                STR33000
   88 IF(35.0-A)92,89,89                                                STR33100
   89 IF(15.0-A)93,94,94                                                STR33200
C                                                                       STR33300
C   DETERMINES WHAT AMOUNT OF SUN'S RADIATION HITS EARTH DUE TO CLOUD   STR33400
C   COVER OR ABSENCE OF CLOUD COVER.                                    STR33500
C                                                                       STR33600
   91 ICN=4                                                             STR33700
      GO TO 100                                                         STR33800
   92 ICN=3                                                             STR33900
      GO TO 100                                                         STR34000
   93 ICN=2                                                             STR34100
      GO TO 100                                                         STR34200
   94 ICN=1                                                             STR34300
  100 CONTINUE                                                          XXX34400
  101 IF(ICA-5)102,102,103                                              STR34500
  102 IR=ICN                                                            STR34600
      GO TO 107                                                         STR34700
  103 IF(ICH-070)104,105,105                                            STR34800
  104 IR=ICN-2                                                          STR34900
      GO TO 107                                                         STR35000
  105 IF(ICH-160)106,102,102                                            STR35100
  106 IR=ICN-1                                                          STR35200
 1068 IF (ICA-10) 107, 1069, 1069                                       XXX35230
 1069 IR = IR-1                                                         XXX35270
  107 IF(IR-1)108,110,110                                               STR35300
  108 IR=1                                                              STR35400
C                                                                       STR35500
C   DETERMINES STABILITY CLASS                                          STR35600
C                                                                       STR35700
  110 GO TO(121,118,114,111),IR                                         STR35800
  111 IF(IWS-5)131,131,112                                              STR35900
  112 IF(IWS-9)132,132,133                                              STR36000
  114 IF(IWS-1)131,131,115                                              STR36100
  115 IF(IWS-7)132,132,116                                              STR36200
  116 IF(IWS-11)133,133,134                                             STR36300
  118 IF(IWS-3)132,132,119                                              STR36400
  119 IF(IWS-9)133,133,134                                              STR36500
  121 IF(IWS-3)133,133,134                                              STR36600
  122 IF(IUR-5)123,123,126                                              STR36700
  123 IF(ICA-4)124,124,125                                              STR36800
  124 IF(IWS-10)135,135,134                                             STR36900
  125 IF(IWS-6)135,135,134                                              STR37000
  126 IF(ICA-4)127,127,129                                              STR37100
  127 IF(IWS-6)136,136,128                                              STR37200
  128 IF(IWS-10)135,135,134                                             STR37300
  129 IF(IWS-3)136,136,130                                              STR37400
  130 IF(IWS-6)135,135,134                                              STR37500
  131 ISC=1                                                             STR37600
      GO TO 140                                                         STR37700
  132 ISC=2                                                             STR37800
      GO TO 140                                                         STR37900
  133 ISC=3                                                             STR38000
      GO TO 140                                                         STR38100
  134 IF(IMOD.EQ.2)ISC=3+M                                              STR38200
      IF(IMOD.EQ.1)ISC=4                                                STR38300
      GO TO 140                                                         STR38400
  135 IF(IMOD.EQ.2)ISC=6                                                STR38500
      IF(IMOD.EQ.1)ISC=5                                                STR38600
      GO TO 140                                                         STR38700
  136 ISC=6                                                             STR38800
C     DEFINING WIND DIRECTION CLASS                                     STR38900
  140 IF(IY-64)320,340,340                                              STR39000
  320 IF(KWD)370,367,370                                                STR39100
  367 IF(IWS)450,3333,450                                               STR39200
 3333 IWD=17                                                            STR39300
      GO TO 151                                                         STR39400
  370 IF(IWS)321,450,321                                                STR39500
  321 IF(KWD-11)322,351,322                                             STR39600
  322 IF(KWD-12)323,352,323                                             STR39700
  323 IF(KWD-22)324,353,324                                             STR39800
  324 IF(KWD-32)325,354,325                                             STR39900
  325 IF(KWD-33)326,355,326                                             STR40000
  326 IF(KWD-34)327,356,327                                             STR40100
  327 IF(KWD-44)328,357,328                                             STR40200
  328 IF(KWD-54)329,358,329                                             STR40300
  329 IF(KWD-55)330,359,330                                             STR40400
  330 IF(KWD-56)331,360,331                                             STR40500
  331 IF(KWD-66)332,361,332                                             STR40600
  332 IF(KWD-76)333,362,333                                             STR40700
  333 IF(KWD-77)334,363,334                                             STR40800
  334 IF(KWD-78)335,364,335                                             STR40900
  335 IF(KWD-88)336,365,336                                             STR41000
  336 IF(KWD-18)450,366,450                                             STR41100
  340 IF(KWD)369,367,369                                                STR41200
  369 IF(IWS)341,450,341                                                STR41300
  341 IF(KWD-10)345,355,342                                             STR41400
  342 IF(KWD-20)346,360,343                                             STR41500
  343 IF(KWD-30)347,364,344                                             STR41600
  344 IF(KWD-37)348,450,450                                             STR41700
  345 GO TO (351,352,352,353,353,354,354,355,355),KWD                   STR41800
  346 KWD=KWD-10                                                        STR41900
      GO TO (356,356,357,357,358,358,359,359,359),KWD                   STR42000
  347 KWD=KWD-20                                                        STR42100
      GO TO(360,361,361,362,362,363,363,363,364),KWD                    STR42200
  348 KWD=KWD-30                                                        STR42300
      GO TO(365,365,366,366,351,351),KWD                                STR42400
  351 IWD=1                                                             STR42500
      GO TO 368                                                         STR42600
  352 IWD=2                                                             STR42700
      GO TO 368                                                         STR42800
  353 IWD=3                                                             STR42900
      GO TO 368                                                         STR43000
  354 IWD=4                                                             STR43100
      GO TO 368                                                         STR43200
  355 IWD=5                                                             STR43300
      GO TO 368                                                         STR43400
  356 IWD=6                                                             STR43500
      GO TO 368                                                         STR43600
  357 IWD=7                                                             STR43700
      GO TO 368                                                         STR43800
  358 IWD=8                                                             STR43900
      GO TO 368                                                         STR44000
  359 IWD=9                                                             STR44100
      GO TO 368                                                         STR44200
  360 IWD=10                                                            STR44300
      GO TO 368                                                         STR44400
  361 IWD=11                                                            STR44500
      GO TO 368                                                         STR44600
  362 IWD=12                                                            STR44700
      GO TO 368                                                         STR44800
  363 IWD=13                                                            STR44900
      GO TO 368                                                         STR45000
  364 IWD=14                                                            STR45100
      GO TO 368                                                         STR45200
  365 IWD=15                                                            STR45300
      GO TO 368                                                         STR45400
  366 IWD=16                                                            STR45500
      GO TO 368                                                         STR45600
  368 ISWD=IWD                                                          STR45700
C     DEFINING WIND SPEED CLASS AND ACCUMULATING ARRAY VALUES           STR45800
      IF(IWS-3)151,151,141                                              STR45900
  141 IF(IWS-6)152,152,142                                              STR46000
  142 IF(IWS-10)153,153,143                                             STR46100
  143 IF(IWS-16)154,154,144                                             STR46200
  144 IF(IWS-21)155,155,156                                             STR46300
  151 IWSC=1                                                            STR46400
      GO TO 161                                                         STR46500
  152 IWSC=2                                                            STR46600
      GO TO 161                                                         STR46700
  153 IWSC=3                                                            STR46800
      GO TO 161                                                         STR46900
  154 IWSC=4                                                            STR47000
      GO TO 161                                                         STR47100
  155 IWSC=5                                                            STR47200
      GO TO 161                                                         STR47300
  156 IWSC=6                                                            STR47400
  161 IF(ISC-IUR)165,165,162                                            STR47500
  162 ISC=IUR                                                           STR47600
  165 IWR(ISC,IWD,IWSC)=IWR(ISC,IWD,IWSC)+1                             STR47700
      T=T+1.0                                                           STR47800
      GO TO 450                                                         STR47900
C     DISTRIBUTING CALMS AND NORMALIZING ARRAY                          STR48000
  400 DO 60 ISC=1,IUR                                                   STR48100
      WRITE(6,215)NSTA,IYEAR,(LOCA(I),I=1,20)                           STR48200
      IF(ITST.EQ.0)GOTO49                                               STR48300
      DO 47 III=1,12                                                    STR48400
      IF(IMO(III).EQ.1)MP(III)=MONTH(III)                               STR48500
      IF(IMO(III).EQ.0)MP(III)=BLK                                      STR48600
   47 CONTINUE                                                          STR48700
      MMM=0                                                             XXX48800
      DO 48 III=1,12                                                    STR48900
      IF(MP(III).EQ.BLK)GOTO48                                          STR49000
      MMM=MMM+1                                                         STR49100
      MPR(MMM)=MP(III)                                                  STR49200
   48 CONTINUE                                                          STR49300
      WRITE(6,217)(MPR(II),II=1,MMM)                                    STR49400
  217 FORMAT(10X,'MONTHS SELECTED:',2X,12A4)                            STR49500
      GOTO46                                                            STR49600
   49 WRITE(6,218)                                                      STR49700
  218 FORMAT(10X,'ANNUAL RUN')                                          STR49800
   46 WRITE(6,213)                                                      STR49900
      WRITE(6,214)                                                      STR50000
      WRITE(6,216)                                                      STR50100
      STI(ISC)=0.0                                                      STR50200
      STJ=0                                                             STR50300
      DO 51 IWD=1,16                                                    STR50400
      DO 51 IWSC=1,6                                                    STR50500
      STI(ISC)=STI(ISC)+IWR(ISC,IWD,IWSC)                               STR50600
   51 CONTINUE                                                          STR50700
      STI(ISC)=STI(ISC)+IWR(ISC,17,1)                                   STR50800
      DO 61 IWD=1,16                                                    STR50900
      DO 61 IWSC=1,2                                                    STR51000
      STJ=STJ+IWR(ISC,IWD,IWSC)                                         STR51100
   61 CONTINUE                                                          STR51200
      DO 53 IWD=1,16                                                    STR51300
      WRJ(IWD)=IWR(ISC,IWD,1)                                           STR51400
      IWRD=0                                                            STR51500
      DO 52 IWSC=1,6                                                    STR51600
      IWRD=IWRD+IWR(ISC,IWD,IWSC)                                       STR51700
   52 CONTINUE                                                          STR51800
      WRITE(6,221)DRCTN(IWD),(IWR(ISC,IWD,IWSC),IWSC=1,6),IWRD          STR51900
   53 CONTINUE                                                          STR52000
      DO 54 IWSC=1,6                                                    STR52100
      IWRS(IWSC)=0                                                      STR52200
      DO 54 IWD=1,16                                                    STR52300
      IWRS(IWSC)=IWRS(IWSC)+IWR(ISC,IWD,IWSC)                           STR52400
   54 CONTINUE                                                          STR52500
      WRITE(6,222)(IWRS(IWSC),IWSC=1,6)                                 STR52600
      IST=STI(ISC)                                                      STR52700
      WRITE(6,231)STAB(ISC,IMOD),IST                                    STR52800
      WRITE(6,232)STAB(ISC,IMOD),IWR(ISC,17,1)                          STR52900
      WRITE(6,215)NSTA,IYEAR,(LOCA(I),I=1,20)                           STR53000
      IF(ITST.EQ.1)WRITE(6,217)(MPR(II),II=1,MMM)                       STR53100
      IF(ITST.EQ.0)WRITE(6,218)                                         STR53200
      WRITE(6,213)                                                      STR53300
      WRITE(6,214)                                                      STR53400
      WRITE(6,216)                                                      STR53500
      WRS(1)=0.0                                                        STR53600
      DO 58 IWD=1,16                                                    STR53700
      WRD=WRJ(IWD)/T                                                    STR53800
      DO 56 IWSC=2,6                                                    STR53900
      WRD=WRD+FLOAT(IWR(ISC,IWD,IWSC))/T                                STR54000
   56 CONTINUE                                                          STR54100
      IF(STJ-0.0)90,90,80                                               STR54200
   80 CLMC=(WRJ(IWD)+IWR(ISC,IWD,2))*IWR(ISC,17,1)/(STJ*T)              STR54300
      GO TO 99                                                          STR54400
   90 CLMC=FLOAT(IWR(ISC,17,1))/(16.0*T)                                STR54500
   99 WR(1)=WRJ(IWD)/T+CLMC                                             STR54600
      WRQ(ISC,IWD,1)=WR(1)+0.0000005                                    STR54700
      WRS(1)=WRS(1)+WR(1)                                               STR54800
      DO 57 IWSC=2,6                                                    STR54900
      WR(IWSC)=FLOAT(IWR(ISC,IWD,IWSC))/T                               STR55000
      WRQ(ISC,IWD,IWSC)=WR(IWSC)+0.0000005                              STR55100
   57 CONTINUE                                                          STR55200
      WRD=WRD+CLMC                                                      STR55300
      WRITE(6,223)DRCTN(IWD),(WR(IWSC),IWSC=1,6),WRD                    STR55400
   58 CONTINUE                                                          STR55500
      DO 59 IWSC=2,6                                                    STR55600
      WRS(IWSC)=0                                                       STR55700
      DO 59 IWD=1,16                                                    STR55800
      WRS(IWSC)=WRS(IWSC)+FLOAT(IWR(ISC,IWD,IWSC))/T                    STR55900
   59 CONTINUE                                                          STR56000
      WRITE(6,224)(WRS(IWSC),IWSC=1,6)                                  STR56100
      ST=STI(ISC)/T                                                     STR56200
      WRITE(6,233)STAB(ISC,IMOD),ST                                     STR56300
      WRC=IWR(ISC,17,1)/T                                               STR56400
      WRITE(6,234)STAB(ISC,IMOD),WRC                                    STR56500
   60 CONTINUE                                                          STR56600
      WRITE(6,212)                                                      STR56700
 3014 DO 301 ISC=1,6                                                    STR56800
      DO 301 IWD=1,16                                                   STR56900
 3015 IF(IMOD.EQ.1)GOTO 9815                                            STR57000
      IF(IOPT.NE.1)GOTO9814                                             STR57100
      WRITE(8,841)(WRQ(ISC,IWD,IWSC),IWSC=1,6)                          STR57200
 9814 WRITE(6,841)(WRQ(ISC,IWD,IWSC),IWSC=1,6)                          STR57300
      GO TO 301                                                         STR57400
 9815 IF(IOPT.NE.1)GOTO9816                                             STR57500
      WRITE(8,242)(WRQ(ISC,IWD,IWSC),IWSC=1,6)                          STR57600
 9816 WRITE(6,241)(WRQ(ISC,IWD,IWSC),IWSC=1,6)                          STR57700
  301 CONTINUE                                                          STR57800
      WRITE(6,3016)                                                     STR57900
 3016 FORMAT(1H1,10X,'PROGRAM HAS FINISHED')                            STR58000
 4001 CONTINUE                                                          STR58100
      STOP                                                              STR58200
      END                                                               STR58300
