10 REM*****************************DSP2***********************************
20 REM  THIS SUB-PROGRAM DEFINES THE SOURCE CONDITIONS(i.e., EMISSION RATE,
30 REM  DURATION OF SPILL, AND WIDTH OF SPILL)
40 DIM TW(4),CONCI(3),CONCP(3),B(40),NN(6,4)
50 COMMON CONCON,IUNIT,QSS,QPIPE,TTSP,TW(),WWIDTH,U,HINV,STB,WAT,WD,OPTN,ZO,UU
60 COMMON HTCONV,ISTAT,IUNCO,STBV,TAK,H,SIGTH,MFLAG,ZOO,PRES,TNU,TA,MW,CLOUD
70 COMMON SR,A,VISCK,CMTC,TMSP,TB,NU,RENL,EOK,DVAP,DLIQ,SIG,HF,PYN,NO
80 COMMON AMW,HS,TS,VF,AT,IUCON,Z,CONCI(),CONCP(),NNNN,T,CMIN,SVE,TC,VP,AA3
90 COMMON SN$,DTE$,ZT$,LA,LO,ZW,DFT,HET,CHM$,DW,PI,EGA,SCR
100 COMMON COL1,COL4,COL5
110 MWA=28.966
120 IF DLIQ=0 THEN DLIQ=1
130 CLS
140 IF PYN>0 THEN 190
150 PRINT "SORRY--YOU MUST START AT THE BEGINNING OF THE PROGRAM."
160 PRINT "PLEASE ENTER <AFTOX>
170 FOR I=1 TO 15000: NEXT I
180 END
190 IF MFLAG>0 THEN 450
200 COLOR COL4: LOCATE 2,1
210 PRINT "IS INFORMATION ON SOURCE STRENGTH AVAILABLE (Y/N)? <Y>"
220 COLOR COL1: LOCATE 5,1
230 PRINT TAB(10) "CAUTION-- Enter 'N' only if you have absolutely no"
240 PRINT TAB(20) "idea on source strength or amount spilled."
250 PRINT
260 PRINT TAB(18) "- Entering 'N' may result in a conservative"
270 PRINT TAB(20) "hazard distance, especially for liquid spills."
280 COLOR COL1: LOCATE 2,56
290 INPUT "",YY$
300 CLS
310 IF YY$="N" OR YY$="n" THEN GOSUB 6840: GOTO 340
320 IF YY$="Y" OR YY$="y" OR YY$="" THEN 440
330 PRINT CHR$(7): GOTO 280
340 COLOR COL4: PRINT
350 LOCATE 20,1
360 PRINT "TO ENTER NEW SOURCE STRENGTH DATA-------------PRESS <ENTER>"
370 PRINT "TO ENTER NEW CHEMICAL, TIME, AND/OR MET DATA--PRESS <M>"
380 PRINT "TO QUIT---------------------------------------PRESS <Q>"
390 INPUT NN$
400 IF NN$="Q" OR NN$="q" THEN 3660
410 IF NN$="M" OR NN$="m" THEN CHAIN "DSP1"
420 IF NN$="" THEN 440
430 PRINT CHR$(7): GOTO 340
440 CLS
450 COLOR COL1
460 IF TAK=>TB THEN 650          'GAS RELEASE
470 IF VP=0 THEN 520
480 PRINT "THIS IS A LIQUID RELEASE"
490 IF PYN=1 THEN 510
500 PRINT #3, "THIS IS A LIQUID RELEASE": GOTO 520
510 LPRINT "THIS IS A LIQUID RELEASE" 
520 NC=0
530 IF CHM$="NITROGEN TETROXIDE" THEN NC=1
540 IF CHM$="HYDRAZINE" THEN NC=2
550 IF CHM$="MONOMETHYLHYDRAZINE(MMH)" THEN NC=3
560 IF CHM$="DIMETHYLHYDRAZINE(UDMH)" THEN NC=4
570 IF CHM$="AEROZINE-50" THEN NC=5
580 IF NC>0 THEN EVAP=3: GOTO 610             'VOSSLER EVAP MODEL
590 IF EOK=0 OR SIG=0 THEN EVAP=1: GOTO 610   'CLEWELL EVAP MODEL 
600 EVAP=2:                                   'SHELL EVAP MODEL
610 H=0
620 COLOR COL4
630 IF ISTAT=1 THEN 980:         'CONTINUOUS LIQUID RELEASE
640 IF ISTAT=2 THEN 2470:        'INSTANTANEOUS LIQUID RELEASE
650 IF NU=0 THEN 700
660 PRINT "THIS IS A GAS RELEASE"
670 IF PYN=1 THEN 690
680 PRINT #3, "THIS IS A GAS RELEASE": GOTO 700
690 LPRINT "THIS IS A GAS RELEASE"
700 COLOR COL4
710 IF IUNIT=2 THEN 800
720 INPUT "HEIGHT OF LEAK ABOVE GROUND(M)";H
730 IF H=999 THEN 130
740 IF H<0 THEN 890
750 IF H=0 THEN 910
760 IF PYN=1 THEN 780
770 PRINT #3, "HEIGHT OF LEAK ABOVE GROUND IS";H;"M": GOTO 940
780 LPRINT "HEIGHT OF LEAK ABOVE GROUND IS";H;"M"
790 GOTO 940
800 INPUT "HEIGHT OF LEAK ABOVE GROUND(FT)";H
810 IF H=999 THEN 130
820 IF H<0 THEN 890
830 IF H=0 THEN 910
840 IF PYN=1 THEN 860
850 PRINT #3, "HEIGHT OF LEAK ABOVE GROUND IS";H;"FT": GOTO 870
860 PRINT "HEIGHT OF LEAK ABOVE GROUND IS";H;"FT"
870 H=H*.3048
880 GOTO 940
890 COLOR COL5: PRINT "NEGATIVE HEIGHTS NOT ACCEPTABLE"
900 PRINT CHR$(7): GOTO 700
910 IF PYN=1 THEN 930
920 PRINT #3, "SPILL IS AT GROUND LEVEL": GOTO 940
930 LPRINT "SPILL IS AT GROUND LEVEL"
940 IF ISTAT=1 THEN 1450     'CONTINUOUS GAS RELEASE
950 IF ISTAT=2 THEN 2130     'INSTANTANEOUS GAS RELEASE
960 '
970 '-----------------CONTINUOUS LIQUID RELEASE--------------------------------
980 IF MFLAG=1 THEN 2970: 'SUBSEQUENT RUN IN WHICH MET CONDITIONS ARE CHANGED
990 PRINT
1000 PRINT "   1";: COLOR COL1: PRINT " - LBS/MIN"
1010 COLOR COL4
1020 PRINT "   2";: COLOR COL1: PRINT " - GAL/MIN"
1030 COLOR COL4
1040 PRINT "   3";: COLOR COL1: PRINT " - KG/MIN"
1050 COLOR COL4
1060 PRINT "   4";: COLOR COL1: PRINT " - M3/MIN"
1070 PRINT: COLOR COL4
1080 INPUT "ENTER UNITS FOR SPILL RATE ",NO
1090 IF NO=999 THEN 130
1100 CLS
1110 ON NO GOTO 1140,1210,1280,1350
1120 PRINT CHR$(7)
1130 GOTO 990
1140 INPUT "SPILL RATE THROUGH RUPTURE(LB/MIN)";QPIPE
1150 IF QPIPE=999 THEN 440 ELSE IF QPIPE<=0 THEN PRINT CHR$(7): GOTO 1140
1160 IF PYN=1 THEN 1180
1170 PRINT #3,"SPILL RATE IS";QPIPE;"LB/MIN": GOTO 1190
1180 LPRINT "SPILL RATE IS";QPIPE;"LB/MIN"
1190 QPIPE=1000*QPIPE/2.2046
1200 GOTO 1730
1210 INPUT "SPILL RATE THROUGH RUPTURE(GAL/MIN)";QPIPE
1220 IF QPIPE=999 THEN 440 ELSE IF QPIPE<=0 THEN PRINT CHR$(7): GOTO 1210
1230 IF PYN=1 THEN 1250
1240 PRINT #3, "SPILL RATE IS";QPIPE;"GAL/MIN": GOTO 1260
1250 LPRINT "SPILL RATE IS";QPIPE;"GAL/MIN"
1260 QPIPE=3785.41*QPIPE*DLIQ
1270 GOTO 1730
1280 INPUT "SPILL RATE THROUGH RUPTURE(KG/MIN)";QPIPE
1290 IF QPIPE=999 THEN 440 
1300 IF QPIPE<=0 THEN PRINT CHR$(7): GOTO 1280
1310 IF PYN=1 THEN 1330
1320 PRINT #3,"SPILL RATE IS";QPIPE;"KG/MIN": GOTO 1420
1330 LPRINT "SPILL RATE IS";QPIPE;"KG/MIN"
1340 GOTO 1420
1350 INPUT "SPILL RATE THROUGH RUPTURE(M3/MIN)";QPIPE
1360 IF QPIPE=999 THEN 440 
1370 IF QPIPE<=0 THEN PRINT CHR$(7): GOTO 1350
1380 IF PYN=1 THEN 1400
1390 PRINT #3,"SPILL RATE IS";QPIPE;"M3/MIN": GOTO 1410
1400 LPRINT "SPILL RATE IS";QPIPE;"M3/MIN"
1410 QPIPE=1000*QPIPE*DLIQ
1420 QPIPE=QPIPE*1000
1430 GOTO 1730
1440 '-----------------CONTINUOUS GAS RELEASE------------------------------------
1450 CLS
1460 PRINT
1470 PRINT "   1 ";: COLOR COL1: PRINT "- LB/MIN"
1480 COLOR COL4
1490 PRINT "   2 ";: COLOR COL1: PRINT "- KG/MIN"
1500 PRINT: COLOR COL4
1510 INPUT "ENTER UNITS FOR EMISSION RATE ",NO
1520 IF NO=999 THEN 130
1530 IF NO<1 OR NO>2 THEN PRINT CHR$(7): GOTO 1450
1540 CLS
1550 IF NO=2 THEN 1640
1560 INPUT "EMISSION RATE THROUGH RUPTURE(LB/MIN)";QPIPE
1570 IF QPIPE=999 THEN 1450 
1580 IF QPIPE<=0 THEN PRINT CHR$(7): GOTO 1560
1590 IF PYN=1 THEN 1610
1600 PRINT #3,"EMISSION RATE IS";QPIPE;"LB/MIN": GOTO 1620
1610 LPRINT "EMISSION RATE IS";QPIPE;"LB/MIN"
1620 QPIPE=QPIPE/2.2046
1630 GOTO 1710
1640 NO=3
1650 INPUT "EMISSION RATE THROUGH RUPTURE(KG/MIN)";QPIPE
1660 IF QPIPE=999 THEN 1450 
1670 IF QPIPE<=0 THEN PRINT CHR$(7): GOTO 1640
1680 IF PYN=1 THEN 1700
1690 PRINT #3, "EMISSION RATE IS";QPIPE;"KG/MIN": GOTO 1710
1700 LPRINT "EMISSION RATE IS";QPIPE;"KG/MIN"
1710 QPIPE=QPIPE*1000
1720 '---------------------------------------------------------------------------
1730 INPUT "IS CHEMICAL STILL LEAKING(Y/N)? <Y>",YN$
1740 IF YN$="N" OR YN$="n" THEN 1850
1750 IF YN$="Y" OR YN$="y" OR YN$="" THEN 1800
1760 IF YN$="999" AND TAK>=TB THEN 1450
1770 IF YN$="999" THEN 1110
1780 PRINT CHR$(7)
1790 GOTO 1730
1800 TTSP=10000  '  TOTAL TIME OF SPILL IN MINUTES
1810 IF PYN=1 THEN 1830
1820 PRINT #3, "CHEMICAL IS STILL LEAKING": GOTO 2070
1830 LPRINT "CHEMICAL IS STILL LEAKING"
1840 GOTO 2070
1850 INPUT "HOW LONG DID THE SPILL LAST (MIN)";TTSP
1860 IF TTSP=999 THEN 1730 
1870 IF TTSP<=0 THEN PRINT CHR$(7): GOTO 1850
1880 IF PYN=1 THEN 1900
1890 PRINT #3, "ELAPSED TIME OF SPILL IS";INT(TTSP+.5);"MIN": GOTO 1910
1900 LPRINT "ELAPSED TIME OF SPILL IS";INT(TTSP+.5);"MIN"
1910 TMSP=TTSP*QPIPE
1920 COLOR COL1
1930 IF NO=1 OR NO=2 THEN 2010
1940 TMET=TMSP/1000
1950 IF TMET>10 THEN TMET=INT(TMET) ELSE TMET=INT(TMET*10)/10
1960 PRINT "TOTAL AMOUNT SPILLED IS";TMET;"KG"
1970 IF PYN=1 THEN 1990
1980 PRINT #3, "TOTAL AMOUNT SPILLED IS";TMET;"KG": GOTO 2070
1990 LPRINT "TOTAL AMOUNT SPILLED IS";TMET;"KG"
2000 GOTO 2070
2010 TENG=TMSP*2.2046/1000
2020 IF TENG>10 THEN TENG=INT(TENG) ELSE TENG=INT(TENG*10)/10
2030 PRINT "TOTAL AMOUNT SPILLED IS";TENG;"LBS"
2040 IF PYN=1 THEN 2060
2050 PRINT #3, "TOTAL AMOUNT SPILLED IS";TENG;"LBS": GOTO 2070
2060 LPRINT "TOTAL AMOUNT SPILLED IS";TENG;"LBS"
2070 QSS=QPIPE
2080 QEVP=QPIPE
2090 IF VP=0 AND NC=0 THEN 2110
2100 IF TAK<TB THEN 2970     'CONTINUOUS LIQUID SPILL
2110 WWIDTH=1
2120 GOTO 3650               'CONTINUOUS GAS RELEASE.  EXIT
2130 '-----------------INSTANTANEOUS GAS RELEASE--------------------------------
2140 CLS
2150 PRINT
2160 PRINT "   1";: COLOR COL1: PRINT " - LBS"
2170 COLOR COL4
2180 PRINT "   2";: COLOR COL1: PRINT " - KG"
2190 PRINT: COLOR COL4
2200 INPUT "ENTER UNITS FOR SPILL AMOUNT ",NO
2210 CLS
2220 IF NO=1 THEN 2260
2230 IF NO=2 THEN 2330
2240 IF NO=999 THEN 710
2250 PRINT CHR$(7): GOTO 2140
2260 INPUT "TOTAL AMOUNT RELEASED IN LBS";TMSP
2270 IF TMSP=999 THEN 2140
2280 IF PYN=1 THEN 2300
2290 PRINT #3, "TOTAL AMOUNT RELEASED IS";INT(TMSP);"LBS": GOTO 2310
2300 LPRINT "TOTAL AMOUNT RELEASED IS";INT(TMSP);"LBS"
2310 TMSP=TMSP/.0022046
2320 GOTO 2410
2330 NO=3
2340 INPUT "TOTAL AMOUNT RELEASED IN KG";TMSP
2350 IF TMSP=999 THEN 2140
2360 IF PYN=1 THEN 2380
2370 PRINT #3, "TOTAL AMOUNT RELEASED IS";INT(TMSP)"KG": GOTO 2390
2380 LPRINT "TOTAL AMOUNT RELEASED IS";INT(TMSP)"KG"
2390 TMSP=TMSP*1000
2400 'ASSUME DEPTH=RADIUS
2410 HA=TMSP/(DVAP*10^6)
2420 WWIDTH=2*(HA/PI)^(1/3)
2430 TTSP=.25 :'ASSUME RELEASE OVER 15 SEC
2440 QPIPE=TMSP/TTSP
2450 QSS=QPIPE
2460 GOTO 3650    'EXIT
2470 '-------------------INSTANTANEOUS LIQUID RELEASE--------------------------
2480 IF MFLAG=1 THEN 2970: 'SUBSEQUENT RUN IN WHICH MET CONDITIONS ARE CHANGED
2490 PRINT
2500 PRINT "   1";: COLOR COL1: PRINT " - LBS"
2510 COLOR COL4
2520 PRINT "   2";: COLOR COL1: PRINT " - GAL"
2530 COLOR COL4
2540 PRINT "   3";: COLOR COL1: PRINT " - KG"
2550 COLOR COL4
2560 PRINT "   4";: COLOR COL1: PRINT " - M3"
2570 PRINT: COLOR COL4
2580 INPUT "ENTER UNITS FOR SPILL AMOUNT ",NO
2590 IF NO=999 THEN 130
2600 CLS
2610 ON NO GOTO 2640,2720,2800,2880
2620 PRINT CHR$(7)
2630 GOTO 2490
2640 INPUT "TOTAL AMOUNT SPILLED IN LBS";TMSP
2650 IF TMSP=999 THEN 2490 
2660 IF TMSP<=0 THEN PRINT CHR$(7): GOTO 2640
2670 IF PYN=1 THEN 2690
2680 PRINT #3,"TOTAL AMOUNT SPILLED IS";INT(TMSP);"LBS": GOTO 2700
2690 LPRINT "TOTAL AMOUNT SPILLED IS";INT(TMSP);"LBS"
2700 TMSP=TMSP/.0022046
2710 GOTO 2950
2720 INPUT "TOTAL AMOUNT SPILLED IN GAL";TMSP
2730 IF TMSP=999 THEN 2490 
2740 IF TMSP<=0 THEN PRINT CHR$(7): GOTO 2720
2750 IF PYN=1 THEN 2770
2760 PRINT #3,"TOTAL AMOUNT SPILLED IS";INT(TMSP);"GAL": GOTO 2780
2770 LPRINT "TOTAL AMOUNT SPILLED IS";INT(TMSP);"GAL"
2780 TMSP=3785.41*TMSP*DLIQ
2790 GOTO 2950
2800 INPUT "TOTAL AMOUNT SPILLED IN KG";TMSP
2810 IF TMSP=999 THEN 2490 
2820 IF TMSP<=0 THEN PRINT CHR$(7): GOTO 2800
2830 IF PYN=1 THEN 2850
2840 PRINT #3,"TOTAL AMOUNT SPILLED IS";INT(TMSP)"KG": GOTO 2860
2850 LPRINT "TOTAL AMOUNT SPILLED IS";INT(TMSP)"KG"
2860 TMSP=TMSP*1000
2870 GOTO 2950
2880 INPUT "TOTAL AMOUNT SPILLED IN M3";TMSP
2890 IF TMSP=999 THEN 2490 
2900 IF TMSP<=0 THEN PRINT CHR$(7): GOTO 2880
2910 IF PYN=1 THEN 2930
2920 PRINT #3,"TOTAL AMOUNT SPILLED IS";INT(TMSP);"M3": GOTO 2940
2930 LPRINT "TOTAL AMOUNT SPILLED IS";INT(TMSP);"M3"
2940 TMSP=1000000!*DLIQ*TMSP
2950 IF VP=0 AND NC=0 THEN 2400 
2960 '***INPUT AREA FOR INSTANTANEOUS OR CONTINUOUS LIQUID SPILL
2970 IF MFLAG=1 AND A<>0 THEN 3300
2980 PRINT
2990 DPTH=1!   'ASSUME POOL DEPTH EQUAL 1 CM
3000 IF IUNIT=1 THEN 3120
3010 IF TTSP=10000 THEN TMSP=10*QPIPE: 'ASSUME 10 MIN FLOW
3020 DAREA=10.76*.0001*TMSP/DLIQ/DPTH
3030 COLOR COL1: PRINT "DEFAULT SPILL AREA IS";INT(DAREA);"SQ FT"
3040 COLOR COL4
3050 INPUT "ENTER SPILL AREA IN SQ FT, OR PRESS <ENTER> FOR DEFAULT AREA ",A
3060 IF A=0 THEN A=DAREA
3070 IF A=999 AND ISTAT=1 THEN 1730
3080 IF A=999 THEN 2490 
3090 IF A<=0 THEN PRINT CHR$(7): GOTO 3020
3100 A=A*.3048*.3048
3110 GOTO 3230
3120 IF TTSP=10000 THEN TMSP=10*QPIPE: 'ASSUME 10 MIN FLOW
3130 DAREA=.0001*TMSP/DLIQ/DPTH
3140 IF DAREA<1 THEN DAREA=1
3150 COLOR COL1: PRINT "DEFAULT SPILL AREA IS";INT(DAREA);"SQ M"
3160 COLOR COL4
3170 INPUT "ENTER SPILL AREA IN SQ M, OR PRESS <ENTER> FOR DEFAULT AREA ",A
3180 IF A=0 THEN A=DAREA
3190 IF A<>999 THEN 3220
3200 IF ISTAT=2 THEN 2490
3210 GOTO 1730
3220 IF A<=0 THEN PRINT CHR$(7): GOTO 3120
3230 WWIDTH=SQR(A)
3240 IF PYN=1 THEN 3280
3250 IF IUNIT=1 THEN PRINT #3,"AREA OF SPILL IS";INT(A);"SQ M"
3260 IF IUNIT=2 THEN PRINT #3,"AREA OF SPILL IS";INT(A/.3048^2);"SQ FT"
3270 GOTO 3300
3280 IF IUNIT=1 THEN LPRINT "AREA OF SPILL IS";INT(A);"SQ M"
3290 IF IUNIT=2 THEN LPRINT "AREA OF SPILL IS";INT(A/.3048^2);"SQ FT"
3300 IF EVAP=1 THEN GOSUB 3680
3310 IF EVAP=2 THEN GOSUB 3950
3320 IF EVAP=3 THEN GOSUB 4150
3330 IF ISTAT=1 AND QEVP>QPIPE THEN QEVP=QPIPE
3340 IF EVAP=1 OR EVAP=3 THEN 3370
3350 '--------------------------------------------------------------------
3360 CLS
3370 COLOR COL1
3380 IF NO=1 OR NO=2 THEN 3460
3390 QQS=INT(100*QEVP/1000)/100
3400 PRINT "EVAPORATION RATE IS";QQS;"KG/MIN"
3410 IF PYN=1 THEN 3440
3420 PRINT #3, "EVAPORATION RATE IS";QQS;"KG/MIN"
3430 GOTO 3540
3440 LPRINT "EVAPORATION RATE IS";QQS;"KG/MIN"
3450 GOTO 3540
3460 QQS=INT(100*QEVP*.0022046)/100
3470 IF QQS=0 THEN QQS=INT(1000*QEVP*.0022046)/1000
3480 IF QQS=0 THEN QQS=INT(10000*QEVP*.0022046)/10000
3490 PRINT "EVAPORATION RATE IS";QQS;"LBS/MIN"
3500 IF PYN=1 THEN 3530
3510 PRINT #3, "EVAPORATION RATE IS";QQS;"LBS/MIN"
3520 GOTO 3540
3530 LPRINT "EVAPORATION RATE IS";QQS;"LBS/MIN"
3540 QSS=QEVP
3550 IF TTSP=10000 THEN 3650
3560 TTSP=TMSP/QEVP
3570 PRINT "THE CHEMICAL WILL EVAPORATE IN";INT(10*TTSP)/10;"MIN"
3580 IF PYN=1 THEN 3610
3590 PRINT #3, "THE CHEMICAL WILL EVAPORATE IN";INT(10*TTSP)/10;"MIN"
3600 GOTO 3620
3610 LPRINT "THE CHEMICAL WILL EVAPORATE IN";INT(10*TTSP)/10;"MIN"
3620 IF TTSP>10000 THEN TTSP=10000: 'ASSUME CONTINUOUS INFINITE RELEASE
3630 IF MFLAG<>1 THEN 3650
3640 FOR I=1 TO 15000: NEXT I
3650 CHAIN"DSP3"
3660 END
3670 '=====================================================================
3680 'SUBROUTINE CLEWELL EVAP
3690 COLOR COL4: INPUT "DO YOU KNOW POOL TEMPERATURE (Y/N)? <N>",YY$
3700 IF YY$="N" OR YY$="n" OR YY$="" THEN 3780
3710 IF YY$="999" THEN 3000
3720 CLS
3730 IF IUNIT=1 THEN INPUT "ENTER POOL TEMP(C)";TP
3740 IF IUNIT=2 THEN INPUT "ENTER POOL TEMP(F)";TP
3750 IF TP=999 THEN 3690
3760 IF IUNIT=2 THEN TP=5/9*(TP-32)
3770 GOTO 3810
3780 TP=TA
3790 CLS
3800 COLOR COL1: PRINT "MODEL ASSUMES POOL TEMP = AIR TEMP"
3810 IF PYN=1 THEN 3850
3820 IF IUNIT=1 THEN PRINT #3, "POOL TEMPERATURE IS ";TP;"C"
3830 IF IUNIT=2 THEN PRINT #3, "POOL TEMPERATURE IS ";1.8*TP+32;"F"
3840 GOTO 3870
3850 IF IUNIT=1 THEN LPRINT "POOL TEMPERATURE IS ";TP;"C"
3860 IF IUNIT=2 THEN LPRINT "POOL TEMPERATURE IS ";1.8*TP+32;"F"
3870 HYDFAC=32.045*.02113: 'HYDRAZINE FACTOR = MW OF HYDRAZINE * VP(ATM)
3880 VF=VP*MW/HYDFAC
3890 FT=1!+.0043*TP^2
3900 IF TP<0 THEN FT=1!
3910 QEVP=.08*U^.75*A*FT*VF :  'EQ 47
3920 QEVP=QEVP*1000/60: 'G/MIN
3930 RETURN
3940 '===================================================================
3950 'SUBROUTINE SHELL EVAP
3960 '-------------------------------------------------------------------
3970 EIJ=SQR(EOK*78.6)
3980 TS=TAK/EIJ
3990 OMEGA=1.06036/TS^.1561+.193*EXP(-.47635*TS)
4000 OMEGA=OMEGA+1.03587*EXP(-1.52996*TS)+1.76474*EXP(-3.89411*TS)
4010 RM=SQR((MW+MWA)/(MW*MWA))
4020 SIJ=.5*(3.711+SIG)
4030 CX=(2.17-.5*RM)/1000
4040 DIFUS=CX*TAK*SQR(TAK)*RM/(OMEGA*SIJ*SIJ*PRES/1013)
4050 SCHMDT=VISCK/DIFUS
4060 RENL=U*WWIDTH*10000/VISCK
4070 IF RENL>320000! THEN 4100
4080 SHWD=.664*SCHMDT^(1/3)*SQR(RENL)
4090 GOTO 4110
4100 SHWD=.037*SCHMDT^(1/3)*(RENL^.8-15200)
4110 CMTC=SHWD*DIFUS/WWIDTH/10000
4120 QEVP=CMTC*A*DVAP*60*1000000!: 'G/MIN
4130 RETURN
4140 '====================================================================
4150 'SUBROUTINE VOSSLER EVAP
4160 '--------------------------------------------------------------------
4170 IF QFLAG=1 THEN 4810
4180 OPEN "I",#2,"EVAP.DAT"
4190 FOR J=1 TO NC
4200   INPUT #2,NN,CHM$
4210   FOR I=1 TO 40
4220     INPUT #2,B(I)
4230   NEXT I
4240 NEXT J
4250 CLOSE #2
4260 MW=B(1):   'MOLECULAR WEIGHT
4270 TB=B(2):   'BOILING TEMP
4280 TF=B(3):   'FREEZING TEMP
4290 'VAPOR VISCOSITY CONSTANTS
4300 VISA=B(4): VISB=B(5): VISC=B(6)
4310 'APPLICABLE TEMPERATURE RANGES
4320 VISD=B(7): VISE=B(8)
4330 'VAPOR HEAT CAPACITY
4340 CPVA=B(9): CPVB=B(10): CPVC=B(11): CPVD=B(12)
4350 'APPLICABLE TEMPERATURE RANGES
4360 CPVE=B(13): CPVF=B(14)
4370 'VAPOR THERMAL CONDUCTIVITY CONSTANTS
4380 XKVA=B(15): XKVB=B(16): XKVC=B(17): XKVD=B(18)
4390 'APPLICABLE TEMPERATURE RANGES
4400 XKVE=B(19): XKVF=B(20)
4410 'HEAT OF VAPORIZATION
4420 LMDA=B(21): LMDB=B(22): LMDC=B(23): LMDD=B(24)
4430 'APPLICABLE TEMPERATURE RANGES
4440 LMDE=B(25): LMDF=B(26)
4450 'SATURATION PRESSURE CONSTANTS
4460 PSATA=B(27): PSATB=B(28): PSATC=B(29): PSATD=B(30): PSATE=B(31): PSATF=B(32)
4470 'APPLICABLE TEMPERATURE RANGES
4480 PSATG=B(33): PSATH=B(34) 
4490 'LIQUID THERMAL CONDUCTIVITY CONSTANTS
4500 XKLA=B(35): XKLB=B(36): XKLC=B(37)
4510 'APPLICABLE TEMPERATURE RANGES
4520 XKLD=B(38): XKLE=B(39)
4530 VO=B(40): 'MOLECULAR DIFFUSION VOLUME 
4540 TL=TAK: TG=TAK
4550 IF TMSP=0 THEN DPM=.1: GOTO 4570: 'DEPTH SET AT 10 CM FOR CONT. SPILLS
4560 DPM=TMSP/(1000000!*DLIQ*A)
4570 R=8314.401:   ' Gas Constant for 1 gram mol of ideal gas
4580 PATM=101325!
4590 TP=TB
4600 IF TP>TG THEN TP=TG
4610 DATA .23,.19,.05,.04,.29,.24,.13,.10
4620 DATA .51,.46,.25,.20,1.05,.96,.60,.54
4630 FOR II=1 TO 4
4640   FOR JJ=1 TO 4
4650     READ NN(II,JJ)
4660   NEXT JJ
4670 NEXT II
4680 IF STBV<=3 THEN II=1
4690 IF INT(STBV)=3 THEN II=2
4700 IF STBV>=4 AND STBV<=6 THEN II=3
4710 IF U<=1 AND STBV=6 THEN II=4
4720 IF ZO=>100 THEN JJ=1
4730 IF ZO<100 THEN JJ=2
4740 IF ZO<35 THEN JJ=3
4750 IF ZO<5 THEN JJ=4
4760 ALFA=NN(II,JJ)
4770 GN=2*ALFA/(1+ALFA)
4780 GNA=(2-GN)/(2+GN)
4790 GNB=-GN/(2+GN)
4800 REM***********CALCULATE ENERGY TERMS****************
4810 XT=600
4820 'IN AFTOX, WE ASSUME THAT GROUND IS SOIL
4830 GD=1
4840 IF DW=2 THEN GD=2
4850 IF GD=1 THEN 5060
4860 IF GD=2 THEN 5090
4870 PRINT
4880 COLOR COL4: PRINT "1";: COLOR COL1: PRINT "--SOIL" 
4890 COLOR COL4: PRINT "2";: COLOR COL1: PRINT "--SAND"
4900 COLOR COL4: PRINT "3";: COLOR COL1: PRINT "--CONCRETE"
4910 PRINT
4920 COLOR COL4: INPUT "GROUND TYPE";GD
4930 IF GD=999 THEN QFLAG=1: GOTO 3000
4940 IF GD<1 OR GD>3 THEN PRINT "PLEASE ENTER 1, 2, OR 3": GOTO 4870
4950 IF GD=3 THEN GD=5
4960 IF DW=2 AND GD=2 THEN GD=4
4970 IF DW=1 AND GD=2 THEN GD=3
4980 IF DW=2 AND GD=1 THEN GD=2
4990 CLS
5000 COLOR COL1
5010 IF GD=1 THEN PRINT "GROUND IS DRY SOIL" : GOTO 5060
5020 IF GD=2 THEN PRINT "GROUND IS WET SOIL" : GOTO 5090
5030 IF GD=3 THEN PRINT "GROUND IS DRY SAND" : GOTO 5120
5040 IF GD=4 THEN PRINT "GROUND IS WET SAND" : GOTO 5150
5050 IF GD=5 THEN PRINT "GROUND IS CONCRETE" : GOTO 5180
5060 KG=.138: ALPHAG=1.1E-07
5070 'IF PYN=1 THEN LPRINT "GROUND IS DRY SOIL" ELSE PRINT#3, "GROUND IS DRY SOIL"
5080 GOTO 5200
5090 KG=.657: ALPHAG=1.9E-07
5100 'IF PYN=1 THEN LPRINT "GROUND IS WET SOIL" ELSE PRINT#3, "GROUND IS WET SOIL"
5110 GOTO 5200
5120 KG=.326: ALPHAG=2.74E-06
5130 IF PYN=1 THEN LPRINT "GROUND IS DRY SAND" ELSE PRINT#3, "GROUND IS DRY SAND"
5140 GOTO 5200
5150 KG=1.128: ALPHAG=4.92E-06
5160 IF PYN=1 THEN LPRINT "GROUND IS WET SAND" ELSE PRINT#3, "GROUND IS WET SAND"
5170 GOTO 5200
5180 KG=1.279: ALPHAG=4.92E-06
5190 IF PYN=1 THEN LPRINT "GROUND IS CONCRETE" ELSE PRINT#3, "GROUND IS CONCRETE"
5200 CLS
5210 COLOR COL1
5220 HGRD=KG/(PI*ALPHAG*XT)^.5
5230 GOSUB 5990:    'LIQUID THERMAL CONDUCTIVITY (XKL)
5240 PHI=1/(1+EXP(-.06*(TB-70!-273.16)))
5250 DPMA=DPM/2
5260 HLIQ=XKL/(PHI*DPMA)
5270 UGRD=1/((1/HGRD)+(1/HLIQ))
5280 GOSUB 5890:   'NET HEAT TRANSFER DUE TO RADIATION EFFECTS (QRAD)
5290 IF TP>TF GOTO 5320
5300 GOSUB 5720:   'HEAT LOSS DUE TO SUBLIMATION (QEV)
5310 GOTO 5330
5320 GOSUB 5650:   'HEAT LOSS DUE TO EVAPORATION (QEV)
5330 GOSUB 5810:   'SENSIBLE HEAT CONDUCTED FROM ATMOSPHERE TO POOL (QHE)
5340 FX=(TP-TAK)*(ULIQ+UGRD)+QEV-QRAD
5350 FDX=ULIQ+UGRD+4*QPOL/TP+(QEV*2.303*PSATB)/((TP+PSATC)^2)-QEV/TP
5360 TOL=.1
5370 TPNEW=TP-(FX/FDX)
5380 IF ABS(TP-TPNEW)<TOL GOTO 5420
5390 TP=TPNEW
5400 IF TP>TF GOTO 5230
5410 TP=TF
5420 IF TP>TF GOTO 5450
5430 GOSUB 5720:   'HEAT LOSS DUE TO SUBLIMATION (QEV)
5440 GOTO 5580
5450 GOSUB 5650:   'HEAT LOSS DUE TO EVAPORATION (QEV)
5460 IF TP<TB GOTO 5580
5470 TP=TB
5480 GOSUB 6710:   'MASS TRANSFER COEFFICIENT (TRCOEFF) 
5490 GOSUB 5810:   'CONVECTIVE HEAT TRANSFER FROM POOL (QHE)
5500 GOSUB 5890:   'NET HEAT TRANSFER DUE TO RADIATION EFFECTS ((QRAD)
5510 QGRD=UGRD*(TG-TP)
5520 IF TP=TF THEN 5560
5530 GOSUB 6430:   'HEAT OF VAPORIZATION (LAMDA)
5540 QEVP=(QGRD+QRAD+QHE)*A/LAMDA: 'KG/SEC
5550 GOTO 5570
5560 QEVP=(QGRD+QRAD+QHE)*A/HSUB: 'KG/SEC
5570 QEVP=QEVP*60*1000: 'G/MIN
5580 TPTEMP=INT(10*(TP-273.16))/10
5590 PRINT "CALCULATED POOL TEMPERATURE ";TPTEMP;"C"
5600 IF PYN=1 THEN 5630
5610 PRINT #3, "CALCULATED POOL TEMPERATURE IS ";TPTEMP;"C"
5620 GOTO 5640
5630 LPRINT "CALCULATED POOL TEMPRATURE IS ";TPTEMP;"C"
5640 RETURN
5650 REM*****HEAT LOSS DUE TO EVAPORATION*****
5660 GOSUB 6710:   'MASS TRANSFER COEFFICIENT (TRCOEFF)
5670 FM=MW*TRCOEFF*PSAT/(R*TP)
5680 QEVP=A*FM*60*1000: 'G/MIN
5690 GOSUB 6430:   'HEAT OF VAPORIZATION (LAMDA)
5700 QEV=1*FM*LAMDA
5710 RETURN
5720 REM*****HEAT LOSS DUE TO SUBLIMATION*****
5730 GOSUB 6710:   'MASS TRANSFER COEFFICIENT (TRCOEFF)
5740 FM=MW*TRCOEFF*PSAT/(R*TP)
5750 QEVP=A*FM*60*1000: 'G/MIN
5760 GOSUB 6430:   'HEAT OF VAPORIZATION (LAMDA)
5770 HFUS=159000!
5780 HSUB=HFUS+LAMDA
5790 QEV=FM*HSUB
5800 RETURN
5810 REM*****CONVECTIVE HEAT TRANSFER FROM ATMOSPHERE TO POOL (QHE)*****
5820 DVAP=(MF*MW+(1-MF)*MWA)*PATM/(R*TP)
5830 GOSUB 6190:   'VAPOR HEAT CAPACITY (CPV)
5840 GOSUB 6300:   'VAPOR THERMAL CONDUCTIVITY (XKV)
5850 PR=CPV*VISP/XKV
5860 ULIQ=TRCOEFF*DVAP*CPV*((SC/PR)^.67)
5870 QHE=ULIQ*(TAK-TP)
5880 RETURN
5890 REM*****NET HEAT TRANSFER DUE TO RADIATION EFFECTS (QRAD)*****
5900 ALB=.14
5910 QSOL=SR*(1-ALB)
5920 SB=5.67E-08
5930 EA=.75
5940 QATM=EA*SB*TAK^4
5950 EP=.95
5960 QPOL=EP*SB*TP^4
5970 QRAD=QATM+QSOL-QPOL
5980 RETURN
5990 REM*****LIQUID THERMAL CONDUCTIVITY (XKL)*****
6000 TLO=XKLE
6010 TUP=XKLD
6020 IF TP<TLO THEN 6050
6030 IF TP>TUP THEN 6060
6040 XKL=XKLA+TP*(XKLB+XKLC*TP): GOTO 6070
6050 XKL=XKLA+TLO*(XKLB+XKLC*TLO): GOTO 6070
6060 XKL=XKLA+TUP*(XKLB+XKLC*TUP): GOTO 6070
6070 RETURN
6080 REM*****VAPOR VISCOSITY (VISP)*****
6090 TLO=VISE
6100 TUP=VISD
6110 IF TP<TLO THEN 6140
6120 IF TP>TUP THEN 6150
6130 VISP=VISA+TP*(VISB+TP*VISC): GOTO 6160
6140 VISP=VISA+TLO*(VISB+TLO*VISC): GOTO 6160
6150 VISP=VISA+TUP*(VISB+TUP*VISC): GOTO 6160
6160 VISPAIR=.0000182
6170 VISP=(MF*MW^.5*VISP+(1-MF)*MWA^.5*VISPAIR)/(MF*MW^.5+(1-MF)*MWA^.5)
6180 RETURN
6190 REM*****VAPOR HEAT CAPACITY (CPV)*****
6200 TLO=CPVF
6210 TUP=CPVE
6220 IF TP<TLO THEN 6250
6230 IF TP>TUP THEN 6260
6240 CPV=CPVA+TP*(CPVB+TP*(CPVC+TP*CPVD)): GOTO 6270
6250 CPV=CPVA+TLO*(CPVB+TLO*(CPVC+TLO*CPVD)): GOTO 6270
6260 CPV=CPVA+TUP*(CPVB+TUP*(CPVC+TUP*CPVD)): GOTO 6270
6270 CPVAIR=1000!:  'J/KG-K
6280 CPV=(MF*MW*CPV+(1-MF)*MWA*CPVAIR)/(MF*MW+(1-MF)*MWA)
6290 RETURN
6300 REM*****THERMAL CONDUCTIVITY OF THE MIXTURE (XKV)*****
6310 TLO=XKVF
6320 TUP=XKVE
6330 IF TP<TLO THEN 6360
6340 IF TP>TUP THEN 6370
6350 XKV=XKVA+TP*(XKVB+TP*(XKVC+TP*XKVD)): GOTO 6380
6360 XKV=XKVA+TLO*(XKVB+TLO*(XKVC+TLO*XKVD)): GOTO 6380
6370 XKV=XKVA+TUP*(XKVB+TUP*(XKVC+TUP*XKVD)): GOTO 6380
6380 XKVAIR=.0233: 'J/M-S-K
6390 XKVX=(MF*MW^.333*XKV+(1-MF)*MWA^.333*XKVAIR)
6400 XKVY=(MF*MW^.333+(1-MF)*MWA^.333)
6410 XKV=XKVX/XKVY
6420 RETURN
6430 REM*****HEAT OF VAPORIZATION (LAMDA)*****
6440 CRIT=LMDA
6450 REFT=LMDB
6460 HVPTRF=LMDC
6470 EXPON=LMDD
6480 TUP=LMDE
6490 TLO=LMDF
6500 IF CRIT-REFT=0 THEN X=0: GOTO 6560
6510 IF TP<TLO THEN 6540
6520 IF TP>TUP THEN 6550
6530 X=HVPTRF*(((CRIT-TP)/(CRIT-REFT))^EXPON): GOTO 6560
6540 X=HVPTRF*(((CRIT-TLO)/(CRIT-REFT))^EXPON): GOTO 6560
6550 X=HVPTRF*(((CRIT-TUP)/(CRIT-REFT))^EXPON): GOTO 6560
6560 LAMDA=X
6570 RETURN
6580 REM*****SATURATION PRESSURE, PSAT (pascal)*****
6590 TLO=PSATH
6600 TUP=PSATG
6610 P=PATM/760
6620 IF TP<TLO THEN 6660
6630 IF TP>TUP THEN 6680
6640 PSAT=P*10^(PSATA-(PSATB/(PSATC+TP))-PSATD/TP^2+PSATE*TP+PSATF*TP^2)
6650 GOTO 6690
6660 PSAT=P*10^(PSATA-(PSATB/(PSATC+TLO))-PSATD/TLO^2+PSATE*TLO+PSATF*TLO^2)
6670 GOTO 6690
6680 PSAT=P*10^(PSATA-(PSATB/(PSATC+TUP))-PSATD/TUP^2+PSATE*TUP+PSATF*TUP^2)
6690 MF=PSAT/PATM
6700 RETURN
6710 REM*****MASS TRANSFER COEFFICIENT (TRCOEFF)*****
6720 VOA=19.7 
6730 DV1=.00101*TP^1.75*SQR(1/MWA+1/MW) 
6740 DV2=(PATM/100000!)*((VOA)^.3333+(VO)^.3333)^2 
6750 DV=(DV1/DV2)*.0001:    'DIFFUSIVITY, M2/SEC 
6760 GOSUB 6580:            'VAPOR PRESSURE AND MOLE FRACTION OF CHEMICAL 
6770 GOSUB 6080:            'VAPOR VISCOSITY, VISP 
6780 DVAP=(MF*MW+(1-MF)*MWA)*PATM/(R*TP) 
6790 SC=VISP/(DVAP*DV) 
6800 TRCOEF=(.0292/(SC^.667))*(U*3600)^GNA*(WWIDTH)^GNB:'M/HR 
6810 TRCOEFF=TRCOEF/3600: 'M/S 
6820 RETURN
6830 '=======================================================================
6840 'SUBROUTINE WORST_CASE
6850 '-----------------------------------------------------------------------
6860 IF UU>1.8 THEN 6890
6870 SAN=360
6880 GOTO 6990
6890 IF OPTN=1 THEN 6940
6900 SAN=6*SIGTH
6910 IF SAN<30 THEN SAN=30
6920 IF SAN>180 THEN SAN=180
6930 GOTO 6990
6940 IF STB>=3.5 THEN 6970
6950 SAN=(165-30*STB)
6960 GOTO 6990
6970 SAN=90
6980 IF UU>5.15 THEN SAN=46
6990 XM=UU*3553
7000 PRINT: COLOR COL1
7010 PRINT "ASSUME WORST CASE AS DEFINED BY AFR 355-1/AWS SUP1, ATCH 1, 24 SEP 90"
7020 PRINT "(Toxic corridor length represents distance plume will travel in 1 hr)"
7030 PRINT
7040 IF PYN=1 THEN 7060
7050 PRINT #3, "ASSUME WORST CASE AS DEFINED BY AFR 355-1/AWS SUP1": GOTO 7070
7060 LPRINT: LPRINT "ASSUME WORST CASE AS DEFINED BY AFR 355-1/AWS SUP1"
7070 IF IUNIT=2 THEN 7120
7080 PRINT "CORRIDOR LENGTH (m)      =";INT(XM*.1)*10
7090 IF PYN=1 THEN 7110
7100 PRINT #3, "CORRIDOR LENGTH (m)     =";INT(XM*.1)*10: GOTO 7160
7110 LPRINT: LPRINT "CORRIDOR LENGTH (m)      =";INT(XM*.1)*10: GOTO 7160
7120 PRINT "CORRIDOR LENGTH (ft)     =";INT(XM*3.28084*.1)*10
7130 IF PYN=1 THEN 7150
7140 PRINT #3, "CORRIDOR LENGTH (ft)     =";INT(XM*3.28084*.1)*10: GOTO 7160
7150 LPRINT: LPRINT "CORRIDOR LENGTH (ft)     =";INT(XM*3.28084*.1)*10
7160 PD=WD+180 
7170 IF PD>360 THEN PD=PD-360
7180 IF SAN=360 THEN 7240
7190 PRINT "CORRIDOR DIRECTION and WIDTH (deg) =";PD;" +/-";INT(SAN/2)
7200 IF PYN=1 THEN 7220
7210 PRINT #3, "CORRIDOR DIRECTION AND WIDTH (deg) =";PD;" +/-";INT(SAN/2): GOTO 7280
7220 LPRINT "CORRIDOR DIRECTION AND WIDTH (deg) =";PD;" +/-";INT(SAN/2)
7230 GOTO 7280
7240 PRINT "CORRIDOR DIRECTION (deg) =";PD;"  CORRIDOR WIDTH IS A CIRCLE"
7250 IF PYN=1 THEN 7270
7260 PRINT #3, "CORRIDOR DIRECTION (deg) =";PD;"  CORRIDOR WIDTH IS A CIRCLE": GOTO 7280
7270 LPRINT "CORRIDOR DIRECTION (deg) =";PD;"  CORRIDOR WIDTH IS A CIRCLE"
7280 RETURN
