      Function JFCTC(iflg)
CC
CC---------------------------------------------------------------------
CC--- Author organization- H. E. Cramer Co., Inc.                   ---
CC--- Subroutine code - JFCTC Version 01.2                          ---
CC--- Subroutine description - Determines what user wants to do     ---
CC---                          after typing CTRL C. when ifccok     ---
CC---                          equals 2.                            ---
CC---------------------------------------------------------------------
CC
CC     iflg  - area where CRTL C was activated.
CC             52 - in general processing.
CC             53 - in plotting to hard copy device loop.
CC
CC     returns - JFCTC - 0 - if no action is to be taken, prog.
CC                           continues.
CC                       1 - to stop process and quit or go to main
CC                           menu.
CC
CC*********************************************************************
CC
      integer*2 icol,irow,ibak,ifor,icha,nmoff,jcha,kcha
CC
      include 'OCNTRL.INC'
      include 'ONAMES.INC'
      include 'OWNTRL.INC'
CC
CC
      data nmoff/3/
CC*********************************************************************
CC
      jcha = ICHAR('^')
      kcha = ICHAR('C')
      JFCTC = 0
      isv = ifbtch
      ifbtch = 0
      kflg = 0
      ibak = ibackd
      ifor = ifored
      isvx = irdcol
      isvy = irdrow
      do 20 j=1,80
        do 10 i=1,25
          irow = j - 1
          icol = i - 1
          call QCMOV(icol,irow)
          call QRTXT(icha,ibak,ifor)                                    031297
          if (icha .eq. jcha) then
            icol = icol + 1
            call QCMOV(icol,irow)
            call QRTXT(icha,ibak,ifor)
            if (icha .eq. kcha) then                                    031297
              kflg = 1
              icol = icol - 1
              go to 30
            end if
          end if
   10   continue
   20 continue
      irow = irowmx - isvy
      icol = isvx - 1
      call QCMOV(icol,irow)
      call QRTXT(icha,ibak,ifor)                                        031297
   30 if (iflg .eq. 52) then
CC        non-plotting.
        jflg = 1
      else
CC        plotting.
        jflg = -1
      end if
CC        processing.
      iferrs = KERRS(46*jflg,mnpbuf,idum,idum,dum,dum,dum,dum,0)
      if (iferrs .eq. 3) then
CC        yes replied to quit message.
        iferrs = 1
        JFCTC = 1
        isv = 0
      else
CC        no replied to quit message.
        iferrs = KERRS(iflg*jflg,mnpbuf,idum,idum,dum,dum,dum,dum,0)
        if (iferrs .eq. 4) then
CC          no replied to if continue message.
          ifnext = 3
          iferrs = 2
          JFCTC = 1
          isv = 0
        else
CC          yes replied to if continue message
          iferrs = 0
CC          blank out ^C generated by system.
          if (iflg .eq. 52) then
CC            non-plotting.
            if (ifctlc .ne. 3) then
              n = 2
            else
CC              message that processing continues.
              if (isv .eq. 0) then
                i = KERRS(35,mnpbuf,idum,idum,dum,dum,dum,dum,0)
              end if
            end if
          else
CC            plotting.
            n = 2
            if (kflg .eq. 0) then
              irow = 1
              if (ifprno .eq. 4) then
                icol = 21
              else
                icol = 20
                if (ifprno .lt. 0) n = 3
              end if
              ibak = iswplt(9)                                          031297
              ifor = iswplt(9)
            end if
          end if
          call MBLK1(mnpbuf,n)
          call IWRSC(icol,irow,n,mnpbuf,ibak,ifor)
        end if
      end if
CC      turn of interupt indicator.
      ifctlc = 0
      ifbtch = isv
CC      turn cursor off
      call CRTYP(nmoff)
      return
      end
