C***********************************************************************BLP00005
C                                                                       BLP00006
C                          BLP (DATED 99176)                            BLP00010
C                                                                       BLP00060
C             *** SEE BLP MODEL CHANGE BULLETIN MCB#3 ***               BLP00061
C                                                                       BLP00062
C    ON THE SUPPORT CENTER FOR REGULATORY AIR MODELS BULLETIN BOARD     BLP00063
C                                                                       BLP00064
C                             919-541-5742                              BLP00065
C                                                                       BLP00066
C***********************************************************************BLP00070
C                                                                       BLP00080
C      BLP -- MULTIPLE BUOYANT LINE AND POINT SOURCE                    BLP00090
C      DISPERSION MODEL                                                 BLP00100
C                                                                       BLP00110
C                                                                       BLP00120
C                                                                       BLP00130
C      DEVELOPED BY:                                                    BLP00140
C                                                                       BLP00150
C      JOE SCIRE AND LLOYD SCHULMAN                                     BLP00160
C      ENVIRONMENTAL RESEARCH AND TECHNOLOGY                            BLP00170
C      696 VIRGINIA ROAD                                                BLP00180
C      CONCORD, MASSACHUSETTS  01742                                    BLP00190
C                                                                       IBM
C                                                                       BLP00200
C***********************************************************************BLP00210
C
C      MODIFIED BY:
C
C      ROGER W. BRODE
C      PACIFIC ENVIRONMENTAL SERVICES, INC.
C      5001 S. MIAMI BLVD, SUITE 300
C      P.O. BOX 12077
C      RESEARCH TRIANGLE PARK, NC  27709
C
C      June 25, 1999
C
C      Modified to read meteorological data from an ASCII data file,
C      rather than an unformatted data file, using the default ASCII
C      format for ISCST3 generated by PCRAMMET and MPRM.  Also modified
C      to get filenames from the command line using the Lahey LF90
C      GETCL function (based on the ISCST3 model code), and to write
C      the model run date and time to the main output file.  Version
C      date used for output is now defined once in BLOCK DATA as
C      CHARACTER*5 VERSN.  Also modified for Y2K compliance using a
C      date window of 1950 to 2049.
C
C***********************************************************************
C                                                                       BLP00220
C                                                                       BLP00220
      CHARACTER*4 TITLE(20)                                             BLP00230
      REAL L,LEFF,LD,LELEV                                              BLP00240
      LOGICAL RINPUT,LSHEAR,RDOWNW,RUTMS                                BLP00250
      LOGICAL LMETIN,LMETOT,LTRANS                                      BLP00260
      LOGICAL RCOMPR                                                    BLP00270
      COMMON/SOURCE/NLINES,XLBEG(10),XLEND(10),DEL(10),YSCS(10),QT(10), BLP00280
     1 HS(10),XRCS(10,129),YRCS(10,129),TCOR,LELEV(10),                 BLP00290
     2 NPTS,XPSCS(50),YPSCS(50),PQ(50),PHS(50),XPRCS(50),YPRCS(50),     BLP00300
     3 TSTACK(50),APTS(50),BPTS(50),VEXIT(50),PELEV(50),IDOWNW(50)      BLP00310
      COMMON/RCEPT/RXBEG,RYBEG,RXEND,RYEND,RDX,RDY,XRSCS(100),          BLP00320
     1 YRSCS(100),XRRCS(100),YRRCS(100),RELEV(100),NREC                 BLP00330
      COMMON/PR/L,HB,WB,WM,FPRIME,FP,XMATCH,DX,AVFACT,TWOHB,N,LSHEAR,   BLP00340
     1 LTRANS                                                           BLP00350
      COMMON/PRLS/XFB,LEFF,LD,R0,XFINAL,XFS                             BLP00360
      COMMON/RINTP/XDIST(7),DH(7)                                       BLP00370
      COMMON/METD/ZMEAS,WS,WD,ISTAB,TDEGK,DPBL,THETA,S,P,IYR,JDAY,IHOUR BLP00380
      COMMON/METD24/KST(24),SPEED(24),RANDWD(24),HMIX(24),TEMP(24),     BLP00390
     1 DTHTA(2),PEXP(6),IDELS,IDSURF,IYSURF,IDUPER,IYUPER,TERAN(6),     BLP00400
     2 IRU,IHRMAX,LMETIN,LMETOT,IDAYS(366)                              BLP00410
      COMMON/PBLDAT/TWOPBL,PBL1P6                                       BLP00420
      COMMON/OUTPT/IPCL(11),IPCP(51)                                    BLP00430
      COMMON/PARM/CRIT,TER1,DECFAC,XBACKG,CONST2,CONST3,MAXIT           BLP00440
C     COMMON/QA/VERSON,LEVEL                                            BLP00450
      DATA PI/3.1415927/                                                BLP00460
CPES  Begin PES Code Changes

C     Declare ILEN_FLD Parameter, which controls length of filenames.
C     Also declare variables for input and output filenames, version date
C     and model run time and date.
      INTEGER, PARAMETER :: ILEN_FLD = 80
      CHARACTER (LEN=ILEN_FLD) :: INPFIL, OUTFIL, METFIL, CNCFIL
      COMMON/IOFILE/ INPFIL, OUTFIL, METFIL, CNCFIL
      CHARACTER RUNDAT*8, RUNTIM*8, VERSN*5
      COMMON/DATETIME/ RUNDAT, RUNTIM, VERSN

C     Get Date and Time using system-specific functions     ---   CALL DATIME
      CALL DATIME (RUNDAT, RUNTIM)

C     Retrieve Input and Output File Names From Command Line,
C                                                           ---   CALL GETCOM
      CALL GETCOM ('  BLP   ',ILEN_FLD,INPFIL,OUTFIL,CNCFIL,METFIL)

C     Open Input and Output Files                           ---   CALL FILOPN
      CALL FILOPN (ILEN_FLD,INPFIL,OUTFIL,CNCFIL,METFIL)

      WRITE (6,1234) VERSN, RUNDAT, RUNTIM
 1234 FORMAT ('1',21X,'BLP              (DATED ',A5,')',71X,A8/123X,A8/)

CPES  End PES Code Changes
C                                                                       BLP00580
C     READ INPUTS                                                       BLP00590
C                                                                       BLP00600
      CALL INPUT(RINPUT,RDOWNW,TITLE,RUTMS,RCOMPR)                      BLP00610
      IF(.NOT.RINPUT)CALL RECEPT(RUTMS)                                 BLP00620
C                                                                       BLP00630
C     WRITE RUN INFORMATION TO RECORD #1 OF OUTPUT FILE (20)            BLP00640
C                                                                       BLP00650
      CALL OUTITL(TITLE,NREC,NPTS,NLINES,IPCL,IPCP,IYR,IDAYS,RCOMPR)    BLP00660
      IF(NLINES.LT.1)GO TO 21                                           BLP00670
      DO 20 I=1,NLINES                                                  BLP00680
20    DEL(I)=XLEND(I)-XLBEG(I)                                          BLP00690
21    CONTINUE                                                          BLP00700
      IF(NPTS.LE.0)GO TO 520                                            BLP00710
C                                                                       BLP00720
C     IF THE POINT SOURCE DOWNWASH OPTION IS REQUESTED,                 BLP00730
C     DEFINE THE RECTANGLE OF INFLUENCE (IN SCS COORDINATES)            BLP00740
C     FOR THE DOWNWASH CALCULATIONS                                     BLP00750
C                                                                       BLP00760
      IF(.NOT.RDOWNW)GO TO 520                                          BLP00770
      THREHB=3.*HB                                                      BLP00780
      TWOHB=2.*HB                                                       BLP00790
      HALFWB=WB/2.                                                      BLP00800
      XAMIN=-TWOHB                                                      BLP00810
      XAMAX=L+TWOHB                                                     BLP00820
      YAMIN=-HALFWB-TWOHB                                               BLP00830
      YAMAX=(NLINES-1)*(DX+WB)+HALFWB+TWOHB                             BLP00840
C     FOR THOSE POINTS WITHIN THE REGION OF BUILDING DOWNWASH           BLP00850
C     EFFECTS AND WITH STACK HEIGHTS < 3*HB, SET                        BLP00860
C     IDOWNW (POINT #) = 1                                              BLP00870
      DO 505 I=1,NPTS                                                   BLP00880
      IF(PHS(I).GE.THREHB)GO TO 505                                     BLP00890
      IF(XPSCS(I).LT.XAMIN.OR.XPSCS(I).GT.XAMAX)GO TO 505               BLP00900
      IF(YPSCS(I).LT.YAMIN.OR.YPSCS(I).GT.YAMAX)GO TO 505               BLP00910
      IDOWNW(I)=1                                                       BLP00920
505   CONTINUE                                                          BLP00930
520   CONTINUE                                                          BLP00940
      IF(LMETIN)GO TO 1212                                              BLP00950
C     READ STATION CODES AND YEAR OF METEOROLOGICAL DATA                BLP00960
CPES  Begin PES Code Changes

      READ(2,*)IDS,IYS,IDU,IYU

CPES  End PES Code Changes
      IF(IDS.EQ.IDSURF.AND.IYS.EQ.IYSURF.AND.IDU.EQ.IDUPER.AND.         BLP00980
     1 IYU.EQ.IYUPER)GO TO 1212                                         BLP00990
      WRITE(6,1211)IDSURF,IYSURF,IDS,IYS,IDUPER,IYUPER,IDU,IYU          BLP01000
1211  FORMAT('1','REQUESTED STATION ID OR YEAR DOES NOT MATCH ',        BLP01010
     1 'THAT READ FROM THE MET. DATA FILE -- RUN TERMINATED'/           BLP01020
     2 '0',2X,'REQUESTED SURFACE DATA: ID = ',I5,3X,'YEAR = ',I4/       BLP01030
     3 10X,'MET. DATA READS: ID = ',I5,3X,'YEAR = ',I4/                 BLP01040
     4 '0','REQUESTED UPPER AIR DATA: ID = ',I5,3X,'YEAR = ',I4/        BLP01050
     5 10X,'MET. DATA FILE READS: ID = ',I5,3X,'YEAR = ',I4)            BLP01060
C     CALL WAUDIT
      STOP                                                              BLP01070
1212  CONTINUE                                                          BLP01080
C     CALCULATE DISTANCE (FROM XFB) TO FINAL NEUTRAL PLUME RISE         BLP01090
C     ASSUMING PLUMES INTERACT BEFORE REACHING TERMINAL RISE            BLP01100
      FBRG=N*FPRIME/PI                                                  BLP01110
      IF(FBRG.GT.55.)GO TO 10                                           BLP01120
C     THE CONSTANT 49 = 3.5*14.                                         BLP01130
      XFINAL=49.*FBRG**0.625                                            BLP01140
      GO TO 15                                                          BLP01150
10    XFINAL=3.5*CONST3*FBRG**0.4                                       BLP01160
15    CONTINUE                                                          BLP01170
      XMATCH=XFINAL                                                     BLP01180
C                                                                       BLP01190
C     ENTER MAIN LOOP                                                   BLP01200
C                                                                       BLP01210
      ISTART=1                                                          BLP01220
      DO 135 I=1,366                                                    BLP01230
      II=367-I                                                          BLP01240
      IF(IDAYS(II).NE.1)GO TO 135                                       BLP01250
      LASTDY=II                                                         BLP01260
      GO TO 137                                                         BLP01270
135   CONTINUE                                                          BLP01280
      WRITE(6,136)                                                      BLP01290
136   FORMAT(///'0','EXECUTION TERMINATING -- NO ELEMENTS OF ',         BLP01300
     1 'IDAYS ARRAY ARE EQUAL TO ONE')                                  BLP01310
C     CALL WAUDIT
      STOP                                                              BLP01320
137   CONTINUE                                                          BLP01330
      IF(LMETIN)LASTDY=1                                                BLP01340
      WRITE(6,1401)                                                     BLP01350
1401  FORMAT('1')                                                       BLP01360
      DO 1002 IDAY=ISTART,LASTDY                                        BLP01370
CPES  Begin PES Code Changes

C     READ METEOROLOGICAL DATA AND RETURN JULIAN DAY (JDAY) FROM DATA FILE

      CALL MET(JDAY)

C     Check for Proper Date Sequence
      IF (IDAY .NE. JDAY) THEN
         WRITE(*,*) 'MET DATA SEQUENCE ERROR AT JDAY = ',JDAY
         WRITE(6,*) 'MET DATA SEQUENCE ERROR AT JDAY = ',JDAY
         STOP
      END IF

CPES  End PES Code Changes
      IF(IDAYS(IDAY).NE.1)GO TO 1002                                    BLP01410
C                                                                       BLP01420
      DO 1000 IHR=1,IHRMAX                                              BLP01430
C                                                                       BLP01440
      IHOUR=IHR                                                         BLP01450
      ISTAB=KST(IHR)                                                    BLP01460
      TER1=1.-TERAN(ISTAB)                                              BLP01470
      P=PEXP(ISTAB)                                                     BLP01480
      TDEGK=TEMP(IHR)                                                   BLP01490
      IF(ISTAB.GT.4)S=9.80616*DTHTA(ISTAB-4)/TDEGK                      BLP01500
      WS=SPEED(IHR)                                                     BLP01510
      WD=RANDWD(IHR)                                                    BLP01520
C     CONVERT WD (FROM PREPROCESSOR) TO WD IN THE REGULAR               BLP01530
C     METEOROLOGICAL SENSE (I.E., 0=NORTH WIND,90=EAST WIND,            BLP01540
C     180=SOUTH WIND,270=WEST WIND)                                     BLP01550
      WD1=WD+180.                                                       BLP01560
      WD1=AMOD(WD1,360.)                                                BLP01570
      THETA=360.-(WD1+TCOR)                                             BLP01580
      IF(THETA.LT.0.0)THETA=360.+THETA                                  BLP01590
      THETA=AMOD(THETA,360.)                                            BLP01600
      DPBL=HMIX(IHR)                                                    BLP01610
      TWOPBL=2.*DPBL                                                    BLP01620
      PBL1P6=1.6*DPBL                                                   BLP01630
      CALL COORD(THETA)                                                 BLP01640
      CALL CONTRB(RCOMPR)                                               BLP01650
1000  CONTINUE                                                          BLP01660
1002  CONTINUE                                                          BLP01670
      WRITE(6,1005)JDAY                                                 BLP01680
1005  FORMAT(/////'0',30X,'LAST DAY PROCESSED = ',I3)                   BLP01690
C     CALL WAUDIT
      STOP                                                              BLP01700
      END                                                               BLP01710
CPES  Begin PES Code Changes

      SUBROUTINE GETCOM (MODEL,LENGTH,INPFIL,OUTFIL,CNCFIL,METFIL)
C***********************************************************************
C     
C        ADAPTED FROM PCCODE Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Controls Retrieving Input and Output File Names From
C                 the Command Line for PCs
C
C        PROGRAMMER: Roger Brode
C        
C        DATE:    March 2, 1992
C
C        MODIFIED:   To use ILEN_FLD (passed in as LENGTH) to define
C                    the length of the INPFIL and OUTFIL variables,
C                    and to specify length of the command line as
C                    a PARAMETER, initially set to 150.  Also set up
C                    conditional compilation statements (commented out)
C                    to facilitate compilation by DEC Visual Fortran.
C                    R.W. Brode, PES, Inc. - 12/2/98
C
C        MODIFIED:   Jayant Hardikar, PES, Inc.
C                    - Length of command line for Lahey version changed
C                      from 80 to 120 characters - 4/19/93
C                    - Adapted for DEPMET/PMERGE - 7/29/94
C
C        INPUTS:  Command Line
C
C        OUTPUTS: Input Runstream File Name
C                 Output Print File Name
C
C        CALLED FROM:   MAIN
C***********************************************************************
C
C     Variable Declarations
      IMPLICIT NONE

      INTEGER LENGTH
      CHARACTER (LEN=LENGTH) :: INPFIL, OUTFIL, CNCFIL, METFIL
      CHARACTER (LEN=8)      :: MODEL
C     Declare the COMLIN Variable to Hold Contents of Command Line for Lahey
      INTEGER , PARAMETER :: LENCL = 150
      CHARACTER (LEN=LENCL) :: COMLIN
      INTEGER LOCB(LENCL), LOCE(LENCL), I, IFCNT
      LOGICAL INFLD

      COMLIN = ' '
      METFIL = ' '

C************************************************************LAHEY START
C     Use Lahey Function GETCL To Retrieve Contents of Command Line.
C     Retrieve Input and Output File Names From the COMLIN Variable.
      CALL GETCL(COMLIN)
      INFLD = .FALSE.
      IFCNT = 0
      DO I = 1, LENCL
         IF (.NOT.INFLD .AND. COMLIN(I:I) .NE. ' ') THEN
            INFLD = .TRUE.
            IFCNT = IFCNT + 1
            LOCB(IFCNT) = I
         ELSE IF (INFLD .AND. COMLIN(I:I) .EQ. ' ') THEN
            INFLD = .FALSE.
            LOCE(IFCNT) = I - 1
         END IF
      END DO
      IF (IFCNT .LT. 3 .OR. IFCNT .GT. 4) THEN
C        Error on Command Line.  Write Error Message and STOP
         WRITE(*,660) MODEL
         STOP
      END IF
      INPFIL = COMLIN(LOCB(1):LOCE(1))
      OUTFIL = COMLIN(LOCB(2):LOCE(2))
      CNCFIL = COMLIN(LOCB(3):LOCE(3))
C     Check for Optional Argument for Preprocessed Met Data File
      IF (IFCNT .EQ. 4) THEN
         METFIL = COMLIN(LOCB(4):LOCE(4))
      END IF

C************************************************************LAHEY STOP

  660 FORMAT (' COMMAND LINE ERROR: ',A8,' input_file output_file',
     &        ' concen_file [metdata_file]')

      RETURN
      END


      SUBROUTINE DATIME ( DCALL, TCALL )
C***********************************************************************
C                 DATIME Module
C
C        PURPOSE: Obtain the system date and time
C
C        PROGRAMMER: Jim Paumier, PES, Inc.
C
C        DATE:    April 15, 1994
C
C        MODIFIED:   Uses Fortran 90 DATE_AND_TIME routine.
C                    R.W. Brode, PES, 8/14/98
C
C        INPUTS:  none
C
C        OUTPUTS: Date and time in character format
C
C        CALLED FROM:  RUNTIME
C***********************************************************************
C
C     Variable Declarations
      IMPLICIT NONE

      CHARACTER DCALL*8, TCALL*8
      CHARACTER CDATE*8, CTIME*10, CZONE*5
      INTEGER  :: IDATETIME(8)
      INTEGER  :: IPTYR, IPTMON, IPTDAY, IPTHR, IPTMIN, IPTSEC

      DCALL = ' '
      TCALL = ' '

C     Call date and time routine
      CALL DATE_AND_TIME (CDATE, CTIME, CZONE, IDATETIME)

C     Convert year to two digits and store array variables
      IPTYR  = IDATETIME(1) - 100 * INT(IDATETIME(1)/100)
      IPTMON = IDATETIME(2)
      IPTDAY = IDATETIME(3)
      IPTHR  = IDATETIME(5)
      IPTMIN = IDATETIME(6)
      IPTSEC = IDATETIME(7)

C     Write Date and Time to Character Variables, DCALL & TCALL
      WRITE(DCALL, '(2(I2.2,"/"),I2.2)' ) IPTMON, IPTDAY, IPTYR
      WRITE(TCALL, '(2(I2.2,":"),I2.2)' ) IPTHR, IPTMIN, IPTSEC

      RETURN
      END

      SUBROUTINE FILOPN (LENGTH,INPFIL,OUTFIL,CNCFIL,METFIL)
C***********************************************************************
C                 FILOPN Module
C
C        PURPOSE: Opens Input and Output Files
C
C        PROGRAMMER: Roger Brode, PES, Inc.
C
C        DATE:    December 6, 1994
C
C        INPUTS:  Input filename, INPFIL
C                 Output filename, OUTFIL
C                 Concentration filename, CNCFIL
C                 Met Data filename, METFIL
C
C        OUTPUTS: Openned files
C
C        CALLED FROM:  MAIN
C
C        ERROR HANDLING:   Checks errors opening files
C***********************************************************************
C
C     Variable Declarations
      IMPLICIT NONE

      INTEGER LENGTH
      CHARACTER (LEN=LENGTH) :: INPFIL, OUTFIL, CNCFIL, METFIL
      CHARACTER DUMMY*8

      SAVE

C     OPEN Input Runstream File, Unit = 5
      DUMMY = 'RUN-STRM'
      OPEN (UNIT=5,FILE=INPFIL,ERR=99,STATUS='OLD')

C     OPEN Print Output File, Unit = 6
      DUMMY = 'OUTPUT'
CLF90 The CARRIAGECONTROL specifier in the following statement is a
CLF90 non-standard Lahey language extension (also supported by DEC VF),
CLF90 and may need to be removed for portability of the code.
      OPEN (UNIT=6,FILE=OUTFIL,CARRIAGECONTROL='FORTRAN',
     &      ERR=99,STATUS='UNKNOWN')

C     OPEN Output Concentration Data File, Unit = 20
      DUMMY = 'CONCDATA'
      OPEN (UNIT=20,FILE=CNCFIL,FORM='UNFORMATTED',ERR=99,
     &      STATUS='UNKNOWN')

      IF (METFIL .NE. ' ') THEN
C        OPEN Meteorological Data File, Unit = 2
         DUMMY = 'METDATA'
         OPEN (UNIT=2,FILE=METFIL,ERR=99,STATUS='OLD')
      END IF

      GO TO 1000

C     WRITE Error Message:  Error Opening File
 99   WRITE(*,*) 'Error Opening File: ', DUMMY
      STOP

 1000 CONTINUE

      RETURN
      END

CPES  End PES Code Changes
C
      SUBROUTINE INPUT(RINPUT,RDOWNW,TITLE,RUTMS,RCOMPR)                BLP01720
C                                                                       BLP01730
C                                                                       BLP01740
      REAL*8 RXBEG,RYBEG,RXEND,RYEND,XBASE,YBASE,XCOORD,YCOORD          BLP01750
      REAL*8 XLBEG,XLEND,YLBEG,YLEND                                    BLP01760
      REAL*8 ANGRD,SINT,COST,XB1,XE1,YB1,YE1,EX,EY                      BLP01770
      REAL*8 YLBS,YLES                                                  BLP01780
      REAL YLBEG1(10),YLEND1(10)                                        BLP01790
      REAL L,LELEV                                                      BLP01800
      REAL DIAM(50)                                                     BLP01810
      LOGICAL RINPUT,LINPUT,LUTMS,LPART,LSHEAR,RDOWNW,LDOWNW,LFALSE     BLP01820
      LOGICAL LMETOT,LMETIN,LTRANS,RUTMS                                BLP01830
      LOGICAL LCOMPR,RCOMPR                                             BLP01840
      CHARACTER*4 TITLE(20)
      CHARACTER*4 ALPYES,ALP1,ALP2,ALP3,ALP4,ALP5,ALP6
C                                                                       BLP01850
C     COMMON BLOCKS                                                     BLP01860
C                                                                       BLP01870
      COMMON/SOURCE/NLINES,XLBEG1(10),XLEND1(10),DEL(10),YSCS(10),      BLP01880
     1 QT(10),HS(10),XRCS(10,129),YRCS(10,129),TCOR,LELEV(10),          BLP01890
     2 NPTS,XPSCS(50),YPSCS(50),PQ(50),PHS(50),XPRCS(50),YPRCS(50),     BLP01900
     3 TSTACK(50),APTS(50),BPTS(50),VEXIT(50),PELEV(50),IDOWNW(50)      BLP01910
      COMMON/RCEPT/RXBEG1,RYBEG1,RXEND1,RYEND1,RDX,RDY,XRSCS(100),      BLP01920
     1 YRSCS(100),XRRCS(100),YRRCS(100),RELEV(100),NREC                 BLP01930
      COMMON/PR/L,HB,WB,WM,FPRIME,FP,XMATCH,DX,AVFACT,TWOHB,N,LSHEAR,   BLP01940
     1 LTRANS                                                           BLP01950
      COMMON/OUTPT/IPCL(11),IPCP(51)                                    BLP01960
      COMMON/PARM/CRIT,TER1,DECFAC,XBACKG,CONST2,CONST3,MAXIT           BLP01970
      COMMON/METD24/KST(24),SPEED(24),RANDWD(24),HMIX(24),TEMP(24),     BLP01980
     1 DTHTA(2),PEXP(6),IDELS,IDSURF,IYSURF,IDUPER,IYUPER,TERAN(6),     BLP01990
     2 IRU,IHRMAX,LMETIN,LMETOT,IDAYS(366)                              BLP02000
      COMMON/METD/ZMEAS,WS,WD,ISTAB,TDEGK,DPBL,THETA,S,P,IYR,JDAY,IHOUR BLP02010
C     COMMON/QA/VERSON,LEVEL                                            BLP02020
CPES  Begin PES Code Changes

      CHARACTER RUNDAT*8, RUNTIM*8, VERSN*5
      COMMON/DATETIME/ RUNDAT, RUNTIM, VERSN

CPES  End PES Code Changes
C                                                                       BLP02030
C     NAMELIST STATEMENTS                                               BLP02040
C                                                                       BLP02050
      NAMELIST/GEN/NLINES,NPTS,NREC,LINPUT,LUTMS,LPART,LDOWNW,LSHEAR,   BLP02060
     1 LTRANS,TCOR,LCOMPR                                               BLP02070
      NAMELIST/RISE/L,HB,WB,WM,FPRIME,DX                                BLP02080
      NAMELIST/METIN/ZMEAS,DTHTA,PEXP,IDSURF,IYSURF,IDUPER,IYUPER,      BLP02090
     1 IDELS,IRU,IDAYS,LMETIN,LMETOT                                    BLP02100
      NAMELIST/CALC/CRIT,TERAN,DECFAC,XBACKG,CONST2,CONST3,MAXIT        BLP02110
      NAMELIST/OUTPUT/IPCL,IPCP                                         BLP02120
      NAMELIST/RCEPT/RXBEG,RYBEG,RXEND,RYEND,RDX,RDY                    BLP02130
C                                                                       BLP02140
      DATA LINPUT/.FALSE./,LUTMS/.FALSE./,LPART/.FALSE./                BLP02150
      DATA LDOWNW/.TRUE./,LFALSE/.FALSE./,LCOMPR/.FALSE./               BLP02160
      DATA ALPYES/'YES'/,ALP1/'NO'/                                     BLP02170
      DATA ALP2/'NO'/,ALP3/'NO'/,ALP4/'NO'/,ALP5/'NO'/,ALP6/'NO'/       BLP02180
      DATA RAD/0.017453293/                                             BLP02190
      DATA MAXL/10/,MAXP/50/,MAXR/100/                                  BLP02200
      DATA TEN6/1.E6/                                                   BLP02210
C                                                                       BLP02220
C     READ TITLE CARD                                                   BLP02230
C                                                                       BLP02240
      READ(5,7)TITLE                                                    BLP02250
7     FORMAT(20A4)                                                      BLP02260
CPES  Begin PES Code Changes

      WRITE(6,1400) VERSN, RUNDAT, RUNTIM
1400  FORMAT('1',11X,'BLP -- MULTIPLE BUOYANT LINE AND POINT ',
     1'SOURCE DISPERSION MODEL     SCRAM VERSION (DATED ',A5,')',17X,A8,
     2/,123X,A8 / ' ',13('**********'))

CPES  End PES Code Changes
      WRITE(6,8)TITLE                                                   BLP02310
8     FORMAT(/'0',20A4)                                                 BLP02320
C                                                                       BLP02330
C     READ NUMBER OF SOURCES AND FORMAT OF INPUTS (GEN NAMELIST)        BLP02340
C                                                                       BLP02350
      READ(5,GEN)                                                       BLP02360
      WRITE(6,GEN)                                                      BLP02370
      N=NLINES                                                          BLP02380
      RINPUT=LINPUT                                                     BLP02390
      RUTMS=LUTMS                                                       BLP02400
      RCOMPR=LCOMPR                                                     BLP02410
      IF(NLINES.LE.0)LDOWNW=LFALSE                                      BLP02420
      RDOWNW=LDOWNW                                                     BLP02430
      IF(NLINES.GT.MAXL)GO TO 700                                       BLP02440
      IF(NPTS.GT.MAXP)GO TO 702                                         BLP02450
      IF(NREC.GT.MAXR)GO TO 704                                         BLP02460
C                                                                       BLP02470
C     READ PARAMETERS USED IN LINE SOURCE PLUME RISE                    BLP02480
C     CALCULATIONS (RISE NAMELIST)                                      BLP02490
C                                                                       BLP02500
      IF(NLINES.LT.1)GO TO 49                                           BLP02510
      READ(5,RISE)                                                      BLP02520
      WRITE(6,RISE)                                                     BLP02530
C                                                                       BLP02540
C     READ RECEPTOR INFORMATION (RCEPT NAMELIST)                        BLP02550
C                                                                       BLP02560
C     IF LINPUT (RINPUT) = .TRUE., INPUT COORDINATES OF EACH RECEPTOR   BLP02570
C     OTHERWISE, INPUT RECEPTOR GRID BOUDARIES AND SPACING AND A        BLP02580
C     RECTANGULAR RECEPTOR GRID WILL BE GENERATED (UP TO 100 RECEPTORS) BLP02590
49    CONTINUE                                                          BLP02600
      IF(RINPUT)GO TO 25                                                BLP02610
      READ(5,RCEPT)                                                     BLP02620
      WRITE(6,RCEPT)                                                    BLP02630
      XBASE=0.0                                                         BLP02640
      YBASE=0.0                                                         BLP02650
      IF(.NOT.LUTMS)GO TO 61                                            BLP02660
      XBASE=RXBEG                                                       BLP02670
      YBASE=RYBEG                                                       BLP02680
61    CONTINUE                                                          BLP02690
      RXBEG1=RXBEG-XBASE                                                BLP02700
      RYBEG1=RYBEG-YBASE                                                BLP02710
      RXEND1=RXEND-XBASE                                                BLP02720
      RYEND1=RYEND-YBASE                                                BLP02730
25    CONTINUE                                                          BLP02740
C                                                                       BLP02750
C     READ MET. DATA PARAMETERS (METIN NAMELIST)                        BLP02760
C                                                                       BLP02770
      READ(5,METIN)                                                     BLP02780
      WRITE(6,METIN)                                                    BLP02790
      IF(IYSURF.EQ.IYUPER)GO TO 55                                      BLP02800
      WRITE(6,56)IYSURF,IYUPER                                          BLP02810
56    FORMAT('1','RUN TERMINATED -- YEAR REQUESTED FOR SURFACE AND ',   BLP02820
     1 'UPPER AIR MET. DATA DO NOT MATCH'/'0','IYSURF = ',I4,           BLP02830
     2 5X,'IYUPER = ',I4)                                               BLP02840
C     CALL WAUDIT
      STOP                                                              BLP02850
55    CONTINUE                                                          BLP02860
      IYR=IYSURF                                                        BLP02870
      IF(LMETIN)IDAYS(1)=1                                              BLP02880
      IF(MOD(IYSURF,4).NE.0)IDAYS(366)=0                                BLP02890
C                                                                       BLP02900
C     READ DECAY RATE, TERRAIN CORRECTION FACTOR, CONVERGENCE           BLP02910
C     CRITERION, ITERATION LIMIT (CALC NAMELIST)                        BLP02920
C                                                                       BLP02930
      READ(5,CALC)                                                      BLP02940
      WRITE(6,CALC)                                                     BLP02950
C                                                                       BLP02960
C     READ WHICH SOURCES (IF ANY) TO HAVE PARTIAL                       BLP02970
C     CONCENTRATION OUTPUT (OUTPUT NAMELIST)                            BLP02980
C                                                                       BLP02990
      IF(.NOT.LPART)GO TO 118                                           BLP03000
      READ(5,OUTPUT)                                                    BLP03010
      WRITE(6,OUTPUT)                                                   BLP03020
118   CONTINUE                                                          BLP03030
C                                                                       BLP03040
C     READ COORDINATES OF USER SPECIFIED RECEPTORS                      BLP03050
C                                                                       BLP03060
      IF(.NOT.RINPUT)GO TO 40                                           BLP03070
      IF(LUTMS)GO TO 36                                                 BLP03080
C     READ RECEPTOR COORDINATES IN SCS UNITS                            BLP03090
      DO 27 I=1,NREC                                                    BLP03100
27    READ(5,28)XRSCS(I),YRSCS(I),RELEV(I)                              BLP03110
28    FORMAT(3F10.1)                                                    BLP03120
      XBASE=0.0                                                         BLP03130
      YBASE=0.0                                                         BLP03140
      GO TO 40                                                          BLP03150
C     READ RECEPTOR COORDINATES IN UTM UNITS                            BLP03160
36    READ(5,28)XBASE,YBASE,RELEV(1)                                    BLP03170
      XRSCS(1)=0.0                                                      BLP03180
      YRSCS(1)=0.0                                                      BLP03190
      IF(NREC.LE.1)GO TO 40                                             BLP03200
      DO 37 I=2,NREC                                                    BLP03210
      READ(5,28)XCOORD,YCOORD,RELEV(I)                                  BLP03220
      XRSCS(I)=XCOORD-XBASE                                             BLP03230
      YRSCS(I)=YCOORD-YBASE                                             BLP03240
37    CONTINUE                                                          BLP03250
40    CONTINUE                                                          BLP03260
C                                                                       BLP03270
C     READ LINE SOURCE PARAMETERS USED IN DISPERSION CALCULATIONS       BLP03280
C                                                                       BLP03290
      IF(NLINES.LT.1)GO TO 59                                           BLP03300
      DO 46 I=1,NLINES                                                  BLP03310
      READ(5,48)XLBEG,YLBEG,XLEND,YLEND,HS(I),QT(I),LELEV(I)            BLP03320
48    FORMAT(4F10.1,2F10.4,F10.1)                                       BLP03330
C     NEGATIVE EMISSIONS CANNOT BE USED WHEN ARRAY COMPRESSION          BLP03340
C     OPTION IS USED                                                    BLP03350
      IF(.NOT.RCOMPR.OR.QT(I).GE.0.0)GO TO 936                          BLP03360
      WRITE(6,934)I,QT(I)                                               BLP03370
934   FORMAT(//'0','EXECUTION TERMINATING -- NEGATIVE EMISSIONS ',      BLP03380
     1 'CANNOT BE USED WHEN ARRAY COMPRESSION OPTION (LCOMPR) IS ',     BLP03390
     2 'USED'/'0','LINE SOURCE: ',I2,3X,'EMISSION RATE = ',F12.2)       BLP03400
C     CALL WAUDIT
      STOP                                                              BLP03410
936   CONTINUE                                                          BLP03420
C     CHANGE EMISSION RATE TO MICROGRAMS/SECOND                         BLP03430
      QT(I)=QT(I)*TEN6                                                  BLP03440
      IF(XLBEG.GT.XLEND)GO TO 706                                       BLP03450
C     VERIFY LINE SOURCE COORDINATES ARE                                BLP03460
C     INPUT CORRECTLY - SCS COORDINATE SYSTEM                           BLP03470
      IF(LUTMS)GO TO 946                                                BLP03480
      IF(I.NE.1)GO TO 940                                               BLP03490
      YLBS=YLBEG                                                        BLP03500
      YLES=YLEND                                                        BLP03510
C     SCS COORDINATES OF BEGINNING OF FIRST LINE SOURCE                 BLP03520
C     SHOULD BE (0.0,0.0)                                               BLP03530
      IF(XLBEG.EQ.0.0.AND.YLBEG.EQ.0.0)GO TO 940                        BLP03540
      WRITE(6,708)XLBEG,YLBEG                                           BLP03550
708   FORMAT('1','THE ORIGIN OF THE SCS COORDINATE SYSTEM MUST BE ',    BLP03560
     1 'LOCATED AT THE BEGINNING OF '/3X,'LINE SOURCE NO. 1 -- I.E.,',  BLP03570
     2 '(XLBEG,YLBEG) FOR LINE NO. 1 MUST BE (0.0,0.0)'/'0','VALUES ',  BLP03580
     3 'OF (XLBEG,YLBEG) INPUT BY USER ARE (',F10.1,',',F10.1,')')      BLP03590
C     CALL WAUDIT
      STOP                                                              BLP03600
940   CONTINUE                                                          BLP03610
C     X-AXIS IN THE SCS COORDINATE SYSTEM MUST BE PARALLEL TO           BLP03620
C     THE LINE SOURCES                                                  BLP03630
      IF(YLBEG.EQ.YLEND)GO TO 941                                       BLP03640
      WRITE(6,709)I,YLBEG,YLEND                                         BLP03650
709   FORMAT('1','IN SCS COORDINATE SYSTEM, THE X-AXIS IS ALIGNED ',    BLP03660
     1 'PARALLEL TO THE LINE SOURCES -- I.E., THE Y COORDINATES '/3X,   BLP03670
     2 'OF THE BEGINNING AND END OF EACH LINE SOURCE MUST BE THE SAME'/ BLP03680
     3 '0','VALUES INPUT BY THE USER FOR LINE ',I2,' ARE YLBEG = ',     BLP03690
     4 F10.1,3X,'YLEND = ',F10.1)                                       BLP03700
C     CALL WAUDIT
      STOP                                                              BLP03710
941   CONTINUE                                                          BLP03720
      IF(I.EQ.1)GO TO 946                                               BLP03730
      IF(YLBEG.GT.YLBS.AND.YLEND.GT.YLES)GO TO 942                      BLP03740
      IM1=I-1                                                           BLP03750
      WRITE(6,710)IM1,YLBS,YLES,I,YLBEG,YLEND                           BLP03760
710   FORMAT('1','IN SCS COORDINATE SYSTEM, LINE SOURCES MUST BE ',     BLP03770
     1 'INPUT IN ORDER OF INCREASING Y -- I.E., YLBEG (YLEND) OF LINE ',BLP03780
     2 'NO. N'/3X,'MUST BE GREATER THAN YLBEG (YLEND) OF LINE NO. (N-1)'BLP03790
     3 /'0','VALUES INPUT BY THE USER FOR LINE ',I2,' ARE YLBEG = ',    BLP03800
     4 F10.1,3X,'YLEND = ',F10.1/29X,'LINE ',I2,3X,'YLBEG = ',F10.1,3X, BLP03810
     5 'YLEND = ',F10.1)                                                BLP03820
C     CALL WAUDIT
      STOP                                                              BLP03830
942   CONTINUE                                                          BLP03840
      YLBS=YLBEG                                                        BLP03850
      YLES=YLEND                                                        BLP03860
946   CONTINUE                                                          BLP03870
      XLBEG1(I)=XLBEG-XBASE                                             BLP03880
      YLBEG1(I)=YLBEG-YBASE                                             BLP03890
      XLEND1(I)=XLEND-XBASE                                             BLP03900
      YLEND1(I)=YLEND-YBASE                                             BLP03910
      YSCS(I)=YLBEG1(I)                                                 BLP03920
46    CONTINUE                                                          BLP03930
59    CONTINUE                                                          BLP03940
C                                                                       BLP03950
C     READ POINT SOURCE INFORMATION                                     BLP03960
C                                                                       BLP03970
      IF(NPTS.LT.1)GO TO 22                                             BLP03980
      DO 15 I=1,NPTS                                                    BLP03990
      READ(5,14)XCOORD,YCOORD,PHS(I),PQ(I),D,W,TSTACK(I),PELEV(I)       BLP04000
14    FORMAT(2F10.1,5F10.4,F10.1)                                       BLP04010
C     NEGATIVE EMISSIONS CANNOT BE USED WHEN ARRAY COMPRESSION          BLP04020
C     OPTION IS USED                                                    BLP04030
      IF(.NOT.RCOMPR.OR.PQ(I).GE.0.0)GO TO 1936                         BLP04040
      WRITE(6,1934)I,PQ(I)                                              BLP04050
1934  FORMAT(//'0','EXECUTION TERMINATING -- NEGATIVE EMISSIONS ',      BLP04060
     1 'CANNOT BE USED WHEN ARRAY COMPRESSION OPTION (LCOMPR) IS ',     BLP04070
     2 'USED'/'0','POINT SOURCE: ',I2,3X,'EMISSION RATE = ',F12.2)      BLP04080
C     CALL WAUDIT
      STOP                                                              BLP04090
1936  CONTINUE                                                          BLP04100
C     CHANGE EMISSION RATE TO MICROGRAMS/SECOND                         BLP04110
      PQ(I)=PQ(I)*TEN6                                                  BLP04120
      XPSCS(I)=XCOORD-XBASE                                             BLP04130
      YPSCS(I)=YCOORD-YBASE                                             BLP04140
C     CONSTANT 2.45154 = G/4. (9.80616/4.)                              BLP04150
      APTS(I)=2.45154*D*D*W/TSTACK(I)                                   BLP04160
C     WHEN MULTIPLIED BY THE AMBIENT TEMPERATURE, BPTS GIVES 3. * FM    BLP04170
C     CONSTANT 0.75 = 3./(2.*2.)                                        BLP04180
      BPTS(I)=0.75*W*W*D*D/TSTACK(I)                                    BLP04190
      VEXIT(I)=W                                                        BLP04200
      DIAM(I)=D                                                         BLP04210
15    CONTINUE                                                          BLP04220
22    CONTINUE                                                          BLP04230
C                                                                       BLP04240
C     WRITE INPUT PARAMETERS                                            BLP04250
C                                                                       BLP04260
CPES  Begin PES Code Changes

      WRITE(6,1400) VERSN, RUNDAT, RUNTIM

CPES  End PES Code Changes
      WRITE(6,8)TITLE                                                   BLP04280
      NDYS=0                                                            BLP04290
      DO 135 I=1,366                                                    BLP04300
135   NDYS=NDYS+IDAYS(I)                                                BLP04310
      WRITE(6,136)NDYS,IDAYS                                            BLP04320
136   FORMAT(//'0','TOTAL NUMBER OF DAYS INCLUDED IN THIS RUN: ',I3//   BLP04330
     1 1X,'(0=NOT INCLUDED,1=INCLUDED)'//                               BLP04340
     2 3('0',10(10I1,3X)/),'0',6(10I1,3X),6I1)                          BLP04350
      NT=NPTS+NLINES                                                    BLP04360
      WRITE(6,112)NT,NLINES,NPTS                                        BLP04370
112   FORMAT(//'0','TOTAL NUMBER OF SOURCES: ',I3//12X,'LINE SOURCES: ',BLP04380
     1 I3/11X,'POINT SOURCES: ',I3)                                     BLP04390
      IF(LPART)ALP1=ALPYES                                              BLP04400
      WRITE(6,113)ALP1                                                  BLP04410
113   FORMAT(/'0','PARTIAL CONCENTRATIONS REQUESTED FOR ANY LINE OR ',  BLP04420
     1 'POINT SOURCES ? ',A3)                                           BLP04430
      IF(LDOWNW)ALP2=ALPYES                                             BLP04440
      WRITE(6,1110)ALP2                                                 BLP04450
1110  FORMAT('0','POINT SOURCE BUILDING DOWNWASH OPTION REQUESTED ? ',  BLP04460
     1 A3)                                                              BLP04470
      IF(LSHEAR)ALP3=ALPYES                                             BLP04480
      WRITE(6,1111)ALP3                                                 BLP04490
1111  FORMAT('0','VERTICAL WIND SHEAR (IN PLUME RISE) REQUESTED ? ',A3) BLP04500
      IF(LTRANS)ALP5=ALPYES                                             BLP04510
      WRITE(6,1212)ALP5                                                 BLP04520
1212  FORMAT('0','TRANSITIONAL POINT SOURCE PLUME RISE REQUESTED ? ',A3)BLP04530
      IF(LMETOT)ALP4=ALPYES                                             BLP04540
      WRITE(6,1112)ALP4                                                 BLP04550
1112  FORMAT('0','OUTPUT OF METEOROLOGICAL DATA REQUESTED ? ',A3)       BLP04560
      IF(RCOMPR)ALP6=ALPYES                                             BLP04570
      WRITE(6,1113)ALP6                                                 BLP04580
1113  FORMAT('0','OPTION TO COMPRESS OUTPUT CONCENTRATION ARRAYS ',     BLP04590
     1 'REQUESTED ? ',A3)                                               BLP04600
C                                                                       BLP04610
C     WRITE THE LINE SOURCE PLUME RISE PARAMETERS                       BLP04620
C                                                                       BLP04630
      IF(NLINES.LT.1)GO TO 122                                          BLP04640
      DXM=DX+WB                                                         BLP04650
      WRITE(6,50)HB,WB,L,DX,DXM,WM,FPRIME                               BLP04660
50    FORMAT(//'0','PARAMETERS USED IN THE LINE SOURCE PLUME RISE ',    BLP04670
     1 'CALCULATIONS'/                                                  BLP04680
     1 '0','BUILDING DIMENSIONS:  HEIGHT = ',F7.2,1X,'(M)'/             BLP04690
     2 24X,'WIDTH = ',F7.2,1X,'(M)'/                                    BLP04700
     3 23X,'LENGTH = ',F7.2,1X,'(M)'/                                   BLP04710
     4 '0',9X,'BUILDING SEPARATION = ',F7.2,1X,'(M)'/                   BLP04720
     5 '0',6X,'LINE SOURCE SEPARATION = ',F7.2,1X,'(M)'/                BLP04730
     6 '0',11X,'LINE SOURCE WIDTH = ',F7.2,1X,'(M)'/                    BLP04740
     7 '0','BUOYANCY FLUX PER LINE (FPRIME) = ',F7.1,1X,'(M**4/S**3)')  BLP04750
122   CONTINUE                                                          BLP04760
C                                                                       BLP04770
C     WRITE THE METEOROLOGICAL PARAMETERS                               BLP04780
C                                                                       BLP04790
CPES  Begin PES Code Changes

      WRITE(6,1400) VERSN, RUNDAT, RUNTIM

CPES  End PES Code Changes
      WRITE(6,1120)                                                     BLP04810
1120  FORMAT(/'0','METEOROLOGICAL PARAMETERS')                          BLP04820
      WRITE(6,1121)ZMEAS,PEXP,DTHTA                                     BLP04830
1121  FORMAT(/'0','MEAN WIND SPEED MEASUREMENT HEIGHT = ',F4.1,' (M)'/  BLP04840
     1 '0','WIND SPEED POWER LAW EXPONENTS (STABILITIES 1-6) =  ',      BLP04850
     2 6(F4.2,2X)/'0','VERTICAL POTENTIAL TEMPERATURE GRADIENT =  ',    BLP04860
     3 F5.3,1X,'DEG K/M  (STABILITY 5)',5X,F5.3,1X,'DEG K/M  ',         BLP04870
     4 '(STABILITY 6)')                                                 BLP04880
      IF(LMETIN)WRITE(6,1122)                                           BLP04890
1122  FORMAT('0','METEOROLOGICAL DATA -- FORMATTED USER INPUT')         BLP04900
      IF(.NOT.LMETIN)WRITE(6,1123)IDELS,IRU,IDSURF,IYSURF,IDUPER,IYUPER BLP04910
1123  FORMAT('0','METEOROLOGICAL DATA -- PREPROCESSOR FORMAT'/          BLP04920
     1 '0','STABILITY CLASS VARIATION RESTRICTED TO ',I1,' CLASSES/',   BLP04930
     2 'HOUR'/'0',1X,'MIXING HEIGHTS USED: ',I1,2X,'(1=RURAL,2=URBAN)'/ BLP04940
     3 '   SURFACE STATION ID: ',I5,5X,'YEAR: ',I2/                     BLP04950
     4 1X,'UPPER AIR STATION ID: ',I5,5X,'YEAR: ',I2)                   BLP04960
C                                                                       BLP04970
C     WRITE THE COMPUTATIONAL PARAMETERS                                BLP04980
C                                                                       BLP04990
      WRITE(6,1130)CRIT,MAXIT                                           BLP05000
1130  FORMAT(///'0','COMPUTATIONAL PARAMETERS'//'0','CONVERGENCE ',     BLP05010
     1 'THRESHOLD FOR LINE SOURCE CALCULATIONS = ',F6.3,1X,             BLP05020
     2 /                                                                BLP05030
     3 '0','MAXIMUM NUMBER OF ITERATIONS IN LINE SOURCE CALCULATIONS = 'BLP05040
     4,I2)                                                              BLP05050
      IF(.NOT.LSHEAR)WRITE(6,1131)CONST2                                BLP05060
1131  FORMAT('0','STABLE POINT SOURCE PLUME RISE CONSTANT (CONST2) = ', BLP05070
     1 F4.2)                                                            BLP05080
      WRITE(6,11131)CONST3                                              BLP05090
11131 FORMAT('0','FINAL NEUTRAL PLUME RISE CONSTANT (CONST3) = ',       BLP05100
     1 F5.2)                                                            BLP05110
      WRITE(6,1132)XBACKG,DECFAC,TERAN                                  BLP05120
1132  FORMAT('0','BACKGROUND CONCENTRATION = ',F8.2,1X,'(MICROGRAMS/',  BLP05130
     1 'M**3)'/'0','POLLUTANT DECAY FACTOR = ',E12.5,1X,' (1/SEC)'/     BLP05140
     2 '0','TERRAIN ADJUSTMENT FACTORS (STABILITIES 1-6) =  ',          BLP05150
     3 6(F4.2,2X))                                                      BLP05160
C                                                                       BLP05170
C     WRITE THE RECEPTOR INFORMATION                                    BLP05180
C                                                                       BLP05190
CPES  Begin PES Code Changes

      WRITE(6,1400) VERSN, RUNDAT, RUNTIM

CPES  End PES Code Changes
      IF(RINPUT)GO TO 85                                                BLP05210
      WRITE(6,114)                                                      BLP05220
114   FORMAT(/'0','RECEPTOR LOCATIONS GENERATED FROM USER DEFINED ',    BLP05230
     1 'RECEPTOR RECTANGLE')                                            BLP05240
      WRITE(6,70)RXBEG,RYEND,RXEND,RYEND,RXBEG,RYBEG,RXEND,RYBEG,RDX,RDYBLP05250
70    FORMAT(//'0',10X,'RECEPTOR NETWORK DEFINED BY THE FOLLOWING ',    BLP05260
     1 'RECTANGLE'/                                                     BLP05270
     2 '0',10X,'(',F10.1,',',F10.1,')',5X,'(',F10.1,',',F10.1,')'/      BLP05280
     3 '0',10X,'(',F10.1,',',F10.1,')',5X,'(',F10.1,',',F10.1,')'/      BLP05290
     4 '0',10X,'X GRID SPACING = ',F7.2/                                BLP05300
     5 '0',10X,'Y GRID SPACING = ',F7.2)                                BLP05310
      GO TO 99                                                          BLP05320
85    WRITE(6,115)NREC                                                  BLP05330
115   FORMAT(/'0','ALL RECEPTOR LOCATIONS SPECIFIED BY THE USER -- ',   BLP05340
     1 'TOTAL NUMBER OF RECEPTOR: ',I3)                                 BLP05350
      WRITE(6,89)NREC                                                   BLP05360
89    FORMAT(//'0',10X,'RECEPTOR NETWORK (USER INPUT)'/                 BLP05370
     1 '0','NUMBER OF RECEPTORS: ',I4///1X,'RECEPTOR NUMBER',10X,       BLP05380
     2 'X',14X,'Y',10X,'ELEVATION'/25X,'(M)',12X,'(M)',12X,'(M)'/)      BLP05390
      DO 92 I=1,NREC                                                    BLP05400
      XCOORD=XRSCS(I)+XBASE                                             BLP05410
      YCOORD=YRSCS(I)+YBASE                                             BLP05420
92    WRITE(6,93)I,XCOORD,YCOORD,RELEV(I)                               BLP05430
93    FORMAT(7X,I3,11X,F10.1,5X,F10.1,2X,F10.1)                         BLP05440
99    CONTINUE                                                          BLP05450
      IF(.NOT.LUTMS)WRITE(6,116)TCOR                                    BLP05460
116   FORMAT('0','SOURCE AND RECEPTOR LOCATIONS SPECIFIED IN SCS ',     BLP05470
     1 'COORDINATES -- TCOR = ',F6.2,' DEGREES')                        BLP05480
      IF(LUTMS)WRITE(6,117)                                             BLP05490
117   FORMAT('0','SOURCE AND RECEPTOR LOCATIONS SPECIFIED IN UTM ',     BLP05500
     1 'COORDINATES')                                                   BLP05510
C                                                                       BLP05520
C     WRITE THE LINE SOURCE  PARAMETERS                                 BLP05530
C                                                                       BLP05540
      IF(NLINES.LT.1)GO TO 1133                                         BLP05550
CPES  Begin PES Code Changes

      WRITE(6,1400) VERSN, RUNDAT, RUNTIM

CPES  End PES Code Changes
      WRITE(6,60)NLINES                                                 BLP05570
60    FORMAT(/'0','LINE SOURCE PARAMETERS'///'0','NUMBER OF LINES: ',I4 BLP05580
     1 //1X,'LINE NUMBER',4X,'X START',6X,'Y START',9X,'X END',9X,      BLP05590
     2 'Y END',11X,'Q',10X,'HEIGHT',5X,'ELEVATION'/                     BLP05600
     3 18X,'(M)',10X,'(M)',12X,'(M)',11X,'(M)',8X,'(GM/SEC)',9X,        BLP05610
     4 '(M)',9X,'(M)')                                                  BLP05620
      DO 65 I=1,NLINES                                                  BLP05630
      XLBEG=XLBEG1(I)+XBASE                                             BLP05640
      YLBEG=YLBEG1(I)+YBASE                                             BLP05650
      XLEND=XLEND1(I)+XBASE                                             BLP05660
      YLEND=YLEND1(I)+YBASE                                             BLP05670
      QGMS=QT(I)/TEN6                                                   BLP05680
65    WRITE(6,62)I,XLBEG,YLBEG,XLEND,YLEND,QGMS,HS(I),LELEV(I)          BLP05690
62    FORMAT(4X,I3,7X,4(F10.1,4X),2X,F7.2,6X,F7.2,1X,F10.1)             BLP05700
      WRITE(6,212)                                                      BLP05710
212   FORMAT(//'0','SOURCE CONTRIBUTIONS FROM THE FOLLOWING ',          BLP05720
     1 'LINE SOURCES ARE AVAILABLE: '/'0','(0=NOT AVAILABLE; ',         BLP05730
     2 '1=AVAILABLE)'/'0','LINE SOURCE NUMBER',5X,'AVAILABILITY')       BLP05740
      DO 219 I=1,NLINES                                                 BLP05750
      WRITE(6,215)I,IPCL(I)                                             BLP05760
215   FORMAT('0',7X,I2,19X,I1)                                          BLP05770
219   CONTINUE                                                          BLP05780
      WRITE(6,216)NLINES,IPCL(11)                                       BLP05790
216   FORMAT('0',5X,'1 - ',I2,17X,I1)                                   BLP05800
1133  CONTINUE                                                          BLP05810
C                                                                       BLP05820
C     WRITE THE POINT SOURCE PARAMETERS                                 BLP05830
C                                                                       BLP05840
      IF(NPTS.LT.1)GO TO 127                                            BLP05850
CPES  Begin PES Code Changes

      WRITE(6,1400) VERSN, RUNDAT, RUNTIM

CPES  End PES Code Changes
      WRITE(6,160)NPTS                                                  BLP05870
160   FORMAT(/'0','POINT SOURCE PARAMETERS'///'0','NUMBER OF POINTS: ', BLP05880
     1 I4//1X,'POINT NUMBER',8X,'X',14X,'Y',11X,'Q',10X,'HEIGHT',4X,    BLP05890
     2 'DIAM.',4X,'EXIT VEL.',4X,'STACK TEMP.',3X,'ELEVATION'/          BLP05900
     3 20X,'(M)',12X,'(M)',6X,'(GM/SEC)',9X,'(M)',6X,'(M)',7X,          BLP05910
     4 '(M/S)',8X,'(DEG K)',8X,'(M)')                                   BLP05920
      DO 132 I=1,NPTS                                                   BLP05930
      XCOORD=XPSCS(I)+XBASE                                             BLP05940
      YCOORD=YPSCS(I)+YBASE                                             BLP05950
      QGMS=PQ(I)/TEN6                                                   BLP05960
132   WRITE(6,133)I,XCOORD,YCOORD,QGMS,PHS(I),DIAM(I),VEXIT(I),         BLP05970
     1 TSTACK(I),PELEV(I)                                               BLP05980
133   FORMAT(5X,I3,8X,F10.1,5X,F10.1,4X,F7.2,6X,F7.2,2X,F7.2,4X,F7.2,   BLP05990
     1 8X,F6.1,2X,F10.1)                                                BLP06000
      WRITE(6,222)                                                      BLP06010
222   FORMAT(//'0','SOURCE CONTRIBUTIONS FROM THE FOLLOWING ',          BLP06020
     1 'POINT SOURCES ARE AVAILABLE: '/'0','(0=NOT AVAILABLE; ',        BLP06030
     2 '1=AVAILABLE)'/'0','POINT SOURCE NUMBER',5X,'AVAILABILITY')      BLP06040
      DO 239 I=1,NPTS                                                   BLP06050
      WRITE(6,235)I,IPCP(I)                                             BLP06060
235   FORMAT('0',8X,I2,19X,I1)                                          BLP06070
239   CONTINUE                                                          BLP06080
      WRITE(6,236)NPTS,IPCP(51)                                         BLP06090
236   FORMAT('0',6X,'1 - ',I2,17X,I1)                                   BLP06100
127   CONTINUE                                                          BLP06110
C                                                                       BLP06120
C     CALCULATE SCS COORDINATES FROM UTM COORDINATES                    BLP06130
C                                                                       BLP06140
      IF(.NOT.LUTMS)RETURN                                              BLP06150
      IF(NLINES.LE.0)RETURN                                             BLP06160
      XOR=XLBEG1(1)                                                     BLP06170
      YOR=YLBEG1(1)                                                     BLP06180
      DDX=XLEND1(1)-XOR                                                 BLP06190
      DDY=YLEND1(1)-YOR                                                 BLP06200
      ANGRAD=ATAN2(DDY,DDX)                                             BLP06210
      ANGRD=ANGRAD                                                      BLP06220
      TCOR=90.+ANGRAD/RAD                                               BLP06230
      SINT=DSIN(ANGRD)                                                  BLP06240
      COST=DCOS(ANGRD)                                                  BLP06250
      WRITE(6,189)                                                      BLP06260
189   FORMAT('1')                                                       BLP06270
C                                                                       BLP06280
C     TRANSLATE ORIGIN AND ROTATE COORDINATES                           BLP06290
C                                                                       BLP06300
C     LINE SOURCE COORDINATES                                           BLP06310
      DO 260 I=1,NLINES                                                 BLP06320
      XLBEG1(I)=XLBEG1(I)-XOR                                           BLP06330
      XLEND1(I)=XLEND1(I)-XOR                                           BLP06340
      YLBEG1(I)=YLBEG1(I)-YOR                                           BLP06350
      YLEND1(I)=YLEND1(I)-YOR                                           BLP06360
      XB1=XLBEG1(I)                                                     BLP06370
      XE1=XLEND1(I)                                                     BLP06380
      YB1=YLBEG1(I)                                                     BLP06390
      YE1=YLEND1(I)                                                     BLP06400
      YB1=-XB1*SINT+YB1*COST                                            BLP06410
      YLBEG1(I)=YB1                                                     BLP06420
      XB1=(XB1+YB1*SINT)/COST                                           BLP06430
      XLBEG1(I)=XB1                                                     BLP06440
      YE1=-XE1*SINT+YE1*COST                                            BLP06450
      YSCS(I)=YE1                                                       BLP06460
      YLEND1(I)=YE1                                                     BLP06470
      XE1=(XE1+YE1*SINT)/COST                                           BLP06480
      XLEND1(I)=XE1                                                     BLP06490
260   CONTINUE                                                          BLP06500
      DO 266 I=1,NLINES                                                 BLP06510
C     VERIFY LINE SOURCE COORDINATES ARE                                BLP06520
C     INPUT CORRECTLY - UTM COORDINATES                                 BLP06530
      IF(I.NE.1)GO TO 242                                               BLP06540
      YLBSAV=YLBEG1(I)                                                  BLP06550
      YLESAV=YLEND1(I)                                                  BLP06560
      GO TO 266                                                         BLP06570
242   CONTINUE                                                          BLP06580
      IF(YLBEG1(I).GT.YLBSAV.AND.YLEND1(I).GT.YLESAV)GO TO 243          BLP06590
      IM1=I-1                                                           BLP06600
      WRITE(6,217)IM1,YLBSAV,YLESAV,I,YLBEG1(I),YLEND1(I)               BLP06610
217   FORMAT('1','LINE SOURCE COORDINATES INPUT IN INCORRECT ',         BLP06620
     1 'ORDER -- WHEN USING UTM COORDINATES '/3X,                       BLP06630
     2 'LINE SOURCE COORDINATES MUST BE INPUT SUCH THAT WHEN ',         BLP06640
     3 'COORDINATES ARE CONVERTED TO SCS COORDINATES '/3X,              BLP06650
     4 'YLBEG (YLEND) OF LINE NO. N MUST BE GREATER THAN ',             BLP06660
     5 'YLBEG (YLEND) OF LINE NO. (N-1)'/'0','CURRENT SCS VALUES ',     BLP06670
     6 'FOR ',2('LINE ',I2,' ARE YLBEG = ',F10.1,3X,'YLEND = ',         BLP06680
     7 F10.1/24X))                                                      BLP06690
C     CALL WAUDIT
      STOP                                                              BLP06700
243   CONTINUE                                                          BLP06710
      YLBSAV=YLBEG1(I)                                                  BLP06720
      YLESAV=YLEND1(I)                                                  BLP06730
266   CONTINUE                                                          BLP06740
C     POINT SOURCE COORDINATES                                          BLP06750
      IF(NPTS.LT.1)GO TO 275                                            BLP06760
      DO 270 I=1,NPTS                                                   BLP06770
      XPSCS(I)=XPSCS(I)-XOR                                             BLP06780
      YPSCS(I)=YPSCS(I)-YOR                                             BLP06790
      EX=XPSCS(I)                                                       BLP06800
      EY=YPSCS(I)                                                       BLP06810
      EY=-EX*SINT+EY*COST                                               BLP06820
      YPSCS(I)=EY                                                       BLP06830
      EX=(EX+EY*SINT)/COST                                              BLP06840
      XPSCS(I)=EX                                                       BLP06850
270   CONTINUE                                                          BLP06860
275   CONTINUE                                                          BLP06870
C     TRANSLATE BUT DO NOT ROTATE RECEPTOR RECTANGLE COORDINATES        BLP06880
      IF(LINPUT)GO TO 290                                               BLP06890
      RXBEG1=RXBEG1-XOR                                                 BLP06900
      RXEND1=RXEND1-XOR                                                 BLP06910
      RYBEG1=RYBEG1-YOR                                                 BLP06920
      RYEND1=RYEND1-YOR                                                 BLP06930
      GO TO 299                                                         BLP06940
290   DO 295 I=1,NREC                                                   BLP06950
      XRSCS(I)=XRSCS(I)-XOR                                             BLP06960
      YRSCS(I)=YRSCS(I)-YOR                                             BLP06970
      EX=XRSCS(I)                                                       BLP06980
      EY=YRSCS(I)                                                       BLP06990
      EY=-EX*SINT+EY*COST                                               BLP07000
      YRSCS(I)=EY                                                       BLP07010
      EX=(EX+EY*SINT)/COST                                              BLP07020
      XRSCS(I)=EX                                                       BLP07030
295   CONTINUE                                                          BLP07040
299   CONTINUE                                                          BLP07050
      RETURN                                                            BLP07060
700   WRITE(6,701)NLINES,MAXL                                           BLP07070
701   FORMAT('1','NUMBER OF LINE SOURCES INPUT EXCEEDS MAXIMUM NUMBER ',BLP07080
     1 'ALLOWED'/'0','NUMBER OF LINE SOURCES INPUT (NLINES): ',I5/      BLP07090
     2 '0','MAXIMUM NUMBER OF LINE SOURCES ALLOWED: ',I5)               BLP07100
C     CALL WAUDIT
      STOP                                                              BLP07110
702   WRITE(6,703)NPTS,MAXP                                             BLP07120
703   FORMAT('1','NUMBER OF POINT SOURCES INPUT EXCEEDS MAXIMUM ',      BLP07130
     1 'NUMBER ALLOWED'/'0','NUMBER OF POINT SOURCES INPUT (NPTS): ',I5/BLP07140
     2 '0','MAXIMUM NUMBER OF POINT SOURCES ALLOWED: ',I5)              BLP07150
C     CALL WAUDIT
      STOP                                                              BLP07160
704   WRITE(6,705)NREC,MAXR                                             BLP07170
705   FORMAT('1','NUMBER OF RECEPTORS INPUT EXCEEDS MAXIMUM NUMBER ',   BLP07180
     1 'ALLOWED'/'0','NUMBER OF RECEPTORS INPUT (NREC): ',I5/           BLP07190
     2 '0','MAXIMUM NUMBER OF RECEPTORS ALLOWED: ',I5)                  BLP07200
C     CALL WAUDIT
      STOP                                                              BLP07210
706   WRITE(6,707)XLBEG,XLEND                                           BLP07220
707   FORMAT('1','ENTER COORDINATES OF THE LINE SOURCE ENDPOINTS FROM ',BLP07230
     1 'WEST TO EAST -- '/1X,'I.E., XLBEG MUST BE LESS THAN OR EQUAL ', BLP07240
     2 'TO XLEND'/'0','XLBEG INPUT AS ',F10.1/'0','XLEND INPUT AS ',    BLP07250
     3 F10.1)                                                           BLP07260
C     CALL WAUDIT
      STOP                                                              BLP07270
      END                                                               BLP07280
C
      SUBROUTINE RECEPT(LUTMS)                                          BLP07290
C                                                                       BLP07300
C                                                                       BLP07310
      REAL*8 EX,EY,SINT,COST,ANGRAD                                     BLP07320
      REAL LELEV                                                        BLP07330
      LOGICAL LUTMS                                                     BLP07340
      COMMON/SOURCE/NLINES,XLBEG(10),XLEND(10),DEL(10),YSCS(10),QT(10), BLP07350
     1 HS(10),XRCS(10,129),YRCS(10,129),TCOR,LELEV(10),                 BLP07360
     2 NPTS,XPSCS(50),YPSCS(50),PQ(50),PHS(50),XPRCS(50),YPRCS(50),     BLP07370
     3 TSTACK(50),APTS(50),BPTS(50),VEXIT(50),PELEV(50),IDOWNW(50)      BLP07380
      COMMON/RCEPT/RXBEG,RYBEG,RXEND,RYEND,RDX,RDY,XRSCS(100),          BLP07390
     1 YRSCS(100),XRRCS(100),YRRCS(100),RELEV(100),NREC                 BLP07400
C     COMMON/QA/VERSON,LEVEL                                            BLP07410
CPES  Begin PES Code Changes

      CHARACTER RUNDAT*8, RUNTIM*8, VERSN*5
      COMMON/DATETIME/ RUNDAT, RUNTIM, VERSN

CPES  End PES Code Changes
      DATA RAD/57.29578/                                                BLP07420
      IF(NLINES.LE.0)GO TO 151                                          BLP07430
      YLMAX=YSCS(1)                                                     BLP07440
      YLMIN=YSCS(NLINES)                                                BLP07450
      XLMAX=XLEND(1)                                                    BLP07460
      XLMIN=XLBEG(1)                                                    BLP07470
      DO 5 I=1,NLINES                                                   BLP07480
      XLMIN=AMIN1(XLMIN,XLBEG(I))                                       BLP07490
      XLMAX=AMAX1(XLMAX,XLEND(I))                                       BLP07500
      YLMIN=AMIN1(YLMIN,YSCS(I))                                        BLP07510
      YLMAX=AMAX1(YLMAX,YSCS(I))                                        BLP07520
5     CONTINUE                                                          BLP07530
C     DEFINE THE SOURCE RECTANGLE                                       BLP07540
      WRITE(6,105)XLMIN,YLMAX,XLMAX,YLMAX,XLMIN,YLMIN,XLMAX,YLMIN       BLP07550
105   FORMAT('0','THE SOURCE RECTANGLE IS DEFINED BY THE FOLLOWING ',   BLP07560
     1 'POINTS (IN SCS COORDINATES):'                                   BLP07570
     2 /'0','(',F10.2,',',F10.2,')',10X,'(',F10.2,',',F10.2,')'         BLP07580
     3 /'0','(',F10.2,',',F10.2,')',10X,'(',F10.2,',',F10.2,')')        BLP07590
      GO TO 161                                                         BLP07600
C     IF THERE ARE NO LINE SOURCES, SOURCE RECTANGLE IS                 BLP07610
C     UNDEFINED -- ASSIGN VALUES TO XLMIN,XLMAX,YLMIN,YLMAX             BLP07620
C     SUCH THAT NO RESTRICTION IS PLACED ON THE LOCATIONS OF            BLP07630
C     RECEPTORS                                                         BLP07640
151   CONTINUE                                                          BLP07650
      XLMIN=1.E10                                                       BLP07660
      XLMAX=-1.E10                                                      BLP07670
      YLMIN=1.E10                                                       BLP07680
      YLMAX=-1.E10                                                      BLP07690
161   CONTINUE                                                          BLP07700
      IF(.NOT.LUTMS)GO TO 550                                           BLP07710
      ANGRAD=(TCOR-90.)/RAD                                             BLP07720
      SINT=DSIN(ANGRAD)                                                 BLP07730
      COST=DCOS(ANGRAD)                                                 BLP07740
550   CONTINUE                                                          BLP07750
      NRINX=(RXEND-RXBEG)/RDX+1.01                                      BLP07760
      NRINY=(RYEND-RYBEG)/RDY+1.01                                      BLP07770
C     NTHTOT IS THE NUMBER OF RECEPTORS BEFORE ELIMINATING              BLP07780
C     THOSE IN THE SOURCE RECTANGLE                                     BLP07790
      NTHTOT=NRINX*NRINY                                                BLP07800
      NREC=0                                                            BLP07810
      DO 10 I=1,NRINX                                                   BLP07820
      DO 10 J=1,NRINY                                                   BLP07830
      RXSAVE=RXBEG+(I-1)*RDX                                            BLP07840
      RYSAVE=RYBEG+(J-1)*RDY                                            BLP07850
      IF(.NOT.LUTMS)GO TO 560                                           BLP07860
      EX=RXSAVE                                                         BLP07870
      EY=RYSAVE                                                         BLP07880
      EY=-EX*SINT+EY*COST                                               BLP07890
      RYSAVE=EY                                                         BLP07900
      EX=(EX+EY*SINT)/COST                                              BLP07910
      RXSAVE=EX                                                         BLP07920
560   CONTINUE                                                          BLP07930
C     IF A RECEPTOR IS OUTSIDE THE SOURCE RECTANGLE, RECORD ITS         BLP07940
C     X AND Y COORDINATES, OTHERWISE, IGNORE IT                         BLP07950
      IF(RYSAVE.GT.YLMAX.OR.RYSAVE.LT.YLMIN)GO TO 9                     BLP07960
      IF(RXSAVE.GT.XLMAX.OR.RXSAVE.LT.XLMIN)GO TO 9                     BLP07970
      GO TO 10                                                          BLP07980
9     NREC=NREC+1                                                       BLP07990
      IF(NREC.GT.100)GO TO 200                                          BLP08000
      XRSCS(NREC)=RXSAVE                                                BLP08010
      YRSCS(NREC)=RYSAVE                                                BLP08020
10    CONTINUE                                                          BLP08030
CPES  Begin PES Code Changes

      WRITE(6,1400) VERSN, RUNDAT, RUNTIM
1400  FORMAT('1',11X,'BLP -- MULTIPLE BUOYANT LINE AND POINT ',
     1'SOURCE DISPERSION MODEL     SCRAM VERSION (DATED ',A5,')',17X,A8,
     2/,123X,A8 / ' ',13('**********'))

CPES  End PES Code Changes
      WRITE(6,26)                                                       BLP08080
26    FORMAT(//'0','RECEPTOR NO.',11X,'LOCATION',19X,'RECEPTOR NO.',11X,BLP08090
     1 'LOCATION'/16X,'X',16X,'Y',32X,'X',16X,'Y')                      BLP08100
      IH=NREC/2                                                         BLP08110
      DO 30 I=1,IH                                                      BLP08120
      IP=IH+I                                                           BLP08130
      WRITE(6,29)I,XRSCS(I),YRSCS(I),IP,XRSCS(IP),YRSCS(IP)             BLP08140
29    FORMAT(3X,I3,10X,F6.0,10X,F6.0,13X,I3,10X,F6.0,10X,F6.0)          BLP08150
30    CONTINUE                                                          BLP08160
      IEVEN=MOD(NREC,2)                                                 BLP08170
      IF(IEVEN.NE.0)WRITE(6,33)NREC,XRSCS(NREC),YRSCS(NREC)             BLP08180
33    FORMAT(51X,I3,10X,F6.0,10X,F6.0)                                  BLP08190
      WRITE(6,35)NTHTOT,NREC                                            BLP08200
35    FORMAT(////1X,'NUMBER OF POSSIBLE RECEPTOR LOCATIONS = ',I5/      BLP08210
     1 '0','NUMBER OF ACTUAL RECEPTOR LOCATIONS = ',I5)                 BLP08220
      WRITE(6,37)                                                       BLP08230
37    FORMAT(/'0','GENERATED RECEPTOR LOCATIONS IN SCS COORDINATES')    BLP08240
      RETURN                                                            BLP08250
200   WRITE(6,205)RXBEG,RYBEG,RXEND,RYEND,RDX,RDY                       BLP08260
205   FORMAT('0','TOO MANY RECEPTOR LOCATIONS REQUESTED.'/'0',          BLP08270
     1 'RECEPTORS AT: (',E13.6,',',E13.6,')',2X,'TO  (',E13.6,',',      BLP08280
     2 E13.6,')',10X,'WITH (DX,DY) = (',E13.6,',',E13.6,')')            BLP08290
C     CALL WAUDIT
      STOP                                                              BLP08300
      END                                                               BLP08310
C
      SUBROUTINE OUTITL(TITLE,NREC,NPTS,NLINES,IPCL,IPCP,IYR,IDAYS,     BLP08320
     1 RCOMPR)                                                          BLP08330
C                                                                       BLP08340
C                                                                       BLP08350
      CHARACTER*4 TITLE(20)                                             BLP08360
      INTEGER IPCL(11),IPCP(51)                                         BLP08370
      DIMENSION IDAYS(366)                                              BLP08380
      LOGICAL RCOMPR                                                    BLP08390
C                                                                       BLP08400
C     THIS SUBROUTINE WRITES THE TITLE CARD AND OTHER RUN               BLP08410
C     INFORMATION TO RECORD #1 OF THE OUTPUT FILE (UNIT 20)             BLP08420
C                                                                       BLP08430
C     THOUSANDS PLACE OF NNREC IS CODED TO INDICATE IF ARRAY            BLP08440
C     COMPRESSION OPTION IS USED                                        BLP08450
C     IF NNREC > 1000, OUTPUT ARRAYS ARE COMPRESSED                     BLP08460
C     IF NNREC < 1000, OUTPUT ARRAYS ARE NOT COMPRESSED                 BLP08470
      NNREC=NREC                                                        BLP08480
      IF(RCOMPR)NNREC=NNREC+1000                                        BLP08490
      WRITE(20)TITLE,NNREC,NPTS,NLINES,IPCL,IPCP,IYR,IDAYS              BLP08500
      RETURN                                                            BLP08510
      END                                                               BLP08520
C
CPES  Begin PES Code Changes

      SUBROUTINE MET(JDAY)

C     The routine has been modified to read meteorological data from
C     an ASCII-formatted file rather than an unformatted file.  It also
C     returns the Julian day (JDAY) determined from the date in the file.
C     Simple error checks for proper date sequence have also been added.
C     Modified by R.Brode, PES, Inc. - 6/25/99

CPES  End PES Code Changes
C                                                                       BLP08540
C                                                                       BLP08550
      LOGICAL LMETIN,LMETOT                                             BLP08560
CPES  Beging PES Code Changes

      DIMENSION HLH(2,24)

CPES  End PES Code Changes
      COMMON/METD24/KST(24),SPEED(24),RANDWD(24),HMIX(24),TEMP(24),     BLP08600
     1 DTHTA(2),PEXP(6),IDELS,IDSURF,IYSURF,IDUPER,IYUPER,TERAN(6),     BLP08610
     2 IRU,IHRMAX,LMETIN,LMETOT,IDAYS(366)                              BLP08620
      COMMON/QA/VERSON,LEVEL                                            BLP08630
CPES  Beging PES Code Changes

      CHARACTER RUNDAT*8, RUNTIM*8, VERSN*5
      COMMON/DATETIME/ RUNDAT, RUNTIM, VERSN

CPES  End PES Code Changes
      DATA KSTOLD/5/                                                    BLP08640
C                                                                       BLP08650
C     READ PROCESSED UNFORMATTED METEOROLOGICAL DATA                    BLP08660
C                                                                       BLP08670
      IF(LMETIN)GO TO 185                                               BLP08680
CPES  Begin PES Code Changes

      DO I = 1, 24
C        Read Hourly Records from Formatted ASCII File
         READ(2,9500,END=999,ERR=99) IYR, IMO, IDAY, IHR,
     &        RANDWD(I), SPEED(I), TEMP(I), KST(I),
     &        HLH(1,I), HLH(2,I)
9500     FORMAT(4I2,2F9.4,F6.1,I2,2F7.1)
         IF (I .NE. IHR) THEN
            WRITE(*,*) 'MET DATA SEQUENCE ERROR AT ',IYR,IMO,IDAY,IHR
            WRITE(6,*) 'MET DATA SEQUENCE ERROR AT ',IYR,IMO,IDAY,IHR
            STOP
         END IF

         CYCLE

99       CONTINUE

         WRITE(*,*) 'ERROR READING MET DATA FILE AT ',IYR,IMO,IDAY,IHR
         WRITE(6,*) 'ERROR READING MET DATA FILE AT ',IYR,IMO,IDAY,IHR
         STOP

999      CONTINUE

         WRITE(*,*) 'PREMATURE END OF FILE REACHED FOR MET DATA'
         WRITE(6,*) 'PREMATURE END OF FILE REACHED FOR MET DATA'
         STOP

      END DO

C     Convert Year to 4-Digit Value (IYEAR) Using Date Windowing
      IF (IYR .GE. 50 .AND. IYR .LE. 99) THEN
         IYEAR = 1900 + IYR
      ELSE IF (IYR .LT. 50) THEN
         IYEAR = 2000 + IYR
      ELSE
C        Input IYR must be 4-digit:  Save to IYEAR and convert to 2-digit
         IYEAR = IYR
         IYR   = IYEAR - 100 * (IYEAR/100)
      END IF

C     Calculate Julian Day Using 4-Digit Year
      CALL JULIAN(IYEAR,IMO,IDAY,JDAY)

C     Write Status Message to the Screen
      WRITE(*,909) JDAY, IYEAR
 909  FORMAT('+','Now Processing Data For Day No. ',I4,' of ',I4)

CPES  End PES Code Changes
C     IRU=1 FOR RURAL MIXING HEIGHTS, IRU=2 FOR URBAN MIXING HEIGHTS    BLP08800
      DO 5 I=1,24                                                       BLP08810
      HMIX(I)=HLH(IRU,I)                                                BLP08820
5     CONTINUE                                                          BLP08830
C                                                                       BLP08840
C     ALLOW ONLY STABILITIES 1 TO 6 AND                                 BLP08850
C     RESTRICT STABILITY VARIATION TO 'IDELS' CLASSES/HOUR              BLP08860
C                                                                       BLP08870
      DO 75 I=1,24                                                      BLP08880
      ISTAB=KST(I)                                                      BLP08890
      ISTAB=MIN0(ISTAB,6)                                               BLP08900
      IDSTAB=ISTAB-KSTOLD                                               BLP08910
      IF(IABS(IDSTAB).GT.IDELS)ISTAB=KSTOLD+ISIGN(IDELS,IDSTAB)         BLP08920
      KSTOLD=ISTAB                                                      BLP08930
      KST(I)=ISTAB                                                      BLP08940
C     IF AMBIENT TEMPERATURE IS MISSING, ASSUME T=293.0 DEG. K          BLP08950
      IF(TEMP(I).LE.0.0)TEMP(I)=293.                                    BLP08960
75    CONTINUE                                                          BLP08970
C                                                                       BLP08980
C     IF LMETOT = .TRUE., WRITE HOURLY METEOROLOGY                      BLP08990
C                                                                       BLP09000
      IF(.NOT.LMETOT)RETURN                                             BLP09010
CPES  Begin PES Code Changes

      IF(IDAYS(JDAY).NE.1)RETURN
      WRITE(6,12)IYR,IMO,JDAY,(NH,NH=1,24),KST,SPEED,TEMP,RANDWD,
     1 (HLH(1,N),N=1,24),(HLH(2,N2),N2=1,24)                            BLP09040
12    FORMAT('0','IYR = ',I2,3X,'IMO = ',I2,3X,'JDAY = ',I4/
     1 4X,'HR=',3X,I4,23I5/                                             BLP09060
     1 4X,'ISTAB=',I4,23I5/4X,'WS=  ',24F5.1/4X,'TEMP=',24F5.0/         BLP09070
     2 4X,'WD-R=',24F5.0/4X,'H-RURAL=',12F6.0/                          BLP09080
     3 12X,12F6.0/4X,'H-URBAN=',12F6.0/12X,12F6.0)                      BLP09090

CPES  End PES Code Changes
      RETURN                                                            BLP09100
185   CONTINUE                                                          BLP09110
C                                                                       BLP09120
C     READ UP TO 24 HOURS OF FORMATTED METEOROLOGICAL DATA              BLP09130
C     FROM UNIT 5                                                       BLP09140
C                                                                       BLP09150
      READ(5,110)IHRMAX                                                 BLP09160
110   FORMAT(I2)                                                        BLP09170
      IF(IHRMAX.LE.24.AND.IHRMAX.GE.1)GO TO 161                         BLP09180
      WRITE(6,159)IHRMAX                                                BLP09190
159   FORMAT(/////10X,'EXECUTION TERMINATING -- IHRMAX MUST ',          BLP09200
     1 'BE SPECIFIED BY THE USER TO BE '/'0',9X,'BETWEEN ',             BLP09210
     2 '1 AND 24 WHEN THE FORMATTED METEOROLOGICAL USER INPUT '/        BLP09220
     3 '0',9X,'OPTION IS REQUESTED  --  (IHRMAX = ',                    BLP09230
     4 I5,')')                                                          BLP09240
C     CALL WAUDIT
      STOP                                                              BLP09250
161   CONTINUE                                                          BLP09260
CPES  Begin PES Code Changes

C     Set Julian Day = 1 for User Input Formatted Met Data
      JDAY = 1

      WRITE(6,1400) VERSN, RUNDAT, RUNTIM
1400  FORMAT('1',11X,'BLP -- MULTIPLE BUOYANT LINE AND POINT ',
     1'SOURCE DISPERSION MODEL     SCRAM VERSION (DATED ',A5,')',17X,A8,
     2/,123X,A8 / ' ',13('**********'))

CPES  End PES Code Changes
      WRITE(6,171)                                                      BLP09310
171   FORMAT(/'0',20X,'USER INPUT FORMATTED METEOROLOGICAL DATA'//      BLP09320
     1 '0',5X,'HOUR',3X,'STABILITY',3X,'WIND SPEED',3X,'WIND ',         BLP09330
     2 'DIRECTION',3X,'TEMPERATURE',3X,'MIXING HEIGHT'/                 BLP09340
     3 15X,'CLASS',8X,'(M/S)',8X,'(DEGREES)',6X,'(DEG. K)',9X,          BLP09350
     4 '(M)')                                                           BLP09360
      DO 100 I=1,IHRMAX                                                 BLP09370
      READ(5,112)KST(I),SPEED(I),RANDWD(I),TEMP(I),HMIX(I)              BLP09380
112   FORMAT(I1,9X,F10.2,F10.2,F10.2,F10.2)                             BLP09390
      IF(KST(I).GT.6)KST(I)=6                                           BLP09400
      WRITE(6,114)I,KST(I),SPEED(I),RANDWD(I),TEMP(I),HMIX(I)           BLP09410
114   FORMAT('0',6X,I2,8X,I1,9X,F5.2,10X,F5.1,11X,F5.1,9X,F5.0)         BLP09420
100   CONTINUE                                                          BLP09430
      RETURN                                                            BLP09440
      END                                                               BLP09450
CPES  Begin PES Code Changes

      SUBROUTINE JULIAN(INYR,INMN,INDY,JDY)
C***********************************************************************
C        Based on JULIAN Module of ISC3 Short Term Model
C
C        PURPOSE:    CONVERT YR/MN/DY DATE TO JULIAN DAY (1-366),
C                    INCLUDES TEST FOR 100 AND 400 YEAR CORRECTIONS
C
C        PROGRAMMER: Roger Brode
C
C        DATE:       June 24, 1999
C
C        INPUTS:     YEAR,  INYR (4 DIGIT)
C                    MONTH, INMN
C                    DAY,   INDY
C
C        OUTPUT:     JULIAN DAY,  JDY (1-366)
C
C        CALLED FROM:   MET
C
C        ERROR HANDLING:   Checks for Invalid Month or Day
C***********************************************************************

C     Variable Declarations
      IMPLICIT NONE

      SAVE
      INTEGER :: NDAY(12), IDYMAX(12)
      INTEGER :: INYR, INMN, INDY, JDY

C     Variable Initializations
      DATA NDAY/0,31,59,90,120,151,181,212,243,273,304,334/
      DATA IDYMAX/31,29,31,30,31,30,31,31,30,31,30,31/
      JDY = 0

C     Check for Invalid Month or Day
      IF (INMN.LT.1 .OR. INMN.GT.12) THEN
         WRITE(*,*) 'Invalid Month in Met Data File for IMO = ',INMN
         WRITE(6,*) 'Invalid Month in Met Data File for IMO = ',INMN
         STOP
      ELSE IF (INDY .GT. IDYMAX(INMN)) THEN
         WRITE(*,*) 'Invalid Day in Met Data File for IMO = ',INMN,
     &              ' and IDY = ',INDY
         WRITE(6,*) 'Invalid Day in Met Data File for IMO = ',INMN,
     &              ' and IDY = ',INDY
         STOP
      END IF

C     Determine JULIAN Day Number; For Non-Leap Year First
      IF ((MOD(INYR,4) .NE. 0) .OR.
     &    (MOD(INYR,100) .EQ. 0 .AND. MOD(INYR,400) .NE. 0)) THEN
C        Not a Leap Year
         IF (INMN.NE.2 .OR. (INMN.EQ.2 .AND. INDY.LE.28)) THEN
            JDY = INDY + NDAY(INMN)
         ELSE
            WRITE(*,*) 'Invalid Date; 2/29 in Non-Leap Year for IYR = ',
     &                  INYR
            WRITE(6,*) 'Invalid Date; 2/29 in Non-Leap Year for IYR = ',
     &                  INYR
            STOP
         END IF
      ELSE
C        Leap Year
         JDY = INDY + NDAY(INMN)
         IF (INMN .GT. 2)  JDY = JDY + 1
      END IF

 999  CONTINUE

      RETURN
      END

CPES  End PES Code Changes
C
      SUBROUTINE COORD(THETA)                                           BLP09460
C                                                                       BLP09470
C                                                                       BLP09480
      DIMENSION XSCS(10,129)                                            BLP09490
      REAL LELEV                                                        BLP09500
      REAL TCHK(4)/90.,180.,270.,360./                                  BLP09510
      INTEGER IL(4)/4*1/,ISEG(4)/1,129,129,1/                           BLP09520
      COMMON/SOURCE/NLINES,XLBEG(10),XLEND(10),DEL(10),YSCS(10),QT(10), BLP09530
     1 HS(10),XRCS(10,129),YRCS(10,129),TCOR,LELEV(10),                 BLP09540
     2 NPTS,XPSCS(50),YPSCS(50),PQ(50),PHS(50),XPRCS(50),YPRCS(50),     BLP09550
     3 TSTACK(50),APTS(50),BPTS(50),VEXIT(50),PELEV(50),IDOWNW(50)      BLP09560
      COMMON/RCEPT/RXBEG,RYBEG,RXEND,RYEND,RDX,RDY,XRSCS(100),          BLP09570
     1 YRSCS(100),XRRCS(100),YRRCS(100),RELEV(100),NREC                 BLP09580
      EQUIVALENCE (XRCS(1,1),XSCS(1,1))                                 BLP09590
      DATA RAD/57.29578/                                                BLP09600
      TRAD=THETA/RAD                                                    BLP09610
      COST=COS(TRAD)                                                    BLP09620
      SINT=SIN(TRAD)                                                    BLP09630
      IF(NLINES.LT.1)GO TO 250                                          BLP09640
C                                                                       BLP09650
C     CALCULATE SOURCE COORDINATES FOR EACH SOURCE LINE SEGMENT         BLP09660
C                                                                       BLP09670
      DO 25 I=1,NLINES                                                  BLP09680
      DXX=DEL(I)/128.                                                   BLP09690
      XSCS(I,1)=XLBEG(I)                                                BLP09700
      DO 25 J=2,129                                                     BLP09710
      XSCS(I,J)=XSCS(I,J-1)+DXX                                         BLP09720
25    CONTINUE                                                          BLP09730
      IL(3)=NLINES                                                      BLP09740
      IL(4)=NLINES                                                      BLP09750
C                                                                       BLP09760
C     CALCULATE XN, YN (ORIGINS OF TRANSLATED COORDINATE SYSTEM         BLP09770
C     IN TERMS OF THE SCS COORDINATES                                   BLP09780
C                                                                       BLP09790
      DO 5 I=1,4                                                        BLP09800
      IF(THETA.GE.TCHK(I))GO TO 5                                       BLP09810
      ISAVE=I                                                           BLP09820
      ILINE=IL(I)                                                       BLP09830
      ISEGN=ISEG(I)                                                     BLP09840
      XN=XSCS(ILINE,ISEGN)                                              BLP09850
      YN=YSCS(ILINE)                                                    BLP09860
      GO TO 6                                                           BLP09870
5     CONTINUE                                                          BLP09880
6     CONTINUE                                                          BLP09890
C                                                                       BLP09900
C     TRANSLATE COORDINATES                                             BLP09910
C                                                                       BLP09920
C     TRANSLATE LINE SOURCE SEGMENT COORDINATES                         BLP09930
      DO 10 I=1,NLINES                                                  BLP09940
      DO 10 J=1,129                                                     BLP09950
      XRCS(I,J)=XSCS(I,J)-XN                                            BLP09960
      YRCS(I,J)=YSCS(I)-YN                                              BLP09970
10    CONTINUE                                                          BLP09980
C     TRANSLATE POINT SOURCE COORDINATES                                BLP09990
      DO 11 I=1,NPTS                                                    BLP10000
      XPRCS(I)=XPSCS(I)-XN                                              BLP10010
      YPRCS(I)=YPSCS(I)-YN                                              BLP10020
11    CONTINUE                                                          BLP10030
C     TRANSLATE RECEPTOR COORDINATES                                    BLP10040
      DO 12 I=1,NREC                                                    BLP10050
      XRRCS(I)=XRSCS(I)-XN                                              BLP10060
      YRRCS(I)=YRSCS(I)-YN                                              BLP10070
12    CONTINUE                                                          BLP10080
C                                                                       BLP10090
C     ROTATE COORDINATE SYSTEM                                          BLP10100
C                                                                       BLP10110
C     ROTATE LINE SOURCE SEGMENT COORDINATES                            BLP10120
      DO 20 I=1,NLINES                                                  BLP10130
      DO 20 J=1,129                                                     BLP10140
      XSAVE=XRCS(I,J)                                                   BLP10150
      YSAVE=YRCS(I,J)                                                   BLP10160
      XRCS(I,J)=XSAVE*COST+YSAVE*SINT                                   BLP10170
      YRCS(I,J)=YSAVE*COST-XSAVE*SINT                                   BLP10180
20    CONTINUE                                                          BLP10190
      IF(NPTS.LT.1)GO TO 260                                            BLP10200
C     ROTATE POINT SOURCE COORDINATES                                   BLP10210
      DO 21 I=1,NPTS                                                    BLP10220
      XSAVE=XPRCS(I)                                                    BLP10230
      YSAVE=YPRCS(I)                                                    BLP10240
      XPRCS(I)=XSAVE*COST+YSAVE*SINT                                    BLP10250
      YPRCS(I)=YSAVE*COST-XSAVE*SINT                                    BLP10260
21    CONTINUE                                                          BLP10270
260   CONTINUE                                                          BLP10280
C     ROTATE RECEPTOR COORDINATES                                       BLP10290
      DO 22 I=1,NREC                                                    BLP10300
      XSAVE=XRRCS(I)                                                    BLP10310
      YSAVE=YRRCS(I)                                                    BLP10320
      XRRCS(I)=XSAVE*COST+YSAVE*SINT                                    BLP10330
      YRRCS(I)=YSAVE*COST-XSAVE*SINT                                    BLP10340
22    CONTINUE                                                          BLP10350
      RETURN                                                            BLP10360
250   CONTINUE                                                          BLP10370
C                                                                       BLP10380
C     WITH NO LINE SOURCES, JUST ROTATE THE POINT SOURCE AND            BLP10390
C     RECEPTOR COORDINATES                                              BLP10400
C                                                                       BLP10410
      IF(NPTS.LT.1)GO TO 360                                            BLP10420
C     ROTATE POINT SOURCE COORDINATES                                   BLP10430
      DO 321 I=1,NPTS                                                   BLP10440
      XSAVE=XPSCS(I)                                                    BLP10450
      YSAVE=YPSCS(I)                                                    BLP10460
      XPRCS(I)=XSAVE*COST+YSAVE*SINT                                    BLP10470
      YPRCS(I)=YSAVE*COST-XSAVE*SINT                                    BLP10480
321   CONTINUE                                                          BLP10490
360   CONTINUE                                                          BLP10500
C     ROTATE RECEPTOR COORDINATES                                       BLP10510
      DO 322 I=1,NREC                                                   BLP10520
      XSAVE=XRSCS(I)                                                    BLP10530
      YSAVE=YRSCS(I)                                                    BLP10540
      XRRCS(I)=XSAVE*COST+YSAVE*SINT                                    BLP10550
      YRRCS(I)=YSAVE*COST-XSAVE*SINT                                    BLP10560
322   CONTINUE                                                          BLP10570
      RETURN                                                            BLP10580
      END                                                               BLP10590
C
      SUBROUTINE CONTRB(RCOMPR)                                         BLP10600
C                                                                       BLP10610
C                                                                       BLP10620
      REAL CHI(100),PARTCH(100),CHIL(100),FTSAVE(129)                   BLP10630
      REAL L,LEFF,LD,LELEV                                              BLP10640
      INTEGER NSEGA(7)/3,5,9,17,33,65,129/                              BLP10650
      LOGICAL LSHEAR,LTRANS,RCOMPR                                      BLP10660
      COMMON/PRLS/XFB,LEFF,LD,R0,XFINAL,XFS                             BLP10670
      COMMON/SOURCE/NLINES,XLBEG(10),XLEND(10),DEL(10),YSCS(10),QT(10), BLP10680
     1 HS(10),XRCS(10,129),YRCS(10,129),TCOR,LELEV(10),                 BLP10690
     2 NPTS,XPSCS(50),YPSCS(50),PQ(50),PHS(50),XPRCS(50),YPRCS(50),     BLP10700
     3 TSTACK(50),APTS(50),BPTS(50),VEXIT(50),PELEV(50),IDOWNW(50)      BLP10710
      COMMON/RCEPT/RXBEG,RYBEG,RXEND,RYEND,RDX,RDY,XRSCS(100),          BLP10720
     1 YRSCS(100),XRRCS(100),YRRCS(100),RELEV(100),NREC                 BLP10730
      COMMON/RINTP/XDIST(7),DH(7)                                       BLP10740
      COMMON/METD/ZMEAS,WS,WD,ISTAB,TDEGK,DPBL,THETA,S,P,IYR,JDAY,IHOUR BLP10750
      COMMON/PR/L,HB,WB,WM,FPRIME,FP,XMATCH,DX,AVFACT,TWOHB,N,LSHEAR,   BLP10760
     1 LTRANS                                                           BLP10770
      COMMON/PBLDAT/TWOPBL,PBL1P6                                       BLP10780
      COMMON/OUTPT/IPCL(11),IPCP(51)                                    BLP10790
      COMMON/PARM/CRIT,TER1,DECFAC,XBACKG,CONST2,CONST3,MAXIT           BLP10800
      DATA PI/3.1415927/,SRT2DP/0.7978846/,IWPBL/0/,JITCT/0/            BLP10810
      DO 5 I=1,NREC                                                     BLP10820
      CHIL(I)=0.0                                                       BLP10830
5     CHI(I)=0.0                                                        BLP10840
      IF(NLINES.LT.1)GO TO 2000                                         BLP10850
      ITHETA=THETA+0.5                                                  BLP10860
      WSST=WS*(HB/ZMEAS)**P                                             BLP10870
C     SET EFFECTIVE WIND SPEED USED IN PLUME RISE                       BLP10880
C     CALCULATIONS, U, TO STACK HEIGHT WIND SPEED, WSST --              BLP10890
C     IF USING WIND SHEAR OPTION IN PLUME RISE, U WILL BE               BLP10900
C     CALCULATED IN SUBROUTINE WSC                                      BLP10910
      U=WSST                                                            BLP10920
      IF(LSHEAR)CALL WSC(ISTAB,WSST,U,S,P)                              BLP10930
      CALL LENG(THETA,U)                                                BLP10940
C                                                                       BLP10950
C     CALCULATE DISTANCE TO FINAL RISE                                  BLP10960
C                                                                       BLP10970
      IF(ISTAB.LE.4)GO TO 6                                             BLP10980
C     CALCULATE DISTANCE TO FINAL RISE FOR STABLE CONDITIONS            BLP10990
      UNSRT=16.*U*U/S-XFB*XFB/3.                                        BLP11000
      IF(UNSRT.LE.0.0)GO TO 105                                         BLP11010
      XFS=0.5*(XFB+SQRT(UNSRT))                                         BLP11020
      GO TO 106                                                         BLP11030
105   XFS=(12.*XFB*U*U/S)**0.3333333                                    BLP11040
106   CONTINUE                                                          BLP11050
      XFSXX=U*PI/SQRT(S)                                                BLP11060
      XFS=AMIN1(XFS,XFSXX)                                              BLP11070
      IF(XFS.GT.XFB)GO TO 7                                             BLP11080
      DO 18 I=2,7                                                       BLP11090
18    XDIST(I)=XFS                                                      BLP11100
      GO TO 10                                                          BLP11110
6     XFS=XFB+XFINAL                                                    BLP11120
7     CONTINUE                                                          BLP11130
C     FIND 5 INTERMEDIATE DOWNWIND DISTANCES (IN ADDITION TO XFB)       BLP11140
C     AT WHICH PLUME RISE WILL BE CALCULATED                            BLP11150
      DO 9 I=2,7                                                        BLP11160
      RI=FLOAT(I)                                                       BLP11170
      XDIST(I)=XFS-(XFS-XFB)*(7.-RI)/5.                                 BLP11180
9     CONTINUE                                                          BLP11190
10    CONTINUE                                                          BLP11200
      CALL RISE(U,ISTAB,S)                                              BLP11210
C                                                                       BLP11220
C     CALCULATE PARTIAL CONCENTRATIONS DUE TO THE LINE SOURCES          BLP11230
C                                                                       BLP11240
C     LOOP OVER LINES                                                   BLP11250
C                                                                       BLP11260
      DO 1000 LNUM=1,NLINES                                             BLP11270
      DLMIN=DEL(LNUM)/128.                                              BLP11280
      ZB=LELEV(LNUM)                                                    BLP11290
      ZLINE=HS(LNUM)                                                    BLP11300
      WSST=WS*(ZLINE/ZMEAS)**P                                          BLP11310
      CUQ=QT(LNUM)/((NSEGA(1)-1)*WSST)                                  BLP11320
C     SRT2DP = SQRT(2./PI)                                              BLP11330
      SZ0=R0*SRT2DP                                                     BLP11340
      ZV=1000.*XVZ(SZ0,ISTAB)                                           BLP11350
      SY0=SZ0/2.                                                        BLP11360
      YV=1000.*XVY(SY0,ISTAB)                                           BLP11370
      XB=XRCS(LNUM,1)                                                   BLP11380
      YB=YRCS(LNUM,1)                                                   BLP11390
      XE=XRCS(LNUM,129)                                                 BLP11400
      YE=YRCS(LNUM,129)                                                 BLP11410
      XMAXL=AMAX1(XB,XE)                                                BLP11420
      XMINL=AMIN1(XB,XE)                                                BLP11430
      YMAXL=AMAX1(YB,YE)                                                BLP11440
      YMINL=AMIN1(YB,YE)                                                BLP11450
      DXEL=XE-XB                                                        BLP11460
      DYEL=YE-YB                                                        BLP11470
C                                                                       BLP11480
C     LOOP OVER RECEPTORS                                               BLP11490
C                                                                       BLP11500
      DO 500 I=1,NREC                                                   BLP11510
      SUM=0.0                                                           BLP11520
      PARTCH(I)=0.0                                                     BLP11530
      NSEG=0                                                            BLP11540
      NCONTR=0                                                          BLP11550
      XRECEP=XRRCS(I)                                                   BLP11560
      THT=RELEV(I)-ZB                                                   BLP11570
C                                                                       BLP11580
C     IF RECEPTOR IS UPWIND OF THE LINE, CHI = 0.0                      BLP11590
C                                                                       BLP11600
      IF(XRECEP.LE.XMINL)GO TO 500                                      BLP11610
      YRECEP=YRRCS(I)                                                   BLP11620
C     IWOSIG KEEPS TRACK OF WHETHER ANY LINE SEGMENT IS WITHIN          BLP11630
C     ONE SIGMA Y OF THE CURRENT RECEPTOR (0=NO,1=YES)                  BLP11640
      IWOSIG=0                                                          BLP11650
C     DEFINE REGION OF INFLUENCE                                        BLP11660
C     MAX DISTANCE FROM ANY SOURCE SEGMENT TO CURRENT RECEPTOR          BLP11670
C     IS EQUAL TO (XRECEP-XMINL)                                        BLP11680
      XRMXKM=(XRECEP-XMINL)/1000.                                       BLP11690
      CALL SIGMAY(XRMXKM,ISTAB,SYC)                                     BLP11700
      YLOW=YMINL-4.*SYC                                                 BLP11710
      YHIGH=YMAXL+4.*SYC                                                BLP11720
      IF(YRECEP.LT.YLOW.OR.YRECEP.GT.YHIGH)GO TO 500                    BLP11730
      YLOW=YLOW+DLMIN                                                   BLP11740
      YHIGH=YHIGH-DLMIN                                                 BLP11750
      IF(YRECEP.LT.YLOW.OR.YRECEP.GT.YHIGH)GO TO 500                    BLP11760
C     CHECK IF RECEPTOR IS DIRECTLY DOWNWIND OF                         BLP11770
C     THE LINE (IDW=0=NO,IDW=1=YES)                                     BLP11780
      IDW=1                                                             BLP11790
      IF(YRECEP.LT.YMINL.OR.YRECEP.GT.YMAXL)IDW=0                       BLP11800
C     CHECK IF RECEPTOR IS ON THE DOWNWIND SIDE OF THE LINE             BLP11810
      IF(XRECEP.GE.XMAXL)GO TO 477                                      BLP11820
      IF(MOD(ITHETA,90).EQ.0)GO TO 477                                  BLP11830
      EM=DYEL/DXEL                                                      BLP11840
      B=YE-EM*XE                                                        BLP11850
      IF(XRECEP.LT.(YRECEP-B)/EM)NCONTR=999                             BLP11860
477   CONTINUE                                                          BLP11870
      NSEG0=NSEGA(1)                                                    BLP11880
      NNEW=NSEG0                                                        BLP11890
      ITER=0                                                            BLP11900
      INDL=1                                                            BLP11910
      IDELTA=128/(NSEG0-1)                                              BLP11920
498   CONTINUE                                                          BLP11930
      NSEG=NSEG+NNEW                                                    BLP11940
C                                                                       BLP11950
C     LOOP OVER LINE SEGMENTS                                           BLP11960
C                                                                       BLP11970
      DO 499 ISEG=1,NNEW                                                BLP11980
      FTSAVE(INDL)=0.0                                                  BLP11990
C     IF CURRENT RECEPTOR IS UPWIND OF A SOURCE SEGMENT, THEN           BLP12000
C     THIS SOURCE SEGMENT DOES NOT CONTRIBUTE                           BLP12010
      IF(XRCS(LNUM,INDL).GE.XRECEP)GO TO 495                            BLP12020
      DOWNX=XRECEP-XRCS(LNUM,INDL)                                      BLP12030
      CROSSY=YRECEP-YRCS(LNUM,INDL)                                     BLP12040
      VIRTXZ=DOWNX+ZV                                                   BLP12050
      VIRTXY=DOWNX+YV                                                   BLP12060
      VXYKM=VIRTXY/1000.                                                BLP12070
      VXZKM=VIRTXZ/1000.                                                BLP12080
      CALL DBTSIG(VXZKM,VXYKM,ISTAB,SIGY,SIGZ)                          BLP12090
C                                                                       BLP12100
C     IF CROSSWIND DISTANCE > 4 * SIGY, THEN THIS SOURCE SEGMENT        BLP12110
C     DOES NOT CONTRIBUTE                                               BLP12120
      IF(4.*SIGY.LT.ABS(CROSSY))GO TO 495                               BLP12130
      IF(ABS(CROSSY).LT.SIGY)IWOSIG=1                                   BLP12140
      CALL ZRISE(LNUM,INDL,I,Z)                                         BLP12150
C                                                                       BLP12160
C     INCLUDE TERRAIN CORRECTION IN DETERMINING THE PLUME HEIGHT        BLP12170
C                                                                       BLP12180
      HNT=Z+ZLINE                                                       BLP12190
C     TER1=(1.-TERAN(ISTAB)); THT=RELEV(I)-LELEV(LNUM)                  BLP12200
      TERRAN=TER1*AMIN1(HNT,THT)                                        BLP12210
      H=HNT-TERRAN                                                      BLP12220
      IF(H.GT.DPBL.AND.ISTAB.LE.4)GO TO 495                             BLP12230
C                                                                       BLP12240
C     SOLVE THE GAUSSIAN POINT SOURCE EQUATION                          BLP12250
C                                                                       BLP12260
      CALL GAUSS(CROSSY,SIGY,SIGZ,H,FT)                                 BLP12270
C     INCLUDE DECAY IN DETERMINING CHI                                  BLP12280
      DELTAT=DOWNX/WSST                                                 BLP12290
      FT=FT*(1.-DELTAT*DECFAC)                                          BLP12300
      FTSAVE(INDL)=FT                                                   BLP12310
      NCONTR=NCONTR+1                                                   BLP12320
495   INDL=INDL+IDELTA                                                  BLP12330
499   CONTINUE                                                          BLP12340
C                                                                       BLP12350
C     FIRST TIME THROUGH LOOP, CALCULATE THE FIRST CHI ESTIMATE         BLP12360
C                                                                       BLP12370
      IF(NNEW.NE.NSEG0)GO TO 714                                        BLP12380
      INDL=1                                                            BLP12390
      NSEGM1=NSEG0-1                                                    BLP12400
      SUM=(FTSAVE(1)+FTSAVE(129))/2.                                    BLP12410
      DO 712 ISEG2=2,NSEGM1                                             BLP12420
      INDL=INDL+IDELTA                                                  BLP12430
      SUM=SUM+FTSAVE(INDL)                                              BLP12440
712   CONTINUE                                                          BLP12450
C     IF RECEPTOR IS WITHIN REGION OF INFLUENCE BUT NOT DIRECTLY        BLP12460
C     DOWNWIND OF ANY PART OF THE LINE, AND SUM=0.0, CHI=0.0            BLP12470
      IF(SUM.LE.0.0.AND.IDW.NE.1)GO TO 500                              BLP12480
C                                                                       BLP12490
C     CALCULATE THE REFINED CHI ESTIMATE                                BLP12500
C                                                                       BLP12510
713   CONTINUE                                                          BLP12520
      ITER=ITER+1                                                       BLP12530
      IDIV=MIN0(ITER,2)                                                 BLP12540
      IDELTA=IDELTA/IDIV                                                BLP12550
      INDL=1+IDELTA/2                                                   BLP12560
C     INDL IS THE SUBCRIPT OF THE FIRST NEW LINE SEGMENT                BLP12570
C     (SAVE AS INDLSV)                                                  BLP12580
      INDLSV=INDL                                                       BLP12590
      NNEW=NSEGM1**ITER+0.1                                             BLP12600
C     IF MORE THAN 129 LINE SEGMENTS (I.E., 64 NEW SEGMENTS)            BLP12610
C     ARE REQUIRED, CONTINUE TO INCREASE THE NUMBER OF                  BLP12620
C     SEGMENTS BUT ONLY OVER THE SECTION OF THE LINE                    BLP12630
C     WHICH IS CONTRIBUTING                                             BLP12640
      IF(NNEW.GT.64)GO TO 759                                           BLP12650
      GO TO 498                                                         BLP12660
714   CONTINUE                                                          BLP12670
C     SUBSCRIPT OF THE FIRST NEW LINE SEGMENT IS INDLSV                 BLP12680
C     SUBSCRIPT OF THE LAST NEW LINE SEGMENT IS INDLLN                  BLP12690
      INDLLN=129-IDELTA/2                                               BLP12700
C     SUM THE FIRST AND LAST NEW LINE SEGMENTS                          BLP12710
      SUM2=FTSAVE(INDLSV)+FTSAVE(INDLLN)                                BLP12720
C     IF THERE ARE ONLY 2 NEW LINE SEGMENTS, SKIP THIS LOOP             BLP12730
      IF(NNEW.LE.2)GO TO 717                                            BLP12740
      INDL=INDLSV                                                       BLP12750
      I2=NNEW-1                                                         BLP12760
C                                                                       BLP12770
C     FIND THE SUM OF ALL THE NEW LINE SEGMENTS                         BLP12780
C                                                                       BLP12790
      DO 715 ISEG3=2,I2                                                 BLP12800
      INDL=INDL+IDELTA                                                  BLP12810
      SUM2=SUM2+FTSAVE(INDL)                                            BLP12820
715   CONTINUE                                                          BLP12830
717   CONTINUE                                                          BLP12840
C                                                                       BLP12850
C     COMPARE THE NEW ESTIMATE WITH THE PREVIOUS ESTIMATE               BLP12860
C                                                                       BLP12870
      SUM2=SUM/2.+SUM2/(2.**ITER)                                       BLP12880
C     AT LEAST ONE LINE SEGMENT MUST BE WITHIN ONE SIGMA Y OF           BLP12890
C     THE LINE (IF THE RECEPTOR IS DIRECTLY DOWNWIND OF ANY PART        BLP12900
C     OF THE LINE)                                                      BLP12910
      IF(IDW.EQ.1.AND.IWOSIG.NE.1)GO TO 758                             BLP12920
      DIFF=ABS(SUM2-SUM)                                                BLP12930
      IF(DIFF*CUQ.LT.0.1)GO TO 720                                      BLP12940
      CORR=DIFF/SUM2                                                    BLP12950
      IF(CORR.LT.CRIT)GO TO 720                                         BLP12960
758   CONTINUE                                                          BLP12970
      SUM=SUM2                                                          BLP12980
      GO TO 713                                                         BLP12990
C     IF 129 SOURCE SEGMENTS NOT SUFFICIENT, CONTINUE                   BLP13000
C     TO INCREASE NUMBER OF SEGMENTS, BUT ONLY OVER THE                 BLP13010
C     SECTION OF LINE WHICH IS CONTRIBUTING                             BLP13020
759   CONTINUE                                                          BLP13030
      CALL SORT(FTSAVE,IBMIN,IBMAX,IWPBL)                               BLP13040
      IF(IWPBL.NE.999)GO TO 4949                                        BLP13050
      IWPBL=0                                                           BLP13060
      PARTCH(I)=0.0                                                     BLP13070
      GO TO 500                                                         BLP13080
4949  CONTINUE                                                          BLP13090
      IBMAX1=IBMAX-1                                                    BLP13100
      IH=0                                                              BLP13110
      IGMAX=1                                                           BLP13120
939   CONTINUE                                                          BLP13130
      SUM2=0.0                                                          BLP13140
      XGMAX1=IGMAX+1                                                    BLP13150
      DO 940 IG=IBMIN,IBMAX1                                            BLP13160
C     XCLN = X COORDINATE (RCS) OF CURRENT (NEWEST) LINE SEGMENT        BLP13170
C     YCLN = Y COORDINATE (RCS) OF CURRENT (NEWEST) LINE SEGMENT        BLP13180
      XSEG1=XRCS(LNUM,IG)                                               BLP13190
      XDIFF=XRCS(LNUM,IG+1)-XSEG1                                       BLP13200
      YSEG1=YRCS(LNUM,IG)                                               BLP13210
      YDIFF=YRCS(LNUM,IG+1)-YSEG1                                       BLP13220
      DO 940 IGSUB=1,IGMAX                                              BLP13230
      WEIGHT=FLOAT(IGSUB)/XGMAX1                                        BLP13240
      XCLN=XSEG1+WEIGHT*XDIFF                                           BLP13250
      YCLN=YSEG1+WEIGHT*YDIFF                                           BLP13260
      DOWNX=XRECEP-XCLN                                                 BLP13270
      CROSSY=YRECEP-YCLN                                                BLP13280
      VIRTXZ=DOWNX+ZV                                                   BLP13290
      VIRTXY=DOWNX+YV                                                   BLP13300
      VXYKM=VIRTXY/1000.                                                BLP13310
      VXZKM=VIRTXZ/1000.                                                BLP13320
      CALL DBTSIG(VXZKM,VXYKM,ISTAB,SIGY,SIGZ)                          BLP13330
      CALL ZRISE(LNUM,IG,I,Z)                                           BLP13340
C     INCLUDE TERRAIN CORRECTION IN DETERMINING THE PLUME HEIGHT        BLP13350
      HNT=Z+ZLINE                                                       BLP13360
C     TER1=(1.-TERAN(ISTAB)); THT=RELEV(I)-LELEV(LNUM)                  BLP13370
      TERRAN=TER1*AMIN1(HNT,THT)                                        BLP13380
      H=HNT-TERRAN                                                      BLP13390
      CALL GAUSS(CROSSY,SIGY,SIGZ,H,FT)                                 BLP13400
C     INCLUDE DECAY IN DETERMINING CHI                                  BLP13410
      DELTAT=DOWNX/WSST                                                 BLP13420
      FT=FT*(1.-DELTAT*DECFAC)                                          BLP13430
      SUM2=SUM2+FT                                                      BLP13440
      NCONTR=NCONTR+1                                                   BLP13450
940   CONTINUE                                                          BLP13460
C     COMPARE THE NEW ESTIMATE WITH THE PREVIOUS ESTIMATE               BLP13470
      SUM2=SUM/2.+SUM2/(2.**ITER)                                       BLP13480
      DIFF=ABS(SUM2-SUM)                                                BLP13490
      IF(DIFF*CUQ.LT.0.1)GO TO 720                                      BLP13500
      CORR=DIFF/SUM2                                                    BLP13510
      IF(CORR.LT.CRIT)GO TO 720                                         BLP13520
      SUM=SUM2                                                          BLP13530
      ITER=ITER+1                                                       BLP13540
      IF(ITER.GE.MAXIT)GO TO 599                                        BLP13550
      IH=IH+1                                                           BLP13560
      IGMAX=2**IH                                                       BLP13570
      GO TO 939                                                         BLP13580
720   CONTINUE                                                          BLP13590
      SUM=SUM2                                                          BLP13600
C     TEST TO MAKE SURE AT LEAST TWO LINE SEGMENTS CONTRIBUTED          BLP13610
C     TO THE CHI ESTIMATE                                               BLP13620
C     (UNLESS RECEPTOR IS ON THE UPWIND SIDE OF THE LINE WITH           BLP13630
C     SOME SOURCE SEGMENTS DOWNWIND AND SOME SOURCE SEGMENTS            BLP13640
C     UPWIND -- IN THAT CASE JUST USE THE TEST FOR CONVERGENCE)         BLP13650
      IF(NCONTR.LT.2)GO TO 713                                          BLP13660
C     CALCULATE CONCENTRATION (IN MICROGRAMS)                           BLP13670
C     USE STACK HEIGHT WIND SPEED FOR DILUTION                          BLP13680
      PARTCH(I)=CUQ*SUM                                                 BLP13690
      CHIL(I)=CHIL(I)+PARTCH(I)                                         BLP13700
      GO TO 500                                                         BLP13710
599   WRITE(6,600)MAXIT,I,LNUM,CORR,CRIT,ITER,IHOUR,JDAY,IYR            BLP13720
600   FORMAT(//'0','TOO MANY ITERATIONS IN LINE SOURCE CALCULATIONS',   BLP13730
     1 ' -- MAXIT = ',I2/1X,'RECEPTOR ',I3,                             BLP13740
     1 ' PROBABLY TOO CLOSE TO LINE ',I2/                               BLP13750
     2 1X,'CORR = ',F6.2/1X,'CRIT = ',F6.2/1X,'ITER = ',I3/             BLP13760
     3 1X,'(IHOUR,JDAY,IYR) = ','(',I2,',',I3,',',I2,')')               BLP13770
      JITCT=JITCT+1                                                     BLP13780
      IF(JITCT.GT.100)GO TO 6491                                        BLP13790
      SUM=SUM2                                                          BLP13800
      PARTCH(I)=CUQ*SUM                                                 BLP13810
      CHIL(I)=CHIL(I)+PARTCH(I)                                         BLP13820
      GO TO 500                                                         BLP13830
6491  WRITE(6,6492)                                                     BLP13840
6492  FORMAT(//'0','TOO MANY EXCEEDENCES OF LINE SOURCE ',              BLP13850
     1 'ITERATION MAXIMUM -- EXECUTION TERMINATING')                    BLP13860
C     CALL WAUDIT
      STOP                                                              BLP13870
500   CONTINUE                                                          BLP13880
      IF(IPCL(LNUM).EQ.1)CALL OUTPUT(LNUM,PARTCH,NREC,RCOMPR)           BLP13890
1000  CONTINUE                                                          BLP13900
      IF(IPCL(11).EQ.1)CALL OUTPUT(11,CHIL,NREC,RCOMPR)                 BLP13910
C                                                                       BLP13920
C     CALCULATE PARTIAL CONCENTRATIONS DUE TO THE POINT SOURCES         BLP13930
C                                                                       BLP13940
C     LOOP OVER POINTS                                                  BLP13950
C                                                                       BLP13960
2000  IF(NPTS.LT.1)GO TO 9999                                           BLP13970
      IF(ISTAB.GT.4)SQRTS=SQRT(S)                                       BLP13980
      DO 2100 NUMPT=1,NPTS                                              BLP13990
      ZB=PELEV(NUMPT)                                                   BLP14000
      XSTACK=XPRCS(NUMPT)                                               BLP14010
      YSTACK=YPRCS(NUMPT)                                               BLP14020
      ZSTACK=PHS(NUMPT)                                                 BLP14030
      WSST=WS*(ZSTACK/ZMEAS)**P                                         BLP14040
      CUQ=PQ(NUMPT)/WSST                                                BLP14050
      BUOYFX=APTS(NUMPT)*(TSTACK(NUMPT)-TDEGK)                          BLP14060
      IF(ISTAB.GT.4)GO TO 7150                                          BLP14070
C     CALCULATE DISTANCE TO FINAL RISE                                  BLP14080
      IF(BUOYFX.GT.55.)GO TO 7010                                       BLP14090
C     THE CONSTANT 49. = 3.5*14.                                        BLP14100
      XSMT=49.*BUOYFX**0.625                                            BLP14110
      GO TO 7015                                                        BLP14120
7010  XSMT=3.5*CONST3*BUOYFX**0.4                                       BLP14130
      GO TO 7015                                                        BLP14140
7150  XSMT=3.14159*WSST/SQRTS                                           BLP14150
7015  CONTINUE                                                          BLP14160
C                                                                       BLP14170
C     IF THE POINT SOURCE BUILDING DOWNWASH OPTION IS REQUESTED,        BLP14180
C     DETERMINE THE EFFECTS (IF ANY) OF BUILDING DOWNWASH               BLP14190
C                                                                       BLP14200
      ZV=0.0                                                            BLP14210
      YV=0.0                                                            BLP14220
      IF(IDOWNW(NUMPT).NE.1)GO TO 512                                   BLP14230
C     CALCULATE THE MOMENTUM RISE AT A DOWNWIND DISTANCE OF 2.*HB       BLP14240
C     FM3 = 3.*FM (I.E., 3.*VERTICAL MOMENTUM FLUX TERM)                BLP14250
      FM3=BPTS(NUMPT)*TDEGK                                             BLP14260
      BETAM=0.3333333+WSST/VEXIT(NUMPT)                                 BLP14270
      IF(ISTAB.GT.4)GO TO 509                                           BLP14280
      EFFHT=ZSTACK+(FM3*TWOHB/(BETAM*BETAM*WSST*WSST))**0.3333333       BLP14290
      GO TO 511                                                         BLP14300
509   EFFHT=ZSTACK+(FM3*SIN(SQRTS*TWOHB/WSST)/                          BLP14310
     1 (BETAM*BETAM*WSST*SQRTS))**0.3333333                             BLP14320
511   CONTINUE                                                          BLP14330
      RATIO=EFFHT/HB                                                    BLP14340
      RATIO=AMAX1(RATIO,1.0)                                            BLP14350
C     IF RATIO GE 3.0, SIGY AND SIGZ ARE NOT MODIFIED                   BLP14360
C     IF RATIO LT 3.0 AND GT 1.2, ONLY SIGZ IS MODIFIED                 BLP14370
C     IF RATIO LE 1.2, BOTH SIGY AND SIGZ ARE MODIFIED                  BLP14380
      IF(RATIO.GE.3.0)GO TO 512                                         BLP14390
      R0Z=HB*(1.5-RATIO/2.)                                             BLP14400
      SZ0=SRT2DP*R0Z                                                    BLP14410
      ZV=1000.*XVZ(SZ0,ISTAB)                                           BLP14420
      A=5.0*R0Z                                                         BLP14430
      B=8.3333333*R0Z*R0Z                                               BLP14440
      IF(RATIO.GT.1.2)GO TO 512                                         BLP14450
      R0Y=HB*(6.-5.*RATIO)/2.                                           BLP14460
      SY0=SRT2DP*R0Y                                                    BLP14470
      YV=1000.*XVY(SY0,ISTAB)                                           BLP14480
512   CONTINUE                                                          BLP14490
C                                                                       BLP14500
C     LOOP OVER RECEPTORS                                               BLP14510
C                                                                       BLP14520
      DO 2050 I=1,NREC                                                  BLP14530
      PARTCH(I)=0.0                                                     BLP14540
      DOWNX=XRRCS(I)-XSTACK                                             BLP14550
      IF(DOWNX.LE.0.0)GO TO 2050                                        BLP14560
      CROSSY=YRRCS(I)-YSTACK                                            BLP14570
      VIRTXZ=DOWNX+ZV                                                   BLP14580
      VIRTXY=DOWNX+YV                                                   BLP14590
      VXZKM=VIRTXZ/1000.                                                BLP14600
      VXYKM=VIRTXY/1000.                                                BLP14610
      CALL DBTSIG(VXZKM,VXYKM,ISTAB,SIGY,SIGZ)                          BLP14620
      IF(4.*SIGY.LT.ABS(CROSSY))GO TO 2050                              BLP14630
      IF(IDOWNW(NUMPT).NE.1)GO TO 1517                                  BLP14640
      ZSAVE=9999.                                                       BLP14650
C                                                                       BLP14660
C     IF THE SHEAR AND DOWNWASH OPTIONS ARE BOTH REQUESTED,             BLP14670
C     USE THE MINIMUM OF Z(SHEAR) AND Z(DOWNWASH)                       BLP14680
C                                                                       BLP14690
      IF(LSHEAR)CALL PTRISE(BUOYFX,ZSTACK,XSMT,DOWNX,WSST,ZSAVE,LSHEAR, BLP14700
     1 LTRANS)                                                          BLP14710
      IF(ISTAB.GT.4)GO TO 1515                                          BLP14720
1514  CONTINUE                                                          BLP14730
      EXR=AMIN1(DOWNX,XSMT)                                             BLP14740
      IF(.NOT.LTRANS)EXR=XSMT                                           BLP14750
      IF(.NOT.LTRANS.AND.ISTAB.GE.5)EXR=2.*WSST/SQRT(S)                 BLP14760
      C=-4.16666667*BUOYFX*EXR*EXR/WSST**3                              BLP14770
      GO TO 1516                                                        BLP14780
1515  IF(DOWNX.LT.2.*WSST/SQRT(S))GO TO 1514                            BLP14790
      C=-16.666667*BUOYFX/(WSST*S)                                      BLP14800
1516  CONTINUE                                                          BLP14810
      CALL CUBIC(A,B,C,Z)                                               BLP14820
      Z=AMIN1(Z,ZSAVE)                                                  BLP14830
      GO TO 1518                                                        BLP14840
1517  CONTINUE                                                          BLP14850
      CALL PTRISE(BUOYFX,ZSTACK,XSMT,DOWNX,WSST,Z,LSHEAR,LTRANS)        BLP14860
1518  CONTINUE                                                          BLP14870
      HNT=Z+ZSTACK                                                      BLP14880
      THT=RELEV(I)-ZB                                                   BLP14890
C     TER1=(1.-TERAN(ISTAB))                                            BLP14900
      TERRAN=TER1*AMIN1(HNT,THT)                                        BLP14910
      H=HNT-TERRAN                                                      BLP14920
      IF(H.GT.DPBL.AND.ISTAB.LE.4)GO TO 2050                            BLP14930
      CALL GAUSS(CROSSY,SIGY,SIGZ,H,FT)                                 BLP14940
C     INCLUDE DECAY IN DETERMINING CHI                                  BLP14950
      DELTAT=DOWNX/WSST                                                 BLP14960
      FT=FT*(1.-DELTAT*DECFAC)                                          BLP14970
      PARTCH(I)=CUQ*FT                                                  BLP14980
      CHI(I)=CHI(I)+PARTCH(I)                                           BLP14990
2050  CONTINUE                                                          BLP15000
      ICODE=100+NUMPT                                                   BLP15010
      IF(IPCP(NUMPT).EQ.1)CALL OUTPUT(ICODE,PARTCH,NREC,RCOMPR)         BLP15020
2100  CONTINUE                                                          BLP15030
      IF(IPCP(51).EQ.1)CALL OUTPUT(151,CHI,NREC,RCOMPR)                 BLP15040
9999  CONTINUE                                                          BLP15050
      DO 9050 I=1,NREC                                                  BLP15060
      CHI(I)=CHI(I)+CHIL(I)+XBACKG                                      BLP15070
9050  CONTINUE                                                          BLP15080
      CALL OUTPUT(999,CHI,NREC,RCOMPR)                                  BLP15090
      RETURN                                                            BLP15100
      END                                                               BLP15110
C
      SUBROUTINE GAUSS(CROSSY,SIGY,SIGZ,H,FT)                           BLP15120
C                                                                       BLP15130
C                                                                       BLP15140
      COMMON/METD/ZMEAS,WS,WD,ISTAB,TDEGK,DPBL,THETA,S,P,IYR,JDAY,IHOUR BLP15150
      COMMON/PBLDAT/TWOPBL,PBL1P6                                       BLP15160
      DATA TMIN/0.0512/,TMAX/9.21/                                      BLP15170
      TD1=3.1415927*SIGY*SIGZ                                           BLP15180
      YPSIG=CROSSY/SIGY                                                 BLP15190
      EXPYP=0.5*YPSIG*YPSIG                                             BLP15200
C     PREVENT UNDERFLOWS                                                BLP15210
      IF(EXPYP.GT.50.)GO TO 495                                         BLP15220
      F=EXP(-EXPYP)                                                     BLP15230
      GO TO 496                                                         BLP15240
495   F=0.0                                                             BLP15250
      GO TO 443                                                         BLP15260
496   CONTINUE                                                          BLP15270
C     IF MIXING HEIGHT (DPBL) GE 5000 M OR FOR STABLE CONDITIONS,       BLP15280
C     NEGLECT THE REFLECTION TERMS                                      BLP15290
      IF(ISTAB.GE.5.OR.DPBL.GT.5000.)GO TO 451                          BLP15300
C     IF SIGZ GT 1.6*DPBL, ASSUME A UNIFORM VERTICAL DISTRIBUTION       BLP15310
      IF(SIGZ.GT.PBL1P6)GO TO 460                                       BLP15320
C     CALCULATE MULTIPLE EDDY REFLECTIONS TERMS                         BLP15330
C     USING A FOURIER SERIES METHOD -- SEE ERT MEMO CS 093              BLP15340
      F1=1                                                              BLP15350
      T=(SIGZ/DPBL)**2                                                  BLP15360
      H2=H/DPBL                                                         BLP15370
      IF(T.GE.0.6)GO TO 500                                             BLP15380
      ARG=2.*(1.-H2)/T                                                  BLP15390
      IF(ARG.GE.TMAX)GO TO 400                                          BLP15400
      IF(ARG.LT.TMIN)F1=F1+1.-ARG                                       BLP15410
      IF(ARG.GE.TMIN)F1=F1+EXP(-ARG)                                    BLP15420
      ARG=2.*(1.+H2)/T                                                  BLP15430
      IF(ARG.GE.TMAX)GO TO 400                                          BLP15440
      F1=F1+EXP(-ARG)                                                   BLP15450
      ARG=4.*(2.-H2)/T                                                  BLP15460
      IF(ARG.GE.TMAX)GO TO 400                                          BLP15470
      F1=F1+EXP(-ARG)                                                   BLP15480
      ARG=4.*(2.+H2)/T                                                  BLP15490
      IF(ARG.LT.TMAX)F1=F1+EXP(-ARG)                                    BLP15500
400   ARG=-0.5*H2*H2/T                                                  BLP15510
      IF(ARG.LT.-90.)F1=0.0                                             BLP15520
C     CONSTANT 0.797885 = SQRT(2./PI)                                   BLP15530
      IF(ARG.GE.-90.)F1=0.797885*F1*EXP(ARG)/SIGZ                       BLP15540
      IF(F1.LT.1.E-30)F1=0.0                                            BLP15550
      GO TO 1500                                                        BLP15560
C     CONSTANT 4.934802 = PI*PI/2.                                      BLP15570
500   ARG=4.934802*T                                                    BLP15580
      IF(ARG.GE.TMAX)GO TO 900                                          BLP15590
      F1=F1+2.*EXP(-ARG)*COS(3.141593*H2)                               BLP15600
C     CONSTANT 19.739209 = 2.*PI*PI                                     BLP15610
      ARG=19.739209*T                                                   BLP15620
      IF(ARG.LT.TMAX)F1=F1+2.*EXP(-ARG)*COS(6.283185*H2)                BLP15630
900   F1=F1/DPBL                                                        BLP15640
      IF(F1.LT.1.E-30)F1=0.0                                            BLP15650
1500  CONTINUE                                                          BLP15660
C     THE CONSTANT 1.25331414 = SQRT(PI/2.)                             BLP15670
      F1=1.25331414*SIGZ*F1                                             BLP15680
      GO TO 445                                                         BLP15690
451   CONTINUE                                                          BLP15700
      HPSIG=H/SIGZ                                                      BLP15710
      EXPHP=0.5*HPSIG*HPSIG                                             BLP15720
      IF(EXPHP.GT.50)GO TO 443                                          BLP15730
      F1=EXP(-EXPHP)                                                    BLP15740
      GO TO 445                                                         BLP15750
443   F1=0.0                                                            BLP15760
445   CONTINUE                                                          BLP15770
C     FIND PRODUCT OF EXPONENTIAL TERMS DIVIDED BY (PI*SIGY*SIGZ)       BLP15780
      FT=F*F1/TD1                                                       BLP15790
      GO TO 470                                                         BLP15800
460   CONTINUE                                                          BLP15810
C     VERTICAL DISTRIBUTION ASSUMED UNIFORM                             BLP15820
C     THE CONSTANT 2.5066283 = SQRT(2.*PI)                              BLP15830
      FT=F/(2.5066283*SIGY*DPBL)                                        BLP15840
470   RETURN                                                            BLP15850
      END                                                               BLP15860
C
      SUBROUTINE SORT(FTSAVE,IBMIN,IBMAX,IWPBL)                         BLP15870
C                                                                       BLP15880
C                                                                       BLP15890
      REAL FTSAVE(129)                                                  BLP15900
      ISAFE=0                                                           BLP15910
      IB=0                                                              BLP15920
      IF(FTSAVE(129).NE.0.0)IB=129                                      BLP15930
      IF(FTSAVE(1).NE.0.0)IB=1                                          BLP15940
      IF(IB.NE.0)GO TO 970                                              BLP15950
      DO 950 ILEVEL=1,7                                                 BLP15960
      NEACHL=2**(ILEVEL-1)                                              BLP15970
      INCR=2**(8-ILEVEL)                                                BLP15980
      INDEX=1+INCR/2                                                    BLP15990
      DO 945 NC=1,NEACHL                                                BLP16000
      IF(FTSAVE(INDEX).EQ.0.0)GO TO 944                                 BLP16010
      IB=INDEX                                                          BLP16020
      GO TO 970                                                         BLP16030
944   INDEX=INDEX+INCR                                                  BLP16040
945   CONTINUE                                                          BLP16050
950   CONTINUE                                                          BLP16060
      IF(IB.NE.0)GO TO 970                                              BLP16070
      IWPBL=999                                                         BLP16080
      RETURN                                                            BLP16090
970   IBMIN=IB-1                                                        BLP16100
      IBMAX=IB+1                                                        BLP16110
      IBMIN=AMAX0(IBMIN,1)                                              BLP16120
      IBMAX=AMIN0(IBMAX,129)                                            BLP16130
975   CONTINUE                                                          BLP16140
      INCRM=0                                                           BLP16150
      INCRP=0                                                           BLP16160
      IF(FTSAVE(IBMIN).NE.0.0)INCRM=1                                   BLP16170
      IF(IBMIN.EQ.1)INCRM=0                                             BLP16180
      IF(FTSAVE(IBMAX).NE.0.0)INCRP=1                                   BLP16190
      IF(IBMAX.EQ.129)INCRP=0                                           BLP16200
      IBMIN=IBMIN-INCRM                                                 BLP16210
      IBMAX=IBMAX+INCRP                                                 BLP16220
      IF(INCRM.EQ.0.AND.INCRP.EQ.0)GO TO 980                            BLP16230
      ISAFE=ISAFE+1                                                     BLP16240
      IF(ISAFE.GT.129)GO TO 980                                         BLP16250
      GO TO 975                                                         BLP16260
980   CONTINUE                                                          BLP16270
      RETURN                                                            BLP16280
      END                                                               BLP16290
C
      SUBROUTINE OUTPUT(ICODE,CHIS,NREC,RCOMPR)                         BLP16300
C                                                                       BLP16310
C                                                                       BLP16320
      REAL CHIS(NREC)                                                   BLP16330
      LOGICAL RCOMPR                                                    BLP16340
      COMMON/METD/ZMEAS,WS,WD,ISTAB,TDEGK,DPBL,THETA,S,P,IYR,JDAY,IHOUR BLP16350
C                                                                       BLP16360
C     THIS SUBROUTINE OUTPUTS ALL CHI ARRAYS TO TAPE (OR DISK)          BLP16370
C                                                                       BLP16380
C     ICODE IDENTIFIES THE CHI ARRAY TO FOLLOW:                         BLP16390
C                                                                       BLP16400
C     ICODE = 1 TO 10 IMPLIES THE CHI ARRAY IS THE PARTIAL              BLP16410
C     CONTRIBUTION OF LINE NUMBER "ICODE" AT EACH RECEPTOR              BLP16420
C                                                                       BLP16430
C     ICODE = 11 IMPLIES THE CHI ARRAY IS THE PARTIAL                   BLP16440
C     CONTRIBUTION OF ALL THE LINES AT EACH RECEPTOR                    BLP16450
C                                                                       BLP16460
C     ICODE = 101 TO 150 IMPLIES THE CHI ARRAY IS THE PARTIAL           BLP16470
C     CONTRIBUTION OF POINT SOURCE NUMBER "ICODE - 100" AT              BLP16480
C     EACH RECEPTOR                                                     BLP16490
C                                                                       BLP16500
C     ICODE = 151 IMPLIES THE CHI ARRAY IS THE PARTIAL                  BLP16510
C     CONTRIBUTION OF ALL THE POINT SOURCES AT EACH RECEPTOR            BLP16520
C                                                                       BLP16530
C     ICODE = 999 IMPLIES THE CHI ARRAY IS THE TOTAL                    BLP16540
C     CONCENTRATION SUMMED OVER ALL THE POINT AND LINE SOURCES AT       BLP16550
C     EACH RECEPTOR                                                     BLP16560
      IDAYHR=JDAY*100+IHOUR                                             BLP16570
C     ROUND THE WS (NEAREST TENTHS OF M/S) AND                          BLP16580
C     THE DPBL (NEAREST METER)                                          BLP16590
      IWS=(WS+0.05)*10                                                  BLP16600
      IDPBL=DPBL+0.5                                                    BLP16610
      IWD=WD                                                            BLP16620
      ICD=IWS*10000+ISTAB*1000+ICODE                                    BLP16630
      IMET2=IWD*10000+IDPBL                                             BLP16640
      IF(RCOMPR)GO TO 10                                                BLP16650
      WRITE(20)IDAYHR,ICD,IMET2,CHIS                                    BLP16660
      RETURN                                                            BLP16670
10    CONTINUE                                                          BLP16680
      CALL COMPRS(IDAYHR,ICD,IMET2,NREC,CHIS)                           BLP16690
      RETURN                                                            BLP16700
      END                                                               BLP16710
C
      SUBROUTINE PTRISE(BUOYFX,ZSTACK,XSMT,DOWNX,WSST,Z,LSHEAR,LTRANS)  BLP16720
C                                                                       BLP16730
C                                                                       BLP16740
      LOGICAL LSHEAR,LTRANS                                             BLP16750
      COMMON/METD/ZMEAS,WS,WD,ISTAB,TDEGK,DPBL,THETA,S,P,IYR,JDAY,IHOUR BLP16760
      COMMON/PARM/CRIT,TER1,DECFAC,XBACKG,CONST2,CONST3,MAXIT           BLP16770
C                                                                       BLP16780
C     THIS SUBROUTINE CALCULATES POINT SOURCE PLUME RISE                BLP16790
C     WITH AN OPTIONAL VERTICAL WIND SPEED SHEAR CORRECTION FOR         BLP16800
C     BOTH NEUTRAL AND STABLE PLUME RISE                                BLP16810
C                                                                       BLP16820
C     A VALUE OF 0.6 IS ASSUMED FOR THE ENTRAINMENT                     BLP16830
C     PARAMETER (BETA)                                                  BLP16840
C                                                                       BLP16850
      X=DOWNX                                                           BLP16860
      IF(.NOT.LSHEAR)GO TO 145                                          BLP16870
C     CONSTANT 2.777778 = 1./(BETA*BETA) WITH BETA=0.6                  BLP16880
      CS=2.777778*BUOYFX                                                BLP16890
      CS2=ZSTACK**P                                                     BLP16900
      EP=3.*(1.+P)                                                      BLP16910
      P3=3.+P                                                           BLP16920
      TP3=2.*P3                                                         BLP16930
145   CONTINUE                                                          BLP16940
      X=AMIN1(X,XSMT)                                                   BLP16950
      IF(.NOT.LTRANS)X=XSMT                                             BLP16960
      IF(ISTAB.GT.4)GO TO 150                                           BLP16970
      IF(.NOT.LSHEAR)GO TO 170                                          BLP16980
C                                                                       BLP16990
C     NEUTRAL-UNSTABLE PLUME RISE WITH SHEAR                            BLP17000
C                                                                       BLP17010
16    CONTINUE                                                          BLP17020
C     BETA (ENTRAINMENT PARAMETER) IS ASSUMED TO BE 0.6                 BLP17030
      A1=CS*X*X/WSST**3                                                 BLP17040
C     CONSTANT 0.8735805 = (2./3.)**(1./3.)                             BLP17050
      RMULT=0.8735805*(EP*EP*CS2**3/(TP3*A1**P))**(1./EP)               BLP17060
      RMULT=AMIN1(RMULT,1.0)                                            BLP17070
      Z=RMULT*(1.5*A1)**0.333333                                        BLP17080
      IF(ISTAB.LE.4)GO TO 39                                            BLP17090
      Z=AMIN1(Z,(6./CSV1)**0.333333)                                    BLP17100
      Z=AMIN1(Z,5.0*BUOYFX**0.25/S**0.375)                              BLP17110
39    CONTINUE                                                          BLP17120
      RETURN                                                            BLP17130
C                                                                       BLP17140
C     NEUTRAL-UNSTABLE PLUME RISE -- NO SHEAR                           BLP17150
C                                                                       BLP17160
170   CONTINUE                                                          BLP17170
      Z=1.6*(BUOYFX*X*X)**0.333333/WSST                                 BLP17180
      IF(ISTAB.GT.4)Z=AMIN1(Z,ZB)                                       BLP17190
      RETURN                                                            BLP17200
C                                                                       BLP17210
C     STABLE PLUME RISE -- NO SHEAR                                     BLP17220
C                                                                       BLP17230
175   CONTINUE                                                          BLP17240
      ZMTT=5.0*BUOYFX**0.25/S**0.375                                    BLP17250
C     CONST2 HAS A DEFAULT VALUE OF 2.6 (BRIGGS, 1975)                  BLP17260
      ZB=CONST2*(BUOYFX/(WSST*S))**0.333333                             BLP17270
      ZB=AMIN1(ZB,ZMTT)                                                 BLP17280
      IF(X.LT.XSMT)GO TO 170                                            BLP17290
      Z=ZB                                                              BLP17300
      RETURN                                                            BLP17310
C                                                                       BLP17320
C     STABLE PLUME RISE WITH SHEAR                                      BLP17330
C                                                                       BLP17340
150   CONTINUE                                                          BLP17350
      IF(.NOT.LSHEAR)GO TO 175                                          BLP17360
      XPFS=SQRT((TP3*CS2*CS/(WSST*S))**(EP/P3)*TP3*WSST**3/(EP*EP*CS2**3BLP17370
     1 *CS))                                                            BLP17380
      CSV1=WSST*S/CS                                                    BLP17390
      IF(X.LT.XPFS)GO TO 16                                             BLP17400
C     CONSTANT 0.5503212 = (1./6.)**(1./3.)                             BLP17410
      RMULT=0.5503212*CSV1**(P/(3.*P3))*(TP3*CS2)**(1./P3)              BLP17420
      RMULT=AMIN1(RMULT,1.0)                                            BLP17430
      Z=RMULT*(6./CSV1)**0.333333                                       BLP17440
      Z=AMIN1(Z,5.0*BUOYFX**0.25/S**0.375)                              BLP17450
      RETURN                                                            BLP17460
      END                                                               BLP17470
C
      SUBROUTINE CUBIC(A,B,C,Z)                                         BLP17480
C                                                                       BLP17490
C                                                                       BLP17500
C                                                                       BLP17510
C     SOLVES FOR ONE ROOT OF THE CUBIC EQUATION:                        BLP17520
C     Z**3 + A*Z**2 + B*Z + C = 0                                       BLP17530
C                                                                       BLP17540
      IMPLICIT  DOUBLE PRECISION (A-H,O-Z)                              XXX17545
      REAL A,B,C,Z                                                      XXX17547
      DATA ONE/1.0/                                                     BLP17550
      A3=A/3.                                                           BLP17560
      AP=B-A*A3                                                         BLP17570
      BP=2.*A3**3-A3*B+C                                                BLP17580
      AP3=AP/3.                                                         BLP17590
      BP2=BP/2.                                                         BLP17600
      TROOT=BP2*BP2+AP3*AP3*AP3                                         BLP17610
      IF(TROOT.LE.0.0)GO TO 50                                          BLP17620
      TR=SQRT(TROOT)                                                    BLP17630
      APP=(-BP2+TR)**0.333333                                           BLP17640
      BSV=-BP2-TR                                                       BLP17650
      IF(BSV .EQ. 0) GO TO 45                                           XXX17655
      SGN=SIGN(ONE,BSV)                                                 BLP17660
      BPP=SGN*(ABS(BSV))**0.333333                                      BLP17670
      Z=APP+BPP-A3                                                      BLP17680
      RETURN                                                            BLP17690
   45 CONTINUE                                                          XXX17691
C     BSV (& BPP) = 0.0                                                 XXX17692
      Z=APP-A3                                                          XXX17693
      RETURN                                                            XXX17694
50    CM=2.*SQRT(-AP3)                                                  BLP17700
      ALPHA=ACOS(BP/(AP3*CM))/3.                                        BLP17710
      Z=CM*COS(ALPHA)-A3                                                BLP17720
      RETURN                                                            BLP17730
      END                                                               BLP17740
C
      SUBROUTINE WSC(ISTAB,UM,U,S,P)                                    BLP17750
C                                                                       BLP17760
C                                                                       BLP17770
      REAL L                                                            BLP17780
      LOGICAL LSHEAR,LTRANS                                             BLP17790
      COMMON/PR/L,HB,WB,WM,FPRIME,FP,XMATCH,DX,AVFACT,TWOHB,N,LSHEAR,   BLP17800
     1 LTRANS                                                           BLP17810
C     CALCULATES AN EFFECTIVE U USING THE LINE SOURCE PLUME             BLP17820
C     RISE EQUATION (LINE SOURCE TERM ONLY)                             BLP17830
C     MATCHED AT X = XF (FINAL RISE)                                    BLP17840
      IF(ISTAB.GT.4)GO TO 50                                            BLP17850
C                                                                       BLP17860
C     NEUTRAL (OR UNSTABLE) CONDITIONS                                  BLP17870
C                                                                       BLP17880
      P3=3.*P                                                           BLP17890
      EP=2.+P3                                                          BLP17900
      EPI=1./EP                                                         BLP17910
C     CONSTANT 2.4=4.*BETA WITH BETA=0.6                                BLP17920
      T1=(EP*EP*N*FPRIME*HB**P3/(2.4*(2.+P)*L*UM**3))**EPI              BLP17930
      Z=T1*XMATCH**(2.*EPI)                                             BLP17940
C     CONSTANT 1.2 = 2.*BETA WITH BETA=0.6                              BLP17950
      U=(N*FPRIME/(1.2*L)*(XMATCH/Z)**2)**0.333333                      BLP17960
      U=AMAX1(U,UM)                                                     BLP17970
      RETURN                                                            BLP17980
50    CONTINUE                                                          BLP17990
C                                                                       BLP18000
C     STABLE CONDITIONS                                                 BLP18010
C                                                                       BLP18020
      P2=2.+P                                                           BLP18030
C     CONSTANT 0.6 = BETA                                               BLP18040
      Z=(P2*HB**P*N*FPRIME/(0.6*L*UM*S))**(1./P2)                       BLP18050
C     CONSTANT 3.3333333 = 2./BETA WITH BETA=0.6                        BLP18060
      U=3.3333333*N*FPRIME/(L*S*Z*Z)                                    BLP18070
      U=AMAX1(U,UM)                                                     BLP18080
      RETURN                                                            BLP18090
      END                                                               BLP18100
C
      SUBROUTINE LENG(THETA,U)                                          BLP18110
C                                                                       BLP18120
C                                                                       BLP18130
      REAL L,LEFF,LD,LEFF1,LEFFV                                        BLP18140
      LOGICAL LSHEAR,LTRANS                                             BLP18150
      COMMON/PR/L,HB,WB,WM,FPRIME,FP,XMATCH,DX,AVFACT,TWOHB,N,LSHEAR,   BLP18160
     1 LTRANS                                                           BLP18170
      COMMON/PRLS/XFB,LEFF,LD,R0,XFINAL,XFS                             BLP18180
      DATA RAD/0.0174533/                                               BLP18190
C                                                                       BLP18200
C     THIS SUBROUTINE CALCULATES XFB,LEFF,LD,R0                         BLP18210
C                                                                       BLP18220
C     FPRIME IS THE BUOYANCY FLUX OF ONE LINE; FP IS THE EFFECTIVE      BLP18230
C     BUOYANCY FLUX OF N LINES                                          BLP18240
      FP=N*FPRIME                                                       BLP18250
      TRAD=THETA*RAD                                                    BLP18260
      SINT=ABS(SIN(TRAD))                                               BLP18270
      COST=ABS(COS(TRAD))                                               BLP18280
C     CALCULATE DISTANCE OF FULL BUOYANCY (XFB)                         BLP18290
      DXM=DX+WB                                                         BLP18300
      XFB=L*COST+(N-1)*DXM*SINT                                         BLP18310
C     CALCULATE EFFECTIVE LINE SOURCE LENGTH (LEFF) AND                 BLP18320
C     EFFECTIVE DOWNWASH LINE LENGTH (LD)                               BLP18330
      LEFF1=L*SINT                                                      BLP18340
      IF(N.EQ.1)GO TO 112                                               BLP18350
C     CONSTANT 0.8333333 = 1./(2.*BETA) WITH BETA=0.6                   BLP18360
      ZI=0.8333333*DXM                                                  BLP18370
C     CONSTANT 2.2619467 = 2.*PI*BETA*BETA WITH BETA=0.6                BLP18380
C     CONSTANT 1.5915494 = 3./(PI*BETA) WITH BETA=0.6                   BLP18390
      T1=(2.2619467*U**3/FPRIME)*ZI*ZI*(ZI+1.5915494*WM)                BLP18400
      XI=(T1*L)**0.333333                                               BLP18410
      IF(XI.LE.L)GO TO 55                                               BLP18420
      XI=L/2.+SQRT(12.*T1-3.*L*L)/6.                                    BLP18430
C     CONSTANT 1.2 = 2.*BETA WITH BETA=0.6                              BLP18440
C     CONSTANT 0.6283185 = PI*BETA/3. WITH BETA=0.6                     BLP18450
      LEFFV=FP*(L*L/3.+XI*(XI-L))/(1.2*U**3*ZI*ZI)-0.6283185*ZI         BLP18460
      GO TO 110                                                         BLP18470
55    CONTINUE                                                          BLP18480
C     CONSTANT 3.6 = 6.*BETA WITH BETA=0.6                              BLP18490
C     CONSTANT 0.6283185 = PI*BETA/3. WITH BETA=0.6                     BLP18500
      LEFFV=FP/(3.6*L*ZI*ZI)*(XI/U)**3-0.6283185*ZI                     BLP18510
110   LEFF=LEFF1+LEFFV*COST                                             BLP18520
      LD=LEFF*SINT                                                      BLP18530
C     CALCULATE DOWNWASHED EDGE RADIUS                                  BLP18540
      R0=AMIN1(HB,LD)/AVFACT                                            BLP18550
      RETURN                                                            BLP18560
C     IF N = 1, NO INTERACTION AT ANY X, I.E.,                          BLP18570
C     LEFFV = WM; FP = FPRIME; XFB = L * COST + WM * SINT               BLP18580
112   LEFFV=WM                                                          BLP18590
      FP=FPRIME                                                         BLP18600
      XFB=XFB+WM*SINT                                                   BLP18610
      GO TO 110                                                         BLP18620
      END                                                               BLP18630
C
      SUBROUTINE RISE(U,ISTAB,S)                                        BLP18640
C                                                                       BLP18650
C                                                                       BLP18660
      REAL L,LEFF,LD                                                    BLP18670
      LOGICAL LSHEAR,LTRANS                                             BLP18680
      COMMON/PR/L,HB,WB,WM,FPRIME,FP,XMATCH,DX,AVFACT,TWOHB,N,LSHEAR,   BLP18690
     1 LTRANS                                                           BLP18700
      COMMON/PRLS/XFB,LEFF,LD,R0,XFINAL,XFS                             BLP18710
      COMMON/RINTP/XDIST(7),DH(7)                                       BLP18720
C                                                                       BLP18730
C     THIS SUBROUTINE CALCULATES LINE SOURCE PLUME RISE                 BLP18740
C     USING AN OPTIONAL VERTICAL WIND SHEAR CORRECTED 'EFFECTIVE' WIND  BLP18750
C     SPEED FOR BOTH NEUTRAL AND STABLE CONDITIONS                      BLP18760
C                                                                       BLP18770
C     CONSTANT 1.5915494 = 3./(PI*BETA) WITH BETA=0.6                   BLP18780
C     CONSTANT 5.0 = 3./BETA WITH BETA=0.6                              BLP18790
      A=1.5915494*LEFF+5.*R0                                            BLP18800
C     CONSTANT 5.3051648 = 6./(PI*BETA*BETA) WITH BETA=0.6              BLP18810
C     CONSTANT 8.3333333 = 3./(BETA*BETA) WITH BETA=0.6                 BLP18820
      B=R0*(5.3051648*LD+8.333333*R0)                                   BLP18830
      DO 1000 I=2,7                                                     BLP18840
      X=XDIST(I)                                                        BLP18850
      IF(ISTAB.LE.4)GO TO 90                                            BLP18860
C     WITH STABLE CONDITIONS, USE NEUTRAL RISE EQUATION                 BLP18870
C     FOR TRANSITIONAL RISE CALCULATIONS, BUT CALCULATE                 BLP18880
C     FINAL RISE BASED ON THE FINAL STABLE RISE EQUATION                BLP18890
      IF(X.LT.XFS)GO TO 90                                              BLP18900
C     CALCULATE FINAL (STABLE) PLUME RISE                               BLP18910
C     CONSTANT 5.3051648 = 6./(PI*BETA*BETA) WITH BETA=0.6              BLP18920
92    C=-5.3051648*FP/(U*S)                                             BLP18930
      GO TO 8                                                           BLP18940
90    CONTINUE                                                          BLP18950
      IF(X.LE.XFB)GO TO 80                                              BLP18960
7     CONTINUE                                                          BLP18970
C     CONSTANT 1.3262912 = 3./(2.*PI*BETA*BETA) WITH BETA=0.6           BLP18980
      C=-1.3262912*FP*(XFB*XFB/3.+X*X-XFB*X)/U**3                       BLP18990
8     CONTINUE                                                          BLP19000
      CALL CUBIC(A,B,C,Z)                                               BLP19010
12    CONTINUE                                                          BLP19020
      DH(I)=Z                                                           BLP19030
      GO TO 1000                                                        BLP19040
C     CONSTANT 0.4420971 = 1./(2.*PI*BETA*BETA) WITH BETA=0.6           BLP19050
80    C=-0.4420971*(FP/XFB)*(X/U)**3                                    BLP19060
      GO TO 8                                                           BLP19070
1000  CONTINUE                                                          BLP19080
      RETURN                                                            BLP19090
      END                                                               BLP19100
C
      SUBROUTINE ZRISE(IL,IS,IR,Z)                                      BLP19110
C                                                                       BLP19120
C                                                                       BLP19130
      REAL LEFF,LD,LELEV                                                BLP19140
      COMMON/RCEPT/RXBEG,RYBEG,RXEND,RYEND,RDX,RDY,XRSCS(100),          BLP19150
     1 YRSCS(100),XRRCS(100),YRRCS(100),RELEV(100),NREC                 BLP19160
      COMMON/SOURCE/NLINES,XLBEG(10),XLEND(10),DEL(10),YSCS(10),QT(10), BLP19170
     1 HS(10),XRCS(10,129),YRCS(10,129),TCOR,LELEV(10),                 BLP19180
     2 NPTS,XPSCS(50),YPSCS(50),PQ(50),PHS(50),XPRCS(50),YPRCS(50),     BLP19190
     3 TSTACK(50),APTS(50),BPTS(50),VEXIT(50),PELEV(50),IDOWNW(50)      BLP19200
      COMMON/PRLS/XFB,LEFF,LD,R0,XFINAL,XFS                             BLP19210
      COMMON/RINTP/XDIST(7),DH(7)                                       BLP19220
C                                                                       BLP19230
C     Z1 IS THE PLUME HEIGHT OF THE HIGHEST PLUME SEGMENT AT X = XFB    BLP19240
C     (EXCEPT IN THE SPECIAL CASE OF STABLE CONDITIONS WITH             BLP19250
C     THE DISTANCE TO FINAL RISE (XFS) LESS THAN XFB -- IN              BLP19260
C     THAT CASE, Z1 IS THE HEIGHT OF THE HIGHEST PLUME ELEMENT          BLP19270
C     AT X=XFS)                                                         BLP19280
C     XI IS THE DISTANCE OF THE CURRENT LINE SEGMENT TO XFB             BLP19290
C                                                                       BLP19300
      Z1=DH(2)                                                          BLP19310
      XI=XFB-XRCS(IL,IS)                                                BLP19320
      XI=AMAX1(XI,0.0)                                                  BLP19330
      XI=AMIN1(XI,XFB)                                                  BLP19340
      ZXFB=Z1*(1.-(XFB-XI)/XFB)                                         BLP19350
C     Z2 IS THE PLUME HEIGHT OF THE HIGHEST SEGMENT AT X                BLP19360
      CALL INTRSE(XRRCS(IR),Z2)                                         BLP19370
      DELTAZ=Z2-Z1                                                      BLP19380
      Z=ZXFB+DELTAZ                                                     BLP19390
      RETURN                                                            BLP19400
      END                                                               BLP19410
C
      SUBROUTINE INTRSE(X,Z)                                            BLP19420
C                                                                       BLP19430
C                                                                       BLP19440
      REAL LEFF,LD                                                      BLP19450
      COMMON/PRLS/XFB,LEFF,LD,R0,XFINAL,XFS                             BLP19460
      COMMON/RINTP/XDIST(7),DH(7)                                       BLP19470
C                                                                       BLP19480
C     THIS SUBROUTINE INTERPOLATES THE PLUME RISE OF THE TOP (HIGHEST)  BLP19490
C     PLUME ELEMENT AT ANY DISTANCE X USING THE CALCULATED              BLP19500
C     PLUME RISE AT SEVEN POINTS (XDIST(1-7))                           BLP19510
C                                                                       BLP19520
      IF (X.GT.XDIST(7))GO TO 55                                        BLP19530
      DO 10 I=2,6                                                       BLP19540
      IF(X.GT.XDIST(I))GO TO 10                                         BLP19550
      INDEX=I                                                           BLP19560
      GO TO 11                                                          BLP19570
10    CONTINUE                                                          BLP19580
      INDEX=5                                                           BLP19590
11    CONTINUE                                                          BLP19600
      INDEX1=INDEX-1                                                    BLP19610
      Z=DH(INDEX)-(DH(INDEX)-DH(INDEX1))*(XDIST(INDEX)-X)/              BLP19620
     1 (XDIST(INDEX)-XDIST(INDEX1))                                     BLP19630
      RETURN                                                            BLP19640
55    CONTINUE                                                          BLP19650
C     PLUME REACHES FINAL RISE                                          BLP19660
      Z=DH(7)                                                           BLP19670
      RETURN                                                            BLP19680
      END                                                               BLP19690
C
      SUBROUTINE DBTSIG (X,XY,KST,SY,SZ)                                BLP19700
C                                                                       BLP19710
C                                                                       BLP19720
      DIMENSION XA(7),XB(2),XD(5),XE(8),XF(9),AA(8),BA(8),AB(3),BB(3),  BLP19730
     1 AD(6),BD(6),AE(9),BE(9),AF(10),BF(10)                            BLP19740
      DATA XA/.5,.4,.3,.25,.2,.15,.1/                                   BLP19750
      DATA XB/.4,.2/                                                    BLP19760
      DATA XD /30.,10.,3.,1.,.3/                                        BLP19770
      DATA XE /40.,20.,10.,4.,2.,1.,.3,.1/                              BLP19780
      DATA XF /60.,30.,15.,7.,3.,2.,1.,.7,.2/                           BLP19790
      DATA AA /453.85,346.75,258.89,217.41,179.52,170.22,158.08,122.8/  BLP19800
      DATA BA /2.1166,1.7283,1.4094,1.2644,1.1262,1.0932,1.0542,.9447/  BLP19810
      DATA AB /109.30,98.483,90.673/                                    BLP19820
      DATA BB /1.0971,0.98332,0.93198/                                  BLP19830
      DATA AD /44.053,36.650,33.504,32.093,32.093,34.459/               BLP19840
      DATA BD /0.51179,0.56589,0.60486,0.64403,0.81066,0.86974/         BLP19850
      DATA AE /47.618,35.420,26.970,24.703,22.534,21.628,21.628,23.331, BLP19860
     1 24.26/                                                           BLP19870
      DATA BE /0.29592,0.37615,0.46713,0.50527,0.57154,0.63077,0.75660, BLP19880
     1 0.81956,0.8366/                                                  BLP19890
      DATA AF /34.219,27.074,22.651,17.836,16.187,14.823,13.953,13.953, BLP19900
     1 14.457,15.209/                                                   BLP19910
      DATA BF /0.21716,0.27436,0.32681,0.41507,0.46490,0.54503,0.63227, BLP19920
     1 0.68465,0.78407,0.81558/                                         BLP19930
      GO TO (10,20,30,40,50,60),KST                                     BLP19940
C        STABILITY A (10)                                               BLP19950
   10 TH = (24.167 - 2.5334*ALOG(XY))/57.2958                           BLP19960
      IF (X.GT.3.11) GO TO 69                                           BLP19970
      DO 11 ID = 1,7                                                    BLP19980
      IF(X.GE.XA(ID)) GO TO 12                                          BLP19990
   11 CONTINUE                                                          BLP20000
      ID = 8                                                            BLP20010
   12 SZ = AA(ID) * X ** BA(ID)                                         BLP20020
      GO TO 71                                                          BLP20030
C        STABILITY B (20)                                               BLP20040
   20 TH = (18.333 - 1.8096*ALOG(XY))/57.2958                           BLP20050
      IF(X.GT.35.) GO TO 69                                             BLP20060
      DO 21 ID = 1,2                                                    BLP20070
      IF (X.GE.XB(ID)) GO TO 22                                         BLP20080
   21 CONTINUE                                                          BLP20090
      ID = 3                                                            BLP20100
   22 SZ = AB(ID) * X ** BB(ID)                                         BLP20110
      GO TO 70                                                          BLP20120
C        STABILITY C (30)                                               BLP20130
   30 TH = (12.5 - 1.0857*ALOG(XY))/57.2958                             BLP20140
      SZ = 61.141 *X ** 0.91465                                         BLP20150
      GO TO 70                                                          BLP20160
C        STABILITY D (40)                                               BLP20170
   40 TH = (8.3333-0.72382*ALOG(XY))/57.2958                            BLP20180
      DO 41 ID = 1,5                                                    BLP20190
      IF (X.GE.XD(ID)) GO TO 42                                         BLP20200
   41 CONTINUE                                                          BLP20210
      ID = 6                                                            BLP20220
   42 SZ = AD(ID) * X ** BD(ID)                                         BLP20230
      GO TO 70                                                          BLP20240
C        STABILITY E (50)                                               BLP20250
   50 TH = (6.25 - 0.54287*ALOG(XY))/57.2958                            BLP20260
      DO 51 ID = 1,8                                                    BLP20270
      IF (X.GE.XE(ID)) GO TO 52                                         BLP20280
   51 CONTINUE                                                          BLP20290
      ID = 9                                                            BLP20300
   52 SZ = AE(ID) * X ** BE(ID)                                         BLP20310
      GO TO 70                                                          BLP20320
C        STABILITY F (60)                                               BLP20330
   60 TH = (4.1667 - 0.36191*ALOG(XY))/57.2958                          BLP20340
      DO 61 ID = 1,9                                                    BLP20350
      IF (X.GE.XF(ID)) GO TO 62                                         BLP20360
   61 CONTINUE                                                          BLP20370
      ID = 10                                                           BLP20380
   62 SZ = AF(ID) * X ** BF(ID)                                         BLP20390
      GO TO 70                                                          BLP20400
   69 SZ = 5000.                                                        BLP20410
      GO TO 71                                                          BLP20420
   70 IF (SZ.GT.5000.) SZ = 5000.                                       BLP20430
   71 SY = 1000. * XY * SIN(TH)/(2.15 * COS(TH))                        BLP20440
      RETURN                                                            BLP20450
      END                                                               BLP20460
C
      SUBROUTINE SIGMAY(XKM,KST,SY)                                     BLP20470
C                                                                       BLP20480
C                                                                       BLP20490
C                                                                       BLP20500
C     THIS SUBROUTINE CALCULATES SIGMA Y                                BLP20510
C                                                                       BLP20520
      GO TO (10,20,30,40,50,60),KST                                     BLP20530
10    TH=(24.167-2.5334*ALOG(XKM))/57.2958                              BLP20540
      GO TO 70                                                          BLP20550
20    TH=(18.333-1.8096*ALOG(XKM))/57.2958                              BLP20560
      GO TO 70                                                          BLP20570
30    TH=(12.5-1.0857*ALOG(XKM))/57.2958                                BLP20580
      GO TO 70                                                          BLP20590
40    TH=(8.3333-0.72385*ALOG(XKM))/57.2958                             BLP20600
      GO TO 70                                                          BLP20610
50    TH=(6.25-0.54287*ALOG(XKM))/57.2958                               BLP20620
      GO TO 70                                                          BLP20630
60    TH=(4.1667-0.36191*ALOG(XKM))/57.2958                             BLP20640
70    SY=1000.*XKM*SIN(TH)/(2.15*COS(TH))                               BLP20650
      RETURN                                                            BLP20660
      END                                                               BLP20670
C
      FUNCTION XVZ (SZO,KST)                                            BLP20680
C                                                                       BLP20690
C                                                                       BLP20700
      DIMENSION SA(7),SB(2),SD(5),SE(8),SF(9),AA(8),AB(3),AD(6),AE(9),  BLP20710
     * AF(10),CA(8),CB(3),CD(6),CE(9),CF(10)                            BLP20720
      DATA SA /13.95,21.40,29.3,37.67,47.44,71.16,104.65/               BLP20730
      DATA SB /20.23,40./                                               BLP20740
      DATA SD /12.09,32.09,65.12,134.9,251.2/                           BLP20750
      DATA SE /3.534,8.698,21.628,33.489,49.767,79.07,109.3,141.86/     BLP20760
      DATA SF /4.093,10.93,13.953,21.627,26.976,40.,54.89,68.84,83.25/  BLP20770
      DATA AA /122.8,158.08,170.22,179.52,217.41,258.89,346.75,453.85/  BLP20780
      DATA AB /90.673,98.483,109.3/                                     BLP20790
      DATA AD /34.459,32.093,32.093,33.504,36.650,44.053/               BLP20800
      DATA AE /24.26,23.331,21.628,21.628,22.534,24.703,26.97,35.42,    BLP20810
     * 47.618/                                                          BLP20820
      DATA AF /15.209,14.457,13.953,13.953,14.823,16.187,17.836,22.651, BLP20830
     * 27.074,34.219/                                                   BLP20840
      DATA CA /1.0585,.9486,.9147,.8879,.7909,.7095,.5786,.4725/        BLP20850
      DATA CB /1.073,1.017,.9115/                                       BLP20860
      DATA CD /1.1498,1.2336,1.5527,1.6533,1.7671,1.9539/               BLP20870
      DATA CE /1.1953,1.2202,1.3217,1.5854,1.7497,1.9791,2.1407,2.6585, BLP20880
     * 3.3793/                                                          BLP20890
      DATA CF /1.2261,1.2754,1.4606,1.5816,1.8348,2.151,2.4092,3.0599,  BLP20900
     * 3.6448,4.6049/                                                   BLP20910
      GO TO (10,20,30,40,50,60),KST                                     BLP20920
C        STABILITY A(10)                                                BLP20930
10    DO 11 ID = 1,7                                                    BLP20940
      IF(SZO.LE.SA(ID)) GO TO 12                                        BLP20950
11    CONTINUE                                                          BLP20960
      ID = 8                                                            BLP20970
12    XVZ =(SZO/AA(ID))**CA(ID)                                         BLP20980
      RETURN                                                            BLP20990
C        STABILITY B (20)                                               BLP21000
20    DO 21 ID = 1,2                                                    BLP21010
      IF (SZO.LE.SB(ID)) GO TO 22                                       BLP21020
21    CONTINUE                                                          BLP21030
      ID = 3                                                            BLP21040
22    XVZ = (SZO/AB(ID))**CB(ID)                                        BLP21050
      RETURN                                                            BLP21060
C        STABILITY C (30)                                               BLP21070
30    XVZ = (SZO/61.141)**1.0933                                        BLP21080
      RETURN                                                            BLP21090
C        STABILITY D (40)                                               BLP21100
40    DO 41 ID = 1,5                                                    BLP21110
      IF(SZO.LE.SD(ID)) GO TO 42                                        BLP21120
41    CONTINUE                                                          BLP21130
      ID = 6                                                            BLP21140
42    XVZ = (SZO/AD(ID))**CD(ID)                                        BLP21150
      RETURN                                                            BLP21160
C        STABILITY E (50)                                               BLP21170
50    DO 51 ID = 1,8                                                    BLP21180
      IF (SZO.LE.SE(ID)) GO TO 52                                       BLP21190
51    CONTINUE                                                          BLP21200
      ID = 9                                                            BLP21210
52    XVZ = (SZO/AE(ID))**CE(ID)                                        BLP21220
      RETURN                                                            BLP21230
C        STABILITY F(60)                                                BLP21240
60    DO 61 ID = 1,9                                                    BLP21250
      IF(SZO.LE.SF(ID)) GO TO 62                                        BLP21260
61    CONTINUE                                                          BLP21270
      ID = 10                                                           BLP21280
62    XVZ = (SZO/AF(ID))**CF(ID)                                        BLP21290
      RETURN                                                            BLP21300
      END                                                               BLP21310
C
      FUNCTION XVY (SYO,KST)                                            BLP21320
C                                                                       BLP21330
C                                                                       BLP21340
      GO TO (1,2,3,4,5,6),KST                                           BLP21350
1     XVY = (SYO/213.)**1.1148                                          BLP21360
      RETURN                                                            BLP21370
2     XVY = (SYO/155.)**1.097                                           BLP21380
      RETURN                                                            BLP21390
3     XVY = (SYO/103.)**1.092                                           BLP21400
      RETURN                                                            BLP21410
4     XVY = (SYO/68.)**1.076                                            BLP21420
      RETURN                                                            BLP21430
5     XVY = (SYO/50.)**1.086                                            BLP21440
      RETURN                                                            BLP21450
6     XVY = (SYO/33.5)**1.083                                           BLP21460
      RETURN                                                            BLP21470
      END                                                               BLP21480
C
      BLOCK DATA                                                        BLP21490
C                                                                       BLP21500
C                                                                       BLP21510
      REAL L,LELEV                                                      BLP21520
      LOGICAL LSHEAR,LMETIN,LMETOT,LTRANS                               BLP21530
      COMMON/PR/L,HB,WB,WM,FPRIME,FP,XMATCH,DX,AVFACT,TWOHB,N,LSHEAR,   BLP21540
     1 LTRANS                                                           BLP21550
      COMMON/METD/ZMEAS,WS,WD,ISTAB,TDEGK,DPBL,THETA,S,P,IYR,JDAY,IHOUR BLP21560
      COMMON/SOURCE/NLINES,XLBEG(10),XLEND(10),DEL(10),YSCS(10),QT(10), BLP21570
     1 HS(10),XRCS(10,129),YRCS(10,129),TCOR,LELEV(10),                 BLP21580
     2 NPTS,XPSCS(50),YPSCS(50),PQ(50),PHS(50),XPRCS(50),YPRCS(50),     BLP21590
     3 TSTACK(50),APTS(50),BPTS(50),VEXIT(50),PELEV(50),IDOWNW(50)      BLP21600
      COMMON/RCEPT/RXBEG,RYBEG,RXEND,RYEND,RDX,RDY,XRSCS(100),          BLP21610
     1 YRSCS(100),XRRCS(100),YRRCS(100),RELEV(100),NREC                 BLP21620
      COMMON/RINTP/XDIST(7),DH(7)                                       BLP21630
      COMMON/OUTPT/IPCL(11),IPCP(51)                                    BLP21640
      COMMON/PARM/CRIT,TER1,DECFAC,XBACKG,CONST2,CONST3,MAXIT           BLP21650
      COMMON/METD24/KST(24),SPEED(24),RANDWD(24),HMIX(24),TEMP(24),     BLP21660
     1 DTHTA(2),PEXP(6),IDELS,IDSURF,IYSURF,IDUPER,IYUPER,TERAN(6),     BLP21670
     2 IRU,IHRMAX,LMETIN,LMETOT,IDAYS(366)                              BLP21680
CPES  Begin PES Code Changes

      CHARACTER RUNDAT*8, RUNTIM*8, VERSN*5
      COMMON/DATETIME/ RUNDAT, RUNTIM, VERSN
      DATA RUNDAT/' '/, RUNTIM/' '/, VERSN/'99176'/

CPES  End PES Code Changes
      DATA AVFACT/1.0/                                                  BLP21690
      DATA NLINES/0/,NPTS/0/,NREC/0/,TCOR/90.0/                         BLP21700
      DATA ZMEAS/7.0/,DTHTA/0.02,0.035/,IDELS/5/,IDAYS/366*0/           BLP21710
      DATA IRU/1/,IHRMAX/24/                                            BLP21720
      DATA LSHEAR/.TRUE./,LMETIN/.FALSE./,LMETOT/.FALSE./,LTRANS/.TRUE./BLP21730
      DATA PEXP/0.10,0.15,0.20,0.25,0.30,0.30/                          BLP21740
      DATA IYSURF/0/,IYUPER/0/                                          BLP21750
      DATA CRIT/0.02/,DECFAC/0.0/,XBACKG/0.0/,CONST2/2.6/,CONST3/34.49/,BLP21760
     1 TERAN/0.5,0.5,0.5,0.5,0.30,0.30/,MAXIT/14/                       BLP21770
      DATA IPCL/11*0/,IPCP/51*0/                                        BLP21780
      DATA RXBEG/0.0/,RYBEG/0.0/,RXEND/0.0/,RYEND/0.0/,RDX/0.0/,RDY/0.0/BLP21790
      DATA XRSCS/100*0.0/,YRSCS/100*0.0/,RELEV/100*0.0/                 BLP21800
      DATA XLBEG/10*0.0/,XLEND/10*0.0/,YSCS/10*0.0/,                    BLP21810
     1 HS/10*0.0/,QT/10*0.0/,LELEV/10*0.0/                              BLP21820
      DATA XPSCS/50*0.0/,YPSCS/50*0.0/,PHS/50*0.0/,PQ/50*0.0/,          BLP21830
     1 APTS/50*0.0/,TSTACK/50*0.0/,PELEV/50*0.0/,IDOWNW/50*0/           BLP21840
      END                                                               BLP21850
C
      SUBROUTINE COMPRS(IDAYHR,ICD,IMET2,NREC,CHIS)                     BLP21860
C                                                                       BLP21870
C                                                                       BLP21880
      REAL CHIS(NREC),CHIOUT(100)                                       BLP21890
C                                                                       BLP21900
C     ARRAY COMPRESSION TECHNIQUE USES NEGATIVE NUMBERS TO FLAG ZEROES  BLP21910
C     FOR EXAMPLE, CHIS=12.5, 12.2, 0.0, 0.0, 0.0, 10.1, 0.0, 15.1,     BLP21920
C     16.7, 0.0, 0.0, 0.0, 0.0, 0.0 IS STORED AS:                       BLP21930
C     CHIOUT=12.5, 12.2, -3., 10.1, -1., 15.1, 16.7, -5.                BLP21940
C     WHERE -3 REPLACES THREE ZEROES, -1 REPLACES ONE ZERO, ETC.        BLP21950
C                                                                       BLP21960
      NZERO=0                                                           BLP21970
      II=0                                                              BLP21980
      DO 100 I=1,NREC                                                   BLP21990
      IF(CHIS(I).NE.0.0)GO TO 50                                        BLP22000
      NZERO=NZERO+1                                                     BLP22010
      GO TO 100                                                         BLP22020
50    CONTINUE                                                          BLP22030
      IF(NZERO.EQ.0)GO TO 70                                            BLP22040
      II=II+1                                                           BLP22050
      CHIOUT(II)=-NZERO                                                 BLP22060
      NZERO=0                                                           BLP22070
70    CONTINUE                                                          BLP22080
      II=II+1                                                           BLP22090
      CHIOUT(II)=CHIS(I)                                                BLP22100
100   CONTINUE                                                          BLP22110
      IF(NZERO.EQ.0)GO TO 105                                           BLP22120
      II=II+1                                                           BLP22130
      CHIOUT(II)=-NZERO                                                 BLP22140
105   CONTINUE                                                          BLP22150
      WRITE(20)II                                                       BLP22160
      CALL OUT(IDAYHR,ICD,IMET2,II,CHIOUT)                              BLP22170
      RETURN                                                            BLP22180
      END                                                               BLP22190
C
      SUBROUTINE OUT(IDAYHR,ICD,IMET2,II,CHIOUT)                        BLP22200
C                                                                       BLP22210
C                                                                       BLP22220
      REAL CHIOUT(II)                                                   BLP22230
      WRITE(20)IDAYHR,ICD,IMET2,CHIOUT                                  BLP22240
      RETURN                                                            BLP22250
      END                                                               BLP22260
