C	......................................................
C
C	SUBROUTINE RKGST
C
c.............................................................
c
c	This routine was originally supplied by Digital Equipment
c	Corporation as part of the Scientific Subroutine Package
c	available for RT-11 as part of the Fortran Enhancement
c	Package.  It was upgraded for use as the integration
c	routine in this package.
c
c.............................................................
c
C	PURPOSE
C		TO SOLVE A SYSTEM OF FIRST ORDER ORDINARY DIFFERENTIAL
C		EQUATIONS WITH GIVEN INITIAL VALUES.
C
C	USAGE
C		CALL RKGST (PRMT,Y,DERY,NDIM,IHLF,FCT,OUTP,AUX)
C		PARAMETERS FCT AND OUTP REQUIRE AN EXTERNAL STATEMENT.
C
C	DESCRIPTION OF PARAMETERS
C
C	PRMT	AN INPUT AND OUTPUT VECTOR WITH DIMENSION GREATER
C		OR EQUAL TO 5, WHICH SPECIFIES THE PARAMETERS OF
C		THE INTERVAL AND OF ACCURACY AND WHICH SERVES FOR
C		COMMUNICATION BETWEEN SUBROUTINES OUTP AND FCT
C		(FURNISHED BY THE USER) AND SUBROUTINE RKGST.
C		EXCEPT PRMT(5) THE COMPONENTS ARE NOT DESTROYED
C		BY SUBROUTINE RKGST AND THEY ARE:
C	PRMT(1)	LOWER BOUND OF THE INTERVAL (INPUT),
C	PRMT(2)	UPPER BOUND OF THE INTERVAL (INPUT),
C	PRMT(3)	INITIAL INCREMENT OF THE INDEPENDENT VARIABLE
C		(INPUT),
C	PRMT(4)	UPPER ERROR BOUND (INPUT). IF RELATIVE ERROR IS
C		GREATER THAN PRMT(4), INCREMENT GETS HALVED.
C		IF RELATIVE ERROR LESS THAN PRMT(4)*EXPAND,
C		INCREMENT GETS DOUBLED.
C		THE USER MAY CHANGE PRMT(4) BY MEANS OF HIS
C		OUTPUT SUBROUTINE.
C	PRMT(5)	MAXIMUM STEP SIZE ORDER OF MAGNITUDE (INPUT). 
C		SUBROUTINE RKGST INITIALIZES
C		PRMT(5)=0. IF THE USER WANTS TO TERMINATE
C		SUBROUTINE RKGST AT ANY OUTPUT POINT, HE HAS TO
C		CHANGE PRMT(5) TO NON-ZERO BY MEANS OF SUBROUTINE
C		OUTP. FURTHER COMPONENTS OF VECTOR PRMT ARE
C		FEASIBLE IF ITS DIMENSION IS DEFINED GREATER
C		THAN 5. HOWEVER SUBROUTINE RKGST DOES NOT REQUIRE
C		AND CHANGE THEM. NEVERTHELESS THEY MAY BE USEFUL
C		FOR HANDING RESULT VALUES TO THE MAIN PROGRAM
C		(CALLING RKGST) WHICH ARE OBTAINED BY SPECIAL
C		MANIPULATIONS WITH OUTPUT DATA IN SUBROUTINE OUTP.
C	Y	INPUT VECTOR OF INITIAL VALUES.  (DESTROYED)
C		LATER, Y IS THE RESULTING VECTOR OF DEPENDENT
C		VARIABLES COMPUTED AT INTERMEDIATE POINTS X.
C	DERY	INPUT VECTOR OF ERROR WEIGHTS.  (DESTROYED)
C		ERROR WEIGHTS ARE CENTERED AT ONE. IF ONE PARA-
C		METER NEEDS A TIGHTER ERROR CRITERIA,THE WEIGHT IS 
C		GREATER THAN ONE. IF A PARAMETER NEED NOT BE DETER-
C		MINED SO PRECISELY,THE WEIGHT SHOULD BE LESS
C		THAN ONE.IN OTHER WORDS,
C			ERROR CRITERIA(I) = PRMT(4) / WEIGHT(I)
C		WHERE I IS THE SUBSCRIPT OF A DEPENDENT VARIABLE.
C		LATER, DERY IS THE VECTOR OF DERIVATIVES, WHICH
C		BELONG TO FUNCTION VALUES Y AT A POINT X.
C	NDIM	AN INPUT VALUE, WHICH SPECIFIES THE NUMBER OF
C		EQUATIONS IN THE SYSTEM.
C	IHLF	AN OUTPUT VALUE, WHICH SPECIFIES THE NUMBER OF
C		BISECTIONS OF THE INITIAL INCREMENT. IF IHLF BE-
C		COMES GREATER THAN 10, SUBROUTINE RKGST RETURNS THE
C		ERROR MESSAGE IHLF=11 INTO MAIN PROGRAM. ERROR
C		MESSAGE IHLF=12 OR IHLF=13 APPEARS IN CASE
C		PRMT(3)=0 OR IN CASE SIGN(PRMT(3)).NE.SIGN(PRMT(2)-
C		PRMT(1)) RESPECTIVELY.
C	FCT	THE NAME OF AN EXTERNAL SUBROUTINE USED. THIS
C		SUBROUTINE COMPUTES THE RIGHT HAND SIDES DERY OF
C		THE SYSTEM TO GIVEN VALUES X AND Y. ITS PARAMETER
C		LIST MUST BE X,Y,DERY,PRMT. SUBROUTINE FCT SHOULD
C		NOT DESTROY X AND Y.
C	OUTP	THE NAME OF AN EXTERNAL OUTPUT SUBROUTINE USED.
C		ITS PARAMETER LIST MUST BE X,Y,DERY,IHLF,NDIM,PRMT.
C		NONE OF THESE PARAMETERS (EXCEPT, IF NECESSARY,
C		PRMT(4),PRMT(5),...) SHOULD BE CHANGED BY
C		SUBROUTINE OUTP. IF PRMT(5) IS CHANGED TO NON-ZERO,
C		SUBROUTINE RKGST IS TERMINATED.
C	AUX	AN AUXILIARY STORAGE ARRAY WITH 8 ROWS AND NDIM
C		COLUMNS.
C
C	REMARKS
C
C	THE PROCEDURE TERMINATES AND RETURNS TO CALLING PROGRAM, IF
C	(1) MORE THAN 10 BISECTIONS OF THE INITIAL INCREMENT ARE
C		NECESSARY TO GET SATISFACTORY ACCURACY (ERROR MESSAGE
C		IHLF=11),
C	(2) INITIAL INCREMENT IS EQUAL TO 0 OR HAS WRONG SIGN
C		(ERROR MESSAGES IHLF=12 OR IHLF=13),
C	(3) THE WHOLE INTEGRATION INTERVAL IS WORKED THROUGH,
C	(4) SUBROUTINE OUTP HAS CHANGED PRMT(5) TO NON-ZERO.
C
C	SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C	THE EXTERNAL SUBROUTINES FCT(X,Y,DERY,PRMT) AND
C	OUTP(X,Y,DERY,IHLF,NDIM,PRMT) MUST BE FURNISHED BY THE USER.
C
C	METHOD
C	EVALUATION IS DONE BY MEANS OF FOURTH ORDER RUNGE-KUTTA
C	FORMULAE IN THE MODIFICATION DUE TO GILL. ACCURACY IS
C	TESTED COMPARING THE RESULTS OF THE PROCEDURE WITH SINGLE
C	AND DOUBLE INCREMENT.
C	SUBROUTINE RKGST AUTOMATICALLY ADJUSTS THE INCREMENT DURING
C	THE WHOLE COMPUTATION BY HALVING OR DOUBLING. IF MORE THAN
C	10 BISECTIONS OF THE INCREMENT ARE NECESSARY TO GET
C	SATISFACTORY ACCURACY, THE SUBROUTINE RETURNS WITH
C	ERROR MESSAGE IHLF=11 INTO MAIN PROGRAM.
C	TO GET FULL FLEXIBILITY IN OUTPUT, AN OUTPUT SUBROUTINE
C	MUST BE FURNISHED BY THE USER.
C	FOR REFERENCE, SEE
C	RALSTON/WILF, MATHEMATICAL METHODS FOR DIGITAL COMPUTERS,
C	WILEY, NEW YORK/LONDON, 1960, PP.110-120.
C
C	SOME NOTES ON THE PROGRAM/RALSTON AND WILF
C
C	AUX
C	---
C
C	AUX(1,I) -- CURRENT VALUE OF Y
C	AUX(2,I) -- CURRENT VALUE OF Y'
C	AUX(3,I) -- LAST GOOD VALUES OF Q
C	AUX(4,I) -- Y AFTER ONE RK STEP H
C	AUX(5,I) -- Y AFTER ONE OR TWO RK STEPS OF H/2.
C	AUX(6,I) -- CURRENT VALUES OF Q
C	AUX(7,I) -- Y' AFTER ONE OR TWO RK STEPS OF H/2.
C	AUX(8,I) -- 2/15 * WEIGHTS
C
C	A(4),B(4),C(4)
C	--------------
C
C	Y  = Y    + A  *(K  - B *Q   )
C	 i    i-1    i    i    i  i-1
C
C	Q  = Q    + 3*(A *(K  - B *Q   ) - C *K
C	 i    i-1       i   i    i  i-1     i  i
C
C	FOR VALUES OF I BETWEEN 1 AND 4, AND FOR VALUES OF K AS FOLLOWS
C
C	K  = H * F(X ,Y )
C	 1          0  0
C
C	K  = H * F(X +H/2,Y )
C	 2          0      1
C
C	K  = H * F(X +H/2,Y )
C	 3          0      2
C
C	K  = H * F(X +H,Y )
C	 4          0    3
C
C	RELATIVE ERROR
C	-------- -----
C
C	AS PER RICHARDSON QUOTED IN RALSTON/WILF (P117),
C
C	ABS ERROR = WEIGHT/15*ABS(Y2 - Y1)
C
C	THEN, RELATIVE ERROR
C
C	REL ERROR = WEIGHT*2/15*ABS(Y2 - Y1)/SUM
c
c	where SUM = ABS(Y2 + Y1)
C
C	The solution tries to use SUM=abs(y2+y1) first. If this is zero,
C	then SUM=.25*ABS(Y1) is used since y1 and y2 must be oposite in
C	sign with equal magnitude. If this
C	quantity is zero as well, the values y2 and y1 both must be zero;
C	therefore, the difference is also zero which satisfies the
C	error criteria.
C
C	.............................................................
C
	SUBROUTINE RKGST(PRMT,Y,DERY,NDIM,IHLF,FCT,OUTP,AUX)

	Implicit Real*8 ( A-H, O-Z ), Integer*4 ( I-N )

C
	DIMENSION Y(1),DERY(1),AUX(8,NDIM),A(4),B(4),C(4),PRMT(1)
C
	DATA ERRSET/1./
C
C
	DO 10 I=1,NDIM
   10	AUX(8,I)=2.D0/15.D0 * DERY(I)
	X=PRMT(1)
	XEND=PRMT(2)
	H=PRMT(3)
	stpmin = abs(h/1024.D0)
	stpmax = abs(prmt(5))
	PRMT(5)=0.D0
	CALL FCT(X,Y,DERY,PRMT)
C
C*** ERROR TEST
C
	IF(H*(XEND-X))380,370,20
C
C*** PREPARATIONS FOR RUNGE-KUTTA METHOD
C
   20	A(1)=.5D0
	A(2)= 1.D0 - DSQRT( 0.5D0 )
	A(3)= 1.D0 + DSQRT( 0.5D0 )
	A(4)= 1.D0/6.D0
	B(1)=2.D0
	B(2)=1.D0
	B(3)=1.D0
	B(4)=2.D0
	C(1)=.5D0
	C(2)= A(2)
	C(3)= A(3)
	C(4)=.5D0
C
C*** PREPARATIONS OF FIRST RUNGE-KUTTA STEP
C
	DO 30 I=1,NDIM
	AUX(1,I)=Y(I)
	AUX(2,I)=DERY(I)
	AUX(3,I)=0.D0
   30	AUX(6,I)=0.D0
	IREC=0
	H=H+H
	IHLF=-1
	ISTEP=0
	IEND=0
C
C*** START OF A RUNGE-KUTTA STEP
C*** STEP = 2 * SPECIFIED STEP
C
   40	IF((X+H-XEND)*H)70,60,50
   50	H=XEND-X
   60	IEND=1
C
C*** RECORDING OF INITIAL VALUES OF THIS STEP
C
   70	CALL FCT(X,Y,DERY,PRMT)
	CALL OUTP(X,Y,DERY,IREC,NDIM,PRMT)
	IF(PRMT(5))400,80,400
   80	ITEST=0
   90	ISTEP=ISTEP+1
C
C*** START OF INNERMOST RUNGE-KUTTA LOOP
C
	J=1
  100	AJ=A(J)
	BJ=B(J)
	CJ=C(J)
	DO 110 I=1,NDIM
	R1=H*DERY(I)
	R2=AJ*(R1-BJ*AUX(6,I))
	Y(I)=Y(I)+R2
	R2=R2+R2+R2
  110	AUX(6,I)=AUX(6,I)+R2-CJ*R1
	IF(J-4)120,150,150
  120	J=J+1
	IF(J-3)130,140,130
  130	X=X+H/2.D0
  140	CALL FCT(X,Y,DERY,PRMT)
	GOTO 100
C
C*** END OF INNERMOST RUNGE-KUTTA LOOP
C
C*** TEST OF ACCURACY
C
  150	IF(ITEST)160,160,200
C
C*** IN CASE ITEST=0 THERE IS NO POSSIBILITY FOR TESTING OF ACCURACY
C*** IF(ITEST=0) RK STEP JUST PERFORMED WAS FOR TWICE THE SPECIFIED STEP
C
  160	DO 170 I=1,NDIM
  170	AUX(4,I)=Y(I)
	ITEST=1
	ISTEP=ISTEP+ISTEP-2
  180	IHLF=IHLF+1
	X=X-H
	H=H/2.D0
	DO 190 I=1,NDIM
	Y(I)=AUX(1,I)
	DERY(I)=AUX(2,I)
  190	AUX(6,I)=AUX(3,I)
	GOTO 90
C
C*** IN CASE ITEST=1 TESTING OF ACCURACY IS POSSIBLE ONLY IF EACH
C*** HALF OF THE INTERVAL IS DONE(I.E.,IFF ISTEP IS EVEN)
C
  200	IMOD=ISTEP/2
	IF(ISTEP-IMOD-IMOD)210,230,210
  210	CALL FCT(X,Y,DERY,PRMT)
	DO 220 I=1,NDIM
	AUX(5,I)=Y(I)
  220	AUX(7,I)=DERY(I)
	GOTO 90
C
C*** ORIGINAL VERSION; absolute error
C
C     COMPUTATION OF TEST VALUE DELT
C  230	DELT=0.	                !Good so far
C	DO 240 I=1,NDIM
C  240	DELT=DELT+AUX(8,I)*ABS(AUX(4,I)-Y(I))
C	IF(DELT-PRMT(4))280,280,250
C
C*** RELATIVE ERROR
C
  230	DELT = 0.
	DO 240 I=1,NDIM
	ARG = ABS(AUX(4,I) + Y(I))
	IF(ARG .EQ. 0.) arg = .25*ABS(AUX(4,I))
c--- if the next statement is true, aux(4,i)=y(i)=0.0; rer=0.
	IF(ARG .EQ. 0.) ARG = ERRSET
	RER = AUX(8,I)*ABS(AUX(4,I) - Y(I))/ARG
  240	DELT = dMAX1(DELT,RER)
	IF(DELT-PRMT(4)) 280,280,250
C
C*** ERROR IS TOO GREAT
C
  250	if(abs(h) .lt. stpmin) goto 360
	DO 270 I=1,NDIM
  270	AUX(4,I)=AUX(5,I)
C	WRITE(5,1200) DELT
C 1200	FORMAT(' ?RKGST? -- ERROR TOO GREAT',G13.5)
	ISTEP=ISTEP+ISTEP-4
	X=X-H
	IEND=0
	GOTO 180
C
C*** RESULT VALUES ARE GOOD
C
  280	CALL FCT(X,Y,DERY,PRMT)
	DO 290 I=1,NDIM
	AUX(1,I)=Y(I)
	AUX(2,I)=DERY(I)
	AUX(3,I)=AUX(6,I)
	Y(I)=AUX(5,I)
  290	DERY(I)=AUX(7,I)
	CALL FCT(X-H,Y,DERY,PRMT)
	CALL OUTP(X-H,Y,DERY,IHLF,NDIM,PRMT)
	IF(PRMT(5))400,300,400
  300	DO 310 I=1,NDIM
	Y(I)=AUX(1,I)
  310	DERY(I)=AUX(2,I)
	IREC=IHLF
	IF(IEND) 320,320,390
C
C*** INCREMENT GETS DOUBLED TO KEEP UP WITH HALF STEPPING
C
  320	IHLF=IHLF-1
	ISTEP=ISTEP/2
	H=H+H
C
C*** ALLOW THE PROGRAM TO EXPAND BEYOND ORIGINAL STEP SIZE SPECIFICATION
C*** UP TO THE MAXIMUM
C
	IF(abs(h).ge.stpmax) goto 40
C
C*** EXPAND H DUE TO LOW ERROR VALUE after Press et al.  Since a 'new'
c	step size is being chosen, reset IHLF and ISTEP to starting values.
c	STPMIN will still stop simulations which bisect the original interval
c	more than 10 times.
C
	if(delt.ne. 0.D0) then
	   trial =  .9D0 * abs(h) * (abs(prmt(4)/delt)) ** .25D0
	else
	   trial = 10.D0 * abs(h)
	endif
c	if(trial .ge. abs(h)) then
	   h = sign( min(trial, stpmax), h)
	   IHLF=-1
	   ISTEP=0
c	endif
	GOTO 40
C
C*** RETURNS TO CALLING PROGRAM
C
  360	IHLF=11
	CALL FCT(X,Y,DERY,PRMT)
	GOTO 389
  370	IHLF=12
	GOTO 389
  380	IHLF=13
  389	CALL FCT(X,Y,DERY,PRMT)
	CALL OUTP(X,Y,DERY,IHLF,NDIM,PRMT)
	RETURN
  390	CALL FCT(X,Y,DERY,PRMT)
	CALL OUTP(X,Y,DERY,IHLF,NDIM,PRMT)
  400	IHLF=0
	RETURN
	END
