c-----------------------------------------------------------------------
      FUNCTION ERF(XX)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 4.0       Level: 941228                   ERF
c                R. Yamartino, SRC
c
c --- PURPOSE:  Computes the error function, erf(x).
c ---           This is the Quick medium accuracy ERROR FUNCTION from
c ---           NBS 55.  Using an approximation due to Hastings;
c ---           absolute error about 3e-7
c
c
c --- INPUTS:
c
c                XX - real    - Argument  (no units)
c
c --- OUTPUTS:
c
c               ERF - real    - error function of x
c
c --- ERF called by:  SLUGINT, SLUGAVE, SLUGSNP, ERFDIF, XERFDIF
c --- ERF calls:   no routines
c----------------------------------------------------------------------
c
      real x, xx ,t, t16, a(6)
      data a/0.0000430638, 0.0002765672, 0.0001520143,
     *       0.0092705272, 0.0422820123, 0.0705230784/
      data xcut/ 3.919206/
c
      x = abs(xx)
      if(x .gt. xcut) then
         t16 = 0.0
      else
c
         t = ((((((((( a(1)*x + a(2) ) * x ) + a(3) ) * x ) + a(4) ) *
     x                    x ) + a(5) ) * x ) + a(6) ) * x
c
         t = 1.0 / (t + 1.0)
c
         t16 = t * t * t * t
         t16 = t16 * t16 * t16 * t16
      endif
c
      if(xx .gt. 0.0) then
         erf =  1.0 - t16
      else
         erf =  t16 - 1.0
      endif
c
      return
      end
