c----------------------------------------------------------------------
      FUNCTION ERFDIF(X1,X2)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 4.0       Level: 900228                ERFDIF
c                R. Yamartino, SRC
c
c --- PURPOSE:  Computes the difference: erfdif = erf(x1) - erf(x2).
c               Various methods are used to avoid roundoff errors
c               depending on the values of the two arguments.
c
c --- INPUTS:
c
c                X1 - real    - Argument 1 (no units)
c                X2 - real    - Argument 1 (no units)
c
c --- OUTPUTS:
c
c            ERFDIF - real    - erf(x1) - erf(x2)
c
c --- ERFDIF called by:  SLUGINT,SLUGAVE,SLUGSNP
c --- ERFDIF calls:      ERF,ERFC
c----------------------------------------------------------------------
C *** V3.21
c
      ERFDIF=0.0
      IF(X1.EQ.X2) GO TO 40
      IF((X1*X2).LE.0.0) GO TO 50
      XTEST=ABS(X2)
      IF(ABS(X1).LT.XTEST) XTEST=ABS(X1)
c --- Some compilers cannot handle reals .LT. 1.18e-38, so reset cut
c     IF(XTEST.GE.13.306) GO TO 40
      if(xtest .GE. 9.15) GO TO 40
      IF(XTEST.LT.0.47) GO TO 50
C     CAN ONLY REACH HERE WHEN X1 AND X2 HAVE SAME SIGN.
      ISIGN=1
      XX1=X1
      XX2=X2
      IF(X1.GT.0.0) GO TO 30
      ISIGN=-1
      XX1=-XX1
      XX2=-XX2
C  30 ERFDIF=ISIGN*(ERFC(XX2)-ERFC(XX1))
   30 ERFCX1=0.0
      ERFCX2=0.0
c --- Some compilers cannot handle reals .LT. 1.18e-38, so reset cut
c     IF(XX1.LT.13.306) ERFCX1=ERFC(XX1)
c     IF(XX2.LT.13.306) ERFCX2=ERFC(XX2)
      if(xx1 .LT. 9.15) erfcx1=ERFC(xx1)
      if(xx2 .LT. 9.15) erfcx2=ERFC(xx2)
      ERFDIF=ISIGN*(ERFCX2-ERFCX1)
c --- Protect against flakey LAHEY compiler 4/9/89
      if(erfcx2.eq.erfcx1) erfdif=0.0
   40 RETURN
   50 ERFDIF=ERF(X1)-ERF(X2)
      RETURN
      END
