c----------------------------------------------------------------------
      subroutine pfsamp(xold,yold,xnew,ynew,xrec,yrec,sygu,dist2,
     &                  xi1,xi2)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 4.0       Level: 950715                PFSAMP
c                J. Scire,  SRC
c
c --- PURPOSE:  For a given puff and receptor, compute the time-
c               averaged coupling coefficients used to compute
c               concentration and wet and dry deposition fluxes.
c
c --- INPUTS:   (*  Assumes all distance units are consistent)
c
c         XOLD,YOLD - real    - Starting position (*)
c         XNEW,YNEW - real    - Ending position (*)
c         XREC,YREC - real    - Sampling position (*)
c              SYGU - real    - Sigma-y at receptor (*)
c             DIST2 - real    - Square of distance of closest approach
c                               of puff to receptor (*)
c
c --- OUTPUTS:  (unitless)
c               XI1 - real    - Integral I1 in sampling function
c               XI2 - real    - Integral I2 in sampling function
c
c
c --- PFSAMP called by:  CALCPF
c --- PFSAMP calls:      none
c----------------------------------------------------------------------
c --- Adapted from:
c --- MESOPUFF II   VERSION 5.1   LEVEL 920930                   SAMPLE
c----------------------------------------------------------------------

      data rt2/1.4142136/,rtpiby2/1.2533141/

      xi1=0.0
      xi2=0.0

      dx=xnew-xold
      dy=ynew-yold
      dx1=xold-xrec
      dy1=yold-yrec
c
      c1=dx*dx+dy*dy
      tsy=sygu*sygu
      a=c1/tsy
c
c --- Prevent numerical problems at very low wind speeds
      if(a.LT.1.e-4) then
c ---    Factor of 0.5 averages (qold+qnew)
         xi2=0.5*exp(-dist2/(2.*tsy))
         xi1=2.*xi2
         return
      endif
c
      sqrta=sqrt(a)
      sqrt2a=rt2*sqrta
      c2=dx*dx1+dy*dy1
      b=c2/tsy
      c=(dx1*dx1+dy1*dy1)/tsy
c
      xxexp=exp(0.5*(b*b/a-c))
c --- Use error function difference routine
c --- XI1=(rtpiby2/SQRTA)*XXEXP*(ERF((A+B)/SQRT2A)-ERF(B/SQRT2A))
      xi1=(rtpiby2/sqrta)*xxexp*(erfdif((a+b)/sqrt2a,b/sqrt2a))
      b2da=b*b/a
      xi2=-b*xi1/a+(xxexp/a)*(exp(-0.5*b2da)-exp(-0.5*(a+2.*b+b2da)))
      return

      end
