c----------------------------------------------------------------------
      FUNCTION VCOUP(ZR,ZS,SZ,HLID)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 4.0       Level: 940831                 VCOUP
c                R. Yamartino, SRC
c
c --- PURPOSE:  Computes the vertical coupling coefficient for a source
c               at height ZS, to a receptor at height ZR given a plume
c               with sigma z of SZ and including reflections from the
c               ground and lid at height HLID.
c
c
c --- INPUTS:
c
c                ZR - real    - Z-coordinate of receptor (m)
c                ZS - real    - Z-coordinate of source (m)
c                SZ - real    - Z-sigma at receptor (m)
c              HLID - real    - Mixing depth at receptor (m)
c              Note that these input values must have same units.
c
c
c --- OUTPUTS:
c
c             VCOUP - real    - Vertical coupling coefficient (1/m)
c
c --- VCOUP called by:  VCBAR, SLUGAVE, SLUGSNP, SLUGINT
c --- VCOUP calls:      none
c----------------------------------------------------------------------
c
c --- All heights have same units.      1/26/89
c
      data small/1.0e-10/,srttpi/2.5066283/,pi/3.1415926/
c
      vcoup = 0.0
c
          if((sz/hlid).gt.0.63) go to 15
c
c --- Sum the reflection terms
      sz1 = sz + small
      sz2 = sz*sz + small
      x = -0.5*(zr-zs)**2/sz2
      if(x.lt.-20.0) go to 20
      expz = exp(x)
      x = -0.5*(zr+zs)**2/sz2
      if(x.gt.-20.0) expz = expz + exp(x)
c
          do 10 j = -1 , +1 , 2
            zrefl = 2.0*float(j)*hlid
            x = -0.5*(zr+zs+zrefl)**2/sz2
            if(x.gt.-20.0) expz = expz + exp(x)
            x = -0.5*(zr-zs+zrefl)**2/sz2
            if(x.gt.-20.0) expz = expz + exp(x)
 10       continue
c
      vcoup = expz/(srttpi*sz1)
      go to 20
c
c --- Near uniform mixing using approximation of R. Yamartino
c     (JAPCA 27, 5, MAY 1977)
 15   szsb = -0.5*(pi*sz/hlid)**2
      if(szsb.gt.-20.0) then
         beta = exp(szsb)
         beta2 = beta*beta
         expz = (1.0-beta2)*(1.0+beta2+2.0*beta*cos(pi*zs/hlid)*
     *                                          cos(pi*zr/hlid))
      else
         expz = 1.0
      endif
      vcoup = expz/hlid
c
 20   return
      end
