      SUBROUTINE CHKWTS(KOUNT)
C
C      CHECKS FOR NON-NEGATIVE SOLUTIONS, AND UPDATES CURRENT BEST SOLUTION IF
C      THIS IS NOT THE FIRST FEASIBLE SOLUTION
C
C      VARIABLES
C         INPUTS
C      KOUNT        NUMBER OF ALLOWED CYCLES
C      X(7)         ARRAY OF WEIGHTS
C      SS           SUM OF SQUARES FOR THE REGRESSION
C      LFOUND       LOGICAL, TRUE IF A PREVIOUS TEST HAS FOUND A NON-NEG SOLN
C      W(7)         CURRENT BEST SOLUTION
C      SSFND        SUM OF SQUARES OF CURRENT BEST SOLUTION
C
C         OUTPUTS
C      NONE, EXCEPT LFOUND, LTT, W, AND SSFND MAY BE UPDATED
C         INTERNAL
C      ICYCL(7)     ARRAY OF ALLOWED CYCLE
C
       INCLUDE      'weight.inc'
	 include      'emspec.inc'
       INTEGER      ICYCL(7)
       INTEGER      I,IC
C
C==============================================================================
C
C      NEGATIVE X, SO DROP THIS
C
       DO 10 I=1,KOUNT
         IF (X(I).LT. 0.) RETURN
 10    CONTINUE
C
C      THIS ONE'S FEASIBLE SO LET THE LOOPING PROGRAM KNOW.  (LTT SET
C        TO FALSE ON ENTRY TO THIS SUBROUTINE)
C
       LTT = .TRUE.
C
C      FIRST SOLUTION
C
       IF (.NOT. LFOUND) GOTO 15
C
C      PREVIOUS SOLUTION EXISTS, SO CHECK SS
C
       IF (SS .LT. SSFND) GOTO 16
       RETURN
C
C      STORE SOLUTION
C
 15    LFOUND = .TRUE.
 16    SSFND = SS
       IC = 0
       DO 18 I = 1, NEFSPD-1
          ICYCL(I) = 0
          W(I) = 0.
          IF (LW(I)) THEN
              IC = IC + 1
              ICYCL(IC) = I
          ENDIF
 18    CONTINUE
       IF (IC .NE. KOUNT) STOP 'INCONSISTENT COUNT OF CYCLE'
       DO 19 I = 1, KOUNT
          W(ICYCL(I)) = X(I)
 19    CONTINUE
C
c
crgi debug
      write(88,1000) (w(i),i=1,nefspd-1)
	write(88,*) 'ss = ',ss
crgi
c
 1000 format(7f10.2)
       RETURN
C
       END
