c This is the include file that will have parameter definitions,
c and data structures that will deal primarily with information
c passed from the emissions module to the dispersion modules

ccccccccccccccccccccccc
c  PARAMETER          c
c  DEFINITIONS        c
ccccccccccccccccccccccc

      real FUZZ,MNMIX,MXMIX,MNHT,MXHT,MXWS,RELDEF
      real MNMXHT,MXMXHT,MXCONC,MNTEMP,MXTEMP,MXVSPD,MXEMIS
      integer*4 MXLANE,MXBLKS,MXLNKS,MXTM,IUSRIN,MXREC,INTDEF
      integer*4 MXVOL,IOR92,IOREF
      real DFSFCRF,DFSETVEL,DFDEPVEL,DFAMBCNC,DFLANWID
      real DFMIXHT,PI

      parameter (PI=3.141592654)
      parameter (DFSFCRF=0.01)
      parameter (DFSETVEL=0.0)
      parameter (DFDEPVEL=0.0)
      parameter (DFAMBCNC=0.0)
      parameter (DFLANWID=3.65764)
      parameter (DFMIXHT=1000.0)
      parameter (RELDEF=-9.)
      parameter (INTDEF=-9)
      parameter (MXEMIS=20000.)
      parameter (MXVSPD=90.)
      parameter (MNTEMP=-50.)
      parameter (MXTEMP=50.)
      parameter (MNMXHT=50.)
      parameter (MXMXHT=5000.)
      parameter (MXCONC=10.)
      parameter (MXVOL=99999)
      parameter (MXLANE = 6)
      parameter (MNMIX=10.)
      parameter (MXMIX=100.)
      parameter (MXREC  = 50)
      parameter (MXLNKS = 50)
      parameter (MXBLKS = 125)
      parameter (MXTM = 96)
      parameter (IUSRIN = 30)
      parameter (IOR92= 40)
      parameter (IOREF= 50)
      parameter (FUZZ = 0.0005)
      parameter (MNHT=1.)
      parameter (MXHT=20.)
      parameter (MXWS=50.)
crgi      parameter (wslow=1.0)
crgi      parameter (wshigh=1.5)
c
      logical lxsprd,lzsprd
      common /rgicom/ wslow,wshigh,lxsprd,lzsprd
c
c DFSFCRF = default value for surface roughness in meters
c DFSETVEL = default value for settling velocity in meters/sec
c DFDEPVEL = default value for deposition velocity in meters/sec
c DFAMBCNC = default value for ambient conc. in ppm
c DFLANWID = default value for lane width in meters
c DFMIXHT = default value for mixing height in meters
c RELDEF = value input by user when default is desired for real
c INTDEF = value input by user when default is desired for integer
c MNTEMP = minimum value for temperature in celsius
c MXTEMP = maximum value for temperature in celsius
c MXEMIS = maximum value for vehicle emissions in grams 
c MXVSPD = maximum vehicle speed in miles per hour
c MXVOL  = maximum traffic volume in vehicles per hour on link
c MXCONC = maximum value for ambient concentration in ppm
c MNMXHT = minimum mixing height value in meters
c MXMXHT = maximum mixing height value in meters
c MXWS = maximum value for a wind speed in meters per second
c MNHT = minimum height for a met reading in meters
c MXHT = maximum height for a met reading in meters
c MNMIX = minimum value for a mixing width in meters
c MXMIX = maximum value for a mixing width in meters
c MXLANE = max number of lanes per link
c FUZZ = parameter used in comparisons between real numbers
c MXREC  = max number of receptors
c MXLNKS = max number of links
c MXBLKS = max number of blocks per link
c MXTM   = max number of time blocks (15 minute intervals)
c IUSRIN = unit number for the user input file
c IOR92 = unit number for the lu92 file
c IOREF = unit number for the emission factor file
c wslow = value for wind speed below which the puff model will be used
c wshigh = value for wind speed above which the puff model will not be used

      character*80 USRINFL,LU92FL, EFFL, EFMDL

c EFMDL is either MOBILE5 or MOBILE6 and dictates # of spd dists for emfacs
c      (other info passed re: # of speeds is in EMSPEC.INC)
c USRINFL = name of the userin file

       common /fnames/ USRINFL,LU92FL,EFFL

ccccccccccccccccccccccc
c  variables related  c
c  to deposition      c
ccccccccccccccccccccccc

       real sfcrgh,setvel,depvel

c sfcrgh = surface roughness in meters
c setvel = settling velocity in meters
c depvel = deposition velocity in meters


       common /dep/ sfcrgh,setvel,depvel


ccccccccccccccccccccccc
c  variables related  c
c  to met. data       c
ccccccccccccccccccccccc
       real     tmpht
       real     ws(MXTM),wd(MXTM),sgth(MXTM)
       real mixhgt(MXTM),ambconc(MXTM),temper(MXTM)
       integer         stabcls(MXTM)

c tmpht height in meters of the temperature and met readings
c ws = wind speed in m/s at lower level
c wd = lower wind direction in degrees 
c sgth = std deviation in lower wind angle in degrees
c mixhgt = mixing height in meters
c ambconc = ambient concentration of co in ppm
c temper = lower ambient temperature in (C)
c stabcls = stability class (1-6)

       common /met1/ tmpht,ws,wd,
     &                sgth,mixhgt,ambconc,temper
       common /met2/ stabcls



ccccccccccccccccccccccc
c  variables related  c
c  to receptor data   c
ccccccccccccccccccccccc

       integer numrec
       character*20 recnam(MXREC)
       real recloc(3,MXREC)

c numrec is the number of receptors input by the user
c namrec is a name of the individual receptor
c recloc is the x,y,z location of the receptor in meters

       common /recdat1/  numrec
       common /recdat2/  recnam
       common /recdat3/  recloc

ccccccccccccccccccccccc
c  variables related  c
c  to grid definition c
ccccccccccccccccccccccc

         real xorg,yorg,DELTA
         integer*4 nx,ny,MXCELL

         parameter (MXCELL=40000)
         parameter (DELTA=10.)

c xorg = utmx coordinate of origin
c yorg = utmy coordinate of origin
c nx = number of cells in x direction (cells are 10 meters)
c ny = number of cells in y direction
c MXCELL = maximum number of cells (nx * ny)
c DELTA = parameter for grid spacing in meters

       common /grid1/ xorg,yorg
       common /grid2/ nx,ny





ccccccccccccccccccccccc
c  variables related  c
c  to link definition c
ccccccccccccccccccccccc



      integer*4 numlnks,numblks(MXLNKS),numlans(MXLNKS)
      integer*4 landir(MXLNKS,MXLANE)
      integer*4 iaway(MXLNKS)
      integer*4 itoward(MXLNKS),ivol(MXLNKS)
      real*4 rnod1(2,MXLNKS),rnod2(2,MXLNKS),rlenblk(MXLNKS)
      real*4 lnkhgt(MXLNKS),mixznwd(MXLNKS)


c numlnks = number of links for this run
c ivol  = traffic volume on link in vehicles per hour
c iaway = number of lanes for a link going away from intersection
c itoward = number of lanes for a link going toward intersection
c landir = the direction of the lane wrt intersection
c          positive number is toward intersection, negative
c          is going away from intersection
c numblks() = number of blocks for each link
c numlans() = number of lanes for each link
c rlenblk() = length of blocks for each link (meters)
c rnod1() = xy coordinates (utm meters) for a node of all links
c           this node is closest to intersection
c rnod2() = xy coordinates (utm meters) for a node of all links
c           this node is furthest away from intersection by convention
c lnkhgt() = the height of the link in meters
c mixznwd() = the width of the mixing zone in meters (usually roadway width +
c             3 meters on either side)
c istime   = Strat time of run (1335 is 1:35 pm)
c numtime  = Number of time periods in the traffic file to read
c numotime = numner of 15 min. periods to average for output data

      common /lnkdef1/ rnod1,rnod2,rlenblk,lnkhgt,mixznwd
      common /lnkdef2/ numlnks,numblks,numlans,numtime,landir,
     & iaway,itoward,ivol,istime,numotim,ldoit

      
ccccccccccccccccccccccc
c  variables related  c
c  to link data       c
ccccccccccccccccccccccc

c      real spdlan(MXTM,MXLNKS,MXLANE,MXBLKS)
c      real emslan(MXTM,MXLNKS,MXLANE,MXBLKS)
c      real emsblk(MXTM,MXLNKS,MXBLKS)
c      real twrdspd(MXTM,MXLNKS,MXBLKS)
c      real awayspd(MXTM,MXLNKS,MXBLKS)
c      real twrdems(MXTM,MXLNKS,MXBLKS)
c      real awayems(MXTM,MXLNKS,MXBLKS)
      real weight(MXBLKS)

      integer*4 itim,ihour(MXTM)

c spdlan() speed in mph for each lane of each block for each link
c emslan() CO emissions in grams for each lane block link
c emsblk() CO emissions in grams for each block link
c twrdspd () speed in mph for each lane (toward intersection) block link
c awayspd () speed in mph for each lane (away) block link
c twrdems () ems in grams for each lane (toward intersection) block link
c awayems () ems in grams for each lane (away) block link
c weight () fractional weight of block emissions for current link

c      common /landata/ spdlan,emslan,twrdspd,awayspd,emsblk,
c     &     awayems,twrdems,weight
      common /landata/ weight

      common /control/ itim,ihour

 

 
