C                    DISPERSE - VERSION 1.1 
C
C
C * * *  PROGRAM ABSTRACT -- DISPERSE - VERSION 1.1
C
C            DISPERSE IS THE MAIN PROGRAM FOR THE DISPERSION SECTION
C        OF HYROAD. iT CALLS ALL OF THE MODULE IN THE CORRECT ORDER.
C
C            FIRST IT ASKED FOR THE NAMES OF THE INPUT AND OUTPUT FILES.
C        IT OPENS THE FILES AND CALLS RDUSRIN WHICH READS IN THE
C        INFORMATION FROM THE INPUT FILE. NEXT IT LOOPS THROUGH THE
C        HOURS CALLING THE EMISSIONS MODULE AND THE THE APPROPRIATE
C        DISPERSION MODULE. IF THE WIND SPEED IS LESS THAN 1.0 M/S
C        IT CALLS THE PUFF DISPERSION. ABOUVE 1.5 M/S IT CALLS THE
C        'CALINE' MODULE. BETWEEN 1.0 AND 1.5 M/S IT CALLS BOTH AND
C        USES AN AVERAGE BASED ON THE WIND SPEED. AT THE END OF EACH TIME
C        PERIOD IT WILL WRITE THE RESULTS.
C
C            NOTE THAT MANY OF THE LARGER ARRAYS IN THIS ROUTINE AND
C         ROUTINES CALLED BY THE ROUTINE ARE DYNAMICALLY ALLOCATED. THUS
C         THE SCOPE OF THE PROBLEM THAT CAN BE HANDLED IS DEPEMDANT
C         ON THE AVAILABLE MEMORY.
C
c		Original coding through 10/98:
c			NETSIM							KLD Associates
c			DISPERSE 
c				framework and puff module	R. G. Johnson and R. G. Ireson
c				ROADWAY module				R. G. Johnson and E. L. Carr
c				emissions module			H. T. Tunggal and R. G. Ireson
c				CALINE module				R. E. Looker

c	DISPERSE v. 1.04
c	This version is includes extensive recoding and logic changes, and conversion
c	from Lahey to Visual Fortran.  NETSIM (still in LAHEY) produces a binary
c	(unformatted) LU92 file that must be converted to Visual Fortran binary
c	format before use.  Several changes alter the format and content of input files
c	as originally described in the Nov. 1998 User's Guide.  Changes relate 
c	primarily to intersection geometry inputs for puff and CALINE modules, and
c	it remains possible for users to input internally inconsistent geometries.
c						
c							Rob Ireson
c							June, 2000
c
c     DISPERSE v. 1.10
c     This version has been revised to accept either MOBILE5 (idle plus 6 
c     speed-based emission rates) or MOBILE6 (idle plus 7 rates).  The 
c     underlying speed distributions are different in M6.  The user must 
c     specify which emission factor model is the source of the inputs
c     so DISPERSE can determine how many speed distributions are being 
c     used.  The CALINE dispersion module is disabled in this version,
c     which provides only puff model-based concentration estimates.

       program disperse

       include 'disp.inc'
       include 'eparam.inc'
       include 'receptor.inc'
	      real emsblk(MXTM,MXLNKS,MXBLKS)
       real ctot(MXREC),btot(MXREC),cave(MXREC,MXTM)
       character*100 OUTFILE
	integer kss(6)
	real wss(20),sss(20),css(50,20,20,6,2),ccc(2,50,50)
c
c      Zero out average array
c
       do 100 j=1,MXTM
          do 90 i=1,MXLNKS
             cave(i,j) = 0.0
   90     continue
  100  continue

       write(*,*) 'enter name of the user input file'
       read(*,'(a)') USRINFL

       write(*,*) 'enter name of the output file'
       read(*,'(a)') OUTFILE
       open (unit=88,file=OUTFILE)


c
c call the routine to read in the information from the user input
c
       call rdusrin(ierr)
       if (ierr .eq. IFAIL) goto 8888
c
crgi -- sensitivity runs
c     ldoit is a logical that triggers an undocumented option for 
c     conducting consecutive sensitivity runs, and is triggered by
c     the user specifying a negative number of time periods
	if (ldoit) then
		open (unit=89, file='doitall.dat')
		open (unit=99, file='sens.out')
		read (89,*) nnk, nns, nnw
		if(nnk .eq. 0) goto 8888
		nnn= nnk*nns*nnw
		read (89,*) (kss(i),i=1,nnk)
		read (89,*) (sss(i),i=1,nns)
		read (89,*) (wss(i),i=1,nnw)
		ndone = 0
		ixk=1
		ixs=0
		ixw=0
	endif
c
crgi  sensitivity data input
c
  150 if (ldoit) then

		print*, 'ndone = ', ndone
		if (mod(ndone,nnw) .eq. 0) then
		 ixw=1
		 ixs = ixs+1
		else
		 ixw=ixw + 1
		endif

		if (ixs .gt. nns) then
		 ixs=1
		 ixk = ixk + 1
		endif

		ndone = ndone + 1

		stabcls(1) = kss(ixk)
		ws(1) = sss(ixs)
		wd(1) = wss(ixw)

		if (ndone .ne. 1) rewind (ior92)
	endif
c
c
        do 500 iloop = 1,numtime
           write (*,*) 'Starting time step #',iloop
c
c   Get the emissions
c
          call emscalc(ioref,ior92,iloop,emsblk)

c   check wind speed to determine dispersion module(DISABLED in v1.1)
c     Lines commented out with cxcl4 force puff-only modeling
c
cxcl4          if (ws(iloop) .lt. wshigh) then
c
c    Set up for call to roadway (puff) module
c
            call setrw(iloop)
c
c    Zero out receptor concentrations
c
            do 333 ii=1,nrecp
               ctot(ii) = 0.0
               btot(ii) = 0.0
  333       continue
c
c     Call the roadway module
c

cxcl4            if (ws(iloop) .le. wslow) then
              call rwmain(iloop,ctot)
cxcl4            else
cxcl4              fact1 = (ws(iloop) - wslow) / (wshigh - wslow)
cxcl4              fact2 = 1.0 - fact1
cxcl4              call rwmain(iloop,btot)
cxcl4            endif
cxcl4          endif
c
c   call the caline module
c
cxcl4          if (ws(iloop) .gt. wslow) then
cxcl4             call main(iloop,emsblk,ctot,nrecp)
cxcl4          endif
c
c   average the puff and caline results (based on wind speed)
c
cxcl4          if (ws(iloop) .gt. wslow .and. ws(iloop) .lt. wshigh) then
cxcl4             do 444 ii=1,nrecp
cxcl4                ctot(ii) = ctot(ii)*fact1 + btot(ii)*fact2
cxcl4  444        continue
cxcl4          endif
c
c           endif
  555 continue
c
c    Write out the results (note averaging for > 15 min values)
c
	do 556 ii=1,nrecp
		if(abs(ctot(ii)).lt. 0.0001) ctot(ii)=0.
		if(abs(btot(ii)).lt. 0.0001) btot(ii)=0.
  556 continue				
           write (*,*) iloop,(ctot(i),i=1,nrecp)
           if (numotim .gt. 1) then
              ioff = ((iloop - 1) / numotim) + 1
              fact = numotim
              do 490 i=1,nrecp
                 cave(i,ioff) = cave(i,ioff) + (ctot(i) / fact)
 490          continue
              if (mod(iloop,numotim) .eq. 0) then
                 write (88,*) 'For time period ',ioff
                 Do 485 i=1,nrecp
                    write (88,*) recnam(i),' ',cave(i,ioff), ' ppm'
 485             continue
              endif
           else
              write (88,*) 'For time period ',iloop
              Do 480 i=1,nrecp
                 write (88,*) recnam(i),' ', ctot(i), ' ppm'
crgic -- do averaging of 15 minute periods to hours.  Hardwired for
crgic		Tucson intensive for now.
crgic		First, get hour index and initialize if start of hour.
crgic		Then increment 15 minute concs
crgi		iii = 1 + (iloop-1)/4
crgi		if (mod((iloop -1),4) .eq. 0) then
crgi				ccc(1,i,iii) = 0.
crgi				ccc(2,i,iii) = 0.
crgi		endif
crgi				ccc(1,i,iii) = btot(i)/4. + ccc(1,i,iii)
crgi				ccc(2,i,iii) = ctot(i)/4. + ccc(1,i,iii)
 480          continue
           endif
crgi -- write grid of caline and puff concentrations for sensitivity
c		4x4 receptor grid and sequential for E-W and S-N roadsides
c	write(88,1001) (btot(ii),ii=13,16),(ctot(ii),ii=13,16)
c	write(88,1001) (btot(ii),ii=9,12),(ctot(ii),ii=9,12)
c	write(88,1001) (btot(ii),ii=5,8),(ctot(ii),ii=5,8)
c	write(88,1001) (btot(ii),ii=1,4),(ctot(ii),ii=1,4)
c	write(88,1001) (btot(4*ii),ii=1,4),(ctot(4*ii),ii=1,4)
c	write(88,1001) (btot(ii),ii=1,16),fact2
c	write(88,1001) (ctot(ii),ii=1,16),fact1
1001  format(16f6.2,f7.4)
crgi -- big grid output
c	write(88,1011)
c	write(88,1012) wd(1),ws(1),stabcls(1)
 1012 format(2f7.2,i7)
c	do 481 j=1,7
c		jrow = 8-j
c		ii0 = 1 +(jrow-1)*7
c		write(88,1010) (btot(ii),ii=ii0,ii0+6)
c		if (j .eq. 4) write (88,1011)
c  481 continue
 1010 format(4f7.2,7x,3f7.2)
 1011 format(1x)
c	write(88,1011)
c	do 482 j=1,7
c		jrow = 8-j
c		ii0 = 1 +(jrow-1)*7
c		write(88,1010) (ctot(ii),ii=ii0,ii0+6)
c		if (j .eq. 4) write (88,1011)
c  482 continue
c	write(88,1011)
 500    continue

crgi write sensitivity results and fill array
	if (ldoit) then
		do 600 n=1,nrecp
			css(n,ixw,ixs,ixk,1) = btot(n)
			css(n,ixw,ixs,ixk,2) = ctot(n)
			write(99,1002) n,recnam(n),wss(ixw),sss(ixs),
     1			kss(ixk),btot(n),ctot(n)
  600		continue
		if (ndone .lt. nnn) goto 150
	endif
	if (ldoit .and. (ndone .eq.nnn)) then
		close (99)
		open(99,file='bin.out',form='unformatted',status='replace')
c	write(99) (((((css(n,i,j,k,m),n=1,nrecp),i=1,nnw),j=1,nns),k=1,nnk),
c     1		m=1,2)
	write (99) css
		close (99)
		open (unit=99, file='plot.out')

c	information on file
		write (99,1003) nrecp,nnw,nns,nnk
		write (99,1004) ((n,recnam(n)),n=1,nrecp)
		write (99,1005) (wss(i),i=1,nnw)
		write (99,1005) (sss(i),i=1,nns)
		write (99,1003) (kss(i),i=1,nnk)
 1002 format(i5,a10,2f10.2,i5,2f10.2)
 1003 format(6i7)
 1004 format(i7,a10)
 1005 format(20f7.2)
 
c	wd results
	 do 601 k=1,nnk
	 do 601 j=1,nns
	 do 601 n=1,nrecp
	  write(99,1006) n,-1.,sss(j),kss(k),1,(css(n,i,j,k,1),i=1,nnw)
	  write(99,1006) n,-1.,sss(j),kss(k),2,(css(n,i,j,k,2),i=1,nnw)
  601  continue
 1006 format(i7,2f7.2,2i7,20f7.2)

c	ws results
	 do 602 k=1,nnk
	 do 602 j=1,nnw
	 do 602 n=1,nrecp
	  write(99,1006) n,wss(j),0.,kss(k),1,(css(n,j,i,k,1),i=1,nns)
	  write(99,1006) n,wss(j),0.,kss(k),2,(css(n,j,i,k,2),i=1,nns)
  602  continue

c	kstab results
	 do 603 k=1,nns
	 do 603 j=1,nnw
	 do 603 n=1,nrecp
	  write(99,1006) n,wss(j),sss(k),0,1,(css(n,j,k,i,1),i=1,nnk)
	  write(99,1006) n,wss(j),sss(k),0,2,(css(n,j,k,i,2),i=1,nnk)
  603  continue
							
c	end of sensitivity plotfile
	endif
c
crgic	Tucson-specific output
crgi	write (88,*) 'Tucson output for 12 one-hour averages'
crgi	write (88,*) 'Time, ((Puff(i),CL4(i)), i = 1,14)	'
crgi	write (88,1007) ((recnam(i),recnam(i)),i = 1,14)
 1007 format (' Int ',(14(A8,'-P',A8,'-C')))
crgi	do 605 iloop = 1, 12
crgi	write (88,1009) iloop, ((ccc(i,j,iloop),i=1,2),j=1,nrecp)
 1009 format(i5,28f10.6)
  605 continue
c
c
       print*, 'program ended without error'
       goto 9999

 8888  continue
       print*, 'program ended abnormally'

 9999  continue


       stop
       end
