       SUBROUTINE DOREGR
C
C      RUNS THROUGH ALL COMBINATIONS OF ALLOWED SPEED CYCLES TO GET
C      WEIGHTS FOR EMISSION FACTORS.
C      THIS IS A BRANCH AND BOUND, BASED ON THE FACT THAT A FEASIBLE
C      (I.E., NON-NEGATIVE) SOLUTION FOR A SET OF CYCLES WILL ALWAYS BE AT LEAST
C      AS GOOD AS ANY SOLUTION DERIVED FOR A SUBSET OF THOSE CYCLES.  THUS,
C      IF WE FIND A FEASIBLE SOLUTION WITH ALL CYCLES, THE REST DON'T NEED TO BE
C      TESTED.
C
C
C      VARIABLES
C          INPUT
C      S(13)        SPEED ARRAY IN VEH-SECONDS
C      CYCS(6,13)   SPEED ARRAY IN VEH-SECONDS FOR 6 DRIVING CYCLES
C
C         INTERNAL
C      LW(6)        LOGICAL, TRUE IF CYCLE I IS TO BE ALLOWED
C      LFOUND       LOGICAL, FALSE UNTIL A FEASIBLE SOLUTION IS FOUND
C      LTT          LOGICAL, TRUE IF A FEASIBLE SOLUTION WAS FOUND FOR THIS
C                    ATTEMPT
C
C         OUTPUT
C      W(6)         FINAL (NON-NEGATIVE) WEIGHTS TO BE ASSIGNED TO CYCLES
C      SSFND        SUM OF SQUARES FOR THE REGRESSION (NOT REALLY NEEDED)
C
       INCLUDE      'weight.inc'
	 include      'emspec.inc'
       INTEGER      I, J1, J2, J3, J4, J5
C
C      EXTERNAL SUBROUTINE
C
       EXTERNAL     GETWT
C
C==============================================================================
C
C      LOOP PROGRESSIVELY OVER ALL COMBINATIONS OF ALLOWED CYCLES
C      START WITH ALL SIX ALLOWED
C      IN EACH INNER LOOP, DISALLOW A DIFFERENT CYCLE
C
       LFOUND = .FALSE.
       DO 10 I = 1, NEFSPD-1
       LW(I) = .TRUE.
 10    CONTINUE
C
C      CHECK WITH ALL CYCLES ALLOWED
C
       CALL GETWT
C
C      FOUND SOLUTION - NO NEED TO GO FURTHER
C
       IF (LFOUND) RETURN
C
C      NO SOLUTION FOR ALL CYCLES, NEED TO DO THE WHOLE LIST
C
       DO 600 J1 = 1, NEFSPD-1
C
C      LOOP OF ONLY ONE DISALLOWED CYCLE, FIRST RESETTING LOGICALS)
       NXCUR = 1
C
       DO 15 I = 1, NEFSPD-1
         LW(I) = .TRUE.
 15    CONTINUE
       LW(J1) = .FALSE.
       CALL GETWT
       IF (LTT) GO TO 600
C
C      ANY NON-NEG SOLUTION AT THIS LEVEL MUST BE BETTER THAN A MORE RESTRICTED
C      SOLUTION
C
          DO 500 J2 = J1+1, NEFSPD-1
C
C      LOOP OF TWO DISALLOWED CYCLES
       NXCUR = 2
C
          DO 16 I = J1+1, NEFSPD-1
            LW(I) = .TRUE.
 16       CONTINUE
          LW(J2) = .FALSE.
          CALL GETWT
          IF (LTT) GO TO 500
C
            DO 400 J3 = J2+1, NEFSPD-1
C
C      LOOP OF THREE DISALLOWED CYCLES
       NXCUR = 3
C
            DO 17 I = J2+1, NEFSPD-1
              LW(I) = .TRUE.
 17         CONTINUE
            LW(J3) = .FALSE.
            CALL GETWT
            IF (LTT) GO TO 400
C
              DO 300 J4 = J3+1, NEFSPD-1
C
C      LOOP OF FOUR DISALLOWED CYCLES
       NXCUR = 4
C
              DO 18 I = J3+1, NEFSPD-1
                LW(I) = .TRUE.
 18           CONTINUE
              LW(J4) = .FALSE.
              CALL GETWT
              IF (LTT) GO TO 300
C
                DO 200 J5 = J4+1, NEFSPD-1
C
C      LOOP OF FIVE DISALLOWED CYCLES
       NXCUR = 5
C
                DO 19 I = J4+1, NEFSPD-1
                  LW(I) = .TRUE.
 19             CONTINUE
                LW(J5) = .FALSE.
                CALL GETWT
	          IF (LTT) GO TO 200
c          Only 6 cycles? Then skip next loop
	          if (nefspd .eq. 7) goto 200
C
                  DO 100 J6 = J5+1, NEFSPD-1
C
C      LOOP OF SIX DISALLOWED CYCLES
       NXCUR = 6
C
                  DO 20 I = J5+1, NEFSPD-1
                    LW(I) = .TRUE.
 20               CONTINUE
                  LW(J6) = .FALSE.
                  CALL GETWT
C
 100              CONTINUE
 200            CONTINUE
 300          CONTINUE
 400        CONTINUE
 500      CONTINUE
 600    CONTINUE
C
       IF (.NOT. LFOUND) STOP 'NO FEASIBLE SOLUTION FOUND'
C
       RETURN
C
       END
