       SUBROUTINE EMSCALC(IO1,IO2,it,emsblk)
C
C      ICF Kaiser International
C      March 25, 1998
C
C      EMSCALC READS DATA FROM EXTERNAL FILE AND GENERATES GRIDDED EMISSIONS
C      FOR AIR QUALITY MODELING
C
       INCLUDE    'emiss.inc'       !fuel, speed
       INCLUDE    'disp.inc'
	 include    'emspec.inc'
C
C  ... ARGUMENTS ...
C
C      INPUTS
C      IO1        UNIT NUMBER OF EMISSION FACTOR FILE
C      IO2        UNIT NUMBER OF TRAFFIC DATA FILE
C
       INTEGER    IO1,IO2
       REAL emsblk(MXTM,MXLNKS,MXBLKS)
C
C  ... PARAMETERS ...
C
C
C ...  LOCAL VARIABLES ...
C
C      ITIME      15 MINUTES TIME INTERVAL BEING PROCESSED
C      ITPCNT     TOTAL NUMBER OF 15 MINUTES TIME INTERVALS
C
       INTEGER    ITIME, ITPCNT
       DATA       ITIME   /0/
       SAVE       ITIME, ITPCNT
C
C      JN         NODE NUMBER
C      ICLOCK     SECONDS AFTER SIMULATION START
C      IU         UPSTREAM NODE NUMBER
C      ID         DOWNSTREAM NODE NUMBER
C      IA         LINK NUMBER
C
       INTEGER    JN, ICLOCK, IU, ID, IA
C
C      RCELL      VEHICLE SECONDS BY BLOCK, LANE, PHASE, ACCEL BIN AND SPEED BIN
C
C       REAL       RCELL(MXBLK, MXLNE, MXFZ, 9, 14)
       REAL       RCELL(:,:,:,:,:)
       ALLOCATABLE :: RCELL
C
C      FUELTOT    TOTAL FUEL CONSUMED BY PHASE FOR ENTIRE INTERSECTION
C      FUELCON    FUEL CONSUMPTION PER VEHICLE SECOND BY ACCEL BIN AND SPEED BIN
C      SPDAVG     AVERAGE SPEED FOR SPEED BIN
C
       REAL       FUELTOT
       REAL       FUELCON(9, 14), SPDAVG(14)
       DATA       FUELCON 
     &       /0.45, 0.45, 0.45, 0.45, 0.47, 0.86, 1.56, 2.78, 3.81,
     &        0.45, 0.45, 0.45, 0.46, 0.47, 1.02, 1.76,    3, 4.03,
     &        0.47, 0.47, 0.47, 0.52, 0.64, 1.45, 2.47,  3.8, 4.63,
     &        0.54, 0.54, 0.54, 0.55, 0.71, 1.93, 3.34, 4.81, 5.58,
     &        0.57, 0.57, 0.57, 0.58, 0.85,  2.3, 4.36, 5.99, 6.71,
     &        0.64, 0.64, 0.64, 0.64, 0.94, 2.76, 5.36, 7.65, 8.02,
     &        0.65, 0.65, 0.65, 0.65, 1.07, 3.28, 6.32, 9.75, 9.75,
     &        0.65, 0.65, 0.65, 0.65, 1.23, 3.85, 7.63,11.19,11.19,
     &        0.67, 0.67, 0.67, 0.65, 1.32, 4.46, 8.37,11.36,11.42,
     &        0.71, 0.71, 0.71, 0.72, 1.48, 5.16, 9.17,11.36,11.45,
     &        0.79, 0.79, 0.79,  0.8, 1.68, 5.87, 9.74, 11.4,11.45,
     &         0.8,  0.8,  0.8, 0.82, 1.78, 6.49,10.59, 11.4,11.45,
     &         0.8,  0.8,  0.8, 0.88, 1.98, 7.44,11.37, 11.4,11.78,
     &        0.85, 0.85, 0.85, 0.88, 2.33, 8.35, 11.6, 11.6, 11.8/

       DATA       SPDAVG / 0. ,  2.5,  7.5, 12.5, 17.5, 22.5, 27.5,
     &                    32.5, 37.5, 42.5, 47.5, 52.5, 57.5, 62.5/
C
C      VSBLK      VEHICLE SECOND BY LINK, BLOCK, PHASE AND SPEED BIN
C      VSDIST     TOTAL VEHICLE SEC DISTRIBUTION BY SPEED
C      VMTBLK     TOTAL VMT ACROSS ALL LANES
C      VSTOT      TOTAL VEHICLE SEC BY BLOCK AND PHASE
C      RVMAIR     VEHICLE FEET TRAVELED FOR LINK BY SPEED BIN
C      VMTLINK    TOTAL VMT FOR LINK OVER ALL SPEED BINS
C
C       REAL       VSBLK(MXIA, MXBLK, MXFZ, 14)
C       REAL       VSDIST(MXFZ,14)
C       REAL       VMTBLK(MXIA, MXBLK, MXFZ)
C       REAL       VSTOT(MXIA, MXBLK, MXFZ)
C       REAL       RVMAIR(MXIA, 14)
       REAL       VSBLK(:,:,:,:)
       REAL       VSDIST(:,:)
       REAL       VMTBLK(:,:,:)
c       REAL       VSTOT(:,:,:)
       REAL       RVMAIR(:,:)
       REAL       VMTLNK, VSTMP
       ALLOCATABLE :: VSBLK,VSDIST,VMTBLK,RVMAIR
C
C      EMOB       EMISSION FACTOR ARRAY
C      EMFAC      EMISSION FACTORS FOR THE CURRENT TIME INTERVAL
c  note that for M5, only 7 of 8 rates are used as set by NEFSPD
C      EMRATE     TOTAL AVERAGE EMISSION RATE (G/MILE)
C
C      EMSTOT     TOTAL LINK EMISSIONS FOR THIS TIME INTERVAL (G)
C      EMSFUEL    FUEL BASED EMISSION FACTOR (G/UNIT FUEL USAGE)
C
C
       REAL       EMOB (8,MXTS)
       REAL       EMFAC(8), EMRATE, EMSTOT, EMSFUEL
C
C      DUMMY VARIABLES
C
       INTEGER    I, ILINK, IBL, ILN, IFZ, JC, JV, IDUM
       REAL       DUMMY1(MXLNE, MXFZ), DUMMY2(MXFZ)
	 integer    iiaa(10)
C
C      EXTERNAL SUBROUTINE
C
       EXTERNAL   RDEF, GETEMS
C
C===============================================================================
C
C
C   ALLOCATE ARRAY SPACE
C

      ALLOCATE (RCELL(MXBLK, MXLNE, MXFZ, 9, 14),STAT=IERR_ALOC)
      IF (IERR_ALLOC .NE. 0) THEN
         STOP
      ENDIF
      ALLOCATE (VSBLK(MXIA, MXBLK, MXFZ, 14),STAT=IERR_ALOC)
      IF (IERR_ALLOC .NE. 0) THEN
         STOP
      ENDIF
      ALLOCATE (VSDIST(MXFZ,14),STAT=IERR_ALOC)
      IF (IERR_ALLOC .NE. 0) THEN
         STOP
      ENDIF
      ALLOCATE (VMTBLK(MXIA, MXBLK, MXFZ),STAT=IERR_ALOC)
      IF (IERR_ALLOC .NE. 0) THEN
         STOP
      ENDIF
      ALLOCATE (RVMAIR(MXIA, 14),STAT=IERR_ALOC)
      IF (IERR_ALLOC .NE. 0) THEN
         STOP
      ENDIF
C** ON PROGRAM INITIATION (FIRST TIME THROUGH):
C   READ TOTAL NUMBER OF 15 MINUTE TIME INTERVALS INCLUDED IN FILE
C
      IF (ITIME .EQ. 0) THEN
          READ (IO2) ITPCNT
ch          WRITE (*,*) 'ITPCNT', ITPCNT
          CALL RDEF (IO1, ITPCNT, EMOB)
      ENDIF
C
C** SETUP EMISSION FACTOR ARRAY FOR THE TIME INTERVAL
C
      ITIME = ITIME + 1
c      WRITE (*,*) 'ITIME',ITIME
      IF (ITIME .GT. ITPCNT) GO TO 999
C
      DO 20 I = 1, NEFSPD
        EMFAC (I) = EMOB(I, ITIME)
 20   CONTINUE
C
C
C** READ TIME INTERVAL DATA (NODE #, SECONDS SINCE SIMULATION START, TOTAL 
C   LINKS FOR NODE, # OF PHASES)
C
      READ (IO2) JN, ICLOCK, ITOTA, IMXFZ
c      WRITE (*,*) 'JN,ICLOCK,ITOTA,IMXFZ',JN,ICLOCK,ITOTA,IMXFZ
      IF (IMXFZ .GT. MXFZ) STOP 'ERROR: MXFZ EXCEEDED'
c
      FUELTOT = 0.
      VMTLINK = 0.
      DO 30 IFZ = 1, MXFZ
      DO 30 JV = 1, 14
         VSDIST(IFZ,JV) = 0.
  30  CONTINUE
c
C
C** LOOP OVER LINKS
C
      DO 500 ILINK = 1, ITOTA
C
C** READ UPSTREAM AND DOWNSTREAM NODE #, # OF BLOCKS FOR LINK IA, LINK #, 
C   # OF LANES FOR LINK IA
C
      READ (IO2) IU, ID, INBLK, IA, IMXLNE
		iiaa(ilink) = IA
      IF (INBLK .GT. MXBLK)  STOP 'ERROR: MXBLK EXCEEDED'
      IF (IA .GT. MXIA)      STOP 'ERROR: MXIA EXCEEDED'
      IF (IMXLNE .GT. MXLNE) STOP 'ERROR: MXLNE EXCEEDED'
      IDIR(IA) = IU - ID
C
C** INITIALIZE VARIABLES
C
      DO 100 IBL = 1, INBLK
      DO 100 IFZ = 1, MXFZ
         emiss(IBL,IA,IFZ) = 0.
         VMTBLK(IA,IBL,IFZ) = 0.
         vhsec(IBL,IA,IFZ) = 0.
 100  CONTINUE

c
      DO 110 IFZ = 1, MXFZ
      DO 110 JV = 1, 14
c
      DO 105 IBL = 1, INBLK
         VSBLK(IA,IBL,IFZ,JV) = 0.
 105  CONTINUE
 110  CONTINUE
C
C** LOOP OVER BLOCKS FOR LINK IA
C   READ VEHICLE SECONDS BY BLOCK, LANE, PHASE, ACCEL BIN, AND SPEED BIN
C
      DO 300 IBL = 1, INBLK
         READ (IO2) ((((RCELL(IBL, ILN, IFZ, JC, JV), JV = 1,14),
     &                 JC = 1,9), IFZ = 1,IMXFZ), ILN = 1,IMXLNE)
C
C** CALCULATE FUEL CONSUMED FOR LINK BY BLOCK AND PHASE
C   INCREMENT TOTAL FUEL CONSUMED BY PHASE FOR ENTIRE INTERSECTION
C   SUM VEHICLE SECONDS OVER ALL ACCEL BINS TO GIVE VEHICLE SECONDS BY LINK,
C   BLOCK, PHASE, SPEED
C
      DO 150 ILN = 1, IMXLNE
      DO 150 IFZ = 1, IMXFZ
      DO 150 JC = 1, 9
      DO 150 JV = 1, 14
         emiss(IBL,IA,IFZ) = emiss(IBL,IA,IFZ) + 
     &                      RCELL(IBL,ILN,IFZ,JC,JV)*FUELCON(JC,JV)
         FUELTOT = FUELTOT +
     &                      RCELL(IBL,ILN,IFZ,JC,JV)*FUELCON(JC,JV)
         VSBLK(IA,IBL,IFZ,JV) = VSBLK(IA,IBL,IFZ,JV) + 
     &                      RCELL(IBL,ILN,IFZ,JC,JV)
 150  CONTINUE
C
C** CALCULATE TOTAL vmt ACROSS ALL LANES (= VEH-SEC * AVG SPEED(MPH)
C   UNITS=VEH-SEC-MILES/HR)
C   INCREMENT TOTAL VEH-SEC BY BLOCK AND PHASE (SUMMED OVER SPEED BINS)
C   INCREMENT TOTAL VEH-SEC DISTRIBUTION BY SPEED
C   CALCULATE SPEED BY BLOCK AND PHASE (= VEH-SEC-MILES/HR / VEH-SEC)
C            
      DO 250 IFZ = 1,IMXFZ
         DO 200 JV  = 1,14
            VSTMP = VSBLK(IA,IBL,IFZ,JV)
            VSDIST(IFZ,JV) = VSDIST(IFZ,JV) + VSTMP
            VMTBLK(IA,IBL,IFZ) = VMTBLK(IA,IBL,IFZ) + VSTMP*SPDAVG(JV)
            vhsec(IBL,IA,IFZ) = vhsec(IBL,IA,IFZ) + VSTMP
 200     CONTINUE
            IF (vhsec(IBL,IA,IFZ) .EQ. 0) THEN
               SPEED(IBL,IA,IFZ) = 0.
               GOTO 250
            ENDIF
            SPEED(IBL,IA,IFZ) = VMTBLK(IA,IBL,IFZ)/vhsec(IBL,IA,IFZ)
c
 250  CONTINUE
 300  CONTINUE
C
C** AFTER ALL BLOCKS FOR LINK ARE PROCESSED:
C   READ TOTAL VEHICLE FEET TRAVELED FOR LINK BY SPEED BIN
C   INCREMENT TOTAL VFT FOR LINK OVER ALL SPEED BINS AND CONVERT TO MILES
C
      READ (IO2) (RVMAIR(IA,JV),JV=1,14),(DUMMY2(IDUM),IDUM=1,4)
C
      DO 350 JV=1,14
         VMTLINK = VMTLINK + RVMAIR(IA,JV)
 350  CONTINUE
C
C
C** READ THROUGH REMAINING DATA FOR LINK (NOT USED FOR aq MODELING)
C
      IF (ID.EQ.JN) THEN
         READ (IO2) ((DUMMY1(ILN,IFZ),IFZ=1,IMXFZ),
     &                ILN=1,IMXLNE)
         DO 450 ILOOP = 1,4
            READ (IO2) (DUMMY2(IFZ),IFZ=1,IMXFZ)
 450     CONTINUE
      ENDIF
C

 500  CONTINUE
C
C** CALL SUBROUTINE WHICH RETURNS TOTAL AVERAGE EMISSION RATE
C
      CALL GETEMS (VSDIST, IMXFZ, EMFAC, EMRATE)
C
C** CALCULATE TOTAL LINK EMISSIONS FOR THIS TIME INTERVAL (GRAMS)
C   CALCULATE FUEL BASED EMISSIONS FACTOR (GRAMS/UNIT FUEL USAGE)
C
      EMSTOT = VMTLINK * EMRATE
      IF (FUELTOT .EQ. 0) THEN
          EMSFUEL = 0.
      ELSE
         EMSFUEL = EMSTOT / FUELTOT
      ENDIF
C
C** ALLOCATE TOTAL LINK EMISSIONS TO BLOCKS BASED ON FUEL CONSUMPTION
C   THEN ASSIGN RESULTING EMISSIONS (G) TO THE FUEL CONSUMPTION ARRAY FUEL, 
C   WHICH WILL BE ACCESSED BY THE DISPERSION MODULE
C
	do 400 iia = 1,ITOTA
		ia = iiaa(iia)
      DO 400 IBL=1,INBLK
      DO 400 IFZ=1,IMXFZ
         emiss(IBL,IA,IFZ) = EMSFUEL*emiss(IBL,IA,IFZ)
      IF (IA.EQ.1 .AND. IBL.EQ.1 .AND. IFZ .EQ.1) THEN
ch         WRITE (*,*) 'VMTLINK,EMRATE',VMTLINK,EMRATE
      ENDIF
 400  CONTINUE

        do 111 iloop=1,MXIA
            vsnow=0.
          do 222 jloop=1,MXBLK
            blkems=0.
            do 333 kloop=1,IMXFZ
              blkems=blkems+emiss(jloop,iloop,kloop)
              vsnow=vsnow+ vhsec(jloop,iloop,kloop)
 333        continue
              emsblk(it,iloop,jloop) = blkems
 222      continue
 111    continue
C
      READ (IO2) IDUM,IDUM,IDUM,IDUM,IDUM
C
C** RETURN  FIRST DEALLOCATE MEMORY
C
  999 DEALLOCATE (RCELL,STAT=IERR_ALLOC)
      IF (IERR_ALLOC .NE. 0) THEN
         STOP
      ENDIF
      DEALLOCATE (VSBLK,STAT=IERR_ALLOC)
      IF (IERR_ALLOC .NE. 0) THEN
         STOP
      ENDIF
      DEALLOCATE (VSDIST,STAT=IERR_ALLOC)
      IF (IERR_ALLOC .NE. 0) THEN
         STOP
      ENDIF
      DEALLOCATE (VMTBLK,STAT=IERR_ALLOC)
      IF (IERR_ALLOC .NE. 0) THEN
         STOP
      ENDIF
      DEALLOCATE (RVMAIR,STAT=IERR_ALLOC)
      IF (IERR_ALLOC .NE. 0) THEN
         STOP
      ENDIF
      RETURN
      END
