c this routine will figure out what the grid should be to encompass
c all of the links and receptors

       subroutine grdcalc

       include 'disp.inc'
c
 

c -------------------------------------------------------------

c
c the idea is we find the minimum and maximum xutm and ytum by
c looking at all the xutm and yutm coordinates from the links
c and receptors. we then add 5% in each direction and make our
c grid start on a multiple of 10 meters. we also need to check
c that the number of 10meter x and y cells does not exceed some
c maximum
c

            xmin=1.0e10
            ymin=1.0e10
            xmax=-1.0e10
            ymax=-1.0e10

c
c first let us check through the links
c

         do 10 iloop=1,numlnks

           if (rnod1(1,iloop).lt.xmin) xmin = rnod1(1,iloop)
           if (rnod2(1,iloop).lt.xmin) xmin = rnod2(1,iloop)
           if (rnod1(1,iloop).gt.xmax) xmax = rnod1(1,iloop)
           if (rnod2(1,iloop).gt.xmax) xmax = rnod2(1,iloop)

           if (rnod1(2,iloop).lt.ymin) ymin = rnod1(2,iloop)
           if (rnod2(2,iloop).lt.ymin) ymin = rnod2(2,iloop)
           if (rnod1(2,iloop).gt.ymax) ymax = rnod1(2,iloop)
           if (rnod2(2,iloop).gt.ymax) ymax = rnod2(2,iloop)

 10      continue


c
c now for the receptors
c
       do 20 iloop = 1,numrec
           if (recloc(1,iloop).lt.xmin) xmin=  recloc(1,iloop)
           if (recloc(2,iloop).lt.ymin) ymin=  recloc(2,iloop)
           if (recloc(1,iloop).gt.xmax) xmax=  recloc(1,iloop)
           if (recloc(2,iloop).gt.ymax) ymax=  recloc(2,iloop)

 20     continue
c
c ok - now we calculate the range and add 5% to current box
c
       xrange = xmax - xmin
       yrange = ymax - ymin
       xmin=xmin - int(0.05*xrange)
       ymin=ymin - int(0.05*yrange)
       xmax=xmax + int(0.05*xrange)
       ymax=ymax + int(0.05*yrange)
c
c now we move the minimums down and the maximums up until
c both are divisible by delta
c
       do 30 iloop=0,9
          if(mod(int(xmin-iloop),int(DELTA)).eq.0) xmin=xmin-iloop
          if(mod(int(xmax+iloop),int(DELTA)).eq.0) xmax=xmax+iloop
          if(mod(int(ymin-iloop),int(DELTA)).eq.0) ymin=ymin-iloop
          if(mod(int(ymax+iloop),int(DELTA)).eq.0) ymax=ymax+iloop
 30    continue

       xorg=xmin
       yorg=ymin
       nx = (int(xmax) - int(xmin))/int(DELTA)
       ny = (int(ymax) - int(ymin))/int(DELTA)



c       print*,'xmin ymin ',xmin,ymin
c       print*,'xmax ymax ',xmax,ymax
c       print*,'nx ny ',nx,ny
       

       return
       end

