
        Subroutine idexcy(ij,xpuff,ypuff,ncycle)
        dimension xpuff(ij),ypuff(ij)
c
        include 'puffdata.inc'
        include 'receptor.inc'
        include 'release.inc'
        include 'winds.inc'

c        Purpose:     Figure out how many traffic cycles need to be done.  To do this
c                    find the most downwind receptor and the most upwind puff.
c                    Then calculate the distance between then along the wind vector
c                    We must also add 1/2 the maximum puff size.
c
crgi					Logic changed to solving simultaneous equations to eliminate
c					numerical errors from trig functions
c
c       Arguments:   ij     = Dimension of dynamic puff array
c                    xpuff  = X coordinate of a puff
c                    ypuff  = Y coordinate of a puff
c                    ncycle = Return value of number of cycles
c
c       Locals
c
c                    tpuff  = Y axis intercept of a line through the puff with
c                             a slope perpindicular to the wind vector.
c                    trecp  = Y axis intercept of a line through the puff with
c                             a slope perpindicular to the wind vector.
c                    d      = Distance between the most downwind receptor
c                             and the most upwind puff.
c                    angle  = Angle between the Y axis and the lines
c                             perpindicular to the wind vector
c                    tpuff  = Y intercept of a line perpindicular to the wind
c                             vector that goes through the selected puff
c                    trecp  = Y intercept of a line perpindicular to the wind
c                             vector that goes through the selected receptor
c                    ws     = Nominal wind speed m/sec
c					xr	=	x coord of farthest downwind receptor
c					yr	=	y coord of farthest downwind receptor
c					slope = slope perpendicular to wind axis
c			
c
c
c       There are nine differnt possibilities depending on the winds. They are
c
c       uave < 0 vave < 0       Lower left quad
c       uave < 0 vave = 0       negative horizontal wind
c       uave < 0 vave > 0       Upper left quad
c       uave = 0 vave < 0       negative vertical wind
c       uave = 0 vave = 0       No wind
c       uave = 0 vave > 0       positive vertical wind
c       uave > 0 vave < 0       Lower right quad
c       uave > 0 vave = 0       positive horizontal wind
c       uave > 0 vave > 0       Upper right quad
c
c		We'll trap zero uave and vave, since we're going to solve for 
c		linear equations rather than using trig.  Can't have infinite slope.
c		Also, uave and vave are victims of trig functions, so trap for
c		numerics.  Assume that 1 mm/s is effectively zero.
		if (abs(uave) .lt. 0.001) uave = 0.
		if (abs(vave) .lt. 0.001) vave = 0.
c       
        if (uave .eq. 0.0) then
c
c          Positive vertical wind just find highest receptor and
c          lowest puff
c
           if (vave .gt. 0.0) then
              tpuff = 1.0e10
              trecp = -1.0e10
              do 100 i=1,nrecp
                 if (yrecp(i) .gt. trecp) trecp = yrecp(i)
  100         continue
              do 120 i=1,npuff
                 if (ypuff(i) .lt. tpuff) tpuff = ypuff(i)
  120         continue
c
c          Negative vertical wind just find lowest receptor and
c          highest puff
c
           else
              tpuff = -1.0e10
              trecp = 1.0e10
              do 140 i=1,nrecp
                 if (yrecp(i) .lt. trecp) trecp = yrecp(i)
  140         continue
              do 160 i=1,npuff
                 if (ypuff(i) .gt. tpuff) tpuff = ypuff(i)
  160         continue
           endif
c
        endif
c
 	  if (vave .eq. 0.0) then
c
c          Positive horizontal wind find left most puff and right most receptor
c
           if (uave .gt. 0.0) then
              tpuff = 1.0e10
              trecp = -1.0e10
              do 180 i=1,nrecp
                 if (xrecp(i) .gt. trecp) trecp = xrecp(i)
  180         continue
              do 200 i=1,npuff
                 if (xpuff(i) .lt. tpuff) tpuff = xpuff(i)
  200         continue
c
c          Negative horizontal wind find right most puff and left most receptor
c
           else
              tpuff = -1.0e10
              trecp = 1.0e10
              do 220 i=1,nrecp
                 if (xrecp(i) .lt. trecp) trecp = xrecp(i)
  220         continue
              do 240 i=1,npuff
                 if (xpuff(i) .gt. tpuff) tpuff = xpuff(i)
  240         continue
           endif
        endif
c
	 if ((uave .ne. 0.) .and. (vave .ne. 0.)) then
c      Non-zero u and v winds
c		get slope of perpendicular to flow vector so can find intercepts
c		of perp. through most downwind receptor and most upwind puff
c
           slope = -(uave/vave)
c
c       Positive v vector. Find the highest receptor and the lowest puff
c
           if (vave .gt. 0.0) then
              tpuff = 1.0e10
              trecp = -1.0e10
              do 300 i=1,nrecp
                 b1 = yrecp(i) - (slope * xrecp(i))
                 if (b1 .le. trecp) goto 300
			   trecp = b1
				xr = xrecp(i)
				yr = yrecp(i)
  300         continue
              do 320 i=1,npuff
                 b1 = ypuff(i) - (slope * xpuff(i))
                 if (b1 .lt. tpuff) then
                    tpuff = b1
                    kk = i
                 endif
  320         continue
           else
c
c       Negative v vector. Find the lowest receptor and the highest puff
c
              tpuff = -1.0e10
              trecp = 1.0e10
              do 340 i=1,nrecp
                 b1 = yrecp(i) - (slope * xrecp(i))
                 if (b1 .ge. trecp) goto 340
			   trecp = b1
				xr = xrecp(i)
				yr = yrecp(i)
  340         continue
              do 360 i=1,npuff
                 b1 = ypuff(i) - (slope * xpuff(i))
                 if (b1 .gt. tpuff) tpuff = b1
  360         continue
           endif
        endif
c
c
c		Have the equations for lines through upwind puff and downwind
c		receptor, and location of downwind receptor, so solve for the
c		intercept of a windaxis line through the receptor to the perp
c		through the puff, and calculate distance.  Do it the easy way
c		for wd = multiple of 90.
c
	if ((uave .ne. 0.) .and. (vave .ne. 0.)) goto 400
	d = abs(trecp -tpuff)
	goto 500
c
  400  bb = yr +xr/slope
	 xp = (bb - tpuff)/(slope + (1./slope))
	 yp = bb - xp/slope
	 d = sqrt((xp-xr)*(xp-xr) + (yp-yr)*(yp-yr))
c
c       Compute the wind speed. Then calculate how many trafic cycles
c       are needed to get from the selected puff to the selected receptor.
c       Note the distance is increased by 1/2 the maximum puff width.
  500   ws = sqrt(uave*uave + vave*vave)
        ncycle = 1 + (((d + 0.5*puffmax) / ws) / cydist)
        return
        end
