       SUBROUTINE RDEF(IEF, ISTEP, EF)
C
C      READS EMISSION FACTOR ARRAY
C
C      VARIABLES
C         INPUTS
C      IEF          UNIT NUMBER FOR EF FILE
C      ISTEP        NUMBER OF TIME STEP
C
C         OUTPUTS
C      EF(8,*)      EMISSION FACTOR ARRAY FOR w or 8 speeds (M5 or M6)
C                   (IDLE, SPEED1, SPEED2, etc) AND ISTEP TIMESTEP
C                   Only 7 of 8 are used for MOBILE5
C

       include 'disp.inc'
	 include 'emspec.inc'

       INTEGER      IEF, ISTEP, JJ
       REAL         EF(8,ISTEP)
C
       INTEGER      MXTMP
       PARAMETER    (MXTMP = 20)
       CHARACTER    STRING*22
       CHARACTER    EFTS*13, EFTM*16, EF2TM*22, END*5
       INTEGER      ITEMP
       REAL         TEMP(MXTMP), RANGE(MXTMP), ET(8,MXTMP,2)

       DATA         EFTS /'/EF TIMESTEP/'/
       DATA         EFTM /'/EF TEMPERATURE/'/
       DATA         EF2TM /'/EF AM/PM TEMPERATURE/'/
       DATA         END  /'/END/'/
C
C============================================================================
C
       REWIND (IEF)
 10    READ (IEF, 1000, END=50) STRING
       IF (STRING(1:13) .NE. EFTS) GOTO 10
C
C      READ EF BY TIMESTEP
C
       DO 20 I = 1,NEFSPD
          READ (IEF,*,ERR=9000,END=9000) JJ,(EF(I,J),J=1,ISTEP)
	    IF (JJ .NE. I) GOTO 9030
 20    CONTINUE
       RETURN
C
 50    CONTINUE
C
       REWIND (IEF)
 60    READ (IEF, 1000, END=150) STRING
       IF (STRING(1:16) .NE. EFTM) GOTO 60
C
C      READ EF BY TEMPERATURE
C
       READ (IEF,*,ERR=9020,END=9020) (TEMP(I),I=1,ISTEP)
       READ (IEF,*,ERR=9020,END=9020) ITEMP
       IF (ITEMP .GT. MXTMP) STOP 'MXTMP EXCEEDED IN RDEF'
       READ (IEF,*,ERR=9020,END=9020) (RANGE(I),I=1,ITEMP)
       DO 70 I =1,NEFSPD
           READ (IEF,*,ERR=9020,END=9020) JJ,(ET(I,J,1),J=1,ITEMP)
	     IF (JJ .NE. I) GOTO 9030
 70    CONTINUE
C
C      INTERPOLATE EF BY TEMPERATURE
C
       DO 120 I = 1,ISTEP
          TNOW = TEMP(I)
          DO 110 J = 1,ITEMP-1
             IF (TNOW .GE. RANGE(J) .AND. 
     &           TNOW .LT. RANGE(J+1)) THEN
                 DO 100 K = 1,NEFSPD
                    EF(K,I) = ET(I,J,1) + (ET(I,J+1,1) - ET(I,J,1)) *
     &               (TNOW - RANGE(J)) / (RANGE(J+1) - RANGE(J))
 100             CONTINUE
                 GOTO 120
             ENDIF    
 110      CONTINUE
       WRITE (*,1010) 'TEMP FOR TIMESTEP ',I,' OUT OF RANGE',TNOW
       j = itemp
       if (tnow .lt. range(1)) j = 1
       do 115 k=1,NEFSPD
          ef(k,i) = et(i,j,1)
 115   continue
 120   CONTINUE
C
 150   CONTINUE
C
       REWIND (IEF)
 160   READ (IEF, 1000, END=9010) STRING
       IF (STRING(1:22) .NE. EF2TM) GOTO 160
C
C      READ EF BY TEMPERATURE
C
       READ (IEF,*,ERR=9020,END=9020) ITEMP
       IF (ITEMP .GT. MXTMP) STOP 'MXTMP EXCEEDED IN RDEF'
       READ (IEF,*,ERR=9020,END=9020) (RANGE(I),I=1,ITEMP)
       DO 170 I =1,NEFSPD
           READ (IEF,*,ERR=9020,END=9020) JJ,(ET(I,J,1),J=1,ITEMP)
 	     IF (JJ .NE. I) GOTO 9030
 170   CONTINUE
       DO 180 I =1,NEFSPD
           READ (IEF,*,ERR=9020,END=9020) JJ,(ET(I,J,2),J=1,ITEMP)
           IF (JJ .NE. I) GOTO 9030
 180   CONTINUE
C
C      INTERPOLATE EF BY TEMPERATURE
C
       itime = 60*(istime/100) + mod(istime,100)
       DO 220 I = 1, NUMTIME
          jj = 1
          if (itime .gt. 720) jj = 2
          itime = itime + 15
          TNOW = TEMPER(I)
          DO 210 J = 1,ITEMP-1
             IF (TNOW .GE. RANGE(J) .AND. 
     &           TNOW .LT. RANGE(J+1)) THEN
                 DO 200 K = 1,NEFSPD
                    EF(K,I) = ET(K,J,1) + (ET(K,J+1,jj) - ET(K,J,jj)) *
     &               (TNOW - RANGE(J)) / (RANGE(J+1) - RANGE(J))
 200             CONTINUE
                 GOTO 220
             ENDIF    
 210      CONTINUE
       WRITE (*,1010) 'TEMP FOR TIMESTEP ',I,' OUT OF RANGE',TNOW
       STOP
 220   CONTINUE
C
       RETURN
C
C
 1000  FORMAT (A22)
 1010  FORMAT (A,I4,A,F10.4)
 9000  WRITE (*,*) 'ERROR READING EMISSION FACTOR BY TIMESTEP'     
       STOP
 9010  WRITE (*,*) 'ERROR NO EMISSION FACTOR FLAG FOUND'     
       STOP
 9020  WRITE (*,*) 'ERROR READING EMISSION FACTOR BY TEMPERATURE'     
       STOP
 9030  WRITE (*,*) 'ERROR IN NUMBER OF EMISSION RATES PROVIDED'
       STOP
C
       END
