C      WEIGHT.INC
C
C      VARIABLES: 
C      S(13)       SPEED ARRAY IN VEHICLE SECONDS
C      CYCS(7,13)  SPEED ARRAYS FOR 6 DRIVING CYCLES (VEH-SECS)
C      W(7)        WEIGHTS CALCULATED FOR DIFFERENT CYCLES (DIMENSIONLESS)
C      X(7)        WEIGHTS FROM CURRENT ATTEMPT AT SOLUTION
c            if MOBILE5 is used, only 6 of 7 index values are used
c      CYCM5(6,13) Speed data for M5 cycles
c      CYCM6(7,13) Speed data for M6 cycles
c      TIDLE(7)    Idle time array (6 of 7 used if M5 run)
c      TIDLM5(6)   Idle time data for M5 cycles
c      TIDLM6(7)   Idle time data for M6 cycles
c      VMTCYC(7)   VMT data (6 of 7 used if M5 run)
c      VMTCM5(6)   VMT data for M5 cycles
c      VMTCM6(7)   VMT data for M6 cycles
C      LFOUND      LOGICAL, TRUE IF A FEASIBLE SOLUTION HAS BEEN FOUND
C      SSFND       SUM OF SQUARES OF BEST WEIGHTS FOUND SO FAR
C      SS          SUM OF SQUARES FOR CURRENT ATTEMPT
C      LW(6)       LOGICAL, TRUE IF CYCLE I TO BE ALLOWED IN CURRENT TRY
C      LTT         LOGICAL, TRUE IF THE CURRENT ATTEMPT WAS FEASIBLE
C      
       REAL        S(13), CYCS(7,13), W(7), X(7)
	   REAL        CYCM5(6,13), CYCM6(7,13)
	   REAL        TIDLE(7), TIDLM5(6), TIDLM6(7)
	   REAL        VMTCYC(7),VMTCM5(6),VMTCM6(7)
       LOGICAL     LFOUND, LTT, LW(7)
       REAL        SS, SSFND
C
       COMMON /SPD/ S, CYCS, TIDLE, VMTCYC
	   common /cycjnk/ cycm5,cycm6,tidlm5,tidlm6,vmtcm5,vmtcm6
       COMMON /REGRES/ W, X, SS, SSFND
       COMMON /LREG/ LFOUND, LTT, LW
