c this routine will find out where on the current link is the
c current element being inspected by caline routine in the
c context of contribution to the current receptor

       subroutine wtcalc(it,il,ir,F,ED1,ED2,UWL,DWL,emiss,emsblk)


       include 'disp.inc'
       dimension emsblk(MXTM,MXLNKS,MXBLKS)
c


c   il is the link index
c   ir is the receptor index
c   d is the distance from receptor to link centerline
c   ED1,ED2 are element boundaries along the link
c   uwl is the upwind length
c   dwl is the downwind length
c
 

c -------------------------------------------------------------
        RMULT=100.   

        do 1 iloop=1,MXBLKS
          weight(iloop)=0.
 1      continue

c
c first thing we do is figure out if node1 or node2 of the current
c link is the upwind or downwind side - by pythag thm.
c

        delx = abs(recloc(1,ir)-rnod1(1,il))
        dely = abs(recloc(2,ir)-rnod1(2,il))
        dist = sqrt (delx**2 + dely**2)

        node1=0

        if (abs(dist**2 -((F**2)+(DWL**2))).lt.1.0) then
           node1=1
c           print*, 'node 1 is downwind side '
        elseif (abs(dist**2 -((F**2)+(UWL**2))).lt.1.0) then
c           print*, 'node 1 is upwind side '
        else
           stop
           
        endif

c
c now we loop from node1 to node2, this will either be uwl to dwl
c or vice versa
c

c case 1 is when node1 is the downwind side of the link
c we go negative to positive

        icell=0

        if (node1 .eq. 1) then
           do 10 iloop = nint(DWL*RMULT),nint(UWL*RMULT)-DELTA*RMULT,
     &DELTA*RMULT

c      print*, '** checking ed1 ed2 iloop ',ed1*RMULT,ed2*RMULT,iloop
             icell=icell+1
             if (iloop.ge.nint(ED1*RMULT) .and. 
     &                iloop+DELTA*RMULT.le.nint(ED2*RMULT)) then
                weight(icell)=1.0
c             print*,'all there ',icell,weight(icell)
             elseif (iloop.lt.nint(ED1*RMULT).and.
     &            iloop+DELTA*RMULT.gt.nint(ED1*RMULT)
     &            .and.iloop+DELTA*RMULT.lt.nint(ED2*RMULT)) then
                weight(icell)=abs((iloop+DELTA*RMULT)
     &            -ED1*RMULT)/(DELTA*RMULT)
c             print*,'partial ',icell,weight(icell)
             elseif (iloop.lt.nint(ED2*RMULT).and.
     &           iloop+DELTA*RMULT.gt.nint(ED2*RMULT)) then
                weight(icell)=abs((iloop)-ED2*RMULT)/(DELTA*RMULT)
c             print*,'partial ',icell,weight(icell)
             endif
       
 10        continue

        else


c case 2 is when node1 is the upwind side of the link(pos-->neg)

           icell=0

           do 20 iloop = nint(UWL*RMULT),nint(DWL*RMULT)+DELTA*RMULT,
     & -DELTA*RMULT
             icell=icell+1
             if (iloop.le.nint(ED1*RMULT) .and. 
     &                iloop-DELTA*RMULT.ge.nint(ED2*RMULT)) then
                weight(icell)=1.0
             elseif (iloop.gt.nint(ED1*RMULT).and.
     & iloop-DELTA*RMULT.lt.nint(ED1*RMULT).and.
     & iloop-DELTA*RMULT.gt.nint(ED2*RMULT)) then
             weight(icell)=abs((iloop-DELTA*RMULT)-
     &       ED1*RMULT)/(DELTA*RMULT)
             elseif (iloop.gt.nint(ED2*RMULT).and.
     &         iloop-DELTA*RMULT.lt.nint(ED2*RMULT)) then
                weight(icell)=abs(ED2*RMULT-iloop)/(DELTA*RMULT)
             endif
       
 20        continue


        endif


c
c compute the sum of the weight array for qa purposes
c and compute the emission rate qa to be returned
c
        sum=0
        emiss=0
        rlen = abs(ED1-ED2)
        do 44 jloop=1,MXBLKS
           sum=sum+weight(jloop)
           emiss=emiss+(weight(jloop)*emsblk(it,il,jloop))
c      print*, 'emsblk it il jloop ',it,il,jloop,emsblk(it,il,jloop)
 44     continue

c
c assume input emiss is in gram/15 min period   - turn into 
c ug/m*sec
c
           emiss = 1.0e6*emiss/(rlen*(15.*60.))


c      print*,'sum_wt len_elem emiss ',sum,rlen/DELTA,emiss

c
c show the weight array
c
c        do 99 jloop=1,MXBLKS
c         if (weight(jloop).gt.0.) then
c      print*,'index weight ems',jloop,weight(jloop),emsblk(it,il,jloop) 
        
c         endif
c 99     continue

       return
       end
