      SUBROUTINE PRMAIR                                                 
C                                                                       
C                                                                       
C --- CODED   12-29-97 BY M. YEDLIN                                     
C                                                                       
C --- TITLE - PRIME DATA BASE FOR AIR QUALITY MODELING - MODULE 2261.14
C                                                                       
C --- FUNCTION - THIS MODULE ACTS AS EXECUTIVE TO CONTROL PRIMING OF   
C ---            ARRAYS NEEDED TO COMPUTE AIR QUALITY MEASURES   
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE CALLS SUBORDINATE MODULES TO PRIME THE NETSIM DATA    
C     BASE SO THAT THE SIMULATION CAN PRODUCE THE INFORMATION NEEDED    
C     TO COMPUTE AIR QUALITY MEASURES.  
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    INPTFN - MODULE 2.2.6.1                            
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    GCDIS  - MODULE 2261.14.1
C                    PRFDR  - MODULE 2261.14.2
C                    INTOFZ - MODULE 2261.14.3
C                    LNKAPP - MODULE 2261.14.4
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     INODE   LOCAL VALUE OF XNODE
C     XNODE   NUMBER OF NODE WHERE AIR QUALITY DATA IS REQUESTED 
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                               
      INCLUDE 'AIRQUAL.INC'                                              
C
C -----  PRIME COMMON STORAGE FOR AIR QUALITY MODELING WHEN REQUESTED.
C
      IF (XNODE .GT. 0) THEN
         INODE = XNODE
         CALL GCDIS (INODE)
         CALL PRFDR (INODE)
         CALL INTOFZ (INODE)
         CALL LNKAPP (INODE)
      ENDIF   
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE GCDIS (I1)                                                           
C                                                                                     
C                                                                                     
C --- CODED   10-28-97 BY E. LIEBERMAN                                                
C                                                                                     
C --- TITLE - GET DISTANCE FROM STOP-BAR TO CENTER OF INTERSECTION                    
C             MODULE 2261.14.1
C                                                                                     
C --- FUNCTION - COMPUTES THE DISTANCE FROM STOP-BAR TO CENTER OF 
C ---            INTERSECTION FOR AIR QUALITY CALCULATIONS        
C                                                                                     
C --- ARGUMENTS - I1  -  NODE NUMBER OF INTERSECTION, FROM CALLING
C ---                    ROUTINE                                         
C                                                                                     
C -------------------------   DESCRIPTION   ---------------------------               
C                             -----------                                             
C                                                                                     
C     FOR EACH APPROACH LINK, CALCULATE THE WIDTH OF THE CROSS STREET
C     AND STORE HALF THAT DISTANCE IN BLKREF(IL).
C                                                                                
C -------------------   THIS ROUTINE CALLED BY   ----------------------               
C                       ----------------------                                        
C                                                                                     
C                    PRMAIR - MODULE 2261.14                                          
C                                                                                     
C ---------------------   THIS ROUTINE CALLS   ------------------------               
C                         ------------------                                          
C
C                                NONE                                                     
C                                                                                     
C ---------------    GLOSSARY OF VARIABLE NAMES   ---------------------               
C                    --------------------------                                       
C                                                                                     
C     ARIGHT  LINK SPECIFIC ARRAY - RIGHT TURN RECEIVING LINK
C     BLKREF  LINK SPECIFIC ARRAY - DISTANCE TO CENTER OF INTERSECTION
C     CROSFR  LINK SPECIFIC ARRAY - FAR CROSS LINK APPROACH TO DWN NODE
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER
C     ERRCT   INPUT ERROR COUNTER
C     I       LOOP INDEX
C     IA      APPROACH NUMBER
C     IL      LINK NUMBER
C     ILW     SUM OF LANE WIDTHS ON CROSS LINKS TO THE LEFT OF LINK, IL
C     IALL    APPROACH LINK FROM THE LEFT
C     IN      NODE NUMBER
C     IARL    APPROACH LINK FROM THE RIGHT
C     IRL     DEPARTING LINK SERVICING RIGHT TURNERS
C     IRW     SUM OF LANE WIDTHS ON CROSS LINKS TO THE RIGHT OF LINK, IL
C     J       LANE INDEX
C     JL      OPPOSING LINK NUMBER
C     K
C     LANEGD  NUMBER OF LANES ON LINK
C     LEFT    LINK SPECIFIC ARRAY - LEFT TURN RECEIVING LINK
C     LU6     LOGICAL UNIT
C     NMAP    NODE SPECIFIC ARRAY - USER SPECIFIED NODE NUMBERS
C     SIGI    ARRAY OF LINK NUMBERS WHICH ARE APPROACHES TO NODE, IN
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER
C                                                   
C ----------------------------------------------------------------------              
C                                                                                     
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)                     
C                                                                                     
      INCLUDE 'GLOBAL.INC'                                                            
      INCLUDE 'NETSIM.INC'     
      INCLUDE 'AIRQUAL.INC'     
C                                                                                     
      IN = I1
      I = 5 * (IN - 1)
      IA = 0
   10 CONTINUE
      I = I + 1
      IA = IA + 1
      IL = SIGI(I)
      IF (BLKREF(IL) .GT. 0)                                 GO TO 50
      IRL = ARIGHT(IL)
      IARL = CROSFR(IL)
      IRW = 0
C
C -----  CALCULATE WIDTH OF LINK RECEIVING R.T. VEHICLES, IF IT EXISTS.
C
      IF (IRL .GT. 0) THEN
         JLN = MOD (LANEGD(IRL) / 2**3, 2**3)
         K = 0
            DO 20 J = 1, JLN                                      
               IRW = IRW + MOD (XWIDTH(IRL) / 2**K, 2**4)         
               K = K + 4
   20       CONTINUE                                              
         IRW = IRW + MOD (XWIDT2(IRL), 2**4)
      ENDIF
C
C -----  TEST FOR AN APPROACH LINK FROM THE RIGHT.  IF SO, GET ITS
C -----  WIDTH.
C   
      IF (IARL .GT. 0) THEN
         JLN = MOD (LANEGD(IARL) / 2**3, 2**3)
         K = 0
            DO 25 J = 1, JLN
               IRW = IRW + MOD (XWIDTH(IARL) / 2**K, 2**4)
               K = K + 4
   25       CONTINUE
         IRW = IRW + MOD (XWIDT2(IARL), 2**4)
      ENDIF
C
C -----  TEST FOR LINKS FROM THE LEFT.
C
      ILW = 0
      ILL = LEFT(IL)
      IALL = CROSNR(IL)
      IF (IALL .GT. 0) THEN
         K = 0
            DO 40 J = 1, 7
               ILW = ILW + MOD (XWIDTH(IALL) / 2**K, 2**4)
               K = K + 4
   40       CONTINUE
         ILW = ILW + MOD (XWIDT2(IALL), 2**4)
      ENDIF
      IF (ILL .GT. 0) THEN
         JLN = MOD (LANEGD(ILL) / 2**3, 2**3)
         K = 0
            DO 45 J = 1, JLN
               ILW = ILW + MOD (XWIDTH(ILL) / 2**K, 2**4)
               K = K + 4
   45       CONTINUE
      ENDIF
      IF (ILW + IRW .EQ. 0) WRITE (LU6, 1000) NMAP(IN)
C
C -----  GET DISTANCE FROM STOP BAR TO CENTER OF INTERSECTION 
C -----  = 1/2 OF CROSS STREET WIDTH (AVERAGE OF TWO CROSS
C -----  STREETS). IF NO CROSS STREETS, BLKREF(IL) = 0
C      
      IF (BLKREF(IL) .EQ. 0) BLKREF(IL) = (ILW + IRW + 2) / 4
      IF (BLKREF(IL) .GT. 0) BLKREF(IL) = BLKREF(IL) + 
     1                                    MOD (XWIDT2(IL) / 2**4, 2**7)
C
C -----  ONCOMING APPROACH HAS SAME DISTANCE TO CENTER OF 
C -----  INTERSECTION.
C      
      IF (OPPOSE(IL) .GT. 0) THEN
         JL = OPPOSE(IL)
         BLKREF(JL) = BLKREF(IL)
         IF (BLKREF(JL) .GT. 0) BLKREF(JL) = BLKREF(JL) + 
     1       MOD (XWIDT2(JL) / 2**4, 2**7) - MOD(XWIDT2(IL) / 2**4,
     2                               2**7)
      ENDIF
   50 CONTINUE     
      IF (SIGI(I+1) .GT. 0 .AND. IA .LT. 5)                  GO TO 10
C         
      RETURN                                                                          
 1000 FORMAT ('0', 40X, 'NODE', I3, ' HAS NO INTERSECTING LINKS.')
      END                                                                             
      SUBROUTINE ILKNDN
C
C --- CODED    8-10-79 BY M. MASSUCCI
C --- REVISED  5-04-87 BY O. SHARAF-ELDIEN FOR MISSING COMMON BLOCKS
C --- REVISED  9-15-87 BY AJAY K. RATHI FOR IDENTICAL TRAFFIC STREAMS
C --- REVISED 10-15-87 BY K. SHERIDAN (FOR NETSIM SIGNAL TRANSITION)
C --- REVISED  3-26-88 BY O. SHARAF-ELDIEN TO REMOVE REDUNDANT ARRAYS
C --- REVISED  3-29-90 BY H. CHEN TO ADD INITIALIZATION FOR QAVG, QMAX
C --- REVISED 12-27-91 BY J. WERK TO RENAME CANDL ARRAY TO XCANDL ARRAY  
C --- REVISED  4-01-92 BY B. ANDREWS TO REMOVE XCOORD ARRAY              
C --- REVISED  8-26-92 BY S.E.SMITH FOR ARRAYS NEEDED TP SPEC OUTPUT
C --- REVISED  9-25-92 BY M. SEELEY TO CLEAR PEDFED AND PEDTMR ARRAYS
C --- REVISED  3-05-93 BY A. PHLEGAR TO ADD OD ARRAYS
C --- REVISED 11-05-93 BY A. PHLEGAR FOR LANE DISCHARGE ARRAYS
C --- REVISED  8-18-94 BY S. WALKER TO CHANGE MAXINT TO MAXIND
C --- REVISED 10-11-94 BY A. PHLEGAR FOR TO RENAME STOP TO XSTOP
C --- REVISED  4-25-97 BY K. SHERIDAN FOR PEDESTRIAN DELAY LOGIC
C --- REVISED 11-01-97 BY E. LIEBERMAN FOR AIR QUALITY MODELING   
C
C --- TITLE - CLEAR OR SET ALL LINK SPECIFIC AND NODE SPECIFIC ARRAYS -
C ---         MODULE 2261.1.4
C
C --- FUNCTION - THIS MODULE CLEARS OR SETS ALL LINK SPECIFIC AND NODE
C ---            ARRAYS
C
C --- ARGUMENTS - NONE
C
C -------------------------   DESCRIPTION   ----------------------------
C                             -----------
C
C     THIS MODULE IS CALLED TO INITIALIZE ALL LINK AND NODE ARRAYS FOR
C     THE NETSIM SUBNETWORK (DURING THE FIRST TIME PERIOD)
C
C -------------------   THIS ROUTINE CALLED BY   -----------------------
C                       ----------------------
C
C                    INCENN - MODULE 2261.1
C
C ----------------------   THIS ROUTINE CALLS   -----------------------
C                          ------------------
C
C                               NONE
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ----------------------
C                    --------------------------
C
C     ALIGN   LINK SPECIFIC ARRAY - THRU LANE, NO. OF FEEDER LINK
C     ARIGHT  LINK SPECIFIC ARRAY - RIGHT TURN RECEIVING LINK
C     BLKLOC  LINK SPECIFIC ARRAY - LANE, DIST. OF BLKAGE FROM UP-NODE
C     BLKR    LINK SPECIFIC ARRAY - REMAINING TIME FOR AN EVENT (SEC)
C     BLKREF  LINK SPECIFIC ARRAY - DISTANCE TO CENTER OF INTERSECTION
C     BSTIME  LINK SPECIFIC ARRAY - TOTAL BUS TRAVEL TIME
C     BUSES   LINK SPECIFIC ARRAY - TOTAL NUMBER OF BUSES DISCHARGED
C     BUSESP  LINK SPECIFIC ARRAY - NO OF BUSES DISCHARGD AT START OF TP
C     BUSTP   LINK SPECIFIC ARRAY - TOTAL NUMBER OF STOPS BY BUSES
C                                   ON THIS LINK
C     CCNAME  LINK SPECIFIC ARRAY - LINK NAMES
C     CFAILP  LINK SPECIFIC ARRAY - NO OF PHASE FAILURES AT START OF TP
C     CNTENT  LINK SPECIFIC ARRAY - NUMBER OF VEHICLES CURRENTLY ON LINK
C     CPTPL   LINK SPECIFIC ARRAY - NO OF LEFT TURN VEHICLES DISCHARGED 
C                                   AT START OF TP
C     CPTPR   LINK SPECIFIC ARRAY - NO OF RIGHT TURN VEHICLES DISCHARGED 
C                                   AT START OF TP
C     CROSFR  LINK SPECIFIC ARRAY - FAR CROSS LINK APPROACH TO DWN NODE
C     CROSNR  LINK SPECIFIC ARRAY - NEAR CROSS LNK APPROACH TO DWN NODE
C     CTDATA  CONDITIONAL TURN PROBABILITY ARRAY - PCT ENTERING TRAFFIC
C     CTVECT  LINK SPECIFIC ARRAY - POINTERS TO CTDATA ARRAY FOR
C                                   CONDITIONAL TURN MOVEMENT DATA
C     CUMPTP  LINK SPECIFIC ARRAY - NO OF VEHS DISCHARGED AT START OF TP
C     CUMVEH  LINK SPECIFIC ARRAY - VEHICLES DISCHARGING FROM LINK
C     CUMVL   LINK SPECIFIC ARRAY - NO. OF LEFT TURN DSCHG VEH
C     CUMVR   LINK SPECIFIC ARRAY - NO. OF RIGHT TURN DSCHG VEH
C     CYCFAL  LINK SPECIFIC ARRAY - TOTAL SIGNAL CYCLE FAILURES
C     DIAGNL  LINK SPECIFIC ARRAY - LINK RECEIVING DIAGONAL MOVEMENT
C     DISCHG  LINK SPECIFIC ARRAY - LOST TIME, DISCHARGE HEADWAY
C     DIVPED  LINK SPECIFIC ARRAY - RTOR CODE, FREE FLOW SPD, PED COD
C     DURINT  INTERVAL SPECIFIC ARRAY - DURATION OF INTERVAL, REF OFFSET
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER
C     ECOUNT  LINK SPECIFIC ARRAY - NUMBER OF VEHICLES WAITING FOR ENTRY
C                                   AT SOURCE NODE ON LINK
C     EHDWY   LINK SPECIFIC ARRAY - EMISSION(EXTRACTION HEADWAY (+,-)
C     FDRLNK  LINK SPECIFIC ARRAY - FEEDER LINK NUMBERS FOR ALL                                                                           
C     FZPNTR  NODE SPECIFIC ARRAY - POINTER TO DURINT ARRAY
C     GMIN    NODE SPECIFIC ARRAY - MINIMUM ALLOWABLE MAIN STREET GREEN
C             INTERVAL DURATION DURING SIGNAL TRANSITION (SEC.)
C     I       DO LOOP INDEX
C     IL      DO LOOP INDEX
C     ILL     DIMENSION OF LANEV ARRAY
C     IN      DO LOOP INDEX
C     ITIMEP  LINK SPECIFIC ARRAY - TRAVEL TIME AT START OF TP
C     IVFTP   LINK SPECIFIC ARRAY - FEET TRAVELED AT START OF TP
C     LANEF   LINK AND LANE SPECIFIC ARRAY - NUMBER OF FIRST VEHICLE
C     LANEGD  LINK SPECIFIC ARRAY - GRADE,NO.OF FULL LANES,POCKET LANES
C     LANEV   LINK AND LANE SPECIFIC ARRAY - NO. OF LAST VEH IN LANE
C     LEFT    LINK SPECIFIC ARRAY - LINK RECEIVING LEFT TURNERS
C     LGLPK   LINK SPECIFIC ARRAY - LENGTH OF LEFT TURN POCKET(FT)
C     LGRPK   LINK SPECIFIC ARRAY - LENGTH OF RIGHT TURN POCKET(FT)
C     LINK    ARRAY OF SUBNETWORK SPECIFIC INDICES FOR LINK MAPPING
C     LNDCH   LANE SPECIFIC ARRAY - CUMULATIVE NUMBER OF VEH. DISCHARGED
C             FROM LANE
C     LNDCHO  LANE SPECIFIC ARRAY - CUMULATIVE NUMBER OF VEH. DISCHARGED
C             FROM LANE AT END OF LAST TIME PERIOD
C     MAXCTD  DIMENSION OF CTDATA ARRAY
C     MAXIND  DIMENSION OF DURINT ARRAY
C     MAXLNK  MAXIMUM NUMBER OF LINKS ON SUBNETWORK
C     MAXND   MAXIMUM OF NODES ON SUBNETWORK
C     MXFUEL  MAXIMUM NUMBER OF LINKS (FUEL OPTION). MUST BE SAME AS
C             IMXLNK WHEN FUEL FEATURE IS OPERATIONAL
C     MXMOVE  MAX. NUMBER OF LINKS (MOVEMENT SPECIFIC OUTPUT FEATURE).
C             MUST BE SAME AS MAXLNK WHEN MOVEMENT SPECIFIC FEATURE
C             IS OPERATIONAL
C     MXPARK  MAX. NUMBER OF LINKS (PARKING FEATURE). MUST BE SAME AS
C             MAXLNK WHEN PARKING FEATURE IS OPERATIONAL
C     NACT    NODE SPECIFIC ARRAY - TYPE OF CONTROL,POINTER IF ACTUATED
C     NEXTE   LINK SPECIFIC ARRAY - TIME ELAPSED SINCE EMISSION AT
C                                   SOURCE/SINK
C     NMAP    NODE SPECIFIC ARRAY - USER SPECIFIED NODE NUMBER
C     OPPOSE  LINK SPECIFIC ARRAY - LINK CARRYING ONCOMING TRAFFIC
C     PARKL   LINK SPECIFIC ARRAY - DIST TO STPLNE,LENTH OF LT PARK ZONE
C     PARKR   LINK SPECIFIC ARRAY - DIST TO STPLNE,LENTH OF RT PARK ZONE
C     PCONF   LINK SPECIFIC ARRAY - BASE CONFLICT ZONE PEDESTRIAN 
C             OCCUPANCY (PCT.) CROSSING LINK NEAR UPSTREAM INTERSECTION
C     PCTLR   LINK SPECIFIC ARRAY - PERCENT OF VEH TURNING LEFT OR RITE
C     PDURNT  INTERVAL SPECIFIC ARRAY - DURATION OF INTERVAL, REF OFFSET
C             DURING AND AFTER SIGNAL TRANSITION
C     PEDFED  LINK SPECIFIC ARRAY - FEEDER LINK WHOSE PED FLOW BLOCKS 
C             TRAFFIC ON LINK (BITS 4-15) AND MOVEMENT CODE (0, 1, 2,
C             3, 4) IF THE FEEDER IS A (L, T, R, LD, RD) FEEDER LINK
C             (BITS 1-3)
C     PEDSTP  LINK SPECIFIC ARRAY - NUMBER OF VEHICLE STOPS EXPERIENCED
C             DUE TO PEDESTRIAN CONFLICTS
C     PEDTMR  LINK SPECIFIC ARRAY - TIME SINCE ONSET OF PED FLOW (SECS)
C     PFZPNT  NODE SPECIFIC ARRAY - POINTER TO PDURNT ARRAY
C     PLSEED  LINK SPECIFIC ARRAY - POINTER TO XLSEED ARRAY
C     PNACT   NODE SPECIFIC ARRAY - TYPE OF CONTROL AT BEGIN OF SIGNAL
C             TRANSITION
C     PPINTL  LINK SPECIFIC ARRAY - SIGNAL INTERVAL AT UPSTREAM INTER-  
C             SECTION WHICH BEGINS WALK PHASE FOR PEDS CROSSING 
C             UPSTREAM END OF LINK
C     PRKACT  LINK SPECIFIC ARRAY - REMAINING TIME FOR PARKING MANEUVERS
C     PRKDEM  LINK SPECIFIC ARRAY - DURATION AND FREQUENCY OF PARK MAN.
C     PRKLOC  LINK SPECIFIC ARRAY - PARKER DISTANCE FROM UPSTREAM NODE
C     PRKTMR  LINK SPECIFIC ARRAY - TIME UNTIL NEXT PARKING MANEUVER
C     PTHRU   LINK SPECIFIC ARRAY - PERCENT OF VEH GOING THRU OR DIAG
C     PWALK   LINK SPECIFIC ARRAY - DURATION OF WALK INTERVAL (SECS.)
C     PWCLK   LINK SPECIFIC ARRAY - ELAPSED TIME SINCE START OF WALK
C             INTERVAL (SECS.).  SET ZERO IF WALK INTERVAL NOT ACTIVE.
C     QAVG    LINK SPECIFIC ARRAY - AVERAGE QUEUE LENGTH ON LINK, LANE 
C     QDELAY  LINK SPECIFIC ARRAY - TOTAL DELAY IN QUEUE, SEC.
C     QDELL   LINK SPECIFIC ARRAY - LEFT TURN VEH DELAY IN Q, SEC
C     QDELR   LINK SPECIFIC ARRAY - RIGHT TURN VEH DELAY IN Q, SEC
C     QDLAYP  LINK SPECIFIC ARRAY - TTL DELAY IN QUEUE (SEC) START OF TP
C     QMAX    LINK SPECIFIC ARRAY - MAXIMUM QUEUE LENGTH ON LINK, LANE
C     SDCODE  LINK SPECIFIC ARRAY - SIGNAL CODE, POINTER TO DET ARRAY
C     SHEVNT  LINK SPECIFIC ARRAY -DURATION,INTER-ARRIVAL GAP,SHRT EVNT
C     SIGI    NODE AND APPROACH SPECIFIC ARRAY - NUMBER OF APPROACH LINK
C     SIGT    NODE SPECIFIC ARRAY - CURRENT SIGNAL STATUS
C     SINK    LINK SPECIFIC ARRAY - NO. OF VEH EXTRACTED AT SINK NODE
C     SINKP   LINK SPECIFIC ARRAY - NO. OF VEH EXTRACTED AT SINK NODE 
C                                   AT BEGINNING OF TIME PERIOD
C     SOURCE  LINK SPECIFIC ARRAY - NO. OF VEH EMITTED AT SOURCE NODE
C     SOURCP  LINK SPECIFIC ARRAY - NO. OF VEH EMITTED AT SOURCE NODE
C                                   AT BEGINNING OF TIME PERIOD
C     SPLBK   LINK SPECIFIC ARRAY - TIME OF ONSET OF SPILLBACK
C     SSNODE  LINK SPECIFIC ARRAY - NUMBER OD SINK/SOURCE NODE ON LINK
C     XSTOP   LINK SPECIFIC ARRAY - TOTAL VEH FORCED TO STOP
C     STOPL   LINK SPECIFIC ARRAY - NO. OF LEFT TURN VEH FORCED TO STOP
C     STOPP   LINK SPECIFIC ARRAY - VEHS FORCED TO STOP AT START OF TP
C     STOPR   LINK SPECIFIC ARRAY - NO. OF RIGHT TURN VEH FORCED TO STOP
C     STPDL   LINK SPECIFIC ARRAY - TTL LEFT TURN STOPPED DLY TIME, SEC
C     STPDLY  LINK SPECIFIC ARRAY - TOTAL STOPPED DELAY TIME, SEC
C     STPDP   LINK SPECIFIC ARRAY - STOPPED DELAY TIME AT START OF TP
C     STPDR   LINK SPECIFIC ARRAY - TTL RIGHT TURN STOPPED DLY TIME, SEC
C     SUMCNT  LINK SPECIFIC ARRAY - SUM OF LINK CONTENT
C     SUMCP   LINK SPECIFIC ARRAY - SUM OF LINK CONTENT AT START OF TP
C     TEVENT  LINK SPECIFIC ARRAY - TIME UNTIL NEXT SHORT TERM EVT VEH
C     THRU    LINK SPECIFIC ARRAY - LINK RECEIVING THROUGH TRAFFIC
C     TRVLL   LINK SPECIFIC ARRAY - TTL LEFT TURN VEH TRVL TIME, SEC
C     TRVLR   LINK SPECIFIC ARRAY - TTL RIGHT TURN VEH TRVL TIME, SEC
C     TRVLTM  LINK SPECIFIC ARRAY - TOTAL TRAVEL TIME (MOD 30000)
C     TYPLN   LINK SPECIFIC ARRAY - LANE CHANNELIZED FOR BUSES
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER
C     VPROC   LINK SPECIFIC ARRAY - VEH.FT OF LINK CONTENT AT END OF
C             INITIALIZATION
C     VREM    LINK SPECIFIC ARRAY - TOTAL VEH REMAINING ON LINK
C     XCANDL  LINK SPECIFIC ARRAY - CANDIDATE LANES FOR TURN MOVEMENTS
C     XDIST   ARRAY CONTAINING DISTANCE TRAVELLED ON LINK(BY VEH. FLEET)
C     XEBUF   ARRAY OF FUEL DATA FOR EACH LINK BY TABLE AND VEH. FLEET
C     XINT1   LINK SPECIFIC ARRAY - MOVEMENT CODES FOR INTERVALS 1 - 6
C     XINT2   LINK SPECIFIC ARRAY - MOVEMENT CODES FOR INTERVALS 7 - 12
C     XLNGTH  LINK SPECIFIC ARRAY - LINK LENGTH
C     XPERS   LINK SPECIFIC ARRAY - CUM. PERSON TRIPS SINCE BEGIN OF SIM
C     XPINT1  LINK SPECIFIC ARRAY - CONTROL CODES FOR INTERVALS 1 - 9
C             DURING AND AFTER SIGNAL TRANSITION
C     XPINT2  LINK SPECIFIC ARRAY - CONTROL CODES FOR INTERVALS 10 - 12
C             DURING AND AFTER SIGNAL TRANSITION
C     XSGTRN  NODE SPECIFIC ARRAY - COMPUTED MAIN STREET GREEN INTERVAL
C             DURATIONS DURING SIGNAL TRANSITION
C     XTRNS   LINK SPECIFIC ARRAY - PACKED TURN PERCENTS
C     ZFA     FIRST PED OCCUPANCY CALIB. COEFF. FOR THREE REGIMES
C     ZFB     SECOND PED OCCUPANCY CALIB. COEFF. FOR THREE REGIMES
C     ZFC     OCCUPANCY CALIB. REGIME BOUNDARIES (FRACT. OF GREEN TIME)
C     ZZA     FIRST CONFLICT ZONE CALIB. COEFF. FOR TWO REGIMES
C     ZZB     SECOND CONFLICT ZONE CALIB. COEFF. FOR TWO REGIMES
C
C ----------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
C     CHARACTER CCNAME * 12         <<<<< DECLARED IN NETSIM.INC
C
      INCLUDE 'NETSIM.INC'
      INCLUDE 'NETPEDS.INC'
      INCLUDE 'AIRQUAL.INC'
      INCLUDE 'GLOBAL.INC'
C
C -----  CLEAR LINK ARRAYS
C
      DO 10 IL = 1, MAXLNK
         ALIGN (IL) = 0
         ARIGHT(IL) = 0
         BLKREF(IL) = 0
         BSTIME(IL) = 0
         BUSES (IL) = 0
         BUSESP(IL) = 0
         BUSTP (IL) = 0
         CFAILP(IL) = 0
         CNTENT(IL) = 0
         CPTPL (IL) = 0
         CPTPR (IL) = 0
         CROSFR(IL) = 0
         CROSNR(IL) = 0
         CTVECT(IL) = 0
         CUMPTP(IL) = 0
         CUMVEH(IL) = 0
         CYCFAL(IL) = 0
         DIAGNL(IL) = 0
         DISCHG(IL) = 0
         DIVPED(IL) = 0
         DWNOD (IL) = 0
         ECOUNT(IL) = 0
         EHDWY (IL) = 0
         FDRLNK(IL) = 0
         ITIMEP(IL) = 0
         IVFTP (IL) = 0
         LANEGD(IL) = 0
         LEFT  (IL) = 0
         XLNGTH(IL) = 0
         LGLPK (IL) = 0
         LGRPK (IL) = 0
         LINK  (IL) = 0
         NEXTE (IL) = 0
         OPPOSE(IL) = 0
         PCONF (IL) = 0
         PCTLR (IL) = 0
         PEDFED(IL) = 0
         PEDSTP(IL) = 0
         PEDTMR(IL) = 0
         PLSEED(IL) = 0
         PPINTL(IL) = 0
         PTHRU (IL) = 0
         PWALK (IL) = 0
         PWCLK (IL) = 0
         QDELAY(IL) = 0
         QDLAYP(IL) = 0
         SDCODE(IL) = 0
         SHEVNT(IL) = 0
         SINK  (IL) = 0
         SINKP (IL) = 0
         SOURCE(IL) = 0
         SOURCP(IL) = 0
         SSNODE(IL) = 0
         SPLBK (IL) = 0
         XSTOP (IL) = 0
         STPDLY(IL) = 0
         STPDP (IL) = 0
         SUMCNT(IL) = 0
         SUMCP (IL) = 0
         TEVENT(IL) = 0
         THRU  (IL) = 0
         TRVLTM(IL) = 0
         TYPLN (IL) = 0
         UPNOD (IL) = 0
         VPROC (IL) = 0
         VREM  (IL) = 0
         XCANDL(IL) = 0
         XINT1 (IL) = -1
         XINT2 (IL) = -1
         XPERS (IL) = 0
         XPINT1(IL) = -1
         XPINT2(IL) = -1
         XTRNS (IL) = 0
C
C -----  FOR CONSISTENCY, CLEAR CHARACTER STRING FOR LINK NAMES
C
         CCNAME(IL) = '            '
   10 CONTINUE
C
C -----  CLEAR OPTIONAL LINK ARRAYS USED FOR MOVEMENT SPECIFIC
C -----  OUTPUT FEATURE AND FOR PARKING FEATURE
C
      DO 12 IL = 1, MXMOVE
         CUMVL(IL) = 0
         CUMVR(IL) = 0
         QDELL(IL) = 0
         QDELR(IL) = 0
         STOPL(IL) = 0
         STOPR(IL) = 0
         STPDL(IL) = 0
         STPDR(IL) = 0
         TRVLL(IL) = 0
         TRVLR(IL) = 0
   12 CONTINUE
C
      DO 13 IL = 1, MXPARK
         BLKLOC(IL) = 0
         BLKR  (IL) = 0
         PARKL (IL) = 0
         PARKR (IL) = 0
         PRKACT(IL) = 0
         PRKDEM(IL) = 0
         PRKLOC(IL) = 0
         PRKTMR(IL) = 1
   13 CONTINUE
C
C -----  CLEAR ARRAYS DIMENSIONED LINKS * LANES
C
      ILL = 7 * MAXLNK
      DO 15 IL = 1, ILL
         DSCSPD(IL) = 0
         LANEF(IL) = 0
         LANEV(IL) = 0
         LNDCH(IL) = 0
         LNDCHO(IL)= 0
         QAVG (IL) = 0
         QMAX (IL) = 0
   15 CONTINUE
C
C -----  CLEAR ALL NODE ARRAYS
C
      DO 20 IN = 1, MAXND
         FZPNTR(IN) = 0
         GMIN  (IN) = 0
         NACT  (IN) = -9
         NMAP  (IN) = 0
         PFZPNT(IN) = 0
         PNACT (IN) = -9
         SIGT  (IN) = 0
         XSGTRN(IN) = 0
   20 CONTINUE
C
C -----  CLEAR ARRAY WHOSE DIMENSION IS MAXIND
C
      DO 30 I = 1, MAXIND
          DURINT(I) = 0
          PDURNT(I) = 0
   30 CONTINUE
C
C -----  CLEAR ARRAY WHOSE DIMENSION = APPROACHES * NODES
C
      IN = 5 * MAXND
      DO 40 I = 1, IN
         SIGI(I) = 0
   40 CONTINUE
C
C -----  CLEAR ARRAY OF CONDITIONAL TURN PROBABILITY DATA
C
      DO 50 I = 1, MAXCTD
         CTDATA(I) = 0
   50 CONTINUE
C
C -----  FOR CONSISTENCY, CLEAR FUEL ARRAYS HERE
C
      DO 60 I = 1, MXFUEL * 3
         XDIST (I) = 0
   60 CONTINUE
C
      DO 70 I = 1, MXFUEL * 12
         XEBUF(I) = 0
   70 CONTINUE
C
C -----  INITIALIZE PEDESTRIAN COEFFICIENT ARRAYS.
C
      ZFA(1) =   0.75
      ZFA(2) =   2.5
      ZFA(3) =   1.333
      ZFB(1) =   3.33
      ZFB(2) =  -2.5
      ZFB(3) =  -0.8333
      ZFC(1) =   0.3    
      ZFC(2) =   0.7
C
      ZZA(1) =   0.05
      ZZA(2) =   0.01
      ZZB(1) =   0.0
      ZZB(2) =  40.0            
      ZZC(1) =  1000.0
      ZZC(2) =  5000.0
C   
      RETURN
      END
      SUBROUTINE PRFDR (I1)                                                           
C                                                                                     
C                                                                                     
C --- CODED   10-28-97 BY E. LIEBERMAN                                                
C                                                                                     
C --- TITLE - IDENTIFY FEEDER LINKS - MODULE 2261.14.2                                
C                                                                                     
C --- FUNCTION - GET NUMBER OF LINK FEEDING THRU TRAFFIC TO DEPARTING
C ---            LINKS FROM NODE, IN     
C ---                                                                                 
C                                                                                     
C --- ARGUMENTS - I1  -  SPECIFIED NODE, FROM CALLING ROUTINE                                                             
C                                                                                     
C -------------------------   DESCRIPTION   ---------------------------               
C                             -----------                                             
C                                                                                     
C     LOOP OVER ALL APPROACHES TO NODE, IN.  GET THE THRU RECEIVING
C     LINK (IF IT EXISTS) FOR EACH.  STORE THE APPROACH LINK NUMBER
C     AS THE DEPARTING LINK'S FEEDER.
C                                                                                     
C -------------------   THIS ROUTINE CALLED BY   ----------------------               
C                       ----------------------                                        
C                                                                                     
C                    PRMAIR - MODULE 2261.14                                          
C                                                                                     
C ---------------------   THIS ROUTINE CALLS   ------------------------               
C                         ------------------                                          
C                                    
C                               NONE                 
C                                                                                     
C ---------------    GLOSSARY OF VARIABLE NAMES   ---------------------               
C                    --------------------------                                       
C        
C     FDRLNK  LINK ARRAY CONTAINING FEEDER LINK NUMBERS FOR ALL     
C             DEPARTING LINKS FROM NODE, IN
C     IA      INDEX OVER APPROACHES TO NODE, IN
C     IL      LINK NUMBER
C     ILT     LINK NUMBER RECEIVING THRU TRAFFIC
C     IN      NODE NUMBER
C     J       INDEX
C     SIGI    NODE SPECIFIC ARRAY - LINK ID NUMBER (APPROACH SPECIFIC) 
C     THRU    LINK SPECIFIC ARRAY - LINK RECEIVING THRU TRAFFIC
C                                                   
C ----------------------------------------------------------------------              
C                                                                                     
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)                     
C                                                                                     
      INCLUDE 'NETSIM.INC'                                                                
      INCLUDE 'AIRQUAL.INC'     
      INCLUDE 'GLOBAL.INC'     
C                                                                                     
      IN = I1
      J = 5 * (IN - 1)
         DO 10 IA = 1, 5
            J = J + 1
            IL = SIGI(J)
            IF (IL .GT. 0) THEN
               ILT = THRU(IL)
               IF (ILT .GT. 0 .AND. ILT .LT. 8000) FDRLNK(ILT) = IL
            ENDIF
   10    CONTINUE
      RETURN                                                                          
      END                                                                             
      SUBROUTINE STCELL (I1, I2)                                                   
C                                                                                     
C                                                                                     
C --- CODED   10-28-97 BY E. LIEBERMAN                                                
C                                                                                     
C --- TITLE - STORE VEHICLE DATA BY BLOCK - MODULE 3234.13                            
C                                                                                     
C --- FUNCTION - THIS ROUTINE RECONCILES A VEHICLE'S TRAJECTORY
C ---            OVER ONE TIME-STEP TO THE BLOCKS THAT ARE TRAVERSED           
C                                                                                     
C --- ARGUMENTS - I1  -  VEHICLE NUMBER, FROM CALLING ROUTINE      
C ---             I2  -  NODE NUMBER OF INTERSECTION BEING ANALYZED,
C ---                    FROM CALLING ROUTINE
C                                                                                     
C -------------------------   DESCRIPTION   ---------------------------               
C                             -----------         
C                                    
C     A VEHICLE TRAJECTORY OVER ONE TIME-STEP MAY TRAVERSE SEVERAL        
C     BLOCKS ON A LINK, REMAIN WITHIN ONE BLOCK, OR MOVE FROM AN
C     APPROACH LINK TO A DEPARTING LINK, OR FROM A DEPARTING LINK TO A
C     LINK DOWNSTREAM.  THIS ROUTINE IDENTIFIES THE BLOCKS TRAVERSED 
C     BY THE SUBJECT VEHICLE, IV, ON EITHER AN APPROACH OR DEPARTING
C     LINK RELATIVE TO THE SPECIFIED NODE, IN AND STORES THE
C     BLOCK-SPECIFIC TRAVERSAL TIME(S) AND DISTANCE IN THE PROPER 
C     CELL(S).
C                                                                                     
C -------------------   THIS ROUTINE CALLED BY   ----------------------               
C                       ----------------------                                        
C                                                                                     
C                    CLNUP - MODULE 3.2.3.4                                                                 
C                                                                                     
C ---------------------   THIS ROUTINE CALLS   ------------------------               
C                         ------------------                                          
C                                            
C                               NONE          
C                                                                                     
C ---------------    GLOSSARY OF VARIABLE NAMES   ---------------------               
C                    --------------------------                                       
C        
C     BLKREF  LINK SPECIFIC ARRAY - DISTANCE OF INTERSECTION CENTER 
C                                   FROM THE STOP-BAR
C     DISTUP  VEHICLE SPECIFIC ARRAY - DISTANCE OF VEH FROM UPSTM NODE
C     DAIRBL  ARRAY CONTAINING THE BLOCK NUMBER IN WHICH THIS VEHICLE
C             HAS TRAVELLED DURING (PART OF) THIS TIME STEP
C     DAIRSA  ARRAY CONTAINING SPEED AND ACCEL. CELL NUMBERS, PACKED
C             FOR EACH APPROACH
C     DAIRTM  ARRAY CONTAINING TIME VEHICLE SPENT IN THIS BLOCK AND 
C             APPROACH, TO NEAREST 250TH OF A SECOND WITHIN A ONE-
C             SECOND TIME-STEP
C     DAIRLN  ARRAY CONTAINING LANE AND ACTIVE SIGNAL PHASE FOR THIS
C             BLOCK AND APPROACH.  NEGATIVE IF VEHICLE DISCHARGED
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER
C     FDRLNK  LINK ARRAY CONTAINING FEEDER LINK NUMBERS FOR ALL      
C     FZINT   ARRAY THAT CONTAINS THE PHASE ASSOCIATED WITH EACH
C             INTERVAL
C     IA      APPROACH NUMBER
C     IACC    ACCEL. OF VEHICLE, IV, OVER TIME-STEP
C     IL      LINK NUMBER
C     ILN     LANE OCCUPIED BY VEHICLE, IV, AT END OF TIME-STEP
C     IN      CENTRAL NODE NUMBER
C     IV      VEHICLE NUMBER
C     IVT     VEH-FEET OF TRAVEL FOR VEHICLE, IV
C     JC      INDEX TO ACCEL. CELL IN MATRIX
C     JD      DISTANCE OF VEHICLE FROM UPSTREAM END OF CURRENT LINK
C     JV      INDEX TO SPEED CELL IN MATRIX
C     JVA     AVERAGE SPEED WITHIN BLOCK
C     KAIR    INDEX TO STORAGE ARRAYS
C     KAIRMX  MAXIMUM VALUE FOR KAIR INDEX
C     KAIRPT  ARRAY OF INDICES FOR THE DAIR ARRAYS
C     KSW     LOGICAL SWITCH
C     LKAQ    ARRAY OF APPROACHES AND DEPARTING LINKS
C     LPOS    INDEX OF BLOCK CURRENTLY OCCUPIED
C     NFLEET  VEHICLE ARRAY OF CODES INDENTIFYING FLEET COMPONENT
C     NMAP    USER SPECIFIED NODE NUMBER
C     NVHLNK  VEHICLE SPECIFIC ARRAY - LINK OCCUPIED
C     PRVLNK  VEHICLE SPECIFIC ARRAY - BITS (1-9) CONTAINING VEH'S
C                                      PREVIOUS LINK NUMBER 
C     RACC    ACCEL. OF VEHICLE, IV, OVER TIME-STEP
C     RDREF   DISTANCE TRAVELLED INTO THIS BLOCK
C     RDREFC  DISTANCE TRAVELLED INTO THIS BLOCK (BEFORE UPDATED TO
C             CONSIDER UPSTREAM BLOCK(S))
C     RDIS    DISTANCE FROM UPSTREAM END OF LINK                   
C     RDRLNK
C     RDTRVL  DISTANCE TRAVELLED BY VEHICLE, IV, IN ONE TIME-STEP
C     RFTM    CONVERSION FACTOR: FPS TO MPH
C     RMACC   ACCEL / DECEL IN MPH/S
C     RMTR    FEET / 10 METERS.  ALSO, BLOCK LENGTH, IN FEET         
C     RR      CURRENT DISTANCE FROM CENTER OF SUBJECT NODE
C     RSEC    RUNNING COUNT OF UNALLOCATED VEHICLE TRAVEL TIME
C     RSPD    VEHICLE SPEED AT END OF TIME-STEP, INITIALLY
C     RTRVL   DISTANCE TRAVELLED BY VEHICLE, IV, OVER TIME-STEP,
C             INITIALLY
C     RVSEC   TIME VEHICLE SPENT WITHIN A BLOCK
C     RVA     AVERAGE SPEED WITHIN BLOCK
C     RVSEC   TRAVEL TIME WITHIN THIS BLOCK
C     RVZ     VEHICLE SPEED UPON ENTRY TO THIS BLOCK
C     SPDLN   VEHICLE SPEDIFIC ARRAY - VEHICLE SPEED, FT/SEC
C     UPNOD   UPSTREAM NODE OF LINK
C     VSTATE  VEHICLE SPECIFIC ARRAY - STATUS CODE 
C     XLNGTH  LINK SPECIFIC ARRAY - LINK LENGTH 
C     YAIREX  APPROACH SPECIFIC ARRAY (T,F) IF KAIR (DOES,DOESNT) EXCEED
C             KAIRMX  
C     ZVMAIR  ARRAY CONTAINING VEH-FT OF TRAVEL ON EACH APPROACH
C             AND WITHIN EACH SPEED CELL
C     ZVMART  ARRAY CONTAINING VEH-FT OF TRAVEL ON EACH APPROACH,
C             FOR EACH VEHICLE TYPE CATEGORY
C     
C ----------------------------------------------------------------------              
C                                                                                     
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)                     
C                                                                                     
      INCLUDE 'NETSIM.INC'     
      INCLUDE 'AIRQUAL.INC'     
      INCLUDE 'GLOBAL.INC'     
C                                                                                     
      DATA RMTR /32.8084/
      DATA RFTM /0.68182/
C
C -----  PRIME ARGUMENTS.
C
      IV = I1
      IN = I2
      IL = NVHLNK(IV)
c     wdump = upnod(il) .eq. 2 .and. dwnod(il) .eq. 9
C
C -----  THIS ROUTINE IS ENTERED ONLY IF THE VEHICLE, IV, IS ON A LINK,
C -----  IL, THAT: (1) APPROACHES NODE, IN; (2) DEPARTS NODE, IN; OR
C -----  (3) DEPARTS A LINK THAT DEPARTS NODE, IN.
C      
      JN = MOD(PRVLNK(IV), 2**9)
      IF (JN .NE. 0) JN = UPNOD(JN)
C
C -----  TRA IF VEHICLE'S PRIOR LINK WAS OUTBOUND FROM NODE, IN, BUT IT
C -----  WAS NOT ON THAT LINK WITHIN THIS TIME-STEP
C -----  GET ITS CURRENT (END-OF-TIME-STEP) SPEED AND ITS (CONSTANT)
C -----  ACCELERATION OVER THE TIME STEP.
C
      RSPD = SPDLN(IV)
      IACC = ACCEL(IV)
      IF (ACCODE(IV) .EQ. 1) IACC = - IACC
      RACC = IACC
      IF (JN .EQ. IN) THEN
         IF (FLOAT (DISTUP(IV)) .GE. (RSPD - RACC/2.0))      GO TO 60
C
C -----  VEHICLE'S PRIOR LINK IS AN OUTBOUND LINK, IL, FROM NODE, IN.
C
         IL = MOD(PRVLNK(IV), 2**9)
C
C -----  GET TIME SPENT ON IL AND ITS DISCHARGE POSITION FROM IL
C
         RSEC = MAX (0.01, MIN (1.0, 1.0 - FLOAT (DISTUP(IV)) /
     1            MAX (0.01, (RSPD - 0.75 * RACC))))
         JD = MOD (XLNGTH(IL), 2**12)
      ELSE
C
C -----  VEHICLE IS NOW ON LINK, IL WHICH IS CONNECTED TO NODE, IN.  
C -----  SET TIME SPENT ON THIS LINK TO THE TIME-STEP, ONE SECOND.
C
         RSEC = 1.0
         JD = DISTUP(IV)
      ENDIF       
C      
C -----  LINK, IL, IS CONNECTED TO NODE, IN.  GET ITS APPROACH
C -----  INDEX, IA.
C
         DO 3 IA = 1, 10
            IF (LKAQ(IA) .EQ. IL)                            GO TO 6
    3    CONTINUE
      WRITE (LU6, 1000) IL, NMAP(IN)
      STOP      
    6 CONTINUE
C
C -----  LINK, IL IS EITHER AN APPROACH OR DEPARTING LINK RELATIVE
C -----  TO NODE, IN.  GET VEHICLE'S LOCATION ON LINK, IL, AT 
C -----  END OF THIS TIME-STEP.  FIRST, GET ITS LANE AND TYPE.
C
      IFZ = MOD (SIGT(IN), 2**4)
      IFZ = FZINT(IFZ)
      ILN = NLANE(IV)
      IVT = NFLEET(IV) + 1
C
C -----  CONVERT FROM FPSS TO MPHS AND GET THE ACCEL/DECEL CELL.
C
      RMACC = RACC * RFTM
      JC = MIN (MAX (INT (RMACC+11.0) / 2, 1), 9)
C
C -----  DISTANCE VEHICLE HAS TRAVELED DURING ONE SECOND TIME-STEP.
C -----  (ALSO EQUALS ITS MEAN SPEED).  IF VEHICLE DISCHARGED FROM
C -----  THE OUTBOUND LINK, (RDTRVL, RSEC) ARE (DISTANCE TRAVELLED,
C -----  TIME SPENT) ON OUTBOUND LINK.
C
      RDTRVL = MAX (RSPD - RACC / 2.0, 0.0) * RSEC
      RTRVL = RDTRVL
C
C -----  TRA IF LINK, IL, IS NOT AN APPROACH TO NODE, IN.
C      
      IF (DWNOD(IL) .NE. IN)                                 GO TO 15
C
C -----  LINK, IL, IS AN APPROACH TO NODE, IN.  RR IS THE VEHICLE'S
C -----  CURRENT DISTANCE FROM THE CENTER OF THE INTERSECTION.
C        
      RR = MAX (MOD (XLNGTH(IL), 2**12) - JD + BLKREF(IL), 0)
C    
C -----  TRA TO EXIT IF VEHICLE MORE THAN 1000 METERS (3280 FT) FROM 
C -----  CENTER OF INTERSECTION.
C
      IF (RR .GT. 100.0 * RMTR)                              GO TO 55
    7 CONTINUE
C
C -----  BLOCK NUMBER (VEHICLE NOW OCCUPIES) MINUS ONE.
C            
      LPOS = INT (RR / RMTR)
C
C -----  DISTANCE VEHICLE HAS TRAVELED WITHIN THIS BLOCK DURING THIS AND
C -----  POSSIBLY, PRIOR TIME-STEPS.
C            
      RDREF = (LPOS + 1) * RMTR - RR
C
C -----  LOOP UPSTREAM FROM BLOCK TO BLOCK.  START WITH THE BLOCK
C -----  NOW OCCUPIED.
C 
    8 CONTINUE
   10 CONTINUE
C
C -----  BLOCK NUMBER VEHICLE OCCUPIES.
C   
      LPOS = LPOS + 1
      KSW = 1
C
C -----  GET VEHICLE'S TRAVEL TIME IN BLOCK, LPOS, AND INCREMENT      
C -----  FEEDER LINK'S COUNTER, IF APPROPRIATE.
C
   12 CONTINUE      
C
C -----  GET INDEX TO LAST FILLED SLOT IN THE DATA ARRAYS.
C
      KAIR = KAIRPT
C
C -----  SET FLAG (REPEATEDLY) IF NUMBER OF VEHICLE TRAJECTORIES 
C -----  PROCESSED WITHIN THIS 15-MINUTE PERIOD, ON ALL LINKS CONNECTED
C -----  TO NODE, IN, EXCEEDS THE STORAGE CAPACITY OF THE DATA CELLS,
C -----  KAIRMX.
C
      YAIREX = KAIR .GT. KAIRMX
C
C -----  WRITE MESSAGE WHEN MAXIMUM STORAGE IS FILLED. GET RATIO OF 15
C -----  MINUTES TO CURRENT ELAPSED TIME WITHIN THAT TIME PERIOD.
C
      IF (KAIR .EQ. KAIRMX) THEN
         ID = NMAP(IN)
         IC = (CLOCK / 900) 
         RC = 90000.0 / FLOAT (CLOCK - IC * 900) - 100.0
         IC = IC + 1
         WRITE (LU6, 1010) ID, KAIRMX, IC, RC, CLOCK
      ENDIF   
C
C -----  DISTANCE VEHICLE TRAVELED THROUGH UPSTREAM BLOCK(S), THIS
C -----  TIME-STEP.
C            
      RTRVL = MAX (RTRVL - RDREF, 0.0)
C
C -----  VEHICLE SPEED AT ENTRY TO BLOCK OR AT BEGINNING OF
C -----  TIME-STEP IF IT BEGAN ITS TIME-STEP WITHIN THIS BLOCK.
C            
      RVZ = 0.0
      IF (RDTRVL .GT. 0.0) 
     1   RVZ = MAX (RSPD - RACC * MIN (RDTRVL, RDREF) 
     2         / RDTRVL, 0.0)
      RVA = (RSPD + RVZ) / 2.0
      JV = MIN (INT (RVA * RFTM + 5.0) / 5 + 1, 14)
      IF (RVA .LT. 1.466667) JV = 1
C
C -----  TRA IF VEHICLE STARTED ITS TRAJECTORY IN THIS BLOCK 
C -----  AT BEGIN OF TIME-STEP. SAVE VALUE OF DISTANCE TRAVELLED IN
C -----  BLOCK, LPOS.
C
      RDREFC = MIN (RDREF, RDTRVL)
      RVSEC = RSEC
      IF (RTRVL .LT. 0.000001)                               GO TO 13
C
C -----  VEHICLE, IV, HAS ENTERED THIS BLOCK DURING THIS TIME-
C -----  STEP.  TRAVEL TIME WITHIN THIS BLOCK.
C
      IF (RVA .GT. 0.0) RVSEC = MIN (RDREF / RVA, RSEC)
C
C -----  DISTANCE VEHICLE TRAVELED WITHIN UPSTREAM BLOCK.
C               
      RDREF = MIN (RTRVL, RMTR)
      RSPD = RVZ
C
C -----  REMAINING TRAVEL TIME AFTER DEDUCTING VEHICLE TRAVEL TIME
C -----  IN THIS BLOCK, LPOS.
C               
      RSEC = RSEC - RVSEC
      IF (RDREF .GT. 0.00001 .AND. (KSW .EQ. 1 .OR. 
     1    (KSW .EQ. -1 .AND. LPOS .GT. 1))) THEN
C
C -----  VEHICLE DISCHARGED FROM UPSTREAM BLOCK DURING THIS TIME-
C -----  STEP.  GET ITS SPEED CELL IN PRIOR BLOCK AND BUMP COUNTER.
C               
         RVA = RSPD - RACC * RDREF / RDTRVL / 2.0
      ENDIF
C
C -----  ADD TRAVEL TIME WITHIN THIS BLOCK, INTO MATRIX IF ARRAY SIZE
C -----  NOT EXCEEDED.    
C            
   13 CONTINUE
C
C -----  TRA IF ARRAY SIZE EXCEEDED OR BLOCK NUMBER .GT. 100
C
      IF (YAIREX .OR. LPOS .GT. 100)                         GO TO 14
      KAIR = KAIR + 1
      DAIRSA(KAIR) = 9 * (JV - 1) + (JC - 1)
C
C -----  TRA IF NOT AN APPROACH LINK.
C
      IF (KSW .NE. 1)                                        GO TO 135       
C
C -----  TEST WHETHER RVSEC IS BASED ON A VEHICLE TRAJECTORY WHICH 
C -----  BEGAN IN BLOCK, LPOS, AT A DISTANCE THAT EXCEEDED THE LENGTH
C -----  OF APPROACH LINK, IL, PLUS THE DISTANCE FROM THE STOP-BAR TO
C -----  THE INTERSECTION CENTER.  ALSO CHECK WHETHER THE BLOCK IN WHICH 
C -----  VEHICLE, IV, RESIDES AT THE END OF THE TIME-STEP, EXTENDS 
C -----  BEYOND THE LINK LENGTH. 
C      
      REX = RDREFC + RMTR * FLOAT(LPOS - 1) - 
     1               FLOAT (MOD(XLNGTH(IL), 2**12) + BLKREF(IL))
      IF (RR + RDREFC .GT. FLOAT (MOD (XLNGTH(IL), 2**12) + BLKREF(IL))
     1    .AND. REX .LT. 0.0)
     2   REX = RR + RDREFC - FLOAT(MOD (XLNGTH(IL), 2**12) + BLKREF(IL))
      IF (REX .GT. 0 .AND. RDREFC .GT. 0) THEN
C
C -----  YES. MUST REDUCE RVSEC TO COVER TRAVEL ONLY WITHIN LINK, IL
C
         RVSEC = RVSEC * MIN (1.0, MAX (0.01, (RDREFC -REX) / RDREFC))
         RDREFC = MAX (0.0, RDREFC - REX)
      ENDIF   
C
C -----  HANDLE CASE WHERE VEHICLE JUST ENTERED APPROACH DURING THIS
C -----  TIME-STEP AND HAS NOT CROSSED A BLOCK BOUNDARY.
C
      IF (JD .LE. SPDLN(IV) .AND. RR.GE. INT(FLOAT(MOD(XLNGTH(IL),2**12)
     1    + BLKREF(IL)) / RMTR) * RMTR) THEN
         RVSEC = MIN (1.0, MAX (0.01, FLOAT(JD) / MAX (1.0, (RSPD - RACC
     1           / 4.0))))
         RDREFC = JD
         RTRVL = 0.0
      ENDIF
  135 CONTINUE   
      JJ = NINT (RVSEC * 250.)
      IF (JJ .EQ. 128) JJ = 129
      IF (JJ .GT. 127) THEN
         DAIRTM(KAIR) = - (JJ - 128)
      ELSE  
         DAIRTM(KAIR) = JJ
      ENDIF   
      DAIRBL(KAIR) = LPOS
      DAIRLN(KAIR) = IFZ * 2**3 + ILN
      DAIRIA(KAIR) = IA
C
C -----  STORE CONTRIBUTION TO VMT AT THIS SPEED.
C
      ZVMAIR(IA,JV) = ZVMAIR(IA,JV) + RDREFC
      ZVMART(IA,IVT) = ZVMART(IA,IVT) + RDREFC
   14 CONTINUE  
C
C -----  STORE UPDATED INDEX IN COMMON.
C
      KAIRPT = KAIR
C
C -----  TRA IF THIS BLOCK IS ON DEPARTING LINK.
C     
      IF (KSW .EQ. -1)                                       GO TO 25
C
C -----  LOOP TO PROCESS VEHICLE IN UPSTREAM BLOCK IF IT TRAVELED
C -----  THEREIN DURING THIS TIME-STEP AND THE UPSTREAM BLOCK IS
C -----  AT LEAST PARTIALLY, WITHIN APPROACH, IA (LINK IL).
C     
      IF (RTRVL .GT. 0.000001 .AND. FLOAT(LPOS) * RMTR .LT.
     1    MIN (100.0 * RMTR, MOD (XLNGTH(IL), 2**12)
     2               + BLKREF(IL)))                          GO TO 10
C
C -----  VEHICLE TRAJECTORY PROCESSED.  TRA TO RETURN.
C
                                                             GO TO 50
   15 CONTINUE
C
C -----  LINK, IL, IS DEPARTING FROM NODE, IN. IDENTIFY FEEDER
C -----  LINK, IF ANY.
C
      ILF = FDRLNK(IL)
      LPOS = 0
      IF (ILF .GT. 0) LPOS = BLKREF(ILF)
C
C -----  RR IS DISTANCE FROM CENTER OF (UPSTREAM) INTERSECTION TO 
C -----  FRONT OF VEHICLE.  IT IS NEGATIVE IF VEHICLE IS WITHIN
C -----  INTERSECTION BUT UPSTREAM OF ITS CENTER.  IF SO, IT
C -----  IS ON A BLOCK BELONGING TO THE APPROACH (FEEDER) LINK.
C            
      RR = JD - LPOS
      IF (RR .LT. 0.000001) THEN
C
C -----  VEHICLE IS ON A BLOCK BELONGING TO THE FEEDER APPROACH LINK,
C -----  ILF.  SET UP TO PROCESS VEHICLE AND TRA (NOTE: ILF MUST
C -----  EXIST FOR RR TO BE .LT. 0).
C
         IL = ILF
C
C -----  LINK, IL, IS CONNECTED TO NODE, IN.  GET ITS APPROACH 
C -----  INDEX, IA.
C
         DO 17 IA = 1, 10
            IF (LKAQ(IA) .EQ. IL)                            GO TO 19
   17    CONTINUE
         WRITE (LU6, 1000) IL, NMAP(IN)
         CALL EXIT
   19    CONTINUE
         RR = MAX (-RR, 0.0)
                                                             GO TO 7
      ENDIF                                                    
C    
C -----  TRA TO EXIT IF VEHICLE MORE THAN 1000 METERS (3280 FT) FROM 
C -----  CENTER OF INTERSECTION AT BEGINNING OF TIME-STEP.
C
      IF (RR - RDTRVL .GT. 100.0 * RMTR)                     GO TO 55
C
C -----  VEHICLE, IV, IS ON A BLOCK BELONGING TO OUTBOUND LINK, IL,
C -----  AT END OF TIME-STEP.  LPOS IS THIS BLOCK NUMBER MINUS ONE.
C
      LPOS = INT (RR / RMTR)
C
C -----  DISTANCE OF VEHICLE FROM UPSTREAM END OF ITS BLOCK, 
C -----  LPOS + 1.
C               
      RDREF = RR - LPOS * RMTR
      LPOS = LPOS + 2
C
C -----  LOOP TO PROCESS VEHICLE TRAJECTORY THROUGH UPSTREAM BLOCKS
C -----  ON DEPARTING LINK.
C      
   20 CONTINUE
C
C -----  LPOS IN FIRST PASS THROUGH THE LOOP IS BLOCK OCCUPIED 
C -----  BY VEHICLE AT END OF TIME-STEP. THEREAFTER LPOS 
C -----  IDENTIFIES UPSTREAM BLOCKS THROUGH WHICH VEHICLE
C -----  TRAVELED DURING THIS TIME-STEP.
C   
      LPOS = LPOS - 1
C
C -----  TRA TO USE EXISTING CODE, THEN RETURN HERE.
C
      KSW = -1
                                                             GO TO 12
   25 CONTINUE                                                   
C
C -----  TRA IF THIS IS BLOCK NO. 1 ON DEPARTING LINK, IL, AND
C -----  A PORTION OF THIS VEHICLE'S TRAVEL DURING THIS
C -----  TIME-STEP TOOK PLACE ON THE FEEDER LINK.
C
      IF (LPOS .EQ. 1 .AND. RTRVL .GT. 0.000001)             GO TO 30
C
C -----  TRA TO LOOP TO PROCESS VEHICLE TRAJECTORY IN UPSTREAM
C -----  BLOCK.
C      
      IF (RTRVL .GT. 0.000001)                               GO TO 20
C
C -----  TRAJECTORY PROCESSED.  TRA TO RETURN.
C      
                                                             GO TO 40 
C
C -----  VEHICLE ON BLOCK NO. 1 OF DEPARTING LINK. IF NO FEEDER 
C -----  LINK, ASSIGN ENTIRE (REMAINDER OF) TIME-STEP TO THIS BLOCK 
C -----  AND RETURN.
C
   30 CONTINUE  
      IF (ILF .EQ. 0) THEN
         IF (.NOT. YAIREX) THEN
            JJ = NINT (RSEC*250.0)
            IF (JJ .EQ. 128) JJ = 127
            IF (JJ .GT. 127) THEN
               DAIRTM(KAIR) = - (JJ - 128)
            ELSE
               DAIRTM(KAIR) = JJ
            ENDIF
            DAIRIA(KAIR) = IA
C
C -----  STORE CONTRIBUTION TO VMT AT THIS SPEED.
C
            ZVMAIR(IA,JV) = ZVMAIR(IA,JV) + RDREF 
            ZVMART(IA,IVT) = ZVMART(IA,IVT) + RDREF 
         ENDIF         
      ELSE
C
C -----  PRIOR BLOCK IS BLOCK NO. 1 ON FEEDER LINK, ILF.  
C -----  BUMP BLOCK VEHICLE COUNTER, THEN TRA TO COMPLETE
C -----  PROCESSING OF VEHICLE TRAJECTORY ON BLOCKS BELONGING 
C -----  TO FEEDER LINK, ILF.
C
         IL = ILF
C
C -----  APPROACH (FEEDER) LINK, IL, IS CONNECTED TO NODE, IN.  
C -----  GET ITS APPROACH INDEX, IA.
C
            DO 33 IA = 1, 10
               IF (LKAQ(IA) .EQ. IL)                         GO TO 36
   33       CONTINUE
         WRITE (LU6, 1000) IL, NMAP(IN)
         CALL EXIT
   36    CONTINUE
C
C -----  GET DISTANCE TRAVELLED ON BLOCK NO. 1 OF FEEDER APPROACH.
C   
         LPOS = 0
         RDREF = MIN (RTRVL, RMTR)
                                                             GO TO 8
      ENDIF                                                       
C
   40 CONTINUE
   50 CONTINUE
   55 CONTINUE
   60 CONTINUE
      RETURN                                                       
 1000 FORMAT (' ', 35X, 'LINK', I4,' NOT CONNECTED TO NODE ', I4)      
 1010 FORMAT (' ',  8X, 'THE NUMBER OF VEHICLE TRAJECTORY SEGMENTS',
     1                  ' IN ALL 10-METER BLOCKS',/
     2              9X, ' AT NODE ', I4, ' HAS',
     3                  ' EXCEEDED THE UPPER BOUND OF ', I7, ' DURING',
     *                  ' 15 MINUTE PERIOD NO.', I4 //
     4              9X, ' THE COMPUTED VALUES OF VEHICLE-SECONDS WILL',   
     5                  ' BE EXPANDED BY APPROXIMATELY',F6.1,' PERCENT',
     A          //, 9X, ' TO PROVIDE DATA FOR THIS 15 MINUTE PERIOD.'
     6          //, 9X, ' THE',
     7                  ' ELAPSED SIMULATION TIME IS ', I7, 
     8                  ' SECONDS.')
      END                                                                             
      SUBROUTINE INTOFZ(I1)
C                                                                                     
C                                                                                     
C --- CODED   10-28-97 BY E. LIEBERMAN                                                
C                                                                                     
C --- TITLE -  IDENTIFY SIGNAL PHASES - MODULE 2261.14.3                              
C                                                                                     
C --- FUNCTION - OPERATE ON SPECIFIED SIGNAL INTERVALS TO IDENTIFY 
C ---            SIGNAL PHASES AT SPECIFIED NODE
C ---                                                                          
C                                                                                     
C --- ARGUMENTS - I1  -  SUBJECT NODE NUMBER, FROM CALLING ROUTINE
C                                                                                     
C -------------------------   DESCRIPTION   ---------------------------               
C                             -----------                                             
C                                                                         
C     COMPARE THE PATTERNS OF TRAFFIC MOVEMENTS SERVICED ON ALL 
C     APPROACHES BETWEEN TWO SEQUENTIAL SIGNAL INTERVALS.  IF THE
C     PATTERN DIFFERS, THE SECOND INTERVAL STARTS A NEW PHASE.  
C     REPEAT COMPARISON FOR ALL INTERVALS.  A YELLOW INTERVAL CONTINUES 
C     A PHASE, AS DOES AN ALL-RED INTERVAL.
C                                                                                     
C -------------------   THIS ROUTINE CALLED BY   ----------------------               
C                       ----------------------                                        
C                                                                                     
C                    PRMAIR - MODULE 2261.14                                          
C                                                                                     
C ---------------------   THIS ROUTINE CALLS   ------------------------               
C                         ------------------                                          
C                                            
C                               NONE     
C                                                                                     
C ---------------    GLOSSARY OF VARIABLE NAMES   ---------------------               
C                    --------------------------                                       
C        
C     FZPNTR  POINTER TO DURINT ARRAY                                       
C     I       INDEX
C     IA      LINK INDEX
C     II      COUNTER INDEX
C     IL      LINK NUMBER
C     IN      NODE NUMBER                                                  
C     INT     ARRAY OF INTERVAL CODES
C     INTMX   NUMBER OF INTERVALS                                           
C     J       INTERVAL CODE                       
C     JJ      PHASE COUNTER
C     K       NUMBER OF APPROACHES                                                        
C     PHSMX   NUMBER OF PHASES AT NODE, IN
C     W       FLAG (T,F) IF THIS INTERVAL (IS,IS NOT) SAME AS PREVIOUS 
C             INTERVAL
C     WAR     FLAG (T,F) IF THIS INTERVAL (IS,IS NOT) ALL RED
C     XINT1   LINK SPECIFIC ARRAY - MOVEMENT CODES FOR INTERVALS 1 - 6
C     XINT2   LINK SPECIFIC ARRAY - MOVEMENT CODES FOR INTERVALS 7 - 12
C            
C ----------------------------------------------------------------------              
C                                                                                     
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)                     
C                                                                                     
      INCLUDE 'NETSIM.INC'     
      INCLUDE 'AIRQUAL.INC'     
      INCLUDE 'GLOBAL.INC'     
C
      DIMENSION INT (5, 12)       
C
      IN = I1
      INTMX = FZPNTR(IN) / 2**11
      JJ = 0
      J = 5 * (IN - 1)
C
C -----  LOOP OVER APPROACHES TO IN.
C
         DO 20 IA = 1, 5
            J = J + 1
            IL = SIGI(J)
            IF (IL .EQ. 0)                                   GO TO 25
C
C -----  TRA IF SIGN, OR NO SIGNAL CONTROL.
C
            IF (XINT1(IL) / 2 .EQ. 15 .OR. XINT1(IL) .EQ. 16
     1                                .OR. XINT1(IL) .EQ. 0) GO TO 60 
C            
C -----  STORE INTERVAL CODES SERVICING APPROACHES TO NODE, IN.
C
            K = 0
               DO 10 I = 1, 6
                  INT (IA,I) = MOD (XINT1(IL)/2**K, 2**5)
                  IF (XINT2(IL) .GT. 0)
     1               INT (IA,I+6) = MOD (XINT2(IL)/2**K, 2**5)  
                  K = K + 5
   10          CONTINUE
   20    CONTINUE
      IA = IA + 1
C
C ----------------------------------------------------------------------              
C
C     LOOP OVER APPROACHES AND SIGNAL INTERVALS TO AGGREGATE      
C     SIGNAL INTERVALS INTO PHASES.  IF, IN INTERVAL, I, ANY      
C     MOVEMENT FROM ANY APPROACH IS SERVICED BY AN INDICATION     
C     (GO OR NO-GO) THAT DIFFERS FROM THE INDICATION (GO OR NO-GO)
C     IN THE PRIOR INTERVAL, THEN INTERVAL, I, IS (THE START OF)  
C     A NEW PHASE.  A YELLOW INTERVAL WILL BE TREATED AS AN       
C     EXTENSION OF THE PRIOR INTERVAL FOR THIS PURPOSE.  AN       
C     ALL RED INTERVAL WILL LIKEWISE BE ASSIGNED TO THE CURRENT   
C     SIGNAL PHASE.  EACH INTERVAL WILL BE ASSIGNED TO A PHASE.   
C
C ----------------------------------------------------------------------              
C
   25 CONTINUE
      K = IA - 1
C
C -----  LOOP OVER ALL SIGNAL INTERVALS.
C      
         DO 40 I = 1, INTMX
            W = .TRUE.
            WAR = .TRUE.
C
C -----  LOOP OVER THE K APPROACHES.
C            
               DO 30 IA = 1, K
                  J = INT(IA,I)
C
C -----  FLAG REMAINS .T. IF SIGNAL INTERVAL IS RED FOR ALL
C -----  MOVEMENTS.
C                  
                  WAR = WAR .AND. J .EQ. 15
C
C -----  PROCESS YELLOW INTERVAL.  SET CODES TO THOSE OF PRIOR
C -----  INTERVAL.
C
                  II = I - 1
                  IF (I .EQ. 1) II = INTMX
                  IF (J .EQ. 24) THEN
                     INT(IA,I) = INT(IA,II)
                  ELSE
C
C -----  FLAG REMAINS .T. IF MOVEMENTS SERVICED BY THIS INTERVAL, I,
C -----  ARE THE SAME AS THOSE SERVICED IN PRIOR INTERVAL, II.
C                  
                     W = W .AND. INT(IA,I) .EQ. INT(IA,II)
                  ENDIF
   30          CONTINUE
C
C -----  INTERVAL, I, IS THE START OF PHASE, JJ, IF IT IS NOT
C -----  ALL-RED AND THE SIGNAL INDICATIONS FOR AT LEAST ONE
C -----  APPROACH DIFFER FROM THOSE OF THE PRIOR INTERVAL, II.
C
            IF (.NOT. WAR .AND. .NOT. W) JJ = JJ + 1
            FZINT(I) = JJ
   40    CONTINUE
C
C -----  IF FIRST INTERVAL(S) BELONGED TO THE LAST PHASE THEN
C -----  SET FZINT ACCORDINGLY. (IT WOULD BE ZERO INITIALLY).
C
         DO 50 I = 1, 2
            IF (FZINT(I) .EQ. 0) FZINT(I) = MAX (1, JJ)
   50    CONTINUE
C
C -----  WRITE MESSAGE AND EXIT IF FEWER THAN 2 PHASES OR MORE
C -----  THAN 8 PHASES.
C
   60 CONTINUE
      IF (JJ .LT. 2 .OR. JJ .GT. 8) THEN
         WRITE (LU6, 1000) JJ, NMAP(IN)
         CALL EXIT
      ENDIF
C
C -----  STORE THE NUMBER OF PHASES.
C
      PHSMX = JJ
C
C -----  WRITE THE PHASE/INTERVAL ASSIGNMENTS.
C
C     WRITE (LU6, 1010) (INT(IA,I), I = 1, INTMX)     
C     WRITE (LU6, 1020) (FZINT(I), I = 1, INTMX)
      RETURN
C
 1000 FORMAT ('0', 25X, ' THERE ARE ', I3, 'SIGNAL PHASES.  THIS IS',
     1                  ' NOT ACCEPTABLE: THERE MUST BE BETWEEN 2 AND',
     2                  ' 8 PHASES.'/
     3             25X, ' CHECK YOUR SIGNAL SPECIFICATIONS AT THE',
     4                  ' SELECTED NODE ', I5)
 1010 FORMAT ('0', 5X, ' RELATIONSHIP BETWEEN SPECIFIED SIGNAL',
     1                 ' INTERVALS AND DERIVED SIGNAL PHASES'//
     2             5X, ' INTERVAL: ', 12I5)
 1020 FORMAT ('0', 4X, 'PHASES:  ', 12I5)    
      END        
      SUBROUTINE RD03
C
C --- CODED    3-20-78 BY B. ANDREWS
C --- REVISED 10-28-91 BY A. KANAAN TO NOT CHECK LENGTH IF ONLY TA 
C --- REVISED 11-13-97 BY K. SHERIDAN FOR AIR QUALITY MODELING 
C
C --- TITLE - READ, CHECK AND STORE DATA ITEMS IN CARD TYPE 03
C ---         MODULE 2.6.3
C
C --- FUNCTION - THIS MODULE PROCESSES CARD TYPE 03
C
C --- ARGUMENTS - NONE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     WHEN THIS ROUTINE IS CALLED CARD TYPE 03 IS EXPECTED TO APPEAR
C     NEXT IN THE INPUT STREAM. THIS ROUTINE WILL READ, CHECK, STORE
C     AND PRINT THE CONTENTS OF THE TYPE 03 CARD.  FOR AIR QUALITY
C     MODELING, ALLOW 114 TIME PERIODS TO BE SPECIFIED.
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                    GETRNC - MODULE 2.6
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                    ERGEN  - MODULE 2.6.1.1
C                    RDNUM  - MODULE 2222.1.1.1
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ---------------------
C                    --------------------------
C
C     I       DO-LOOP INDEX
C     ILAST   TIME PERIOD DURATION OF LAST TP ON A RECORD
C     J       COUNTER OF TIME PERIODS 
C     MAXTPR  MAXIMUM ALLOWABLE NUMBER OF TIME PERIODS ON A RECORD
C     LNTMPR  TP SPECIFIC ARRAY - TP LENGTHS (SEC.)
C     MAXTP   MAXIMUM ALLOWABLE NUMBER OF TIME PERIODS
C     TYPERN  TYPE REQUESTED (1=SIM, 2=TA, 3=BOTH), (-=DIAGNOSTIC ONLY)
C     WFIRST  FLAG .TRUE. IF FIRST RECORD TYPE 03 BEING PROCESSED
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS
C
C ---------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'GLOBAL.INC'
C
      J = 0
      WFIRST = .TRUE.
      CALL RDNUM
   10 CONTINUE   
C
C -----  DOUNTIL ALL TIME PERIOD LENGTHS CHECKED
C -----  TRA IF TP LENGTH OK, ELSE PRINT MESSAGE
C
      DO 60 I = 1, MAXTPR
         IF (XBUF(I) .GE. 10) THEN
            J = J + 1
C             
C -----  IF MORE THAN ONE RECORD TYPE 03 WAS SPECIFIED AND
C -----  A NON-ZERO LENGTH FOLLOWS A ZERO LENGTH ON THE PRIOR 
C -----  RECORD, PRINT MESSAGE.
C
             IF (.NOT. WFIRST) THEN
                IF (I .EQ. 1 .AND. ILAST .EQ. 0)
     1              CALL ERGEN ('RD03  ', 2032, I, XBUF(I), 19, 0, 3)
             ENDIF   
         ELSE
             IF (XBUF(I) .NE. 0) 
     1           CALL ERGEN ('RD03  ', 2030, J, XBUF(I), 0, 0, 2)
C
C -----  IF ZERO LENGTH PRECEDES NON-ZERO LENGTH PRINT MESSAGE
C
             IF (XBUF(I).EQ.0 .AND. XBUF(I+1).NE.0 .AND. I.LT. MAXTPR) 
     1           CALL ERGEN ('RD03  ', 2032, I, XBUF(I), I+1, 0, 3)
         ENDIF
C
C -----  STORE TIME PERIOD DURATION.
C         
         IF (J .LE. MAXTP) THEN
            IF (XBUF(I) .GT. 0) LNTMPR(J) = XBUF(I)
         ELSE
            CALL ERGEN ('RD03  ', 2033, MAXTP, J, 0, 0, 2)
         ENDIF  
   60 CONTINUE
      ILAST = XBUF(MAXTPR)
C
C -----  IF NO TP LENGTH AND NOT TA ONLY, ISSUE MESSAGE
C
      IF (ABS(TYPERN) .NE. 2  .AND.  J .EQ. 0) 
     1    CALL ERGEN ('RD03  ', 2030, 1, XBUF(1), 0, 0, 2)
C
C -----  GET NEXT RECORD TYPE 03, IF IT EXISTS.  
C
      CALL RDNUM
      IF (XBUF(20) .EQ. 3) THEN
         WFIRST = .FALSE.
                                                             GO TO 10
      ENDIF                                                       
C
      RETURN
      END
      SUBROUTINE RD04 (WXPLAN)
C
C
C --- CODED    3-21-78 BY B. ANDREWS
C --- REVISED 11-13-86 BY A. HALATI (FOR FRESIM)
C --- REVISED  2-16-90 BY J. MEKEMSON TO SET UPPER & LOWER BOUNDS OF LENINT
C --- REVISED 10-28-91 BY A. KANAAN TO SET DEFAULT TIME SLICES TO 15
C --- REVISED 12-28-92 BY J. COTTON TO INTEGRATE FRESIM AND RESTRUCTURE
C --- REVISED 12-28-94 BY S. WALKER TO REQUIRE FRESIM TIME STEP TO BE AN
C ---                        INTEGER (FOR CORSIM ONLY)
C --- REVISED 11-13-97 BY K. SHERIDAN FOR AIR QUALITY MODELING
C
C --- TITLE - READ, CHECK AND STORE DATA ITEMS IN CARD TYPE 04 -
C ---         MODULE 2.6.4
C
C --- FUNCTION - THIS MODULE PROCESSES CARD TYPE 04
C
C --- ARGUMENTS - WXPLAN - ARRAY OF FLAGS (T,F) IF EXPLANATIONS
C ---                      IN RUN CONTROL TABLE (ARE, ARE NOT)
C ---                      REQUIRED TO BE PRINTED
C ---                      TO THE CALLING ROUTINE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     WHEN THIS ROUTINE IS CALLED CARD TYPE 04 IS EXPECTED TO BE
C     IN THE INPUT BUFFER ARRAY. THIS ROUTINE WILL READ, CHECK, STORE
C     AND PRINT THE CONTENTS OF THE TYPE 04 CARD
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                    GETRNC - MODULE 2.6
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                    ERGEN  - MODULE 2.6.1.1
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ---------------------
C                    --------------------------
C
C     I       DO LOOP INDEX AND DIVISOR
C     ILEN    FULL WORD EQUIVALENT OF LENINT
C     INUM    NUMBER OF TIME INTERVALS IN INITIALIZATION PERIOD
C     ITMIN   FULL WORD EQUIVALENT OF TMINIT
C     LENINT  LENGTH OF A TIME INTERVAL, SECONDS
C     LNTMPR  TP SPECIFIC ARRAY - TP LENGTHS (SEC.)
C     LU7     PERIPHERAL UNIT NUMBER 7
C     MAXTP   MAXIMUM ALLOWABLE NUMBER OF TIME PERIODS
C     NSLICE  NUMBER OF TIME SLICES PER TIME INTERVAL
C     SLIDUR  DURATION OF A TIME SLICE, HUNDREDTHS-OF-A-SEC
C     TMINIT  INITIALIZATION TIME (TIME INTERVALS)
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS
C     YSUB    FLAG FOR EXISTING SUBNETWORKS IN THE SYSTEM
C     ZSSTEP  FRESIM TIME STEP DURATION (SECONDS)
C
C ---------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'GLOBAL.INC'
C
      DIMENSION WXPLAN(24)
C
C -----  CHECK NEXT RECORD. IF NOT A TYPE 4 REPOSITION UNIT 7
C -----  AND TRA (TYPE 4 CARD NOT REQUIRED FOR SOME TYPES OF
C -----  FRESIM FUEL RUNS)
C
      IF (XBUF(20) .NE. 4) THEN
         BACKSPACE LU7
      ELSE
C
C -----  ASSUME THAT MODEL WILL NOT OVERRIDE USER SPECIFICATIONS AND
C -----  NO EXPLANATIONS WILL NEED TO BE PRINTED IN RUN CONTROL TABLE.
C
         DO 5 I = 1, 24
            WXPLAN(I) = .FALSE.
    5    CONTINUE
C
C -----  STORE THE VALUE OF THE TIME INTERVAL.  IF TIME INTERVAL
C -----  DURATION IS MISSING, SET INTERVAL TO DEFAULT OF 60 SECONDS
C -----  AND FLAG TO PRINT * AND EXPLANATION IN TABLE 
C
         IF (XBUF(5) .NE. 0) THEN
            LENINT = XBUF(5)
            IF (LENINT .LT. 1  .OR.  LENINT .GT. 200) THEN
               CALL ERGEN ('RD04  ', 206, XBUF(5), 0, 0, 0, 1)
            ENDIF
            IF (XNODE .GT. 0) THEN
               IMULT = 900 / LENINT
               IF (IMULT * LENINT .NE. 900) THEN
                  WRITE (LU6, 1000) LENINT
                  LENINT = 60
               ENDIF   
            ENDIF   
         ELSE
            WXPLAN(20) = .TRUE.
            LENINT = 60
         ENDIF
C
C -----  CHECK THAT ALL TIME PERIODS ARE MULTIPLES OF SPECIFIED TIME
C -----  INTERVAL. IF NOT, MODIFY TIME PERIOD DURATION AND SET FLAG
C -----  TO PRINT * AND EXPLANATION IN TABLE.
C
         ILEN = LENINT
         DO 50 I = 1, MAXTP
            IF ((LNTMPR(I)/LENINT)*LENINT .NE. LNTMPR(I)) THEN
               WXPLAN(I) = .TRUE.
               LNTMPR(I) = MAX0 ((LNTMPR(I)/ILEN)*ILEN, ILEN)
            ENDIF
   50    CONTINUE
C
C -----  STORE THE FRESIM TIMESTEP, IF NEED TO SET TO DEFAULT THEN SET
C -----  TO ONE SECOND, AND CHECK THAT IT IS LESS THAN NINE SECONDS.
C -----  CHECK THAT THE FRESIM TIMESTEP IS A MULTIPLE OF THE TIME
C -----  INTERVAL.  IF NOT, SET TIMESTEP TO DEFAULT OF ONE SECOND.
C -----  IF A CORSIM RUN, ENSURE THAT FRESIM TIME STEP IS AN INTEGER.
C
         ZSSTEP = XBUF(4)/10.
         IF (ZSSTEP .LE. 0) THEN
            ZSSTEP = 1.
         ELSE IF (ZSSTEP .GT. 9) THEN
            CALL ERGEN ('RD04  ', 300, XBUF(4), 0, 0, 0, 1)
         ELSE
            ISTEP = XBUF(4)
            IF (((LENINT*10)/ISTEP)*ISTEP .NE. LENINT*10) THEN
               WXPLAN(24) = .TRUE.
               ZSSTEP = 1.
            ENDIF
            IF (YSUB(3) .AND. YSUB(8) .AND. MOD(ISTEP,10) .GT. 0)
     1         CALL ERGEN ('RD04  ', 2028, XBUF(4), 0, 0, 0, 1)
         ENDIF
C
C -----  CALCULATE WIDTH OF HISTOGRAM SLICES (HUNDREDTHS-OF-A-SEC)
C -----  IF NO. OF TIME SLICES OMITTED, SET TO DEFAULT OF 15 AND SET
C -----  FLAG TO PRINT * AND EXPLANATION IN TABLE
C
         IF (XBUF(6) .GT. 0) THEN
            NSLICE = XBUF(6)
            IF (XBUF(6) .NE. NSLICE) WXPLAN(22) = .TRUE. 
         ELSE
            WXPLAN(21) = .TRUE.
            NSLICE = 15
         ENDIF
         SLIDUR = LENINT / NSLICE
C
C -----  CHECK THAT THE SLICE DURATION IS BETWEEN 0 AND 5 SECONDS, IS 
C -----  AN INTEGER MULTIPLE OF THE TIME INTERVAL AND IS LESS THAN 50
C
         IF (YSUB(6) .AND. 
     1       (SLIDUR .LT. 2  .OR.  SLIDUR .GT. 5  .OR. 
     2        SLIDUR*NSLICE .NE. LENINT .OR. NSLICE .GT. 50))             
     3      CALL ERGEN ('RD04  ', 2001, LENINT, SLIDUR, NSLICE, 0, 3)
         SLIDUR = SLIDUR * 100
C
C -----  CONVERT INITIALIZATION TIME (MINUTES) TO TIME INTERVALS
C -----  INITIALIZATION MUST BE AT LEAST 3 TIME INTERVALS
C
         ITMIN = TMINIT
         INUM = ((IABS(ITMIN)*60) + LENINT / 2) / LENINT
         IF (INUM .LT. 3) THEN
            WXPLAN(23) = .TRUE.
            INUM = 3
         ENDIF
         TMINIT = ISIGN (INUM, ITMIN)
      ENDIF
C
 1000 FORMAT (/, ' TO PRODUCE AIR QUALITY STATISTICS, THE TIME'
     1           ' INTERVAL DURATION', I4,' SECONDS',
     2           ' SPECIFIED ON RECORD TYPE 04 MUST BE AN INTEGER',
     3           ' DIVIDER OF 900 SECONDS.  TIME INTERVAL',
     4           ' DURATION HAS BEEN CHANGED TO 60 SECONDS.')
      RETURN
      END
      SUBROUTINE TVALID
C
C --- CODED    4-01-78 BY B. ANDREWS
C --- REVISED  4-16-87 BY O. SHARAF-ELDIEN TO READ TYPE 3 CARD CORRECTLY
C --- REVISED 10-15-87 BY K. SHERIDAN (FOR NETSIM SIGNAL TRANSITION)
C --- REVISED  4-16-90 BY B. ANDREWS TO CHANGE CONDITIONS FOR ERROR/GRAPHICS
C --- REVISED 10-30-91 BY A. KANAAN TO NOT CHECK TP LENGTH IF TA ONLY
C --- REVISED 12-31-91 BY J. WERK TO ALLOW ONLY ONE TYPE 5 CARD          
C --- REVISED  5-11-93 BY A. KANAAN TO ALLOW NO ANIMATION FOR CORFLO
C --- REVISED  1-25-94 BY Y. CHUANG TO ALLOW USER TO INPUT PRETIMED 
C                                   SIGNAL IN SUBSEQUENT TIME PERIOD
C --- REVISED  6-23-94 BY S. WALKER TO RENUMBER ERROR 2001 TO 2027         
C --- REVISED  8-01-94 BY Y. CHUANG TO SET DEFAULT SIGNAL TRANSITION 
C                                   ALGORITHM, RELEASE ERROR 5210
C --- REVISED  8-18-94 BY S. WALKER TO ALLOW NETSIM GRAPHICS IN CORSIM         
C --- REVISED 11-22-94 BY A. PHLEGAR TO ALLOW FRESIM GRAPHICS
C --- REVISED 11-13-97 BY K. SHERIDAN FOR AIR QUALITY MODELING             
C
C --- TITLE - TEST VALIDITY OF SUBNETWORK SPECIFIC CARD TYPES -
C ---         MODULE 2.3.3
C
C --- FUNCTION - THIS MODULE CHECKS THAT EACH CARD TYPE IS ALLOWED IN
C ---            THE SUBNETWORK AND TIME PERIOD IN WHICH IT APPEARS
C
C --- ARGUMENTS - NONE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     WHEN THIS MODULE IS CALLED IT IS ASSUMED THAT THE INPUT CARDS
C     ARE IN THE PROPER SEQUENCE.  RUN CONTROL AND DELIMITER CARDS
C     ARE CHECKED HERE.  SUBROUTINES ARE CALLED TO CHECK
C     SUBNETWORK CARD TYPES.
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                    COPYCD - MODULE 2.3
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                    RDNUM  - MODULE 2222.1.1.1
C                    RDALPH - MODULE 2.3.1.1
C                    TVINT  - MODULE 2.3.3.1
C                    TVFRY  - MODULE 2.3.3.2
C                    TV1    - MODULE 2.3.3.3
C                    TV2    - MODULE 2.3.3.4
C                    TV3    - MODULE 2.3.3.5
C                    TVNET  - MODULE 2.3.3.6
C                    TVRURL - MODULE 2.3.3.7
C                    ERGEN  - MODULE 2.6.1.1
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ---------------------
C                    --------------------------
C
C     CASINP  CHARACTER STRING CONTAINING CASE NAME
C     CCBUF   CHARACTER STRING USED TO STORE CARD CONTENTS READ IN
C             ALPHABETIC FORMAT
C     INETCD  SUBNETWORK TYPE CODE
C     IPRTYP  PREVIOUS CARD TYPE
C     ISUB    SUBNETWORK TYPE CODE USED FOR LOOPING
C     ITP     NUMBER OF TIME PERIOD DURATIONS INPUT ON CARD TYPE 03
C     ITPCNT  TIME PERIOD BEING CHECKED
C     J       DO-LOOP INDEX
C     K       SCALAR DEFINING BRANCHES TO BE TAKEN TO PROCESS
C             SUBNETWORK DATA
C     LU7     PERIPHERAL UNIT NUMBER 7
C     MAXSUB  MAXIMUM ALLOWABLE NUMBER OF SUBNETWORK TYPES
C     MAXTPR  MAXIMUM ALLOWABLE NUMBER OF TIME PERIODS ON A RECORD
C     NEXTRN  NEXT CASE CODE (0,1) IF ANOTHER CASE (DOESNT,DOES) FOLLOW
C     SIGTRN  CODE (1,2,3) FOR (IMMEDIATE,2-CYCLE,3-CYCLE) TRANSITION
C     TYPERN  (1,2,3) IF (SIM,TA,BOTH) DESIRED (-FOR DIAGNOSTICS ONLY)
C     UNITIN  NETSIM CODE (0,1) IF (ENGLISH,METRIC) UNITS INPUT
C     UNITOT  NETSIM CODE (0,1,2,3) IF (SAME AS INPUT,ENGLISH,METRIC,
C             BOTH) UNITS TO BE OUTPUT
C     WERR    ERROR FLAG, SET TO .T. IF PROCESSING CANNOT CONTINUE
C     WFINAL  LAST TP FLAG, SET TO .T. WHEN LAST 210 CARD FOUND
C     WNETSM  FLAG (T, F) IF NETSIM (IS, ISN'T) THE ONLY MODEL EXECUTED
C     WREPOS  FLAG, SET TO TRUE IF UNIT 7 MUST BE REPOSITIONED
C     WSIGTR  FLAG (T, F) IF NETSIM SIGNAL DATA (IS, NOT) INPUT DURING
C             SUBSEQUENT TIME PERIOD
C     WSUB    ARRAY OF FLAGS (T,F) IF A SUBNETWORK (WAS,NOT) SPECIFIED
C             WITHIN ONE TIME PERIOD
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS
C     YGANMT  FLAG (T,F) IF ANIMATION (IS, IS NOT) REQUESTED
C     YGRAPH  FLAG (T,F) IF USER (DOES,DOESN'T) WANT GRAPHICS OUTPUT
C     YSUB    ARRAY OF FLAGS (T,F) IF A SUBNETWORK (DOES,DOESNT) EXIST
C
C ---------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'GLOBAL.INC'
C
C     CHARACTER CASINP*8             <<<<<ALREADY DECLARED IN GLOBAL.INC
C
      DIMENSION WSUB(8)
C
      IPRTYP = 0
      WERR = .FALSE.
      WFINAL = .FALSE.
      WSIGTR = .FALSE.
      WREPOS = .TRUE.
      ITPCNT = 1
C
C -----  RESET SUBNETWORK EXISTANCE FLAGS FOR TIME
C -----  PERIOD 1
C
      DO 5 ISUB = 1, MAXSUB
         WSUB(ISUB) = .FALSE.
    5 CONTINUE
C     WNETSM = .TRUE.
   10 CONTINUE
C
C -----  TRA IF CHECKING FOR A RUN CONTROL CARD
C
      IF (IPRTYP .LE. 5)                                     GO TO 110
      IF (XBUF(20) .EQ. 170) INETCD = XBUF(1)
      IF (XBUF(20) .EQ. 210) INETCD = XBUF(2)
C
C -----  WHEN DATA FOR NEW TIME PERIOD BEGINS, RESET
C -----  SUBNETWORK EXISTANCE FLAGS, WSUB
C
      IF (XBUF(20) .EQ. 210) THEN                                
          ISUB = 0
   12     CONTINUE
          ISUB = ISUB + 1
          WSUB(ISUB) = .FALSE.
          IF (ISUB .LT. MAXSUB)                              GO TO 12
      ENDIF
   15 CONTINUE
      IF(INETCD.NE.0 .AND. (INETCD.LT.2 .OR. INETCD.GT.MAXSUB)) GOTO 100
C
C -----  WHEN NO TYPE 9 CARD IS INCLUDED REPOSITION UNIT 7 TO
C -----  FIRST SUBNETWORK SPECIFIC CARD
C
      IF (WREPOS) BACKSPACE LU7
      IF (WREPOS) WREPOS = .FALSE.
      K = INETCD + 1
C
C -----  DURING SCAN OF DATA FOR TIME PERIOD 1, SET SUBNETWORK EXISTANCE
C -----  FLAG TRUE FOR EACH SUBNETWORK SPECIFIED. OUTPUT MESSAGE WHEN
C -----  DATA IS SPECIFIED IN A SUBSEQUENT TP FOR A SUBNETWORK THAT
C -----  WAS NOT IDENTIFIED IN TP 1.
C
      IF (ITPCNT .EQ. 1 .AND. INETCD .GT. 0) YSUB(INETCD) = .TRUE.
      IF (ITPCNT .GT. 1 .AND. INETCD .GT. 0 .AND. .NOT. YSUB(INETCD))
     1        CALL ERGEN ('TVALID', 2014, ITPCNT, INETCD, 0, 0,2)
C
C -----  OUTPUT MESSAGE IF DATA FOR THIS SUBNETWORK WAS
C -----  ALREADY SPECIFIED FOR THIS TIME PERIOD
C
      IF (INETCD .GT. 0) THEN 
          IF(WSUB(INETCD)) CALL ERGEN('TVALID',2015,INETCD,ITPCNT,0,0,2)
          WSUB(INETCD) = .TRUE.
C         IF (INETCD .NE. 3) WNETSM = .FALSE.
      ENDIF
C
C -----  BRANCH TO CALL ROUTINES THAT CHECK SUBNETWORK
C -----  SPECIFIC CARD TYPES
C
      IF (K .EQ. 1) THEN
          CALL TVINT (ITPCNT)
      ELSEIF (K .EQ. 3) THEN
          CALL TVRURL (ITPCNT)
      ELSEIF (K .EQ. 4) THEN
          CALL TVNET (ITPCNT, WSIGTR)
      ELSEIF (K .EQ. 5) THEN
          CALL TVFRY (ITPCNT)
      ELSEIF (K .EQ. 6) THEN
          CALL TV1 (ITPCNT, WSIGTR)
      ELSEIF (K .EQ. 7) THEN
          CALL TV2 (ITPCNT, WSIGTR)
      ELSEIF (K .EQ. 8) THEN
          CALL TV3 (ITPCNT)
      ELSEIF (K .EQ. 9) THEN
          CALL TVFRE (ITPCNT)
      ELSE
          IF (K.NE.2) STOP ' ERROR IN ROUTINE TVALID. CHECK VALUE OF K'
      ENDIF
C
C -----  CARD IN BUFFER IS A 170 OR 210.  IF LAST CARD OF CASE
C -----  SET FLAG.  IF A 210 CARD INCREMENT TP COUNTER
C
      IF (XBUF(20) .EQ. 210) THEN  
          IF (XBUF(1) .EQ. 1) WFINAL = .TRUE.
          IF (XBUF(1) .EQ. 0) ITPCNT = ITPCNT + 1
      ENDIF
                                                             GO TO 200
C
C -----  INVALID SUBNETWORK TYPE. PRINT MESSAGE AND SET ERROR FLAG
C
  100 CONTINUE
      CALL ERGEN ('TVALID', 2024, INETCD, XBUF(20), 1, 0, 3)
      WERR = .TRUE.
                                                             GO TO 190
C
C -----  PREVIOUS CARD TYPE IS 5 OR LESS.
C
  110 CONTINUE
      CALL RDALPH (7)
      IF (IPRTYP .EQ. 0)                                     GO TO 150
      IF (XBUF(20) .EQ. 9) WREPOS = .FALSE.
C
C -----  PRINT MESSAGE IF A RUN CONTROL CARD MISSING
C
      IF (XBUF(20) .NE. IPRTYP+1  .AND.  IPRTYP .LT. 5)
     1    CALL ERGEN ('TVALID', 2002, IPRTYP+1, 0, 0, 0, 1)
      IF (XBUF(20) .EQ. 5 .AND. IPRTYP .EQ. 5) CALL ERGEN ('TVALID',     
     1    2027, 0, 0, 0, 0, 0)                                           
      IPRTYP = XBUF(20)                                                  
      IF (XBUF(20) .NE. 2)                                   GO TO 120   
C
C -----  CHECK SUBNETWORK TYPE CODE ON CARD TYPE 02.  IF
C -----  WRONG PRINT MESSAGE AND SET FLAG
C -----  STORE RUN TYPE CODE (WILL BE USED IN TVINT)
C -----  AND UNIT CODES
C
      IF (XBUF(20) .EQ. 2) THEN
          READ (CCBUF(52:52), 1000) INETCD
          IF (INETCD .LT. 2 .OR. INETCD .GT. MAXSUB) WERR = .TRUE.
          IF (WERR) CALL ERGEN ('TVALID', 2024, INETCD, 2, 2, 0, 2)
          READ (CCBUF(4:4), 1000) NEXTRN
          READ (CCBUF(7:8), 1002) TYPERN
          READ (CCBUF(46:46), 1000) UNITIN
          READ (CCBUF(48:48), 1000) UNITOT
          READ (CCBUF(60:60), 1000) SIGTRN
      ENDIF
  120 CONTINUE
C
C -----  RE-READ TYPE 03 CARD IN NUMERIC FORMAT, THEN
C -----  COUNT NUMBER OF TIME PERIODS, ITP, INPUT ON TYPE 03 CARD
C
      IF (XBUF(20) .NE. 3) GOTO 180
          BACKSPACE LU7
          ITP = 0
          CALL RDNUM
  125     CONTINUE   
          DO 130 J = 1, MAXTPR
             IF (XBUF(J) .NE. 0) ITP = ITP + 1
  130     CONTINUE
          CALL RDNUM
          IF (XBUF(20) .NE. 3) THEN
             BACKSPACE LU7
          ELSE
                                                             GO TO 125
          ENDIF                                                   
                                                             GO TO 160
C
C -----  PREVIOUS CARD TYPE WAS A TYPE 00
C
  150     CONTINUE
          IPRTYP = XBUF(20)
          IF (IPRTYP .GT. 1) THEN
              CALL ERGEN ('TVALID', 2002, IPRTYP-1, 0, 0, 0, 1)
              WERR = .TRUE.
          ENDIF
C
C -----  BRANCH BACK TO PROCESS MORE CARDS (IF POSSIBLE)
C
  160     CONTINUE
  180 CONTINUE
C
C -----  CHECK FOR GRAPHICS TYPE REQUESTED 
C -----  (0=NO GRAPHICS, 1= ALL GRAPHICS, 2=NO ANIMATION FOR CORFLO)
C
      IF (XBUF(20) .EQ. 5) THEN
         YGRAPH = CCBUF(52:52) .EQ. '1' .OR. CCBUF(52:52) .EQ. '2'
         YGANMT = CCBUF(52:52) .EQ. '1' .AND. WSUB(3)
         CASINP = CCBUF(53:58)
      ENDIF
  190 CONTINUE
  200 CONTINUE
      IF (.NOT. WERR .AND. .NOT. WFINAL)                     GO TO 10
C
C -----  CHECK THAT SIGNAL CARDS DO EXIST IN SUBSEQUENT TIME PERIOD
C -----  WHEN SIGNAL TRANSITION IS REQUESTED, THAT SIGNAL TRANSITION
C -----  IS REQUESTED FOR NETSIM, LEVEL1 AND LEVEL2 ONLY, AND THAT SIGNAL 
C -----  CARDS DO NOT EXIST IN SUBSEQUENT TIME PERIOD IF SIGNAL TRANSITION 
C -----  IS NOT REQUESTED.
C
C -----  REWROTE THIS LOGIC TO ALLOW USER TO INPUT LEVEL1 AND LEVEL2 
C        PRETIMED SIGNAL DATA IN SEQUENTIAL TIME PERIODS
C
      IF (SIGTRN .GT. 0 .AND. SIGTRN .LT. 4) THEN
          IF (.NOT. WSIGTR) CALL ERGEN ('TVALID', 661, 0, 0, 0, 0, 0)
          IF (YSUB(4) .AND. .NOT. YSUB(5) .AND. .NOT. YSUB(6))
     1    CALL ERGEN ('TVALID', 5214, 4, 0, 0, 0, 1)
          IF (YSUB(8) .AND. .NOT. YSUB(3))
     1    CALL ERGEN ('TVALID', 5214, 8, 0, 0, 0, 1)
      END IF
      IF (WSIGTR .AND. SIGTRN .EQ. 0) THEN
          SIGTRN = 1
          CALL ERGEN ('TVALID', 667, 0, 0, 0, 0, 0)
      END IF
C
C -----  CHECK WHETHER NUMBER OF TIME PERIODS SPECIFIED IN
C -----  INPUT STREAM EQUALS NUMBER SPECIFIED ON CARD TYPE 03
C -----  MAKE SURE THAT IT IS NOT TA ONLY WITH ONE TIME PERIOD
C
      IF (WFINAL .AND. ITPCNT .NE. ITP .AND. ABS(TYPERN) .NE. 2)
     1    CALL ERGEN ('TVALID', 2056, ITP, ITPCNT, 0, 0, 2)
C
C -----  OUTPUT A MESSAGE IF SUBNETWORKS OTHER THAN NETSIM OR CORFLO 
C -----  WERE INPUT AND THE GRAPHICS OUTPUT OPTION WAS REQUESTED.
C -----  ALSO OUTPUT A MESSAGE IF GRAPHICS IS REQUESTED FOR A COMBINED
C -----  NETSIM AND CORFLO NETWORK (REMOVE WHEN BOTH MODELS ARE INTEGRATED)
C
      IF (YGRAPH) THEN 
          IF (YSUB(1) .OR. YSUB(2) .OR. YSUB(7))
     1        CALL ERGEN ('TVALID', 3103, 0, 0, 0, 0, 0)
C
          IF (YSUB(3) .AND. (YSUB(4) .OR. YSUB(5) .OR. YSUB(6))) 
     2        CALL ERGEN ('TVALID', 3114, 0, 0, 0, 0, 0)
      ENDIF
C
      REWIND LU7
C
      RETURN
 1000 FORMAT (I1)
 1002 FORMAT (I2)
      END
      BLOCK DATA GLOBAL
C
C --- CODED    3-14-78 BY B. ANDREWS
C --- REVISED  8-15-79 BY B. ANDREWS (FOR NETSIM)
C --- RECODED 10-16-85 BY O. SHARAF-ELDIEN
C --- REVISED  9-11-86 BY A. HALATI (FOR FRESIM)
C --- REVISED  9-15-87 BY AJAY K. RATHI FOR IDENTICAL TRAFFIC STREAMS
C --- REVISED 10-15-87 BY K. SHERIDAN (FOR NETSIM SIGNAL TRANSITION)
C --- REVISED  1-02-88 BY O. SHARAF-ELDIEN FOR NEW DATA BASE STRUCTURE
C --- REVISED  4-18-88 BY O. SHARAF-ELDIEN FOR SUBNETWORK MOE'S
C --- REVISED  9-08-90 BY B. ANDREWS TO DECLARE GRAPHICS BLOCKS
C --- REVISED  7-03-91 BY A. KANAAN FOR NEW INTERFACE DATA BASE
C --- REVISED 11-15-91 BY J. WERK TO INCLUDE TRACING VARIABLES           
C --- REVISED 12-02-91 BY S.E. SMITH TO ADD AVERAGE BUS OCCUPANCY 
C --- REVISED  9-25-92 BY S.E. SMITH TO ADD AVERAGE ROUTE TT PER BUS 
C --- REVISED 11-30-92 BY S.E. SMITH TO ADD WARNING MESSAGE COUNTER 
C --- REVISED 12-23-92 BY J. COTTON FOR FRESIM INTEGRATION
C --- REVISED 12-27-92 BY A. KANAAN TO ALLOW NO ANIMATION IN GRAPHICS
C --- REVISED  5-04-93 BY A. KANAAN TO ADD INCLUDE FILES, UNIT LU82 & LU84
C --- REVISED 10-19-93 BY A. PHLEGAR TO ADD WNCNVT
C --- REVISED 12-10-93 BY A. KANAAAN TO RESET LU5 & LU6 TO 65 & 66 FOR UNIX
C --- REVISED  3-25-94 BY A. PHLEGAR TO ADD PHASE DURATION OUTPUT FLAG
C --- REVISED  6-08-94 BY Y. CHUANG TO DELETE LU72 AND LU81
C --- REVISED 11-15-94 BY I.J. CHIEN FOR CORSIM GRAPHICS LU90 & LU91
C --- REVISED  2-26-95 BY A. KANAAN TO DECLARE LU56
C --- REVISED 11-13-97 BY K. SHERIDAN FOR AIR QUALITY MODELING 
C
C --- TITLE - BLOCK DATA GLOBAL
C
C --- FUNCTION - THIS MODULE ESTABLISHES GLOBAL ARRAY SIZES AND LOADS
C ---            GLOBAL ARRAYS AND SCALARS
C
C --- ARGUMENTS - NONE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     EACH COMMON ARRAY LOADED HERE IS ASSIGNED A MAXIMUM SIZE. THIS
C     ROUTINE LOADS THE COMMON ARRAYS USING THEIR ACTUAL DIMENSIONS AND
C     DEFINES THE SCALARS REPRESENTING ARRAY BOUNDS.  IT ALSO LOADS
C     COMMON SCALARS USED IN THIS OVERLAY
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                               NONE
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                                NONE
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ---------------------
C                    --------------------------
C
C     ABUSTT  ROUTE SPECIFIC ARRAY - AVERAGE TRAVEL TIME PER BUS
C     ACCDEC  ARRAY - VEH OPERATING CHARACTERISTICS BY VEH TYPE AND GRD
C     ACCGAP  ACCEPTABLE GAP FOR LEFT TURNING VEH(SEC * 10)
C     ANODE   HIGHEST INTERNAL NODE NUMBER SPECIFIED BY USER
C     AROUTE  HIGHEST ROUTE NUMBER SPECIFIED BY USER
C     ARTESP  MAXIMUM ALLOWABLE RIGHT TURN SPEED (FT/SEC)
C     BEGTME  CLOCK TIME AT START OF SIMULATION, HOURS AND MINUTES
C     BINDEX  ROUTE SPECIFIC ARRAY - MANUVR ARRAY INDEX
C     BSTRPS  ROUTE SPECIFIC ARRAY - TOTAL NUMBER OF TRIPS
C     BUSLDR  PERCENTAGE OF MEAN HEADWAY APPLIED TO A BUS VEHICLE
C     BUSLNK  BUS PATH ARRAY - CONTAINS SUBNETWORK TYPE, LINK NO. & BUS ROUTE
C     CASE    CASE COUNTER
C     CASINP  CHARACTER STRING CONTAINING CASE NAME
C     CNTINT  NUMBER OF TIME INTERVALS UNTIL NEXT INTERMEDIATE OUTPUT
C     DISILT  INCREMENT TO THRU HEADWAY TO GET LEFT-TURN HDWY (SEC *10)
C     DISIRT  INCREMENT TO THRU HEADWAY TO GET RIGHT-TURN HDWY (SEC*10)
C     DWLPCT  DISTRIBUTION OF PERCENTS APPLIED TO MEAN BUS DWELL TIME
C     ELAPST  ARRAY OF ELAPSED TIMES TO START OF INTERMEDIATE
C             OUTPUT, MIN.
C     EMHDWY  ROUTE SPECIFIC ARRAY - EMISSION HEADWAY (SEC.)
C     EMTIME  ROUTE SPECIFIC ARRAY - TIME REMAINING UNTIL NEXT EMISSION
C     ENTLNK  ROUTE SPECIFIC ARRAY - ENTRY POINT IDENTIFICATION
C     ERRCT   INPUT ERROR COUNTER
C     FCTDSP  DISPERSION DELAY FACTOR
C     FILDUR  ACTUAL DURATION OF FILL TIME, SEC
C     FROFFL  FLAG IF FRESIM OFFLINE INCIDENT DETECTION IS DESIRED
C     FUEL    CODE SPECIFYING FUEL OPTION FOR NETSIM
C     FUELCD  FUEL RUN CODE, (0,1) IF FUEL CALCS. (WILL, WONT) BE MADE
C     FUELFR  CODE SPECIFYING FUEL OPTION FOR FRESIM
C     GCLK    CLOCK TIME SINCE THE BEGINNING OF CASE, SECONDS
C     GLOBND  GLOBAL NODE SPECIFIC ARRAY - SUBNETWORK NODE AND TYPE
C     GTRKCP  GLOBAL LINK SPECIFIC ARRAY - PACKED TRUCK AND CAR POOL
C             PERCENTS FOR ENTRY LINKS (ZERO FOR NON-ENTRY LINKS)
C     HDWPCT  DISTRIBUTION OF PERCENTS APPLIED TO MEAN Q DISCHGE HDWY
C     IMXBRT  MAXIMUM ALLOWABLE NUMBER OF BUS ROUTES
C     IMXGLK  MAXIMUM ALLOWABLE NUMBER OF LINKS IN NETWORK
C     IMXMAN  MAXIMUM ALLOWABLE NUMBER OF BUS MANEUVERS IN MANUVR ARRAY
C     IMXSTA  MAXIMUM ALLOWABLE NUMBER OF BUS STATIONS IN NETWORK
C     IMXSUB  MAXIMUM NUMBER OF SUBNETWORKS ALLOWED
C     INMAX   MAXIMUM ALLOWABLE NUMBER OF INTERNAL/NON INTERFACE NODES
C     LEFTSP  MAXIMUM ALLOWABLE LEFT TURN SPEED. (FT / SEC)
C     LENINT  LENGTH OF A TIME INTERVAL, SECONDS
C     LENPRD  LENGTH OF TIME PERIOD BEING PROCESSED, SECONDS
C     LNTMPR  TP SPECIFIC ARRAY - TP LENGTHS (SEC.)
C     LSTME   DISTRIBUTN OF PERCENTS APPLIED TO MEAN START UP LOST TIME
C     LU90    CORSIM GRAPHICS UNIT 90
C     LU91    CORSIM GRAPHICS UNIT 91
C     MANUVR  ARRAY CONTAINING SEQUENCE OF BUS MANEUVERS ON EACH ROUTE
C     MAXBRT  MAXIMUM ALLOWABLE NUMBER OF BUS ROUTES
C     MAXGLK  MAXIMUM ALLLOWABLE NUMBER OF GLOBAL LINKS
C     MAXMAN  CAPACITY OF MANUVR ARRAY
C     MAXSTA  MAXIMUM ALLOWABLE NUMBER OF BUS STATIONS
C     MAXSUB  MAXIMUM ALLOWABLE NUMBER OF SUBNETWORK TYPES
C     MAXTP   MAXIMUM ALLOWABLE NUMBER OF TIME PERIODS
C     MAXTPR  MAXIMUM ALLOWABLE NUMBER OF TIME PERIODS PER RECORD
C     MSGCT   INPUT WARNING MESSAGE COUNTER
C     MXBSLK  MAXIMUM NUMBER OF LINKS LOADED IN BUSLNK ARRAY
C     NETCD   SUBNETWORK TYPE CODE
C     NEXTRN  NEXT CASE CODE (0,1) IF ANOTHER CASE (DOESNT,DOES) FOLLOW
C     NMAX    MAXIMUM ALLOWABLE INTERNAL NODE NUMBER (USER NODE NUMBER)
C     NRUN    RUN IDENTIFICATION NUMBER
C     NSLICE  NUMBER OF TIME SLICES PER TIME INTERVAL
C     OUTFRQ  ARRAY OF FREQUENCIES OF INTERMEDIATE OUTPUT, SEC
C     OUTSPN  ARRAY OF SPANS OF INTERMEDIATE OUTPUT, MIN.
C     PEDENS  ONSET OF PEDESTRIAN INTENSITY, SECS INTO ACTIVE PHASE
C     PEDIMP  DIST. OF DELAYS DUE TO PED TRAFFIC (WEAK, STRONG, HEAVY)
C     PUTINT  NUMBER OF TI BETWEEN INT. OUTPUT, MACRO MODELS
C     PUTSTD  NUMBER OF TIME INTVLS BETWEEN SUCCESSIVE STANDARD OUTPUTS
C     SCNTER  NO. OF TIME INTERVAL BETWEEN SERVICE RATES COMPUTATION.
C     SECHWY  HEADWAY SURCHARGE FOR 2ND VEHICLE IN QUEUE.
C     SIGTRN  CODE (1,2,3) FOR (IMMEDIATE,2-CYCLE,3-CYCLE) TRANSITION
C     SLIDUR  DURATION OF A TIME SLICE, HUNDREDTHS-OF-A-SEC
C     SNPFRQ  TIME BETWEEN UPDATES OF SNAPSHOT FILE (SECS)
C     STASHN  ARRAY OF STATION SPECIFICATION INFORMATION
C     STOPLT  ARRAY OF SERVICE RATES (THRUS AND LEFTS), STOP SIGN.
C     STOPRT  ARRAY OF SERVICE RATES (RIGHT TURNERS), STOP SIGN.
C     SYIELT  ARRAY OF SERVICE RATES (THRUS AND LEFTS), YIELD SIGN.
C     SYIERT  ARRAY OF SERVICE RATES (RIGHT TURNERS), YIELD SIGN.
C     THRHWY  HEADWAY SURCHARGE FOR 3RD VEHICLE IN QUEUE.
C     TICNT   TIME INTERVAL COUNTER
C     TMINIT  INITIALIZATION TIME (TIME INTERVALS)
C     TPCLK   TIME PERIOD CLOCK, SECONDS
C     TPCNT   TIME PERIOD COUNTER
C     TRKLDR  PERCENTAGE OF MEAN HEADWAY APPLIED TO A TRUCK VEHICLE
C     TRNCD   CODE (0,1) IF MVEMNT-SPEC. NETSIM OUTPUT (NOT,IS) DESIRED
C     TRYLER  PCT OF MEAN HDWY APPLIED TO VEHS TRAILING A BUS OR TRUCK
C     TTLSUB  TOTAL NUMBER OF SUBNETWORKS BEING SIMULATED
C     TTLVHA  TOTAL NUMBER OF VEHICLES IN VEHICLE HOLDING AREA
C     TYPERN  (1,2,3) IF (SIM,TA,BOTH) DESIRED (-FOR DIAGNOSTICS ONLY)
C     UFPCT   DISTRIBUTION OF PERCENTS APPLIED TO FREE-FLOW SPEED
C     UNITIN  NETSIM CODE (0,1) IF (ENGLISH,METRIC) UNITS INPUT
C     UNITOT  NETSIM CODE (0,1,2,3) IF (SAME AS INPUT,ENGLISH,METRIC,
C             BOTH) UNITS TO BE OUTPUT
C     VEHLNG  ARRAY OF VEHICLE LENGTHS
C     WNCNVT  FLAG (.T. TO SUPPRESS CONVERSION OF GRAPHICS)
C     XBSEED  BUS ROUTE SPECIFIC ARRAY - RANDOM NUMBER SEED
C     XBSTRV  ROUTE SPECIFIC ARRAY - TOTAL TRAVEL TIME (SEC.)
C     XC7000  INTERFACE NODE SPECIFIC ARRAY * 2 - X COORDINATE (FT) AND  
C             Y COORDINATE (FT) FOR NODE (IN TWO CONSECUTIVE WORDS)      
C     XC8000  ENTRY NODE SPECIFIC ARRAY * 2 - X COORDINATE (FT) AND     
C             Y COORDINATE (FT) FOR NODE (IN TWO CONSECUTIVE WORDS)     
C     XGCOOR  NODE SPECIFIC ARRAY * 2 - X COORDINATE (FT) AND            
C             Y COORDINATE (FT) FOR NODE (IN TWO CONSECUTIVE WORDS)      
C     XPHSCD  CODES TO UNPACK PHASE CODE FOR A TURN MOVEMENT
C     XSEED   RANDOM NUMBER SEED
C     XSEED2  RANDOM NUMBER SEED TO GENERATE TRAFFIC STREAM
C     XVETRP  CUMULATIVE NO.OF VEHICLE TRIPS COMPLETED THRU THE NETWORK
C     YACTND  PHASE DURATION OUTPUT FLAG FOR ACTUATED NODES
C     YCASE   CASE TERMINATION FLAG, SET TO .T. IF CASE MUST BE ABORTED
C     YEOI    END-OF-INPUT FLAG, SET TO .T. IF EOF FOUND UNEXPECTEDLY
C     YEQLB   ARRAY OF SUBNETWORK-SPECIFIC EQUILIBRIUM FLAGS.
C     YGANMT  FLAG (T,F) IF ANIMATION (IS,ISN'T) REQUESTED
C     YGRAPH  FLAG (T,F) IF USER (DOES,DOESN'T) WANT GRAPHICS OUTPUT
C     YINIT   INITIALIZATION FLAG, SET TO .T. IF PRIMING FOR SIMULATION
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)
C     YRTALG  REAL TIME ALGORITHM FLAG (.TRUE. IF ALGORITHM TO BE USED)
C     YSUB    SUBNETWORK EXISTNCE FLAGS (.T. IF INPUTS HAVE BEEN READ)
C     YTRACE  TRACE FLAG.  SET TO .TRUE. AT THE TIME TRACES ARE TO BEGIN 
C     ZAVGBO  AVERAGE BUS OCCUPANCY FOR ALL SUBNETWORKS FOR ALL TP
C     ZBOSUM  SUM OF BUS OCCUPANCIES FOR SUBNETWORK
C     ZCNVRT  ARRAY OF ENGLISH AND METRIC CONVERSION FACTORS (1-6) TO
C             CONVERT (FT-M,MI-KM,GAL-LIT,M-FT,KM-MI,LIT-GAL)
C     ZMILE   SUBNETWORK SPEC.ARRAY - SUM OF VEHICLE MILES
C     ZMOVE   SUBNETWORK SPEC.ARRAY - SUM OF (FREE FLOW) VEHICLE-HOURS
C     ZSSTEP  TIME STEP DURATION FOR FRESIM
C     ZTIME   SUBNETWORK SPEC.ARRAY - SUM OF VEHICLE HOURS
C
C ---------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
C     CHARACTER CASINP*8             <<<<<ALREADY DECLARED IN GLOBAL.INC
C
      INCLUDE 'GLOBAL.INC'
C
C ---------------------------------------------------------------------
C     DEFINE MAXGLK WHICH IS THE DIMENSION FOR ALL GLOBAL LINK SPECIFIC
C     ARRAYS WHICH ARE LOADED IN THIS ROUTINE AND IN BLOCK DATA INTDAT
C     (FOR OVERLAY 2.2.5) AND BLOCK DATA TADATA (FOR OVERLAY 5.0).
C     IF MAXGLK IS CHANGED, ARRAY DIMENSIONS IN ROUTINES TRFASS AND
C     TRAFIC ALSO MUST BE REVISED, IN ADDITION TO ANY ARRAYS
C     DEPENDENT ON MAXGLK HERE AND IN INTDAT AND TADATA.
C ---------------------------------------------------------------------
C
      DATA MAXBRT /IMXBRT/
      DATA MAXGLK /IMXGLK/
      DATA MAXGVH /IMXGVH/
      DATA MAXMAN /IMXMAN/
      DATA MAXSUB /IMXSUB/
      DATA MAXTP  /   114/
      DATA MAXTPR /    19/
      DATA MAXSTA /IMXSTA/
      DATA NMAX   /INMAX /
      DATA SNPFRQ /     1/
C
      DATA MAXINT /IMXINT/
      DATA MAXSPT /IMXSPT/
      DATA MAXVHA /IMXVHA/
C
      DATA LU5    /   65/
      DATA LU6    /   66/
      DATA LU7    /   14/
      DATA LU8    /    8/
      DATA LU9    /    8/
      DATA LU10   /    8/
      DATA LU11   /    8/
      DATA LU12   /    8/
      DATA LU13   /    8/
      DATA LU15   /    2/
      DATA LU16   /    3/
      DATA LU17   /   17/
      DATA LU18   /   18/
      DATA LU19   /   19/
      DATA LU20   /    4/
      DATA LU31   /    4/
      DATA LU32   /    2/
      DATA LU35   /   35/
      DATA LU36   /   36/
      DATA LU37   /   37/
      DATA LU38   /   38/
      DATA LU39   /   39/
      DATA LU40   /    9/
      DATA LU41   /   10/
      DATA LU42   /   17/
      DATA LU43   /   18/
      DATA LU44   /   19/
      DATA LU45   /   13/
      DATA LU48   /   11/
      DATA LU49   /   12/
      DATA LU52   /   22/
      DATA LU55   /   13/
      DATA LU56   /   15/
      DATA LU61   /   22/
      DATA LU71   /   20/
      DATA LU82   /   28/
      DATA LU84   /   29/
      DATA LU90   /   90/
      DATA LU91   /   91/
C
      DATA YACTND /.FALSE./
      DATA YLAHEY /.TRUE./
      DATA YMSDOS /.TRUE./
      DATA YTRACE /.FALSE./
      DATA WNCNVT /.FALSE./
C
      END
      SUBROUTINE LNKAPP(I1)
C                                                                                     
C --- CODED   10-28-97 BY E. LIEBERMAN                                                
C                                                                                     
C --- TITLE -  CREATE ARRAY WHICH MAPS THE APPROACHES AND DEPARTING
C ---          LINKS OF THE SPECIFIED NODE TO THEIR RESPECTIVE
C ---          LINK NUMBERS. - MODULE 2261.14.4
C                                                                                     
C --- FUNCTION -  STORE ALL APPROACH AND DEPARTING LINKS ATTENDANT
C ---             TO NODE, IN, INTO AN ARRAY, IN THAT SEQUENCE.
C                                                                                     
C --- ARGUMENTS - I1   -  SELECTED NODE NUMBER
C                                                                                     
C -------------------------   DESCRIPTION   ---------------------------               
C                             -----------                                             
C                                                                         
C     LOOP OVER SIGI ARRAY TO STORE ALL APPROACH LINKS.  THEN LOOP 
C     OVER ALL NETWORK LINKS TO IDENTIFY THE DEPARTING LINKS AND
C     STORE THEM.
C                                                            
C -------------------   THIS ROUTINE CALLED BY   ----------------------               
C                       ----------------------                                        
C                                                                                     
C                    PRMAIR - MODULE 2261.14                                          
C                                                                                     
C ---------------------   THIS ROUTINE CALLS   ------------------------               
C                         ------------------                                          
C                                            
C                               NONE          
C                                                                                     
C ---------------    GLOSSARY OF VARIABLE NAMES   ---------------------               
C                    --------------------------                                       
C        
C     IA      APPROACH NUMBER
C     IL      LINK NUMBER
C     IN      NODE NUMBER
C     J       INDEX COUNTER
C     LKAQ    ARRAY THAT STORES ALL LINK NUMBERS: APPROACHES, THEN
C             DEPARTING RELATIVE TO NODE, IN
C     SIGI    NODE SPECIFIC ARRAY - OF APPROACH LINKS
C     TTLILK  TOTAL NUMBER OF INTERNAL LINKS
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER
C     
C ----------------------------------------------------------------------              
C                                                                                     
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)                     
C                                                                                     
      INCLUDE 'NETSIM.INC'     
      INCLUDE 'AIRQUAL.INC'     
      INCLUDE 'GLOBAL.INC'     
C
      IN = I1 
      J = 5 * IN - 5
C
C -----  MAP THE APPROACH LINKS.
C
         DO 10 IA = 1, 5
            J = J + 1
            IL = SIGI(J)
            IF (IL .EQ. 0)                                   GO TO 15
            LKAQ(IA) = IL
   10    CONTINUE
   15 CONTINUE
      IF (SIGI(J) .EQ. 0) IA = IA - 1
C
C -----  MAP THE DEPARTING LINKS.
C
         DO 25 IL = 1, TTLILK
            IF (UPNOD(IL) .NE. IN)                           GO TO 20
            IA = IA + 1
            LKAQ(IA) = IL
   20       CONTINUE
   25    CONTINUE
C
C -----  SET ZERO TO DELIMIT ARRAY
C
      IF (IA .LT. 10) LKAQ(IA+1) = 0
      RETURN
      END
      SUBROUTINE RD02
C
C --- CODED    3-20-78 BY B. ANDREWS
C --- REVISED  7-02-85 BY A. RATHI
C --- REVISED 11-13-86 BY A. HALATI (FOR FRESIM)
C --- REVISED  9-15-87 BY AJAY K. RATHI FOR IDENTICAL TRAFFIC STREAMS
C --- REVISED 10-15-87 BY K. SHERIDAN (FOR NETSIM SIGNAL TRANSITION)
C --- REVISED 12-28-92 BY J. COTTON TO INTEGRATE FRESIM
C --- REVISED  8-01-93 BY A. KANAAN FOR PROPER DATA STATEMENT
C --- REVISED  1-25-94 BY Y. CHUANG TO ALLOW USER TO INPUT PRETIMED 
C                                   SIGNAL IN SEQUENTIAL TIME PERIOD
C --- REVISED  9-07-94 BY S. WALKER TO REMOVE FRESIM INCLUDE
C --- REVISED 10-19-94 BY A. PHLEGAR TO SET XSEEDF FOR FRESIM
C --- REVISED 12-01-97 BY K. SHERIDAN FOR AIR QUALITY MODELING        
C
C --- TITLE - READ, CHECK AND STORE DATA ITEMS IN CARD TYPE 02 -
C ---         MODULE 2.6.2
C
C --- FUNCTION - THIS MODULE PROCESSES CARD TYPE 02
C
C --- ARGUMENTS - NONE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     WHEN THIS ROUTINE IS CALLED CARD TYPE 02 IS EXPECTED TO APPEAR
C     NEXT IN THE INPUT STREAM. THIS ROUTINE WILL READ, CHECK, STORE
C     AND PRINT THE CONTENTS OF THE TYPE 02 CARD
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                    GETRNC - MODULE 2.6
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                    ERGEN  - MODULE 2.6.1.1
C                    RDNUM  - MODULE 2222.1.1.1
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ---------------------
C                    --------------------------
C
C     BEGTME  CLOCK TIME AT START OF SIMULATION, HOURS AND MINUTES
C     FROFFL  FRESIM OFFLINE INCIDENT DETECTION CODE, 0 OR 1
C     FUEL    NETSIM FUEL CODE, 0 THRU 17
C     FUELCD  FUEL RUN CODE, (0,1) IF FUEL CALCS. (WILL, WONT) BE MADE
C     FUELFR  FRESIM FUEL CODE, 0 THRU 17
C     I       UNITS DIGIT OF RANDOM NUMBER SEED
C     IXF     CODE FOR IDENTIFING FUEL/EMISSION TABLES
C     IYF     CODE FOR IDENTIFING NETSIM ENVIRONMENTAL OPTIONS
C     IXFR    CODE FOR IDENTIFING FRESIM FUEL/EMISSION TABLES
C     IYFR    CODE FOR IDENTIFING FRESIM ENVIRONMENTAL OPTIONS
C     J       (RANDOM NUMBER SEED / 10) * 10
C     KS      ARRAY OF CHARACTER STRINGS IDENTIFYING THE SELECTED
C             OPTION OF THE FUEL CONSUMPTION AND VEHICLE EMISSIONS
C             FEATURE OF NETSIM
C     LU6     PERIPHERAL UNIT NUMBER 6
C     NETCD   SUBNETWORK TYPE CODE
C     NEXTRN  NEXT CASE CODE (0,1) IF ANOTHER CASE (DOESNT,DOES) FOLLOW
C     SIGTRN  CODE (1,2,3) FOR (IMMEDIATE,2-CYCLE,3-CYCLE) TRANSITION
C     TMINIT  INITIALIZATION TIME, MINUTES
C     TYPERN  (1,2,3) IF (SIM,TA,BOTH) DESIRED (-FOR DIAGNOSTICS ONLY)
C     UNITIN  NETSIM CODE (0,1) IF (ENGLISH,METRIC) UNITS INPUT
C     UNITOT  NETSIM CODE (0,1,2,3) FOR (SAME AS INPUT, ENGLISH, METRIC,
C             BOTH) UNITS OUTPUT
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS
C     XSEED   RANDOM NUMBER SEED
C     XSEEDF  RANDOM NUMBER SEED FOR FRESIM
C     XSEED2  RANDOM NUMBER SEED TO GENERATE TRAFFIC STREAM
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)
C     YSUB    ARRAY OF FLAGS (T,F) IF A SUBNETWORK (DOES,DOESNT) EXIST
C     YVSVOT  ARRAY .TRUE. IF USER REQUESTS VEHICLE TYPE SPECIFIC OUTPUT
C
C ---------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      DIMENSION KS(10)
C
      INCLUDE 'NETSIM.INC'
      INCLUDE 'GLOBAL.INC'
      INCLUDE 'AIRQUAL.INC'
C
      CHARACTER*36 KS
C
      DATA KS /'PERFORMED                           ',
     1         'NOT PERFORMED (READ TRAJECTORY FILE)',
     2         'CALCULATED                          ',
     3         'NOT CALCULATED                      ',
     4         'EMBEDDED                            ',
     5         'MODIFIED                            ',
     6         'NOT WRITTEN                         ',
     7         'WRITTEN                             ',
     8         'ARE PRINTED                         ',
     9         'ARE NOT PRINTED                     '/
C
      CALL RDNUM
C
C -----  CHECK AND STORE ENTRY 1.  ALLOWABLE VALUES ARE 0 AND 1
C
      IF (XBUF(1) .LT. 0  .OR.  XBUF(1) .GT. 1)
     1            CALL ERGEN ('RD02  ', 2021, XBUF(1), 0, 0, 0, 1)
      NEXTRN = XBUF(1)
C
C -----  CHECK AND STORE ENTRY 2.  ALLOWABLE VALUES ARE -3 THRU +3
C -----  EXCLUDING ZERO
C
      IF (XBUF(2) .EQ. 0  .OR.  IABS(XBUF(2)) .GT. 3)
     1            CALL ERGEN ('RD02  ', 2022, XBUF(2), 0, 0, 0, 1)
      TYPERN = XBUF(2)
C
C -----  CHECK AND STORE ENTRY 3. FRESIM OFFLINE CODE IS 0 OR 1
C
      IF (XBUF(3) .EQ. 0 .OR. XBUF(3) .EQ. 1) THEN
         FROFFL = XBUF(3)
      ELSE
         CALL ERGEN ('RD02  ', 2101, XBUF(3), 0, 0, 0, 1)
      ENDIF
C
C -----  CHECK AND STORE ENTRY 4. OUTPUT MESSAGE IF FILL TIME IS ZERO
C
      IF (XBUF(5) .EQ. 0) CALL ERGEN ('RD02  ', 2026, 0, 0, 0, 0, 0)
      TMINIT = XBUF(5)
C
C -----  CHECK ENTRY 5. ALLOWABLE VALUES ARE 0 THRU 17.
C
      IF (XBUF(8) .LT. 0 .OR. XBUF(8) .GT. 17)
     1            CALL ERGEN ('RD02  ', 2020, XBUF(8), 0, 0, 0, 1)
      FUEL = XBUF(8)
C
C -----  UNPACK FUEL TO FIND X AND Y FACTORS
C
      IXF = FUEL / 10
      IYF = MOD (FUEL, 10)
C
C --- CHECK AND STORE ENTRY 6. IF VALUE IS BETWEEN 20 AND 37, USER
C --- MAY BE REQUESTING UNDOCUMENTED VEHICLE TYPE SPECIFIC OUTPUT.
C --- SET THE FLAG FOR THIS TO TRUE, REDUCE THE CODE BY 20, AND
C --- NOTIFY THE USER OF THIS CHOICE.
C
      FUELFR = XBUF(9) /100
      IF (FUELFR .GE. 20 .AND. FUELFR .LT. 38) THEN
         FUELFR = FUELFR - 20
         YVSVOT = .TRUE.
      ENDIF         
C
C --- CHECK AND STORE ENTRY 6. ALLOWABLE VALUES ARE 0 THRU 17.
C
      IF (FUELFR .LT. 0 .OR. FUELFR .GT. 17) CALL
     1   ERGEN ('RD02  ', 2101, FUELFR, 0, 0, 0, 1)
C
C -----  UNPACK FUEL TO FIND X AND Y FACTERS
C
      IXFR = FUELFR / 10
      IYFR = MOD (FUELFR, 10)
C
C -----  CHECK ENTRY 7, NETFLO FUEL CODE. ALLOWABLE VALUES ARE 0 AND 1.
C
      XBUF(9) = XBUF(9) - (XBUF(9) / 100) * 100
      IF (XBUF(9) .LT. 0 .OR. XBUF(9) .GT. 1)
     1            CALL ERGEN ('RD02  ', 2023, XBUF(9), 0, 0, 0, 1)
      FUELCD = XBUF(9)
C
C -----  CHECK ENTRY 8, NODE TO APPLY AIR QUALITY MODELING.      
C
      IF (XBUF(10) .LT. 0 .OR. XBUF(10) .GT. 6999) 
     1    CALL ERGEN ('RD02  ', 2023, XBUF(10), 0, 0, 0, 1)
      IF (XBUF(10) .GT. 0) XNODE = XBUF(10)
C
C -----  CHECK AND STORE ENTRY 9. ALLOWABLE VALUES ARE 0 AND 1.
C
      UNITIN = XBUF(12) / 100
      IF (UNITIN .LT. 0  .OR.  UNITIN .GT. 1)
     1             CALL ERGEN ('RD02  ', 4125, UNITIN, 0, 0, 0, 1)
C
C -----  CHECK AND STORE ENTRY 10. ALLOWABLE VALUES ARE 0 THRU 3,
C -----  INCLUSIVELY
C
      UNITOT = MOD (XBUF(12), 100)
      IF (UNITOT .LT. 0  .OR.  UNITOT .GT. 3)
     1             CALL ERGEN ('RD02  ', 4126, UNITOT, 0, 0, 0, 1)
C
C -----  STORE ENTRY 11. (IT WAS CHECKED ON FIRST DIAGNOSTIC PASS
C -----  BY MODULE 2.3.3)
C
      NETCD = XBUF(13)
C
C -----  CHECK AND STORE ENTRY 12. VALUE MUST BE .LE. 2359 AND .GE. 0
C
      IF (XBUF(14) .GT. 2359 .OR. XBUF(14) .LT. 0)
     1            CALL ERGEN ('RD02  ', 2025, XBUF(14), 0, 0, 0, 1)
      BEGTME = XBUF(14)
C
C -----  CHECK AND STORE ENTRY 13.  VALUE MUST BE .LE. 3 AND .GE. 0
C
      IF (XBUF(15) .GT. 3 .OR. XBUF(15) .LT. 0)
     1    CALL ERGEN ('RD02  ', 5203, XBUF(15), 0, 0, 0, 1)
      SIGTRN = XBUF(15)
C
C -----  CHECK AND STORE ENTRY 14.  MUST BE ODD AND NOT A MULTIPLE OF 5.
C
      XSEED2 = XBUF(16) * 10000 + XBUF(17)
      IF (XSEED2 .LE. 0) THEN
         XSEED2 = 7781
      ELSE
         J = (XSEED2/10)*10
         I = XSEED2 - J
         IF (I .EQ. 5 .OR. I .EQ. 4) THEN
            CALL ERGEN ('RD02  ', 202, XSEED2, 11, 0, 0, 2)
            XSEED2 = J + 7
         ELSE IF ((XSEED2/2)*2 .EQ. XSEED2) THEN
            CALL ERGEN ('RD02  ', 202, XSEED2, 11, 0, 0, 2)
            XSEED2 = XSEED2 + 1
         ENDIF
      ENDIF
C
C -----  CHECK AND STORE ENTRY 15.  MUST BE ODD AND NOT A MULTIPLE OF 5
C -----  REVISE SPECIFIED RANDOM NUMBER SEED
C
      XSEED = XBUF(18) * 10000 + XBUF(19)
      IF (XSEED .LE. 0) THEN
         XSEED = 7581
      ELSE
         J = (XSEED/10)*10
         I = XSEED - J
         IF (I .EQ. 5 .OR. I .EQ. 4) THEN
            CALL ERGEN ('RD02  ', 202, XSEED, 12, 0, 0, 2)
            XSEED = J + 7
         ELSE IF ((XSEED/2)*2 .EQ. XSEED) THEN
            CALL ERGEN ('RD02  ', 202, XSEED, 12, 0, 0, 2)
            XSEED = XSEED + 1
         ENDIF
      ENDIF
C
C -----  SET FRESIM RANDOM NUMBER SEED
C
      XSEEDF = XSEED
C
C -----  ADD DATA FROM THIS CARD TO TABLE OF RUN CONTROL DATA
C
      IF (YPRINT) THEN
          WRITE (LU6, 1002) NEXTRN
          WRITE (LU6, 1003) TYPERN
      ENDIF
C
C -----  TRA IF A FRESIM SUBNETWORK DOES NOT EXIST. ELSE, PRINT
C -----  OFF-LINE PROCESSING OPTION, AS WELL AS THE OPTION ON
C -----  FRESIM FUEL CONSUMPTION AND EMISSION TABLES.  ALSO, PRINT
C -----  FRESIM OPTIONS ON SIMULATION, ENVIRONMENTAL MEASURES, FUEL
C -----  CONSUMPTION AND EMISSION RATE TABLES, AND TRAJECTORY 
C -----  FILE PROCESSING
C
      IF (YSUB(8)) THEN
         IF (YPRINT) THEN
            WRITE (LU6, 1013) FROFFL
            IF (IXFR .EQ. 0) THEN
               WRITE (LU6, 1012) IXFR, KS(10)
            ELSE
               WRITE (LU6, 1012) IXFR, KS(9)
            ENDIF
            IF (IYFR .EQ. 0) THEN
               WRITE(LU6,1005) IYFR, KS(1), KS(3), KS(5), KS(7)
            ELSEIF (IYFR .EQ. 1) THEN 
               WRITE(LU6,1005) IYFR, KS(1), KS(3), KS(5), KS(8)
            ELSEIF (IYFR .EQ. 2) THEN
               WRITE(LU6,1005) IYFR, KS(1), KS(3), KS(6), KS(7)
            ELSEIF (IYFR .EQ. 3) THEN 
               WRITE(LU6,1005) IYFR, KS(1), KS(3), KS(6), KS(7)
            ELSEIF (IYFR .EQ. 4) THEN 
               WRITE(LU6,1005) IYFR, KS(2), KS(3), KS(5), KS(7)
            ELSEIF (IYFR .EQ. 5) THEN 
               WRITE(LU6,1005) IYFR, KS(2), KS(3), KS(6), KS(7)
            ELSEIF (IYFR .EQ. 6) THEN 
               WRITE(LU6,1005) IYFR, KS(1), KS(4), KS(5), KS(7)
            ELSEIF (IYFR .EQ. 7) THEN 
               WRITE(LU6,1005) IYFR, KS(1), KS(4), KS(5), KS(8)
            ENDIF
         ENDIF
      ENDIF
C
C -----  TRA IF A NETSIM SUBNETWORK DOES NOT EXIST. ELSE, PRINT
C -----  OPTION ON NETSIM FUEL CONSUMPTION AND EMISSION TABLES
C -----  PRINT NETSIM OPTIONS ON SIMULATION, ENVIRONMENTAL MEASURES,
C -----  FUEL CONSUMPTION AND EMISSION RATE TABLES, AND TRAJECTORY
C -----  FILE PROCESSING
C
      IF (YSUB(3)) THEN                                    
         IF (IXF .EQ. 0) KS(9) = 'ARE NOT PRINTED                    '
         IF (YPRINT) THEN
             WRITE (LU6, 1004) IXF, KS(9)
             IF (IYF .EQ. 0) THEN
                 WRITE(LU6,1005) IYF, KS(1), KS(3), KS(5), KS(7)
             ELSEIF (IYF .EQ. 1) THEN 
                 WRITE(LU6,1005) IYF, KS(1), KS(3), KS(5), KS(8)
             ELSEIF (IYF .EQ. 2) THEN 
                 WRITE(LU6,1005) IYF, KS(1), KS(3), KS(6), KS(7)
             ELSEIF (IYF .EQ. 3) THEN 
                 WRITE(LU6,1005) IYF, KS(1), KS(3), KS(6), KS(7)
             ELSEIF (IYF .EQ. 4) THEN 
                 WRITE(LU6,1005) IYF, KS(2), KS(3), KS(5), KS(7)
             ELSEIF (IYF .EQ. 5) THEN 
                 WRITE(LU6,1005) IYF, KS(2), KS(3), KS(6), KS(7)
             ELSEIF (IYF .EQ. 6) THEN 
                 WRITE(LU6,1005) IYF, KS(1), KS(4), KS(5), KS(7)
             ELSEIF (IYF .EQ. 7) THEN 
                 WRITE(LU6,1005) IYF, KS(1), KS(4), KS(5), KS(8)
             ENDIF
         ENDIF
      ENDIF
C
C -----  ADD DATA FROM THIS CARD TO TABLE OF RUN CONTROL DATA.
C -----  PRINT NETFLO FUEL CODE ONLY IF A NETFLO LEVEL I OR II
C -----  SUBNETWORK EXISTS.
C
      IF (YPRINT) THEN 
         IF (YSUB(5) .OR. YSUB(6)) WRITE (LU6, 1010) FUELCD
         WRITE (LU6, 1006) UNITIN, UNITOT
         WRITE (LU6, 1008) BEGTME
         IF (YSUB(3) .OR. YSUB(5) .OR. YSUB(6)) WRITE (LU6, 1007) SIGTRN
         WRITE (LU6, 1009) XSEED
         IF (YSUB(3) .OR. YSUB(5)) WRITE (LU6, 1011) XSEED2
      ENDIF
C
      RETURN
 1002 FORMAT('0',I26,5X,'NEXT CASE CODE = (0,1) IF ANOTHER CASE (DOES',
     1      ' NOT, DOES) FOLLOW')
 1003 FORMAT('0',I26,5X,'RUN TYPE CODE = ( 1, 2, 3) TO RUN (SIMULATION',
     1      ', ASSIGNMENT, BOTH)'/48X,'(-1,-2,-3) TO CHECK (SIMULATION',
     2      ', ASSIGNMENT, BOTH) ONLY'/)
 1004 FORMAT('0',31X,'NETSIM ENVIRONMENTAL OPTIONS'/32X,28('-')/
     1      I27,5X,'FUEL/EMISSION RATE TABLES ',A36)
 1005 FORMAT(I27,5X,'SIMULATION:  ', A36,'   ENVIRONMENTAL MEASURES:  ',
     1      A20/32X,'RATE TABLES: ',A36,'   TRAJECTORY FILE:',9X,A20)
 1006 FORMAT('0', I26, '     INPUT  UNITS CODE = (0,1) IF INPUT IS IN ',
     1      '(ENGLISH, METRIC) UNITS'/I27,5X,'OUTPUT UNITS CODE = (0,1',
     2      ',2,3) IF OUTPUT IS IN (SAME AS INPUT, ENGLISH, METRIC,',
     3      ' BOTH) UNITS')
 1007 FORMAT('0',I26,5X,'SIGNAL TRANSITION CODE = (0,1,2,3) IF (NO, IM',
     1      'MEDIATE, 2-CYCLE, 3-CYCLE) TRANSITION WAS REQUESTED')
 1008 FORMAT('0', I26, 5X, 'CLOCK TIME AT START OF SIMULATION (HHMM)')
 1009 FORMAT('0', I26, 5X, 'RANDOM NUMBER SEED')
 1010 FORMAT('0', I26, 5X, 'NETFLO FUEL RUN CODE = (0,1) IF FUEL ',
     1      '(WILL, WILL NOT) BE CALCULATED')
 1011 FORMAT(I27, 5X, 'RANDOM NUMBER SEED TO GENERATE ',
     1      'TRAFFIC STREAM FOR NETSIM OR LEVEL I SIMULATION'/)
 1012 FORMAT('0',31X,'FRESIM ENVIRONMENTAL OPTIONS'/32X,28('-')/
     1      I27,5X,'FUEL/EMISSION RATE TABLES ',A36)
 1013 FORMAT ('0', I26, 5X, 'FRESIM OFFLINE INCIDENT DETECTION CODE',
     1                      ' = (0, 1) IF OFFLINE INCIDENT DETECTION',
     2                      /, 31X, ' (IS NOT, IS) BEING PERFORMED')
      END
      SUBROUTINE RDFN11
C
C
C --- CODED    3-22-78 BY B. ANDREWS
C --- REVISED  8-10-79 BY M. MASSUCCI (FOR NETSIM)
C --- REVISED  9-27-91 BY A. KANAAN TO ADD SOME STATISTICS TO OUTPUT
C --- REVISED 12-31-91 BY J. WERK TO READ CARD IN AS ALPHANUMERIC AND    
C ---                        STORE ENTRIES IN XBUF ARRAY                    
C --- REVISED  1-08-92 BY J. WERK TO PRINT OUT DEFINITION OF 5 NEW       
C ---                        CHANNELIZATION CODES                           
C
C --- TITLE - READ, CHECK TYPE 11 CARDS - MODULE 2261.2.2
C
C --- FUNCTION - THIS MODULE CONTROLS THE PROCESSING OF CARD TYPE 11
C
C --- ARGUMENTS - NONE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     THIS MODULE DIRECTS THE CARD READING, CHECKING AND STORING OF
C     CARD TYPE 11 DATA
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                    LINKFN - MODULE 2261.2
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                    CKFN11 - MODULE 2261.2.2.1
C                    STFN11 - MODULE 2261.2.2.2
C                    PRFN11 - MODULE 2261.2221
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ---------------------
C                    --------------------------
C
C     CCBUF   CHARACTER STRING USED TO STORE DATA THAT IS READ IN
C             ALPHABETIC FORMAT
C     I       INDEX
C     ICARD   CARD COUNTER
C     JCHAN   CONTAINS MOVEMENTS SERVICED BY EACH LANE FOR CURRENT LINK
C     LU6     PERIPHERAL UNIT NUMBER 6
C     LU7     PERIPHERAL UNIT NUMBER 7
C     MAXLNK  MAXIMUM ALLOWABLE NUMBER OF LINKS
C     MAXND   MAXIMUM ALLOWABLE NO. OF NODES IN SUBNETWORK
C     TTLND   TOTAL NUMBER OF NODES IN SUBNETWORK
C     TTLNK   TOTAL NUMBER OF LINKS IN SUBNETWORK
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)
C     XNODE   NODE SELECTED FOR AIR QUALITY MODELING
C
C ---------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'GLOBAL.INC'
      INCLUDE 'NETSIM.INC'
      INCLUDE 'AIRQUAL.INC'
C
C -----  HEADING IS PRINTED
C
      IF (YPRINT) WRITE (LU6, 1000)
C
C -----  PROCESS CARDS UNTIL A CARD TYPE OTHER THAN A TYPE 11 IS FOUND
C
      ICARD = 0
   10 CONTINUE
C
      READ (LU7, 1004) CCBUF(1:76), XBUF(20)                             
      IF (XBUF(20) .NE. 11) THEN                                         
         READ (CCBUF(1:76), 1005) (XBUF(I), I = 1, 19)                   
                                                             GO TO 100   
      ELSE                                                               
         XBUF(32) = XBUF(20)                                             
         READ (CCBUF(1:29), 1006) (XBUF(I), I = 1, 10)                   
            DO 20 I = 30, 36                                             
               IF (CCBUF(I:I) .EQ. 'D'.OR. CCBUF(I:I)                    
     1                 .EQ. 'd') THEN                                    
                  XBUF(I-19) = 10                                        
               ELSEIF (CCBUF(I:I) .EQ. 'T'.OR. CCBUF(I:I)                
     1                 .EQ. 't') THEN                                    
                  XBUF(I-19) = 11                                        
               ELSE                                                      
                  READ (CCBUF(I:I), 1007) XBUF(I-19)                     
               ENDIF                                                     
   20       CONTINUE                                                     
         READ (CCBUF(37:76), 1008) (XBUF(I), I = 18, 31)                 
      ENDIF                                                              
      CALL CKFN11 (JCHAN)
      CALL STFN11 (JCHAN)
      ICARD = ICARD + 1
C                     
      IF (YPRINT) CALL PRFN11 (ICARD)
                                                              GO TO 10
  100 CONTINUE
C
C -----  SET XNODE TO NETWORK NODE NUMBER.
C
      IF (XNODE .GT. 0) THEN
         IN = 0
   30    CONTINUE
         IN = IN + 1
         IF (NMAP(IN) .NE. XNODE .AND. IN .LT. TTLND)        GO TO 30
         IF (NMAP(IN) .NE. XNODE) THEN
            CALL ERGEN ('RDFN11', 2222, XNODE, 0, 0, 0, 1)
         ELSE   
            XNODE = IN
         ENDIF
      ENDIF   
C
C -----  OUTPUT EXPLANATION OF CODES
C
      IF (YPRINT) THEN 
          IF (MOD (ICARD, 45) .GT. 27) WRITE (LU6, 1003)
          WRITE (LU6, 1002)
          WRITE (LU6, 1001)
          WRITE (LU6, 1010) TTLNK, MAXLNK, TTLND, MAXND
      ENDIF
C
      RETURN
 1000 FORMAT ('1' //, 60X, 'NETSIM LINKS')
 1001 FORMAT(///, 14X, 9HLINK TYPE, 17X, 19HLANE CHANNELIZATION, 20X,
     1            4HRTOR, 20X, 10HPEDESTRIAN, /,
     2            47X, 5HCODES, 27X, 5HCODES, 22X, 5HCODES, //,
     3            10X, 14HIDENTIFIES THE, 15X, 15H0  UNRESTRICTED, 17X,
     4            17H0  RTOR PERMITTED, 11X, 17H0  NO PEDESTRIANS, /,
     5            8X, 21HDISTRIBUTION USED FOR, 10X,
     6            18H1  LEFT TURNS ONLY, 14X, 18H1  RTOR PROHIBITED,
     7            10X, 8H1  LIGHT, /, 8X, 19HQUEUE DISCHARGE AND, 12X,
     8            13H2  BUSES ONLY, 47X, 11H2  MODERATE, /,
     9            8X, 18HSTART-UP LOST TIME, 13X, 9H3  CLOSED,
     A            51X, 8H3  HEAVY, /,
     B            8X, 16HCHARACTERISTICS., 15X, 19H4  RIGHT TURNS ONLY,
     C            /, 39X, 14H5  CAR - POOLS, /,
     D            39X, 22H6  CAR - POOLS + BUSES, /, 39X,
     E            46H7  RIGHT TURNS + RIGHT DIAGONAL AND/OR THROUGH, /,  
     F            39X, 44H8  LEFT TURNS + LEFT DIAGONAL AND/OR THROUGH,  
     G            /,39X,42H9  ALL PERMITTED MOVEMENTS WITH RESPECT TO,/, 
     H            42X,46HTHE GEOMETRY AND ADJACENT LANE CHANNELIZATIONS, 
     I            /, 39X, 24HD  DIAGONAL TRAFFIC ONLY, /, 39X,           
     J            23HT  THROUGH TRAFFIC ONLY)                            
 1002 FORMAT (//45X, '* INDICATES DEFAULT VALUES WERE SPECIFIED')
 1003 FORMAT ('1')
 1004 FORMAT (A76, I4)                                                   
 1005 FORMAT (19I4)                                                      
 1006 FORMAT (5I4, 4I2, I1)                                              
 1007 FORMAT (I1)                                                        
 1008 FORMAT (8I4, I2, 4I1, I2)                                          
 1010 FORMAT (/18X, 'TOTAL LINKS:', I5, ' (ALLOWED:', I5, ')',
     1        /18X, 'TOTAL NON-ENTRY NODES:', I5, ' (ALLOWED:', I5, ')')
      END
      SUBROUTINE CLNUP (ISTEP)                                           
C                                                                        
C                                                                        
C --- CODED   10-05-79 BY E. LIEBERMAN                                   
C --- REVISED  5-18-87 BY O. SHARAF-ELDIEN FOR PROPER TRACE PROCESSING   
C --- REVISED  6-29-87 BY M. YEDLIN FOR GLOSSARY CHANGES                 
C --- REVISED  3-26-88 BY O. SHARAF-ELDIEN TO REMOVE REDUNDANT BLOCKS    
C --- REVISED 10-30-91 BY A. KANAAN FOR CODE CLEAN-UP                    
C --- REVISED  8-10-92 BY M. SEELEY AND J. WERK TO CLEAR TRIPLE STAR     
C ---                     BLOCKAGES (STATUS = 4) FROM XLKREB ARRAY       
C --- REVISED 12-23-97 BY M. YEDLIN FOR AIR QUALITY MODELING
C                                                                        
C --- TITLE - PERFORM REQUIRED END-OF-TIME-STEP TASKS - MODULE 3.2.3.4   
C                                                                        
C --- FUNCTION - THIS ROUTINE CALLS SUBORDINATE MODULES TO PERFORM       
C ---            THESE TASKS - IT ACTS AS AN EXECUTIVE ROUTINE           
C                                                                        
C --- ARGUMENTS - ISTEP  = COUNT OF TIME STEPS INTO TIME INTERVAL,       
C ---                      FROM CALLING ROUTINE                          
C                                                                        
C -------------------------   DESCRIPTION   ---------------------------  
C                             -----------                                
C                                                                        
C     THIS MODULE CALLS SUBORDINATE MODULES, AS REQUIRED, WHICH          
C     PERFORM THE FOLLOWING TASKS-- CHECK VEHICLE CHAIN, PROCESS         
C     EXPANSION WAVES WITHIN DISCHARGING QUEUES, EQUILIBRATE QUEUE       
C     LENGTHS VIA LANE-SWITCHING, PROCESS LONG- AND SHORT-TERM EVENTS    
C     CREATE AND STORE VEHICLE TRAJECTORY DATA, UPDATE STATUS OF BUSES   
C     IN DWELL, UPDATE SYSTEM STATISTICS, UPDATE SPILLBACK CONDITIONS,   
C     AND UPDATE THE STATUS OF ALL PRESENCE DETECTORS                    
C                                                                        
C --------------------  THIS ROUTINE CALLED BY  ------------------------ 
C                       ----------------------                           
C                                                                        
C                    NETSIM - MODULE 3.2.3                               
C                                                                        
C ---------------------   THIS ROUTINE CALLS   ------------------------- 
C                         ------------------                             
C                                                                        
C                    ADJQ   - MODULE 3234.2                              
C                    BUSUPD - MODULE 3234.5                              
C                    CHAIN  - MODULE 3234.1                              
C                    DETPTH - MODULE 3232.1.5                            
C                    EVENTS - MODULE 3234.3                              
C                    POLL   - MODULE 3234.8                              
C                    PUTMIC - MODULE 3234.12                             
C                    PUTMOE - MODULE 3234.10                             
C                    PUTSNP - MODULE 3234.11                             
C                    STCELL - MODULE 3234.13
C                    UPSTAT - MODULE 3234.6                              
C                    UPSPIL - MODULE 3234.7                              
C                    VTRAJ  - MODULE 3234.4                              
C                                                                        
C ------------------   GLOSSARY OF VARIABLE NAMES  --------------------  
C                      --------------------------                        
C                                                                        
C     AROUTE  HIGHEST BUS ROUTE NUMBER                                   
C     CLOCK   ELAPSED SIMULATION TIME, SEC. AT START OF TIME STEP        
C     CODES   VEHICLE SPECIFIC ARRAY - VEHICLE PROCESS CODE              
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER               
C     FUEL    CODE IDENTIFYING USER OPTION FOR ENVIRONMENTAL MEASURES    
C     IAP     APPROACH LINK TO MICRO-NODE                                
C     IBEGP   POINTER TO XREBP ARRAY FOR FIRST REB IN PATH THAT IS       
C             OCCUPIED BY VEHICLE IV                                     
C     ICLOCK  ELAPSED SIMULATION TIME, SEC. AT END OF TIME STEP          
C     IFELD   POINTER TO FIELD OF XLKREB ARRAY                           
C     IFELDC  POINTER TO FIELD OF XLKREB ARRAY FOR REB                   
C     IL      LINK NUMBER                                                
C     ILN     CURRENT LANE NUMBER                                        
C     ILV     LEAD VEHICLE                                               
C     IN      LOCAL VARIABLE FOR XNODE
C     IMIC    INDEX OVER MICRONODES                                      
C     IND     INDEX OVER POINTERS TO XREBP ARRAY FOR PATH OF VEHICLE IV  
C     IRC     RECEIVING LINK TO MICRO-NODE                               
C     IRLN    RECEIVING LANE TO MICRO-NODE                               
C     ISCAN   TIME-STEP FOR CHECKING VEHICLE CHAINS, SEC.                
C     ISTAT   REB STATUS                                                 
C     ITC     TURN CODE OF VEHICLE IV                                    
C     IV      VEHICLE NUMBER                                             
C     IVC     VEHICLE NUMBER                                             
C     IWORD   INDEX OVER POINTERS TO XLKREB ARRAY                        
C     IWORDC  POINTER TO WORD OF XLKREB ARRAY FOR REB                    
C     IWORD2  INDEX OVER POINTERS TO XLKREB ARRAY                        
C     IWRD    INDEX OVER POINTERS TO XLKREB ARRAY                        
C     JSCAN   TIME-STEP FOR CHECKING SPILLBACK, SEC.                     
C     LANEF   LINK AND LANE SPECIFIC ARRAY - FIRST VEHICLE IN LANE       
C     LENINT  LENGTH OF A TIME INTERVAL, SEC.                            
C     MCNOD   MICRONODE SPECIFIC ARRAY - NODE NUMBER                     
C     NVHLNK  LINK NUMBER CURRENTLY OCCUPIED
C     PRVLNK  VEHICLE SPECIFIC ARRAY - BITS (1-9) CONTAINING VEH'S
C                                      PREVIOUS LINK NUMBER 
C     SIGI    NODE AND APPROACH SPECIFIC ARRAY - APPROACH LINK NUMBERS   
C     SNPFRQ  TIME BETWEEN UPDATES OF SNAPSHOT FILE (SECS)               
C     TICNT   TIME INTERVAL COUNTER                                      
C     TTLMIC  TOTAL NUMBER OF MICRO NODES IN SUBNETWORK                  
C     TTLVEH  MAXIMUM NUMBER OF VEHICLES ON NETWORK                      
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER                 
C     VRPATH  VEHICLE SPECIFIC ARRAY - INDEX TO XREBP ARRAY IDENTIFYING  
C             CURRENT REB OCCUPIED BY THE VEHICLE (0 FOR NOT IN          
C             INTERSECTION)                                              
C     WAPP    LOGICAL FLAG (T, F) IF VEHICLE (IS, IS NOT) AT THE         
C             STOP-LINE OF APPROACH TO INTERSECTION                      
C     W1ST    LOGICAL (T, F) IF POINTER (IS, IS NOT) FIRST IN VEHICLE    
C             IV'S PATH                                                  
C     WGOOD   LOGICAL FLAG (T, F) IF REB STATUS (SHOULD NOT, SHOULD)     
C             BE REMOVED                                                 
C     WLAST   LOGICAL (T, F) IF POINTER (IS, IS NOT) LAST IN VEHICLE     
C             IV'S PATH                                                  
C     XLKREB  MICRONODE, APPROACH AND LANE SPECIFIC ARRAY - DATA FOR     
C             SEQUENTIAL REBS IN THREE SEQUENTIAL WORDS:                 
C              WORD                                                      
C               1: STATUS CODE (0 - 6) OF REBS 1 - 10 (3 BITS EACH)      
C               2: CONTAIN THE VEHICLE NUMBER INFLUENCING                
C                  (EITHER OCCUPYING OF "BLOCKING") THE REB              
C                  FOR REB1 (BITS 1-15), REB2 (BITS 16-30)               
C               3: SAME AS WORD 2 FOR REB3 (BITS 1-15),REB4 (BITS 16-30) 
C               4: SAME AS WORD 2 FOR REB5 (BITS 1-15),REB6 (BITS 16-30) 
C               5: SAME AS WORD 2 FOR REB7 (BITS 1-15),REB8 (BITS 16-30) 
C               6: SAME AS WORD 2 FOR REB9 (BITS 1-15),REB10 (BITS 16-30 
C     XNODE   NUMBER OF NODE WHERE AIR QUALITY DATA IS REQUESTED 
C     XREBP   ARRAY CONTAINING THE POINTER TO THE XLKREB ARRAY WORD THAT 
C             CONTAINS THE STATUS OF A REB ON A PATH, THE FIELD WITHIN   
C             THE XLKREB WORD CONTAINING THE STATUS FOR A REB, CODE      
C             INDICATING IF REB IS THE LAST REB IN THE PATH, AND THE     
C             DISTANCE FROM TAIL OF RECEIVER LINK TO THIS REB.           
C     YGRAPH  FLAG (T,F) IF USER (DOES,DOESN'T) WANT GRAPHICS OUTPUT     
C     YINIT   FLAG .T. IF INITIALIZATION IS ACTIVE                       
C                                                                        
C ---------------------------------------------------------------------  
C                                                                        
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)        
C                                                                        
      INCLUDE 'GLOBAL.INC'                                               
      INCLUDE 'NETSIM.INC'                                               
      INCLUDE 'AIRQUAL.INC'                                              
C                                                                        
      DATA ISCAN /1/, JSCAN /1/                                          
C                                                                        
C -----  PROCESS ALL BUSES IN DWELL, DISCHARGING THOSE WHO HAVE          
C -----  COMPLETED THEIR DWELL TIME. UPDATE STATISTICS ACCORDINGLY       
C            
      IF (AROUTE .GT. 0) CALL BUSUPD                                     
C                                                                        
C -----  PERIODICALLY, CHECK INTEGRITY OF VEHICLE CHAINS ON ALL LANES    
C -----  AND LINKS. IF A CHAIN IS IN ERROR, RE-ESTABLISH ALL CHAINS      
C -----  THROUGHOUT THE NETWORK AFTER WRITING MESSAGE                    
C                                                                        
      IF ((CLOCK / ISCAN) * ISCAN .EQ. CLOCK) CALL CHAIN                 
C                                                                        
C -----  ADJUST QUEUE EXPANSION WAVE WHERE APPLICABLE. ALSO HAVE         
C -----  QUEUED VEHICLE SWITCH LANE TO EQUILIBRATE QUEUE LENGTHS,        
C -----  WHEN POSSIBLE                                                   
C                                                                        
      CALL ADJQ                                                          
C                                                                        
C -----  TRA IF IN INITIALIZATION STAGE. ELSE, PROCESS SHORT- AND        
C -----  LONG-TERM EVENTS                                                
C                                                                        
      IF (YINIT)                                             GO TO 10    
      CALL EVENTS                                                        
C                                                                        
C -----  GET VEHICLE TRAJECTORY DATA, IF REQUESTED                       
C                                                                        
      IF (FUEL .NE. 6 .AND. FUEL .NE. 16) CALL VTRAJ(ISTEP)              
C                                                                        
C -----  PERIODICALLY CHECK FOR SPILLBACK                                
C                                                                        
      IF ((CLOCK / JSCAN) * JSCAN .EQ. CLOCK) CALL UPSPIL                
C                                                                        
   10 CONTINUE                                                           
C                                                                        
C -----  POLL ALL PRESENCE DETECTORS, IF ANY                             
C                                                                        
      CALL POLL                                                          
C                                                                        
C -----  UPDATE STATISTICS                                               
C                                                                        
      CALL UPSTAT                                                        
C
C -----  WHEN AIR QUALITY MODELING IS REQUESTED, LOOP OVER VEHICLES AND
C -----  CALL ROUTINE TO COMPUTE AIR QUALITY DATA FOR THIS TIME-STEP
C
      IF (XNODE .GT. 0 .AND. .NOT. YINIT) THEN   
         IN = XNODE
         DO 15 IV = 1, TTLVEH  
            IL = NVHLNK(IV)
            IF (IL .GT. 0) THEN
               JN = MOD (PRVLNK(IV), 2**9)
               IF (JN .NE. 0) JN = UPNOD(JN)
               IF (UPNOD(IL) .EQ. XNODE .OR. DWNOD(IL) .EQ. XNODE .OR.
     1             JN .EQ. XNODE) CALL STCELL (IV, IN)
            ENDIF
   15    CONTINUE
      ENDIF  
C                                                                        
C -----  WHEN GRAPHICAL DISPLAYS ARE REQUESTED AND INITIALIZATION IS     
C -----  COMPLETED, PERIODICALLY WRITE FILES TO DISPLAY SNAPSHOTS OF     
C -----  CURRENT LINK CONDITIONS AND LINK-SPECIFIC MOE DATA.             
C                                                                        
      ICLOCK = CLOCK + 1                                                 
      IF (YGRAPH .AND. (.NOT. YINIT)) THEN                               
         IF ((ICLOCK / LENINT) * LENINT .EQ. ICLOCK) THEN                
              CALL PUTMOE                                                
              CALL PUTMIC                                                
         ENDIF                                                           
         IF ((ICLOCK / SNPFRQ) * SNPFRQ .EQ. ICLOCK) CALL PUTSNP         
      ENDIF                                                              
C                                                                        
C -----  CLEAR TRIPLE STAR BLOCKAGES (STATUS = 4) FROM XLKREB ARRAY      
C                                                                        
      IMIC = 0                                                           
   20 CONTINUE                                                           
      IMIC = IMIC + 1                                                    
      IF (MCNOD(IMIC) .NE. 0) THEN                                       
         DO 60 IWORD = (IMIC - 1) * 210 + 1, IMIC * 210, 6               
            DO 50 IFELD = 1, 10                                          
               ISTAT = MOD (XLKREB(IWORD) / 2**((IFELD-1)*3), 2**3)      
               IWORD2 = IWORD + (IFELD + 1) / 2                          
               IF (ISTAT .EQ. 4) THEN                                    
                  XLKREB(IWORD) = XLKREB(IWORD) - ISTAT*2**((IFELD-1)*3) 
                  IF (MOD (IFELD, 2) .EQ. 1) THEN                        
                     XLKREB(IWORD2) = (XLKREB(IWORD2) / 2**15) * 2**15   
                  ELSE                                                   
                     XLKREB(IWORD2) = MOD(XLKREB(IWORD2), 2**15)         
                  ENDIF                                                  
               ENDIF                                                     
C                                                                        
C -----  IF THE FIRST REB SHOWS A SINGLE OR DOUBLE STAR BLOCKAGE         
C -----  (STATUS = 2 OR 3) DETERMINE WHICH VEHICLE IS EXERTING THIS      
C -----  INFLUENCE.  IF THIS VEHICLE IS ON AN APPROACH TO THE            
C -----  MICRONODE AND THE VEHICLE CHANGED LANES DURING THIS             
C -----  TIME-STEP, THEN CLEAR ITS SINGLE AND DOUBLE STAR BLOCKAGES      
C -----  FROM ITS PREVIOUS PATH.                                         
C                                                                        
               IF (ISTAT.EQ.2 .OR. ISTAT.EQ.3) THEN                      
                  IWRD = IWORD + (IFELD + 1) / 2                         
                  IF (MOD(IFELD, 2) .EQ. 1) THEN                         
                     IV = MOD (XLKREB(IWRD), 2**15)                      
                  ELSE                                                   
                     IV = XLKREB(IWRD) / 2**15                           
                  ENDIF                                                  
                  IF (VRPATH(IV) .EQ. 0) THEN                            
                     CALL DETPTH(IV, IMIC, IL, IAP, ILN, IRC, IRLN,      
     1                           ITC, WAPP, IBEGP)                       
C                                                                        
                     IND = IBEGP - 1                                     
   35                CONTINUE                                            
                     IND = IND + 1                                       
                     IWORDC = MOD(XREBP(IND), 2**15)                     
                     IFELDC = MOD(XREBP(IND) / 2**15, 2**4)              
                     WLAST = MOD(XREBP(IND) / 2**19, 2) .EQ. 1           
                     WGOOD = IWORD .EQ. IWORDC .AND. IFELD .EQ. IFELDC   
                     IF (.NOT. WGOOD .AND. .NOT. WLAST)      GO TO 35    
C                                                                        
                     IF (WGOOD .AND. IND .NE. IBEGP) THEN                
   40                   CONTINUE                                         
                        IND = IND - 1                                    
                        IWORDC = MOD(XREBP(IND), 2**15)                  
                        W1ST   = IND .EQ. IBEGP                          
                        IVC    = MOD (XLKREB(IWORDC+1), 2**15)           
                        WGOOD  = IV .EQ. IVC                             
                        IF (WGOOD .AND. .NOT. W1ST)        GO TO 40      
                     ENDIF                                               
C                                                                        
                     ILV = LANEF((IL - 1) * 7 + ILN)                     
                     IF (ILV .NE. IV .OR. .NOT. WGOOD) THEN              
                        XLKREB(IWORD)= XLKREB(IWORD) -                   
     1                               ISTAT * 2**((IFELD - 1) * 3)        
                        IF (MOD (IFELD, 2) .EQ. 1) THEN                  
                           XLKREB(IWORD2) = (XLKREB(IWORD2)/2**15)*2**15 
                        ELSE                                             
                           XLKREB(IWORD2) = MOD(XLKREB(IWORD2), 2**15)   
                        ENDIF                                            
                     ENDIF                                               
                  ENDIF                                                  
               ENDIF                                                     
   50       CONTINUE                                                     
   60    CONTINUE                                                        
      ENDIF                                                              
      IF (MCNOD(IMIC) .NE. 0 .AND. IMIC .LT. TTLMIC)         GO TO 20    
C                                                                        
      RETURN                                                             
      END                                                                
      SUBROUTINE NETSIM (ISTEP, WCASE)                                  
C                                                                       
C                                                                       
C --- CODED    6-17-79 BY M. KAPTANOGLU                                 
C --- REVISED 12-30-87 BY O. SHARAF-ELDIEN FOR CALLING NETCOM ONLY ONCE 
C --- REVISED  1-09-88 BY O. SHARAF-ELDIEN FOR NEW OVERLAY STRUCTURE    
C --- REVISED  8-01-88 BY A. KANAAN FOR MODIFYING PC OPEN STATEMENT     
C --- REVISED  8-28-89 BY H. CHEN TO ADD RUN-TIME MESSAGE FOR MS-DOS VER
C --- REVISED 11-14-89 BY A. KANAAN FOR SECOND MOE CUMULATIVE TABLE     
C --- REVISED 10-17-91 BY A. KANAAN TO CHECK TRANSITION AT BEGIN OF STEP
C --- REVISED  9-28-92 BY S.E.SMITH TO STORE AVG TT PER BUS ON ROUTE    
C --- REVISED 10-06-92 BY A. PHLEGAR TO ADD SURVEILLANCE DETECTOR       
C                                  INTERMEDIATE OUTPUT                  
C --- REVISED  2-17-93 BY J. COTTON FOR CORSIM                          
C --- REVISED  2-04-94 BY Y. CHUANG TO CORRECT SIGNAL TRANSITION LOGIC  
C                            WHICH IS UNNECESSARY DURING INITIALIZATION 
C --- REVISED  8-22-94 BY S. WALKER FOR CONCURRENT PROCESSING IN CORSIM 
C --- REVISED 12-23-97 BY M. YEDLIN FOR AIR QUALITY MODELING
C                                                                       
C                                                                       
C --- TITLE - SIMULATE TRAFFIC ON URBAN STREETS MICROSCOPICALLY         
C ---         MODULE - 3.2.3                                            
C                                                                       
C --- FUNCTION - THIS MODULE IS THE EXECUTIVE ROUTINE THAT CONTROLS     
C ---            THE SIMULATION OF TRAFFIC ON THE NETSIM SUBNETWORK     
C                                                                       
C --- ARGUMENTS - ISTEP   TIME STEP COUNTER                             
C                 WCASE   FLAG USED TO DETERMINE WHETHER CASE ABORT     
C                         FLAG, YCASE WAS SET .T. DURING THIS TIME STEP 
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE DIRECTS THE SIMULATION OF TRAFFIC FOR ONE TIME       
C     STEP ON THE NETSIM SUBNETWORK.  IT EMITS VEHICLES, MOVES          
C     THEM, UPDATES THE CONTROLS, UPDATES THE STATUS OF THE NETWORK,    
C     AND PRINTS NETSIM STATISTICS WHEN REQUESTED.                      
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    CORSIM -                                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    EMITLN - MODULE 3.2.3.1                            
C                    MOVE   - MODULE 3.2.3.2                            
C                    UPSIG  - MODULE 3.2.3.3                            
C                    CLNUP  - MODULE 3.2.3.4                            
C                    PUTNET - MODULE 3.2.3.6                            
C                    COMPQN -                                           
C                    DETOUT -                                           
C                    RFBLCK -                                           
C                    WNBLCK -                                           
C                    WRTAIR - MODULE 3.2.3.11
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     CLOCK   ELAPSED TIME SINCE BEGINNING OF SIMULATION, SECS.         
C     ELAPST  ARRAY OF ELAPSED TIMES TO START OF INTERMEDIATE OUTPUT    
C     EFREQ   EVALUATION FREQUENCE FOR SURVEILLANCE DETECTORS           
C     I       INDEX USED FOR INTERMEDIATE OUTPUT TESTS                  
C     IFRQ    COUNTER FOR FRQUENCY OF COLLECTING CUMULATIVE AVG. & MAX Q
C     ITRCE1  TIME, IN SECS., WHEN TRACING SHOULD BEGIN                 
C     ITRCE2  TIME, IN SECS., WHEN TRACING SHOULD END                   
C     LENPRD  LENGTH OF CURRENT TIME PERIOD                             
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     LU31    PERIPHERAL UNIT NUMBER 31                                 
C     LU32    PERIPHERAL UNIT NUMBER 32                                 
C     OUTFRQ  ARRAY OF PRINT FREQUENCY OF INTERMEDIATE OUTPUT           
C     OUTSPN  ARRAY OF TIME SPANS FOR INTERMEDIATE OUTPUT               
C     QFREQ   FREQUENCY AVERAGE AND MAXIMUM QUEUES ARE COLLECTED (SEC.) 
C     TPCNT   TIME PERIOD COUNTER                                       
C     TTLSUB  TOTAL NUMBER OF SUBNETWORKS BEING SIMULATED               
C     UDTCNT  ELAPSED TIME SINCE LAST INTERMEDIATE NETSIM OUTPUT        
C     UDTSUR  ELAPSED TIME SINCE LAST SURVEILLANCE DETECTOR INT. OUTPUT 
C     W       FLAG IS (T, F) IF (IS, ISNT) TIME TO PRINT INT. OUTPUT    
C     WFLAG   FLAG (T,F) TO DETOUT IF THIS (IS,IS NOT) FOR INTERMEDIATE 
C             SURVEILLANCE OUTPUT                                       
C     WSDET   FLAG (T,F) IF THERE (ARE, ARE NOT) SURVEILLANCE DETECTORS 
C             IN THIS NETWORK                                           
C     YCASE   CASE TERMINATION FLAG, SET TO .T. IF CASE MUST BE ABORTED 
C     YINIT   INITIALIZATION FLAG. FLAG IS TRUE UNTIL INITIALIZATION HAS
C             BEEN COMPLETED                                            
C     YTRACE  TRACE FLAG                                                
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C           
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
      INCLUDE 'AIRQUAL.INC'                                              
C                                                                       
C -----  CHECK TRANSITION LOGIC, EMIT VEHICLES, MOVE VEHICLES           
C -----  ALONG THE NETWORK, UPDATE ALL SIGNAL CONTROLS, AND THEN        
C -----  UPDATE THE STATUS OF THE NETSIM DATA BASE.                     
C                                                                       
      CALL RFBLCK                                                       
      IF (.NOT. YINIT) CALL CHKTRN                                      
      CALL EMITLN (ISTEP)                                               
      CALL MOVE                                                         
      CALL UPSIG                                                        
      CALL CLNUP(ISTEP)                                                 
C      CALL WNBLCK                                                      
      IF (YCASE .AND. .NOT. WCASE) WRITE (LU6, 1000) CLOCK              
      WCASE = YCASE                                                     
C                                                                       
C -----  INCREMENT SUBNETWORK SPECIFIC CLOCK TIMER AND RESET TIME       
C -----  SINCE LAST NETSIM INTERMEDIATE OUTPUT. PRINT INTERMEDIATE      
C -----  OUTPUTS UPON REQUEST.                                          
C                                                                       
      CLOCK = CLOCK + 1 
C
C -----  WHEN AIR QUALITY MEASURES ARE REQUESTED, OUTPUT THESE MEASURES
C -----  EVERY 15 MINUTES AFTER INITIALIZATION IS COMPLETED.
C
      IF (XNODE .GT. 0 .AND. .NOT. YINIT) THEN
         IF (MOD(CLOCK, 900) .EQ. 0) THEN
            CALL WRTAIR  
         ENDIF      
      ENDIF                                                    
C                                                                       
C ----- IF INTERMEDIATE STATISTICS REQUESTED AND                        
C ----- TIME FOR FIRST PRINT-OUT AND NOT INITIALIZATION                 
C                                                                       
      IF (OUTSPN(1) .NE. 0 .AND. CLOCK .GE. ELAPST(1) .AND.             
     1    .NOT. YINIT) THEN                                             
         IF (CLOCK .EQ. ELAPST(2) .OR. CLOCK .EQ. ELAPST(3))            
     1      UDTCNT = 0                                                  
         UDTCNT = UDTCNT + 1                                            
         I = 0                                                          
    4    CONTINUE                                                       
         I = I + 1                                                      
         W = (CLOCK .GT. ELAPST(I) .AND. CLOCK .LE. ELAPST(I)           
     1          + OUTSPN(I) .AND. UDTCNT .EQ. OUTFRQ(I)) .OR.           
     2          CLOCK .EQ. ELAPST(I)                                    
         IF (.NOT. W .AND. I .LT. 3 .AND.                               
     1          OUTFRQ(I+1) .GT. 0)                             GO TO 4 
C                                                                       
C ----  IF IT IS TIME TO PRINT INTER. OUTPUT OR TRACE FLAG IS ON        
C                                                                       
         IF (W) THEN                                                    
            UDTCNT = 0                                                  
            CALL PUTNET                                                 
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
      IF (YINIT .AND. YTRACE) CALL PUTNET                               
C                                                                       
C ----  PRINT SURVEILLANCE DETECTOR INTERMEDITE OUTPUT IF IT IS TIME    
C                                                                       
      IF ((.NOT. YINIT) .AND. (WSDET) .AND. (EFREQ .GT. 0)) THEN        
          IF (UDTSUR .EQ. EFREQ) THEN                                   
              WFLAG = .TRUE.                                            
              CALL DETOUT (WFLAG)                                       
              UDTSUR = 1                                                
          ELSE                                                          
              UDTSUR = UDTSUR + 1                                       
          ENDIF                                                         
      ENDIF                                                             
C                                                                       
C      CALL SUBROUTINE COMPQN TO COMPUTE AVERAGE AND MAXIMUM QUEUES     
C                                                                       
      IFRQ = IFRQ + 1                                                   
      IF (IFRQ .EQ. QFREQ) THEN                                         
          IFRQ = 0                                                      
          IF (.NOT. YINIT) CALL COMPQN                                  
      ENDIF                                                             
C                                                                       
 1000 FORMAT (6X, '********** CASE ABORT TRIGGERED FROM NETSIM AT',     
     1        I6, ' SECONDS FROM BEGINNING OF SIMULATION. **********')  
      RETURN                                                            
      END                                                               
      SUBROUTINE INSCAN
C
C --- CODED    8-10-79 BY M. MASSUCCI
C --- REVISED  5-04-87 BY O. SHARAF-ELDIEN FOR MISSING COMMON BLOCKS
C --- REVISED  7-01-87 BY M. YEDLIN FOR MISSING COMMON BLOCKS
C --- REVISED  9-15-87 BY AJAY K. RATHI FOR IDENTICAL TRAFFIC STREAMS
C --- REVISED  3-26-88 BY O. SHARAF-ELDIEN TO REMOVE REDUNDANT BLOCKS
C --- REVISED 11-08-91 BY J. WERK TO INCLUDE SCALARS AND ARRAYS FOR      
C ---                        INTRA-LINK LANE CHANGING LOGIC      
C --- REVISED 11-20-91 BY J. WERK TO INCLUDE SCALARS AND ARRAYS FOR      
C ---                        LINK GEOMETRIC DATA & INTERCHANGE DATA                                
C --- REVISED  8-26-92 BY S.E.SMITH FOR ARRAYS NEEDED TP SPEC OUTPUT
C --- REVISED  8-28-92 BY M. SEELEY AND J. WERK TO ADD 
C ---                        MICRO-INTERSECTION SCALARS AND ARRAYS
C --- REVISED 11-13-92 BY A. PHLEGAR TO ADD ARRAYS TO DETERMINE MAXIMUM
C                            NUMBER OF VEHICLES
C --- REVISED  7-07-94 BY A. PHLEGAR FOR SECTION SPECIFIC ARRAYS
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK VLANE AND VTYPLS
C --- REVISED 12-01-97 BY K. SHERIDAN FOR AIR QUALITY MODELING
C
C --- TITLE - CLEAR OR SET MISCELLANEOUS ARRAYS AND SCALARS -
C ---         MODULE 2261.1.5
C
C --- FUNCTION - THIS MODULE CLEARS OR SETS REMAINING ARRAYS AND SCALARS
C
C --- ARGUMENTS - NONE
C
C -------------------------   DESCRIPTION   ----------------------------
C                             -----------
C
C     THIS MODULE IS CALLED TO INITIALIZE ASSORTED ARRAYS AND SCALARS
C     FOR THE NETSIM SUBNETWORK (DURING THE FIRST TIME PERIOD)
C
C -------------------   THIS ROUTINE CALLED BY   -----------------------
C                       ----------------------
C
C                    INCENN - MODULE 2261.1
C
C ----------------------   THIS ROUTINE CALLS   -----------------------
C                          ------------------
C
C                               NONE
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ----------------------
C                    --------------------------
C
C     AGGFCT  DRIVER TYPE FACTOR USED TO COMPUTE DRIVER AGGRESSIVENESS   
C     BEGDEC  DECELERATION AT BEGINNING OF LANE CHANGE MANEUVER FOR      
C             COMPUTATION OF ACCEPTABLE RISK                             
C     BEGQUE  CUM NO OF VEHS IN QUEUE AT START OF IPH, ON APPROACH, IAP
C             AND LANE ILN, DURING CURRENT 15 MINUTE PERIOD 
C     BSCAN   BUS ID NUMBER SCANNER
C     CLOCK   ELAPSED TIME SINCE START OF SIMULATION, SECS.
C     COLCNT  ARRAY CONTAINING COUNTER OF COLLISIONS BY MOVMENTS.
C             INDEX K = (IMIC-1)*40 + (IAP-1)*8 + (IMV-1)*2 + IMV2,
C             WHERE IMIC IS MICRO-NODE INDEX, IAP IS APPROACH NUMBER
C             IN SIGI ARRAY, IMV IS PRIMARY MOVEMENT AND IMV2 IS
C             CONFLICTING MOVEMENT
C     COOPCT  PERCENTAGE OF DRIVERS WHO COOPERATE WITH A LANE CHANGER    
C     CUMDIG  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA DIAG MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IPH ACTIVE
C     CUMICM  ARRAY CONTAINING CUMULATIVE VEHICLE TRIPS THROUGH
C             INTERSECTION BY MOVEMENT
C             INDEX K = (IMIC-1)*20 + (IAP-1)*4 + IMV
C             WHERE IMIC IS MICRO-NODE INDEX, IAP IS APPROACH NUMBER
C             IN SIGI ARRAY, IMV IS PRIMARY MOVEMENT 
C     CUMLC   LINK SPECIFIC ARRAY - CUMULATIVE NUMBER OF LANE CHANGES    
C     CUMLFT  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA LEFT MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IPH ACTIVE
C     CUMMIC  MICRO-NODE SPECIFIC ARRAY - NUMBER OF VEHICLES DISCHARGING
C             INTERSETION FROM BEGINNNING OF SIMULATION
C     CUMRIT  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA RITE MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IPH ACTIVE
C     CUMTHR  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA THRU MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IPH ACTIVE
C     DATMIC  BUFFER ARRAY USED TO ACCUMULATE VEHICLE TRAJECTORIES
C             THROUGH THE MICRO-INTERSECTION: 
C                      VEHICLE SPEED                  (BITS 1-7),
C                      VEHICLE TYPE CODE 0, 1, OR 2   (BITS (8-10)
C                      VEHICLE ACCELERATION           (BITS 11-14)
C                      ACCELERATION CODE              (BIT 15)
C     DECDIF  ARRAY CONTAINING THE DIFFERENCE IN DECELERATION BETWEEN    
C             THE POSITION WHEN VEHICLE BEGAN TO RESPOND TO OBJECT AND   
C             THE POSITION OF THE OBJECT CAUSING THE LANE CHANGE         
C     DECFOL  DECELERATION RATE OF FOLLOWER VEHICLE                      
C     DECLED  DECELERATION RATE OF LEAD VEHICLE                          
C     DEPLNK  MICONODE RECEIVER SPECIFIC ARRAY - LINK NUMBER
C     DURPHS  PHASE SPECIFIC ARRAY - NO. OF SEC PHASE ACTIVE THIS 15 MIN  
C     EATBL   NUMBER OF ACCELERATION ELEMENTS IN ENVIRONMENTAL TABLES
C     EXSEED  ACTUAL NUMBER OF ENTRIES IN XLSEED ARRAY
C     ETTBL   NUMBER OF VEHICLE TYPES IN ENVIRONMENTAL TABLES
C     EVTBL   NUMBER OF SPEED ELEMENTS IN ENVIRONMENTAL TABLES
C     FLTAUT  PCT. OF VEHICLE TYPES IN AUTO  FLEET COMPONENT
C     FLTBUS  PCT. OF VEHICLE TYPES IN BUS   FLEET COMPONENT
C     FLTPUL  PCT. OF VEHICLE TYPES IN POOL  FLEET COMPONENT
C     FLTTRK  PCT. OF VEHICLE TYPES IN TRUCK FLEET COMPONENT
C     HEDMAX  HEADWAY ABOVE WHICH NO DRIVERS WILL ATTEMPT TO CHANGE      
C             LANES                                                      
C     HEDMIN  HEADWAY BELOW WHICH ALL DRIVERS WILL ATTEMPT TO CHANGE     
C             LANES                                                      
C     HIGHTM  CLOCK TIME WHEN HIGHEST NUMBER OF VEH. WERE ON NETWORK
C     HIGHVH  HIGHEST NUMBER OF VEHICLES ON NETWORK
C     IDATMC  CAPACITY OF DATMIC ARRAY (IDATMC = (IDATBF - 2) / 2
C     IMIC    INDEX OVER MICRO-NODES
C     K       DO LOOP INDEX                                              
C     LANDUR  DURATION OF NETSIM LANE CHANGE MANEUVER                    
C     LEVNT1  EVENT SPECIFIC ARRAY - TIME EVENT WILL BE ACTIVATED
C     LEVNT2  EVENT SPECIFIC ARRAY - TIME EVENT WILL BE DEACTIVATED
C     LEVNT3  EVENT SPECIFIC ARRAY - LOCATION OF EVENT
C     LEVNT4  EVENT SPECIFIC ARRAY - CODE 1 IF IN INTERSECTION (BIT 1),
C                                    LANE # ON CROSS STREET (BITS 2-4)
C                                    PREVIOUS LANE NUMBER (BITS (5-7),
C                                    PREVIOUS TURN CODE (BITS (8-15) -
C                                    FOR INTERSECTION BLOCKAGE ONLY  
C     LEVNT5  EVENT SPECIFIC ARRAY - DISTANCE FROM UPSTREAM NODE -
C                                    FOR INTERSECTION BLOCKAGE ONLY   
C     LEVNT6  EVENT SPECIFIC ARRAY - LANE NUMBER (BITS 1-3),
C                                    LINK NUMBER (BITS 4-15) FOR 
C                                    APPROACH THAT LOCATES BLOCAGE -
C                                    FOR INTERSECTION BLOCKAGE ONLY 
C     LEVNT7  EVENT SPECIFIC ARRAY - POINTER TO XREBP ARRAY IDENTIFYING
C                                    REB BLOCKED WITHIN VEHICLE 
C                                    TRAJECTORY EMULATING BLOCKAGE
C     LHORZN  LONGITUDINAL DISTANCE OVER WHICH DRIVERS DECIDE TO         
C             PERFORM ONE LANE CHANGE                                    
C     MAXEVT  MAXIMUM NUMBER OF EVENTS                                   
C     MAXICH  MAXIMUM INTERCHANGE NUMBER                                 
C     MAXLCH  MAXIMUM ALLOWABLE NUMBER OF LANE-CHANGING VEHICLES         
C     MAXLNK  MAXIMUM NUMBER OF LINKS IN SUBNETWORK                      
C     MAXMIC  MAXIMUM ALLOWABLE NUMBER OF MICRONODES
C     MAXND   MAXIMUM ALLOWABLE NUMBER OF NODES IN SUBNETWORK   
C     MAXTRJ  MAXIMUM NUMBER OF REBS TRAVERSED IN A SINGLE TRAJECTORY 
C     MAXVEH  MAXIMUM ALLOWABLE NUMBER OF VEHICLES IN SUBNETWORK         
C     MAXVIN  MAXIMUM NUMBER OF VEHICLES EXPECTED IN MICRO-INTERSECTION 
C     MCNOD   MICRONODE SPECIFIC ARRAY - NODE NUMBER
C     MXSCLK  MAXIMUM NUMBER OF LINKS IN SEGMENTS
C     MXSEC   MAXIMUM NUMBER OF SEGMENTS
C     MXSEED  MAXIMUM NUMBER OF ENTRIES IN XLSEED ARRAY                  
C     NCGLNK  POINTER TO 1ST ELEMENT IN XNCGLK PERTAINING TO AN INTCHG   
C     NMAPRC  MAXIMUM NUMBER OF APPROACHES AND RECEIVERS TO MICRONODE
C     NTCHG   POINTER TO 1ST ELEMENT IN XTRPTB PERTAINING TO AN INTCHG   
C     NUM96C  INTERCHANGE SPECIFIC ARRAY - NUMBER OF ELEMENTS IN         
C             XTRPTB ARRAY                                               
C     NUMLNK  NUMBER OF LINKS IN INTERCHANGE ICHG                        
C     PEDLY   MICONODE RECEIVER SPECIFIC ARRAY - REMAINING PED DELAY
C             (10THS OF SECS) ON LAST REB OF THIS DEPARTING LINK
C     PHSCNT  PHASE SPECIFIC ARRAY - NO OF TIMES PHASE ACTIVATED DURING
C             CURRENT 15 MINUTE PERIOD
C     PRVGLN  VEHICLE SPECIFIC ARRAY - PREVIOUS GOAL LANES AND TURN CODE
C     PRVLNK  VEHICLE SPECIFIC ARRAY - PREVIOUS LINK (BITS 1-9)
C     PTHREB  MICRONODE, APPROACH AND LANE SPECIFIC ARRAY - POINTERS TO
C             XREBP ARRAY IN TWO SEQUENTIAL WORDS:
C             WORD 1 (BITS  1-15) : FOR LEFT MOVEMENT                    
C             WORD 1 (BITS 16-30) : FOR THRU MOVEMENT                    
C             WORD 2 (BITS  1-15) : FOR RIGHT MOVEMENT                   
C             WORD 3 (BITS 16-30) : FOR DIAGONAL MOVEMENT                
C     RDCFOL  DECELERATION RATE OF FOLLOWER VEHICLE                      
C     RDCLED  DECELERATION RATE OF LEAD VEHICLE                          
C     RHEDMN  HEADWAY BELOW WHICH ALL DRIVERS WILL ATTEMPT TO CHANGE     
C             LANES                                                      
C     RHEDMX  HEADWAY ABOVE WHICH NO DRIVERS WILL ATTEMPT TO CHANGE      
C             LANES                                                      
C     SAFACT  SAFETY FACTOR                                              
C     SECSHN  ARRAY OF LINK NUMBERS COMPRISING SEGMENTS
C     SECNUM  ARRAY OF USER DEFINED SECTION NUMBERS
C     SIGHT   ARRAY CONTAINING FORWARD SIGHT DISTANCE AT STOP-LINE OF LK 
C     STPTHR  SPEED THRESHOLD FOR CALCULATING STOP DELAY                 
C     SUCTME  TIME REQUIRED FOR SUCCESSIVE LANE CHANGES                  
C     TDIFER  PERCENT CHANGE IN SUBNETWORK OCCUPANCY(PREVIOUS T. I.)     
C     TMREAC  REACTION TIME BY DRIVER TYPE                               
C     TOTCTD  TOTAL NUMBER OF ELEMENTS IN CTDATA ARRAY USED TO
C             DESCRIBE TURN CONSTRAINTS ON ENTERING TRAFFIC
C     TOTDET  TOTAL NUMBER OF DETECTORS
C     TOTEVT  TOTAL NUMBER OF EVENTS
C     TTLBUS  TOTAL NUMBER OF BUSES
C     TTLIEN  NUMBER OF ENTRY INTERFACE LINKS IN SUBNETWORK
C     TTLILK  NUMBER OF INTERNAL LINKS IN SUBNETWORK
C     TTLINT  NUMBER OF INTERVAL DURATIONS STORED IN DURINT ARRAY
C     TTLMIC  TOTAL NUMBER OF MICRO NODES IN SUBNETWORK
C     TTLND   TOTAL NUMBER OF NODES
C     TTLNK   TOTAL NUMBER OF LINKS
C     TTLVEH  TOTAL NUMBER OF VEHICLES
C     TVEHS   TOTAL NUMBER OF VEHICLES ON SUBNETWORK(PREVIOUS T. I.)
C     UDTCNT  ELAPSED TIME SINCE LAST STANDARD NETSIM OUTPUT
C     URGTHR  URGENCY THRESHOLD                                          
C     VCHNG   VEHICLE SPECIFIC ARRAY - REMAIN TIME TO CHK FOR LANE CHNG, 
C             INT BET LANE CHNGES, (1,0) IF (IN, NOT IN) GOAL LANE,      
C             POINTER TO VLNCHG ARRAY, FLAG IF VEH MUST SLOW TO ALLOW    
C             LANE CHANGER IN FRONT                                      
C     VEHOCC  ARRAY OF VEHICLE OCCUPANCY BY VEHICLE FLEET COMPONENT      
C     VHLANE  VEHICLE SPECIFIC ARRAY - TARGET LANE, GOAL LANES, FLAG IF  
C             DRIVER IS COOP. TO A LANE CHANGER, REMAIN TIME TO CHNGE    
C     VLNCHG  LANE CHANGE SPECIFIC ARRAY - VEH DWNSTRM OF IV THAT IS     
C             LEAVING IV'S LANE BUT STILL INFLUENCES IV'S MOVEMENT       
C     VMICRO  VEHICLE WITHIN MICRO-INTERSECTION SPECIFIC ARRAY - 
C             VEHICLE NUMBER
C     VPATH   VEHICLE SPECIFIC ARRAY - POINTER TO XIPATH ARRAY AND FIELD 
C             WITHIN XIPATH DESCRIBING VEHICLE'S CURRENT TURN MOVEMENT   
C     VREBP   ARRAY CONTAINING REB STATUS CODE FOR THE REMAINING
C             REBS IN A VEHICLES TRAJECTORY
C     VRPATH  VEHICLE SPECIFIC ARRAY - INDEX TO XREBP ARRAY IDENTIFYING
C             CURRENT REB OCCUPIED BY THE VEHICLE (0 FOR NOT IN
C             INTERSECTION)
C     VSCAN   VEHICLE ID NUMBER SCANNER
C     VTYPAH  VEHICLE TYPE ARRAY - MAX. ACCEL. AND HDWY FACTOR
C     VTYPLD  VEHICLE TYPE ARRAY - PERSON OCCUPANCY
C     VTYPLE  VEHICLE TYPE ARRAY - EFFECTIVE VEHICLE LENGTH 
C     VTYPSP  VEHICLE TYPE ARRAY - MAXIMUM SPEED AT 0 ACCELERATION 
C     XDATA   ARRAY CONTAINING ALL INFORMATION INPUT TO AND OUTPUT
C             FROM MODULE 3232.2111
C     XGOALN  VEHICLE SPECIFIC ARRAY - CURRENT GOAL LANE OF VEHICLE IV   
C     XIPATH  ARRAY CONTAINING TURN MOVEMENT CODES DEFINING THE PATH     
C             FROM AN ORIGIN TO A DESTINATION LINK                       
C     XLKREB  MICRONODE, APPROACH AND LANE SPECIFIC ARRAY - DATA FOR 
C             SEQUENTIAL REBS IN THREE SEQUENTIAL WORDS:
C              WORD
C               1: STATUS CODE (0 - 6) OF REBS 1 - 10 (3 BITS EACH) 
C               2: CONTAIN THE VEHICLE NUMBER INFLUENCING 
C                  (EITHER OCCUPYING OF "BLOCKING") THE REB 
C                  FOR REB1 (BITS 1-15), REB2 (BITS 16-30)
C               3: SAME AS WORD 2 FOR REB3 (BITS 1-15),REB4 (BITS 16-30)
C               4: SAME AS WORD 2 FOR REB5 (BITS 1-15),REB6 (BITS 16-30)
C               5: SAME AS WORD 2 FOR REB7 (BITS 1-15),REB8 (BITS 16-30)
C               6: SAME AS WORD 2 FOR REB9 (BITS 1-15),REB10 (BITS 16-30)
C     XLSEED  ARRAY OF RANDOM NUMBER SEEDS FOR ENTRY AND ENTRY-INTERFACE
C             LINKS AND INTERNAL LINKS WITH SOURCE POINTS
C     XMBUF   ARRAY OF DATA DESCRIBING RESOURCES CONSUMED THROUGH EACH
C             MICRO-INTERSECTION, STRATIFIED BY VEHICLE TYPE.
C     XMDIST  ARRAY CONTAINING DISTANCE TRAVELED THROUGH EACH
C             MICRO-INTERSECTION, STRATIFIED BY VEHICLE TYPE.
C     XNCGLK  CONTAINS UP TO 3 LINK NUMBERS OF LINKS WITHIN AN INTCHG    
C     XREBP   ARRAY CONTAINING SEQUENTIAL LIST OF REBS IN A PATH FOR
C             AS MANY PATHS AS ARE DETERMINED BY THE GEOMETRY AND
C             AS SPECIFIED IN PTHREB ARRAY
C     XTRPTB  ARRAY CONTAINING - ORIGIN LINK, DESTINATION LINK, TURN     
C                             CODE ON DESTINATION LINK, AND PERCENTAGE   
C                             OF TRAFFIC ON ORIGIN LINK THAT TRAVELS TO  
C                             DESTINATION LINK AND EXECUTES THAT TURN    
C                             MOVEMENT.                                  
C     XVTRPN  CUMULATIVE NUMBER OF VEHICLE TRIPS IN SUBNETWORK
C     XVTRPP  NO OF VEHICLE TRIPS IN SUBNETWORK AT START OF TIME PERIOD
C     XWIDTH  ARRAY CONTAINING LANE WIDTHS OF A LINK                     
C     XWIDT2  ARRAY CONTAINING:  WIDTH OF PARKING LANE, DISTANCE FROM    
C             STOP-LINE TO CURB, CURVATURE CODE, ELEVATION CODE,         
C             INTERCHANGE NUMBER, IF APPLICABLE, AND ANGLE OF LINK       
C             RELATIVE TO DUE NORTH                                      
C     YSEC    FLAG (T,F) IF SEGMENT SPECIFIC MOE (WILL,WONT) BE OUTPUT
C     ZVMAIR  ARRAY CONTAINING VEHICLE FEET OF TRAVEL BY APPROACH
C             AND SPEED CELL
C     ZVMART  ARRAY CONTAINING VEHICLE FEET OF TRAVEL BY APPROACH AND
C             VEHICLE TYPE
C 
C ----------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q,S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'NETSIM.INC'
      INCLUDE 'AIRQUAL.INC'
C
C -----  CLEAR EVENT SPECIFIC ARRAYS
C
         DO 10 K = 1, MAXEVT
            LEVNT1(K) = 0
            LEVNT2(K) = 0
            LEVNT3(K) = 0
            LEVNT4(K) = 0                                            
            LEVNT5(K) = 0                                            
            LEVNT6(K) = 0                                            
            LEVNT7(K) = 0                                            
   10    CONTINUE
C
C -----  CLEAR ARRAY USED FOR MODULE 3232.2111, XDATA
C
         DO 20 K = 1, 10
            XDATA(K) = 0
   20    CONTINUE
C
C -----  CLEAR VEHICLE TYPE ARRAYS
C
         DO 30 K = 1, 16
            FLTAUT(K) = 0
            FLTBUS(K) = 0
            FLTPUL(K) = 0
            FLTTRK(K) = 0
            VTYPAH(K) = 0
            VTYPLD(K) = 0
            VTYPLE(K) = 0
            VTYPSP(K) = 0
   30    CONTINUE
C
C -----  CLEAR SEGMENT ARRAY.
C
         DO 40 K = 1, MXSCLK
            SECSHN(K) = 0
   40    CONTINUE
         DO 42 K = 1, MXSEC
            SECNUM(K) = 0
   42    CONTINUE
C
C -----  CLEAR OR SET SCALARS
C
      AGGFCT = 0                                                         
      BEGDEC = 0                                                         
      BSCAN  = 0
      CLOCK  = 0
      COOPCT = 0                                                         
      DECFOL = 0                                                         
      DECLED = 0                                                         
      EATBL = 19
      EXSEED = 0
      ETTBL =  3
      EVTBL = 71
      HEDMAX = 0                                                         
      HEDMIN = 0                                                         
      HIGHTM = 0
      HIGHVH = 0
      KAIRMX = 3000000
      LANDUR = 0                                                         
      LHORZN = 0                                                         
      RDCFOL = 0.0                                                       
      RDCLED = 0.0                                                       
      RHEDMX = 0.0                                                       
      RHEDMN = 0.0                                                       
      SAFACT = 0                                                         
      STPTHR = 3                                                         
      SUCTME = 0                                                         
      TDIFER = 0
      TTLND  = 0
      TTLIEN = 0
      TTLILK = 0
      TTLINT = 0
      TTLVEH = 0
      TTLBUS = 0
      TTLNK  = 0
      TOTEVT = 0
      TOTDET = 0
      TVEHS  = 0
      UDTCNT = 0
      URGTHR = 0                                                         
      VSCAN  = 0
      XVTRPN = 0
      XVTRPP = 0
      YSEC   = .FALSE.
C
C -----  CLEAR ARRAY OF LINK-TURN MOVEMENT SPECIFIC RANDOM NUMBER
C -----  SEEDS
C
         DO 45 K = 1, MXSEED
            XLSEED(K) = 0
   45    CONTINUE
C
C -----  CLEAR COUNTER OF ENTRIES USED IN CTDATA ARRAY TO DESCRIBE
C -----  TURNING CONSTRAINTS ON ENTERING TRAFFIC
C
      TOTCTD = 0
C
C -----  FOR CONSISTENCY, CLEAR ARRAY OF VEHICLE OCCUPANCIES
C
         DO 50 K = 1, 4
            VEHOCC(K) = 0
   50    CONTINUE
C                                                                        
C -----  CLEAR ARRAY OF DECELERATION RATES FOR MANDATORY AND             
C -----  DISCRETIONARY LANE CHANGE MANEUVERS                             
C                                                                        
         DO 60 K = 1, 2                                                  
            DECDIF(K) = 0                                                
   60    CONTINUE                                                        
C                                                                        
C -----  CLEAR VEHICLE LANE CHANGING ARRAYS                              
C                                                                        
         DO 65 K = 1, MAXVEH                                             
            PRVGLN(K) = 0
            PRVLNK(K) = 0
            VHLANE(K) = 0                                                 
            VCHNG(K) = 0                                                 
            VPATH(K) = 0                                                 
            VRPATH(K) = 0
   65    CONTINUE                                                        
C                                                                        
C -----  CLEAR ARRAY OF REACTION TIME BY DRIVER TYPE                     
C                                                                        
         DO 70 K = 1, 10                                                 
            TMREAC(K) = 0                                                
   70    CONTINUE                                                        
C                                                                        
C -----  CLEAR ARRAY OF FORWARD SIGHT DISTANCES AT STOP-LINE OF EACH     
C -----  LINK, ARRAY OF LANE WIDTHS OF EACH LINK, AND ARRAY CONTAINING   
C -----  WIDTH OF PARKING LANE, DISTANCE FROM STOP-LINE TO CURB,         
C -----  CURVATURE CODE, ELEVATION CODE, INTERCHANGE NUMBER, IF          
C -----  APPLICABLE, AND ANGLE OF LINK RELATIVE TO DUE NORTH             
C                                                                        
         DO 80 K = 1, MAXLNK                                             
            CUMLC(K) = 0                                                 
            SIGHT(K) = 0                                                 
            XWIDTH(K) = 0                                                
            XWIDT2(K) = 0                                                
   80    CONTINUE                                                        
C                                                                        
C -----  CLEAR ALL INTERCHANGE DATA ARRAYS                               
C                                                                        
         DO 90 K = 1, MAXICH                                             
            NTCHG(K) = 0                                                 
            NCGLNK(K) = 0                                                
            NUM96C(K) = 0                                                
            NUMLNK(K) = 0                                                
   90    CONTINUE                                                        
         DO 100 K = 1, MAXICH * 13                                       
            XNCGLK(K) = 0                                                
  100    CONTINUE                                                        
         DO 110 K = 1, MAXICH * 60                                       
            XTRPTB(K) = 0                                                
            XIPATH(K) = 0                                                
  110    CONTINUE                                                        
C                                                                        
C -----  CLEAR GOAL LANE ARRAY                                           
C                                                                        
         DO 120 K = 1, MAXVEH * 3                                        
            XGOALN(K) = 0                                                
  120    CONTINUE                                                        
C                                                                        
C -----  CLEAR LANE-CHANGE SPECIFIC ARRAY.                               
C                                                                        
         DO 125 K = 1, MAXLCH                                            
            VLNCHG(K) = 0                                                
  125    CONTINUE                                                        
C
C -----  CLEAR MICRONODE ARRAYS.
C
         DO 135 K = 1, MAXMIC
            MCNOD(K) = 0  
  135    CONTINUE
         DO 140 K = 1, MAXMIC * 5
            DEPLNK(K) = 0
            PEDLY(K) = 0  
  140    CONTINUE
         DO 145 K = 1, MAXMIC * 70
            PTHREB(K) = 0
  145    CONTINUE
         DO 150 K = 1, MAXTRJ     
            VREBP(K) = 0
  150    CONTINUE
         DO 152 K = 1, MAXVIN     
            VMICRO(K) = 0
  152    CONTINUE
         DO 155 K = 1, MAXMIC * 4200
            XREBP(K) = 0
  155    CONTINUE
C
C -----  INITIALIZE CODE INDICATING STATUS REB TO DOES NOT EXIST
C  
         DO 165 K = 1, MAXMIC * 210, 6
            XLKREB(K) = 766958445     
  165    CONTINUE         
C
C -----  INITIALIZE CONFLICT AND TRIP VARIABLES FOR MICRO-NODES
C
      TTLMIC = 0  
         DO 190 IMIC = 1, MAXMIC
            CUMMIC(IMIC) = 0
               DO 170 K = 1, 40
                  COLCNT((IMIC-1)*40+K) = 0
  170          CONTINUE
               DO 175 K = 1, 20
                  CUMICM((IMIC-1)*20+K) = 0
  175          CONTINUE
               DO 180 K = 1, 12
                  XMBUF((IMIC-1)*12+K) = 0
  180          CONTINUE
               DO 185 K = 1, 3
                  XMDIST((IMIC-1)*3+K) = 0
  185          CONTINUE
  190    CONTINUE
         DO 200 K = 1, IDATMC
            DATMIC(K) = 0
  200    CONTINUE   
C
C -----  CLEAR ARRAYS FOR AIR QUALITY MODELING LOGIC.
C
      PHSMX = 0
      KAIRPT = 0
         DO 250 I = 1, 10
            LKAQ(I) = 0
               DO 230 I2 = 1, 125
                  DO 220 I3 = 1, 7
  220             CONTINUE
  230          CONTINUE                   
               DO 240 K = 1, 14
                  ZVMAIR(I,K) = 0
  240          CONTINUE   
               DO 245 K = 1, 4
                  ZVMART(I,K) = 0  
  245          CONTINUE       
  250    CONTINUE
         DO 210 J = 1, KAIRMX
            DAIRSA(J) = 0
            DAIRBL(J) = 0
            DAIRTM(J) = 0
            DAIRLN(J) = 0
            DAIRIA(J) = 0
  210    CONTINUE
         DO 280 IPH = 1, 8
            DURPHS(IPH) = 0
            PHSCNT(IPH) = 0
            DO 270 IA = 1, 5
               CUMLFT(IA,IPH) = 0
               CUMTHR(IA,IPH) = 0
               CUMRIT(IA,IPH) = 0
               CUMDIG(IA,IPH) = 0
               DO 260 ILN = 1, 7
                  BEGQUE(IA,ILN,IPH) = 0  
  260          CONTINUE
  270       CONTINUE
  280    CONTINUE
         DO 290 I = 1, 12
            FZINT(I) = 0
  290    CONTINUE      
C                                                                        
      RETURN
      END
      SUBROUTINE TRFOPN(LU)
C
C
C --- CODED    4-19-91 BY A. KANAAN
C --- REVISED 10-17-91 BY B. ANDREWS TO OPEN CORFLO GRAPHIC FILES
C --- REVISED  1-28-92 BY J. WERK TO RECOGNIZE LAHEY FLAG
C --- REVISED 10-19-92 BY M. SEELEY TO PROCESS COMMAND LINE FOR TSIS
C --- REVISED 12-26-92 BY A. AKANAAN TO REMOVE LU8, LU9, LU11
C --- REVISED  1-07-93 BY J. COTTON FOR FRESIM
C --- REVISED  2-10-93 BY M. SEELEY TO ADD UNIT56
C --- REVISED  3-17-93 BY J. COTTON FOR BLOCKSIZE REDUCTION
C --- REVISED  4-13-93 BY A. PHLEGAR TO ADD LU82, LU84
C --- REVISED  6-08-94 BY Y. CHUANG TO DELETE LU72 AND LU81
C --- REVISED 11-15-94 BY I.J. CHIEN FOR CORSIM GRAPHICS LU90 & 91
C --- REVISED 12-21-94 BY A. AKANAAN TO ACCOUNT FOR WATCOM
C --- REVISED 12-01-97 BY K. SHERIDAN FOR AIR QUALITY MODELING
C
C --- TITLE - OPEN LOGICAL UNIT FILE
C
C --- FUNCTION - THIS MODULE CONTROLS THE OPEN FILE PROCEDURE FOR
C ---            ALL LOGICAL DEVICES PASSED.  THE MICRO OR MAINFRAME
C ---            VERSION IS CONSIDERED BEFORE OPENING THE FILE.
C
C --- ARGUMENTS - LU    = LOGICAL UNIT NUMBER TO OPEN, FROM CALLER
C
C -------------------------   DESCRIPTION   ----------------------------
C                            -----------
C
C     THIS MODULE IS CALLED EVERY TIME A LOGICAL UNIT DEVICE IS TO BE
C     OPENED.  THE MICRO VERSION IS CHECKED AND THE OPEN STATEMENT IS
C     CONSTRUCTED ACCORDINGLY.
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                    GETSD3 - MODULE 2251.3
C                    GETSD4 - MODULE 2251.4
C                    GETSD5 - MODULE 2251.5
C                    GETSD6 - MODULE 2251.6
C                    LEVELF - MODULE 3.2.4
C                    NETSIM - MODULE 3.2.3
C                    NTERTA - MODULE 2.2.5.5
C                    OUTNET - MODULE 4.3
C                    PINTER - MODULE 2.2.5
C                    PMACFR - MODULE 2.2.1
C                    PNETSM - MODULE 2.2.6
C                    PRIME  - MODULE 2.0
C                    PUTFRE - MODULE 4.4
C                    PUTGRF - MODULE 2.2.6.5
C                    RESETF - MODULE 3.1.2.4
C                    RESETN - MODULE 3.1.2.3
C                    TESTLF - MODULE 3.1.1.4
C                    TESTLM - MODULE 3.1.1.3
C                    TRAF   - MODULE 1.0
C                    TRAFIC - MODULE 5.1
C                    TRFASS - MODULE 5.0
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                    NONE
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ---------------------
C                    --------------------------
C
C     ACCES   STRING FOR SEQUENTIAL
C     BSIZE   BLOCKSIZE (2048=MSDOS 2*DEFAULT, 64000=LAHEY)
C     CASINP  CHARACTER STRING CONTAINING CASE NAME
C     I       INDEX
C     KBATCH  NAME OF TEMP. FILE FOR I/O FILES (LAHEY ONLY)
C     KFILE   NAME OF FILE TO OPEN
C     LU      PERIPHERAL UNIT NUMBER
C     LU5     PERIPHERAL UNIT NUMBER 65
C     LU6     PERIPHERAL UNIT NUMBER 66
C     LU7     PERIPHERAL UNIT NUMBER 7
C     LU8     PERIPHERAL UNIT NUMBER 8 (LEVEL 1 DATA BASE)
C     LU9     PERIPHERAL UNIT NUMBER 9  (LEVEL 2 DATA BASE)
C     LU11    PERIPHERAL UNIT NUMBER 11
C     LU12    PERIPHERAL UNIT NUMBER 12
C     LU15    UNIT 15 (O-D FILE)
C     LU16    UNIT 16 (GEOMETRIC-PATH NETWORKS' MAPPING ARRAYS)
C     LU17    UNIT 17 (GEOM.NETWORK LINK FILE)
C     LU18    UNIT 18 (TEMP.FILE FOR GLOB.NETWORK O-D MATRIX)
C     LU19    UNIT 19 (TRN MVMT FILE)
C     LU20    UNIT 20 (MIN.PATH TREE FILE )
C     LU31    PERIPHERAL UNIT NUMBER 31
C     LU32    PERIPHERAL UNIT NUMBER 32
C     LU40    UNIT 40 (SELECTED ITEMS FROM GLOBAL AND NETSIM DATA BASE)
C     LU41    PERIPHERAL UNIT NUMBER 41
C     LU42    PERIPHERAL UNIT NUMBER 42
C     LU43    PERIPHERAL UNIT NUMBER 43
C     LU44    PERIPHERAL UNIT NUMBER 44
C     LU45    PERIPHERAL UNIT NUMBER 45
C     LU48    PERIPHERAL UNIT NUMBER 48
C     LU49    PERIPHERAL UNIT NUMBER 49
C     LU52    PERIPHERAL UNIT NUMBER 52
C     LU55    PERIPHERAL UNIT NUMBER 55
C     LU56    PERIPHERAL UNIT NUMBER 56
C     LU61    PERIPHERAL UNIT NUMBER 61
C     LU71    PERIPHERAL UNIT NUMBER 71
C     LU82    PERIPHERAL UNIT NUMBER 82 (FOR OD OUTPUT ONLY)
C     LU90    UNIT 90 (FRESIM GEOMETRY DATA BASE)
C     LU91    UNIT 91 (FRESIM VEHICLE DATA BASE)
C     LU92    UNIT 92 (NETSIM AIR QUALITY MODELING DATA UNIT)
C     NOFRM   STRING FOR 'UNFORMATTED'
C     STATS   STRING FOR STATUS 'UNKNOWN'
C     YBATCH  FLAG (TRUE IF BATCH MODE IS ACTIVE> NO PROMPT IN LAHEY)
C     YLAHEY  FLAG FOR LAHEY COMPILER
C     YMSDOS  FLAG FOR MS-DOS ENVIRONMENT
C     YSUB    SUBNETWORK FLAG (T,F) IF IT (DOES,NOT) EXIST
C     ZERO    STRING FOR 'ZERO'
C
C ----------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'GLOBAL.INC'
C
      CHARACTER ACCES*10
C
C     CHARACTER CASINP*8             <<<<<ALREADY DECLARED IN GLOBAL.INC
C
      CHARACTER KBATCH*11
      CHARACTER KFILE*50
      CHARACTER NOFRM*11
      CHARACTER STATS*7
      CHARACTER ZERO*4
C
      ACCES = 'SEQUENTIAL'
      KBATCH = '_CORFLO.INP'
      NOFRM = 'UNFORMATTED'
      STATS = 'UNKNOWN'
      ZERO = 'ZERO'
C
C --- ASSIGN BLOCKSIZE BASED ON TYPE OF OPERATING ENVIRONMENT
C
      BSIZE = 2048
      IF (YLAHEY) BSIZE = BSIZE * 15
C
C -----  DETERMINE FILE NAME TO BE USED ON OPEN STATEMENT BASED ON
C -----  OPERATING SYSTEM (DOS OR NON-DOS).  WHEN RUNNING A CORFLO
C -----  CASE APPEND TO THE CASE NAME '.F50' FOR DOS SYSTEMS OR 'G' FOR
C -----  NON-DOS SYSTEMS WHEN OPENING UNIT 40, THE GEOMETRIC DATA
C -----  FILE.  OTHERWISE, USE '.F40' OR '0' FOR NETSIM.  SIMILARLY,
C -----  WHEN RUNNING CORFLO USE '.F62' OR 'L' FOR UNIT 42, THE LINK
C -----  MOE DATA FILE, OTHERWISE USE '.F42' OR '2' FOR NETSIM.
C -----  ALSO, USE '.F53' OR 'B' FOR UNIT 43, THE CORFLO MASS TRANSIT
C -----  MOE DATA FILE, OTHERWISE USE '.F43' OR '3' FOR NETSIM.
C -----  NOTE, EVENTUALLY WHEN NETSIM IS COMBINED WITH CORFLO ALL DATA
C -----  CAN BE WRITTEN TO CORFLO FILES AND THE NETSIM UNIT NAMES
C -----  ELIMINATED.
C
      KFILE = ' '
      IF (LU .GE. 40) THEN
          I = INDEX (CASINP, ' ') - 1
          IF (I .LT. 0)  I = 8
          KFILE = CASINP(1:I)
          IF (YMSDOS) THEN
              WRITE (KFILE(I+1:I+4) , 10) LU
              IF (YSUB(4) .OR. YSUB(5) .OR. YSUB(6)) THEN
                  IF (LU .EQ. 40) KFILE(I+1:I+4) = '.F50'
                  IF (LU .EQ. 42) KFILE(I+1:I+4) = '.F62'
                  IF (LU .EQ. 43) KFILE(I+1:I+4) = '.F53'
              ENDIF
          ELSE
              IF (LU .LE. 49) WRITE (KFILE(I+1:I+1) , '(I1)') LU-40
              IF (LU .EQ. 52) KFILE(I+1:I+1) = 'T'
              IF (LU .EQ. 55) KFILE(I+1:I+1) = 'A'
              IF (LU .EQ. 56) KFILE(I+1:I+1) = 'M'
              IF (LU .EQ. 61) KFILE(I+1:I+1) = 'H'
              IF (LU .EQ. 71) KFILE(I+1:I+1) = 'F'
              IF (LU .EQ. 72) KFILE(I+1:I+1) = 'R'
              IF (LU .EQ. 81) KFILE(I+1:I+1) = 'V'
              IF (YSUB(4) .OR. YSUB(5) .OR. YSUB(6)) THEN
                  IF (LU .EQ. 40) KFILE(I+1:I+4) = 'G'
                  IF (LU .EQ. 42) KFILE(I+1:I+4) = 'L'
                  IF (LU .EQ. 43) KFILE(I+1:I+4) = 'B'
              ENDIF
          ENDIF
      ENDIF
C
      YBATCH = .FALSE.
C
C --- CHECK WHICH UNIT IS TO BE OPENED.
C --- IF NOT RECOGNIZED STOP (PROBABLE BUG).
C --- CHECK IF THIS IS A BATCH RUN FOR LAHEY VERSION ONLY
C
      IF (LU .EQ. 65) THEN
CAK       IF (YLAHEY) THEN
              INQUIRE (FILE = KBATCH, EXIST = YBATCH)
              IF (YBATCH) THEN
                 OPEN (LU5, FILE = KBATCH)
                   READ (LU5,*) KFILE
                 CLOSE (LU5)
                 WRITE(*,*) ' INPUT FILE NAME: ' // KFILE
              ELSE
                 WRITE(*,*) ' ENTER INPUT FILE NAME:'
                 IF (YLAHEY) THEN 
                     READ (*,*) KFILE
                 ELSE 
                     READ (*, '(A50)') KFILE
                 ENDIF
              ENDIF
CAK       ENDIF
          OPEN (LU5, FILE = KFILE)
      ELSEIF (LU .EQ. 66) THEN
CAK       IF (YLAHEY) THEN
              INQUIRE (FILE = KBATCH, EXIST = YBATCH)
              IF (YBATCH) THEN
                 OPEN (LU6, FILE = KBATCH)
                   READ (LU6,*) KFILE
                   READ (LU6,*) KFILE
                 CLOSE (LU6)
                 WRITE(*,*) ' OUTPUT FILE NAME: ' // KFILE
              ELSE
                 WRITE(*,*) ' ENTER OUTPUT FILE NAME:'
                 IF (YLAHEY) THEN
                     READ (*,*) KFILE
                 ELSE 
                     READ (*, '(A50)') KFILE
                 ENDIF
              ENDIF
CAK       ENDIF
          OPEN (LU6, FILE = KFILE, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 7) THEN
          OPEN (LU7, FILE = 'LU7', BLANK = ZERO)
C      ELSEIF (LU .EQ. 8) THEN
C          OPEN (LU8, FILE = 'LU8', FORM = NOFRM, BLOCKSIZE = BSIZE)
C      ELSEIF (LU .EQ. 9) THEN
C          OPEN (LU9, FILE = 'LU9', FORM = NOFRM, BLOCKSIZE = BSIZE)
C      ELSEIF (LU .EQ. 11) THEN
C          OPEN(LU11, FILE = 'LU11', FORM = NOFRM, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 12) THEN
         OPEN (LU12, FILE = 'LU12', FORM = NOFRM, STATUS = STATS)
      ELSEIF (LU .EQ. 15) THEN
          OPEN(LU15, FILE = 'LU15', FORM = NOFRM, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 16) THEN
          OPEN(LU16, FILE = 'LU16', FORM = NOFRM, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 17) THEN
          OPEN(LU17, FILE = 'LU17', FORM = NOFRM, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 18) THEN
          OPEN (LU18, FILE = 'LU18', FORM = NOFRM, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 19) THEN
          OPEN (LU19, FILE = 'LU19', FORM = NOFRM, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 20) THEN
          OPEN(LU20, FILE = 'LU20', FORM = NOFRM, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 31) THEN
          OPEN (LU31, FILE = 'LU31', FORM = NOFRM, STATUS = STATS)
      ELSEIF (LU .EQ. 32) THEN
          OPEN (LU32, FILE = 'LU32', FORM = NOFRM, STATUS = STATS)
      ELSEIF (LU .EQ. 35) THEN
          OPEN(LU35, FILE = 'LU35', FORM = NOFRM)
      ELSEIF (LU .EQ. 36) THEN
          OPEN(LU36, FILE = 'LU36', FORM = NOFRM)
      ELSEIF (LU .EQ. 37) THEN
          OPEN (LU37, FILE = 'LU37', ACCESS = ACCES, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 38) THEN
          OPEN (LU38, FILE = 'LU38', FORM = NOFRM)
      ELSEIF (LU .EQ. 39) THEN
          OPEN (LU39, FILE = 'LU39', FORM = NOFRM)
      ELSEIF (LU .EQ. 40) THEN
          OPEN (LU40, FILE = KFILE, ACCESS = ACCES, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 41) THEN
          OPEN (LU41, FILE = KFILE, ACCESS = ACCES, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 42) THEN
          OPEN (LU42, FILE = KFILE, ACCESS = ACCES)
      ELSEIF (LU .EQ. 43) THEN
          OPEN (LU43, FILE = KFILE, ACCESS = ACCES)
      ELSEIF (LU .EQ. 44) THEN
          OPEN (LU44, FILE = KFILE, ACCESS = ACCES)
      ELSEIF (LU .EQ. 45) THEN
          OPEN (LU45, FILE = KFILE, ACCESS = ACCES)
      ELSEIF (LU .EQ. 48) THEN
          OPEN (LU48, FILE = KFILE, ACCESS = ACCES)
      ELSEIF (LU .EQ. 49) THEN
          OPEN (LU49, FILE = KFILE, ACCESS = ACCES)
      ELSEIF (LU .EQ. 52) THEN
          OPEN (LU52, FILE = KFILE, ACCESS = ACCES, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 55) THEN
          OPEN (LU55, FILE = KFILE, ACCESS = ACCES, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 56) THEN
          OPEN (LU56, FILE = KFILE, ACCESS = ACCES)
      ELSEIF (LU .EQ. 61) THEN
          OPEN (LU61, FILE = KFILE, ACCESS = ACCES, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 71) THEN
          OPEN (LU71, FILE = KFILE, ACCESS = ACCES, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 82) THEN
          OPEN (LU82, FILE = 'LU82', ACCESS = ACCES, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 84) THEN
          OPEN (LU84, FILE = 'TRAF.ERR', BLOCKSIZE = BSIZE)
C
CCC   I.J. CHIEN ADD FOR CORSIM GRAPHICS
C
      ELSEIF (LU .EQ. 90) THEN
          IB = INDEX(CASINP, ' ')
          IF (IB .EQ. 0) IB = 9
          IB = IB - 1
          KFILE = CASINP(1:IB)//'.F90'
          OPEN (LU90, FILE = KFILE, ACCESS = ACCES, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 91) THEN
          IB = INDEX(CASINP, ' ')
          IF (IB .EQ. 0) IB = 9
          IB = IB - 1
          KFILE = CASINP(1:IB)//'.F91'
          OPEN (LU91, FILE = KFILE, ACCESS = ACCES, BLOCKSIZE = BSIZE)
      ELSEIF (LU .EQ. 92) THEN
          OPEN (LU92, FILE = 'LU92', FORM = NOFRM)
C
CCC
C
      ELSE
          IF (YMSDOS) WRITE(*,*) 'UNRECOGNIZED UNIT NUMBER:', LU
          STOP 'TERMINATE IN SUBROUTINE TRFOPN'
      ENDIF
C
      IF (YTRACE) WRITE (*, 20) LU
C
      RETURN
10    FORMAT('.F', I2)
20    FORMAT(' TRFOPN OPENED UNIT', I4)
      END
      SUBROUTINE CLRGLB
C
C --- CODED    3-20-78 BY B. ANDREWS
C --- REVISED  8-15-87 BY O. SHARAF-ELDIEN FOR THE NEW ASSIGNMENT LOGIC
C --- REVISED 10-15-87 BY K. SHERIDAN (FOR NETSIM SIGNAL TRANSITION)
C --- REVISED  1-02-88 BY O. SHARAF-ELDIEN FOR NEW DATA BASE STRUCTURE
C --- REVISED  4-18-88 BY O. SHARAF-ELDIEN FOR SUBNETWORK MOE'S
C --- REVISED  4-16-90 BY B. ANDREWS TO ADD COMMONS FOR GRAPHICS
C --- REVISED  6-15-90 BY A. KANAAN TO ADD BUSLNK ARRAY
C --- REVISED  7-03-91 BY A. KANAAN FOR NEW INTERFACE DATA BASE
C --- REVISED 11-15-91 BY J. WERK TO INCLUDE TRACING VARIABLES           
C --- REVISED 11-30-92 BY S.E.SMITH TO ADD WARNING MESSAGE COUNTER
C --- REVISED  5-25-93 BY A. PHLEGAR FOR ERROR MESSAGE ARRAY & OD OUTPUT
C --- REVISED  8-18-94 BY S. WALKER TO CHANGE MAXNTF TO MAXINT
C --- REVISED  9-07-94 BY S. WALKER TO REMOVE RESETTING OF YTRACE
C --- REVISED 12-01-97 BY K. SHERIDAN FOR AIR QUALITY MODELING
C
C --- TITLE - INITIALIZE ALL NECESSARY GLOBAL, SYSTEM SPECIFICATION
C ---         AND CARD PROCESSING ITEMS - MODULE 2.1.1
C
C --- FUNCTION - INITIALIZE CENTRAL DATA BASE ITEMS
C
C --- ARGUMENTS - NONE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     THIS ROUTINE INITIALIZES MISCELLANEOUS GLOBAL ITEMS.  IT IS CALLED
C     ONCE PER CASE.
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                    INTRNC - MODULE 2.1
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                               NONE
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ---------------------
C                    --------------------------
C
C     ANODE   HIGHEST INTERNAL NODE NUMBER SPECIFIED BY USER
C     BUSLDR  PERCENTAGE OF MEAN HEADWAY APPLIED TO A BUS VEHICLE
C     BUSLNK  BUS PATH ARRAY - CONTAINS SUBNETWORK TYPE, LINK NO. & BUS ROUTE
C     CNTINT  NUMBER OF TIME INTERVALS UNTIL NEXT INTERMEDIATE OUTPUT
C     ELAPST  ARRAY OF ELAPSED TIMES TO START OF INTERMEDIATE
C             OUTPUT, MINUTES
C     ERMSG   ARRAY CONTAINING FLAGS FOR EVERY ERROR MESSAGE ENCOUNTERED
C     ERRCT   INPUT ERROR COUNTER
C     FILDUR  DURATION OF FILL TIME
C     GLOBND  GLOBAL NODE SPECIFIC ARRAY - SUBNETWORK NODE AND TYPE
C     GTRKCP  GLOBAL LINK SPECIFIC ARRAY - PACKED TRUCK AND CAR POOL
C             PERCENTS FOR ENTRY LINKS (ZERO FOR NON-ENTRY LINKS)
C     I       DO-LOOP INDEX
C     INTVEH  MAX ALLOWABLE NO OF VEH ENTERING INTERFACE NODE PER SEC.
C     J       DO LOOP INDEX
C     LENINT  LENGTH OF A TIME INTERVAL, SECONDS
C     MAXGLK  MAXIMUM ALLOWABLE NUMBER OF GLOBAL LINKS
C     MAXSPT  MAXIMUM ALLOWABLE NUMBER OF INTERFACE ARRAYS
C     MAXSUB  MAXIMUM ALLOWABLE NUMBER OF SUB-NETWORK TYPES
C     MSGCT   INPUT WARNING MESSAGE COUNTER
C     MXBSLK  MAXIMUM NUMBER OF LINKS LOADED IN BUSLNK ARRAY
C     NEXTP   CODE (0,1) IF ANOTHER TP (DOES NOT,DOES) FOLLOW CURRENT TP
C     NEXTRN  NEXT CASE CODE (0,1) IS ANOTHER CASE (DOESNT,DOES) FOLLOW
C     NMAX    MAXIMUM ALLOWABLE INTERNAL NODE NUMBER (USER NODE NUMBER)
C     OUTFRQ  ARRAY OF FREQUENCIES OF INTERMEDIATE OUTPUT, SEC.
C     OUTSPN  ARRAY OF SPANS OF INTERMEDIATE OUTPUT, MINUTES
C     PUTSTD  NUMBER OF TIME INTVLS BETWEEN SUCCESSIVE STANDARD OUTPUTS
C     SCNTER  NO. OF TIME INTERVALS BETWEEN SERVICE RATES COMPUTATION
C     SECHWY  HEADWAY SURCHARGE FOR 2ND VEHICLE IN QUEUE.
C     SIGTRN  CODE (1,2,3) FOR (IMMEDIATE,2-CYCLE,3-CYCLE) TRANSITION
C     THRHWY  HEADWAY SURCHARGE FOR 3RD VEHICLE IN QUEUE.
C     TRKLDR  PERCENTAGE OF MEAN HEADWAY APPLIED TO A TRUCK VEHICLE
C     TRYLER  PCT OF MEAN HDWY APPLIED TO VEHS TRAILING A BUS OR TRUCK
C     TTLSUB  TOTAL NUMBER OF SUBNETWORKS BEING SIMULATED.
C     UNITIN  NETSIM CODE (0,1) IF (ENGLISH,METRIC) UNITS INPUT
C     UNITOT  NETSIM CODE (0,1,2,3) IF (SAME AS INPUT,ENGLISH,METRIC,
C             BOTH) UNITS TO BE OUTPUT
C     WODOUT  FLAG (T, F) IF OD OUTPUT (IS, IS NOT) REQUESTED
C     WTPSOD  FLAG (T, F) IF TIME PERIOD OD OUTPUT (IS, IS NOT) REQUESTED
C     XC7000  INTERFACE NODE ARRAY - X (FT) AND Y (FT) COORDINATES
C     XC8000  ENTRY NODE ARRAY - X (FT) AND Y (FT) COORDINATES
C     XGCOOR  NODE SPECIFIC ARRAY - X (FT) AND Y (FT) COORDINATES
C     XNODE   NODE NUMBER SELECTED FOR AIR QUALITY MODELING
C     XPHSCD  CODES TO UNPACK PHASE CODE FOR A TURN MOVEMENT
C     XSPINT  PERCENT SPILLBACK FACTORS AT SUBNETWORK INTERFACES
C     XVETRP  CUMULATIVE NUMBER OF VEHICLE TRIPS COMPLETED THRU THE NTWK
C     YRTALG  REAL TIME ALGORITHM FLAG (.TRUE. IF ALGORITHM TO BE USED)
C     YSUB    SUBNETWORK EXISTENCE FLAGS (.T. IF INPUTS HAVE BEEN READ)
C     ZMILE   SUBNETWORK SPEC.ARRAY - SUM OF VEHICLE MILES
C     ZMOVE   SUBNETWORK SPEC.ARRAY - SUM OF (FREE FLOW) VEHICLE-HOURS
C     ZTIME   SUBNETWORK SPEC.ARRAY - SUM OF VEHICLE HOURS
C
C ---------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'GLOBAL.INC'
C
C ------ ERRCT AND MSGCT WERE MOVED BACK TO TRAF AK 5/25/93
C
      ANODE  = 1
      BUSLDR = 120
      NEXTRN = 0
      CNTINT = 0
      FILDUR = 0
      LENINT = 0
      MXBSLK = 0
      NEXTP  = 0
      PUTSTD = 0
      SCNTER = 3
      SECHWY = 5
      SIGTRN = 0
      THRHWY = 2
      TRKLDR = 120
      TRYLER = 150
      TTLSUB = 0
      UNITIN = 0
      UNITOT = 0
      WODOUT = .FALSE.
      WTPSOD = .FALSE.
      XVETRP = 0
      YRTALG = .FALSE.
      XNODE  = 0
C
      DO 20 I = 1, NMAX
         GLOBND(I) = 0
         XGCOOR(I) = -9999
         XGCOOR(NMAX + I) = -9999
20    CONTINUE
C
      DO 30 I = 1, MAXSUB
         YSUB (I) = .FALSE.
         ZMILE(I) = 0.
         ZMOVE(I) = 0.
         ZTIME(I) = 0.
   30 CONTINUE
C
      DO 40 I = 1, MAXGLK
         GTRKCP(I) = 0
40    CONTINUE
C
      DO 45 I = 1, MAXMAN
         BUSLNK(I) = 0
45    CONTINUE
C
      XPHSCD(1) = 1
      XPHSCD(2) = 2**5
      XPHSCD(3) = 2**10
      XPHSCD(4) = 2**15
      XPHSCD(5) = 2**20
      XPHSCD(6) = 2**25
C
      DO 50 I = 1, MAXSPT
         XSPINT(I) = 0
   50 CONTINUE
C
      DO 60 I = 1, MAXINT
         INTVEH(I) = 0
   60 CONTINUE
C
      DO 70 I = 1, 3
         ELAPST(I) = 0
         OUTFRQ(I) = 0
         OUTSPN(I) = 0
   70 CONTINUE
C
      DO 80 I = 1, 2000
         XC7000(I) = -9999
         XC8000(I) = -9999
   80 CONTINUE
C
      RETURN
      END
      SUBROUTINE INPTFN
C
C
C --- CODED    8-10-79 BY M. MASSUCCI
C --- REVISED  2-26-88 BY O. SHARAF-ELDIEN TO PROPERLY BRANCH ON ERROR
C --- REVISED 11-07-91 BY J. WERK TO ADD CARD TYPE 80, 81, 95, & 96      
C --- REVISED 10-06-92 BY A. PHLEGAR TO CHECK CARD 64
C --- REVISED  5-13-94 BY A. KANAAN TO MAKE CALLS CONDITIONAL         
C --- REVISED 12-29-97 BY M. YEDLIN FOR AIR QUALITY MODELING
C
C --- TITLE - GET NETSIM INPUTS FOR EACH CATEGORY, FIRST TIME PERIOD -
C ---         MODULE 2.2.6.1
C
C --- FUNCTION - THIS MODULE CONTROLS THE PROCESSING OF THE NETSIM
C ---            SUBNETWORK INPUT CARDS FOR THE FIRST TIME PERIOD.
C
C --- ARGUMENTS - NONE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     WHEN THIS ROUTINE IS CALLED IT IS ASSUMED THAT NETSIM INPUT
C     CARDS APPEAR IN THE INPUT STREAM. SUBROUTINES ARE CALLED TO
C     GET LINK, TURN OPERATIONS, SURVEILLANCE AND VOLUME DATA.
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                    PNETSM - MODULE 2.2.6
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                    INCENN - MODULE 2261.1
C                    LINKFN - MODULE 2261.2
C                    TURNFN - MODULE 2261.3
C                    LNKSQN - MODULE 2261.4
C                    CTRLFN - MODULE 2261.5
C                    DMNDFN - MODULE 2261.6
C                    GEMDAT - MODULE 2261.7
C                    RDFN60 - MODULE 2261.8
C                    RDN64
C                    RDN90  - MODULE 2261.10
C                    INTCFN - MODULE 2261.11                             
C                    GEOMFN - MODULE 2261.12                             
C                    RDN81  - MODULE 2261.13                             
C                    PRMAIR - MODULE 2261.14
C
C ---------------    GLOSSARY OF VARIABLE NAMES   ---------------------
C                    --------------------------
C
C     ERRCT   COUNT OF INPUT ERRORS
C
C ----------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'GLOBAL.INC'
C
      CALL INCENN
      CALL LINKFN
C
      IF (ERRCT .EQ. 0) THEN
          CALL LNKSQN
          CALL TURNFN
      ENDIF
      IF (ERRCT .EQ. 0) CALL CTRLFN
      IF (ERRCT .EQ. 0) CALL DMNDFN
      IF (ERRCT .EQ. 0) CALL RDFN60
      IF (ERRCT .EQ. 0) CALL RDN64
      IF (ERRCT .EQ. 0) CALL GEOMFN                                                        
      IF (ERRCT .EQ. 0) CALL RDN81          
      IF (ERRCT .EQ. 0) CALL PRMAIR                                               
      IF (ERRCT .EQ. 0) CALL RDN90
      IF (ERRCT .EQ. 0) CALL INTCFN                                                        
      IF (ERRCT .EQ. 0) CALL GEMDAT
C
      RETURN
      END
      SUBROUTINE QUEUE (I1)
C
C
C --- CODED   12-30-97 BY M. YEDLIN   
C
C --- TITLE - GET QUEUE AT START OF NEW PHASE - MODULE 3233.5
C
C --- FUNCTION - THIS ROUTINE COMPUTES AND STORES THE QUEUE BY LANE
C ---            ON EACH APPROACH TO THE NODE AT WHICH AIR QUALITY
C ---            DATA IS REQUESTED
C
C --- ARGUMENTS - I1    - NUMBER OF INTERVAL BEGINNING THIS TIME-STEP
C ---                     FROM CALLING ROUTINE  
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     THIS MODULE LOOPS OVER ALL APPROACHES TO THE NODE WHERE AIR  
C     QUALITY DATA IS REQUESTED.  THE QUEUE IN EACH LANE ON EACH 
C     APPROACH IS IDENTIFIED AND STORED IN ARRAY BEGQUE.
C
C --------------------  THIS ROUTINE CALLED BY  ------------------------
C                       ----------------------
C
C                    UPSIG  - MODULE 3.2.3.3
C
C ---------------------   THIS ROUTINE CALLS   -------------------------
C                         ------------------
C
C                               NONE
C
C ------------------   GLOSSARY OF VARIABLE NAMES  --------------------
C                      --------------------------
C
C     BEGQUE  CUM NO OF VEHS IN QUEUE AT START OF IPH, ON APPROACH, IAP
C             AND LANE ILN, DURING CURRENT 15 MINUTE PERIOD 
C     FOLOWR  VEHICLE SPECIFIC ARRAY - FOLLOWING VEHICLE NUMBER
C     FZINT   ARRAY THAT CONTAINS THE PHASE ASSOCIATED WITH EACH
C             INTERVAL
C     I       INDEX TO SIGI ARRAY
C     IAP     APPROACH NUMBER
C     IFV     NUMBER OF FOLLOWING VEHICLE
C     IL      LINK NUMBER
C     ILN     LANE NUMBER 
C     IMXLNE  NUMBER OF LANES ON LINK, IL
C     IN      INTERNAL NODE NUMBER
C     INTNEW  NEXT INTERVAL NUMBER
C     IPH     NUMBER OF PHASE WHICH BEGAN THIS TIME STEP
C     ISTAT   VEHICLE STATUS (MOVING, QUEUE, ETC)
C     IQUEUE  NUMBER OF VEHICLES IN QUEUE ON LANE, ILN, APPROACH, IAP
C     IV      VEHICLE NUMBER
C     K       INDEX TO LANEF ARRAY
C     LANEF   ARRAY OF NO. OF LEAD VEHICLE IN LANE
C     LKSTOP  VEHICLE SPECIFIC ARRAY - CODE WHETHER VEH STOPS ON LINK 
C     PHSCNT  PHASE SPECIFIC ARRAY - NO OF TIMES PHASE ACTIVATED DURING
C             CURRENT 15 MINUTE PERIOD
C     SIGI    ARRAY OF LINK NUMBERS WHICH ARE APPROACHES TO NODE, IN
C     VSTATE  VEHICLE SPECIFIC ARRAY - STATUS CODE
C     WQ      FLAG (T,F) IF VEHICLE IV (IS, IS NOT) IN QUEUE 
C     XNODE   NUMBER OF NODE WHERE AIR QUALITY DATA IS REQUESTED 
C
C ----------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'GLOBAL.INC'
      INCLUDE 'NETSIM.INC'
      INCLUDE 'AIRQUAL.INC'
C
      INTNEW = I1
C
C -----  GET NUMBER OF PHASE, IPH WHICH BEGAN THIS TIME STEP, AND
C -----  NUMBER OF NODE WHERE AIR QUALITY DATA IS REQUESTED. LOOP
C -----  OVER APPROACHES TO THIS NODE.
C      
      IPH = FZINT(INTNEW)
      IN = XNODE
      I = 5 * (IN - 1)
      IAP = 0
   10 CONTINUE
      I = I + 1
      IAP = IAP + 1
      IL = SIGI(I)
      IF (IL .GT. 0) THEN
C
C -----  APPROACH EXISTS. LOOP OVER LANES. FIND FIRST VEHICLE IN LANE 
C -----  AND LOOP OVER ALL FOLLOWING VEHICLES.  INCREMENT QUEUE COUNTER
C -----  IQUEUE FOR EACH VEHICLE IN QUEUE.
C
         IMXLNE = MOD (LANEGD(IL) / 2**3, 2**3) + MOD(LANEGD(IL) / 2**6,
     1                            2**2) + MOD (LANEGD(IL) / 2**8, 2**2)
         K = 7 * (IL - 1)
         DO 30 ILN = 1, IMXLNE
            K = K + 1
            IQUEUE = 0
            IF (LANEF(K) .GT. 0) THEN
               IFV = LANEF(K)
               WQ = .FALSE.                         
C
C -----  LOOP OVER ALL VEHICLES IN LANE, ILN, AND COUNT THOSE IN QUEUE
C
   20          CONTINUE
               IV = IFV
               ISTAT  = VSTATE(IV) 
               WQ = (ISTAT .NE. 4 .AND. ISTAT .GT. 0) .OR.
     1                     (WQ .AND. LKSTOP(IV) .GE. 1)
               IF (WQ) IQUEUE = IQUEUE + 1
               IFV = FOLOWR(IV)
               IF (IFV .GT. 0)                               GO TO 20
            ENDIF
C
C -----  ACCUMULATE QUEUE ON APPROACH, IAP, LANE, ILN AT START OF PHASE, 
C -----  IPH DURING THE CURRENT 15 MINUTE PERIOD.
C
            BEGQUE(IAP,ILN,IPH) = BEGQUE(IAP,ILN,IPH) + IQUEUE
   30    CONTINUE   
      ENDIF
      IF (SIGI(I+1) .GT. 0 .AND. IAP .LT. 5)                 GO TO 10
C
C -----  INCREMENT COUNT OF NUMBER OF TIMES PHASE, IPH BEGAN DURING THE
C -----  CURRENT 15 MINUTE PERIOD.
C
      PHSCNT(IPH) = PHSCNT(IPH) + 1
C
      RETURN
      END 
      SUBROUTINE LINKST (IV, IL, ITIME)
C
C --- CODED   11-29-79 BY M. BURNS
C --- REVISED  3-26-88 BY O. SHARAF-ELDIEN TO REMOVE REDUNDANT ARRAYS
C --- REVISED  4-30-88 BY O. SHARAF-ELDIEN TO FIX REF.TO CODES ARRAY
C --- REVISED 12-13-88 BY A. KANAAN TO REMOVE SPLIT OF ENTRTM & TRVLTM
C --- REVISED 12-09-90 BY H. CHEN TO COMPUTE MOV-SPEC. STAT UNCNDTNLY
C --- REVISED 11-05-93 BY A. PHLEGAR TO UPDATE LANE DISCHARGE ARRAY
C --- REVISED  3-08-94 BY S. WALKER TO UNPACK BUS ARRAYS
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK CODES,SPDLN AND VTYPE
C --- REVISED 10-11-94 BY A. PHLEGAR FOR TO RENAME STOP TO XSTOP
C --- REVISED 12-30-97 BY M. YEDLIN FOR AIR QUALITY MODELING
C
C --- TITLE - UPDATE LINK STATISTICS FOR DISCHARGING VEHICLE
C ---          - MODULE 3232.3.6
C
C --- FUNCTION - THIS MODULE UPDATES THE LINK STATISTICS FOR THE
C ---            LINK THE SUBJECT VEHICLE IS DISCHARGING FROM.
C
C --- ARGUMENTS - IV     = VEHICLE DISCHARGING FROM LINK, FROM CALLING
C ---                      ROUTINE
C ---             IL     = LINK NUMBER, FROM CALLING ROUTINE
C ---             ITIME  = TIME USED TO DISCHARGE VEHICLE, FROM
C ---                      CALLING ROUTINE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     THIS MODULE UPDATES THE LINK SPECIFIC DATA FOR LINK, IL, WHICH
C     VEHCILE, IV, IS DISCHARGING FROM. THE LINKAGE IS UPDATED TO
C     REMOVE THE DISCHARGING VEHICLE FROM THIS LINK.
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                    GOQ    - MODULE 3232.3
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                               NONE
C
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------
C                    -------------------------
C
C     BSTIME  LINK SPECIFIC ARRAY - TOTAL TRAVEL TIME ON LINK FOR BUS,
C             SEC * 10
C     BUSES   BUS SPECIFIC ARRAY - TOTAL NO. BUSES TRAVERSING THIS LINK
C     BUSRT   BUS SPECIFIC ARRAY - BUS ROUTE NUMBER
C     CLOCK   ELAPSED TIME SINCE BEGINNING OF SIMULATION, SEC
C     CNTENT  LINK SPECIFIC ARRAY - NO. OF VEHICLES CURRENTLY ON LINK
C     CUMDIG  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA DIAG MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IPH ACTIVE
C     CUMLFT  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA LEFT MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IPH ACTIVE
C     CUMRIT  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA RITE MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IPH ACTIVE
C     CUMTHR  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA THRU MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IPH ACTIVE
C     CUMVEH  LINK SPECIFIC ARRAY - NO. OF VEHICLES DISCHARGED FROM
C             LINK SINCE BEGINNING OF SIMULATION
C     CUMVL   LINK SPECIFIC ARRAY - COUNT OF LEFT TURN DSCHG VEHS.
C     CUMVR   LINK SPECIFIC ARRAY - COUNT OF RIGHT TURN DSCHG VEHS.
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER
C     ENTRTM  VEHICLE SPECIFIC ARRAY - TIME VEH. ENTERED CURRENT LINK,
C             SEC * 10
C     FOLOWR  VEHICLE SPECIFIC ARRAY - VEHICLE BEHIND SUBJECT VEHICLE
C     FZINT   ARRAY THAT CONTAINS THE PHASE ASSOCIATED WITH EACH
C             INTERVAL
C     I       INDEX TO SIGI ARRAY
C     IAP     APPROACH NUMBER
C     IB      BUS VEHICLE NUMBER
C     IBR     BUS ROUTE NUMBER
C     IFV     VEHICLE FOLLOWING SUBJECT VEHICLE
C     IN      INTERNAL NODE NUMBER
C     INTRVL  CURRENTLY ACTIVE INTERVAL
C     IPH     NUMBER OF CURRENTLY ACTIVE PHASE
C     ITURN   TURN CODE (0,1,2,3,4) FOR (LT,TH,RT,LD,RD) MOVEMENTS
C     ITYP    VEHICLE TYPE CODE + 1
C     JL      INDEX TO LANE DISCHARGE ARRAY
C     JTIME   TRAVEL TIME OF VEHICLE, IV, ON LINK, IL, SEC * 10
C     K       INDEX TO LANEV AND LANEF ARRAYS
C     KTIME   TRAVEL TIME OF VEHICLE, IV, ON LINK, IL, (SECONDS)
C     LANE    LANE NUMBER OCCUPIED BY VEHICLE
C     LANEF   LINK SPECIFIC ARRAY - FIRST VEHICLE IN LANE
C     LANEV   LINK SPECIFIC ARRAY - LAST VEHICLE IN LANE
C     LEADER  VEHICLE SPECIFIC ARRAY - VEH. IN FRONT OF THIS VEHICLE
C     LKSTOP  VEHICLE SPECIFIC ARRAY - CODE WHETHER VEH STOPS ON LINK
C     LNDCH   LANE SPECIFIC ARRAY - CUMULATIVE NUMBER OF VEH. DISCHARGED
C             FROM LANE
C     NACT    ARRAY OF CODE IDENTIFYING CONTROL AT EACH NODE
C     NBUSIV  VEHICLE SPECIFIC ARRAY - BUS NUMBER                         
C     NVHTYP  VEHICLE TYPE ARRAY - VEHICLE TYPE CODE, 1-16 
C     NLANE   VEHICLE SPECIFIC ARRAY - LANE OCCUPIED 
C     XSTOP   LINK SPECIFIC ARRAY - NUMBER OF VEHICLES FORCED TO STOP
C             AT LEAST ONCE
C     SIGI    ARRAY OF LINK NUMBERS WHICH ARE APPROACHES TO NODE, IN
C     SIGT    ARRAY CONTAINING CURRENT INTERVAL AND ELAPSED TIME
C     STOPL   LINK SPECIFIC ARRAY - NO. OF LEFT TURN VEH FORCED TO STOP
C     STOPR   LINK SPECIFIC ARRAY - NO. OF RIGHT TURN VEH FORCED TO STOP
C     TCODE   VEHICLE SPECIFIC ARRAY - TURN CODE
C     TRVLL   LINK SPECIFIC ARRAY - TTL LEFT TURN VEH TRVL TIME, SEC
C     TRVLR   LINK SPECIFIC ARRAY - TTL RIGHT TURN TRVL TIME, SEC
C     TRVLTM  LINK SPECIFIC ARRAY - TOTAL TRAVEL TIME OF ALL VEHICLES
C             TRAVERSING LINK, SEC
C     TTLILK  TOTAL NUMBER OF INTERMAL LINKS IN SUBNETWORK
C     VTYPLD  VEHICLE TYPE ARRAY - PERSON OCCUPANCY * 100
C     XBSTRV  BUS ROUTE SPECIFIC ARRAY - TOTAL TRAVEL TIME OF BUSES ON
C             ROUTE, SECS
C     XNODE   NUMBER OF NODE WHERE AIR QUALITY DATA IS REQUESTED 
C     XPERS   LINK SPECIFIC ARRAY - CUM. PERSON TRIPS * 100
C     YINIT   FLAG (T,F) IF INITIALIZATION (IS, IS NOT) UNDERWAY
C
C ---------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'GLOBAL.INC'
      INCLUDE 'NETSIM.INC'
      INCLUDE 'AIRQUAL.INC'
C
C -----  UPDATE VEHICLE CHAIN TO REFLECT DISCHARGE.
C
      IFV = FOLOWR(IV)
      K = 7 * (IL - 1) + NLANE(IV) 
      IF (IFV .NE. 0) LEADER(IFV) = 0
      IF (IFV .EQ. 0) THEN
          LANEV(K) = 0
          DSCSPD(K) = 0
      ENDIF
      LANEF(K) = IFV
C
C -----  UPDATE LINK SPECIFIC ARRAYS TO SHOW DISCHARGING OF VEHICLE.
C -----  INCREMENT STOP COUNTER IF STOP CODE IS SET.
C
      ITURN = TCODE(IV)
      IF (ITURN .EQ. 0) CUMVL(IL) = CUMVL(IL) + 1
      IF (ITURN .EQ. 2) CUMVR(IL) = CUMVR(IL) + 1
      CUMVEH(IL) = CUMVEH(IL) + 1
      IF (NBUSIV(IV) .GT. 0) BUSES(IL) = BUSES(IL) + 1
C
C -----  IF LINK, IL IS AN APPROACH TO A NODE WHERE AIR QUALITY DATA
C -----  IS REQUESTED, INCREMENT MOVEMENT SPECIFIC COUNTERS OF
C -----  VEHICLES DISCHARGED FROM THIS APPROACH DURING THIS PHASE.
C
      IF (.NOT. YINIT .AND. XNODE .GT. 0 .AND. DWNOD(IL) .EQ. XNODE)THEN       
         IN = XNODE
         IF (NACT(IN) .EQ. 0) THEN
            INTRVL = MOD (SIGT(IN), 2**4)
            IPH = FZINT(INTRVL)
            I = 5 * (IN - 1)
            IAP = 0
    5       CONTINUE
            I = I + 1
            IAP = IAP + 1
            IF (SIGI(I) .EQ. IL) THEN
               IF (ITURN .EQ. 0) CUMLFT(IAP,IPH) = CUMLFT(IAP,IPH) + 1
               IF (ITURN .EQ. 1) CUMTHR(IAP,IPH) = CUMTHR(IAP,IPH) + 1
               IF (ITURN .EQ. 2) CUMRIT(IAP,IPH) = CUMRIT(IAP,IPH) + 1
               IF (ITURN .GE. 3) CUMDIG(IAP,IPH) = CUMDIG(IAP,IPH) + 1
            ELSE
               IF (IAP .LT. 5)                               GO TO 5
            ENDIF
         ENDIF   
      ENDIF      
      IF (IL .GT. TTLILK)                                    GO TO 10
      ITYP = NVHTYP(IV) 
      XPERS(IL) = XPERS(IL) + VTYPLD(ITYP)
      CNTENT(IL) = MAX0(CNTENT(IL) - 1, 0)
      IF (LKSTOP(IV) .EQ. 1) THEN
         XSTOP(IL) = XSTOP(IL) + 1
         IF (ITURN .EQ. 0) STOPL(IL) = STOPL(IL) + 1
         IF (ITURN .EQ. 2) STOPR(IL) = STOPR(IL) + 1
      ENDIF
C
C -----  UPDATE LANE DISCHARGE ARRAY    
C
      LANE = NLANE(IV) 
      J = (IL-1)*7 + LANE
      LNDCH(J) = LNDCH(J) + 1
C
C -----  CALCULATE LINK TRAVEL TIME FOR THIS VEHICLE ON
C -----  THIS LINK AND ADD TO CUMULATIVE LINK TRAVEL TIME.
C
      JTIME = CLOCK * 10 - ENTRTM(IV)
      JTIME = JTIME + ITIME
      JTIME = MAX0 (JTIME, 10)
      TRVLTM(IL) = TRVLTM(IL) + (JTIME + 5) / 10
      KTIME = (JTIME + 5) / 10
      IF (ITURN .EQ. 0) TRVLL(IL) = TRVLL(IL) + KTIME
      IF (ITURN .EQ. 2) TRVLR(IL) = TRVLR(IL) + KTIME
C
C -----  TRA IF NOT A BUS. ELSE, INCREMENT BUS COUNTER AND POINTER
C -----  TO MANUVR ARRAY REFLECTING ITS DISCHARGE FROM LINK, IL.
C -----  ADD LINK TRAVEL TIME TO CUMULATIVE BUS TRAVEL TIME.
C
      IF (NBUSIV(IV) .EQ. 0)                                 GO TO 10
      BSTIME(IL) = BSTIME(IL) + JTIME
      IB = NBUSIV(IV) 
      IBR = BUSRT(IB)
      XBSTRV(IBR) = XBSTRV(IBR) + (JTIME + 5) / 10
   10 CONTINUE
C
      RETURN
      END
      SUBROUTINE UPSIG
C
C
C --- CODED   10-04-79 BY E. LIEBERMAN
C --- REVISED 10-22-79 BY M. DAVILA
C --- REVISED  6-02-86 BY A. HALATI FOR NETSIM ACTUATED LOGIC
C --- REVISED  5-10-87 BY A. RATHI FOR GRAPHICAL DISPLAY
C --- REVISED  7-08-87 BY M. YEDLIN TO MINIMIZE SIZE OF LU45 WHEN
C ---                               NO ACTUATED CONTROLLERS EXIST
C --- REVISED 10-15-87 BY K. SHERIDAN (FOR NETSIM SIGNAL TRANSITION)
C --- REVISED  1-05-88 BY O. SHARAF-ELDIEN FOR FIXED-RECORDS (80 BYTES)
C ---                        FOR GRAPHIC FILES
C --- REVISED 10-17-91 BY A. KANAAN TO REMOVE SIGNAL TRANSITION LOGIC
C --- REVISED  2-13-95 BY S. WALKER TO PREVENT OVERFLOW IN SIGT
C --- REVISED  5-01-97 BY R. GOLDBLATT TO ADD NCSU PEDESTRIAN LOGIC
C --- REVISED 12-29-97 BY M. YEDLIN FOR AIR QUALITY MODELING
C
C --- TITLE - UPDATE CONTROLS ON NETSIM SUBNETWORK - MODULE 3.2.3.3
C
C --- FUNCTION - THIS ROUTINE UPDATES THE INTERVAL TIMER AND, IF
C ---            NECESSARY, THE NEXT ACTIVE INTERVAL AT ALL NODES
C ---
C
C --- ARGUMENTS - NONE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     THIS MODULE LOOPS OVER ALL NODES, IN. IF AN ACTUATED CONTROLLER
C     IS SPECIFIED, THE CURRENT ACTIVE PHASE(S) AND ELAPSED TIME(S)
C     ARE UPDATED. FOR ALL FIXED-TIME CONTROLLERS, THE TIMER FOR
C     THE ACTIVE INTERVAL IS INCREMENTED.  IF THE NEXT INTERVAL IS TO
C     BE ACTIVATED, IT IS IDENTIFIED AND MODULE 3233.1 IS CALLED TO
C     STORE THE NEW LINK-SPECIFIC SIGNAL INDICATIONS. IF GRAPHICS
C     OUTPUT IS DESIRED, MODULE 3233.3 IS CALLED TO STORE THE DESIRED
C     INFORMATION INTO A BUFFER AND THEN TRANSFER IT TO A PERIPHERAL
C     UNIT.
C
C --------------------  THIS ROUTINE CALLED BY  ------------------------
C                       ----------------------
C
C                    NETSIM - MODULE 3.2.3
C
C ---------------------   THIS ROUTINE CALLS   -------------------------
C                         ------------------
C
C                    LNKSIG - MODULE 3233.1
C                    UPACT  - MODULE 3233.2
C                    ACTDAT - MODULE 3233.3
C                    TRNSTN - MODULE 3233.4
C                    QUEUE  - MODULE 3233.5
C
C ------------------   GLOSSARY OF VARIABLE NAMES  --------------------
C                      --------------------------
C
C     ACN     COUNT OF ACTUATED CONTROLLERS SPECIFIED
C     ACTFZ   BIT ORIENTED WORD - ACTIVE PHASES
C     ACTRAM  EMULATION OF MOTOROLA 6800 RAM MEMORY
C     CLOCK   ELAPSED SIMULATED TIME (SEC) AT START OF TIME-STEP
C     DATBUF  ARRAY OF GRAPHICS DATA FOR ACTUATED CONTROLLERS
C     DURINT  INTERVAL SPECIFIC ARRAY - INTERVAL DURATION, REF. OFFSET
C     DURPHS  PHASE SPECIFIC ARRAY - NO. OF SEC PHASE ACTIVE THIS 15 MIN  
C     FZINT   ARRAY THAT CONTAINS THE PHASE ASSOCIATED WITH EACH
C             INTERVAL
C     FZPNTR  NODE SPECIFIC ARRAY - POINTER TO DURINT ARRAY
C     I       INDEX TO DATBUF ARRAY
C     IAC     SUBNETWORK ACTUATED NODE NUMBER
C     ICLOCK  ELAPSED SIMULATED TIME (SEC) AT END OF TIME-STEP
C     IDT     DO-LOOP INDEX - SUBNETWORK DETECTOR NUMBER
C     IDTIME  DETECTOR ARRAY - BEGINNING TIME OF ACTUATION
C     IFAZE1  RING A ACTIVE PHASE NUMBER
C     IFAZE2  RING B ACTIVE PHASE NUMBER
C     IL      LINK NUMBER
C     IN      INTERNAL NODE NUMBER
C     INDEX   INDEX TO DATBUF ARRAY
C     INRAM   DATA POSITION INDEX IN ACTRAM ARRAY FOR ACTUATED NODE
C     INTNEW  NEXT INTERVAL NUMBER
C     INTRVL  CURRENTLY ACTIVE INTERVAL
C     IP      POINTER TO FIRST INTERVAL, AT NODE IN, IN DURINT ARRAY
C     IREF    SIGNAL REFERENCE OFFSET
C     IRINGA  PACKED WORD OF BIT CODES (0,1) IF RINGA PHASE
C             (IS NOT, IS) ACTIVE (PHASE = BIT)
C     IRINGB  PACKED WORD OF BIT CODES (0,1) IF RINGB PHASE
C             (IS NOT, IS) ACTIVE (PHASE -4 = BIT)
C     J       INDEX TO DURINT ARRAY
C     LASTD   DETECTOR ARRAY - END TIME OF ACTUATION
C     LU45    PERIPHERAL UNIT NUMBER 45
C     LU6     PERIPHERAL UNIT NUMBER 6
C     MXDET   MAXIMUM ALLOWABLE NUMBER OF DETECTORS
C     NACT    ARRAY OF CODE IDENTIFYING CONTROL AT EACH NODE
C     NMAP    ARRAY OF SPECIFIED NODE NUMBERS
C     PCONF   LINK SPECIFIC ARRAY - BASE CONFLICT ZONE PEDESTRIAN 
C             OCCUPANCY (PCT.) CROSSING LINK NEAR UPSTREAM INTERSECTION
C     PDURNT  INTERVAL SPECIFIC ARRAY - INTERVAL DURATION, REF OFFSET
C             DURING SIGNAL TRANSITION
C     PERMIT  BIT ORIENTED WORD - PERMITTED PHASES
C     PFZPNT  NODE SPECIFIC ARRY - POINTER TO PDURNT ARRAY
C     PNACT   NODE SPECIFIC ARRAY - TYPE OF CONTROL AT BEGIN OF SIGNAL
C             TRANSITION
C     PPINTL  LINK SPECIFIC ARRAY - SIGNAL INTERVAL AT UPSTREAM INTER-  
C             SECTION WHICH BEGINS WALK PHASE FOR PEDS CROSSING 
C             UPSTREAM END OF LINK
C     PWALK   LINK SPECIFIC ARRAY - DURATION OF WALK INTERVAL (SECS.)
C     PWCLK   LINK SPECIFIC ARRAY - ELAPSED TIME SINCE START OF WALK
C             INTERVAL (SECS.).  SET ZERO IF WALK INTERVAL NOT ACTIVE.
C     RAFZ    DO-LOOP INDEX FOR RING A PHASES
C     RBFZ    DO-LOOP INDEX FOR RING B PHASES
C     RFAZE   BIT ORIENTED WORD - RED PHASES
C     SIGT    ARRAY CONTAINING CURRENT INTERVAL AND ELAPSED TIME
C     SNPFRQ  TIME BETWEEN UPDATES OF SNAPSHOT FILE (SECS)
C     TTLND   TOTAL NUMBER OF INTERNAL NODES
C     TTLNK   TOTAL NUMBER OF LINKS
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER
C     W       FLAG SET .TRUE. IF INTERVAL DURATIONS REMAIN IN XSGTRN
C     WDET    FLAG (.T., .F.) IF AN ACTUATION IS REGISTERED
C     WNOW    FLAG (T,F) IF GRAPHICS DATA (IS, NOT) DUE TO BE WRITTEN
C     XNODE   NUMBER OF NODE WHERE AIR QUALITY DATA IS REQUESTED 
C     XSGTRN  NODE SPECIFIC ARRAY - COMPUTED MAIN STREET GREEN INTERVAL
C             DURATIONS DURING TRANSITION
C     XSIGT   ACTUATED CONTROLLER SPECIFIC ARRAY - PHASES ACTIVE AND
C             ELAPSED TIME
C     YGRAPH  FLAG (T,F) IF USER (DOES, DOESN'T) WANT GRAPHICS OUTPUT
C     YINIT   FLAG (T,F) IF INITIALIZATION (IS, IS NOT) UNDERWAY
C     YTRACE  FLAG (T,F) IF TRACING (IS, IS NOT) REQUIRED
C
C ----------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'GLOBAL.INC'
      INCLUDE 'NETSIM.INC'
      INCLUDE 'NETPEDS.INC'
      INCLUDE 'AIRQUAL.INC'
C
C -----  INITIALIZE INDEX TO DATBUF ARRAY. WHEN ACTUATED CONTROLLERS
C -----  EXIST, DETERMINE IF GRAPHICS DATA IS DUE TO BE WRITTEN TO UNIT
C -----  45 NOW.
C
      INDEX = 1
      ICLOCK = CLOCK + 1
      WNOW = YGRAPH .AND. .NOT. YINIT .AND. 
     1       ((ICLOCK / SNPFRQ) * SNPFRQ .EQ. ICLOCK) .AND. ACN .GT. 0
C
C -----  DOUNTIL ALL NETWORK NODES ARE SCANNED. WRITE MESSAGE AND COUNT
C -----  FOR AN ACTUATED CONTROLLER.
C
      DO 30 IN = 1, TTLND
         IF (NACT (IN) .GT. 0) THEN
             DATBUF(1) = 0
             CALL UPACT (IN)
             CALL LNKSIG (IN, 0)
C
C -----  GET THE ACTIVE PHASES.
C
             IAC = NACT (IN)
             INRAM = (IAC - 1) * 751
             IFAZE1 = 0
             IFAZE2 = 0
             RFAZE = ACTRAM (INRAM + 164)
             PERMIT = ACTRAM (INRAM + 496)
             ACTFZ = 255 - RFAZE
             ACTFZ = IAND (PERMIT, ACTFZ)
C
C -----  OBTAIN THE PHASE NUMBERS.
C
             IRINGA = IAND (ACTFZ, 15)
             IF (IRINGA .GT. 0) THEN
                 DO 15 RAFZ = 1, 4
                    IF (MOD (IRINGA, 2) .GT. 0) THEN
                        IFAZE1 = RAFZ
                                                            GO TO 16
                    ELSE
                        IRINGA = IRINGA / 2
                    ENDIF
   15            CONTINUE
   16            CONTINUE
             ENDIF
             IRINGB = IAND (ACTFZ, 240)
             IRINGB = IRINGB / 16
             IF (IRINGB .GT. 0) THEN
                 DO 17 RBFZ = 5, 8
                    IF (MOD (IRINGB, 2) .GT. 0) THEN
                        IFAZE2 = RBFZ
                                                            GO TO 18
                    ELSE
                        IRINGB = IRINGB / 2
                    ENDIF
   17            CONTINUE
   18            CONTINUE
             ENDIF
C
C -----  UPDATE XSIGT
C
              IF (MOD (XSIGT(IAC), 2**4)  .NE.  IFAZE1) THEN
                  XSIGT(IAC) = XSIGT(IAC) / 2**12 * 2**12 + IFAZE1
              ELSE
                  IF (IFAZE1 .NE. 0) XSIGT(IAC) = XSIGT(IAC) + 16
              ENDIF
              IF (MOD (XSIGT(IAC) / 2**12, 2**4) .NE. IFAZE2) THEN
                  XSIGT(IAC) = XSIGT(IAC) + (IFAZE2 -
     1                         MOD (XSIGT(IAC) / 2**12, 2**12)) * 2**12
              ELSE
                  IF (IFAZE2 .NE. 0) XSIGT(IAC) = XSIGT(IAC) + 65536
              ENDIF
C
C -----  CALL MODULE 3233.3 IF GRAPHICS OUTPUT SHOULD BE WRITTEN NOW.
C
               IF (WNOW) CALL ACTDAT (IN, INDEX)
         ENDIF
C
C -----  PROCESS IF CONTROL IS A FIXED-TIME SIGNAL.  INCREMENT
C -----  INTERVAL ACTIVE TIME IN SIGT.  CHECK IF INTERVAL HAS
C -----  JUST ENDED.  IF SO, SET SIGT TO NEXT INTERVAL (INTERVAL
C -----  NUMBER 1 IF START OF CYCLE).
C
         INTRVL = 1
         INTNEW = 0
         IF (NACT(IN) .EQ. 0) THEN
             INTRVL = MOD (SIGT(IN), 2**4)
             J = MOD (FZPNTR(IN), 2**11) + INTRVL - 1
C
C -----  WHEN AIR QUALITY DATA IS REQUESTED, GET PHASE ACTIVE AT NODE,
C -----  XNODE AND INCREMENT COUNT OF SECONDS PHASE HAS BEEN ACTIVE.
C
             IF (.NOT. YINIT .AND. XNODE .EQ. IN) THEN
                IPH = FZINT(INTRVL)
                DURPHS(IPH) = DURPHS(IPH) + 1
             ENDIF      
             IF (MOD(SIGT(IN)/2**4,2**8) .LT. 2**8 - 1) 
     1           SIGT(IN) = SIGT(IN) + 1 * 2**4
             IF (MOD(SIGT(IN)/2**4, 2**8) .EQ. MOD(DURINT(J),2**7)) THEN
                 INTNEW = INTRVL + 1
                 IF (INTNEW .GT. MOD(FZPNTR(IN)/2**11, 2**4)) INTNEW = 1
                 SIGT(IN) = INTNEW + 2**12 * MOD(SIGT(IN) / 2**12,2)
C
C -----  NEW INTERVAL WAS BEGUN.  IF THIS NEW INTERVAL STARTS A NEW 
C -----  PHASE AT NODE WHERE AIR QUALITY DATA IS REQUESTED, CALL MODULE
C -----  TO IDENTIFY AND STORE QUEUE DATA BY APPROACH AND LANE.
C
                 IF (.NOT. YINIT .AND. XNODE .EQ. IN) THEN
                    IF (IPH .NE. FZINT(INTNEW)) CALL QUEUE (INTNEW)
                 ENDIF   
             ENDIF
         ENDIF
C
C -----  UPDATE PEDESTRIAN CLOCKS ON ALL LINKS DEPARTING NODE, IN
C
         DO 20 IL = 1, TTLNK
            IF (UPNOD(IL) .EQ. IN) THEN
               IF (PCONF(IL) .GT. 0) THEN
                  IF (PWCLK(IL) .EQ. 0) THEN
                     IF (INTNEW .EQ. PPINTL(IL)) PWCLK(IL) = 1
                  ELSE
                     PWCLK(IL) = PWCLK(IL) + 1
                     IF (PWCLK(IL) .GT. PWALK(IL)) PWCLK(IL) = 0
                  ENDIF
               ENDIF
            ENDIF      
   20    CONTINUE
C
C -----  PRIME LINK SPECIFIC CODES IN SDCODE ARRAY IF A NEW INTERVAL
C -----  HAS BEGUN FOR A FIXED TIME CONTROLLER.
C
         IF (INTNEW .GT. 0) CALL LNKSIG (IN, INTNEW)
C
   30 CONTINUE
C
C -----  IF GRAPHICS OUTPUT IS DESIRED, WRITE CONTENTS OF DATBUF
C -----  CONTAINING 1 SEC OF DATA FOR ALL ACTUATED CONTROLLERS
C -----  ONTO UNIT 45. WHEN NO ACTUATED CONTROLLERS SPECIFIED,
C -----  WRITE ON UNIT 45 ONLY ONCE FOR ENTIRE RUN.
C
      IF ((ACN.EQ.0 .AND. .NOT.YINIT .AND. ICLOCK.EQ.SNPFRQ .AND.YGRAPH)
     1    .OR. WNOW)  THEN
          INDEX = MAX0 (INDEX, 2)
          WRITE (LU45, 100) INDEX - 1
          WRITE (LU45, 100) (DATBUF(I), I = 2, INDEX)
      ENDIF
C
C -----  INITIALIZE THE DETECTOR ATTRIBUTES
C
      DO 40 IDT = 1, MXDET
         WDET(IDT) = .FALSE.
         IDTIME(IDT) = 0
         LASTD(IDT) = 0
   40 CONTINUE
C
      RETURN
  100 FORMAT (13I6)
 1100 FORMAT (' UPSIG:CLOCK,IN,PNACT(IN)', 3I6)
      END
      SUBROUTINE WRTAIR 
C                                                                                     
C                                                                                     
C --- CODED   12-30-97 BY M. YEDLIN                                                
C                                                                                     
C --- TITLE -  OUTPUT AIR QUALITY DATA ON UNIT 92                        
C ---          MODULE 3.2.3.11
C                                                                                     
C --- FUNCTION -  OUTPUT CELL DATA, QUEUE AND DISCHARGE DATA 
C ---             REQUIRED FOR AIR QUALITY MODELING.
C ---                                                                          
C                                                                                     
C --- ARGUMENTS - NONE
C                                                                                     
C -------------------------   DESCRIPTION   ---------------------------               
C                             -----------                                             
C                                                                         
C     THIS SUBROUTINE OUTPUTS DATA REQUIRED FOR AIR QUALITY MODELING
C     INCLUDING VEH-SEC OF TRAVEL IN EACH 10M CELL BY (LANE,LINK,PHASE,
C     SPEED AND ACCELERATION), VEHICLE MILES OF TRAVEL BY APPROACH AND 
C     SPEED RANGE, VEHICLE MILES OF TRAVEL BY APPROACH AND VEHICLE TYPE,
C     AVG. NUMBER OF VEHICLES IN QUEUE AT THE START OF EACH SIGNAL PHASE
C     (BY LANE), AND AVERAGE NUMBER OF VEHS DISCHARGING EACH APPROACH (BY 
C     MOVEMENT) DURING EACH SIGNAL PHASE. 
C                                                            
C -------------------   THIS ROUTINE CALLED BY   ----------------------               
C                       ----------------------                                        
C                                                                                     
C                    NETSIM - MODULE 3.2.3                                                                 
C                                                                                     
C ---------------------   THIS ROUTINE CALLS   ------------------------               
C                         ------------------                                          
C                                            
C                    TRFOPN  -
C                                                                                     
C ---------------    GLOSSARY OF VARIABLE NAMES   ---------------------               
C                    --------------------------                                       
C        
C     BEGQUE  CUM NO OF VEHS IN QUEUE AT START OF IFZ, ON APPROACH, IAP
C             AND LANE ILN, DURING CURRENT 15 MINUTE PERIOD 
C     CLOCK   ELAPSED TIME SINCE START OF SIMULATION, SECS.
C     CUMDIG  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA DIAG MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IFZ ACTIVE
C     CUMLFT  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA LEFT MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IFZ ACTIVE
C     CUMRIT  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA RITE MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IFZ ACTIVE
C     CUMTHR  CUM NO. OF VEHICLES DISCHARGING APPROACH VIA THRU MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IFZ ACTIVE
C     DAIRBL  ARRAY CONTAINING THE BLOCK NUMBER IN WHICH THIS VEHICLE
C             HAS TRAVELLED DURING (PART OF) THIS TIME STEP
C     DAIRLN  ARRAY CONTAINING LANE AND ACTIVE SIGNAL PHASE FOR THIS
C             BLOCK AND APPROACH.  NEGATIVE IF VEHICLE DISCHARGED
C     DAIRSA  ARRAY CONTAINING SPEED AND ACCEL. CELL NUMBERS, PACKED
C             FOR EACH APPROACH
C     DAIRTM  ARRAY CONTAINING TIME VEHICLE SPENT IN THIS BLOCK AND 
C             APPROACH, TO NEAREST 250TH OF A SECOND WITHIN A ONE-
C             SECOND TIME-STEP
C     DURINT  INTERVAL SPECIFIC ARRAY - INTERVAL DURATION, REF. OFFSET
C     DURPHS  PHASE SPECIFIC ARRAY - NO. OF SEC PHASE ACTIVE THIS 15 MIN  
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER
C     FZINT   ARRAY THAT CONTAINS THE PHASE ASSOCIATED WITH EACH
C             INTERVAL
C     FZPNTR  POINTER TO DURINT ARRAY                     
C     I2PHASE DURATION OF PHASE, IFZ * 2                   
C     IA      APPROACH NUMBER
C     IBL     BLOCK NUMBER 
C     ID      USER SPECIFIED DOWNSTREAM NODE NUMBER
C     IDUR    ARRAY OF PHASE DURATIONS
C     IFZ     PHASE NUMBER 
C     IL      LINK INDEX
C     ILN     LANE NUMBER 
C     IMXFZ   TOTAL NUMBER OF PHASES AT NODE, XNODE
C     IMXLNE  NUMBER OF LANES ON LINK, IL
C     IN      LOCAL VALUE OF XNODE
C     INBLK   NUMBER OF BLOCKS ALONG APPROACH, IA
C     INTMX   NUMBER OF INTERVALS  
C     INTRVL  SIGNAL INTERVAL NUMBER                                         
C     IP      POINTER TO FIRST INTERVAL, AT NODE IN, IN DURINT ARRAY
C     ITOTA   TOTAL NUMBER OF APPROACH AND DEPARTING LINKS FOR XNODE
C     ITPCNT  NUMBER OF 15 MINUTE PERIODS OF DATA THAT WILL BE WRITTEN 
C     IU      USER SPECIFIED UPSTREAM NODE NUMBER
C     J       INDEX TO DURINT ARRAY
C     JC      ACCELERATION INDEX 
C     JV      SPEED INDEX 
C     K       INDEX
C     KAIR    INDEX TO STORAGE ARRAYS
C     KAIRPT  ARRAY OF INDICES FOR THE DAIR ARRAYS
C     LKAQ    ARRAY OF APPROACHES AND DEPARTING LINKS TO NODE, XNODE
C     LNTMPR  TP SPECIFIC ARRAY - TP LENGTHS (SEC.)
C     MAXTP   MAXIMUM ALLOWABLE NUMBER OF TIME PERIODS
C     NMAP    USER SPECIFIED NODE NUMBER
C     PHSCNT  PHASE SPECIFIC ARRAY - NO OF TIMES PHASE ACTIVATED DURING
C             CURRENT 15 MINUTE PERIOD
C     RBGQUE  AVG NO OF VEHS IN QUEUE AT START OF IFZ, ON APPROACH, IAP
C             AND LANE ILN, DURING CURRENT 15 MINUTE PERIOD 
C     RCELL   VEHICLE SECONDS OF TRAVEL IN 10 METER CELL ACCUMULATED BY
C             PHASE, LANE, SPEED AND ACCELERATION 
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE OF LINK
C     XNODE   NUMBER OF NODE WHERE AIR QUALITY DATA IS REQUESTED 
C     ZVMAIR  ARRAY CONTAINING VEHICLE FEET OF TRAVEL BY APPROACH
C             AND SPEED CELL
C     ZVMART  ARRAY CONTAINING VEHICLE FEET OF TRAVEL BY APPROACH
C             AND VEHICLE CATEGORY (AUTOS,TRUCKS,CARPOOLS,BUSES)
C
C ----------------------------------------------------------------------              
C                                                                                     
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)                     
C                                                                                     
      INCLUDE 'NETSIM.INC'     
      INCLUDE 'AIRQUAL.INC'     
      INCLUDE 'GLOBAL.INC'  
C
      DIMENSION IDUR(8), RCELL(125,7,8,9,14), RBGQUE(5,7,8),
     1          RCUMLT(5,8), RCUMTH(5,8), RCUMRT(5,8), RCUMDG(5,8)
C
C -----  STORE DATA COLLECTED DURING THIS TIME PERIOD ON EXTERNAL FILE 
C -----  FOR AIR QUALITY MODELING.
C                     
      IF (CLOCK .EQ. 900) CALL TRFOPN(92)
      IN = XNODE
      JN = NMAP(IN)
C
C -----  LOOP TO DETERMINE TOTAL NUMBER OF APPROACHES AND DEPARTING 
C -----  LINKS FOR THIS NODE.
C
      ITOTA = 0
   10 CONTINUE
      ITOTA = ITOTA + 1     
      IF (ITOTA .LT. 10 .AND. LKAQ(ITOTA+1) .GT. 0)          GO TO 10
C
C -----  DETERMINE HOW MANY 15 MINUTE PERIODS OF DATA WILL BE WRITTEN
C -----  ON UNIT 92 DURING THIS RUN.
C
      ITPCNT = 0
      JDUR = 0
   15 CONTINUE
      ITPCNT = ITPCNT + 1
      JDUR = JDUR + LNTMPR(ITPCNT)
      IF (ITPCNT .LT. MAXTP .AND. LNTMPR(ITPCNT+1) .GT. 0)   GO TO 15  
      ITPCNT = JDUR / 900 
C
C -----  FIRST TIME UNIT IS WRITTEN, WRITE HEADER RECORD IDENTIFYING
C -----  THE NUMBER OF 15 MINUTE PERIODS OF DATA THAT WILL
C -----  BE WRITTEN TO THE UNIT.
C
      IF (CLOCK .EQ. 900) WRITE (LU92) ITPCNT
C 
C -----  GET DURATION OF EACH PHASE.
C
      DO 20 IFZ = 1, 8
         IDUR(IFZ) = 0  
   20 CONTINUE
      INTMX = FZPNTR(IN) / 2**11
      IMXFZ = 0
      J = MOD (FZPNTR(IN), 2**11) - 1
      DO 30 INTRVL = 1, INTMX
         IFZ = FZINT(INTRVL)
         J = J + 1
         IDUR(IFZ) = IDUR(IFZ) + MOD (DURINT(J), 2**7)
         IMXFZ = MAX0(IMXFZ, IFZ)
   30 CONTINUE 
C      
C -----  WRITE A RECORD OF THE SELECTED NODE NUMBER,
C -----  ELAPSED TIME SINCE START OF SIMULATION IN MINUTES, 
C -----  NUMBER OF APPROACHES AND DEPARTING LINKS FOR WHICH DATA WILL
C -----  BE WRITTEN AND NUMBER OF PHASES SERVICING THIS NODE
C      
      WRITE (LU92) JN, CLOCK, ITOTA, IMXFZ
C
C -----  LOOP OVER APPROACH AND DEPARTING LINKS TO WRITE LINK SPECIFIC
C -----  RECORDS.
C
      DO 150 IA = 1, ITOTA
         IL = LKAQ(IA)
         IU = UPNOD(IL)
         IF (IU .LT. 7000) IU = NMAP(IU)
         ID = DWNOD(IL)
         IF (ID .LT. 7000) ID = NMAP(ID)
C
C -----  GET THE NUMBER OF VEHICLE-BLOCK TRAVERSALS ON THIS APPROACH, IA
C -----  THEN RESET THE COUNT FOR THE NEXT TIME PERIOD.  GET THE NUMBER
C -----  OF BLOCKS ALONG APPROACH, IA.
C         
         KAIR = KAIRPT
         INBLK = MAX0 (MOD (XLNGTH(IL), 2**12) / 32 + 3, 100)         
         IMXLNE = MOD (LANEGD(IL) / 2**3, 2**3) + MOD(LANEGD(IL) / 2**6,
     1                            2**2) + MOD (LANEGD(IL) / 2**8, 2**2)
C
C -----  WRITE AIR QUALITY HEADER RECORD FOR APPROACH, IA.
C
         WRITE (LU92) IU, ID, INBLK, IA, IMXLNE
C
C -----  ZERO BUFFER USED TO STORE APPROACH-SPECIFIC DATA.
C
         DO 80 IBL = 1, INBLK
            DO 70 ILN = 1, 7
               DO 60 IFZ = 1, IMXFZ
                  DO 50 JC = 1, 9
                     DO 40 JV = 1, 14
                        RCELL(IBL,ILN,IFZ,JC,JV) = 0.0
   40                CONTINUE
   50             CONTINUE
   60          CONTINUE
   70       CONTINUE
   80    CONTINUE
C
C -----  PROCESS THE AIR QUALITY DATA RECORDS -- ONE FOR EVERY VEHICLE-
C -----  BLOCK TRAVERSAL.
C                              
         IKAIR = MIN0 (KAIR, KAIRMX)  
         DO 90 K = 1, IKAIR
            IF (IA .EQ. DAIRIA(K)) THEN
               IBL = DAIRBL(K)
               IFZ = DAIRLN(K) / 2**3
               ILN = DAIRLN(K) - IFZ * 2**3
               JV  = DAIRSA(K) / 9
               JC  = DAIRSA(K) - JV * 9
               JV  = JV + 1
               JC  = JC + 1
               JT  = DAIRTM(K)
               IF (JT .LT. 0) JT = -JT + 128
               RFACT = 1.0
               RCELL(IBL,ILN,IFZ,JC,JV) = RCELL(IBL,ILN,IFZ,JC,JV) +
     1                                    FLOAT (JT) / 250.0
            ENDIF
   90    CONTINUE
         IF (KAIR .GT. KAIRMX) THEN
            RFACT = FLOAT (KAIR) / FLOAT (KAIRMX)
            DO 99 IBL = 1, INBLK
               DO 98 ILN = 1, IMXLNE
                  DO 97 IFZ = 1, IMXFZ
                     DO 96 JC = 1, 9
                        DO 95 JV = 1, 14
                           RCELL(IBL,ILN,IFZ,JC,JV) = RCELL(IBL,ILN,IFZ,
     1                                                   JC,JV) * RFACT
   95                   CONTINUE
   96                CONTINUE
   97             CONTINUE
   98          CONTINUE
   99       CONTINUE
         ENDIF
         DO 100 IBL = 1, INBLK
            WRITE (LU92) ((((RCELL(IBL,ILN,IFZ,JC,JV), JV=1,14),
     1                   JC=1,9), IFZ=1,IMXFZ), ILN=1,IMXLNE)
  100    CONTINUE
C
C -----  CONVERT VEHICLE FEET TO VEHICLE MILES OF TRAVEL BY APPROACH 
C -----  AND SPEED CELL AND BY APPROACH AND VEHICLE TYPE.
C
         DO 110 K = 1, 14
            ZVMAIR(IA,K) = ZVMAIR(IA,K) / 5280.0
            IF (K .LE. 4)  ZVMART(IA,K) = ZVMART(IA,K) / 5280.0
  110    CONTINUE     
C
C -----  WRITE RECORD FOR APPROACH, IA CONTAINING VEHICLE MILES
C -----  OF TRAVEL BY APPROACH AND SPEED CELL
C
         WRITE (LU92) (ZVMAIR(IA,K), K = 1, 14), (ZVMART(IA,K), K=1, 4)
         DO 115 K = 1, 14
            ZVMAIR(IA,K) = 0
            IF (K .LE. 4) ZVMART(IA,K) = 0
  115    CONTINUE
C
C -----  FOR APPROACH LINKS TO XNODE (AND NOT DEPARTING LINKS)
C -----  WRITE QUEUE BY APPROACH AND LANE AT THE START OF 
C -----  EACH PHASE AVERAGED OVER THE 15 MINUTE PERIOD.
C
         IF (DWNOD(IL) .EQ. XNODE) THEN
            DO 130 ILN = 1, IMXLNE
               DO 120 IFZ = 1, IMXFZ 
                  IF (PHSCNT(IFZ) .GT. 0) THEN
                     RBGQUE(IA,ILN,IFZ) = FLOAT(BEGQUE(IA,ILN,IFZ))  
     1                                  / FLOAT(PHSCNT(IFZ))
                  ELSE
                     RBGQUE(IA,ILN,IFZ) = 0.0
                  ENDIF       
  120          CONTINUE
  130       CONTINUE
            WRITE (LU92) ((RBGQUE(IA,ILN,IFZ),IFZ=1,IMXFZ),ILN=1,IMXLNE)
C
C -----  WRITE MOVEMENT SPECIFIC COUNT OF NUMBER OF VEHICLES
C -----  DISCHARGING DURING PHASE, IFZ AVERAGED OVER THE 15 MINUTE 
C -----  PERIOD.
C
            DO 140 IFZ = 1, IMXFZ
               IF (DURPHS(IFZ) .GT. 0) THEN
                  RATIO = FLOAT(IDUR(IFZ)) / FLOAT(DURPHS(IFZ))
                  RCUMLT(IA,IFZ) =   FLOAT(CUMLFT(IA,IFZ)) * RATIO
                  RCUMTH(IA,IFZ) =   FLOAT(CUMTHR(IA,IFZ)) * RATIO
                  RCUMRT(IA,IFZ) =   FLOAT(CUMRIT(IA,IFZ)) * RATIO
                  RCUMDG(IA,IFZ) =   FLOAT(CUMDIG(IA,IFZ)) * RATIO
               ENDIF
  140       CONTINUE
            WRITE (LU92) (RCUMLT(IA,IFZ), IFZ = 1, IMXFZ)
            WRITE (LU92) (RCUMTH(IA,IFZ), IFZ = 1, IMXFZ)
            WRITE (LU92) (RCUMRT(IA,IFZ), IFZ = 1, IMXFZ)
            WRITE (LU92) (RCUMDG(IA,IFZ), IFZ = 1, IMXFZ)
C
C -----  RESET ARRAYS FOR NEXT 15 MINUTE PERIOD.
C
            DO 147 IFZ = 1, 8
               CUMLFT(IA,IFZ) = 0
               CUMTHR(IA,IFZ) = 0
               CUMRIT(IA,IFZ) = 0
               CUMDIG(IA,IFZ) = 0
               DO 145 ILN = 1, 7
                  BEGQUE(IA,ILN,IFZ) = 0  
  145          CONTINUE
  147       CONTINUE   
         ENDIF
  150 CONTINUE
      DO 160 IFZ = 1, 8
         DURPHS(IFZ) = 0
         PHSCNT(IFZ) = 0
 160  CONTINUE      
      KAIRPT = 0
C
C -----  WRITE FINAL RECORD OF FIVE DATA ITEMS, ALL SET TO ZERO, TO MARK
C -----  END OF 15-MINUTE AIR QUALITY DATA FILE.
C
      K = 0
      WRITE (LU92) K, K, K, K, K
C
      RETURN
      END      
      SUBROUTINE RDAIR 
C                                                                                     
C                                                                                     
C --- CODED   12-31-97 BY M. YEDLIN                                                
C                                                                                     
C --- TITLE -  READ AIR QUALITY DATA FROM UNIT 92                        
C ---          MODULE 3.2.3.12
C                                                                                     
C --- FUNCTION -  READ CELL DATA, QUEUE AND DISCHARGE DATA 
C ---             REQUIRED FOR AIR QUALITY MODELING.
C ---                                                                          
C                                                                                     
C --- ARGUMENTS - NONE
C                                                                                     
C -------------------------   DESCRIPTION   ---------------------------               
C                             -----------                                             
C                                                                         
C     THIS SUBROUTINE READS DATA REQUIRED FOR AIR QUALITY MODELING FROM
C     UNIT 92 AND PRINTS A COPY OF THIS DATA.  THE DATA ON UNIT 92
C     INCLUDES VEH-SEC OF TRAVEL IN EACH 10M CELL BY (LANE,LINK,PHASE,
C     SPEED AND ACCELERATION), VEHICLE MILES OF TRAVEL BY APPROACH AND 
C     SPEED RANGE, VEHICLE MILES OF TRAVEL BY APPROACH AND VEHICLE TYPE,
C     AVG. NUMBER OF VEHICLES IN QUEUE AT THE START OF EACH SIGNAL PHASE
C     (BY LANE), AND AVERAGE NUMBER OF VEHS DISCHARGING EACH APPROACH (BY 
C     MOVEMENT) DURING EACH SIGNAL PHASE. 
C                                                            
C -------------------   THIS ROUTINE CALLED BY   ----------------------               
C                       ----------------------                                        
C                                                                                     
C                         TRAF - MODULE 1.0                                                                 
C                                                                                     
C ---------------------   THIS ROUTINE CALLS   ------------------------               
C                         ------------------                                          
C                                            
C                               NONE
C                                                                                     
C ---------------    GLOSSARY OF VARIABLE NAMES   ---------------------               
C                    --------------------------                                       
C        
C     IA      APPROACH NUMBER
C     IBL     BLOCK NUMBER 
C     ICLOCK  ELAPSED TIME SINCE START OF SIMULATION, SECONDS.
C     ID      USER SPECIFIED DOWNSTREAM NODE NUMBER
C     IFZ     PHASE NUMBER 
C     IIA     INDEX OVER APPROACH AND DEPARTING LINKS
C     IL      LINK INDEX
C     ILN     LANE NUMBER 
C     IMXFZ   TOTAL NUMBER OF PHASES AT NODE
C     IMXLNE  NUMBER OF LANES ON LINK, IL
C     INBLK   NUMBER OF BLOCKS OF DATA TO BE READ FOR APPROACH, IA
C     ITOTA   TOTAL NUMBER OF APPROACH AND DEPARTING LINKS FOR XNODE
C     ITPCNT  NUMBER OF 15 MINUTE PERIODS OF DATA THAT WILL BE WRITTEN 
C     IU      USER SPECIFIED UPSTREAM NODE NUMBER
C     JC      ACCELERATION INDEX 
C     JN      USER DEFINED NODE NUMBER WHERE AIR QUALITY DATA REQUESTED
C     JV      SPEED INDEX 
C     K       INDEX
C     RBGQUE  AVG NO OF VEHS IN QUEUE AT START OF IFZ, ON APPROACH, IAP
C             AND LANE ILN, DURING CURRENT 15 MINUTE PERIOD 
C     RCELL   VEHICLE SECONDS OF TRAVEL IN 10 METER CELL ACCUMULATED BY
C             PHASE, LANE, SPEED AND ACCELERATION 
C     RCMDIG  AVG NO. OF VEHICLES DISCHARGING APPROACH VIA DIAG MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IFZ ACTIVE
C     RCMLFT  AVG NO. OF VEHICLES DISCHARGING APPROACH VIA LEFT MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IFZ ACTIVE
C     RCMRIT  AVG NO. OF VEHICLES DISCHARGING APPROACH VIA RITE MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IFZ ACTIVE
C     RCMTHR  AVG NO. OF VEHICLES DISCHARGING APPROACH VIA THRU MOVEMENT
C             DURING THE CURRENT 15 MINUTE PERIOD WHILE PHASE IFZ ACTIVE
C     RLINE   ONE LINE OF AVG QUEUE DATA FOR 7 LANES FOR PHASE, IFZ 
C     RVMAIR  ARRAY CONTAINING VEHICLE FEET OF TRAVEL BY APPROACH
C             AND SPEED CELL
C     RVMART  ARRAY CONTAINING VEHICLE FEET OF TRAVEL BY APPROACH
C             AND VEHICLE CATEGORY (AUTOS,TRUCKS,CARPOOLS,BUSES)
C
C ----------------------------------------------------------------------              
C                                                                                     
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)                     
C                                                                                     
      INCLUDE 'NETSIM.INC'     
      INCLUDE 'AIRQUAL.INC'     
      INCLUDE 'GLOBAL.INC'  
C
      DIMENSION RCELL(125,7,8,9,14), RVMAIR(10,14), RVMART(10,4),
     1          RBGQUE(5,7,8), RCMLFT(5,8), RCMTHR(5,8), RCMRIT(5,8),
     2          RCMDIG(5,8), RLINE(8), RTMVC(14,9)
C
C -----  READ DATA COLLECTED DURING THIS TIME PERIOD ON EXTERNAL FILE 
C -----  FOR AIR QUALITY MODELING. FIRST READ A HEADER RECORD OF THE 
C -----  NUMBER OF 15 MINUTE PERIODS OF DATA THAT WILL BE WRITTEN 
C -----  TO THE UNIT. THEN READ SELECTED NODE NUMBER, ELAPSED TIME 
C -----  IN MINUTES, AND NUMBER APPROACHES AND DEPARTING LINKS FOR WHICH 
C -----  DATA IS WRITTEN.
C                     
      REWIND (LU92)
      READ (LU92) ITPCNT
      DO 30 ITP = 1, ITPCNT
         READ (LU92) JN, ICLOCK, ITOTA, IMXFZ
         IHOUR = ICLOCK / 3600
         IMIN  = (ICLOCK - IHOUR * 3600) / 60
         ISEC  = (ICLOCK - IHOUR * 3600 - IMIN * 60)
         WRITE (LU6, 1000) JN, IHOUR, IMIN, ISEC, ITOTA, ITPCNT, IMXFZ
C
C -----  LOOP OVER APPROACH AND DEPARTING LINKS TO READ LINK SPECIFIC
C -----  RECORDS.
C                                                               
         DO 20 IIA = 1, ITOTA
C
C -----  READ AIR QUALITY HEADER HEADER RECORD FOR APPROACH, IA.
C
            READ (LU92) IU, ID, INBLK, IA, IMXLNE
            WRITE (LU6, 1010) IU, ID, INBLK, IA, IMXLNE
C
C -----  READ THE AIR QUALITY DATA RECORDS -- ONE FOR EVERY VEHICLE-
C -----  BLOCK TRAVERSAL.
C
            DO 10 IBL = 1, INBLK
               READ (LU92) ((((RCELL(IBL,ILN,IFZ,JC,JV), JV=1,14),
     1                   JC=1,9), IFZ=1,IMXFZ), ILN=1,IMXLNE)
   10       CONTINUE
               RTOT = 0.0
                  DO 50 JV = 1, 14
                     DO 48 JC = 1, 9
                        RTMVC(JV,JC) = 0.0
                           DO 46 IBL = 1, INBLK
                              DO 44 ILN = 1, IMXLNE
                                 DO 42 IFZ = 1, IMXFZ
                                    RTMVC(JV,JC) = RTMVC(JV,JC)
     1                                   + RCELL(IBL,ILN,IFZ,JC,JV)
                                    RTOT = RTOT 
     1                                   + RCELL(IBL,ILN,IFZ,JC,JV)
   42                            CONTINUE
   44                         CONTINUE
   46                      CONTINUE
   48                CONTINUE
   50             CONTINUE
C                 DO 55 JV = 1, 14
C                    WRITE (LU6, 1200) JV, (RTMVC(JV,JC), JC = 1, 9)
C  55             CONTINUE
                  WRITE (LU6, 1190) RTOT
C                 DO 60 JV = 1, 14
C                    WRITE (LU6, 1210) JV, (RTMVC(JV,JC) / RTOT*100,
C    1                                      JC = 1, 9)
C  60             CONTINUE
C           ENDIF
C
C -----  READ RECORD FOR APPROACH, IA CONTAINING VEHICLE MILES
C -----  OF TRAVEL BY APPROACH AND SPEED CELL
C
            READ (LU92) (RVMAIR(IA,K), K = 1, 14),(RVMART(IA,K), K=1, 4)
            WRITE (LU6,1030) (RVMAIR(IA,K), K= 1, 14),
     1                       (RVMART(IA,K), K= 1, 4)
C
C -----  FOR APPROACH LINKS TO NODE (AND NOT DEPARTING LINKS)
C -----  READ QUEUE BY APPROACH AND LANE AT THE START OF 
C -----  EACH PHASE AVERAGED OVER THE 15 MINUTE PERIOD.
C
            IF (ID .EQ. JN) THEN
               READ (LU92) ((RBGQUE(IA,ILN,IFZ), IFZ=1,IMXFZ), 
     1                                          ILN=1,IMXLNE)
               WRITE (LU6, 1040)
               DO 17 IFZ = 1, IMXFZ 
                  RLINE(1) = IFZ
                  DO 15 ILN = 1, IMXLNE
                     RLINE(ILN+1) = RBGQUE(IA,ILN,IFZ)
   15             CONTINUE     
                  WRITE (LU6, 1050) (RLINE(I), I = 1, IMXLNE+1)
   17          CONTINUE     
C
C -----  READ MOVEMENT SPECIFIC COUNT OF NUMBER OF VEHICLES
C -----  DISCHARGING DURING PHASE, IFZ AVERAGED OVER THE 15 MINUTE 
C -----  PERIOD.
C
               READ (LU92) (RCMLFT(IA,IFZ), IFZ = 1, IMXFZ)
               READ (LU92) (RCMTHR(IA,IFZ), IFZ = 1, IMXFZ)
               READ (LU92) (RCMRIT(IA,IFZ), IFZ = 1, IMXFZ)
               READ (LU92) (RCMDIG(IA,IFZ), IFZ = 1, IMXFZ)
               WRITE (LU6, 1060) (RCMLFT(IA,IFZ), IFZ = 1, 8)
               WRITE (LU6, 1070) (RCMTHR(IA,IFZ), IFZ = 1, 8)
               WRITE (LU6, 1080) (RCMRIT(IA,IFZ), IFZ = 1, 8)
               WRITE (LU6, 1090) (RCMDIG(IA,IFZ), IFZ = 1, 8)
            ENDIF
   20    CONTINUE
C
C -----  READ FINAL RECORD OF FIVE DATA ITEMS, ALL SET TO ZERO, TO MARK
C -----  END OF 15-MINUTE AIR QUALITY DATA FILE.
C
         K = 0
         READ (LU92) K, K, K, K, K
         WRITE (LU6, 1100) K, K, K, K, K
   30 CONTINUE      
C      
 1000 FORMAT (//, 51X, 'AIR QUALITY DATA FOR NODE ', I4,
     1        /,  30X, 'ELAPSED TIME SINCE START OF SIMULATION:', I3,
     2                 ' HOURS', I3, ' MINUTES', I3, ' SECONDS',
     3        /,  30X, 'THE TOTAL NUMBER OF APPROACH AND DEPARTING ',
     4                 'LINKS FOR THIS NODE IS', I3,
     5        /,  30X, 'THE TOTAL NUMBER OF 15 MINUTE PERIODS FOR ',
     6                 'WHICH DATA IS WRITTEN IS', I4,
     7         /, 45X, 'THERE ARE ', I4, ' SIGNAL PHASES AT THIS NODE')
 1010 FORMAT (//, 45X, 'BEGINNING OF RECORDS FOR LINK (', I4, ',', I4,
     1                 ')',
     2         /, 36X, 'THERE ARE ', I7, ' CELLS FOR THIS APPROACH'
     3                 '/DEPARTURE LINK,', I3, '.',
     4         /, 53X, 'THERE ARE', I2, ' LANES ON THIS APPROACH.')  
 1030 FORMAT (//, ' VEHICLE-MILES OF TRAVEL BY SPEED RANGE:',
     1         /, 14F7.2
     2        //,' VEHICLE-MILES OF TRAVEL BY AUTO, TRUCK, CARPOOL, BUS'
     3          , /, 25X, F7.2, F7.2, F7.2, F7.2)
 1040 FORMAT (//, ' AVG. QUEUE AT BEGINNING OF EACH PHASE BY LANE:',
     1         /, ' LANE:', 5X, '1', 5X, '2', 5X, '3', 5X, '4', 5X, 
     2                          '5', 5X, '6', 5X, '7',
     3         /, ' PHASE')
 1050 FORMAT (/,  I4, F8.1, 6F6.1)
 1060 FORMAT (//,' AVG. NUMBER OF LEFT TURNING DISCHARGING VEHICLES',
     1              ' BY PHASE:', 5X, '1', 5X, '2', 5X, '3', 5X, '4',
     2               5X, '5', 5X, '6', 5X, '7', 5X, '8',
     3            /, 60X, F5.1, 7F6.1)
 1070 FORMAT (//,' AVG. NUMBER OF THROUGH      DISCHARGING VEHICLES',
     1              ' BY PHASE:', 5X, '1', 5X, '2', 5X, '3', 5X, '4',
     2               5X, '5', 5X, '6', 5X, '7', 5X, '8',
     3            /, 60X, F5.1, 7F6.1)
 1080 FORMAT (//,' AVG. NUMBER OF RIGHT TURN   DISCHARGING VEHICLES',
     1              ' BY PHASE:', 5X, '1', 5X, '2', 5X, '3', 5X, '4',
     2               5X, '5', 5X, '6', 5X, '7', 5X, '8',
     3            /, 60X, F5.1, 7F6.1)
 1090 FORMAT (//,' AVG. NUMBER OF DIAGONAL     DISCHARGING VEHICLES',
     1              ' BY PHASE:', 5X, '1', 5X, '2', 5X, '3', 5X, '4',
     2               5X, '5', 5X, '6', 5X, '7', 5X, '8',
     3            /, 60X, F5.1, 7F6.1)
 1100 FORMAT (//, ' FINAL DELIMITER RECORD:', 5I4)     
 1190 FORMAT ('0', ' TOTAL VEHICLE SECONDS FOR THE APPROACH = ', F10.1)
 1200 FORMAT ('0', 30X, 'VEH-SEC BY SPEED-ACCEL CELL'/
     1        '0', 10X, 'JV = ', I2, 9F10.1)
 1210 FORMAT ('0', 30X, 'PERCENT OF TOTAL VEH-SEC BY SPEED-ACCEL CELL'/,
     1        '0', 10X, 'JV = ', I2, 9F10.2)
C
      RETURN
      END         
      PROGRAM TRAF
C                        
C ======================  ACKNOWLEDGMENTS ===========================
C                         ---------------
C         THE TRAF SYSTEM OF SIMULATION MODELS WAS DEVELOPED UNDER THE
C    SPONSORSHIP OF THE FEDERAL HIGHWAY ADMINISTRATION FOR THE PURPOSE
C    OF PROVIDING THE TRAFFIC ENGINEERING COMMUNITY WITH A HIGHLY
C    SOPHISTICATED TOOL TO DEVELOP AND TEST TRAFFIC CONTROL STRATEGIES
C    PRIOR TO THEIR FIELD IMPLEMENTATION.
C
C         THE SUCCESSFUL DEVELOPMENT OF TRAF HAS BEEN THE RESULT OF
C    THE COMMITMENT AND DEDICATION OF MANY INDIVIDUALS WHO LABORED
C    MANY LONG HOURS OVER MANY YEARS TO MAKE THIS PRODUCT A REALITY.
C    RECOGNITION IS DUE TO MESSRS. LIEBERMAN AND YEDLIN FOR THEIR
C    CONTRIBUTIONS IN THE DEVELOPMENT OF THE SYSTEM. RECOGNITION IS
C    ALSO DUE TO THE FOLLOWING INDIVIDUALS WHO, THROUGH THEIR EFFORTS,
C    MADE THIS SYSTEM FULLY OPERATIONAL:
C
C         MR. H. LIEU         MR. H. CHEN        MR. A. KANAAN
C         MS. C. DUREN        DR. J. MEKEMSON    DR. C. LIU
C         MRS.S. WALKER       MR. J. COTTON      MR. A. PHLEGAR
C         MR. Y. CHUANG       MR. I.J. CHIEN     DR. H. HALATI
C
C         SPECIAL RECOGNITION AND COMMENDATION IS GIVEN TO DR. OSAMA
C    SHARAF-ELDIEN WHO, OVER A PERIOD OF FOUR YEARS, WENT BEYOND THE
C    CALL OF DUTY AND PERFORMED OUTSTANDINGLY IN ENSURING THE PROPER
C    COMPLETION OF THIS SYSTEM.
C
C         DIRECTING AND MANAGING THE EFFORT TO COMPLETE THE TRAF
C    SYSTEM HAS BEEN A REWARDING EXPERIENCE. THE DEDICATION OF THE
C    ABOVE MENTIONED INDIVIDUALS TOGETHER WITH THE SUPPORT OF FHWA
C    HAVE ENABLED THE DEVELOPMENT OF THIS PRODUCT.
C
C                                        ALBERTO J. SANTIAGO
C
C ====================================================================
C
C --- CODED    3-14-78 BY B. ANDREWS
C --- REVISED  5-11-87 BY O. SHARAF-ELDIEN TO AVOID SECOND PASS FOR
C ---                                      A SINGLE TIME PERIOD CASE
C --- REVISED  5-29-87 BY B. ANDREWS TO ADD UNIT 45
C --- REVISED  7-13-87 BY M. YEDLIN TO OUTPUT ENVIRONMENTAL STATS IF
C ---                           TRAJECTORY DATA READ WITHOUT SIMULATION
C --- REVISED  4-25-88 BY O. SHARAF-ELDIEN TO FIX FILL-TIME DEPENDENCY,
C                               FOR TEMP.DEBUG (RANDOM SEEDS),
C                               FOR NETSIM-GRAPHICS, AND
C                               FOR FINAL DELIVERY OF CORFLO
C --- REVISED  8-12-88 BY J. MEKEMSON FOR LU49, TIME SPECIFIC LINK DATA
C                                     VARIABLES XINT1 AND XINT2.
C --- REVISED  8-28-89 BY H. CHEN TO ADD RUN-TIME MESSAGE FOR MS-DOS VER
C --- REVISED 11-02-89 BY H. CHEN TO RESTRUCTURE THE CODE
C --- REVISED  6-11-90 BY B. ANDREWS TO OPEN CORFLO GRAPHICS FILES
C --- REVISED 11-05-90 BY A. KANAAN TO ADD CALLS TO TRFOPN
C --- REVISED 10-02-91 BY A. KANAAN TO DISPLAY CPU CLOCK FOR DOS VERSION
C --- REVISED  1-15-93 BY J. COTTON TO ADD FRESIM
C --- REVISED  2-10-93 BY M. SEELEY TO OPEN UNIT 56
C --- REVISED  3-05-93 BY A. PHLEGAR TO ADD LU82 FOR O-D                
C --- REVISED  4-09-93 BY A. PHLEGAR TO CALL OD OUTPUT
C --- REVISED  4-27-93 BY A. PHLEGAR TO CALL FOR ERROR MESSAGE TEXT & OD OUTPUT
C --- REVISED  5-25-93 BY A. KANAAN TO FOLLOW TRAF COMMON NAMING, ADD CONVRT 
C --- REVISED 10-19-93 BY A. PHLEGAR TO ALLOW NO GRAPHICS CONVERSION
C --- REVISED  2-10-94 BY I.J. CHIEN REDIRECT OUTPUT UNIT FROM 6 TO 66
C                                       AND INPUT UNIT FROM 5 TO 65
C --- REVISED  3-05-94 BY A. KANAAN TO DISPLAY MORE CPU STATISTICS
C --- REVISED  6-06-94 BY Y. CHUANG TO DELETE ANIMATION FILES LU72 AND LU81
C --- REVISED 10-26-94 BY A. PHLEGAR FOR TO RENAME CASE AND RESTRUCTURE CODE
C --- REVISED 10-27-94 BY A. PHLEGAR TO REMOVE FRESIM OFFLINE INCIDENT OUTPUT
C --- REVISED 11-15-94 BY I.J. CHIEN FOR CORSIM GRAPHICS
C --- REVISED 12-31-97 BY M. YEDLIN FOR AIR QUALITY MODELING
C
C --- TITLE - PERFORM SIMULATION - MODULE 1.0
C
C --- FUNCTION - THIS IS THE PRIMARY EXECUTIVE ROUTINE OF THE TRAF MODEL
C
C --- ARGUMENTS - NONE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     TRAF BEGINS EACH CASE BY PRINTING THE TRAF BANNER. THEN AFTER
C     PRINTING THE CASE TITLE AND INITIALIZING COUNTERS THE INPUT
C     PROCESSING OVERLAY IS CALLED TO READ AND TEST ENTIRE INPUT
C     STREAM. IF NO INPUT ERRORS, AND EXECUTION DESIRED THE LOGIC
C     DIRECTS THE CALLS TO OVERLAYS WHICH PERFORM THE TRAFFIC
C     ASSIGNMENT (IF REQUESTED) AND THE SUBSEQUENT SIMULATION. THIS
C     ROUTINE LOOPS OVER TIME PERIODS (TO READ INPUTS) AND OVER TIME
C     INTERVALS (TO CHECK IF OUTPUTS ARE REQUESTED).
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                                NONE
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                    BANNER - MODULE 1.1
C                    PRIME  - MODULE 2.0 - (OVERLAY 1, 0)
C                    SIMUL  - MODULE 3.0 - (OVERLAY 2, 0)
C                    PUTDAT - MODULE 4.0 - (OVERLAY 3, 0)
C                    TRFASS - MODULE 5.0 - (OVERLAY 4, 0)
C                    TRFOPN  -
C                    GRFCNV  -
C                    RDAIR   - 
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ---------------------
C                    --------------------------
C
C     XCASE    CASE COUNTER
C     CASINP  CHARACTER STRING CONTAINING CASE NAME
C     ERRCT   INPUT ERROR COUNTER
C     E1      BEGIN CPU TIME IN 100TH SEC
C     ETIME   END CPU TIME IN 100TH SEC
C     FILDUR  ACTUAL DURATION OF FILL TIME
C     FUEL    CODE SPECIFYING FUEL OPTION FOR NETSIM
C     FUELFR  CODE SPECIFYING FUEL OPTION FOR FRESIM
C     FROFFL  CODE (0,1) IF FRESIM POINT PROCESSING, MOE ESTIMATION,
C             AND/OR OFFLINE INCIDENT DETECTION (IS NOT, IS) DESIRED
C     GCLK    CLOCK TIME SINCE THE BEGINNING OF CASE, SECONDS
C     IB      LOCATION OF FIRST BLANK IN CASE NAME OR LAST CHARACTER
C             IN CASE NAME
C     IGTIME  BEGIN TIME OF GRAPHICS IN 100TH SECONDS SINCE MIDNIGHT
C     IPUTCT  COUNTER OF INTERVALS BETWEEN STANDARD OUTPUTS
C     ISTIME  BEGIN 100TH SECONDS ELAPSED SINCE MIDNIGHT
C     ITTIME  END TIME OF TA IN 100TH SECONDS SINCE MIDNIGHT
C     KFILE   CHARACTER STRING CONTAINING FILE NAME
C     LENINT  LENGTH OF A TIME INTERVAL, SECONDS
C     LENPRD  LENGTH OF TIME PERIOD BEING PROCESSED, SECONDS
C     LNTMPR  TP SPECIFIC ARRAY - TP LENGTHS (SEC.)
C     LU6-49  PERIPHERAL UNIT NUMBER 6 THROUGH 49
C     LU61    PERIPHERAL UNIT NUMBER 61 (LEVEL II HISTOGRAM DATA) 
C     LU71    PERIPHERAL UNIT NUMBER 71 (FREFLO MOE DATA) 
C     LU82    PERIPHERAL UNIT NUMBER 82 (O-D DATA)
C     MAXTP   MAXIMUM ALLOWABLE NUMBER OF TIME PERIODS
C     MSGCT   INPUT WARNING MESSAGE COUNTER
C     NEXTRN  NEXT CASE CODE (0,1) IF ANOTHER CASE (DOESNT,DOES) FOLLOW
C     PUTSTD  NUMBER OF TIME INTVLS BETWEEN SUCCESSIVE STANDARD OUTPUTS
C     TICNT   TIME INTERVAL COUNTER
C     TMINIT  INITIALIZATION TIME (TIME INTERVALS)
C     TPCLK   TIME PERIOD CLOCK, SECONDS
C     TPCNT   TIME PERIOD COUNTER
C     TYPERN  (1,2,3) IF (SIM,TA,BOTH) DESIRED (-FOR DIAGNOSTICS ONLY)
C     W32     FLAG = .T. IF NO SIMULATION TO BE PERFORMED - READ TRAJ
C             DATA FROM UNIT 32 AND PRINT ENVIRONMENTAL MOE
C     WNCNVT  FLAG (.T. TO SUPPRESS CONVERSION OF GRAPHICS)
C     WODOUT  FLAG (T, F) IF OD OUTPUT (IS, IS NOT) REQUESTED
C     WOPEN   FLAG (T,F) IF GRAPHIC FILE UNIT 40 WAS OPENED
C     WTPSOD  FLAG (T, F) IF TIME PERIOD OD OUTPUT (IS, IS NOT) REQUESTED
C     XSEED   RANDOM NUMBER SEED 
C     XSEED2  RANDOM NUMBER SEED TO GENERATE TRAFFIC STREAM  
C     YCASE   CASE TERMINATION FLAG, SET TO .T. IF CASE MUST BE ABORTED
C     YEOI    END-OF-INPUT FLAG, SET TO .T. IF EOF FOUND UNEXPECTEDLY
C     YFIRST  FLAG FOR 1ST PASS
C     YGRAPH  FLAG (T,F) IF USER (DOES, DOESN'T) WANT GRAPHICS OUTPUT
C     YINIT   INITIALIZATION FLAG, SET TO .T. IF PRIMING FOR SIMULATION
C     YLAHEY  FLAG FOR LAHEY ENVIRONMENT
C     YMSDOS  FLAG FOR MS-DOS ENVIRONMENT
C     YSUB    SUBNETWORK SPECIFIC FLAG (T,F) OF SUBNETWORK (DOES,NOT) EXIST
C     YTRACE  FLAG FOR TRACING EXECUTION SEQUENCE
C
C ---------------------------------------------------------------------
C
      IMPLICIT INTEGER(A-Q, S-V, X), REAL(R, Z), LOGICAL(W, Y)
C
      INCLUDE 'GLOBAL.INC'
      INCLUDE 'NETSIM.INC'
      INCLUDE 'AIRQUAL.INC'
C
C ---- THE FOLLOWING COMMON WAS SPLIT INTO 3 COMMON TO 
C ---- FOLLOW NAMING CONVENTION FOR TRAF. BY AK 5/2/93
C
C     COMMON /GLR887/ SD1,SD2,SD3,DBG                               
C
C     CHARACTER CASINP*8             <<<<<ALREADY DECLARED IN GLOBAL.INC
C
      CHARACTER KFILE*12
C
C --- OPEN INPUT AND OUTPUT FILES BEFORE MAKING THE CPU CLOCK TIME.
C --- IF THIS IS A MSDOS VERSION THEN CALL TIMER TO GET CPU CLOCK
C --- IN 100TH OF A SECOND.
C
      IF (YMSDOS) THEN
         CALL TRFOPN(65)
         CALL TRFOPN(66)
         CALL TIMER(ISTIME)
         ITTIME = ISTIME
      ENDIF
C
C           OPEN DATA FILE USING THE BLANK = 'ZERO' PARAMETER.  IF THIS
C           PARAMETER IS NOT USED, IN FIELDS WHERE NUMBERS ARE FOLLOWED
C           BY BLANKS, NUMBERS WILL BE RIGHT JUSTIFIED.
C
      CALL TRFOPN(7)
      IF (YMSDOS .AND. YTRACE) WRITE (*, *) ' UNITS 5,6,7 ARE OPEN',LU56
C
C           PRINT TRAF BANNER, PROGRAM TITLE AND CASE NUMBER
C
      XCASE = 0
      ERRCT = 0
      MSGCT = 0
C
      DO 5 I = 1, 350
         ERMSG(I) = 0
    5 CONTINUE
C
   10 CONTINUE
      XCASE = XCASE + 1
      CALL BANNER()
      IF (YMSDOS .AND. YTRACE) WRITE (*, *) ' BANNER IS DONE',LU56
      WRITE (LU6, 1003)
      WRITE (LU6, 1000) XCASE
      IF (YMSDOS) WRITE (*, 2003) XCASE
C
C           SET COUNTERS, CLOCKS AND FLAGS
C
      TRCSD1 = 0
      TRCSD2 = 0
      TRCSD3 = 0
      TRCDBG = 0
C
      TPCNT = 0
      TICNT = 0
      IPUTCT = 0
      GCLK = 0
      YCASE = .FALSE.
C
C           LOAD INPUT PROCESSING OVERLAY TO CHECK ENTIRE INPUT STREAM
C
      YFIRST = .TRUE.
      CALL PRIME()
      IF (YMSDOS .AND. YTRACE) WRITE (*, *) ' PRIME IS DONE'
      YFIRST = .FALSE.
C
C           TRANSFER IF END-OF-INPUT FOUND THEN TRA IF ERRORS IN INPUTS
C           IF ERRORS IN INPUTS, CALL MODULE TO PRINT ERROR MESSAGE
C           TEXT
C
      IF (.NOT. (YEOI .OR. ERRCT .GT. 0)) THEN
C
C           IF ONLY A DIAGNOSTIC RUN, WRITE MESSAGE AND TRA
C
         IF (TYPERN .LT. 0) THEN
            WRITE (LU6, 1001)
         ELSE
C
C           FLOW WAS RESTRUCTURED TO AVOID A SECOND PREPROCESSOR PASS
C           FOR A SINGLE TIME PERIOD CASE.  FOR A MULTI T.P. CASE,
C           EXEC PREPROCESSOR TO LOAD DATA BASE FOR THE FIRST T.P.
C           AND REWIND LU40 TO OVERWRITE THE FIRST PASS RECORDS.
C
            IF (TPCNT .NE. 1) THEN
               TPCNT = 1
               IF (YGRAPH) REWIND (LU40)
               CALL PRIME()
            ENDIF
C
C --- OPEN O/D OUTPUT FILE IF REQUESTED, AND PRINT HEADER
C
            IF (WODOUT) THEN
               CALL TRFOPN(82)
               WRITE (LU82, 2010)
            ENDIF
C
C           EXECUTE TRAFFIC ASSIGNMENT MODEL IF REQUESTED
C
            IF (TYPERN .GT. 1) THEN
               IF (YMSDOS) WRITE (*, 2004)
               CALL TRFASS()
               CALL TIMER(ITTIME)
            ENDIF
            IF (ERRCT .EQ. 0) THEN
C
C           IF SIMULATION NOT REQUESTED, WRITE MESSAGE AND TRA
C
               IF (TYPERN .EQ. 2) THEN
                  WRITE (LU6, 1002)
               ELSE
C
C           IF NECESSARY, OPEN GRAPHICS DATA FILES
C
                  IF (YGRAPH) THEN
                     CALL TRFOPN(42)
                     CALL TRFOPN(43)
                     IF (YSUB(3)) THEN
                        CALL TRFOPN(41)
                        CALL TRFOPN(44)
                        CALL TRFOPN(45)
                        CALL TRFOPN(56)
                     ENDIF
                     IF (YSUB(4)) CALL TRFOPN(71)
                     IF (YSUB(5)) CALL TRFOPN(55)
                     IF (YSUB(6)) CALL TRFOPN(61)
                     IF (YSUB(8)) THEN
                         CALL TRFOPN (90)
                         CALL TRFOPN (91)
                         CALL DUMP90
                     ENDIF
                  ENDIF
C
                  YINIT = .TRUE.
                  LENPRD = LNTMPR(1)
                  TPCLK = 0
                  IF (TRCDBG .GT. 0) WRITE (LU6, 500) 'START CASE: ', 
     1             XSEED, XSEED2, TRCSD1 + TRCSD2 + TRCSD3, TRCSD1, 
     2             TRCSD2, TRCSD3
C
                  W32 = MOD(FUEL, 10)/2 .EQ. 2
                  W38 = FUELFR .EQ. 5 .OR. FUELFR .EQ. 15 .OR. FUELFR 
     1             .EQ. 4 .OR. FUELFR .EQ. 14
                  IF (W32 .OR. W38) THEN
                     YINIT = .FALSE.
                  ELSE
                     LENPRD = MAX0(LENPRD, 2*IABS(TMINIT)*LENINT)
                     CALL SIMUL()
                  ENDIF
C
C           WRITE MESSAGE AND TRA IF CANNOT ATTAIN EQLBM AS REQUESTED
C
                  IF (YCASE) THEN
                     WRITE (LU6, 1004)
                     IF (YMSDOS) WRITE (*, 2000)
                  ELSE
C
C ---------------------------------------------------------------------
C
C           OUTER LOOP OVER TIME PERIODS
C
C ---------------------------------------------------------------------
C
                     TPCNT = 0
                     IF (TRCDBG .GT. 0) WRITE (LU6, 500) 'FILL-TIME : '
     1                , XSEED, XSEED2, TRCSD1 + TRCSD2 + TRCSD3, 
     2                TRCSD1, TRCSD2, TRCSD3
   40                CONTINUE
                     TPCNT = TPCNT + 1
                     LENPRD = LNTMPR(TPCNT)
                     TPCLK = 0
C
C           GET DATA FOR SUBSEQUENT TIME PERIOD
C
                     IF (TPCNT .GT. 1) CALL PRIME()
C
C ---------------------------------------------------------------------
C
C           INNER LOOP OVER TIME INTERVALS
C
C ---------------------------------------------------------------------
C
                     IF (YMSDOS) WRITE (*, 2002) TPCNT
   60                CONTINUE
                     CALL SIMUL()
                     IF (TRCDBG .GT. 0) WRITE (LU6, 500) 'SIMULATION: '
     1                , XSEED, XSEED2, TRCSD1 + TRCSD2 + TRCSD3, 
     2                TRCSD1, TRCSD2, TRCSD3
                     TICNT = TICNT + 1
                     TPCLK = TPCLK + LENINT
                     GCLK = GCLK + LENINT
                     IPUTCT = IPUTCT + 1
C
C           CHECK IF OUTPUT IS SCHEDULED AT THIS TIME.  IF SO, CALL
C           PUTDAT.  THEN PROVIDE END OF TIME PERIOD OUTPUT FOR AIR 
C           QUALITY MODELING.
C
                     IF (XNODE .GT. 0 .AND. MOD(GCLK,3600) .EQ. 0) THEN
                        CALL PUTDAT()
                        IPUTCT = 0
                     ELSEIF (XNODE .EQ. 0 .AND. IPUTCT .GE. PUTSTD .AND.
     1                       PUTSTD .NE. 0)THEN
                        CALL PUTDAT()
                        IF (TRCDBG .GT. 0) WRITE (LU6, 500) 
     1                   'OUTPUT    : ', XSEED, XSEED2, TRCSD1 + TRCSD2 
     2                   + TRCSD3, TRCSD1, TRCSD2, TRCSD3
                        IPUTCT = 0
                     ENDIF
                     IF (TPCLK .LT. LENPRD .AND. .NOT. YCASE) GOTO 60
C
C           PROVIDE END OF TIME PERIOD DATA, IF OUTPUT HAS NOT ALREADY
C           BEEN PRINTED OR IF NO SIMULATION PERFORMED.
C
                     IF (XNODE .EQ. 0 .AND. ((.NOT. YCASE .AND. 
     1                  IPUTCT .NE. 0) .OR. W32)) 
     2                   CALL PUTDAT()
                     IF (TRCDBG .GT. 0) WRITE (LU6, 500) 'T.P. END  : '
     1                , XSEED, XSEED2, TRCSD1 + TRCSD2 + TRCSD3, 
     2                TRCSD1, TRCSD2, TRCSD3
                     IF ((TPCNT .LT. MAXTP .AND. LNTMPR(TPCNT + 1) .NE. 
     1                0) .AND. .NOT. YCASE) GOTO 40
                  ENDIF
C
C ---------------------------------------------------------------------
C
C           END OF SIMULATION FOR A CASE
C
C ---------------------------------------------------------------------
C
C           WRITE A DELIMITER RECORD ON UNIT CONTAINING SPILLBACK DATA
C           FOR GTRAF.  THIS DELIMITER IS NEEDED FOR THE CASE WHEN NO
C           SPILLBACK HAS OCCURRED.  FOR THIS CASE THE FILE ON UNIT LU44
C           WILL BE EMPTY.  WRITE DELIMTER RECORD ON UNIT 40 TO FLAG
C           CASES ABORTED BEFORE COMPLETION.
C
                  IF (YGRAPH .AND. YSUB(3)) WRITE (LU44, 1020)
               ENDIF
            ENDIF
         ENDIF
C
C           CLOSE GRAPHIC FILES FOR A SUCCESSFUL CASE, OTHERWISE LEAVE
C           THEM OPEN TO PREVENT EXECUTION OF SUBSEQUENT GRAPHIC CASES
C           THAT MAY HAVE SIMILAR ERRORS.
C
         IF (YGRAPH .AND. ERRCT .EQ. 0) THEN
            IF (YTRACE) WRITE (*, *) ' CLOSING GRAPHICS FILES'
            CLOSE (LU42)
            CLOSE (LU43)
            IF (YSUB(3)) THEN
               IF (YTRACE) THEN
                   WRITE (*, *) ' .... NETSIM'
                   WRITE (*, '(A24, 6I3)') 'LU41, 44, 45, 48, 49, 56',
     1                                  LU41,LU44,LU45,LU48,LU49,LU56
               ENDIF
               CLOSE (LU41)
               CLOSE (LU44)
               CLOSE (LU45)
               CLOSE (LU48)
               CLOSE (LU49)
               CLOSE (LU56)
            ENDIF
            IF (YSUB(4)) CLOSE (LU71)
            IF (YSUB(5)) CLOSE (LU55)
            IF (YSUB(6)) CLOSE (LU61)
            IF (YSUB(8)) THEN
                IF (YTRACE) WRITE (*, *) ' .... FRESIM'
                CLOSE (LU90)
                CLOSE (LU91)
            ENDIF
         ENDIF
      ENDIF
C
C -----  INQUIRE IF UNIT 40, THE FILE CONTAINING THE GEOMETRIC
C -----  DATA FOR THE GRAPHICS SOFTWARE, EXISTS.  IF SO, OPEN IT,
C -----  WRITE FILL TIME DURATION AND THE FILE DELIMITER THE CLOSE
C -----  THE FILE.  THE NAME ASSIGNED TO THIS FILE DEPENDS ON THE
C -----  OPERATING SYSTEM AND THE SIMULATION MODEL BEING RUN.  IF
C -----  RUNNING NETSIM THE CASE NAME WILL HAVE THE LETTERS '.F40'
C -----  OR '0' APPENED TO IT FOR DOS AND NON-DOS SYSTEMS,
C -----  RESPECTIVELY.  SIMILARLY, WHEN RUNNING CORFLO THE CASE NAME
C -----  WILL HAVE THE LETTERS '.F50' OR 'G' APPENDED TO IT. EVENTUALLY
C -----  WHEN NETSIM IS COMBINED WITH CORFLO ALL DATA CAN BE ON THE
C -----  SAME UNIT (THE CORFLO UNIT).
C
      IF (YGRAPH) THEN
         IB = INDEX(CASINP, ' ')
         IF (IB .EQ. 0) IB = 9
         IB = IB - 1
         IF (YMSDOS) THEN
            KFILE = CASINP(1:IB)//'.F40'
            IF (YSUB(4) .OR. YSUB(5) .OR. YSUB(6)) KFILE(IB + 1:IB + 4) 
     1       = '.F50'
         ELSE
            KFILE = CASINP(1:IB)//'0'
            IF (YSUB(4) .OR. YSUB(5) .OR. YSUB(6)) KFILE(IB + 1:IB + 4) 
     1       = 'G'
         ENDIF
         INQUIRE (FILE = KFILE, OPENED = WOPEN)
         IF (.NOT. YCASE .AND. ERRCT .EQ. 0) WRITE (LU40, 1024) FILDUR
         IF (WOPEN) THEN
            IF (.NOT. YCASE .AND. ERRCT .EQ. 0) WRITE (LU40, 1020)
            CLOSE (LU40)
         ENDIF
      ENDIF
C
C --- LAST SECTION OF OUTPUT IS FRESIM OFFLINE PROCESSING
C     THIS SECTION IS MOVED TO MODULE TMLFRE
C
C      IF (FROFFL .EQ. 1) THEN
C         CALL PPRCPT()
C         CALL OFFPRT()
C         CALL MOEPRT()
C      ENDIF
C
C --- CALL FOR OD OUTPUT TO BE ANALYZED                      
C --- CALL CONVERT FOR NETSIM OR CORFLO, IF GRAPHICS WAS REQUESTED, 
C --- AND THIS IS THE PC VERSION 
C
      CALL TIMER(IGTIME)
      IF (ERRCT .EQ. 0) THEN
         IF (YSUB(3) .AND. WODOUT) CALL ODPRNT()
         IF (.NOT. WNCNVT .AND. YGRAPH .AND. YMSDOS) CALL GRFCNV
      ENDIF
C
C           LOOP BACK IF ANOTHER CASE AWAITS PROCESSING
C
      IF (TRCDBG .GT. 0) WRITE (LU6, 500) 'CASE-END  : ', XSEED, 
     1 XSEED2, TRCSD1 + TRCSD2 + TRCSD3, TRCSD1, TRCSD2, TRCSD3
C
      IF (NEXTRN .GT. 0 .AND. .NOT. YEOI) GOTO 10
C
      IF (MSGCT .GT. 0) THEN
         WRITE (LU6, 1006) MSGCT, XCASE
         IF (YMSDOS) WRITE (*, 2006) MSGCT, XCASE
      ENDIF
      IF (ERRCT .GT. 0) THEN
         WRITE (LU6, 1005) ERRCT, XCASE
         IF (YMSDOS) WRITE (*, 2001) ERRCT, XCASE
      ENDIF
      IF ((MSGCT .GT. 0) .OR. (ERRCT .GT. 0)) CALL ERTEXT
C
C --- GET END TIME FOR MSDOS VERSION. ADJUST FOR MIDNIGHT CASES
C --- CHECK FOR A CASE WHEN RUN ENDS IN THE SECOND DAY (IF MORE
C --- THAN ONE DAY, THEN THE COMPUTATION IS NOT CORRECT AND SHOULD
C --- BE CORRECTED LATER TO REFLECT THE NUMBER OF DAYS). 5/8/93
C
      IF (YMSDOS) THEN
         CALL TIMER(ETIME)
         IF ((ETIME - ISTIME) .LT. 0) ETIME = ETIME + 8640000
         IF (ITTIME .GT. ISTIME) THEN
            IF ((ITTIME - ISTIME) .LT. 0) ITTIME = ITTIME + 8640000
            WRITE (*, 1026) (ITTIME - ISTIME)/100.
            WRITE (LU6, 1026) (ITTIME - ISTIME)/100.
         ENDIF
         IF ((IGTIME - ISTIME) .LT. 0) IGTIME = IGTIME + 8640000
         WRITE (*, 1025) (IGTIME - ITTIME)/100., (ETIME - ISTIME)/100.
         WRITE (LU6, 1025) (IGTIME - ITTIME)/100., (ETIME - ISTIME)
     1    /100.
      ENDIF
C
      WRITE (LU6, 1012)
C
C -----  READ AIR QUALITY DATA UNIT AND INCLUDE THIS DATA IN TRAF OUTPUT
C -----  FILE. THEN CLOSE UNIT.
C      
      IF (XNODE .GT. 0 .AND. GCLK .GE. 900) THEN
         CALL RDAIR
         CLOSE (LU92)
      ENDIF   
C
      STOP 'END OF PROGRAM'
  500 FORMAT (' ', A12, 'CURRENT SEEDS:', 2I9, '   SEEDS GENERATED=', 
     1 I6, ':', '  (', I6, '+', I6, '+', I6, ')')
 1000 FORMAT ('0', 131('*')//59X, 'START OF CASE ', I3//1X, 131('*'))
 1001 FORMAT ('0ALL DIAGNOSTICS PERFORMED - NO SIMULATION OR TRAFFIC', 
     1 ' ASSIGNMENT REQUESTED')
 1002 FORMAT ('0ALL DIAGNOSTICS PERFORMED - NO SIMULATION REQUESTED')
 1003 FORMAT ('1', 53X, 'TRAF SIMULATION MODEL'//59X, 'DEVELOPED FOR'/
     1 /49X, 'U. S. DEPARTMENT OF TRANSPORTATION'/51X, 
     2 'FEDERAL HIGHWAY ADMINISTRATION'/40X, 
     3 'INTELLIGENT VEHICLE HIGHWAY SYSTEM RESEARCH DIVISION')
 1004 FORMAT ('0CANNOT ATTAIN EQUILIBRIUM AS REQUESTED')
 1005 FORMAT ('0***** THERE WERE', I4, ' ERRORS IN DATA FOR CASE', I3, 
     1 '.')
 1006 FORMAT ('0***** THERE WERE', I4, 
     1 ' WARNING MESSAGES IN DATA FOR CASE', I3, '.')
 1012 FORMAT ('0LAST CASE PROCESSED')
 1020 FORMAT (3(6X, '0'))
 1024 FORMAT (I4)
 1025 FORMAT (' TOTAL CPU TIME FOR SIMULATION =', F10.2, ' SECONDS'/
     1 ' TOTAL CPU TIME FOR THIS RUN =', F10.2, ' SECONDS')
 1026 FORMAT (' TOTAL CPU TIME FOR TA =', F10.2, ' SECONDS')
 2000 FORMAT ('      CANNOT ATTAIN EQUILIBRIUM AS REQUESTED.')
 2001 FORMAT (' **** THERE WERE', I4, ' ERRORS IN DATA FOR CASE', I3, 
     1 '.')
 2002 FORMAT ('      START SIMULATION FOR TIME PERIOD ', I2, '.....')
 2003 FORMAT (' >>> START OF CASE ', I3)
 2004 FORMAT ('      START TRAFFIC ASSIGNMENT.....')
 2006 FORMAT (' **** THERE WERE', I4, 
     1 ' WARNING MESSAGES IN DATA FOR CASE', I3, '.')
 2010 FORMAT (22X, 'ENTRY', 15X, 'EXIT', 9X, 'TRAVEL', 2X, 'START', 2X, 
     1 'END', /, 2X, 'VEH', 4X, 'TYPE', 5X, 'NODE', 5X, 'TIME', 6X, 
     2 'NODE', 5X, 'TIME', 6X, 'TIME', 4X, 'T.P.', 2X, 'T.P.', /)
      END
      SUBROUTINE EXITV (I1)                                              
C                                                                        
C --- CODED    8-01-79 BY M. BURNS                                       
C --- REVISED 11-05-87 BY A. RATHI FOR IDENTICAL TRAFFIC STREAMS         
C --- REVISED  7-27-92 BY J. WERK TO INCLUDE NEW VEHICLE SPECIFIC ARRAYS 
C --- REVISED  3-08-94 BY S. WALKER TO UNPACK BUS ARRAYS
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK CLINK,CODES,SPDLN,TRHDWY,
C ---                                  VLANE,VSTATE AND VTYPE
C --- REVISED  1-07-97 BY M. YEDLIN TO RESET SLOT IN YGLBVH WHEN VEHICLE
C ---                                  LEAVES NETWORK  
C                                                                        
C --- TITLE - DISCHARGE VEHICLE FROM NETWORK - MODULE 3232.3.2           
C                                                                        
C --- FUNCTION - THIS MODULE DISCHARGES THE VEHICLE FROM THE NETWORK.    
C                                                                        
C --- ARGUMENTS - I1     = VEHICLE NUMBER, FROM CALLING ROUTINE          
C                                                                        
C -------------------------   DESCRIPTION   ---------------------------  
C                             -----------                                
C                                                                        
C     THIS MODULE IS CALLED WHEN A VEHICLE IS DISCHARGING TO AN EXIT     
C     LINK. THE VEHICLE SPECIFIC ARRAYS ARE RESET TO ZERO AND THE        
C     TRIP COUNTERS ARE INCREMENTED.                                     
C                                                                        
C -------------------   THIS ROUTINE CALLED BY   ----------------------  
C                       ----------------------                           
C                                                                        
C                    GOQ    - MODULE 3232.3                              
C                                                                        
C ---------------------   THIS ROUTINE CALLS   ------------------------  
C                         ------------------                             
C                                                                        
C                               NONE                                     
C                                                                        
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------   
C                    -------------------------                           
C                                                                        
C     ACCEL   VEHICLE SPECIFIC ARRAY - ACCELERATION                                
C     ACCODE  VEHICLE SPECIFIC ARRAY - ACCEL/DECEL (0/1) CODE
C     BDWELL  BUS SPECIFIC ARRAY - TIME REMAINING IN DWELL                       
C     BLQUE   VEHICLE SPECIFIC ARRAY - CODE IF VEH IN QUEUE BEHIND BLKR
C     BSTRPS  ROUTE-SPECIFIC ARRAY - TOTAL BUS TRIPS                     
C     BUSRT   BUS SPECIFIC ARRAY - BUS ROUTE NUMBER                      
C     DISTUP  VEHICLE SPECIFIC ARRAY - DISTANCE OF VEHICLE FROM          
C             UPSTREAM NODE                                              
C     ENTRTM  VEHICLE SPECIFIC ARRAY - TIME THAT VEHICLE ENTERED         
C             CURRENTLINK, SEC * 10                                      
C     FOLOWR  VEHICLE SPECIFIC ARRAY - NO. OF VEH. BEHIND THIS VEHICLE   
C     IB      BUS VEHICLE NUMBER                                         
C     IBR     BUS ROUTE NUMBER                                           
C     IV      VEHICLE NUMBER                                             
C     JJ      INDEX TO DO LOOP                                           
C     JWORD   FIRST WORD IN XGOALN ARRAY PERTAINING TO VEHICLE IV        
C     LEADER  VEHICLE SPECIFIC ARRAY - NO. OF VEHICLE IN FRONT OF THIS   
C             VEHICLE IN CURRENT LANE                                    
C     LKSTOP  VEHICLE SPECIFIC ARRAY - CODE WHETHER VEH STOPS ON LINK                                 
C     LSWCH   VEHICLE SPECIFIC ARRAY - CODE IF VEH CHANGED LANES AROUND BLKR
C     NBUSIV  VEHICLE SPECIFIC ARRAY - BUS NUMBER                         
C     NDRVRC  VEHICLE SPECIFIC ARRAY - DRIVER TYPE, 1-10
C     NETGVH  VEHICLE SPECIFIC ARRAY - GLOBAL IDENTIFICATION NUMBER
C     NFLEET  VEHICLE SPECIFIC ARRAY - FLEET COMPONENT CODE
C     NVHCDE  VEHICLE SPECIFIC ARRAY - VEHICLE PROCESS CODE
C     NVHLNK  ARRAY OF LINK NUMBERS OCCUPIED BY EACH VEHICLE
C     NVHTYP  VEHICLE SPECIFIC ARRAY - VEHICLE TYPE CODE, 1-16                
C     NLANE   VEHICLE SPECIFIC ARRAY - LANE OCCUPIED                                 
C     PNTER   BUS SPECIFIC ARRAY - POINTER TO MANUVR ARRAY               
C     PREVLN  VEHICLE SPECIFIC ARRAY - LANE ON PREVIOUS LINK
C     PREVTC  VEHICLE SPECIFIC ARRAY - TURN CODE ON PREVIOUS LINK
C     PRFDLN  VEHICLE SPECIFIC ARRAY - PREFERRED LANE
C     PRVGLN  VEHICLE SPECIFIC ARRAY - PREVIOUS GOAL LANES AND TURN CODE
C     PRVLNK  VEHICLE SPECIFIC ARRAY - PREVIOUS LINK (BITS 1-9)
C     SPDLN   VEHICLE SPECIFIC ARRAY - VEHICLE SPEED, FT/SEC                                
C     TCODE   VEHICLE SPECIFIC ARRAY - TURN MOVEMENT CODE
C     TIMDIS  VEHICLE SPECIFIC ARRAY - TIME REMAINING UNTIL DISCHARGE
C     VCHNG   VEHICLE SPECIFIC ARRAY - REMAIN TIME TO CHK FOR LANE CHNG, 
C             INT BET LANE CHNGES, (1,0) IF (IN, NOT IN) GOAL LANE,      
C             POINTER TO VLNCHG ARRAY, FLAG IF VEH MUST SLOW TO ALLOW    
C             LANE CHANGER IN FRONT                                      
C     VFFSPD  VEHICLE SPECIFIC ARRAY - DESIRED FREE FLOW SPEED                                
C     VHLANE  VEHICLE SPECIFIC ARRAY - TARGET LANE, GOAL LANES, FLAG IF  
C             DRIVER IS COOP. TO A LANE CHANGER, REMAIN TIME TO CHNGE    
C     VPATH   VEHICLE SPECIFIC ARRAY - POINTER TO XIPATH ARRAY AND FIELD 
C             WITHIN XIPATH DESCRIBING VEHICLE'S CURRENT TURN MOVEMENT   
C     VSTATE  VEHICLE SPECIFIC ARRAY - VEHICLE STATUS                               
C     XGOALN  VEHICLE SPECIFIC ARRAY - CURRENT GOAL LANE OF VEHICLE IV   
C             ON ALL LINKS IN PATH                                       
C     XVETRP  CUMULATIVE NUMBER OF VEHICLE TRIPS IN ENTIRE NETWORK       
C     XVSEED  VEHICLE SPECIFIC ARRAY - RANDOM NUMBER SEED                
C     XVTRPN  CUMULATIVE NUMBER OF VEHICLE TRIPS IN SUBNETWORK           
C     YGLBVH  GLOBAL VEHICLE SPECIFIC ARRAY - (T,F) IF THE VEHICLE ID
C             (IS, IS NOT) ASSIGNED
C                                                                        
C ---------------------------------------------------------------------  
C                                                                        
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)        
C                                                                        
      INCLUDE 'GLOBAL.INC'
      INCLUDE 'NETSIM.INC'
C                                                                        
      IV = I1                                                            
C                                                                        
C -----  INCREMENT SUBNETWORK AND NETWORK WIDE TRIP COUNTERS             
C                                                                        
      XVTRPN = XVTRPN + 1                                                
      XVETRP = XVETRP + 1                                                
C                                                                        
C -----  UPDATE BUS STATISTICS IF DISCHARGING VEHICLE IS A BUS.          
C                                                                        
      IB = NBUSIV(IV)                                   
      IF (IB .EQ. 0)                                         GO TO 10    
      PNTER(IB) = 0                                                      
      IBR = BUSRT(IB)                                                    
      BUSRT(IB) = 0                                                      
      BDWELL(IB) = 0                                                      
      BSTRPS(IBR) = BSTRPS(IBR) + 1                                      
   10 CONTINUE                                                           
C                                                                        
C -----  DISCHARGE VEHICLE FROM NETWORK                                  
C                                                                        
      ACCEL (IV) = 0                                                     
      ACCODE(IV) = 0                                                     
      BLQUE(IV)  = 0                                                      
      DISTUP(IV) = 0                                                     
      ENTRTM(IV) = 0                                                     
      FOLOWR(IV) = 0                                                     
      LEADER(IV) = 0                                                     
      LKSTOP(IV) = 0                                                     
      LSWCH(IV)  = 0                                                      
      NBUSIV(IV) = 0                                                     
      NDRVRC(IV) = 0                                                     
      NFLEET(IV) = 0                                                     
      NVHCDE(IV) = 0                                                     
      NVHLNK(IV) = 0                                                     
      NVHTYP(IV) = 0                                                      
      NLANE(IV)  = 0                                                     
      PREVLN(IV) = 0                                                      
      PREVTC(IV) = 0                                                      
      PRFDLN(IV) = 0                                                      
      PRVGLN(IV) = 0
      PRVLNK(IV) = 0
      SPDLN (IV) = 0                                                     
      TCODE (IV) = 0                                                     
      TIMDIS(IV) = 0
      VCHNG (IV) = 0                                                     
      VFFSPD(IV) = 0                                                     
      VHLANE(IV) = 0                                                     
      VPATH (IV) = 0                                                     
      VSTATE(IV) = 0                                                     
      XVSEED(IV) = 0                                                     
      YGLBVH(NETGVH(IV)) = .FALSE.
      NETGVH(IV) = 0
      JWORD = 3 * IV - 2                                                 
        DO 20 JJ = JWORD, JWORD + 2                                      
           XGOALN(JJ) = 0                                                
   20   CONTINUE                                                         
C                                                                        
      RETURN                                                             
      END                                                                
      SUBROUTINE EXTRCT (IV, IL)
C
C --- CODED   10-22-79 BY M. BURNS
C --- REVISED 11-04-87 BY A. RATHI FOR IDENTICAL TRAFFIC STREAMS
C --- REVISED  3-26-88 BY O. SHARAF-ELDIEN TO REMOVE REDUNDANT ARRAYS
C --- REVISED 12-13-88 BY A. KANAAN TO REMOVE SPLIT OF ENTRTM & TRVLTM
C --- REVISED 12-09-90 BY H. CHEN TO COMPUTE MOV-SPEC. STAT UNCNDTNLY
C --- REVISED  6-30-92 BY J. WERK TO CLEAR NEW VEHICLE ARRAYS ASSOCIATED 
C ---                        WITH LANE CHANGE LOGIC                      
C --- REVISED  3-05-93 BY A. PHLEGAR TO CALL DEST FOR O-D
C --- REVISED  3-08-94 BY S. WALKER TO UNPACK BUS ARRAYS
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK CLINK, CODES, SPDLN, 
C ---                        TRHDWY, VLANE, VSTATE AND VTYPE
C --- REVISED  1-07-97 BY M. YEDLIN TO RESET SLOT IN YGLBVH WHEN VEHICLE
C ---                                  LEAVES NETWORK  
C
C --- TITLE - REMOVE A VEHICLE FROM A LINK VIA SINK NODE
C ---          - MODULE 3232.4432
C
C --- FUNCTION - THIS MODULE WILL REMOVE VEHICLE, IV, FROM LINK, IL,
C ---            VIA SINK NODE ON THIS LINK.
C
C --- ARGUMENTS - IV     = SUBJECT VEHICLE, FROM CALLING ROUTINE.
C ---             IL     = LINK NUMBER, FROM CALLING ROUTINE
C
C -------------------------   DESCRIPTION   ---------------------------
C                             -----------
C
C     THIS MODULE EXTRACTS THE SUBJECT VEHICLE FROM LINK, IL. IT WILL
C     BE NECESSARY TO UPDATE THE ELAPSED TIME SINCE LAST EXTRACTION.
C     THE VEHICLE CHAIN MUST BE ADJUSTED AND THE LINK COUNTERS
C     DECREMENTED. WHEN THIS IS DONE, ALL VEHICLE SPECIFIC ARRAYS WILL
C     BE CLEARED FOR VEHICLE, IV.
C
C -------------------   THIS ROUTINE CALLED BY   ----------------------
C                       ----------------------
C
C                    TSTATV - MODULE 3232.4.4.3
C
C ---------------------   THIS ROUTINE CALLS   ------------------------
C                         ------------------
C
C                               DEST
C
C ----------------   GLOSSARY OF VARIABLE NAMES   ---------------------
C                    --------------------------
C
C     ACCEL   VEHICLE SPECIFIC ARRAY - ACCELERATION
C     ACCODE  VEHICLE SPECIFIC ARRAY - ACCEL/DECEL (0/1) CODE 
C     BLQUE   VEHICLE SPECIFIC ARRAY - CODE IF VEH IN QUEUE BEHIND BLKR
C     CLOCK   ELAPSED TIME SINCE BEGINNING OF SIMULATION, SECS
C     CNTENT  LINK SPECIFIC ARRAY - NO. VEHICLES CURRENTLY ON LINK
C     CUMVEH  LINK SPECIFIC ARRAY - NO. VEHICLES DISCHARGED SINCE
C             BEGINNING OF SIMULATION
C     CUMVL   LINK SPECIFIC ARRAY - NO. OF LEFT TURN DSCHG. VEHS.
C     CUMVR   LINK SPECIFIC ARRAY - NO. OF RIGHT TURN DSCHG. VEHS.
C     DISTUP  VEHICLE SPECIFIC ARRAY - DIST. FROM UPSTREAM NODE
C     EHDWY   LINK SPECIFIC ARRAY - EXTRACTION HEADWAY, SEC * 10
C     ENTRTM  VEHICLE SPECIFIC ARRAY - TIME VEHICLE ENTERED LINK,
C             SEC * 10
C     FOLOWR  VEHICLE SPECIFIC ARRAY - VEH. FOLLOWING SUBJECT VEHICLE
C     I       INDEX TO DO LOOP
C     IFV     VEHICLE FOLLOWING SUBJECT VEHICLE
C     ILV     VEHICLE IN FRONT OF SUBJECT VEHICLE
C     ITURN   CURRENT TURN CODE
C     ITYP    VEHICLE TYPE CODE + 1
C     JTIME   TRAVEL TIME ON LINK, SEC*10
C     JWORD   FIRST WORD IN XGOALN ARRAY PERTAINING TO VEHICLE IV
C     K       INDEX TO LANEV AND LANEF ARRAYS
C     KTIME   TRAVEL TIME OF VEHICLE, IV, ON LINK, IL (SECONDS)
C     LANEF   LINK SPECIFIC ARRAY - FIRST VEHICLE IN LNAE
C     LANEV   LINK SPECIFIC ARRAY - LAST VEHICLE IN LANE
C     LEADER  VEHICLE SPECIFIC ARRAY - VEH. IN FRONT OF SUBJECT VEHICLE
C     LKSTOP  VEHICLE SPECIFIC ARRAY - CODE WHETHER VEH STOPS ON LINK 
C     LSWCH   VEHICLE SPECIFIC ARRAY - CODE IF VEH CHANGED LANES AROUND BLKR
C     NBUSIV  VEHICLE SPECIFIC ARRAY - BUS NUMBER                         
C     NDRVRC  VEHICLE SPECIFIC ARRAY - DRIVER TYPE, 1-10
C     NETGVH  VEHICLE SPECIFIC ARRAY - GLOBAL IDENTIFICATION NUMBER
C     NEXTE   LINK SPECIFIC ARRAY - TIME ELAPSED SINCE EXTRACTION AT
C             SINK NODE, SEC * 10
C     NFLEET  VEHICLE SPECIFIC ARRAY - FLEET COMPONENT CODE 
C     NVHCDE  VEHICLE SPECIFIC ARRAY - PROCESS CODE
C     NVHLNK  ARRAY OF LINK NUMBERS OCCUPIED BY EACH VEHICLE
C     NVHTYP  VEHICLE SPECIFIC ARRAY - VEHICLE TYPE CODE, 1-16
C     NLANE   VEHICLE SPECIFIC ARRAY - LANE OCCUPIED 
C     PREVLN  VEHICLE SPECIFIC ARRAY - LANE ON PREVIOUS LINK
C     PREVTC  VEHICLE SPECIFIC ARRAY - TURN CODE ON PREVIOUS LINK
C     PRFDLN  VEHICLE SPECIFIC ARRAY - PREFERRED LANE
C     PRVGLN  VEHICLE SPECIFIC ARRAY - PREVIOUS GOAL LANES AND TURN CODE
C     PRVLNK  VEHICLE SPECIFIC ARRAY - PREVIOUS LINK (BITS 1-9)
C     SINK    LINK SPECIFIC ARRAY - NUMBER OF VEHICLES EXTRACTED AT
C             SINK NODE
C     SPDLN   VEHICLE SPECIFIC ARRAY - SPEED, FT/SEC 
C     TCODE   VEHICLE SPECIFIC ARRAY - TURN MOVEMENT CODE
C     TIMDIS  VEHICLE SPECIFIC ARRAY - TIME REMAINING TO DISCHARGE 
C             FROM HEAD OF QUEUE
C     TRVLL   LINK SPECIFIC ARRAY - TTL LEFT TURN VEH TRVL TIME, SEC
C     TRVLR   LINK SPECIFIC ARRAY - TTL RIGHT TURN VEH TRVL TIME, SEC
C     TRVLTM  LINK SPECIFIC ARRAY - TOTAL TRAVEL TIME ON LINK, SEC
C     VCHNG   VEHICLE SPECIFIC ARRAY - REMAIN TIME TO CHK FOR LANE CHNG, 
C             INT BET LANE CHNGES, (1,0) IF (IN, NOT IN) GOAL LANE,      
C             POINTER TO VLNCHG ARRAY, FLAG IF VEH MUST SLOW TO ALLOW    
C             LANE CHANGER IN FRONT                                      
C     VFFSPD  VEHICLE SPECIFIC ARRAY - DESIRED FREE-FLOW SPEED 
C     VHLANE  VEHICLE SPECIFIC ARRAY - TARGET LANE, GOAL LANES, FLAG IF  
C             DRIVER IS COOP. TO A LANE CHANGER, REMAIN TIME TO CHNGE    
C     VSTATE  VEHICLE SPECIFIC ARRAY - STATUS CODE
C     VTYPLD  VEHICLE TYPE ARRAY - PERSON OCCUPANCY * 100
C     WODOUT  FLAG (T,F) IF O/D OUTPUT (IS, IS NOT) REQUESTED
C     XPERS   LINK SPECIFIC ARRAY - CUM. PERSON TRIPS * 100
C     XVETRP  CUMULATIVE NUMBER OF TRIPS COMPLETED ON THE NETWORK
C     XVSEED  VEHICLE SPECIFIC ARRAY - RANDOM NUMBER SEED
C     XVTRPN  CUMULATIVE NUMBER OF TRIPS COMPLETED ON NETSIM SUBNETWORK
C     YGLBVH  GLOBAL VEHICLE SPECIFIC ARRAY - (T,F) IF THE VEHICLE ID
C             (IS, IS NOT) ASSIGNED
C
C ---------------------------------------------------------------------
C
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)
C
      INCLUDE 'GLOBAL.INC'
      INCLUDE 'NETSIM.INC'
C
C -----  CALL SUBROUTINE DEST TO PRINT O-D INFORMATION
C
      IF (WODOUT) CALL DEST (IV, IL)
C
C -----  UPDATE LINK STATISTICS TO REFLECT EXTRACTION OF VEHICLE.
C
      CUMVEH(IL) = CUMVEH(IL) + 1
      SINK(IL) = SINK(IL) + 1
      CNTENT(IL) = MAX0(CNTENT(IL)-1, 0)
      ITYP  = NVHTYP(IV) 
      XPERS(IL) = XPERS(IL) + VTYPLD(ITYP)
      ITURN = TCODE(IV)
      IF (ITURN .EQ. 0) CUMVL(IL) = CUMVL(IL) + 1
      IF (ITURN .EQ. 2) CUMVR(IL) = CUMVR(IL) + 1
C
C -----  INCREMENT NETWORK AND SUBNETWORK DISCHARGING VEHICLE COUNTERS
C
      XVETRP = XVETRP + 1
      XVTRPN = XVTRPN + 1
C
C -----  STORE TRAVEL TIME ON LINK AND DECREMENT TIME SINCE LAST
C -----  EXTRACTION.
C
      JTIME = CLOCK*10 - ENTRTM(IV)
      TRVLTM(IL) = TRVLTM(IL) + (JTIME + 5) / 10
      KTIME = (JTIME + 5) / 10
      IF (ITURN .EQ. 0) TRVLL(IL) = TRVLL(IL) + KTIME
      IF (ITURN .EQ. 2) TRVLR(IL) = TRVLR(IL) + KTIME
      NEXTE(IL) = NEXTE(IL) + EHDWY(IL)
C
C -----  ADJUST CHAIN ON CURRENT LINK TO REFLECT SINK EXTRACTION.
C
      IFV = FOLOWR(IV)
      ILV = LEADER(IV)
      IF (ILV .GT. 0)  FOLOWR(ILV) = IFV
      IF (IFV .GT. 0) LEADER(IFV) = ILV
      K = 7 * (IL - 1) + NLANE(IV) 
      IF (IFV .EQ. 0) LANEV(K) = ILV
      IF (ILV .EQ. 0) LANEF(K) = IFV
C
C -----  CLEAR ALL VEHICLE ARRAYS FOR VEHICLE, IV.
C
      ACCEL (IV) = 0
      ACCODE(IV) = 0
      BLQUE(IV)  = 0
      DISTUP(IV) = 0
      ENTRTM(IV) = 0
      FOLOWR(IV) = 0
      LEADER(IV) = 0
      LKSTOP(IV) = 0
      LSWCH(IV)  = 0
      NBUSIV(IV) = 0
      NDRVRC(IV) = 0
      NFLEET(IV) = 0
      NVHCDE(IV) = 0
      NVHLNK(IV) = 0
      NLANE(IV)  = 0
      NVHTYP(IV) = 0
      PREVLN(IV) = 0
      PREVTC(IV) = 0
      PRFDLN(IV) = 0
      PRVGLN(IV) = 0
      PRVLNK(IV) = 0
      SPDLN (IV) = 0                                                     
      TCODE (IV) = 0
      TIMDIS(IV) = 0
      VCHNG (IV) = 0                                                     
      VFFSPD(IV) = 0
      VHLANE(IV) = 0                                                     
      VSTATE(IV) = 0
      XVSEED(IV) = 0
      YGLBVH(NETGVH(IV)) = .FALSE.
      NETGVH(IV) = 0
      JWORD = 3 * IV - 2
      DO 10 I = JWORD, JWORD + 2
            XGOALN(I) = 0
   10 CONTINUE
C
      RETURN
      END
      SUBROUTINE CHAIN                                                  
C                                                                       
C --- CODED   10-05-79 BY E. LIEBERMAN                                  
C --- REVISED  4-01-88 BY O. SHARAF-ELDIEN FOR ADDED CHECKS AND CODE    
C ---                                      CLEANUP.                     
C --- REVISED  5-27-88 BY O. SHARAF-ELDIEN TO SUPPRESS MESSAGES IF DEBUG
C ---                                      OPTION IS NOT IN EFFECT      
C --- REVISED 12-13-88 BY A. KANAAN TO REMOVE SPLIT OF ENTRTM(IV)       
C --- REVISED 12-12-90 BY A. KANAAN VEHICLE ID TRACING                  
C --- REVISED  5-14-92 BY J. WERK TO MAX THE DISTANCE OF A VEHICLE WHICH
C ---                        CRASHES INTO ITS LEADER TO 1.              
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK CLINK, CODES, SPDLN,      
C ---                        VSTATE, VTYPE AND VTYPLS                   
C --- REVISED 11-27-98 BY M. YEDLIN TO FIX ADJUSTMENT TO DISTUP SO THAT
C ---                        DISTUP(IV) IS NEVER SET TO 0
C                                                                       
C --- TITLE - CHECK INTEGRITY OF ALL VEHICLE CHAINS - MODULE 3234.1     
C                                                                       
C --- FUNCTION - THIS ROUTINE CHECKS THE VEHICLE CHAIN ON EACH LANE OF  
C ---            EACH LINK. IF AT LEAST ONE CHAIN IS BROKEN, THEN       
C ---            ROUTINE RESCHN IS CALLED TO RESTORE ALL CHAINS         
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE LOOPS OVER ALL LINKS AND LANES. ON EACH LANE, IT     
C     SCANS EACH VEHICLE STARTING AT THE UPSTREAM END AND JUMPING ALONG 
C     THE VEHICLE CHAIN TO THE LEADER. THE LINK, LANE, PROCESS CODE,    
C     CONTINUITY OF THE QUEUE AND INTEGRITY OF THE CHAIN ARE CHECKED    
C     FOR VALIDITY. IF AN ERROR IS LOCATED, A MESSAGE IS WRITTEN        
C     IDENTIFYING IT AND ROUTINE RESCHN IS CALLED TO RESTORE ALL CHAINS 
C                                                                       
C --------------------  THIS ROUTINE CALLED BY  ------------------------
C                       ----------------------                          
C                                                                       
C                    CLNUP  - MODULE 3.2.3.4                            
C                                                                       
C ---------------------   THIS ROUTINE CALLS   -------------------------
C                         ------------------                            
C                                                                       
C                    RESCHN - MODULE 3234.1.1                           
C                                                                       
C ------------------   GLOSSARY OF VARIABLE NAMES  -------------------- 
C                      --------------------------                       
C                                                                       
C     CLOCK   ELAPSED SIMULATION TIME, SECS                             
C     DISTUP  VEHICLE SPECIFIC ARRAY - DISTANCE FROM UPSTREAM NODE      
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER              
C     ENTRTM  VEHICLE SPECIFIC ARRAY - CLOCK TIME WHEN VEHICLE ENTERED  
C             LINK, SEC *10                                             
C     FOLOWR  VEHICLE SPECIFIC ARRAY - FOLLOWER VEHICLE NUMBER          
C     I       TEMPORARY STORAGE                                         
C     IACC    ACCELERATION                                              
C     IB      BUS NUMBER                                                
C     ID      DOWNSTREAM NODE NUMBER OF LINK, IL                        
C     IDRVR   DRIVER CODE                                               
C     IFSPD   FREE-FLOW SPEED                                           
C     IFV     FOLLOWING VEHICLE NUMBER                                  
C     IH      REMAINING HEADWAY, SEC * 10                               
C     IL      LINK NUMBER                                               
C     ILN     LANE NUMBER                                               
C     ILV     LEAD VEHICLE NUMBER                                       
C     ISPD    CURRENT SPEED                                             
C     ISTATE  STATUS CODE OF VEHICLE, IV                                
C     ISTP    STOP CODE                                                 
C     ITURN   TURN CODE                                                 
C     ITYP    TYPE CODE                                                 
C     IU      UPSTREAM NODE NUMBER OF LINK, IL                          
C     IV      VEHICLE NUMBER                                            
C     JD      DOWNSTREAM NODE OF LINK, JL                               
C     JFV     VEHICLE FOLLOWING THE LEAD VEHICLE, ILV                   
C     JL      LINK ON WHICH VEHICLE, IV, IS LOCATED                     
C     JLN     LANE ON WHICH VEHICLE, IV, IS LOCATED                     
C     JLV     VEHICLE LEADING THE FOLLOWER VEHICLE, IFV                 
C     JSTATE  STATUS CODE OF VEHICLE, IVL                               
C     JU      UPSTREAM NODE OF LINK, JL                                 
C     JV      FIRST VEHICLE ON SUBJECT LANE                             
C     K       INDEX TO LANEV ARRAY                                      
C     KD      USER-SPECIFIED DOWNSTREAM NODE NUMBER                     
C     KL      USERS LINK NUMBER                                         
C     KU      USER-SPECIFIED UPSTREAM NODE NUMBER                       
C     LANEF   LINK SPECIFIC ARRAY - FIRST VEHICLE IN LANE               
C     LANEV   LINK SPECIFIC ARRAY - LAST VEHICLE IN LANE                
C     LEADER  VEHICLE SPECIFIC ARRAY - LEAD VEHICLE NUMBER              
C     LINK    ARRAY OF SUBNETWORK SPECIFIC INDICES FOR LINK MAPPING     
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     NMAP    ARRAY OF SPECIFIED NODE NUMBERS                           
C     NVHCDE  VEHICLE SPECIFIC ARRAY - PROCESS CODE                     
C     NVHLNK  ARRAY OF LINK NUMBERS OCCUPIED BY EACH VEHICLE            
C     NVHTYP  VEHICLE TYPE ARRAY - VEHICLE TYPE CODE, 1-16              
C     NLANE   VEHICLE SPECIFIC ARRAY - LANE OCCUPIED                    
C     SDCODE  LINK SPECIFIC ARRAY - SIGNAL CODE FACING LINK             
C     TTLILK  TOTAL NUMBER OF INTERNAL NETWORK LINKS                    
C     TTLNK   TOTAL NUMBER OF LINKS IN SUBNETWORK                       
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBERS               
C     VEHID   VEHICLE ID TO BE TRACED                                   
C     VRPATH  VEHICLE SPECIFIC ARRAY - INDEX TO XREBP ARRAY IDENTIFYING 
C             CURRENT REB OCCUPIED BY THE VEHICLE (0 FOR NOT IN         
C             INTERSECTION)                                             
C     VSTATE  VEHICLE SPECIFIC ARRAY - STATUS CODE                      
C     VTYPLE  VEHICLE TYPE ARRAY - EFFECTIVE VEHICLE LENGTH             
C     V       STRING FOR OUTPUT PRINT OF TIME, LINK AND LANE            
C     W       FLAG, SET TO TRUE IF VEHICLE NOT PROCESSED                
C     WD      FLAG, SET TO TRUE IF MESSAGE IS TO BE PRINTED             
C     WBAD    FLAG = (.T.,.F.) IF ERROR (IS, IS NOT) LOCATED            
C     WQ      FLAG = (.T.,.F.) IF A QUEUED VEHICLE (DOES, DOES NOT)     
C             FOLLOW A NON-QUEUED VEHICLE                               
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C ---- THE FOLLOWING COMMON WAS SPLIT INTO 3 COMMON TO                  
C ---- FOLLOW NAMING CONVENTION FOR TRAF. BY AK 5/2/93                  
C                                                                       
C     COMMON /GLR887/ SD1,SD2,SD3,DBG                                   
C                                                                       
C                                                                       
      CHARACTER*48 V                                                    
C                                                                       
C -----  RESET FLAG, THEN LOOP OVER ALL INTERNAL LINKS AND LANES        
C                                                                       
      WD   = TRCDBG .GT. 0                                              
      WBAD = .FALSE.                                                    
      V = ' *CHAIN BREAK AT      ON LINK(    ,    ) LANE   '            
      WRITE( V(17:21), '(I5)') CLOCK                                    
      DO 60 KL = 1, TTLNK                                               
         IL = LINK(KL)                                                  
         IF (IL .GT. TTLILK)                                 GO TO 60   
         IU = UPNOD(IL)                                                 
         IF (IU .LT. 7000) IU = NMAP(IU)                                
         ID = DWNOD(IL)                                                 
         IF (ID .LT. 7000) ID = NMAP(ID)                                
         WRITE( V(31:34), '(I4)') IU                                    
         WRITE( V(36:39), '(I4)') ID                                    
         K = 7 * (IL - 1)                                               
C                                                                       
C -----  CHECK INTEGRITY OF LANEF, LANEV, ARRAYS. TRA IF NO             
C -----  VEHICLE IN LANE, ILN. ELSE, LOOP OVER ALL VEHICLES.            
C                                                                       
         DO 40 ILN = 1, 7                                               
            K = K + 1                                                   
            WRITE( V(46:47), '(I2)') ILN                                
            IV = LANEV(K)                                               
            JV = LANEF(K)                                               
            W = IV.EQ. 0 .AND. JV .GT. 0                                
            IF (W.AND.WD) WRITE (LU6,1100) V, JV                        
            WBAD = W .OR. WBAD                                          
            IF (IV .EQ. 0)                                   GO TO 40   
C                                                                       
C -----  CHECK THAT LAST VEHICLE IN LANE DOES NOT HAVE A FOLLOWER       
C                                                                       
            IFV = FOLOWR(IV)                                            
            W = IFV .GT. 0                                              
            IF (W.AND.WD) WRITE (LU6,1000) V, IFV, LEADER(IFV)          
            WBAD = W .OR. WBAD                                          
C                                                                       
C -----  GET LEAD VEHICLE NUMBER AND FOLLOWER VEHICLE NUMBER            
C -----  CHECK THAT VEHICLE-SPECIFIC LINK, LANE LOCATION CORRECT        
C -----  AND THAT ITS PROCESS CODE IS SET. SET FLAG AND WRITE           
C -----  MESSAGE, IF NOT                                                
C -----  PRINT  VEHICLE INFORMATION, IF REQUESTED                       
C                                                                       
   10       CONTINUE                                                    
            ILV = LEADER(IV)                                            
            IFV = FOLOWR(IV)                                            
            JL = NVHLNK(IV)                                             
            IF(IV.EQ.VEHID) WRITE(LU6,1200) IV,ILV,IFV,JL,CLOCK         
            IF (JL .EQ. IL)                                  GO TO 20   
            JD = DWNOD(JL)                                              
            JU = UPNOD(JL)                                              
            IF (JU .LT. 7000) JU = NMAP(JU)                             
            IF (JD .LT. 7000) JD = NMAP(JD)                             
            IF (WD) WRITE (LU6, 1010) V, IV, JU, JD                     
            WBAD = .TRUE.                                               
   20       CONTINUE                                                    
            JLN = NLANE(IV)                                             
            W = JLN .NE. ILN                                            
            IF (W.AND.WD) WRITE (LU6, 1020) V, IV, JLN                  
            WBAD = W .OR. WBAD                                          
            W = NVHCDE(IV) .LT. 1 .AND. ENTRTM(IV) .LE. CLOCK*10        
            IF (W.AND.WD) WRITE (LU6, 1030) V, IV                       
            WBAD = W .OR. WBAD                                          
            ISTATE = VSTATE(IV)                                         
C                                                                       
C -----  CHECK FOR CONTINUITY OF QUEUED VEHICLES. IF VIOLATED,          
C -----  WRITE MESSAGE AND REMOVE VEHICLE FROM QUEUE STATUS             
C                                                                       
            JSTATE = 1                                                  
            IF (ILV.GT.0) JSTATE = VSTATE(ILV)                          
            WQ = (ISTATE / 3 .NE. 1 .AND. ISTATE .GT. 0) .AND.          
     1           (JSTATE / 3 .EQ. 1 .OR.  JSTATE .EQ. 0)                
            IF (WQ.AND.WD) WRITE (LU6, 1040) V, IV, ILV                 
            IF (WQ) VSTATE(IV) = 0                                      
C                                                                       
C -----  CHECK THAT SUBJECT, AND LEADER, VEHICLES SEE ONE ANOTHER       
C                                                                       
            JFV = IV                                                    
            IF (ILV .GT. 0) JFV = FOLOWR(ILV)                           
            W = JFV .NE. IV                                             
            IF (W.AND.WD) WRITE (LU6, 1050) V, IV, ILV, JFV             
            WBAD = W .OR. WBAD                                          
C                                                                       
C -----  CHECK THAT VEHICLE DOES NOT CRASH INTO ITS LEADER              
C                                                                       
            IF (ILV .GT. 0 .AND. VRPATH(IV) .EQ. 0) THEN                
               JT  = NVHTYP(ILV)                                        
               JDS = DISTUP(ILV) - VTYPLE(JT)                           
               IDS = DISTUP(IV)                                         
               W   = IDS .GT. JDS                                       
               IF (W.AND.WD) WRITE (LU6, 1080) V, IV, ILV, IDS-JDS, IDS 
               IF (W) DISTUP(IV) = MAX0 (JDS, 1)                        
            ENDIF                                                       
C                                                                       
C -----  CHECK THAT SUBJECT, AND FOLLOWER, VEHICLES SEE ONE ANOTHER     
C                                                                       
            JLV = IV                                                    
            IF (IFV .GT. 0) JLV = LEADER(IFV)                           
            W = JLV .NE. IV                                             
            IF (W.AND.WD) WRITE (LU6, 1060) V, IV, IFV, JLV             
            WBAD = W .OR. WBAD                                          
C                                                                       
C -----  ALL TESTS ON VEHICLE, IV, ARE COMPLETED. TRA IF ITS            
C -----  LEADER, ILV, EXISTS                                            
C                                                                       
            IF (ILV.GT.0) IV = ILV                                      
            IF (ILV .GT. 0)                                  GO TO 10   
C                                                                       
C -----  CHECK THAT FIRST VEHICLE IN LANE IS CORRECT                    
C                                                                       
            W = IV .NE. JV                                              
            IF (W.AND.WD) WRITE (LU6, 1070) V, IV, JV                   
            WBAD = W .OR. WBAD                                          
   40    CONTINUE                                                       
   60 CONTINUE                                                          
C                                                                       
C -----  ALL LINKS IN THE NETWORK WERE PROCESSED. IF ANY ERROR WAS      
C -----  LOCATED, CALL MOCULE 3234.1.1 TO CORRECT ALL VEHICLE CHAINS.   
C                                                                       
      IF (WBAD) CALL RESCHN                                             
C                                                                       
      RETURN                                                            
C                                                                       
 1000 FORMAT(A48,'LAST VEHICLE',I4,' WAS FOLLOWED BY VEHICLE',I4,       
     1       ' WHICH HAS A LEADER',I4)                                  
 1010 FORMAT(A48,'VEHICLE',I4,'WAS ALLOCATED TO LINK (',I4,',',I4,      
     1       ') INSTEAD')                                               
 1020 FORMAT(A48,'VEHICLE',I4,'WAS LOCATED ON LANE',I2,' INSTEAD')      
 1030 FORMAT(A48,'VEHICLE',I4,' WAS NOT PROCESSED IN CURRENT TIME STEP')
 1040 FORMAT(A48,'VEHICLE',I4,' WAS IN QUEUE WHILE ITS LEADER',I4,      
     1       ' WAS NOT')                                                
 1050 FORMAT(A48,'LEADER OF VEHICLE',I4,' IS',I4,' WHICH HAS',I4,       
     1       ' AS A FOLLOWER')                                          
 1060 FORMAT(A48,'FOLLWOER OF VEHICLE',I4,' IS',I4,' WHICH HAS',I4,     
     1       ' AS A LEADER')                                            
 1070 FORMAT(A48,'LEAD VEHICLE',I4,' IS NOT IDENTIFIED AS SUCH - LANEF='
     1       ,I4)                                                       
 1080 FORMAT(A48,'VEHICLE',I4,' CRASHED INTO ITS LEADER',I4,' BY',I4,   
     1       ' FT  AT',I5,' FT')                                        
 1100 FORMAT(A48,'HAS NO LAST VEHICLE, BUT THERE IS A LEAD VEHICLE',I4) 
 1200 FORMAT('0   CHAIN:IV,ILV,IFV,LNK,CLOCK',5I5)                      
C                                                                       
      END                                                               
