      SUBROUTINE LTAVE
C***********************************************************************
C                 LTAVE Module of ISC Model - Long Term
C
C        PURPOSE: Calculates PERIOD Averages from Available STAR Summaries
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Array of CONC or DEPOS Values,
C                 SRCVAL(IREC,ISRC)
C
C        OUTPUTS: Array of CONC or DEPOS Values for PERIOD
C
C        CALLED FROM:   LTPER
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'

C     Variable Initializations
      MODNAM = 'LTAVE'

      SNUMI = 1./NUMAVE

C     Begin Source Group LOOP
      DO 2000 ISRC = 1, NUMSRC
C        Begin Receptor LOOP
         DO 1000 IREC = 1, NUMREC

            SRCVAL(IREC,ISRC) = SNUMI * SRCVAL(IREC,ISRC)

 1000    CONTINUE
C        End Receptor LOOP
 2000 CONTINUE
C     End Source Group LOOP

      RETURN
      END

      SUBROUTINE SUMGRP
C***********************************************************************
C                 SUMGRP Module of ISC Model - Long Term
C
C        PURPOSE: Sums Source Group Values
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Source Group Array
C                 Array of CONC or DEPOS Values for One Season or Annual
C                 Period, SRCVAL(IREC,ISRC)
C
C        OUTPUTS: Array of Cumulative Source Group Values, GRPVAL(IREC,IGRP)
C
C        CALLED FROM:   LTMSA
C                       LTPER
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'

C     Variable Initializations
      MODNAM = 'SUMGRP'

C     Begin Source Group LOOP
      DO 1000 IGRP = 1, NUMGRP
C        Begin Source LOOP
         DO 300 ISRC = 1, NUMSRC
            IF (IGROUP(ISRC,IGRP) .EQ. 1) THEN
C              SCRID(Src) Belongs to GRPID
C              Begin Receptor LOOP
               DO 500 IREC = 1, NUMREC

                  GRPVAL(IREC,IGRP) = GRPVAL(IREC,IGRP) +
     &                                SRCVAL(IREC,ISRC)

 500           CONTINUE
C              End Receptor LOOP
            END IF
 300     CONTINUE
C        End Source LOOP
 1000 CONTINUE
C     End Source Group LOOP

      RETURN
      END

      SUBROUTINE LTSORT
C***********************************************************************
C                 LTSORT Module of ISC Model - Long Term
C
C        PURPOSE: Sorts Long Term Value Arrays
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Maximum Value Option Switches
C                 Array of CONC or DEPOS Averages
C
C        OUTPUTS: Maximum Value Arrays
C
C        CALLED FROM:   LTMSA
C                       LTPER
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'

C     Variable Initializations
      MODNAM = 'LTSORT'

      IF (MINDSC) THEN
C        Sort Individual Source Maximum Values              ---   CALL ISSORT
         CALL ISSORT
      END IF
      IF (MSCGRP) THEN
C        Sort Source Group Array for Maximum Values         ---   CALL SGSORT
         CALL SGSORT
      ENDIF
      IF (SOCONT) THEN
         IF (.NOT. MSCGRP) THEN
C           Sort Source Group Array for Maximum Values      ---   CALL SGSORT
            CALL SGSORT
         ENDIF
C        Select Source Contribution Maximum Values          ---   CALL SCSORT
         CALL SCSORT
      END IF

      RETURN
      END

      SUBROUTINE ISSORT
C***********************************************************************
C                 ISSORT Module of ISC Model - Long Term
C
C        PURPOSE: Sort Individual Source Values to Obtain Maximum Value Arrays
C                 Independent of Source Group Maxima
C                 NMAX = 50 Assigned in PARAMETER Statement
C                 Note: For duplicate values, the earlier occurrence keeps its
C                       rank within the array
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Maximum Value Table Options
C                 Array of CONC or DEPOS Averages
C
C        OUTPUTS: Maximum Value Array
C                 Maximum Receptor Array
C
C        CALLED FROM:   LTSORT
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'

C     Variable Initializations
      MODNAM = 'ISSORT'

C     Begin Source Group LOOP
      DO 2000 ISRC = 1, NUMSRC
C        Begin Receptor LOOP
         DO 1000 IREC = 1, NUMREC
            IF (NUMMAX .GT. 1) THEN
               IF (SRCVAL(IREC,ISRC) .GT. SRCMAX(NUMMAX,ISRC)) THEN
                  DO 100 J = NUMMAX-1, 1, -1
                     IF(SRCVAL(IREC,ISRC) .LE. SRCMAX(J,ISRC)) THEN
                        SRCMAX(J+1,ISRC) = SRCVAL(IREC,ISRC)
                        ISMLOC(J+1,ISRC) = IREC
C                       Exit Block
                        GO TO 200
                     ELSE
                        SRCMAX(J+1,ISRC) = SRCMAX(J,ISRC)
                        ISMLOC(J+1,ISRC) = ISMLOC(J,ISRC)
                        IF (J .EQ. 1) THEN
                           SRCMAX(1,ISRC) = SRCVAL(IREC,ISRC)
                           ISMLOC(1,ISRC) = IREC
                        END IF
                     END IF
 100              CONTINUE
               END IF
            ELSE IF (NUMMAX .EQ. 1) THEN
               IF (SRCVAL(IREC,ISRC) .GT. SRCMAX(1,ISRC)) THEN
                  SRCMAX(1,ISRC) = SRCVAL(IREC,ISRC)
                  ISMLOC(1,ISRC) = IREC
               END IF
            END IF

 200        CONTINUE

 1000    CONTINUE
C        End Receptor LOOP
 2000 CONTINUE
C     End Source LOOP

      RETURN
      END

      SUBROUTINE SGSORT
C***********************************************************************
C                 SGSORT Module of ISC Model - Long Term
C
C        PURPOSE: Sort Source Group Values to Obtain Maximum Value Arrays
C                 NMAX = 50 Assigned in PARAMETER Statement
C                 Note: For duplicate values, the earlier occurrence keeps its
C                       rank within the array
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Maximum Value Table Options
C                 Array of CONC or DEPOS Averages
C
C        OUTPUTS: Maximum Value Array
C                 Maximum Receptor Array
C
C        CALLED FROM:   LTSORT
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'

C     Variable Initializations
      MODNAM = 'SGSORT'

C     Begin Source Group LOOP
      DO 1000 IGRP = 1, NUMGRP
C        Begin Receptor LOOP
         DO 500 IREC = 1, NUMREC
            IF (NUMMAX .GT. 1) THEN
               IF (GRPVAL(IREC,IGRP) .GT. GRPMAX(NUMMAX,IGRP)) THEN
                  DO 100 J = NUMMAX-1, 1, -1
                     IF(GRPVAL(IREC,IGRP) .LE. GRPMAX(J,IGRP)) THEN
                        GRPMAX(J+1,IGRP) = GRPVAL(IREC,IGRP)
                        IGMLOC(J+1,IGRP) = IREC
C                       Exit Block
                        GO TO 200
                     ELSE
                        GRPMAX(J+1,IGRP) = GRPMAX(J,IGRP)
                        IGMLOC(J+1,IGRP) = IGMLOC(J,IGRP)
                        IF (J .EQ. 1) THEN
                           GRPMAX(1,IGRP) = GRPVAL(IREC,IGRP)
                           IGMLOC(1,IGRP) = IREC
                        END IF
                     END IF
 100              CONTINUE
               END IF
            ELSE IF (NUMMAX .EQ. 1) THEN
               IF (GRPVAL(IREC,IGRP) .GT. GRPMAX(1,IGRP)) THEN
                  GRPMAX(1,IGRP) = GRPVAL(IREC,IGRP)
                  IGMLOC(1,IGRP) = IREC
               END IF
            END IF

 200        CONTINUE

 500     CONTINUE
C        End Receptor LOOP
 1000 CONTINUE
C     End Source Group LOOP

      RETURN
      END

      SUBROUTINE SCSORT
C***********************************************************************
C                 SCSORT Module of ISC Model - Long Term
C
C        PURPOSE: Select Individual Source Contribution Values For
C                 Receptor Locations of Source Group Maximum Values,
C                 Uses an Assumed Size Array of 20000 Words (80K),
C                 Which Places a Limit on NUMSRC*NUMGRP*NUMMAX of 20000,
C                 e.g. 100 sources, 10 source groups, 20 maximum values
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Maximum Value Table Options
C                 Array of CONC or DEPOS Averages
C
C        OUTPUTS: Maximum Value Array
C                 Maximum Receptor Array
C
C        CALLED FROM:   LTSORT
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'

C     Variable Initializations
      MODNAM = 'SCSORT'

C     Begin Source Group LOOP
      DO 1000 IGRP = 1, NUMGRP
C        Begin Source LOOP
         DO 300 ISRC = 1, NUMSRC
C           In Case Of(SCRID(Src) Belongs to GRPID) THEN
            IF (IGROUP(ISRC,IGRP) .EQ. 1) THEN
               DO 100 J = 1, NUMMAX
                  IMREC = IGMLOC(J,IGRP)
                  IF (IMREC .EQ. 0) THEN
                     SRCONT(J,ISRC,IGRP) = 0.
                  ELSE
                     SRCONT(J,ISRC,IGRP) = SRCVAL(IMREC,ISRC)
                  END IF
100            CONTINUE
            END IF
 300     CONTINUE
C        End Source LOOP
 1000 CONTINUE
C     End Source Group LOOP

      RETURN
      END
