C***********************************************************************
C     MAIN1LT.INC
C     ISCLT2 Model Data - Array Names, Array Limits, Named Common Blocks
C                         Global Data for All Modules - Long Term Model
C
C     MODIFIED - 02/15/93  For Revised Deposition Routines
C     MODIFIED - 11/04/93  To remove dimensioning for AVEEL and AVEUSTAR
C                          in COMMON /METER2/, and IAVEEL and IAVEUSTR
C                          in COMMON /METER3/
C     MODIFIED - 7/19/94   For OPENPIT Algorithms (JAH/PES)
C     MODIFIED - 7/27/94   Added Variable for 10m Reference Wind Speed
C***********************************************************************


C***********************************************************************
C     User Specified Model Parameters for Array Dimensions
C***********************************************************************

C     The following commented line provides the array limits for the
C     Microsoft executable file.
CMICRO      PARAMETER (NSRC= 50, NREC= 500, NGRP= 5, NAVE= 17, NMAX=10,
      PARAMETER (NSRC= 300, NREC= 1200, NGRP= 5, NAVE= 17, NMAX=10,
     &           NQF= 36, NPDMAX= 20, IXM=50, IYM=50, NNET=5,
     &           NWS= 6, NSEC=16, NKST= 6, NSEAS= 4)

C**   NSRC   = Max Number of Sources
C**   NREC   = Max Number of Receptors
C**   NGRP   = Max Number of Source Groups
C**   NAVE   = Max Number of Averaging Periods (STARs)
C**            Set = 17 (for 12 Months + 4 Seasons (or Quarters) + 1 Annual)
C**   NMAX   = Max Number of Overall Maximum Values (MAXTABLE Keyword)
C**   NSEC   = Number of Sectors for Building Dimensions
C**   NQF    = Number of Variable Emission Rate Factors Per Source
C**   NPDMAX = Max Number of Settling Velocity Categories Per Source
C**   IXM    = Max Number of X-coord (Distance) Values Per Receptor Network
C**   IYM    = Max Number of Y-coord (Direction) Values Per Receptor Network
C**   NNET   = Max Number of Cartesian and/or Polar Receptor Networks

C***********************************************************************
C     Model Constants Specified as Parameters
C***********************************************************************

      PARAMETER (PI = 3.141593, TWOPI = 6.283185, RTOFPI = 1.772454,
     &           SRT2PI = 2.506628, BETA = 0.6,  G = 9.80616,
     &           DTORAD = 0.017453293,  RTODEG = 57.29578, VK = 0.4,
     &           CP = 1004., PRESMB = 1013., ELMIN = 2., ANEM = 10.,    DTB94063
     &           RTPIBY2 = 1.2533141)     

C**   PI     = PI
C**   TWOPI  = 2.*PI
C**   RTOFPI = SQRT(PI)
C**   SRT2PI = SQRT(2.*PI)
C**   BETA   = Entrainment Coefficient for BLP Rise
C**   G      = Acceleration Due to Gravity (m/s**2)
C**   DTORAD = Degrees to Radians Conversion Factor
C**   RTODEG = Radians to Degrees Conversion Factor
C**   VK     = von-Karman Constant


C***********************************************************************
C     Programmer Specified Model Parameters
C***********************************************************************

      PARAMETER (IFMAX=40, IPN=7, IKN=47, ISTRG=132, IERRN=110)

C**   IFMAX  = Max Number of Fields Per Runstream Record
C**   IPN    = Number of Pathway IDs (Includes '**')
C**   IKN    = Number of Keywords
C**   ISTRG  = Length of Runstream Image Record
C**   IERRN  = Number of Error/Warning/Informational Messages


C***********************************************************************
C     Common Block for Input/Output File Units (Initialized in BLOCK DATA)
C***********************************************************************

      COMMON /FUNITS/ INUNIT, IOUNIT, MFUNIT, IERUNT, IERWRT,
     &                IZUNIT

C**   INUNIT = Input Runstream File Unit (Initialized to 5)
C**   IOUNIT = Main Printed Output File Unit (Initialized to 6)
C**   MFUNIT = Input Meteorological Data File Unit (Initialized to 19)
C**   IERUNT = Temporary Error/Message File Unit (Initialized to 10)
C**   IERWRT = Permanent Detailed Error/Message File Unit (Init. to 11)
C**   IZUNIT = Gridded Terrain File Used (Initialized to 13)


C***********************************************************************
C     This is The Global Variable Definition Block for Runstream Data
C***********************************************************************

      LOGICAL BLINE, INFLD, MARK, ECHO, SORT

      CHARACTER PATH*2, PPATH*2, KEYWRD*8, PKEYWD*8, KEYWD*8, KTYPE*5,
     &          FIELD*40, RUNST*1, RUNST1*132, INPFIL*40, OUTFIL*40

      COMMON /FIELDS/ LOCB(IFMAX), LOCE(IFMAX), IFC, IDC1, IPNUM, IPPNUM
      COMMON /FLDCHR/ FIELD(IFMAX)
      COMMON /LOGIN1/ BLINE, INFLD, MARK, ECHO, SORT
      COMMON /SETCHR/ PATH, KEYWRD, PPATH, PKEYWD, KTYPE, KEYWD(IKN)
      COMMON /RUNSTR/ RUNST(ISTRG), RUNST1
      COMMON /FILCHR/ INPFIL, OUTFIL


C***********************************************************************
C     This is The Global Variable Definition Block for Error Handling
C***********************************************************************

      LOGICAL FATAL, ISTART, IFINIS, RECERR, ERRLST, EOF

      CHARACTER ERRMSG*50, ERRCOD*3, MSGFIL*40, VERSN*5

      COMMON /ERRLOG/ FATAL, ISTART, IFINIS, RECERR, ERRLST, EOF
      COMMON /ERRCHR/ ERRMSG(IERRN), ERRCOD(IERRN), MSGFIL, VERSN
      COMMON /ERRQA1/ ILINE, IERROR, IFTL, IWRN, INFO,
     &                ICLM, NFATAL, IPAGE
      COMMON /ERRQA2/ EXPLIM
      COMMON /INSTAT/ ICSTAT(20), ISSTAT(20), IRSTAT(20), IMSTAT(20),
     &                IOSTAT(20), ITSTAT(20)
      COMMON /REERR1/ INCSET, IXYSET, IEVSET, IFGSET


C***********************************************************************
C     This is The Global Variable Definition Block for COntrol Pathway
C***********************************************************************

      LOGICAL DFAULT, CONC, DEPOS, RURAL, URBAN, GRDRIS, NOSTD, NOBID,
     &        PERIOD, MONTH, SEASON, ANNUAL, QUARTR, FLAT, ELEV, FLGPOL,
     &        RUN, PLFILE, ANPLOT, STATOK, DEBUG, FSTREC,
     &        MONDAT, SEADAT, ANNDAT, QUADAT,
     &        TXFILE, ANTOXX, DDPLETE

      CHARACTER ELTYPE*6, TITLE1*68, TITLE2*68, AVEPER*6, CHIDEP*4,
     &          MODOPS*6,
     &          SOELEV*6, REELEV*6, TGELEV*6

      COMMON /CNTINT/ KAVE(NAVE), KSTAR(NAVE), NHIVAL, NMXVAL, NDUMP
      COMMON /CNTLOG/ DFAULT, CONC, DEPOS, RURAL, URBAN, GRDRIS, NOSTD,
     &                NOBID, PERIOD, MONTH, SEASON, ANNUAL, QUARTR,
     &                FLAT, ELEV, FLGPOL, RUN, PLFILE, ANPLOT, STATOK,
     &                DEBUG, FSTREC, MONDAT, SEADAT, ANNDAT, QUADAT,
     &                TXFILE, ANTOXX, DDPLETE
      COMMON /CNTCHR/ ELTYPE, TITLE1, TITLE2, AVEPER(NAVE), CHIDEP(6),
     &                MODOPS(12),
     &                SOELEV, REELEV, TGELEV


C***********************************************************************
C     This is The Global Variable Definition Block for SOurce Pathway
C     MODIFIED - 8/24/94   Changed SRCTYP*6 to SRCTYP*8 - JAH/PES
C***********************************************************************

      CHARACTER SRCID*8, SRCTYP*8, SOPCRD*1, GRPID*8, EMILBL*40,
     &          OUTLBL*40, POLLUT*8, PSOID*8, QFLAG*6
      LOGICAL LDPART,LWPART,LWGAS
      LOGICAL LDEP

      COMMON /SOURC1/ AXS(NSRC), AYS(NSRC), AZS(NSRC), AQS(NSRC),
     &                AHS(NSRC), ATS(NSRC), AVS(NSRC), ADS(NSRC),
CTESTA     &                ASYINI(NSRC), ASZINI(NSRC), AXINIT(NSRC)
     &                ASYINI(NSRC), ASZINI(NSRC)
      COMMON /SOURC2/ ADSBH(NSEC,NSRC), ADSBW(NSEC,NSRC),
     &                IDSWAK(NSEC,NSRC)
      COMMON /SOURC3/ QFACT(NQF,NSRC)
      COMMON /SOURC4/ EMIFAC, HAFLIF, DECOEF, INPD(NSRC), LDEP,
     &                LDPART, LWPART, LWGAS,
     &                APDIAM(NPDMAX,NSRC), APHI(NPDMAX,NSRC),
     &                APDENS(NPDMAX,NSRC), ASC(NPDMAX,NSRC),
     &                AVGRAV(NPDMAX,NSRC), ATSTOP(NPDMAX,NSRC),
     &                VAIRMS, ZRDEP, VDPHOR
      COMMON /SORGRP/ IGROUP(NSRC,NGRP)
      COMMON /SORCHR/ SRCID(NSRC), SRCTYP(NSRC), SOPCRD(NSRC),
     &                GRPID(NGRP), QFLAG(NSRC), EMILBL, OUTLBL, POLLUT,
     &                PSOID


C***********************************************************************
C     This is The Global Variable Definition Block for the New Area
C     Source Algorithm - 7/7/93
C*    Added XVERT,YVERT - Jayant Hardikar, PES, 7/20/94
C***********************************************************************

      PARAMETER (K1 = 5, JMAX1 =10, IMAX1 =10, ITMAX =100, EPS = 1.0E-4,
     &           EPS2 = 1.0E-10, NVMAX = 6, NVMAX2 = 12)

C**   K1    = Order of Extrapolating Polynomial
C**   JMAX1 = Maximum Number of Iterations in Halving Interval for Area
C**   IMAX1 = Maximum Number of Iterations in Halving Interval for Sector
C**   ITMAX = Maximum Number of Integral Iterations
C**   EPS   = Tolerance Limit for Convergence of the Integral
C**   EPS2  = Lower Threshold Limit for the Value of the Integral
C**   NVMAX = Maximum Number of Vertices in a Single Area Source + 2
C**   NVMAX2= NVMAX * 2

      LOGICAL LSEG

      COMMON /VERTEX/ IVERT, NVERT, UVERT(NVMAX), VVERT(NVMAX),
     &                VNVERT(NVMAX), WVERT(NVMAX)
      COMMON /SEGTBL/ NSEGS, UASEGS(NVMAX), UBSEGS(NVMAX)
      COMMON /BSIDE1/ LSEG
      COMMON /BSIDE2/ SPA(NVMAX,2)
      COMMON /SRAREA/ AXINIT(NSRC), AYINIT(NSRC), AANGLE(NSRC),
     &                AXVERT(NVMAX,NSRC), AYVERT(NVMAX,NSRC),
     &                XVERT(NVMAX), YVERT(NVMAX)


C***********************************************************************
C     This is The Global Variable Definition Block for the New OPENPIT
C     Source Algorithm - 8/18/94
C***********************************************************************

      PARAMETER (ALPHA = 0.029)
      REAL AALPHA(NSRC), APDEFF(NSRC), AVOLUM(NSRC)
      REAL EFRAC(NPDMAX), QPART(NPDMAX)
      REAL PALPHA, THETA, PDEFF, PDREL, PITFRA, QEFF
      REAL PITLEN, PITWID, PITL, EMIHGT


C*    ALPHA     = Proportionality Constant for determining Escape Fraction
C*    AALPHA    = Array of Angles of Long Pit Dimension w.r.t. 
C*                North for Each Source
C*    PALPHA    = Angle of Long Pit Dimension w.r.t. North for
C*                the Current Source
C*    THETA     = Wind Direction angle w.r.t Long Axis
C*                of the Pit
C*    APDEFF    = Array of Effective Pit Depths for Each Source
C*    PDEFF     = Effective Pit Depths for Current Source
C*    PDREL     = Relative Pit Depth
C*    AVOLUM    = Array of Volume of the OPENPIT Sources
C*    EFRAC     = Array of Escape Fractions
C*    QPART     = Array of Adjusted Emission Rates 
C*    PITFRA    = Fractional Size of the Effective Pit Area
C*    PITLEN    = Length of the Pit
C*    PITWID    = Width of the Pit
C*    PITL      = Along-Wind Length of the Pit
C*    EMIHGT    = Height of Emissions Above Base of Pit

      COMMON /PITSRC/ AALPHA, APDEFF, AVOLUM, EFRAC, QPART,
     &        PALPHA, THETA, PDEFF, PDREL, PITFRA, QEFF,
     &        PITLEN, PITWID, PITL, EMIHGT

      
      
C***********************************************************************
C     This is The Global Variable Definition Block for REceptor Pathway
C***********************************************************************

      LOGICAL ISTA, IEND, NEWID

      CHARACTER NETID*8, NETIDT*8, PNETID*8, NTID*8, NTTYP*8,
     &          RECTYP*2, PXSOID*8, PESOID*8

      COMMON /RECEPT/ AXR(NREC), AYR(NREC), AZELEV(NREC),
     &                AZFLAG(NREC), IREF(NREC)
      COMMON /RECLOG/ ISTA, IEND, NEWID
      COMMON /RECCHR/ NETID(NREC), RECTYP(NREC), NTID(NNET),
     &                NTTYP(NNET), PXSOID, PESOID, NETIDT, PNETID
      COMMON /COORD1/ ICOUNT, JCOUNT, IZE, IZF, IRZE, IRZF, IRXR, IRYR,
     &                IBND, IBELEV, INNET, XINT, YINT
      COMMON /COORD2/ XCOORD(IXM,NNET), YCOORD(IYM,NNET),
     &                NETSTA(NNET), NETEND(NNET),
     &                NUMXPT(NNET), NUMYPT(NNET),
     &                XORIG(NNET), YORIG(NNET)
      COMMON /COORD3/ ZETMP1(NREC), ZFTMP1(NREC),
     &                ZETMP2(NREC), ZFTMP2(NREC)


C***********************************************************************
C     This is The Global Variable Definition Block for MEteorology Pathway
C*    Added UREF10 - Jayant Hardikar, PES, 7/20/94
C***********************************************************************

      CHARACTER METFRM*60, METINP*40, SFNAME*40, UANAME*40

      COMMON /METER1/ ISDATE, IEDATE, ISYEAR, IUYEAR, IDSURF, IDUAIR,
     &                ZREF, ROTANG, ISJDAY, IEJDAY
      COMMON /METER2/ AVESP(NWS), PUSER(NKST,NWS), DTUSER(NKST,NWS),
     &                PURB(NKST), PRUR(NKST), DTURB(NKST), DTRUR(NKST),
     &                AVETA(NAVE,NKST), AVEZI(NAVE,NKST,NWS),
     &                NUMHRS(NAVE), AVEZ0M(NAVE), UREF10
      COMMON /METER3/ IAVETA(NAVE), IAVEZI(NAVE), IAVEZ0M(NAVE)
      COMMON /METCHR/ METFRM, METINP, SFNAME, UANAME


C***********************************************************************
C     This is The Global Variable Definition Block for METEXT
C***********************************************************************

      LOGICAL UNSTAB, NEUTRL, STABLE,
     &        NEWMET, RUNERR, USERP, USERDT

      COMMON /METLOG/ UNSTAB, NEUTRL, STABLE,
     &                NEWMET, RUNERR, USERP, USERDT
      COMMON /METVAR/ AFV, UREF, TA, KST, ZI, S, RTOFS,
     &                USTAR, EL, Z0M, RHO                               DTB94063
      COMMON /METFRQ/ FREQ(NWS,NSEC,NKST), FTOTAL


C***********************************************************************
C     This is The Global Variable Definition Block for Terrain Grid Pathway
C***********************************************************************

      CHARACTER TERINP*40
      LOGICAL LTGRID

      COMMON /TG/ TGX0, TGY0, GRDXLL, GRDXUR, GRDYLL, GRDYUR, XYINT,
     &            LTGRID
      COMMON /TGCHR/  TERINP


C***********************************************************************
C     This is The Global Variable Definition Block for Calculation
C***********************************************************************

      LOGICAL CALCS, WAKE, WAKESS, WAKLOW, BUOYNT, TALL, SQUAT, SSQUAT

      COMMON /INDEXS/ IREC,   ISRC,   IGRP,   IAVE,   ISET,
     &                NUMREC, NUMSRC, NUMGRP, NUMAVE, IWS, ISEC,
     &                ISEA, IQUA, NUMMAX, IKST, NUMSTR
      COMMON /CALCS1/ XS, YS, ZS, QS, HS, DS, VS, TS, SYINIT,
     &                SZINIT, XINIT, YINIT, ANGLE, DSBH, DSBW, DELTHP,
     &                IFVSEC, D, V, VD, E, WDRAD, WDSIN, WDCOS
      COMMON /CALCS2/ CALCS, WAKE, WAKESS, WAKLOW, BUOYNT, TALL,
     &                SQUAT, SSQUAT
      COMMON /CALCS3/ NPD, PDIAM(NPDMAX), PHI(NPDMAX), PDENS(NPDMAX),
     &                SC(NPDMAX), VGRAV(NPDMAX), TSTOP(NPDMAX),
     &                VDEP(NPDMAX), DQCOR(NPDMAX), PCORZR(NPDMAX),
     &                PCORZD(NPDMAX), SZCOR(NPDMAX), SZMIN(NPDMAX)
      COMMON /CALCS4/ XR, YR, X, Y, ZELEV, ZFLAG, DISTR
      COMMON /CALCS5/ HE, HSP, HEFLAT, HTER, HEMWAK, ZB, ZM, IUCAT,
     &                XY, XZ, SBID, FM, FB, DTDZ, DHF, DHP, DELT,
     &                DHPB, DHPM, XF, XFM, XFB, XRAD
      COMMON /CALCS6/ US, SY, SZ, DA, ZLY, ZLB, X3LB, RINIT,
     &                CB, CM, QTK, P, RPV, SM


C***********************************************************************
C     This is The Global Variable Definition Block for OUtput Pathway
C***********************************************************************

      CHARACTER PLTFIL*40, ANNPLT*40, PLTFRM*60, TOXFIL*40, ANNTOX*40
      LOGICAL RSCGRP, RINDSC, MSCGRP, MINDSC, SOCONT

      COMMON /OUTPT1/ RSCGRP, RINDSC, MSCGRP, MINDSC, SOCONT
      COMMON /OUTPT2/ IPLTFL(NGRP,NAVE), IPLUNT(NGRP,NAVE),
     &                IANPLT(NGRP), IPPUNT(NGRP),
     &                ITOXFL(NGRP,NAVE), ITXUNT(NGRP,NAVE),
     &                IANTOX(NGRP), IPXUNT(NGRP)
      COMMON /OUTCHR/ PLTFIL(NGRP,NAVE), ANNPLT(NGRP), PLTFRM,
     &                TOXFIL(NGRP,NAVE), ANNTOX(NGRP)
      COMMON /TOXWRK/ ITAB, NXTOX, NYTOX


C***********************************************************************
C     This is The Global Variable Definition Block for Working Space
C***********************************************************************

      CHARACTER WORKID*8, DUMMY*8

      COMMON /WRKCHR/ WORKID(NSRC), DUMMY
      COMMON /SRCWRK/ IWRK2(NSRC,7)


      SAVE
